/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSBufferedChangeEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSTimeRanges.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_SOURCE)

template<> ConversionResult<IDLDictionary<BufferedChangeEvent::Init>> convertDictionary<BufferedChangeEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    BufferedChangeEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue addedRangesValue;
    if (isNullOrUndefined)
        addedRangesValue = jsUndefined();
    else {
        addedRangesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addedRanges"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!addedRangesValue.isUndefined()) {
        auto addedRangesConversionResult = convert<IDLInterface<TimeRanges>>(lexicalGlobalObject, addedRangesValue);
        if (addedRangesConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.addedRanges = addedRangesConversionResult.releaseReturnValue();
    }
    JSValue removedRangesValue;
    if (isNullOrUndefined)
        removedRangesValue = jsUndefined();
    else {
        removedRangesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "removedRanges"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!removedRangesValue.isUndefined()) {
        auto removedRangesConversionResult = convert<IDLInterface<TimeRanges>>(lexicalGlobalObject, removedRangesValue);
        if (removedRangesConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.removedRanges = removedRangesConversionResult.releaseReturnValue();
    }
    return result;
}

#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBufferedChangeEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsBufferedChangeEvent_addedRanges);
static JSC_DECLARE_CUSTOM_GETTER(jsBufferedChangeEvent_removedRanges);

class JSBufferedChangeEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBufferedChangeEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBufferedChangeEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSBufferedChangeEventPrototype>(vm)) JSBufferedChangeEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBufferedChangeEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBufferedChangeEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBufferedChangeEventPrototype, JSBufferedChangeEventPrototype::Base);

using JSBufferedChangeEventDOMConstructor = JSDOMConstructor<JSBufferedChangeEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSBufferedChangeEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSBufferedChangeEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<BufferedChangeEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = BufferedChangeEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<BufferedChangeEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<BufferedChangeEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSBufferedChangeEventDOMConstructorConstruct, JSBufferedChangeEventDOMConstructor::construct);

template<> const ClassInfo JSBufferedChangeEventDOMConstructor::s_info = { "BufferedChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBufferedChangeEventDOMConstructor) };

template<> JSValue JSBufferedChangeEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSBufferedChangeEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BufferedChangeEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBufferedChangeEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSBufferedChangeEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBufferedChangeEventConstructor, 0 } },
    HashTableValue { "addedRanges"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBufferedChangeEvent_addedRanges, 0 } },
    HashTableValue { "removedRanges"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBufferedChangeEvent_removedRanges, 0 } },
};

const ClassInfo JSBufferedChangeEventPrototype::s_info = { "BufferedChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBufferedChangeEventPrototype) };

void JSBufferedChangeEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBufferedChangeEvent::info(), JSBufferedChangeEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBufferedChangeEvent::s_info = { "BufferedChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBufferedChangeEvent) };

JSBufferedChangeEvent::JSBufferedChangeEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BufferedChangeEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<BufferedChangeEvent> JSBufferedChangeEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, BufferedChangeEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSBufferedChangeEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBufferedChangeEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSBufferedChangeEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBufferedChangeEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBufferedChangeEvent>(vm, globalObject);
}

JSValue JSBufferedChangeEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBufferedChangeEventDOMConstructor, DOMConstructorID::BufferedChangeEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBufferedChangeEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBufferedChangeEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBufferedChangeEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsBufferedChangeEvent_addedRangesGetter(JSGlobalObject& lexicalGlobalObject, JSBufferedChangeEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.addedRanges())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBufferedChangeEvent_addedRanges, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBufferedChangeEvent>::get<jsBufferedChangeEvent_addedRangesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBufferedChangeEvent_removedRangesGetter(JSGlobalObject& lexicalGlobalObject, JSBufferedChangeEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.removedRanges())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBufferedChangeEvent_removedRanges, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBufferedChangeEvent>::get<jsBufferedChangeEvent_removedRangesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSBufferedChangeEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBufferedChangeEvent, UseCustomHeapCellType::No>(vm, "JSBufferedChangeEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBufferedChangeEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBufferedChangeEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBufferedChangeEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBufferedChangeEvent = std::forward<decltype(space)>(space); }
    );
}

void JSBufferedChangeEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBufferedChangeEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BufferedChangeEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19BufferedChangeEventE[]; }
#endif
template<std::same_as<BufferedChangeEvent> T>
static inline void verifyVTable(BufferedChangeEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7BufferedChangeEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19BufferedChangeEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // BufferedChangeEvent has subclasses. If BufferedChangeEvent has subclasses that get passed
        // to toJS() we currently require BufferedChangeEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<BufferedChangeEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<BufferedChangeEvent>(impl.ptr());
#endif
    return createWrapper<BufferedChangeEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, BufferedChangeEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(MEDIA_SOURCE)
