/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// AzureDiskVolumeSourceApplyConfiguration represents a declarative configuration of the AzureDiskVolumeSource type for use
// with apply.
//
// AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
type AzureDiskVolumeSourceApplyConfiguration struct {
	// diskName is the Name of the data disk in the blob storage
	DiskName *string `json:"diskName,omitempty"`
	// diskURI is the URI of data disk in the blob storage
	DataDiskURI *string `json:"diskURI,omitempty"`
	// cachingMode is the Host Caching mode: None, Read Only, Read Write.
	CachingMode *corev1.AzureDataDiskCachingMode `json:"cachingMode,omitempty"`
	// fsType is Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	FSType *string `json:"fsType,omitempty"`
	// readOnly Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
	Kind *corev1.AzureDataDiskKind `json:"kind,omitempty"`
}

// AzureDiskVolumeSourceApplyConfiguration constructs a declarative configuration of the AzureDiskVolumeSource type for use with
// apply.
func AzureDiskVolumeSource() *AzureDiskVolumeSourceApplyConfiguration {
	return &AzureDiskVolumeSourceApplyConfiguration{}
}

// WithDiskName sets the DiskName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DiskName field is set to the value of the last call.
func (b *AzureDiskVolumeSourceApplyConfiguration) WithDiskName(value string) *AzureDiskVolumeSourceApplyConfiguration {
	b.DiskName = &value
	return b
}

// WithDataDiskURI sets the DataDiskURI field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DataDiskURI field is set to the value of the last call.
func (b *AzureDiskVolumeSourceApplyConfiguration) WithDataDiskURI(value string) *AzureDiskVolumeSourceApplyConfiguration {
	b.DataDiskURI = &value
	return b
}

// WithCachingMode sets the CachingMode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CachingMode field is set to the value of the last call.
func (b *AzureDiskVolumeSourceApplyConfiguration) WithCachingMode(value corev1.AzureDataDiskCachingMode) *AzureDiskVolumeSourceApplyConfiguration {
	b.CachingMode = &value
	return b
}

// WithFSType sets the FSType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FSType field is set to the value of the last call.
func (b *AzureDiskVolumeSourceApplyConfiguration) WithFSType(value string) *AzureDiskVolumeSourceApplyConfiguration {
	b.FSType = &value
	return b
}

// WithReadOnly sets the ReadOnly field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReadOnly field is set to the value of the last call.
func (b *AzureDiskVolumeSourceApplyConfiguration) WithReadOnly(value bool) *AzureDiskVolumeSourceApplyConfiguration {
	b.ReadOnly = &value
	return b
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *AzureDiskVolumeSourceApplyConfiguration) WithKind(value corev1.AzureDataDiskKind) *AzureDiskVolumeSourceApplyConfiguration {
	b.Kind = &value
	return b
}
