/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSWebTransportCongestionControl.h"
#include "JSWebTransportHash.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebTransportOptions>> convertDictionary<WebTransportOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebTransportOptions result;
    JSValue allowPoolingValue;
    if (isNullOrUndefined)
        allowPoolingValue = jsUndefined();
    else {
        allowPoolingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "allowPooling"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto allowPoolingConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, allowPoolingValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (allowPoolingConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.allowPooling = allowPoolingConversionResult.releaseReturnValue();
    JSValue congestionControlValue;
    if (isNullOrUndefined)
        congestionControlValue = jsUndefined();
    else {
        congestionControlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "congestionControl"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto congestionControlConversionResult = convertOptionalWithDefault<IDLEnumeration<WebTransportCongestionControl>>(lexicalGlobalObject, congestionControlValue, [&]() -> ConversionResult<IDLEnumeration<WebTransportCongestionControl>> { return Converter<IDLEnumeration<WebTransportCongestionControl>>::ReturnType { WebTransportCongestionControl::Default }; });
    if (congestionControlConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.congestionControl = congestionControlConversionResult.releaseReturnValue();
    JSValue requireUnreliableValue;
    if (isNullOrUndefined)
        requireUnreliableValue = jsUndefined();
    else {
        requireUnreliableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requireUnreliable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto requireUnreliableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, requireUnreliableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (requireUnreliableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.requireUnreliable = requireUnreliableConversionResult.releaseReturnValue();
    JSValue serverCertificateHashesValue;
    if (isNullOrUndefined)
        serverCertificateHashesValue = jsUndefined();
    else {
        serverCertificateHashesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "serverCertificateHashes"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!serverCertificateHashesValue.isUndefined()) {
        auto serverCertificateHashesConversionResult = convert<IDLSequence<IDLDictionary<WebTransportHash>>>(lexicalGlobalObject, serverCertificateHashesValue);
        if (serverCertificateHashesConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.serverCertificateHashes = serverCertificateHashesConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

