//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/dependenciesSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdDependenciesSchemaTokens,
    HD_DEPENDENCIES_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

HdDependenciesSchema::EntryVector
HdDependenciesSchema::GetEntries()
{
    EntryVector result;
    if (!_container) {
        return result;
    }

    TfTokenVector childNames = _container->GetNames();
    for (const TfToken & childName : childNames) {
        if (HdContainerDataSourceHandle child =
                HdContainerDataSource::Cast(_container->Get(childName))) {
            result.push_back(EntryPair(
                    childName, HdDependencySchema(child)));
        }
    }

    return result;
}

// --(END CUSTOM CODE: Schema Methods)--

/*static*/
HdContainerDataSourceHandle
HdDependenciesSchema::BuildRetained(
    const size_t count,
    const TfToken * const names,
    const HdDataSourceBaseHandle * const values)
{
    return HdRetainedContainerDataSource::New(count, names, values);
}

/*static*/
HdDependenciesSchema
HdDependenciesSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdDependenciesSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdDependenciesSchemaTokens->__dependencies))
        : nullptr);
}

/*static*/
const TfToken &
HdDependenciesSchema::GetSchemaToken()
{
    return HdDependenciesSchemaTokens->__dependencies;
}

/*static*/
const HdDataSourceLocator &
HdDependenciesSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE