//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/comm/mailnews/compose/public/nsIMsgOutgoingServer.idl
//


/// `interface nsIMsgOutgoingListener : nsISupports`
///

/// ```text
/// /**
///  * A listener used by an instance of `nsIMsgOutgoingServer` to notify about the
///  * start and end of a message send operation.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIMsgOutgoingListener {
    vtable: &'static nsIMsgOutgoingListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIMsgOutgoingListener.
unsafe impl XpCom for nsIMsgOutgoingListener {
    const IID: nsIID = nsID(0x88842392, 0x765a, 0x44fc,
        [0xbe, 0x82, 0x46, 0x71, 0xbb, 0x18, 0x56, 0x50]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIMsgOutgoingListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIMsgOutgoingListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIMsgOutgoingListenerCoerce {
    /// Cheaply cast a value of this type from a `nsIMsgOutgoingListener`.
    fn coerce_from(v: &nsIMsgOutgoingListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIMsgOutgoingListenerCoerce for nsIMsgOutgoingListener {
    #[inline]
    fn coerce_from(v: &nsIMsgOutgoingListener) -> &Self {
        v
    }
}

impl nsIMsgOutgoingListener {
    /// Cast this `nsIMsgOutgoingListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIMsgOutgoingListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIMsgOutgoingListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIMsgOutgoingListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIMsgOutgoingListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIMsgOutgoingListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIMsgOutgoingListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onSendStart (in nsIRequest request); */
    pub OnSendStart: unsafe extern "system" fn (this: *const nsIMsgOutgoingListener, request: *const nsIRequest) -> ::nserror::nsresult,

    /* void onSendStop (in nsIURI serverURI, in nsresult exitCode, in nsITransportSecurityInfo secInfo, in AUTF8String errorMsg); */
    pub OnSendStop: unsafe extern "system" fn (this: *const nsIMsgOutgoingListener, serverURI: *const nsIURI, exitCode: nserror::nsresult, secInfo: *const nsITransportSecurityInfo, errorMsg: *const ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIMsgOutgoingListener {

    /// ```text
    /// /**
    ///      * Called when the message send operation starts, with a request that can be
    ///      * used to cancel the operation.
    ///      *
    ///      * @param request An `nsIRequest` instance that the consumer can use to
    ///      *                cancel the send if requested by the user.
    ///      */
    /// ```
    ///

    /// `void onSendStart (in nsIRequest request);`
    #[inline]
    pub unsafe fn OnSendStart(&self, request: *const nsIRequest) -> ::nserror::nsresult {
        ((*self.vtable).OnSendStart)(self, request)
    }


    /// ```text
    /// /**
    ///      * Called when the message send operation finishes.
    ///      *
    ///      * @param serverURI The URI of the server used to attempt sending the
    ///      *                  message.
    ///      * @param exitCode  The status code with which the send attempt finished.
    ///      * @param secInfo   Information relating to the security of the transport
    ///      *                  used to send the message. Ignored if the send did not
    ///      *                  conclude from a security error.
    ///      * @param errorMsg  A localized error message about the failure, to display
    ///      *                  for the user. Ignored if the send succeeded.
    ///      */
    /// ```
    ///

    /// `void onSendStop (in nsIURI serverURI, in nsresult exitCode, in nsITransportSecurityInfo secInfo, in AUTF8String errorMsg);`
    #[inline]
    pub unsafe fn OnSendStop(&self, serverURI: *const nsIURI, exitCode: nserror::nsresult, secInfo: *const nsITransportSecurityInfo, errorMsg: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).OnSendStop)(self, serverURI, exitCode, secInfo, errorMsg)
    }


}


/// `interface nsIMsgOutgoingServer : nsISupports`
///

/// ```text
/// /**
///  * This interface represents a single outgoing Server. An outgoing server
///  * instance may be created/obtained from nsIMsgOutgoingServerService.
///  *
///  * Most of the attributes will set/get preferences from the main preferences
///  * file.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIMsgOutgoingServer {
    vtable: &'static nsIMsgOutgoingServerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIMsgOutgoingServer.
unsafe impl XpCom for nsIMsgOutgoingServer {
    const IID: nsIID = nsID(0xa53dce6c, 0xcd81, 0x495c,
        [0x83, 0xbc, 0x45, 0xa6, 0x5d, 0xf1, 0xf0, 0x8e]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIMsgOutgoingServer {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIMsgOutgoingServer.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIMsgOutgoingServerCoerce {
    /// Cheaply cast a value of this type from a `nsIMsgOutgoingServer`.
    fn coerce_from(v: &nsIMsgOutgoingServer) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIMsgOutgoingServerCoerce for nsIMsgOutgoingServer {
    #[inline]
    fn coerce_from(v: &nsIMsgOutgoingServer) -> &Self {
        v
    }
}

impl nsIMsgOutgoingServer {
    /// Cast this `nsIMsgOutgoingServer` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIMsgOutgoingServerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIMsgOutgoingServer {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIMsgOutgoingServerCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIMsgOutgoingServer) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIMsgOutgoingServer
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIMsgOutgoingServerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* attribute AUTF8String key; */
    pub GetKey: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aKey: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String key; */
    pub SetKey: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aKey: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String UID; */
    pub GetUID: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aUID: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String UID; */
    pub SetUID: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aUID: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute AUTF8String type; */
    pub GetType: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aType: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String description; */
    pub GetDescription: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aDescription: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String description; */
    pub SetDescription: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aDescription: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String username; */
    pub GetUsername: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aUsername: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String username; */
    pub SetUsername: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aUsername: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String password; */
    pub GetPassword: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aPassword: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String password; */
    pub SetPassword: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aPassword: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute AUTF8String displayname; */
    pub GetDisplayname: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aDisplayname: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute nsMsgAuthMethodValue authMethod; */
    pub GetAuthMethod: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aAuthMethod: *mut nsMsgAuthMethodValue) -> ::nserror::nsresult,

    /* attribute nsMsgAuthMethodValue authMethod; */
    pub SetAuthMethod: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aAuthMethod: nsMsgAuthMethodValue) -> ::nserror::nsresult,

    /* attribute nsMsgSocketTypeValue socketType; */
    pub GetSocketType: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aSocketType: *mut nsMsgSocketTypeValue) -> ::nserror::nsresult,

    /* attribute nsMsgSocketTypeValue socketType; */
    pub SetSocketType: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aSocketType: nsMsgSocketTypeValue) -> ::nserror::nsresult,

    /* readonly attribute nsIURI serverURI; */
    pub GetServerURI: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aServerURI: *mut*const nsIURI) -> ::nserror::nsresult,

    /* attribute long maximumConnectionsNumber; */
    pub GetMaximumConnectionsNumber: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aMaximumConnectionsNumber: *mut i32) -> ::nserror::nsresult,

    /* attribute long maximumConnectionsNumber; */
    pub SetMaximumConnectionsNumber: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aMaximumConnectionsNumber: i32) -> ::nserror::nsresult,

    /* void sendMailMessage (in nsIFile aFilePath, in Array<msgIAddressObject> aVisibleRecipients, in Array<msgIAddressObject> aBccRecipients, in nsIMsgIdentity aSenderIdentity, in AUTF8String aSender, in AUTF8String aPassword, in nsIMsgStatusFeedback aStatusListener, in boolean aRequestDSN, in AUTF8String aMessageId, in nsIMsgOutgoingListener aListener); */
    pub SendMailMessage: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aFilePath: *const nsIFile, aVisibleRecipients: *const thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>, aBccRecipients: *const thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>, aSenderIdentity: *const nsIMsgIdentity, aSender: *const ::nsstring::nsACString, aPassword: *const ::nsstring::nsACString, aStatusListener: *const nsIMsgStatusFeedback, aRequestDSN: bool, aMessageId: *const ::nsstring::nsACString, aListener: *const nsIMsgOutgoingListener) -> ::nserror::nsresult,

    /* void closeCachedConnections (); */
    pub CloseCachedConnections: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer) -> ::nserror::nsresult,

    /* AUTF8String getPasswordWithUI (in AUTF8String promptString, in AUTF8String promptTitle); */
    pub GetPasswordWithUI: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, promptString: *const ::nsstring::nsACString, promptTitle: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void forgetPassword (); */
    pub ForgetPassword: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer) -> ::nserror::nsresult,

    /* nsIURI verifyLogon (in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
    pub VerifyLogon: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer, aUrlListener: *const nsIUrlListener, aMsgWindow: *const nsIMsgWindow, _retval: *mut*const nsIURI) -> ::nserror::nsresult,

    /* void clearAllValues (); */
    pub ClearAllValues: unsafe extern "system" fn (this: *const nsIMsgOutgoingServer) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIMsgOutgoingServer {


    /// `attribute AUTF8String key;`
    #[inline]
    pub unsafe fn GetKey(&self, aKey: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetKey)(self, aKey)
    }



    /// `attribute AUTF8String key;`
    #[inline]
    pub unsafe fn SetKey(&self, aKey: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetKey)(self, aKey)
    }


    /// ```text
    /// /**
    ///    * A unique identifier for this server that can be used for the same
    ///    * server synced across multiple profiles. Auto-generated on first use.
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String UID;`
    #[inline]
    pub unsafe fn GetUID(&self, aUID: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetUID)(self, aUID)
    }


    /// ```text
    /// /**
    ///    * A unique identifier for this server that can be used for the same
    ///    * server synced across multiple profiles. Auto-generated on first use.
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String UID;`
    #[inline]
    pub unsafe fn SetUID(&self, aUID: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetUID)(self, aUID)
    }



    /// `readonly attribute AUTF8String type;`
    #[inline]
    pub unsafe fn GetType(&self, aType: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetType)(self, aType)
    }



    /// `attribute AUTF8String description;`
    #[inline]
    pub unsafe fn GetDescription(&self, aDescription: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetDescription)(self, aDescription)
    }



    /// `attribute AUTF8String description;`
    #[inline]
    pub unsafe fn SetDescription(&self, aDescription: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetDescription)(self, aDescription)
    }


    /// ```text
    /// /**
    ///    * The username to access the server with (if required).
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String username;`
    #[inline]
    pub unsafe fn GetUsername(&self, aUsername: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetUsername)(self, aUsername)
    }


    /// ```text
    /// /**
    ///    * The username to access the server with (if required).
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String username;`
    #[inline]
    pub unsafe fn SetUsername(&self, aUsername: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetUsername)(self, aUsername)
    }


    /// ```text
    /// /**
    ///    * The password to access the server with (if required).
    ///    *
    ///    * @note this is stored within the server instance but not within preferences.
    ///    * It can be specified/saved here to avoid prompting the user constantly for
    ///    * the sending password.
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String password;`
    #[inline]
    pub unsafe fn GetPassword(&self, aPassword: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetPassword)(self, aPassword)
    }


    /// ```text
    /// /**
    ///    * The password to access the server with (if required).
    ///    *
    ///    * @note this is stored within the server instance but not within preferences.
    ///    * It can be specified/saved here to avoid prompting the user constantly for
    ///    * the sending password.
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String password;`
    #[inline]
    pub unsafe fn SetPassword(&self, aPassword: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetPassword)(self, aPassword)
    }



    /// `readonly attribute AUTF8String displayname;`
    #[inline]
    pub unsafe fn GetDisplayname(&self, aDisplayname: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetDisplayname)(self, aDisplayname)
    }


    /// ```text
    /// /**
    ///    * Authentication mechanism.
    ///    *
    ///    * @see nsMsgAuthMethod (in MailNewsTypes2.idl)
    ///    * For SMTP servers, this is the same as the "mail.smtpserver...authMethod"
    ///    * pref.
    ///    *
    ///    * Compatibility note: This attribute had a different meaning in TB < 3.1
    ///    */
    /// ```
    ///

    /// `attribute nsMsgAuthMethodValue authMethod;`
    #[inline]
    pub unsafe fn GetAuthMethod(&self, aAuthMethod: *mut nsMsgAuthMethodValue) -> ::nserror::nsresult {
        ((*self.vtable).GetAuthMethod)(self, aAuthMethod)
    }


    /// ```text
    /// /**
    ///    * Authentication mechanism.
    ///    *
    ///    * @see nsMsgAuthMethod (in MailNewsTypes2.idl)
    ///    * For SMTP servers, this is the same as the "mail.smtpserver...authMethod"
    ///    * pref.
    ///    *
    ///    * Compatibility note: This attribute had a different meaning in TB < 3.1
    ///    */
    /// ```
    ///

    /// `attribute nsMsgAuthMethodValue authMethod;`
    #[inline]
    pub unsafe fn SetAuthMethod(&self, aAuthMethod: nsMsgAuthMethodValue) -> ::nserror::nsresult {
        ((*self.vtable).SetAuthMethod)(self, aAuthMethod)
    }


    /// ```text
    /// /**
    ///    * Whether to SSL or STARTTLS or not
    ///    *
    ///    * @see nsMsgSocketType (in MailNewsTypes2.idl)
    ///    * For SMTP servers, this is the same as the "mail.smtpserver...try_ssl" pref.
    ///    */
    /// ```
    ///

    /// `attribute nsMsgSocketTypeValue socketType;`
    #[inline]
    pub unsafe fn GetSocketType(&self, aSocketType: *mut nsMsgSocketTypeValue) -> ::nserror::nsresult {
        ((*self.vtable).GetSocketType)(self, aSocketType)
    }


    /// ```text
    /// /**
    ///    * Whether to SSL or STARTTLS or not
    ///    *
    ///    * @see nsMsgSocketType (in MailNewsTypes2.idl)
    ///    * For SMTP servers, this is the same as the "mail.smtpserver...try_ssl" pref.
    ///    */
    /// ```
    ///

    /// `attribute nsMsgSocketTypeValue socketType;`
    #[inline]
    pub unsafe fn SetSocketType(&self, aSocketType: nsMsgSocketTypeValue) -> ::nserror::nsresult {
        ((*self.vtable).SetSocketType)(self, aSocketType)
    }


    /// ```text
    /// /**
    ///    * Returns the URI of the server.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIURI serverURI;`
    #[inline]
    pub unsafe fn GetServerURI(&self, aServerURI: *mut*const nsIURI) -> ::nserror::nsresult {
        ((*self.vtable).GetServerURI)(self, aServerURI)
    }


    /// ```text
    /// /**
    ///    * Limit of concurrent connections to a server.
    ///    */
    /// ```
    ///

    /// `attribute long maximumConnectionsNumber;`
    #[inline]
    pub unsafe fn GetMaximumConnectionsNumber(&self, aMaximumConnectionsNumber: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetMaximumConnectionsNumber)(self, aMaximumConnectionsNumber)
    }


    /// ```text
    /// /**
    ///    * Limit of concurrent connections to a server.
    ///    */
    /// ```
    ///

    /// `attribute long maximumConnectionsNumber;`
    #[inline]
    pub unsafe fn SetMaximumConnectionsNumber(&self, aMaximumConnectionsNumber: i32) -> ::nserror::nsresult {
        ((*self.vtable).SetMaximumConnectionsNumber)(self, aMaximumConnectionsNumber)
    }


    /// ```text
    /// /**
    ///    * Sends a mail message via the given parameters.
    ///
    ///    * @note The file to send must be in the format specified by RFC 2822 for
    ///    *       sending data. This includes having the correct CRLF line endings
    ///    *       throughout the file, and the <CRLF>.<CRLF> at the end of the file.
    ///    *       sendMailMessage does no processing/additions on the file.
    ///    *
    ///    * @note Some protocols require custom handling for Bcc recipients (since they
        ///    *       are excluded from the MIME content), so they are passed separately
    ///    *       from To and Cc recipients.
    ///    *
    ///    * @param aFilePath               The file to send.
    ///    * @param aVisibleRecipients      The visible recipients (i.e. To and Cc) for
    ///    *                                this message.
    ///    * @param aBccRecipients          The Bcc recipients for this message.
    ///    * @param aSenderIdentity         The identity of the sender.
    ///    * @param aSender                 The senders email address.
    ///    * @param aPassword               Pass this in to prevent a dialog if the
    ///    *                                password is needed for secure transmission.
    ///    * @param aStatusListener         A feedback listener for slightly different
    ///    *                                feedback on the message send status. This
    ///    *                                parameter may be null.
    ///    * @param aRequestDSN             Whether to request Delivery Status
    ///    *                                Notification.
    ///    * @param aMessageId              The message ID for this email message.
    ///    * @param aListener               A listener that can communicate the start
    ///    *                                and end of the message send operation. It
    ///    *                                also provides the consumer with a handle to
    ///    *                                cancel the operation if requested (see the
        ///    *                                documentation for `nsIMsgOutgoingListener`).
    ///    */
    /// ```
    ///

    /// `void sendMailMessage (in nsIFile aFilePath, in Array<msgIAddressObject> aVisibleRecipients, in Array<msgIAddressObject> aBccRecipients, in nsIMsgIdentity aSenderIdentity, in AUTF8String aSender, in AUTF8String aPassword, in nsIMsgStatusFeedback aStatusListener, in boolean aRequestDSN, in AUTF8String aMessageId, in nsIMsgOutgoingListener aListener);`
    #[inline]
    pub unsafe fn SendMailMessage(&self, aFilePath: *const nsIFile, aVisibleRecipients: *const thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>, aBccRecipients: *const thin_vec::ThinVec<Option<RefPtr<msgIAddressObject>>>, aSenderIdentity: *const nsIMsgIdentity, aSender: *const ::nsstring::nsACString, aPassword: *const ::nsstring::nsACString, aStatusListener: *const nsIMsgStatusFeedback, aRequestDSN: bool, aMessageId: *const ::nsstring::nsACString, aListener: *const nsIMsgOutgoingListener) -> ::nserror::nsresult {
        ((*self.vtable).SendMailMessage)(self, aFilePath, aVisibleRecipients, aBccRecipients, aSenderIdentity, aSender, aPassword, aStatusListener, aRequestDSN, aMessageId, aListener)
    }


    /// ```text
    /// /**
    ///    * Close cached server connections.
    ///    */
    /// ```
    ///

    /// `void closeCachedConnections ();`
    #[inline]
    pub unsafe fn CloseCachedConnections(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).CloseCachedConnections)(self, )
    }


    /// ```text
    /// /**
    ///    * Gets a password for this server, using a UI prompt if necessary.
    ///    *
    ///    * @param promptString  The string to prompt the user with when asking for
    ///    *                      the password.
    ///    * @param promptTitle   The title of the prompt.
    ///    * @return              The password to use (may be null if no password was
        ///    *                      obtained).
    ///    */
    /// ```
    ///

    /// `AUTF8String getPasswordWithUI (in AUTF8String promptString, in AUTF8String promptTitle);`
    #[inline]
    pub unsafe fn GetPasswordWithUI(&self, promptString: *const ::nsstring::nsACString, promptTitle: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetPasswordWithUI)(self, promptString, promptTitle, _retval)
    }


    /// ```text
    /// /**
    ///    * Calling this will *remove* the saved password for this server from the
    ///    * password manager and from the stored value.
    ///    */
    /// ```
    ///

    /// `void forgetPassword ();`
    #[inline]
    pub unsafe fn ForgetPassword(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).ForgetPassword)(self, )
    }


    /// ```text
    /// /**
    ///    * Verify that we can log onto the server.
    ///    *
    ///    * @param  aPassword    The password to use
    ///    * @param  aUrlListener A listener thatgets called back with success or
    ///    *                      failure.
    ///    * @return              The URI for the server.
    ///    *
    ///    */
    /// ```
    ///

    /// `nsIURI verifyLogon (in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow);`
    #[inline]
    pub unsafe fn VerifyLogon(&self, aUrlListener: *const nsIUrlListener, aMsgWindow: *const nsIMsgWindow, _retval: *mut*const nsIURI) -> ::nserror::nsresult {
        ((*self.vtable).VerifyLogon)(self, aUrlListener, aMsgWindow, _retval)
    }



    /// `void clearAllValues ();`
    #[inline]
    pub unsafe fn ClearAllValues(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).ClearAllValues)(self, )
    }


}


