/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __RESTRICT_IFACES_BPF_SKEL_H__
#define __RESTRICT_IFACES_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct restrict_ifaces_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *sd_restrictif;
		struct bpf_map *rodata;
	} maps;
	struct {
		struct bpf_program *sd_restrictif_e;
		struct bpf_program *sd_restrictif_i;
	} progs;
	struct {
		struct bpf_link *sd_restrictif_e;
		struct bpf_link *sd_restrictif_i;
	} links;
	struct restrict_ifaces_bpf__rodata {
		__u8 is_allow_list;
	} *rodata;

#ifdef __cplusplus
	static inline struct restrict_ifaces_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct restrict_ifaces_bpf *open_and_load();
	static inline int load(struct restrict_ifaces_bpf *skel);
	static inline int attach(struct restrict_ifaces_bpf *skel);
	static inline void detach(struct restrict_ifaces_bpf *skel);
	static inline void destroy(struct restrict_ifaces_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
restrict_ifaces_bpf__destroy(struct restrict_ifaces_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
restrict_ifaces_bpf__create_skeleton(struct restrict_ifaces_bpf *obj);

static inline struct restrict_ifaces_bpf *
restrict_ifaces_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct restrict_ifaces_bpf *obj;
	int err;

	obj = (struct restrict_ifaces_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = restrict_ifaces_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	restrict_ifaces_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct restrict_ifaces_bpf *
restrict_ifaces_bpf__open(void)
{
	return restrict_ifaces_bpf__open_opts(NULL);
}

static inline int
restrict_ifaces_bpf__load(struct restrict_ifaces_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct restrict_ifaces_bpf *
restrict_ifaces_bpf__open_and_load(void)
{
	struct restrict_ifaces_bpf *obj;
	int err;

	obj = restrict_ifaces_bpf__open();
	if (!obj)
		return NULL;
	err = restrict_ifaces_bpf__load(obj);
	if (err) {
		restrict_ifaces_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
restrict_ifaces_bpf__attach(struct restrict_ifaces_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
restrict_ifaces_bpf__detach(struct restrict_ifaces_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *restrict_ifaces_bpf__elf_bytes(size_t *sz);

static inline int
restrict_ifaces_bpf__create_skeleton(struct restrict_ifaces_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "restrict_ifaces_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 2;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "sd_restrictif";
	map->map = &obj->maps.sd_restrictif;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "restrict.rodata";
	map->map = &obj->maps.rodata;
	map->mmaped = (void **)&obj->rodata;

	/* programs */
	s->prog_cnt = 2;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "sd_restrictif_e";
	s->progs[0].prog = &obj->progs.sd_restrictif_e;
	s->progs[0].link = &obj->links.sd_restrictif_e;

	s->progs[1].name = "sd_restrictif_i";
	s->progs[1].prog = &obj->progs.sd_restrictif_i;
	s->progs[1].link = &obj->links.sd_restrictif_i;

	s->data = restrict_ifaces_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *restrict_ifaces_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xc0\x0b\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0c\0\
\x01\0\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x63\x67\
\x72\x6f\x75\x70\x5f\x73\x6b\x62\x2f\x65\x67\x72\x65\x73\x73\0\x63\x67\x72\x6f\
\x75\x70\x5f\x73\x6b\x62\x2f\x69\x6e\x67\x72\x65\x73\x73\0\x2e\x72\x6f\x64\x61\
\x74\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x6d\x61\x70\x73\0\x72\x65\x73\x74\
\x72\x69\x63\x74\x2d\x69\x66\x61\x63\x65\x73\x2e\x62\x70\x66\x2e\x63\0\x5f\x6c\
\x69\x63\x65\x6e\x73\x65\0\x73\x64\x5f\x72\x65\x73\x74\x72\x69\x63\x74\x69\x66\
\x5f\x65\0\x73\x64\x5f\x72\x65\x73\x74\x72\x69\x63\x74\x69\x66\0\x69\x73\x5f\
\x61\x6c\x6c\x6f\x77\x5f\x6c\x69\x73\x74\0\x73\x64\x5f\x72\x65\x73\x74\x72\x69\
\x63\x74\x69\x66\x5f\x69\0\x2e\x72\x65\x6c\x63\x67\x72\x6f\x75\x70\x5f\x73\x6b\
\x62\x2f\x65\x67\x72\x65\x73\x73\0\x2e\x72\x65\x6c\x63\x67\x72\x6f\x75\x70\x5f\
\x73\x6b\x62\x2f\x69\x6e\x67\x72\x65\x73\x73\0\x2e\x42\x54\x46\0\x2e\x42\x54\
\x46\x2e\x65\x78\x74\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x4c\0\0\0\x04\0\xf1\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x62\0\0\0\x01\0\x06\0\0\0\0\0\0\0\0\0\x12\0\0\0\0\0\0\0\0\0\0\0\x03\0\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6b\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\
\x98\0\0\0\0\0\0\0\x7b\0\0\0\x11\0\x07\0\0\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x89\
\0\0\0\x11\0\x05\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x97\0\0\0\x12\0\x04\0\0\0\
\0\0\0\0\0\0\x98\0\0\0\0\0\0\0\x61\x11\x28\0\0\0\0\0\x63\x1a\xfc\xff\0\0\0\0\
\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x85\0\0\0\x01\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\
\0\0\x16\x01\x03\0\0\0\0\0\xb4\x01\0\0\x01\0\0\0\x15\0\x03\0\0\0\0\0\x05\0\x03\
\0\0\0\0\0\xb4\x01\0\0\x01\0\0\0\x15\0\x01\0\0\0\0\0\xb4\x01\0\0\0\0\0\0\xbc\
\x10\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x61\x11\x28\0\0\0\0\0\x63\x1a\xfc\xff\0\0\0\
\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x85\0\0\0\x01\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\
\0\0\0\x16\x01\x03\0\0\0\0\0\xb4\x01\0\0\x01\0\0\0\x15\0\x03\0\0\0\0\0\x05\0\
\x03\0\0\0\0\0\xb4\x01\0\0\x01\0\0\0\x15\0\x01\0\0\0\0\0\xb4\x01\0\0\0\0\0\0\
\xbc\x10\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\0\x4c\x47\x50\x4c\x2d\x32\x2e\x31\x2d\
\x6f\x72\x2d\x6c\x61\x74\x65\x72\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\x38\0\0\0\0\0\0\0\x01\0\0\
\0\x08\0\0\0\x20\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\x38\0\0\0\0\0\0\0\x01\0\0\0\
\x08\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x1c\x04\0\0\x1c\x04\0\0\x9b\x02\0\0\
\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\
\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x01\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\
\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\x19\0\0\0\0\0\0\x08\x07\0\0\0\x1f\0\0\0\
\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x09\0\0\0\x2c\0\0\0\0\0\0\x08\
\x0a\0\0\0\x31\0\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\0\0\0\0\0\x03\0\0\x04\x18\0\0\
\0\x3f\0\0\0\x01\0\0\0\0\0\0\0\x44\0\0\0\x05\0\0\0\x40\0\0\0\x48\0\0\0\x08\0\0\
\0\x80\0\0\0\x4e\0\0\0\0\0\0\x0e\x0b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x0e\0\0\
\0\0\0\0\0\0\0\0\x0a\x0f\0\0\0\x5c\0\0\0\x22\0\0\x04\xc0\0\0\0\x66\0\0\0\x06\0\
\0\0\0\0\0\0\x6a\0\0\0\x06\0\0\0\x20\0\0\0\x73\0\0\0\x06\0\0\0\x40\0\0\0\x78\0\
\0\0\x06\0\0\0\x60\0\0\0\x86\0\0\0\x06\0\0\0\x80\0\0\0\x8f\0\0\0\x06\0\0\0\xa0\
\0\0\0\x9c\0\0\0\x06\0\0\0\xc0\0\0\0\xa5\0\0\0\x06\0\0\0\xe0\0\0\0\xb0\0\0\0\
\x06\0\0\0\0\x01\0\0\xb9\0\0\0\x06\0\0\0\x20\x01\0\0\xc9\0\0\0\x06\0\0\0\x40\
\x01\0\0\xd1\0\0\0\x06\0\0\0\x60\x01\0\0\xda\0\0\0\x10\0\0\0\x80\x01\0\0\xdd\0\
\0\0\x06\0\0\0\x20\x02\0\0\xe2\0\0\0\x06\0\0\0\x40\x02\0\0\xed\0\0\0\x06\0\0\0\
\x60\x02\0\0\xf2\0\0\0\x06\0\0\0\x80\x02\0\0\xfb\0\0\0\x06\0\0\0\xa0\x02\0\0\
\x03\x01\0\0\x06\0\0\0\xc0\x02\0\0\x0a\x01\0\0\x06\0\0\0\xe0\x02\0\0\x15\x01\0\
\0\x06\0\0\0\0\x03\0\0\x1f\x01\0\0\x11\0\0\0\x20\x03\0\0\x2a\x01\0\0\x11\0\0\0\
\xa0\x03\0\0\x34\x01\0\0\x06\0\0\0\x20\x04\0\0\x40\x01\0\0\x06\0\0\0\x40\x04\0\
\0\x4b\x01\0\0\x06\0\0\0\x60\x04\0\0\0\0\0\0\x12\0\0\0\x80\x04\0\0\x55\x01\0\0\
\x14\0\0\0\xc0\x04\0\0\x5c\x01\0\0\x06\0\0\0\0\x05\0\0\x65\x01\0\0\x06\0\0\0\
\x20\x05\0\0\0\0\0\0\x16\0\0\0\x40\x05\0\0\x6e\x01\0\0\x06\0\0\0\x80\x05\0\0\
\x77\x01\0\0\x09\0\0\0\xa0\x05\0\0\x83\x01\0\0\x14\0\0\0\xc0\x05\0\0\0\0\0\0\0\
\0\0\x03\0\0\0\0\x06\0\0\0\x04\0\0\0\x05\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x06\0\
\0\0\x04\0\0\0\x04\0\0\0\0\0\0\0\x01\0\0\x05\x08\0\0\0\x8c\x01\0\0\x13\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x02\x22\0\0\0\x96\x01\0\0\0\0\0\x08\x15\0\0\0\x9c\x01\0\0\
\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\x05\x08\0\0\0\xaf\x01\0\0\x17\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x02\x23\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xaf\x01\
\0\0\x0d\0\0\0\xb2\x01\0\0\x01\0\0\x0c\x18\0\0\0\xc2\x01\0\0\x01\0\0\x0c\x18\0\
\0\0\0\0\0\0\0\0\0\x0a\x1c\0\0\0\0\0\0\0\0\0\0\x09\x09\0\0\0\xd2\x01\0\0\0\0\0\
\x0e\x1b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x1f\0\0\0\xe0\x01\0\0\0\0\0\x01\x01\
\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x1e\0\0\0\x04\0\0\0\x12\0\0\0\xe5\
\x01\0\0\0\0\0\x0e\x20\0\0\0\0\0\0\0\xee\x01\0\0\0\0\0\x07\0\0\0\0\xfc\x01\0\0\
\0\0\0\x07\0\0\0\0\x60\x02\0\0\x01\0\0\x0f\x01\0\0\0\x1d\0\0\0\0\0\0\0\x01\0\0\
\0\x68\x02\0\0\x01\0\0\x0f\x12\0\0\0\x21\0\0\0\0\0\0\0\x12\0\0\0\x70\x02\0\0\
\x01\0\0\x0f\x18\0\0\0\x0c\0\0\0\0\0\0\0\x18\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\
\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x5f\x5f\x75\
\x33\x32\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x5f\x5f\x75\x38\0\
\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x63\x68\x61\x72\0\x74\x79\x70\x65\0\x6b\
\x65\x79\0\x76\x61\x6c\x75\x65\0\x73\x64\x5f\x72\x65\x73\x74\x72\x69\x63\x74\
\x69\x66\0\x5f\x5f\x73\x6b\x5f\x62\x75\x66\x66\0\x6c\x65\x6e\0\x70\x6b\x74\x5f\
\x74\x79\x70\x65\0\x6d\x61\x72\x6b\0\x71\x75\x65\x75\x65\x5f\x6d\x61\x70\x70\
\x69\x6e\x67\0\x70\x72\x6f\x74\x6f\x63\x6f\x6c\0\x76\x6c\x61\x6e\x5f\x70\x72\
\x65\x73\x65\x6e\x74\0\x76\x6c\x61\x6e\x5f\x74\x63\x69\0\x76\x6c\x61\x6e\x5f\
\x70\x72\x6f\x74\x6f\0\x70\x72\x69\x6f\x72\x69\x74\x79\0\x69\x6e\x67\x72\x65\
\x73\x73\x5f\x69\x66\x69\x6e\x64\x65\x78\0\x69\x66\x69\x6e\x64\x65\x78\0\x74\
\x63\x5f\x69\x6e\x64\x65\x78\0\x63\x62\0\x68\x61\x73\x68\0\x74\x63\x5f\x63\x6c\
\x61\x73\x73\x69\x64\0\x64\x61\x74\x61\0\x64\x61\x74\x61\x5f\x65\x6e\x64\0\x6e\
\x61\x70\x69\x5f\x69\x64\0\x66\x61\x6d\x69\x6c\x79\0\x72\x65\x6d\x6f\x74\x65\
\x5f\x69\x70\x34\0\x6c\x6f\x63\x61\x6c\x5f\x69\x70\x34\0\x72\x65\x6d\x6f\x74\
\x65\x5f\x69\x70\x36\0\x6c\x6f\x63\x61\x6c\x5f\x69\x70\x36\0\x72\x65\x6d\x6f\
\x74\x65\x5f\x70\x6f\x72\x74\0\x6c\x6f\x63\x61\x6c\x5f\x70\x6f\x72\x74\0\x64\
\x61\x74\x61\x5f\x6d\x65\x74\x61\0\x74\x73\x74\x61\x6d\x70\0\x77\x69\x72\x65\
\x5f\x6c\x65\x6e\0\x67\x73\x6f\x5f\x73\x65\x67\x73\0\x67\x73\x6f\x5f\x73\x69\
\x7a\x65\0\x74\x73\x74\x61\x6d\x70\x5f\x74\x79\x70\x65\0\x68\x77\x74\x73\x74\
\x61\x6d\x70\0\x66\x6c\x6f\x77\x5f\x6b\x65\x79\x73\0\x5f\x5f\x75\x36\x34\0\x75\
\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x73\x6b\
\0\x73\x64\x5f\x72\x65\x73\x74\x72\x69\x63\x74\x69\x66\x5f\x65\0\x73\x64\x5f\
\x72\x65\x73\x74\x72\x69\x63\x74\x69\x66\x5f\x69\0\x69\x73\x5f\x61\x6c\x6c\x6f\
\x77\x5f\x6c\x69\x73\x74\0\x63\x68\x61\x72\0\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\
\x62\x70\x66\x5f\x66\x6c\x6f\x77\x5f\x6b\x65\x79\x73\0\x62\x70\x66\x5f\x73\x6f\
\x63\x6b\0\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\x67\x2f\x73\x79\
\x73\x74\x65\x6d\x64\x2f\x62\x75\x69\x6c\x64\x2f\x2e\x2e\x2f\x73\x79\x73\x74\
\x65\x6d\x64\x2f\x73\x72\x63\x2f\x63\x6f\x72\x65\x2f\x62\x70\x66\x2f\x72\x65\
\x73\x74\x72\x69\x63\x74\x2d\x69\x66\x61\x63\x65\x73\x2f\x72\x65\x73\x74\x72\
\x69\x63\x74\x2d\x69\x66\x61\x63\x65\x73\x2e\x62\x70\x66\x2e\x63\0\x2e\x72\x6f\
\x64\x61\x74\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x6d\x61\x70\x73\0\x63\x67\
\x72\x6f\x75\x70\x5f\x73\x6b\x62\x2f\x65\x67\x72\x65\x73\x73\0\x63\x67\x72\x6f\
\x75\x70\x5f\x73\x6b\x62\x2f\x69\x6e\x67\x72\x65\x73\x73\0\0\x9f\xeb\x01\0\x20\
\0\0\0\0\0\0\0\x24\0\0\0\x24\0\0\0\xf4\0\0\0\x18\x01\0\0\0\0\0\0\x08\0\0\0\x76\
\x02\0\0\x01\0\0\0\0\0\0\0\x19\0\0\0\x88\x02\0\0\x01\0\0\0\0\0\0\0\x1a\0\0\0\
\x10\0\0\0\x76\x02\0\0\x07\0\0\0\0\0\0\0\x05\x02\0\0\0\0\0\0\x17\x6c\0\0\x08\0\
\0\0\x05\x02\0\0\0\0\0\0\x11\x6c\0\0\x20\0\0\0\x05\x02\0\0\0\0\0\0\x19\x70\0\0\
\x38\0\0\0\x05\x02\0\0\0\0\0\0\x0d\x74\0\0\x60\0\0\0\x05\x02\0\0\0\0\0\0\x15\
\x7c\0\0\x78\0\0\0\x05\x02\0\0\0\0\0\0\x15\x8c\0\0\x88\0\0\0\x05\x02\0\0\0\0\0\
\0\x09\xb0\0\0\x88\x02\0\0\x07\0\0\0\0\0\0\0\x05\x02\0\0\0\0\0\0\x17\x6c\0\0\
\x08\0\0\0\x05\x02\0\0\0\0\0\0\x11\x6c\0\0\x20\0\0\0\x05\x02\0\0\0\0\0\0\x19\
\x70\0\0\x38\0\0\0\x05\x02\0\0\0\0\0\0\x0d\x74\0\0\x60\0\0\0\x05\x02\0\0\0\0\0\
\0\x15\x7c\0\0\x78\0\0\0\x05\x02\0\0\0\0\0\0\x15\x8c\0\0\x88\0\0\0\x05\x02\0\0\
\0\0\0\0\x09\xc4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\
\0\x03\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\xe2\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x09\0\0\0\x02\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x28\x01\0\0\0\0\0\0\xf0\0\0\0\0\0\0\0\x01\0\0\0\0\
\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x11\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\x98\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x23\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\xb0\x02\0\0\0\0\0\0\x98\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x36\0\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x48\x03\0\
\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x3e\0\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x49\x03\0\0\0\0\0\0\x12\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x46\0\0\0\x01\
\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x03\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa7\0\0\0\x09\0\0\0\x40\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\x03\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x02\0\0\0\x03\
\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xbd\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x98\x03\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x02\0\0\0\x04\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xd4\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xb8\x03\0\0\0\0\0\0\xcf\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xd9\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x88\
\x0a\0\0\0\0\0\0\x38\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct restrict_ifaces_bpf *restrict_ifaces_bpf::open(const struct bpf_object_open_opts *opts) { return restrict_ifaces_bpf__open_opts(opts); }
struct restrict_ifaces_bpf *restrict_ifaces_bpf::open_and_load() { return restrict_ifaces_bpf__open_and_load(); }
int restrict_ifaces_bpf::load(struct restrict_ifaces_bpf *skel) { return restrict_ifaces_bpf__load(skel); }
int restrict_ifaces_bpf::attach(struct restrict_ifaces_bpf *skel) { return restrict_ifaces_bpf__attach(skel); }
void restrict_ifaces_bpf::detach(struct restrict_ifaces_bpf *skel) { restrict_ifaces_bpf__detach(skel); }
void restrict_ifaces_bpf::destroy(struct restrict_ifaces_bpf *skel) { restrict_ifaces_bpf__destroy(skel); }
const void *restrict_ifaces_bpf::elf_bytes(size_t *sz) { return restrict_ifaces_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
restrict_ifaces_bpf__assert(struct restrict_ifaces_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->is_allow_list) == 1, "unexpected size of 'is_allow_list'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __RESTRICT_IFACES_BPF_SKEL_H__ */
