// services/viz/public/mojom/compositing/layer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/layer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/layer.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool Layer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Layer_Data* object =
      static_cast<const Layer_Data*>(data);


  if (!::cc::mojom::internal::LayerType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->safe_opaque_background_color, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->safe_opaque_background_color, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_rect, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->offset_to_transform_parent, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->offset_to_transform_parent, validation_context))
    return false;

  return true;
}

Layer_Data::Layer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnchorPositionScrollData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnchorPositionScrollData_Data* object =
      static_cast<const AnchorPositionScrollData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->adjustment_container_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& adjustment_container_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->adjustment_container_ids, validation_context,
                                         &adjustment_container_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accumulated_scroll_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->accumulated_scroll_origin, validation_context))
    return false;

  return true;
}

AnchorPositionScrollData_Data::AnchorPositionScrollData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StickyPositionNodeData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StickyPositionNodeData_Data* object =
      static_cast<const StickyPositionNodeData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constraint_box_rect, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->constraint_box_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_container_relative_sticky_box_rect, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_container_relative_sticky_box_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_container_relative_containing_block_rect, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_container_relative_containing_block_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total_sticky_box_sticky_offset, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total_sticky_box_sticky_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total_containing_block_sticky_offset, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total_containing_block_sticky_offset, validation_context))
    return false;

  return true;
}

StickyPositionNodeData_Data::StickyPositionNodeData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TransformTreeUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TransformTreeUpdate_Data* object =
      static_cast<const TransformTreeUpdate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nodes_affected_by_outer_viewport_bounds_delta, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& nodes_affected_by_outer_viewport_bounds_delta_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nodes_affected_by_outer_viewport_bounds_delta, validation_context,
                                         &nodes_affected_by_outer_viewport_bounds_delta_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sticky_position_data, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sticky_position_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sticky_position_data, validation_context,
                                         &sticky_position_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->anchor_position_scroll_data, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& anchor_position_scroll_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->anchor_position_scroll_data, validation_context,
                                         &anchor_position_scroll_data_validate_params)) {
    return false;
  }

  return true;
}

TransformTreeUpdate_Data::TransformTreeUpdate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TransformNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TransformNode_Data* object =
      static_cast<const TransformNode_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_offset, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->snap_amount, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->snap_amount, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->visible_frame_element_id, validation_context))
    return false;

  return true;
}

TransformNode_Data::TransformNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipNode_Data* object =
      static_cast<const ClipNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip, validation_context))
    return false;

  return true;
}

ClipNode_Data::ClipNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EffectNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EffectNode_Data* object =
      static_cast<const EffectNode_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_contents_scale, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_contents_scale, validation_context))
    return false;

  return true;
}

EffectNode_Data::EffectNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollNode_Data* object =
      static_cast<const ScrollNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->container_bounds, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->container_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  return true;
}

ScrollNode_Data::ScrollNode_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz