// Copyright 2026 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/file_system.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#ifndef EXTENSIONS_COMMON_API_FILE_SYSTEM_H__
#define EXTENSIONS_COMMON_API_FILE_SYSTEM_H__

#include <stdint.h>

#include <map>
#include <memory>
#include <optional>
#include <string>
#include <vector>

#include "base/values.h"
#include <string_view>


namespace extensions {
namespace api {
namespace file_system {

//
// Types
//

struct AcceptOption {
  AcceptOption();
  ~AcceptOption();
  AcceptOption(const AcceptOption&) = delete;
  AcceptOption& operator=(const AcceptOption&) = delete;
  AcceptOption(AcceptOption&& rhs) noexcept;
  AcceptOption& operator=(AcceptOption&& rhs) noexcept;

  // Populates a AcceptOption object from a base::Value& instance. Returns
  // whether |out| was successfully populated.
  static bool Populate(const base::Value& value, AcceptOption& out);

  // Populates a AcceptOption object from a Dict& instance. Returns whether
  // |out| was successfully populated.
  static bool Populate(const base::Value::Dict& value, AcceptOption& out);

  // Creates a deep copy of AcceptOption.
  AcceptOption Clone() const;

  // Creates a AcceptOption object from a base::Value::Dict, or nullopt on
  // failure.
  static std::optional<AcceptOption> FromValue(const base::Value::Dict& value);

  // Creates a AcceptOption object from a base::Value, or nullopt on failure.
  static std::optional<AcceptOption> FromValue(const base::Value& value);

  // Returns a new base::Value::Dict representing the serialized form of
  // thisAcceptOption object.
  base::Value::Dict ToValue() const;

  // This is the optional text description for this option. If not present, a
  // description will be automatically generated; typically containing an expanded
  // list of valid extensions (e.g. "text/html" may expand to "*.html, *.htm").
  std::optional<std::string> description;

  // Mime-types to accept, e.g. "image/jpeg" or "audio/*". One of mimeTypes or
  // extensions must contain at least one valid element.
  std::optional<std::vector<std::string>> mime_types;

  // Extensions to accept, e.g. "jpg", "gif", "crx".
  std::optional<std::vector<std::string>> extensions;

};

enum class ChooseEntryType {
  kNone = 0,
  kOpenFile,
  kOpenWritableFile,
  kSaveFile,
  kOpenDirectory,
  kMaxValue = kOpenDirectory,
};


const char* ToString(ChooseEntryType as_enum);
ChooseEntryType ParseChooseEntryType(std::string_view as_string);
std::u16string GetChooseEntryTypeParseError(std::string_view as_string);

struct ChooseEntryOptions {
  ChooseEntryOptions();
  ~ChooseEntryOptions();
  ChooseEntryOptions(const ChooseEntryOptions&) = delete;
  ChooseEntryOptions& operator=(const ChooseEntryOptions&) = delete;
  ChooseEntryOptions(ChooseEntryOptions&& rhs) noexcept;
  ChooseEntryOptions& operator=(ChooseEntryOptions&& rhs) noexcept;

  // Populates a ChooseEntryOptions object from a base::Value& instance. Returns
  // whether |out| was successfully populated.
  static bool Populate(const base::Value& value, ChooseEntryOptions& out);

  // Populates a ChooseEntryOptions object from a Dict& instance. Returns
  // whether |out| was successfully populated.
  static bool Populate(const base::Value::Dict& value, ChooseEntryOptions& out);

  // Creates a deep copy of ChooseEntryOptions.
  ChooseEntryOptions Clone() const;

  // Creates a ChooseEntryOptions object from a base::Value::Dict, or nullopt on
  // failure.
  static std::optional<ChooseEntryOptions> FromValue(const base::Value::Dict& value);

  // Creates a ChooseEntryOptions object from a base::Value, or nullopt on
  // failure.
  static std::optional<ChooseEntryOptions> FromValue(const base::Value& value);

  // Returns a new base::Value::Dict representing the serialized form of
  // thisChooseEntryOptions object.
  base::Value::Dict ToValue() const;

  // Type of the prompt to show. The default is 'openFile'.
  ChooseEntryType type;

  // The suggested file name that will be presented to the user as the default
  // name to read or write. This is optional.
  std::optional<std::string> suggested_name;

  // The optional list of accept options for this file opener. Each option will be
  // presented as a unique group to the end-user.
  std::optional<std::vector<AcceptOption>> accepts;

  // Whether to accept all file types, in addition to the options specified in the
  // accepts argument. The default is true. If the accepts field is unset or
  // contains no valid entries, this will always be reset to true.
  std::optional<bool> accepts_all_types;

  // Whether to accept multiple files. This is only supported for openFile and
  // openWritableFile. The callback to chooseEntry will be called with a list of
  // entries if this is set to true. Otherwise it will be called with a single
  // Entry.
  std::optional<bool> accepts_multiple;

};

struct RequestFileSystemOptions {
  RequestFileSystemOptions();
  ~RequestFileSystemOptions();
  RequestFileSystemOptions(const RequestFileSystemOptions&) = delete;
  RequestFileSystemOptions& operator=(const RequestFileSystemOptions&) = delete;
  RequestFileSystemOptions(RequestFileSystemOptions&& rhs) noexcept;
  RequestFileSystemOptions& operator=(RequestFileSystemOptions&& rhs) noexcept;

  // Populates a RequestFileSystemOptions object from a base::Value& instance.
  // Returns whether |out| was successfully populated.
  static bool Populate(const base::Value& value, RequestFileSystemOptions& out);

  // Populates a RequestFileSystemOptions object from a Dict& instance. Returns
  // whether |out| was successfully populated.
  static bool Populate(const base::Value::Dict& value, RequestFileSystemOptions& out);

  // Creates a deep copy of RequestFileSystemOptions.
  RequestFileSystemOptions Clone() const;

  // Creates a RequestFileSystemOptions object from a base::Value::Dict, or
  // nullopt on failure.
  static std::optional<RequestFileSystemOptions> FromValue(const base::Value::Dict& value);

  // Creates a RequestFileSystemOptions object from a base::Value, or nullopt on
  // failure.
  static std::optional<RequestFileSystemOptions> FromValue(const base::Value& value);

  // Returns a new base::Value::Dict representing the serialized form of
  // thisRequestFileSystemOptions object.
  base::Value::Dict ToValue() const;

  // The ID of the requested volume.
  std::string volume_id;

  // Whether the requested file system should be writable. The default is
  // read-only.
  std::optional<bool> writable;

};

struct Volume {
  Volume();
  ~Volume();
  Volume(const Volume&) = delete;
  Volume& operator=(const Volume&) = delete;
  Volume(Volume&& rhs) noexcept;
  Volume& operator=(Volume&& rhs) noexcept;

  // Populates a Volume object from a base::Value& instance. Returns whether
  // |out| was successfully populated.
  static bool Populate(const base::Value& value, Volume& out);

  // Populates a Volume object from a Dict& instance. Returns whether |out| was
  // successfully populated.
  static bool Populate(const base::Value::Dict& value, Volume& out);

  // Creates a deep copy of Volume.
  Volume Clone() const;

  // Creates a Volume object from a base::Value::Dict, or nullopt on failure.
  static std::optional<Volume> FromValue(const base::Value::Dict& value);

  // Creates a Volume object from a base::Value, or nullopt on failure.
  static std::optional<Volume> FromValue(const base::Value& value);

  // Returns a new base::Value::Dict representing the serialized form of
  // thisVolume object.
  base::Value::Dict ToValue() const;

  std::string volume_id;

  bool writable;

};

struct VolumeListChangedEvent {
  VolumeListChangedEvent();
  ~VolumeListChangedEvent();
  VolumeListChangedEvent(const VolumeListChangedEvent&) = delete;
  VolumeListChangedEvent& operator=(const VolumeListChangedEvent&) = delete;
  VolumeListChangedEvent(VolumeListChangedEvent&& rhs) noexcept;
  VolumeListChangedEvent& operator=(VolumeListChangedEvent&& rhs) noexcept;

  // Populates a VolumeListChangedEvent object from a base::Value& instance.
  // Returns whether |out| was successfully populated.
  static bool Populate(const base::Value& value, VolumeListChangedEvent& out);

  // Populates a VolumeListChangedEvent object from a Dict& instance. Returns
  // whether |out| was successfully populated.
  static bool Populate(const base::Value::Dict& value, VolumeListChangedEvent& out);

  // Creates a deep copy of VolumeListChangedEvent.
  VolumeListChangedEvent Clone() const;

  // Creates a VolumeListChangedEvent object from a base::Value::Dict, or
  // nullopt on failure.
  static std::optional<VolumeListChangedEvent> FromValue(const base::Value::Dict& value);

  // Creates a VolumeListChangedEvent object from a base::Value, or nullopt on
  // failure.
  static std::optional<VolumeListChangedEvent> FromValue(const base::Value& value);

  // Returns a new base::Value::Dict representing the serialized form of
  // thisVolumeListChangedEvent object.
  base::Value::Dict ToValue() const;

  std::vector<Volume> volumes;

};


//
// Functions
//

namespace GetDisplayPath {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  struct Entry {
    Entry();
    ~Entry();
    Entry(const Entry&) = delete;
    Entry& operator=(const Entry&) = delete;
    Entry(Entry&& rhs) noexcept;
    Entry& operator=(Entry&& rhs) noexcept;

    // Populates a Entry object from a base::Value& instance. Returns whether
    // |out| was successfully populated.
    static bool Populate(const base::Value& value, Entry& out);

    // Populates a Entry object from a Dict& instance. Returns whether |out| was
    // successfully populated.
    static bool Populate(const base::Value::Dict& value, Entry& out);

    // Creates a deep copy of Entry.
    Entry Clone() const;

    // Creates a Entry object from a base::Value::Dict, or nullopt on failure.
    static std::optional<Entry> FromValue(const base::Value::Dict& value);

    // Creates a Entry object from a base::Value, or nullopt on failure.
    static std::optional<Entry> FromValue(const base::Value& value);

    base::Value::Dict additional_properties;
  };


  Entry entry;


 private:
  Params();
};

namespace Results {

base::Value::List Create(const std::string& display_path);
}  // namespace Results

}  // namespace GetDisplayPath

namespace GetWritableEntry {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  struct Entry {
    Entry();
    ~Entry();
    Entry(const Entry&) = delete;
    Entry& operator=(const Entry&) = delete;
    Entry(Entry&& rhs) noexcept;
    Entry& operator=(Entry&& rhs) noexcept;

    // Populates a Entry object from a base::Value& instance. Returns whether
    // |out| was successfully populated.
    static bool Populate(const base::Value& value, Entry& out);

    // Populates a Entry object from a Dict& instance. Returns whether |out| was
    // successfully populated.
    static bool Populate(const base::Value::Dict& value, Entry& out);

    // Creates a deep copy of Entry.
    Entry Clone() const;

    // Creates a Entry object from a base::Value::Dict, or nullopt on failure.
    static std::optional<Entry> FromValue(const base::Value::Dict& value);

    // Creates a Entry object from a base::Value, or nullopt on failure.
    static std::optional<Entry> FromValue(const base::Value& value);

    base::Value::Dict additional_properties;
  };


  Entry entry;


 private:
  Params();
};

namespace Results {

struct Entry {
  Entry();
  ~Entry();
  Entry(const Entry&) = delete;
  Entry& operator=(const Entry&) = delete;
  Entry(Entry&& rhs) noexcept;
  Entry& operator=(Entry&& rhs) noexcept;

  // Returns a new base::Value::Dict representing the serialized form of
  // thisEntry object.
  base::Value::Dict ToValue() const;

  base::Value::Dict additional_properties;
};


base::Value::List Create(const Entry& entry);
}  // namespace Results

}  // namespace GetWritableEntry

namespace IsWritableEntry {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  struct Entry {
    Entry();
    ~Entry();
    Entry(const Entry&) = delete;
    Entry& operator=(const Entry&) = delete;
    Entry(Entry&& rhs) noexcept;
    Entry& operator=(Entry&& rhs) noexcept;

    // Populates a Entry object from a base::Value& instance. Returns whether
    // |out| was successfully populated.
    static bool Populate(const base::Value& value, Entry& out);

    // Populates a Entry object from a Dict& instance. Returns whether |out| was
    // successfully populated.
    static bool Populate(const base::Value::Dict& value, Entry& out);

    // Creates a deep copy of Entry.
    Entry Clone() const;

    // Creates a Entry object from a base::Value::Dict, or nullopt on failure.
    static std::optional<Entry> FromValue(const base::Value::Dict& value);

    // Creates a Entry object from a base::Value, or nullopt on failure.
    static std::optional<Entry> FromValue(const base::Value& value);

    base::Value::Dict additional_properties;
  };


  Entry entry;


 private:
  Params();
};

namespace Results {

base::Value::List Create(bool is_writable);
}  // namespace Results

}  // namespace IsWritableEntry

namespace ChooseEntry {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  std::optional<ChooseEntryOptions> options;


 private:
  Params();
};

namespace Results {

struct Entry {
  Entry();
  ~Entry();
  Entry(const Entry&) = delete;
  Entry& operator=(const Entry&) = delete;
  Entry(Entry&& rhs) noexcept;
  Entry& operator=(Entry&& rhs) noexcept;

  // Returns a new base::Value::Dict representing the serialized form of
  // thisEntry object.
  base::Value::Dict ToValue() const;

  base::Value::Dict additional_properties;
};

struct FileEntriesType {
  FileEntriesType();
  ~FileEntriesType();
  FileEntriesType(const FileEntriesType&) = delete;
  FileEntriesType& operator=(const FileEntriesType&) = delete;
  FileEntriesType(FileEntriesType&& rhs) noexcept;
  FileEntriesType& operator=(FileEntriesType&& rhs) noexcept;

  // Returns a new base::Value::Dict representing the serialized form of
  // thisFileEntriesType object.
  base::Value::Dict ToValue() const;

  base::Value::Dict additional_properties;
};



base::Value::List Create(const Entry& entry, const std::vector<FileEntriesType>& file_entries);
}  // namespace Results

}  // namespace ChooseEntry

namespace RestoreEntry {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  std::string id;


 private:
  Params();
};

namespace Results {

struct Entry {
  Entry();
  ~Entry();
  Entry(const Entry&) = delete;
  Entry& operator=(const Entry&) = delete;
  Entry(Entry&& rhs) noexcept;
  Entry& operator=(Entry&& rhs) noexcept;

  // Returns a new base::Value::Dict representing the serialized form of
  // thisEntry object.
  base::Value::Dict ToValue() const;

  base::Value::Dict additional_properties;
};


base::Value::List Create(const Entry& entry);
}  // namespace Results

}  // namespace RestoreEntry

namespace IsRestorable {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  std::string id;


 private:
  Params();
};

namespace Results {

base::Value::List Create(bool is_restorable);
}  // namespace Results

}  // namespace IsRestorable

namespace RetainEntry {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  struct Entry {
    Entry();
    ~Entry();
    Entry(const Entry&) = delete;
    Entry& operator=(const Entry&) = delete;
    Entry(Entry&& rhs) noexcept;
    Entry& operator=(Entry&& rhs) noexcept;

    // Populates a Entry object from a base::Value& instance. Returns whether
    // |out| was successfully populated.
    static bool Populate(const base::Value& value, Entry& out);

    // Populates a Entry object from a Dict& instance. Returns whether |out| was
    // successfully populated.
    static bool Populate(const base::Value::Dict& value, Entry& out);

    // Creates a deep copy of Entry.
    Entry Clone() const;

    // Creates a Entry object from a base::Value::Dict, or nullopt on failure.
    static std::optional<Entry> FromValue(const base::Value::Dict& value);

    // Creates a Entry object from a base::Value, or nullopt on failure.
    static std::optional<Entry> FromValue(const base::Value& value);

    base::Value::Dict additional_properties;
  };


  Entry entry;


 private:
  Params();
};

}  // namespace RetainEntry

namespace RequestFileSystem {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  RequestFileSystemOptions options;


 private:
  Params();
};

namespace Results {

struct FileSystem {
  FileSystem();
  ~FileSystem();
  FileSystem(const FileSystem&) = delete;
  FileSystem& operator=(const FileSystem&) = delete;
  FileSystem(FileSystem&& rhs) noexcept;
  FileSystem& operator=(FileSystem&& rhs) noexcept;

  // Returns a new base::Value::Dict representing the serialized form of
  // thisFileSystem object.
  base::Value::Dict ToValue() const;

  base::Value::Dict additional_properties;
};


base::Value::List Create(const FileSystem& file_system);
}  // namespace Results

}  // namespace RequestFileSystem

namespace GetVolumeList {

namespace Results {

base::Value::List Create(const std::vector<Volume>& volumes);
}  // namespace Results

}  // namespace GetVolumeList

//
// Events
//

namespace OnVolumeListChanged {

extern const char kEventName[];  // "fileSystem.onVolumeListChanged"

base::Value::List Create(const VolumeListChangedEvent& event);
}  // namespace OnVolumeListChanged

}  // namespace file_system
}  // namespace api
}  // namespace extensions

#endif  // EXTENSIONS_COMMON_API_FILE_SYSTEM_H__
