// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/inspector/protocol/Profiler.h"

#include "src/inspector/protocol/Protocol.h"

#include "v8//third_party/inspector_protocol/crdtp/cbor.h"
#include "v8//third_party/inspector_protocol/crdtp/find_by_first.h"
#include "v8//third_party/inspector_protocol/crdtp/span.h"

namespace v8_inspector {
namespace protocol {
namespace Profiler {

using v8_crdtp::DeserializerState;
using v8_crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Profiler";
const char Metainfo::commandPrefix[] = "Profiler.";
const char Metainfo::version[] = "1.3";

V8_CRDTP_BEGIN_DESERIALIZER(ProfileNode)
    V8_CRDTP_DESERIALIZE_FIELD("callFrame", m_callFrame),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("children", m_children),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("deoptReason", m_deoptReason),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("hitCount", m_hitCount),
    V8_CRDTP_DESERIALIZE_FIELD("id", m_id),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("positionTicks", m_positionTicks),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ProfileNode)
    V8_CRDTP_SERIALIZE_FIELD("id", m_id);
    V8_CRDTP_SERIALIZE_FIELD("callFrame", m_callFrame);
    V8_CRDTP_SERIALIZE_FIELD("hitCount", m_hitCount);
    V8_CRDTP_SERIALIZE_FIELD("children", m_children);
    V8_CRDTP_SERIALIZE_FIELD("deoptReason", m_deoptReason);
    V8_CRDTP_SERIALIZE_FIELD("positionTicks", m_positionTicks);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(Profile)
    V8_CRDTP_DESERIALIZE_FIELD("endTime", m_endTime),
    V8_CRDTP_DESERIALIZE_FIELD("nodes", m_nodes),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("samples", m_samples),
    V8_CRDTP_DESERIALIZE_FIELD("startTime", m_startTime),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("timeDeltas", m_timeDeltas),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(Profile)
    V8_CRDTP_SERIALIZE_FIELD("nodes", m_nodes);
    V8_CRDTP_SERIALIZE_FIELD("startTime", m_startTime);
    V8_CRDTP_SERIALIZE_FIELD("endTime", m_endTime);
    V8_CRDTP_SERIALIZE_FIELD("samples", m_samples);
    V8_CRDTP_SERIALIZE_FIELD("timeDeltas", m_timeDeltas);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(PositionTickInfo)
    V8_CRDTP_DESERIALIZE_FIELD("line", m_line),
    V8_CRDTP_DESERIALIZE_FIELD("ticks", m_ticks),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(PositionTickInfo)
    V8_CRDTP_SERIALIZE_FIELD("line", m_line);
    V8_CRDTP_SERIALIZE_FIELD("ticks", m_ticks);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(CoverageRange)
    V8_CRDTP_DESERIALIZE_FIELD("count", m_count),
    V8_CRDTP_DESERIALIZE_FIELD("endOffset", m_endOffset),
    V8_CRDTP_DESERIALIZE_FIELD("startOffset", m_startOffset),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CoverageRange)
    V8_CRDTP_SERIALIZE_FIELD("startOffset", m_startOffset);
    V8_CRDTP_SERIALIZE_FIELD("endOffset", m_endOffset);
    V8_CRDTP_SERIALIZE_FIELD("count", m_count);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(FunctionCoverage)
    V8_CRDTP_DESERIALIZE_FIELD("functionName", m_functionName),
    V8_CRDTP_DESERIALIZE_FIELD("isBlockCoverage", m_isBlockCoverage),
    V8_CRDTP_DESERIALIZE_FIELD("ranges", m_ranges),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(FunctionCoverage)
    V8_CRDTP_SERIALIZE_FIELD("functionName", m_functionName);
    V8_CRDTP_SERIALIZE_FIELD("ranges", m_ranges);
    V8_CRDTP_SERIALIZE_FIELD("isBlockCoverage", m_isBlockCoverage);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(ScriptCoverage)
    V8_CRDTP_DESERIALIZE_FIELD("functions", m_functions),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
    V8_CRDTP_DESERIALIZE_FIELD("url", m_url),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ScriptCoverage)
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("url", m_url);
    V8_CRDTP_SERIALIZE_FIELD("functions", m_functions);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(TypeObject)
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(TypeObject)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(TypeProfileEntry)
    V8_CRDTP_DESERIALIZE_FIELD("offset", m_offset),
    V8_CRDTP_DESERIALIZE_FIELD("types", m_types),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(TypeProfileEntry)
    V8_CRDTP_SERIALIZE_FIELD("offset", m_offset);
    V8_CRDTP_SERIALIZE_FIELD("types", m_types);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(ScriptTypeProfile)
    V8_CRDTP_DESERIALIZE_FIELD("entries", m_entries),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
    V8_CRDTP_DESERIALIZE_FIELD("url", m_url),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ScriptTypeProfile)
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("url", m_url);
    V8_CRDTP_SERIALIZE_FIELD("entries", m_entries);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(CounterInfo)
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CounterInfo)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(RuntimeCallCounterInfo)
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD("time", m_time),
    V8_CRDTP_DESERIALIZE_FIELD("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(RuntimeCallCounterInfo)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("time", m_time);
V8_CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::consoleProfileFinished(const String& id, std::unique_ptr<protocol::Debugger::Location> location, std::unique_ptr<protocol::Profiler::Profile> profile, Maybe<String> title)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("id"), id);
    serializer.AddField(v8_crdtp::MakeSpan("location"), location);
    serializer.AddField(v8_crdtp::MakeSpan("profile"), profile);
    serializer.AddField(v8_crdtp::MakeSpan("title"), title);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Profiler.consoleProfileFinished", serializer.Finish()));
}

void Frontend::consoleProfileStarted(const String& id, std::unique_ptr<protocol::Debugger::Location> location, Maybe<String> title)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("id"), id);
    serializer.AddField(v8_crdtp::MakeSpan("location"), location);
    serializer.AddField(v8_crdtp::MakeSpan("title"), title);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Profiler.consoleProfileStarted", serializer.Finish()));
}

void Frontend::preciseCoverageDeltaUpdate(double timestamp, const String& occassion, std::unique_ptr<protocol::Array<protocol::Profiler::ScriptCoverage>> result)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(v8_crdtp::MakeSpan("occassion"), occassion);
    serializer.AddField(v8_crdtp::MakeSpan("result"), result);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Profiler.preciseCoverageDeltaUpdate", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const v8_crdtp::Dispatchable& dispatchable);

    std::function<void(const v8_crdtp::Dispatchable&)> Dispatch(v8_crdtp::span<uint8_t> command_name) override;

    void disable(const v8_crdtp::Dispatchable& dispatchable);
    void enable(const v8_crdtp::Dispatchable& dispatchable);
    void getBestEffortCoverage(const v8_crdtp::Dispatchable& dispatchable);
    void setSamplingInterval(const v8_crdtp::Dispatchable& dispatchable);
    void start(const v8_crdtp::Dispatchable& dispatchable);
    void startPreciseCoverage(const v8_crdtp::Dispatchable& dispatchable);
    void startTypeProfile(const v8_crdtp::Dispatchable& dispatchable);
    void stop(const v8_crdtp::Dispatchable& dispatchable);
    void stopPreciseCoverage(const v8_crdtp::Dispatchable& dispatchable);
    void stopTypeProfile(const v8_crdtp::Dispatchable& dispatchable);
    void takePreciseCoverage(const v8_crdtp::Dispatchable& dispatchable);
    void takeTypeProfile(const v8_crdtp::Dispatchable& dispatchable);
    void enableCounters(const v8_crdtp::Dispatchable& dispatchable);
    void disableCounters(const v8_crdtp::Dispatchable& dispatchable);
    void getCounters(const v8_crdtp::Dispatchable& dispatchable);
    void enableRuntimeCallStats(const v8_crdtp::Dispatchable& dispatchable);
    void disableRuntimeCallStats(const v8_crdtp::Dispatchable& dispatchable);
    void getRuntimeCallStats(const v8_crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(v8_crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<v8_crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          v8_crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          v8_crdtp::SpanFrom("disableCounters"),
          &DomainDispatcherImpl::disableCounters
    },
    {
          v8_crdtp::SpanFrom("disableRuntimeCallStats"),
          &DomainDispatcherImpl::disableRuntimeCallStats
    },
    {
          v8_crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          v8_crdtp::SpanFrom("enableCounters"),
          &DomainDispatcherImpl::enableCounters
    },
    {
          v8_crdtp::SpanFrom("enableRuntimeCallStats"),
          &DomainDispatcherImpl::enableRuntimeCallStats
    },
    {
          v8_crdtp::SpanFrom("getBestEffortCoverage"),
          &DomainDispatcherImpl::getBestEffortCoverage
    },
    {
          v8_crdtp::SpanFrom("getCounters"),
          &DomainDispatcherImpl::getCounters
    },
    {
          v8_crdtp::SpanFrom("getRuntimeCallStats"),
          &DomainDispatcherImpl::getRuntimeCallStats
    },
    {
          v8_crdtp::SpanFrom("setSamplingInterval"),
          &DomainDispatcherImpl::setSamplingInterval
    },
    {
          v8_crdtp::SpanFrom("start"),
          &DomainDispatcherImpl::start
    },
    {
          v8_crdtp::SpanFrom("startPreciseCoverage"),
          &DomainDispatcherImpl::startPreciseCoverage
    },
    {
          v8_crdtp::SpanFrom("startTypeProfile"),
          &DomainDispatcherImpl::startTypeProfile
    },
    {
          v8_crdtp::SpanFrom("stop"),
          &DomainDispatcherImpl::stop
    },
    {
          v8_crdtp::SpanFrom("stopPreciseCoverage"),
          &DomainDispatcherImpl::stopPreciseCoverage
    },
    {
          v8_crdtp::SpanFrom("stopTypeProfile"),
          &DomainDispatcherImpl::stopTypeProfile
    },
    {
          v8_crdtp::SpanFrom("takePreciseCoverage"),
          &DomainDispatcherImpl::takePreciseCoverage
    },
    {
          v8_crdtp::SpanFrom("takeTypeProfile"),
          &DomainDispatcherImpl::takeTypeProfile
    },
    };
    return commands;
  }();
  return v8_crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const v8_crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(v8_crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const v8_crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getBestEffortCoverage(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Profiler::ScriptCoverage>> out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getBestEffortCoverage(&out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.getBestEffortCoverage"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setSamplingIntervalParams : public v8_crdtp::DeserializableProtocolObject<setSamplingIntervalParams> {
    int interval;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setSamplingIntervalParams)
    V8_CRDTP_DESERIALIZE_FIELD("interval", interval),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setSamplingInterval(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setSamplingIntervalParams params;
    setSamplingIntervalParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setSamplingInterval(params.interval);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.setSamplingInterval"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::start(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->start();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.start"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct startPreciseCoverageParams : public v8_crdtp::DeserializableProtocolObject<startPreciseCoverageParams> {
    Maybe<bool> callCount;
    Maybe<bool> detailed;
    Maybe<bool> allowTriggeredUpdates;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(startPreciseCoverageParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("allowTriggeredUpdates", allowTriggeredUpdates),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("callCount", callCount),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("detailed", detailed),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::startPreciseCoverage(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    startPreciseCoverageParams params;
    startPreciseCoverageParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;

    // Declare output parameters.
    double out_timestamp;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->startPreciseCoverage(std::move(params.callCount), std::move(params.detailed), std::move(params.allowTriggeredUpdates), &out_timestamp);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.startPreciseCoverage"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("timestamp"), out_timestamp);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::startTypeProfile(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->startTypeProfile();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.startTypeProfile"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stop(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    std::unique_ptr<protocol::Profiler::Profile> out_profile;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stop(&out_profile);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.stop"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("profile"), out_profile);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopPreciseCoverage(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stopPreciseCoverage();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.stopPreciseCoverage"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopTypeProfile(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stopTypeProfile();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.stopTypeProfile"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::takePreciseCoverage(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Profiler::ScriptCoverage>> out_result;
    double out_timestamp;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->takePreciseCoverage(&out_result, &out_timestamp);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.takePreciseCoverage"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          serializer.AddField(v8_crdtp::MakeSpan("timestamp"), out_timestamp);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::takeTypeProfile(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Profiler::ScriptTypeProfile>> out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->takeTypeProfile(&out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.takeTypeProfile"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enableCounters(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enableCounters();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.enableCounters"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disableCounters(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disableCounters();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.disableCounters"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getCounters(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Profiler::CounterInfo>> out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getCounters(&out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.getCounters"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enableRuntimeCallStats(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enableRuntimeCallStats();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.enableRuntimeCallStats"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disableRuntimeCallStats(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disableRuntimeCallStats();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.disableRuntimeCallStats"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getRuntimeCallStats(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Profiler::RuntimeCallCounterInfo>> out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getRuntimeCallStats(&out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Profiler.getRuntimeCallStats"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<v8_crdtp::span<uint8_t>, v8_crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<v8_crdtp::span<uint8_t>, v8_crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(v8_crdtp::SpanFrom("Profiler"), SortedRedirects(), std::move(dispatcher));
}

} // Profiler
} // namespace v8_inspector
} // namespace protocol
