#ifndef GEN_UI_GFX_X_XTEST_H_
#define GEN_UI_GFX_X_XTEST_H_

#include <array>
#include <cstddef>
#include <cstdint>
#include <cstring>
#include <vector>

#include "base/component_export.h"
#include "base/memory/ref_counted_memory.h"
#include "base/memory/scoped_refptr.h"
#include "base/optional.h"
#include "base/files/scoped_file.h"
#include "ui/gfx/x/xproto_types.h"
#include "xproto.h"

namespace x11 {

class Connection;

class COMPONENT_EXPORT(X11) Test {
  public:
  static constexpr unsigned major_version = 2;
  static constexpr unsigned minor_version = 2;

  Test(Connection* connection,
      const x11::QueryExtensionReply& info);

  uint8_t present() const {
    return info_.present;
  }
  uint8_t major_opcode() const {
    return info_.major_opcode;
  }
  uint8_t first_event() const {
    return info_.first_event;
  }
  uint8_t first_error() const {
    return info_.first_error;
  }

  Connection* connection() const { return connection_; }

  enum class Cursor : int {
    None = 0,
    Current = 1,
  };

  struct GetVersionRequest {
    uint8_t major_version{};
    uint16_t minor_version{};
  };

  struct GetVersionReply {
    uint8_t major_version{};
    uint16_t sequence{};
    uint16_t minor_version{};
  };

  using GetVersionResponse = Response<GetVersionReply>;

  Future<GetVersionReply> GetVersion(
      const GetVersionRequest& request);

  struct CompareCursorRequest {
    Window window{};
    x11::Cursor cursor{};
  };

  struct CompareCursorReply {
    uint8_t same{};
    uint16_t sequence{};
  };

  using CompareCursorResponse = Response<CompareCursorReply>;

  Future<CompareCursorReply> CompareCursor(
      const CompareCursorRequest& request);

  struct FakeInputRequest {
    uint8_t type{};
    uint8_t detail{};
    uint32_t time{};
    Window root{};
    int16_t rootX{};
    int16_t rootY{};
    uint8_t deviceid{};
  };

  using FakeInputResponse = Response<void>;

  Future<void> FakeInput(
      const FakeInputRequest& request);

  struct GrabControlRequest {
    uint8_t impervious{};
  };

  using GrabControlResponse = Response<void>;

  Future<void> GrabControl(
      const GrabControlRequest& request);

  private:
  x11::Connection* const connection_;
  x11::QueryExtensionReply info_{};
};

}  // namespace x11

inline constexpr x11::Test::Cursor operator|(
    x11::Test::Cursor l, x11::Test::Cursor r) {
  using T = std::underlying_type_t<x11::Test::Cursor>;
  return static_cast<x11::Test::Cursor>(
      static_cast<T>(l) | static_cast<T>(r));
}

inline constexpr x11::Test::Cursor operator&(
    x11::Test::Cursor l, x11::Test::Cursor r) {
  using T = std::underlying_type_t<x11::Test::Cursor>;
  return static_cast<x11::Test::Cursor>(
      static_cast<T>(l) & static_cast<T>(r));
}


#endif  // GEN_UI_GFX_X_XTEST_H_
