// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-blink.h"
#include "services/network/public/mojom/url_loader.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker_mode.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-blink.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/core/core_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class ControllerServiceWorkerProxy;

template <typename ImplRefTraits>
class ControllerServiceWorkerStub;

class ControllerServiceWorkerRequestValidator;
class ControllerServiceWorkerResponseValidator;


class CORE_EXPORT ControllerServiceWorker
    : public ControllerServiceWorkerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ControllerServiceWorkerInterfaceBase;
  using Proxy_ = ControllerServiceWorkerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ControllerServiceWorkerStub<ImplRefTraits>;

  using RequestValidator_ = ControllerServiceWorkerRequestValidator;
  using ResponseValidator_ = ControllerServiceWorkerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDispatchFetchEventForSubresourceMinVersion = 0,
    kCloneMinVersion = 0,
  };
  virtual ~ControllerServiceWorker() {}


  using DispatchFetchEventForSubresourceCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  
  virtual void DispatchFetchEventForSubresource(::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForSubresourceCallback callback) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<ControllerServiceWorker> receiver, const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::blink::CrossOriginEmbedderPolicyReporter> coep_reporter) = 0;
};

class ControllerServiceWorkerConnectorProxy;

template <typename ImplRefTraits>
class ControllerServiceWorkerConnectorStub;

class ControllerServiceWorkerConnectorRequestValidator;


class CORE_EXPORT ControllerServiceWorkerConnector
    : public ControllerServiceWorkerConnectorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ControllerServiceWorkerConnectorInterfaceBase;
  using Proxy_ = ControllerServiceWorkerConnectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = ControllerServiceWorkerConnectorStub<ImplRefTraits>;

  using RequestValidator_ = ControllerServiceWorkerConnectorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateControllerMinVersion = 0,
  };
  virtual ~ControllerServiceWorkerConnector() {}

  
  virtual void UpdateController(::mojo::PendingRemote<ControllerServiceWorker> controller) = 0;
};



class CORE_EXPORT ControllerServiceWorkerProxy
    : public ControllerServiceWorker {
 public:
  using InterfaceType = ControllerServiceWorker;

  explicit ControllerServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchFetchEventForSubresource(::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForSubresourceCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<ControllerServiceWorker> receiver, const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::blink::CrossOriginEmbedderPolicyReporter> coep_reporter) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT ControllerServiceWorkerConnectorProxy
    : public ControllerServiceWorkerConnector {
 public:
  using InterfaceType = ControllerServiceWorkerConnector;

  explicit ControllerServiceWorkerConnectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateController(::mojo::PendingRemote<ControllerServiceWorker> controller) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT ControllerServiceWorkerStubDispatch {
 public:
  static bool Accept(ControllerServiceWorker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ControllerServiceWorker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ControllerServiceWorker>>
class ControllerServiceWorkerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ControllerServiceWorkerStub() {}
  ~ControllerServiceWorkerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ControllerServiceWorkerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ControllerServiceWorkerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ControllerServiceWorkerConnectorStubDispatch {
 public:
  static bool Accept(ControllerServiceWorkerConnector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ControllerServiceWorkerConnector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ControllerServiceWorkerConnector>>
class ControllerServiceWorkerConnectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ControllerServiceWorkerConnectorStub() {}
  ~ControllerServiceWorkerConnectorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ControllerServiceWorkerConnectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ControllerServiceWorkerConnectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ControllerServiceWorkerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ControllerServiceWorkerConnectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ControllerServiceWorkerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class CORE_EXPORT ControllerServiceWorkerInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ControllerServiceWorkerInfo, T>::value>;
  using DataView = ControllerServiceWorkerInfoDataView;
  using Data_ = internal::ControllerServiceWorkerInfo_Data;

  template <typename... Args>
  static ControllerServiceWorkerInfoPtr New(Args&&... args) {
    return ControllerServiceWorkerInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ControllerServiceWorkerInfoPtr From(const U& u) {
    return mojo::TypeConverter<ControllerServiceWorkerInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ControllerServiceWorkerInfo>::Convert(*this);
  }


  ControllerServiceWorkerInfo();

  ControllerServiceWorkerInfo(
      ::blink::mojom::blink::ControllerServiceWorkerMode mode,
      ::mojo::PendingRemote<ControllerServiceWorker> remote_controller,
      const WTF::String& client_id,
      const base::Optional<::base::UnguessableToken>& fetch_request_window_id,
      ::blink::mojom::blink::ServiceWorkerObjectInfoPtr object_info,
      WTF::Vector<::blink::mojom::blink::WebFeature> used_features);

  ~ControllerServiceWorkerInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ControllerServiceWorkerInfoPtr>
  ControllerServiceWorkerInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ControllerServiceWorkerInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ControllerServiceWorkerInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ControllerServiceWorkerInfo_UnserializedMessageContext<
            UserType, ControllerServiceWorkerInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ControllerServiceWorkerInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ControllerServiceWorkerInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ControllerServiceWorkerInfo_UnserializedMessageContext<
            UserType, ControllerServiceWorkerInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ControllerServiceWorkerInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::mojom::blink::ControllerServiceWorkerMode mode;
  
  ::mojo::PendingRemote<ControllerServiceWorker> remote_controller;
  
  WTF::String client_id;
  
  base::Optional<::base::UnguessableToken> fetch_request_window_id;
  
  ::blink::mojom::blink::ServiceWorkerObjectInfoPtr object_info;
  
  WTF::Vector<::blink::mojom::blink::WebFeature> used_features;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ControllerServiceWorkerInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ControllerServiceWorkerInfoPtr ControllerServiceWorkerInfo::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(remote_controller),
      mojo::Clone(client_id),
      mojo::Clone(fetch_request_window_id),
      mojo::Clone(object_info),
      mojo::Clone(used_features)
  );
}

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>*>
bool ControllerServiceWorkerInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->remote_controller, other_struct.remote_controller))
    return false;
  if (!mojo::Equals(this->client_id, other_struct.client_id))
    return false;
  if (!mojo::Equals(this->fetch_request_window_id, other_struct.fetch_request_window_id))
    return false;
  if (!mojo::Equals(this->object_info, other_struct.object_info))
    return false;
  if (!mojo::Equals(this->used_features, other_struct.used_features))
    return false;
  return true;
}

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mode, rhs.mode))
    return true;
  if (std::less<>{}(rhs.mode, lhs.mode))
    return false;
  if (std::less<>{}(lhs.remote_controller, rhs.remote_controller))
    return true;
  if (std::less<>{}(rhs.remote_controller, lhs.remote_controller))
    return false;
  if (std::less<>{}(lhs.client_id, rhs.client_id))
    return true;
  if (std::less<>{}(rhs.client_id, lhs.client_id))
    return false;
  if (std::less<>{}(lhs.fetch_request_window_id, rhs.fetch_request_window_id))
    return true;
  if (std::less<>{}(rhs.fetch_request_window_id, lhs.fetch_request_window_id))
    return false;
  if (std::less<>{}(lhs.object_info, rhs.object_info))
    return true;
  if (std::less<>{}(rhs.object_info, lhs.object_info))
    return false;
  if (std::less<>{}(lhs.used_features, rhs.used_features))
    return true;
  if (std::less<>{}(rhs.used_features, lhs.used_features))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::ControllerServiceWorkerInfo::DataView,
                                         ::blink::mojom::blink::ControllerServiceWorkerInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::ControllerServiceWorkerInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ControllerServiceWorkerInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ControllerServiceWorkerInfo::mode) mode(
      const ::blink::mojom::blink::ControllerServiceWorkerInfoPtr& input) {
    return input->mode;
  }

  static  decltype(::blink::mojom::blink::ControllerServiceWorkerInfo::remote_controller)& remote_controller(
       ::blink::mojom::blink::ControllerServiceWorkerInfoPtr& input) {
    return input->remote_controller;
  }

  static const decltype(::blink::mojom::blink::ControllerServiceWorkerInfo::client_id)& client_id(
      const ::blink::mojom::blink::ControllerServiceWorkerInfoPtr& input) {
    return input->client_id;
  }

  static const decltype(::blink::mojom::blink::ControllerServiceWorkerInfo::fetch_request_window_id)& fetch_request_window_id(
      const ::blink::mojom::blink::ControllerServiceWorkerInfoPtr& input) {
    return input->fetch_request_window_id;
  }

  static  decltype(::blink::mojom::blink::ControllerServiceWorkerInfo::object_info)& object_info(
       ::blink::mojom::blink::ControllerServiceWorkerInfoPtr& input) {
    return input->object_info;
  }

  static const decltype(::blink::mojom::blink::ControllerServiceWorkerInfo::used_features)& used_features(
      const ::blink::mojom::blink::ControllerServiceWorkerInfoPtr& input) {
    return input->used_features;
  }

  static bool Read(::blink::mojom::blink::ControllerServiceWorkerInfo::DataView input, ::blink::mojom::blink::ControllerServiceWorkerInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_BLINK_H_