// third_party/blink/public/mojom/page/drag.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/drag.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/page/drag.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/drag.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/drag.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
AllowedDragOperations::AllowedDragOperations()
    : allow_copy(),
      allow_link(),
      allow_generic(),
      allow_private(),
      allow_move(),
      allow_delete() {}

AllowedDragOperations::AllowedDragOperations(
    bool allow_copy_in,
    bool allow_link_in,
    bool allow_generic_in,
    bool allow_private_in,
    bool allow_move_in,
    bool allow_delete_in)
    : allow_copy(std::move(allow_copy_in)),
      allow_link(std::move(allow_link_in)),
      allow_generic(std::move(allow_generic_in)),
      allow_private(std::move(allow_private_in)),
      allow_move(std::move(allow_move_in)),
      allow_delete(std::move(allow_delete_in)) {}

AllowedDragOperations::~AllowedDragOperations() = default;

void AllowedDragOperations::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("allow_copy", this->allow_copy);
  value->SetBoolean("allow_link", this->allow_link);
  value->SetBoolean("allow_generic", this->allow_generic);
  value->SetBoolean("allow_private", this->allow_private);
  value->SetBoolean("allow_move", this->allow_move);
  value->SetBoolean("allow_delete", this->allow_delete);
}

bool AllowedDragOperations::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemString::DragItemString()
    : string_type(),
      string_data(),
      title(),
      base_url() {}

DragItemString::DragItemString(
    const WTF::String& string_type_in,
    const ::WTF::String& string_data_in,
    const ::WTF::String& title_in,
    const base::Optional<::blink::KURL>& base_url_in)
    : string_type(std::move(string_type_in)),
      string_data(std::move(string_data_in)),
      title(std::move(title_in)),
      base_url(std::move(base_url_in)) {}

DragItemString::~DragItemString() = default;

void DragItemString::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("string_type", this->string_type.Utf8());
  value->SetString("string_data", base::trace_event::ValueToString(this->string_data, "<value of type const ::WTF::String&>"));
  value->SetString("title", base::trace_event::ValueToString(this->title, "<value of type const ::WTF::String&>"));
  value->SetString("base_url", base::trace_event::ValueToString(this->base_url, "<value of type const base::Optional<::blink::KURL>&>"));
}

bool DragItemString::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemFile::DragItemFile()
    : path(),
      display_name(),
      native_file_system_token() {}

DragItemFile::DragItemFile(
    const ::base::FilePath& path_in,
    const ::base::FilePath& display_name_in,
    ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemDragDropToken> native_file_system_token_in)
    : path(std::move(path_in)),
      display_name(std::move(display_name_in)),
      native_file_system_token(std::move(native_file_system_token_in)) {}

DragItemFile::~DragItemFile() = default;

void DragItemFile::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("path", base::trace_event::ValueToString(this->path, "<value of type const ::base::FilePath&>"));
  value->SetString("display_name", base::trace_event::ValueToString(this->display_name, "<value of type const ::base::FilePath&>"));
  value->SetBoolean("native_file_system_token", this->native_file_system_token.is_valid());
}

bool DragItemFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemBinary::DragItemBinary()
    : data(),
      source_url(),
      filename_extension(),
      content_disposition() {}

DragItemBinary::DragItemBinary(
    WTF::Vector<uint8_t> data_in,
    const ::blink::KURL& source_url_in,
    const ::base::FilePath& filename_extension_in,
    const WTF::String& content_disposition_in)
    : data(std::move(data_in)),
      source_url(std::move(source_url_in)),
      filename_extension(std::move(filename_extension_in)),
      content_disposition(std::move(content_disposition_in)) {}

DragItemBinary::~DragItemBinary() = default;

void DragItemBinary::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("data");
  for (const auto& item0 : this->data) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetString("source_url", base::trace_event::ValueToString(this->source_url, "<value of type const ::blink::KURL&>"));
  value->SetString("filename_extension", base::trace_event::ValueToString(this->filename_extension, "<value of type const ::base::FilePath&>"));
  value->SetString("content_disposition", this->content_disposition.Utf8());
}

bool DragItemBinary::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemFileSystemFile::DragItemFileSystemFile()
    : url(),
      size(),
      file_system_id() {}

DragItemFileSystemFile::DragItemFileSystemFile(
    const ::blink::KURL& url_in,
    int64_t size_in,
    const WTF::String& file_system_id_in)
    : url(std::move(url_in)),
      size(std::move(size_in)),
      file_system_id(std::move(file_system_id_in)) {}

DragItemFileSystemFile::~DragItemFileSystemFile() = default;

void DragItemFileSystemFile::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::blink::KURL&>"));
  value->SetString("size", base::NumberToString(this->size));
  value->SetString("file_system_id", this->file_system_id.Utf8());
}

bool DragItemFileSystemFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragData::DragData()
    : items(),
      file_system_id(),
      referrer_policy(::network::mojom::blink::ReferrerPolicy::kDefault) {}

DragData::DragData(
    WTF::Vector<DragItemPtr> items_in,
    const WTF::String& file_system_id_in,
    ::network::mojom::blink::ReferrerPolicy referrer_policy_in)
    : items(std::move(items_in)),
      file_system_id(std::move(file_system_id_in)),
      referrer_policy(std::move(referrer_policy_in)) {}

DragData::~DragData() = default;

void DragData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("items");
  for (const auto& item0 : this->items) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type DragItemPtr>"));
  }
  value->EndArray();
  value->SetString("file_system_id", this->file_system_id.Utf8());
  value->SetString("referrer_policy", base::trace_event::ValueToString(this->referrer_policy));
}

bool DragData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragEventSourceInfo::DragEventSourceInfo()
    : location(),
      source() {}

DragEventSourceInfo::DragEventSourceInfo(
    const ::gfx::Point& location_in,
    ::ui::mojom::blink::DragEventSource source_in)
    : location(std::move(location_in)),
      source(std::move(source_in)) {}

DragEventSourceInfo::~DragEventSourceInfo() = default;

void DragEventSourceInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("location", base::trace_event::ValueToString(this->location, "<value of type const ::gfx::Point&>"));
  value->SetString("source", base::trace_event::ValueToString(this->source));
}

bool DragEventSourceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItem::DragItem() : tag_(Tag::STRING) {
  data_.string = new DragItemStringPtr;
}

DragItem::~DragItem() {
  DestroyActive();
}


void DragItem::set_string(
    DragItemStringPtr string) {
  if (tag_ == Tag::STRING) {
    *(data_.string) = std::move(string);
  } else {
    DestroyActive();
    tag_ = Tag::STRING;
    data_.string = new DragItemStringPtr(
        std::move(string));
  }
}
void DragItem::set_file(
    DragItemFilePtr file) {
  if (tag_ == Tag::FILE) {
    *(data_.file) = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE;
    data_.file = new DragItemFilePtr(
        std::move(file));
  }
}
void DragItem::set_binary(
    DragItemBinaryPtr binary) {
  if (tag_ == Tag::BINARY) {
    *(data_.binary) = std::move(binary);
  } else {
    DestroyActive();
    tag_ = Tag::BINARY;
    data_.binary = new DragItemBinaryPtr(
        std::move(binary));
  }
}
void DragItem::set_file_system_file(
    DragItemFileSystemFilePtr file_system_file) {
  if (tag_ == Tag::FILE_SYSTEM_FILE) {
    *(data_.file_system_file) = std::move(file_system_file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE_SYSTEM_FILE;
    data_.file_system_file = new DragItemFileSystemFilePtr(
        std::move(file_system_file));
  }
}

void DragItem::DestroyActive() {
  switch (tag_) {

    case Tag::STRING:

      delete data_.string;
      break;
    case Tag::FILE:

      delete data_.file;
      break;
    case Tag::BINARY:

      delete data_.binary;
      break;
    case Tag::FILE_SYSTEM_FILE:

      delete data_.file_system_file;
      break;
  }
}

bool DragItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AllowedDragOperations::DataView, ::blink::mojom::blink::AllowedDragOperationsPtr>::Read(
    ::blink::mojom::blink::AllowedDragOperations::DataView input,
    ::blink::mojom::blink::AllowedDragOperationsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AllowedDragOperationsPtr result(::blink::mojom::blink::AllowedDragOperations::New());
  
      if (success)
        result->allow_copy = input.allow_copy();
      if (success)
        result->allow_link = input.allow_link();
      if (success)
        result->allow_generic = input.allow_generic();
      if (success)
        result->allow_private = input.allow_private();
      if (success)
        result->allow_move = input.allow_move();
      if (success)
        result->allow_delete = input.allow_delete();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragItemString::DataView, ::blink::mojom::blink::DragItemStringPtr>::Read(
    ::blink::mojom::blink::DragItemString::DataView input,
    ::blink::mojom::blink::DragItemStringPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragItemStringPtr result(::blink::mojom::blink::DragItemString::New());
  
      if (success && !input.ReadStringType(&result->string_type))
        success = false;
      if (success && !input.ReadStringData(&result->string_data))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadBaseUrl(&result->base_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragItemFile::DataView, ::blink::mojom::blink::DragItemFilePtr>::Read(
    ::blink::mojom::blink::DragItemFile::DataView input,
    ::blink::mojom::blink::DragItemFilePtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragItemFilePtr result(::blink::mojom::blink::DragItemFile::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success) {
        result->native_file_system_token =
            input.TakeNativeFileSystemToken<decltype(result->native_file_system_token)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragItemBinary::DataView, ::blink::mojom::blink::DragItemBinaryPtr>::Read(
    ::blink::mojom::blink::DragItemBinary::DataView input,
    ::blink::mojom::blink::DragItemBinaryPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragItemBinaryPtr result(::blink::mojom::blink::DragItemBinary::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadSourceUrl(&result->source_url))
        success = false;
      if (success && !input.ReadFilenameExtension(&result->filename_extension))
        success = false;
      if (success && !input.ReadContentDisposition(&result->content_disposition))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragItemFileSystemFile::DataView, ::blink::mojom::blink::DragItemFileSystemFilePtr>::Read(
    ::blink::mojom::blink::DragItemFileSystemFile::DataView input,
    ::blink::mojom::blink::DragItemFileSystemFilePtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragItemFileSystemFilePtr result(::blink::mojom::blink::DragItemFileSystemFile::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->size = input.size();
      if (success && !input.ReadFileSystemId(&result->file_system_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragData::DataView, ::blink::mojom::blink::DragDataPtr>::Read(
    ::blink::mojom::blink::DragData::DataView input,
    ::blink::mojom::blink::DragDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragDataPtr result(::blink::mojom::blink::DragData::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
      if (success && !input.ReadFileSystemId(&result->file_system_id))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragEventSourceInfo::DataView, ::blink::mojom::blink::DragEventSourceInfoPtr>::Read(
    ::blink::mojom::blink::DragEventSourceInfo::DataView input,
    ::blink::mojom::blink::DragEventSourceInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragEventSourceInfoPtr result(::blink::mojom::blink::DragEventSourceInfo::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::DragItem::DataView, ::blink::mojom::blink::DragItemPtr>::Read(
    ::blink::mojom::blink::DragItem::DataView input,
    ::blink::mojom::blink::DragItemPtr* output) {
  using UnionType = ::blink::mojom::blink::DragItem;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::STRING: {
      ::blink::mojom::blink::DragItemStringPtr result_string;
      if (!input.ReadString(&result_string))
        return false;

      *output = UnionType::NewString(
          std::move(result_string));
      break;
    }
    case Tag::FILE: {
      ::blink::mojom::blink::DragItemFilePtr result_file;
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::BINARY: {
      ::blink::mojom::blink::DragItemBinaryPtr result_binary;
      if (!input.ReadBinary(&result_binary))
        return false;

      *output = UnionType::NewBinary(
          std::move(result_binary));
      break;
    }
    case Tag::FILE_SYSTEM_FILE: {
      ::blink::mojom::blink::DragItemFileSystemFilePtr result_file_system_file;
      if (!input.ReadFileSystemFile(&result_file_system_file))
        return false;

      *output = UnionType::NewFileSystemFile(
          std::move(result_file_system_file));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif