// third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_INPUT_STREAM_FACTORY_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_INPUT_STREAM_FACTORY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-blink-forward.h"
#include "media/mojo/mojom/audio_data_pipe.mojom-blink.h"
#include "media/mojo/mojom/audio_input_stream.mojom-blink.h"
#include "media/mojo/mojom/audio_parameters.mojom-blink.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class RendererAudioInputStreamFactoryProxy;

template <typename ImplRefTraits>
class RendererAudioInputStreamFactoryStub;

class RendererAudioInputStreamFactoryRequestValidator;


class PLATFORM_EXPORT RendererAudioInputStreamFactory
    : public RendererAudioInputStreamFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RendererAudioInputStreamFactoryInterfaceBase;
  using Proxy_ = RendererAudioInputStreamFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererAudioInputStreamFactoryStub<ImplRefTraits>;

  using RequestValidator_ = RendererAudioInputStreamFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateStreamMinVersion = 0,
    kAssociateInputAndOutputForAecMinVersion = 0,
  };
  virtual ~RendererAudioInputStreamFactory() {}

  
  virtual void CreateStream(::mojo::PendingRemote<RendererAudioInputStreamFactoryClient> client, const ::base::UnguessableToken& session_id, const ::media::AudioParameters& params, bool automatic_gain_control, uint32_t shared_memory_count) = 0;

  
  virtual void AssociateInputAndOutputForAec(const ::base::UnguessableToken& input_stream_id, const WTF::String& output_device_id) = 0;
};

class RendererAudioInputStreamFactoryClientProxy;

template <typename ImplRefTraits>
class RendererAudioInputStreamFactoryClientStub;

class RendererAudioInputStreamFactoryClientRequestValidator;


class PLATFORM_EXPORT RendererAudioInputStreamFactoryClient
    : public RendererAudioInputStreamFactoryClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RendererAudioInputStreamFactoryClientInterfaceBase;
  using Proxy_ = RendererAudioInputStreamFactoryClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererAudioInputStreamFactoryClientStub<ImplRefTraits>;

  using RequestValidator_ = RendererAudioInputStreamFactoryClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStreamCreatedMinVersion = 0,
  };
  virtual ~RendererAudioInputStreamFactoryClient() {}

  
  virtual void StreamCreated(::mojo::PendingRemote<::media::mojom::blink::AudioInputStream> stream, ::mojo::PendingReceiver<::media::mojom::blink::AudioInputStreamClient> client_request, ::media::mojom::blink::ReadOnlyAudioDataPipePtr data_pipe, bool initially_muted, const base::Optional<::base::UnguessableToken>& stream_id) = 0;
};



class PLATFORM_EXPORT RendererAudioInputStreamFactoryProxy
    : public RendererAudioInputStreamFactory {
 public:
  using InterfaceType = RendererAudioInputStreamFactory;

  explicit RendererAudioInputStreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateStream(::mojo::PendingRemote<RendererAudioInputStreamFactoryClient> client, const ::base::UnguessableToken& session_id, const ::media::AudioParameters& params, bool automatic_gain_control, uint32_t shared_memory_count) final;
  
  void AssociateInputAndOutputForAec(const ::base::UnguessableToken& input_stream_id, const WTF::String& output_device_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT RendererAudioInputStreamFactoryClientProxy
    : public RendererAudioInputStreamFactoryClient {
 public:
  using InterfaceType = RendererAudioInputStreamFactoryClient;

  explicit RendererAudioInputStreamFactoryClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StreamCreated(::mojo::PendingRemote<::media::mojom::blink::AudioInputStream> stream, ::mojo::PendingReceiver<::media::mojom::blink::AudioInputStreamClient> client_request, ::media::mojom::blink::ReadOnlyAudioDataPipePtr data_pipe, bool initially_muted, const base::Optional<::base::UnguessableToken>& stream_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT RendererAudioInputStreamFactoryStubDispatch {
 public:
  static bool Accept(RendererAudioInputStreamFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererAudioInputStreamFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererAudioInputStreamFactory>>
class RendererAudioInputStreamFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererAudioInputStreamFactoryStub() {}
  ~RendererAudioInputStreamFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioInputStreamFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioInputStreamFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT RendererAudioInputStreamFactoryClientStubDispatch {
 public:
  static bool Accept(RendererAudioInputStreamFactoryClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererAudioInputStreamFactoryClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererAudioInputStreamFactoryClient>>
class RendererAudioInputStreamFactoryClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererAudioInputStreamFactoryClientStub() {}
  ~RendererAudioInputStreamFactoryClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioInputStreamFactoryClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioInputStreamFactoryClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT RendererAudioInputStreamFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT RendererAudioInputStreamFactoryClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_INPUT_STREAM_FACTORY_MOJOM_BLINK_H_