// third_party/blink/public/mojom/manifest/manifest_observer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/manifest/manifest_observer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/manifest/manifest_observer.mojom-params-data.h"
#include "third_party/blink/public/mojom/manifest/manifest_observer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/manifest/manifest_observer.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_OBSERVER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_OBSERVER_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char ManifestUrlChangeObserver::Name_[] = "blink.mojom.ManifestUrlChangeObserver";

ManifestUrlChangeObserverProxy::ManifestUrlChangeObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ManifestUrlChangeObserverProxy::ManifestUrlChanged(
    const base::Optional<::blink::KURL>& in_manifest_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ManifestUrlChangeObserver::ManifestUrlChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("manifest_url", base::trace_event::ValueToString(in_manifest_url, "<value of type const base::Optional<::blink::KURL>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kManifestUrlChangeObserver_ManifestUrlChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ManifestUrlChangeObserver_ManifestUrlChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->manifest_url)::BaseType::BufferWriter
      manifest_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_manifest_url, buffer, &manifest_url_writer, &serialization_context);
  params->manifest_url.Set(
      manifest_url_writer.is_null() ? nullptr : manifest_url_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestUrlChangeObserver::Name_);
  message.set_method_name("ManifestUrlChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ManifestUrlChangeObserverStubDispatch::Accept(
    ManifestUrlChangeObserver* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kManifestUrlChangeObserver_ManifestUrlChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ManifestUrlChangeObserver::ManifestUrlChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ManifestUrlChangeObserver::ManifestUrlChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ManifestUrlChangeObserver_ManifestUrlChanged_Params_Data* params =
          reinterpret_cast<internal::ManifestUrlChangeObserver_ManifestUrlChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::blink::KURL> p_manifest_url{};
      ManifestUrlChangeObserver_ManifestUrlChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadManifestUrl(&p_manifest_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManifestUrlChangeObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ManifestUrlChanged(
std::move(p_manifest_url));
      return true;
    }
  }
  return false;
}

// static
bool ManifestUrlChangeObserverStubDispatch::AcceptWithResponder(
    ManifestUrlChangeObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kManifestUrlChangeObserver_ManifestUrlChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kManifestUrlChangeObserverValidationInfo[] = {
    {&internal::ManifestUrlChangeObserver_ManifestUrlChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool ManifestUrlChangeObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ManifestUrlChangeObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kManifestUrlChangeObserverValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif