// third_party/blink/public/mojom/frame/media_player_action.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_MEDIA_PLAYER_ACTION_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_MEDIA_PLAYER_ACTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/frame/media_player_action.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class MediaPlayerActionDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::MediaPlayerActionDataView> {
  using Data = ::blink::mojom::internal::MediaPlayerAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class MediaPlayerActionType : int32_t {
  
  kPlay = 0,
  
  kMute = 1,
  
  kLoop = 2,
  
  kControls = 3,
  
  kPictureInPicture = 4,
  
  kDefaultActionType = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(FRAME_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, MediaPlayerActionType value);
inline bool IsKnownEnumValue(MediaPlayerActionType value) {
  return internal::MediaPlayerActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class MediaPlayerActionDataView {
 public:
  MediaPlayerActionDataView() {}

  MediaPlayerActionDataView(
      internal::MediaPlayerAction_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::MediaPlayerActionType>(
        data_value, output);
  }

  MediaPlayerActionType type() const {
    return static_cast<MediaPlayerActionType>(data_->type);
  }
  bool enable() const {
    return data_->enable;
  }
 private:
  internal::MediaPlayerAction_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::MediaPlayerActionType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaPlayerActionType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::MediaPlayerActionType, ::blink::mojom::MediaPlayerActionType> {
  static ::blink::mojom::MediaPlayerActionType ToMojom(::blink::mojom::MediaPlayerActionType input) { return input; }
  static bool FromMojom(::blink::mojom::MediaPlayerActionType input, ::blink::mojom::MediaPlayerActionType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaPlayerActionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaPlayerActionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::MediaPlayerActionType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaPlayerActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaPlayerActionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::MediaPlayerAction_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::MediaPlayerActionType>(
        Traits::type(input), &(*output)->type);
    (*output)->enable = Traits::enable(input);
  }

  static bool Deserialize(::blink::mojom::internal::MediaPlayerAction_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MediaPlayerActionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {




}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_MEDIA_PLAYER_ACTION_MOJOM_SHARED_H_