// media/mojo/mojom/interface_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_H_
#define MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/interface_factory.mojom-shared.h"
#include "media/mojo/mojom/interface_factory.mojom-forward.h"
#include "media/mojo/mojom/audio_decoder.mojom.h"
#include "media/mojo/mojom/decryptor.mojom.h"
#include "media/mojo/mojom/content_decryption_module.mojom.h"
#include "media/mojo/mojom/renderer.mojom.h"
#include "media/mojo/mojom/renderer_extensions.mojom.h"
#include "media/mojo/mojom/video_decoder.mojom.h"
#include "mojo/public/mojom/base/token.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {

class InterfaceFactoryProxy;

template <typename ImplRefTraits>
class InterfaceFactoryStub;

class InterfaceFactoryRequestValidator;
class InterfaceFactoryResponseValidator;


class  InterfaceFactory
    : public InterfaceFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = InterfaceFactoryInterfaceBase;
  using Proxy_ = InterfaceFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = InterfaceFactoryStub<ImplRefTraits>;

  using RequestValidator_ = InterfaceFactoryRequestValidator;
  using ResponseValidator_ = InterfaceFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateAudioDecoderMinVersion = 0,
    kCreateVideoDecoderMinVersion = 0,
    kCreateDefaultRendererMinVersion = 0,
    kCreateCdmMinVersion = 0,
  };
  virtual ~InterfaceFactory() {}

  
  virtual void CreateAudioDecoder(::mojo::PendingReceiver<::media::mojom::AudioDecoder> audio_decoder) = 0;

  
  virtual void CreateVideoDecoder(::mojo::PendingReceiver<::media::mojom::VideoDecoder> video_decoder) = 0;

  
  virtual void CreateDefaultRenderer(const std::string& audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> renderer) = 0;


  using CreateCdmCallback = base::OnceCallback<void(::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>, const base::Optional<::base::UnguessableToken>&, ::mojo::PendingRemote<::media::mojom::Decryptor>, const std::string&)>;
  
  virtual void CreateCdm(const std::string& key_system, const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) = 0;
};



class  InterfaceFactoryProxy
    : public InterfaceFactory {
 public:
  using InterfaceType = InterfaceFactory;

  explicit InterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateAudioDecoder(::mojo::PendingReceiver<::media::mojom::AudioDecoder> audio_decoder) final;
  
  void CreateVideoDecoder(::mojo::PendingReceiver<::media::mojom::VideoDecoder> video_decoder) final;
  
  void CreateDefaultRenderer(const std::string& audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> renderer) final;
  
  void CreateCdm(const std::string& key_system, const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  InterfaceFactoryStubDispatch {
 public:
  static bool Accept(InterfaceFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      InterfaceFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<InterfaceFactory>>
class InterfaceFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  InterfaceFactoryStub() {}
  ~InterfaceFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InterfaceFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InterfaceFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  InterfaceFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  InterfaceFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_H_