// content/common/frame_proxy.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_PROXY_MOJOM_H_
#define CONTENT_COMMON_FRAME_PROXY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/frame_proxy.mojom-shared.h"
#include "content/common/frame_proxy.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "cc/mojom/render_frame_metadata.mojom.h"
#include "content/common/frame.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class RenderFrameProxyHostProxy;

template <typename ImplRefTraits>
class RenderFrameProxyHostStub;

class RenderFrameProxyHostRequestValidator;


class CONTENT_EXPORT RenderFrameProxyHost
    : public RenderFrameProxyHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RenderFrameProxyHostInterfaceBase;
  using Proxy_ = RenderFrameProxyHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderFrameProxyHostStub<ImplRefTraits>;

  using RequestValidator_ = RenderFrameProxyHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOpenURLMinVersion = 0,
  };
  virtual ~RenderFrameProxyHost() {}

  
  virtual void OpenURL(::content::mojom::OpenURLParamsPtr params) = 0;
};

class RenderFrameProxyProxy;

template <typename ImplRefTraits>
class RenderFrameProxyStub;

class RenderFrameProxyRequestValidator;


class CONTENT_EXPORT RenderFrameProxy
    : public RenderFrameProxyInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RenderFrameProxyInterfaceBase;
  using Proxy_ = RenderFrameProxyProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderFrameProxyStub<ImplRefTraits>;

  using RequestValidator_ = RenderFrameProxyRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kChildProcessGoneMinVersion = 0,
    kEnableAutoResizeMinVersion = 0,
    kDisableAutoResizeMinVersion = 0,
    kDidUpdateVisualPropertiesMinVersion = 0,
    kSetFrameSinkIdMinVersion = 0,
  };
  virtual ~RenderFrameProxy() {}

  
  virtual void ChildProcessGone() = 0;

  
  virtual void EnableAutoResize(const ::gfx::Size& min_size, const ::gfx::Size& max_size) = 0;

  
  virtual void DisableAutoResize() = 0;

  
  virtual void DidUpdateVisualProperties(const ::cc::RenderFrameMetadata& metadata) = 0;

  
  virtual void SetFrameSinkId(const ::viz::FrameSinkId& frame_sink_id) = 0;
};



class CONTENT_EXPORT RenderFrameProxyHostProxy
    : public RenderFrameProxyHost {
 public:
  using InterfaceType = RenderFrameProxyHost;

  explicit RenderFrameProxyHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenURL(::content::mojom::OpenURLParamsPtr params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT RenderFrameProxyProxy
    : public RenderFrameProxy {
 public:
  using InterfaceType = RenderFrameProxy;

  explicit RenderFrameProxyProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ChildProcessGone() final;
  
  void EnableAutoResize(const ::gfx::Size& min_size, const ::gfx::Size& max_size) final;
  
  void DisableAutoResize() final;
  
  void DidUpdateVisualProperties(const ::cc::RenderFrameMetadata& metadata) final;
  
  void SetFrameSinkId(const ::viz::FrameSinkId& frame_sink_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RenderFrameProxyHostStubDispatch {
 public:
  static bool Accept(RenderFrameProxyHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderFrameProxyHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderFrameProxyHost>>
class RenderFrameProxyHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderFrameProxyHostStub() {}
  ~RenderFrameProxyHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderFrameProxyHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderFrameProxyHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RenderFrameProxyStubDispatch {
 public:
  static bool Accept(RenderFrameProxy* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderFrameProxy* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderFrameProxy>>
class RenderFrameProxyStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderFrameProxyStub() {}
  ~RenderFrameProxyStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderFrameProxyStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderFrameProxyStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RenderFrameProxyHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT RenderFrameProxyRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_FRAME_PROXY_MOJOM_H_