#line 1 "psqlscan.c"
/*-------------------------------------------------------------------------
 *
 * psqlscan.l
 *	  lexical scanner for SQL commands
 *
 * This lexer used to be part of psql, and that heritage is reflected in
 * the file name as well as function and typedef names, though it can now
 * be used by other frontend programs as well.  It's also possible to extend
 * this lexer with a compatible add-on lexer to handle program-specific
 * backslash commands.
 *
 * This code is mainly concerned with determining where the end of a SQL
 * statement is: we are looking for semicolons that are not within quotes,
 * comments, or parentheses.  The most reliable way to handle this is to
 * borrow the backend's flex lexer rules, lock, stock, and barrel.  The rules
 * below are (except for a few) the same as the backend's, but their actions
 * are just ECHO whereas the backend's actions generally do other things.
 *
 * XXX The rules in this file must be kept in sync with the backend lexer!!!
 *
 * XXX Avoid creating backtracking cases --- see the backend lexer for info.
 *
 * See psqlscan_int.h for additional commentary.
 *
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/fe_utils/psqlscan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include "common/logging.h"
#include "fe_utils/psqlscan.h"

#include "libpq-fe.h"

#line 42 "psqlscan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define psql_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer psql_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define psql_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer psql_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define psql_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer psql_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define psql_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string psql_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define psql_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes psql_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define psql_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer psql_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define psql_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer psql_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define psql_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state psql_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define psql_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer psql_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define psql_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state psql_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define psql_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state psql_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define psql_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack psql_yyensure_buffer_stack
#endif

#ifdef yylex
#define psql_yylex_ALREADY_DEFINED
#else
#define yylex psql_yylex
#endif

#ifdef yyrestart
#define psql_yyrestart_ALREADY_DEFINED
#else
#define yyrestart psql_yyrestart
#endif

#ifdef yylex_init
#define psql_yylex_init_ALREADY_DEFINED
#else
#define yylex_init psql_yylex_init
#endif

#ifdef yylex_init_extra
#define psql_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra psql_yylex_init_extra
#endif

#ifdef yylex_destroy
#define psql_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy psql_yylex_destroy
#endif

#ifdef yyget_debug
#define psql_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug psql_yyget_debug
#endif

#ifdef yyset_debug
#define psql_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug psql_yyset_debug
#endif

#ifdef yyget_extra
#define psql_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra psql_yyget_extra
#endif

#ifdef yyset_extra
#define psql_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra psql_yyset_extra
#endif

#ifdef yyget_in
#define psql_yyget_in_ALREADY_DEFINED
#else
#define yyget_in psql_yyget_in
#endif

#ifdef yyset_in
#define psql_yyset_in_ALREADY_DEFINED
#else
#define yyset_in psql_yyset_in
#endif

#ifdef yyget_out
#define psql_yyget_out_ALREADY_DEFINED
#else
#define yyget_out psql_yyget_out
#endif

#ifdef yyset_out
#define psql_yyset_out_ALREADY_DEFINED
#else
#define yyset_out psql_yyset_out
#endif

#ifdef yyget_leng
#define psql_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng psql_yyget_leng
#endif

#ifdef yyget_text
#define psql_yyget_text_ALREADY_DEFINED
#else
#define yyget_text psql_yyget_text
#endif

#ifdef yyget_lineno
#define psql_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno psql_yyget_lineno
#endif

#ifdef yyset_lineno
#define psql_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno psql_yyset_lineno
#endif

#ifdef yyget_column
#define psql_yyget_column_ALREADY_DEFINED
#else
#define yyget_column psql_yyget_column
#endif

#ifdef yyset_column
#define psql_yyset_column_ALREADY_DEFINED
#else
#define yyset_column psql_yyset_column
#endif

#ifdef yywrap
#define psql_yywrap_ALREADY_DEFINED
#else
#define yywrap psql_yywrap
#endif

#ifdef yyget_lval
#define psql_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval psql_yyget_lval
#endif

#ifdef yyset_lval
#define psql_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval psql_yyset_lval
#endif

#ifdef yyalloc
#define psql_yyalloc_ALREADY_DEFINED
#else
#define yyalloc psql_yyalloc
#endif

#ifdef yyrealloc
#define psql_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc psql_yyrealloc
#endif

#ifdef yyfree
#define psql_yyfree_ALREADY_DEFINED
#else
#define yyfree psql_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define psql_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static const flex_int16_t yy_nxt[][44] =
    {
    {
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0
    },

    {
       23,   24,   25,   26,   25,   27,   28,   29,   30,   31,
       29,   32,   33,   34,   31,   31,   35,   36,   37,   38,
       39,   40,   40,   40,   41,   42,   43,   44,   45,   29,
       46,   47,   48,   46,   49,   46,   50,   51,   52,   46,
       50,   51,   24,   24

    },

    {
       23,   24,   25,   26,   25,   27,   28,   29,   30,   31,
       29,   32,   33,   34,   31,   31,   35,   36,   37,   38,
       39,   40,   40,   40,   41,   42,   43,   44,   45,   29,
       46,   47,   48,   46,   49,   46,   50,   51,   52,   46,
       50,   51,   24,   24
    },

    {
       23,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   54,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53

    },

    {
       23,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   54,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53
    },

    {
       23,   55,   55,   55,   55,   56,   55,   56,   55,   56,
       56,   55,   55,   55,   57,   56,   55,   56,   55,   58,
       55,   55,   55,   55,   55,   55,   56,   56,   56,   56,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55

    },

    {
       23,   55,   55,   55,   55,   56,   55,   56,   55,   56,
       56,   55,   55,   55,   57,   56,   55,   56,   55,   58,
       55,   55,   55,   55,   55,   55,   56,   56,   56,   56,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55
    },

    {
       23,   59,   59,   59,   59,   59,   60,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59

    },

    {
       23,   59,   59,   59,   59,   59,   60,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59
    },

    {
       23,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   54,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61

    },

    {
       23,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   54,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61
    },

    {
       23,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   63,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62

    },

    {
       23,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   63,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62
    },

    {
       23,   64,   65,   66,   67,   64,   64,   64,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   68,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   64

    },

    {
       23,   64,   65,   66,   67,   64,   64,   64,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   68,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   64
    },

    {
       23,   69,   69,   70,   69,   69,   69,   69,   69,   69,
       69,   71,   69,   69,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   72,   69,
       69,   69,   69,   69

    },

    {
       23,   69,   69,   70,   69,   69,   69,   69,   69,   69,
       69,   71,   69,   69,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   72,   69,
       69,   69,   69,   69
    },

    {
       23,   73,   73,   74,   73,   73,   73,   73,   75,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73

    },

    {
       23,   73,   73,   74,   73,   73,   73,   73,   75,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73
    },

    {
       23,   59,   59,   59,   59,   59,   76,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59

    },

    {
       23,   59,   59,   59,   59,   59,   76,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59
    },

    {
       23,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   63,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62

    },

    {
       23,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   63,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62
    },

    {
      -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,
      -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,
      -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,
      -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,
      -23,  -23,  -23,  -23

    },

    {
       23,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,
      -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,
      -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,
      -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,
      -24,  -24,  -24,  -24
    },

    {
       23,  -25,   77,   77,   77,  -25,  -25,  -25,  -25,  -25,
      -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,
      -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,
      -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25,
      -25,  -25,  -25,  -25

    },

    {
       23,  -26,   77,   77,   77,  -26,  -26,  -26,  -26,  -26,
      -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,
      -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,
      -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,
      -26,  -26,  -26,  -26
    },

    {
       23,  -27,  -27,  -27,  -27,   78,  -27,   78,  -27,   78,
       78,  -27,  -27,  -27,   78,   78,  -27,   78,  -27,   78,
      -27,  -27,  -27,  -27,  -27,  -27,   78,   79,   78,   78,
      -27,  -27,  -27,  -27,  -27,  -27,  -27,  -27,  -27,  -27,
      -27,  -27,  -27,  -27

    },

    {
       23,  -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,
      -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,
      -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,
      -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28,
      -28,  -28,  -28,  -28
    },

    {
       23,  -29,  -29,  -29,  -29,   78,  -29,   78,  -29,   78,
       78,  -29,  -29,  -29,   78,   78,  -29,   78,  -29,   78,
      -29,  -29,  -29,  -29,  -29,  -29,   78,   78,   78,   78,
      -29,  -29,  -29,  -29,  -29,  -29,  -29,  -29,  -29,  -29,
      -29,  -29,  -29,  -29

    },

    {
       23,  -30,  -30,  -30,  -30,  -30,  -30,  -30,   80,  -30,
      -30,  -30,  -30,  -30,  -30,  -30,  -30,  -30,  -30,  -30,
       81,   81,   81,   81,  -30,  -30,  -30,  -30,  -30,  -30,
       82,   82,   82,   82,   82,   82,   82,   82,  -30,   82,
       82,   82,  -30,  -30
    },

    {
       23,  -31,  -31,  -31,  -31,   78,  -31,   78,  -31,   78,
       78,  -31,  -31,  -31,   78,   78,  -31,   78,  -31,   78,
      -31,  -31,  -31,  -31,  -31,  -31,   78,   78,   78,   78,
      -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,
      -31,  -31,  -31,  -31

    },

    {
       23,  -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,
      -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,
      -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,
      -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,  -32,
      -32,  -32,  -32,  -32
    },

    {
       23,  -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,
      -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,
      -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,
      -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,  -33,
      -33,  -33,  -33,  -33

    },

    {
       23,  -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,
      -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,
      -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,
      -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,  -34,
      -34,  -34,  -34,  -34
    },

    {
       23,  -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,
      -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,
      -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,
      -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,  -35,
      -35,  -35,  -35,  -35

    },

    {
       23,  -36,  -36,  -36,  -36,   78,  -36,   78,  -36,   78,
       78,  -36,  -36,  -36,   78,   78,  -36,   83,  -36,   78,
      -36,  -36,  -36,  -36,  -36,  -36,   78,   78,   78,   78,
      -36,  -36,  -36,  -36,  -36,  -36,  -36,  -36,  -36,  -36,
      -36,  -36,  -36,  -36
    },

    {
       23,  -37,  -37,  -37,  -37,  -37,  -37,  -37,  -37,  -37,
      -37,  -37,  -37,  -37,  -37,  -37,  -37,  -37,   84,  -37,
       85,   85,   85,   85,  -37,  -37,  -37,  -37,  -37,  -37,
      -37,  -37,  -37,  -37,  -37,  -37,  -37,  -37,  -37,  -37,
      -37,  -37,  -37,  -37

    },

    {
       23,  -38,  -38,  -38,  -38,   78,  -38,   78,  -38,   78,
       78,  -38,  -38,  -38,   86,   78,  -38,   78,  -38,   78,
      -38,  -38,  -38,  -38,  -38,  -38,   78,   78,   78,   78,
      -38,  -38,  -38,  -38,  -38,  -38,  -38,  -38,  -38,  -38,
      -38,  -38,  -38,  -38
    },

    {
       23,  -39,  -39,  -39,  -39,  -39,  -39,  -39,  -39,  -39,
      -39,  -39,  -39,  -39,  -39,  -39,  -39,  -39,   87,  -39,
       88,   88,   88,   88,  -39,  -39,  -39,  -39,  -39,  -39,
       89,   90,   91,   89,   89,   92,   89,   93,  -39,   94,
       89,   93,  -39,  -39

    },

    {
       23,  -40,  -40,  -40,  -40,  -40,  -40,  -40,  -40,  -40,
      -40,  -40,  -40,  -40,  -40,  -40,  -40,  -40,   87,  -40,
       88,   88,   88,   88,  -40,  -40,  -40,  -40,  -40,  -40,
       89,   89,   91,   89,   89,   89,   89,   89,  -40,   94,
       89,   89,  -40,  -40
    },

    {
       23,  -41,  -41,  -41,  -41,  -41,   95,  -41,  -41,  -41,
      -41,   96,  -41,  -41,  -41,  -41,  -41,  -41,  -41,  -41,
       97,   97,   97,   97,   98,  -41,  -41,   99,  -41,  -41,
       97,   97,   97,   97,   97,   97,   97,   97,  -41,   97,
       97,   97,  100,  -41

    },

    {
       23,  -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,
      -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,
      -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,
      -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,  -42,
      -42,  -42,  -42,  -42
    },

    {
       23,  -43,  -43,  -43,  -43,   78,  -43,   78,  -43,   78,
       78,  -43,  -43,  -43,   78,   78,  -43,   78,  -43,   78,
      -43,  -43,  -43,  -43,  -43,  -43,   78,  101,  102,   78,
      -43,  -43,  -43,  -43,  -43,  -43,  -43,  -43,  -43,  -43,
      -43,  -43,  -43,  -43

    },

    {
       23,  -44,  -44,  -44,  -44,   78,  -44,   78,  -44,   78,
       78,  -44,  -44,  -44,   78,   78,  -44,   78,  -44,   78,
      -44,  -44,  -44,  -44,  -44,  -44,   78,   78,  103,   78,
      -44,  -44,  -44,  -44,  -44,  -44,  -44,  -44,  -44,  -44,
      -44,  -44,  -44,  -44
    },

    {
       23,  -45,  -45,  -45,  -45,   78,  -45,   78,  -45,   78,
       78,  -45,  -45,  -45,   78,   78,  -45,   78,  -45,   78,
      -45,  -45,  -45,  -45,  -45,  -45,   78,  104,   78,   78,
      -45,  -45,  -45,  -45,  -45,  -45,  -45,  -45,  -45,  -45,
      -45,  -45,  -45,  -45

    },

    {
       23,  -46,  -46,  -46,  -46,  -46,  -46,  -46,  105,  -46,
      -46,  -46,  -46,  -46,  -46,  -46,  -46,  -46,  -46,  -46,
      105,  105,  105,  105,  -46,  -46,  -46,  -46,  -46,  -46,
      105,  105,  105,  105,  105,  105,  105,  105,  -46,  105,
      105,  105,  -46,  -46
    },

    {
       23,  -47,  -47,  -47,  -47,  -47,  -47,  -47,  105,  -47,
      -47,  106,  -47,  -47,  -47,  -47,  -47,  -47,  -47,  -47,
      105,  105,  105,  105,  -47,  -47,  -47,  -47,  -47,  -47,
      105,  105,  105,  105,  105,  105,  105,  105,  -47,  105,
      105,  105,  -47,  -47

    },

    {
       23,  -48,  -48,  -48,  -48,  -48,  -48,  -48,  105,  -48,
      -48,  107,  -48,  -48,  -48,  -48,  -48,  -48,  -48,  -48,
      105,  105,  105,  105,  -48,  -48,  -48,  -48,  -48,  -48,
      105,  105,  105,  105,  105,  105,  105,  105,  -48,  105,
      105,  105,  -48,  -48
    },

    {
       23,  -49,  -49,  -49,  -49,  -49,  -49,  -49,  105,  -49,
      -49,  108,  -49,  -49,  -49,  -49,  -49,  -49,  -49,  -49,
      105,  105,  105,  105,  -49,  -49,  -49,  -49,  -49,  -49,
      105,  105,  105,  105,  105,  105,  105,  105,  -49,  105,
      105,  105,  -49,  -49

    },

    {
       23,  -50,  -50,  -50,  -50,  -50,  -50,  -50,  105,  -50,
      109,  -50,  -50,  -50,  -50,  -50,  -50,  -50,  -50,  -50,
      105,  105,  105,  105,  -50,  -50,  -50,  -50,  -50,  -50,
      105,  105,  105,  105,  105,  105,  105,  105,  -50,  105,
      105,  105,  -50,  -50
    },

    {
       23,  -51,  -51,  -51,  -51,  -51,  -51,  -51,  105,  -51,
      -51,  110,  -51,  -51,  -51,  -51,  -51,  -51,  -51,  -51,
      105,  105,  105,  105,  -51,  -51,  -51,  -51,  -51,  -51,
      105,  105,  105,  105,  105,  105,  105,  105,  -51,  105,
      105,  105,  -51,  -51

    },

    {
       23,  -52,  -52,  -52,  -52,  -52,  -52,  -52,  -52,  -52,
      -52,  -52,  -52,  -52,  -52,  -52,  -52,  -52,  -52,  -52,
      -52,  -52,  -52,  -52,  111,  111,  -52,  -52,  -52,  -52,
      -52,  -52,  -52,  -52,  -52,  -52,  -52,  -52,  -52,  -52,
      -52,  -52,  -52,  -52
    },

    {
       23,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  -53,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112

    },

    {
       23,  -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,
      -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,
      -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,
      -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,  -54,
      -54,  -54,  -54,  -54
    },

    {
       23,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  -55,  113,  113,  113,  113,  -55,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113

    },

    {
       23,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  -56,  113,  113,  113,  113,  -56,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113
    },

    {
       23,  -57,  -57,  -57,  -57,  -57,  -57,  -57,  -57,  -57,
      -57,  -57,  -57,  -57,  114,  -57,  -57,  -57,  -57,  115,
      -57,  -57,  -57,  -57,  -57,  -57,  -57,  -57,  -57,  -57,
      -57,  -57,  -57,  -57,  -57,  -57,  -57,  -57,  -57,  -57,
      -57,  -57,  -57,  -57

    },

    {
       23,  -58,  -58,  -58,  -58,  -58,  -58,  -58,  -58,  -58,
      -58,  -58,  -58,  -58,  116,  -58,  -58,  -58,  -58,  -58,
      -58,  -58,  -58,  -58,  -58,  -58,  -58,  -58,  -58,  -58,
      -58,  -58,  -58,  -58,  -58,  -58,  -58,  -58,  -58,  -58,
      -58,  -58,  -58,  -58
    },

    {
       23,  117,  117,  117,  117,  117,  -59,  117,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,  117

    },

    {
       23,  -60,  -60,  -60,  -60,  -60,  118,  -60,  -60,  -60,
      -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,
      -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,
      -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60,
      -60,  -60,  -60,  -60
    },

    {
       23,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  -61,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119

    },

    {
       23,  120,  120,  120,  120,  120,  120,  120,  120,  120,
      120,  -62,  120,  120,  120,  120,  120,  120,  120,  120,
      120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
      120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
      120,  120,  120,  120
    },

    {
       23,  -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,
      -63,  121,  -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,
      -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,
      -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,  -63,
      -63,  -63,  -63,  -63

    },

    {
       23,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
      -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
      -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
      -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
      -64,  -64,  -64,  -64
    },

    {
       23,  -65,  122,  123,  123,  -65,  -65,  -65,  -65,  -65,
      -65,  -65,  -65,  -65,  -65,  -65,  -65,  124,  -65,  -65,
      -65,  -65,  -65,  -65,  -65,  -65,  -65,  -65,  -65,  -65,
      -65,  -65,  -65,  -65,  -65,  -65,  -65,  -65,  -65,  -65,
      -65,  -65,  -65,  -65

    },

    {
       23,  -66,  125,  125,  125,  -66,  -66,  -66,  -66,  -66,
      -66,  126,  -66,  -66,  -66,  -66,  -66,  127,  -66,  -66,
      -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
      -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
      -66,  -66,  -66,  -66
    },

    {
       23,  -67,  125,  125,  125,  -67,  -67,  -67,  -67,  -67,
      -67,  126,  -67,  -67,  -67,  -67,  -67,  127,  -67,  -67,
      -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,
      -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,
      -67,  -67,  -67,  -67

    },

    {
       23,  -68,  -68,  -68,  -68,  -68,  -68,  -68,  -68,  -68,
      -68,  -68,  -68,  -68,  -68,  -68,  -68,  128,  -68,  -68,
      -68,  -68,  -68,  -68,  -68,  -68,  -68,  -68,  -68,  -68,
      -68,  -68,  -68,  -68,  -68,  -68,  -68,  -68,  -68,  -68,
      -68,  -68,  -68,  -68
    },

    {
       23,  129,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  -69,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  129,  129,  129,  129,  129,  129,  129,  -69,  129,
      129,  129,  129,  129

    },

    {
       23,  129,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  -70,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  129,  129,  129,  129,  129,  129,  129,  -70,  129,
      129,  129,  129,  129
    },

    {
       23,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,
      -71,  121,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,
      -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,
      -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  -71,
      -71,  -71,  -71,  -71

    },

    {
       23,  130,  130,  130,  130,  130,  130,  130,  130,  130,
      130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
      131,  131,  131,  130,  130,  130,  130,  130,  130,  130,
      130,  130,  130,  130,  130,  130,  132,  130,  130,  130,
      133,  134,  130,  130
    },

    {
       23,  135,  135,  135,  135,  135,  135,  135,  -73,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135

    },

    {
       23,  135,  135,  135,  135,  135,  135,  135,  -74,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135
    },

    {
       23,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  136,  -75,
      -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,
      -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,
      137,  137,  137,  137,  137,  137,  137,  137,  -75,  137,
      137,  137,  -75,  -75

    },

    {
       23,  -76,  -76,  -76,  -76,  -76,  118,  -76,  -76,  -76,
      -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,
      -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,
      -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,
      -76,  -76,  -76,  -76
    },

    {
       23,  -77,   77,   77,   77,  -77,  -77,  -77,  -77,  -77,
      -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,
      -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,
      -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,  -77,
      -77,  -77,  -77,  -77

    },

    {
       23,  -78,  -78,  -78,  -78,   78,  -78,   78,  -78,   78,
       78,  -78,  -78,  -78,   78,   78,  -78,   78,  -78,   78,
      -78,  -78,  -78,  -78,  -78,  -78,   78,   78,   78,   78,
      -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,
      -78,  -78,  -78,  -78
    },

    {
       23,  -79,  -79,  -79,  -79,   78,  -79,   78,  -79,   78,
       78,  -79,  -79,  -79,   78,   78,  -79,   78,  -79,   78,
      -79,  -79,  -79,  -79,  -79,  -79,   78,   78,   78,   78,
      -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,
      -79,  -79,  -79,  -79

    },

    {
       23,  -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,
      -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,
      -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,
      -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,  -80,
      -80,  -80,  -80,  -80
    },

    {
       23,  -81,  -81,  -81,  -81,  -81,  -81,  -81,  -81,  -81,
      -81,  -81,  -81,  -81,  -81,  -81,  -81,  -81,  -81,  -81,
       81,   81,   81,   81,  -81,  -81,  -81,  -81,  -81,  -81,
      138,  138,  138,  138,  138,  138,  138,  138,  -81,  138,
      138,  138,  -81,  -81

    },

    {
       23,  -82,  -82,  -82,  -82,  -82,  -82,  -82,   80,  -82,
      -82,  -82,  -82,  -82,  -82,  -82,  -82,  -82,  -82,  -82,
      139,  139,  139,  139,  -82,  -82,  -82,  -82,  -82,  -82,
      139,  139,  139,  139,  139,  139,  139,  139,  -82,  139,
      139,  139,  -82,  -82
    },

    {
       23,  140,  140,  -83,  -83,  141,  140,  141,  140,  141,
      141,  140,  140,  140,  141,  141,  140,  141,  140,  141,
      140,  140,  140,  140,  140,  140,  141,  141,  141,  141,
      140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140

    },

    {
       23,  -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,
      -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,
      -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,
      -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,  -84,
      -84,  -84,  -84,  -84
    },

    {
       23,  -85,  -85,  -85,  -85,  -85,  -85,  -85,  -85,  -85,
      -85,  -85,  -85,  -85,  -85,  -85,  -85,  -85,  -85,  -85,
      142,  142,  142,  142,  -85,  -85,  -85,  -85,  -85,  -85,
      143,  143,  144,  143,  143,  143,  143,  143,  -85,  145,
      143,  143,  -85,  -85

    },

    {
       23,  -86,  -86,  -86,  -86,  146,  -86,  146,  -86,  146,
      146,  -86,  -86,  -86,  146,  146,  -86,  146,  -86,  146,
      -86,  -86,  -86,  -86,  -86,  -86,  146,  146,  146,  146,
      -86,  -86,  -86,  -86,  -86,  -86,  -86,  -86,  -86,  -86,
      -86,  -86,  -86,  -86
    },

    {
       23,  -87,  -87,  -87,  -87,  -87,  -87,  -87,  -87,  -87,
      -87,  -87,  -87,  -87,  -87,  -87,  -87,  -87,  147,  -87,
      148,  148,  148,  148,  -87,  -87,  -87,  -87,  -87,  -87,
      143,  143,  144,  143,  143,  143,  143,  143,  -87,  143,
      143,  143,  -87,  -87

    },

    {
       23,  -88,  -88,  -88,  -88,  -88,  -88,  -88,  -88,  -88,
      -88,  -88,  -88,  -88,  -88,  -88,  -88,  -88,   87,  -88,
       88,   88,   88,   88,  -88,  -88,  -88,  -88,  -88,  -88,
       89,   89,   91,   89,   89,   89,   89,   89,  -88,   94,
       89,   89,  -88,  -88
    },

    {
       23,  -89,  -89,  -89,  -89,  -89,  -89,  -89,  149,  -89,
      -89,  -89,  -89,  -89,  -89,  -89,  -89,  -89,  -89,  -89,
      149,  149,  149,  149,  -89,  -89,  -89,  -89,  -89,  -89,
      149,  149,  149,  149,  149,  149,  149,  149,  -89,  149,
      149,  149,  -89,  -89

    },

    {
       23,  -90,  -90,  -90,  -90,  -90,  -90,  -90,  149,  -90,
      -90,  -90,  -90,  -90,  -90,  -90,  -90,  -90,  -90,  -90,
      150,  150,  149,  149,  -90,  -90,  -90,  -90,  -90,  -90,
      149,  149,  149,  149,  149,  149,  149,  149,  -90,  151,
      149,  149,  -90,  -90
    },

    {
       23,  -91,  -91,  -91,  -91,  -91,  -91,  -91,  149,  -91,
      -91,  -91,  -91,  -91,  -91,  152,  -91,  152,  -91,  -91,
      153,  153,  153,  153,  -91,  -91,  -91,  -91,  -91,  -91,
      149,  149,  149,  149,  149,  149,  149,  149,  -91,  149,
      149,  149,  -91,  -91

    },

    {
       23,  -92,  -92,  -92,  -92,  -92,  -92,  -92,  149,  -92,
      -92,  -92,  -92,  -92,  -92,  -92,  -92,  -92,  -92,  -92,
      154,  154,  154,  149,  -92,  -92,  -92,  -92,  -92,  -92,
      149,  149,  149,  149,  149,  149,  149,  149,  -92,  155,
      149,  149,  -92,  -92
    },

    {
       23,  -93,  -93,  -93,  -93,  -93,  -93,  -93,  149,  -93,
      -93,  -93,  -93,  -93,  -93,  -93,  -93,  -93,  -93,  -93,
      156,  156,  156,  156,  -93,  -93,  -93,  -93,  -93,  -93,
      156,  156,  156,  149,  149,  149,  149,  149,  -93,  157,
      149,  149,  -93,  -93

    },

    {
       23,  -94,  -94,  -94,  -94,  -94,  -94,  -94,  149,  -94,
      -94,  -94,  -94,  -94,  -94,  -94,  -94,  -94,  -94,  -94,
      158,  158,  158,  158,  -94,  -94,  -94,  -94,  -94,  -94,
      149,  149,  149,  149,  149,  149,  149,  149,  -94,  149,
      149,  149,  -94,  -94
    },

    {
       23,  -95,  -95,  -95,  -95,  -95,  -95,  -95,  -95,  -95,
      -95,  -95,  -95,  -95,  -95,  -95,  -95,  -95,  -95,  -95,
      159,  159,  159,  159,  -95,  -95,  -95,  -95,  -95,  -95,
      159,  159,  159,  159,  159,  159,  159,  159,  -95,  159,
      159,  159,  -95,  -95

    },

    {
       23,  -96,  -96,  -96,  -96,  -96,  -96,  -96,  -96,  -96,
      -96,  -96,  -96,  -96,  -96,  -96,  -96,  -96,  -96,  -96,
      160,  160,  160,  160,  -96,  -96,  -96,  -96,  -96,  -96,
      160,  160,  160,  160,  160,  160,  160,  160,  -96,  160,
      160,  160,  -96,  -96
    },

    {
       23,  -97,  -97,  -97,  -97,  -97,  -97,  -97,  -97,  -97,
      -97,  -97,  -97,  -97,  -97,  -97,  -97,  -97,  -97,  -97,
       97,   97,   97,   97,  -97,  -97,  -97,  -97,  -97,  -97,
       97,   97,   97,   97,   97,   97,   97,   97,  -97,   97,
       97,   97,  -97,  -97

    },

    {
       23,  -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,
      -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,
      -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,
      -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,  -98,
      -98,  -98,  -98,  -98
    },

    {
       23,  -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,
      -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,
      -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,
      -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,  -99,
      -99,  -99,  -99,  -99

    },

    {
       23, -100, -100, -100, -100, -100, -100, -100, -100, -100,
     -100, -100, -100, -100, -100, -100, -100, -100, -100, -100,
     -100, -100, -100, -100, -100, -100, -100, -100, -100,  161,
     -100, -100, -100, -100, -100, -100, -100, -100, -100, -100,
     -100, -100, -100, -100
    },

    {
       23, -101, -101, -101, -101,   78, -101,   78, -101,   78,
       78, -101, -101, -101,   78,   78, -101,   78, -101,   78,
     -101, -101, -101, -101, -101, -101,   78,   78,   78,   78,
     -101, -101, -101, -101, -101, -101, -101, -101, -101, -101,
     -101, -101, -101, -101

    },

    {
       23, -102, -102, -102, -102,   78, -102,   78, -102,   78,
       78, -102, -102, -102,   78,   78, -102,   78, -102,   78,
     -102, -102, -102, -102, -102, -102,   78,   78,   78,   78,
     -102, -102, -102, -102, -102, -102, -102, -102, -102, -102,
     -102, -102, -102, -102
    },

    {
       23, -103, -103, -103, -103,   78, -103,   78, -103,   78,
       78, -103, -103, -103,   78,   78, -103,   78, -103,   78,
     -103, -103, -103, -103, -103, -103,   78,   78,   78,   78,
     -103, -103, -103, -103, -103, -103, -103, -103, -103, -103,
     -103, -103, -103, -103

    },

    {
       23, -104, -104, -104, -104,   78, -104,   78, -104,   78,
       78, -104, -104, -104,   78,   78, -104,   78, -104,   78,
     -104, -104, -104, -104, -104, -104,   78,   78,   78,   78,
     -104, -104, -104, -104, -104, -104, -104, -104, -104, -104,
     -104, -104, -104, -104
    },

    {
       23, -105, -105, -105, -105, -105, -105, -105,  105, -105,
     -105, -105, -105, -105, -105, -105, -105, -105, -105, -105,
      105,  105,  105,  105, -105, -105, -105, -105, -105, -105,
      105,  105,  105,  105,  105,  105,  105,  105, -105,  105,
      105,  105, -105, -105

    },

    {
       23, -106, -106, -106, -106, -106, -106, -106, -106, -106,
     -106, -106, -106, -106, -106, -106, -106, -106, -106, -106,
     -106, -106, -106, -106, -106, -106, -106, -106, -106, -106,
     -106, -106, -106, -106, -106, -106, -106, -106, -106, -106,
     -106, -106, -106, -106
    },

    {
       23, -107, -107, -107, -107, -107, -107, -107, -107, -107,
     -107, -107, -107, -107, -107, -107, -107, -107, -107, -107,
     -107, -107, -107, -107, -107, -107, -107, -107, -107, -107,
     -107, -107, -107, -107, -107, -107, -107, -107, -107, -107,
     -107, -107, -107, -107

    },

    {
       23, -108, -108, -108, -108, -108, -108, -108, -108, -108,
     -108, -108, -108, -108, -108, -108, -108, -108, -108, -108,
     -108, -108, -108, -108, -108, -108, -108, -108, -108, -108,
     -108, -108, -108, -108, -108, -108, -108, -108, -108, -108,
     -108, -108, -108, -108
    },

    {
       23, -109, -109, -109, -109, -109,  162, -109, -109, -109,
     -109,  163, -109, -109, -109, -109, -109, -109, -109, -109,
     -109, -109, -109, -109, -109, -109, -109, -109, -109, -109,
     -109, -109, -109, -109, -109, -109, -109, -109, -109, -109,
     -109, -109, -109, -109

    },

    {
       23, -110, -110, -110, -110, -110, -110, -110, -110, -110,
     -110, -110, -110, -110, -110, -110, -110, -110, -110, -110,
     -110, -110, -110, -110, -110, -110, -110, -110, -110, -110,
     -110, -110, -110, -110, -110, -110, -110, -110, -110, -110,
     -110, -110, -110, -110
    },

    {
       23, -111, -111, -111, -111, -111, -111, -111, -111, -111,
     -111, -111, -111, -111, -111, -111, -111, -111, -111, -111,
     -111, -111, -111, -111, -111, -111, -111, -111, -111, -111,
     -111, -111, -111, -111, -111, -111, -111, -111, -111, -111,
     -111, -111, -111, -111

    },

    {
       23,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112, -112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112
    },

    {
       23,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113, -113,  113,  113,  113,  113, -113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113

    },

    {
       23, -114, -114, -114, -114, -114, -114, -114, -114, -114,
     -114, -114, -114, -114,  114, -114, -114, -114, -114,  115,
     -114, -114, -114, -114, -114, -114, -114, -114, -114, -114,
     -114, -114, -114, -114, -114, -114, -114, -114, -114, -114,
     -114, -114, -114, -114
    },

    {
       23, -115, -115, -115, -115, -115, -115, -115, -115, -115,
     -115, -115, -115, -115, -115, -115, -115, -115, -115, -115,
     -115, -115, -115, -115, -115, -115, -115, -115, -115, -115,
     -115, -115, -115, -115, -115, -115, -115, -115, -115, -115,
     -115, -115, -115, -115

    },

    {
       23, -116, -116, -116, -116,  164, -116,  164, -116,  164,
      164, -116, -116, -116,  164,  164, -116,  164, -116,  164,
     -116, -116, -116, -116, -116, -116,  164,  164,  164,  164,
     -116, -116, -116, -116, -116, -116, -116, -116, -116, -116,
     -116, -116, -116, -116
    },

    {
       23,  117,  117,  117,  117,  117, -117,  117,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,  117

    },

    {
       23, -118, -118, -118, -118, -118, -118, -118, -118, -118,
     -118, -118, -118, -118, -118, -118, -118, -118, -118, -118,
     -118, -118, -118, -118, -118, -118, -118, -118, -118, -118,
     -118, -118, -118, -118, -118, -118, -118, -118, -118, -118,
     -118, -118, -118, -118
    },

    {
       23,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119, -119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119

    },

    {
       23,  120,  120,  120,  120,  120,  120,  120,  120,  120,
      120, -120,  120,  120,  120,  120,  120,  120,  120,  120,
      120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
      120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
      120,  120,  120,  120
    },

    {
       23, -121, -121, -121, -121, -121, -121, -121, -121, -121,
     -121, -121, -121, -121, -121, -121, -121, -121, -121, -121,
     -121, -121, -121, -121, -121, -121, -121, -121, -121, -121,
     -121, -121, -121, -121, -121, -121, -121, -121, -121, -121,
     -121, -121, -121, -121

    },

    {
       23, -122,  122,  123,  123, -122, -122, -122, -122, -122,
     -122, -122, -122, -122, -122, -122, -122,  124, -122, -122,
     -122, -122, -122, -122, -122, -122, -122, -122, -122, -122,
     -122, -122, -122, -122, -122, -122, -122, -122, -122, -122,
     -122, -122, -122, -122
    },

    {
       23, -123,  125,  125,  125, -123, -123, -123, -123, -123,
     -123,  126, -123, -123, -123, -123, -123,  127, -123, -123,
     -123, -123, -123, -123, -123, -123, -123, -123, -123, -123,
     -123, -123, -123, -123, -123, -123, -123, -123, -123, -123,
     -123, -123, -123, -123

    },

    {
       23, -124, -124, -124, -124, -124, -124, -124, -124, -124,
     -124, -124, -124, -124, -124, -124, -124,  128, -124, -124,
     -124, -124, -124, -124, -124, -124, -124, -124, -124, -124,
     -124, -124, -124, -124, -124, -124, -124, -124, -124, -124,
     -124, -124, -124, -124
    },

    {
       23, -125,  125,  125,  125, -125, -125, -125, -125, -125,
     -125,  126, -125, -125, -125, -125, -125,  127, -125, -125,
     -125, -125, -125, -125, -125, -125, -125, -125, -125, -125,
     -125, -125, -125, -125, -125, -125, -125, -125, -125, -125,
     -125, -125, -125, -125

    },

    {
       23, -126, -126, -126, -126, -126, -126, -126, -126, -126,
     -126, -126, -126, -126, -126, -126, -126, -126, -126, -126,
     -126, -126, -126, -126, -126, -126, -126, -126, -126, -126,
     -126, -126, -126, -126, -126, -126, -126, -126, -126, -126,
     -126, -126, -126, -126
    },

    {
       23, -127, -127, -127, -127, -127, -127, -127, -127, -127,
     -127, -127, -127, -127, -127, -127, -127,  165, -127, -127,
     -127, -127, -127, -127, -127, -127, -127, -127, -127, -127,
     -127, -127, -127, -127, -127, -127, -127, -127, -127, -127,
     -127, -127, -127, -127

    },

    {
       23,  166,  167,  123,  123,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  168,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166
    },

    {
       23,  129,  129,  129,  129,  129,  129,  129,  129,  129,
      129, -129,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
      129,  129,  129,  129,  129,  129,  129,  129, -129,  129,
      129,  129,  129,  129

    },

    {
       23, -130, -130, -130, -130, -130, -130, -130, -130, -130,
     -130, -130, -130, -130, -130, -130, -130, -130, -130, -130,
     -130, -130, -130, -130, -130, -130, -130, -130, -130, -130,
     -130, -130, -130, -130, -130, -130, -130, -130, -130, -130,
     -130, -130, -130, -130
    },

    {
       23, -131, -131, -131, -131, -131, -131, -131, -131, -131,
     -131, -131, -131, -131, -131, -131, -131, -131, -131, -131,
      169,  169,  169, -131, -131, -131, -131, -131, -131, -131,
     -131, -131, -131, -131, -131, -131, -131, -131, -131, -131,
     -131, -131, -131, -131

    },

    {
       23, -132, -132, -132, -132, -132, -132, -132, -132, -132,
     -132, -132, -132, -132, -132, -132, -132, -132, -132, -132,
      170,  170,  170,  170, -132, -132, -132, -132, -132, -132,
      170,  170,  170, -132, -132, -132, -132, -132, -132, -132,
     -132, -132, -132, -132
    },

    {
       23, -133, -133, -133, -133, -133, -133, -133, -133, -133,
     -133, -133, -133, -133, -133, -133, -133, -133, -133, -133,
      171,  171,  171,  171, -133, -133, -133, -133, -133, -133,
      171,  171,  171, -133, -133, -133, -133, -133, -133, -133,
     -133, -133, -133, -133

    },

    {
       23, -134, -134, -134, -134, -134, -134, -134, -134, -134,
     -134, -134, -134, -134, -134, -134, -134, -134, -134, -134,
      172,  172,  172,  172, -134, -134, -134, -134, -134, -134,
      172,  172,  172, -134, -134, -134, -134, -134, -134, -134,
     -134, -134, -134, -134
    },

    {
       23,  135,  135,  135,  135,  135,  135,  135, -135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135

    },

    {
       23, -136, -136, -136, -136, -136, -136, -136, -136, -136,
     -136, -136, -136, -136, -136, -136, -136, -136, -136, -136,
     -136, -136, -136, -136, -136, -136, -136, -136, -136, -136,
     -136, -136, -136, -136, -136, -136, -136, -136, -136, -136,
     -136, -136, -136, -136
    },

    {
       23, -137, -137, -137, -137, -137, -137, -137,  136, -137,
     -137, -137, -137, -137, -137, -137, -137, -137, -137, -137,
      173,  173,  173,  173, -137, -137, -137, -137, -137, -137,
      173,  173,  173,  173,  173,  173,  173,  173, -137,  173,
      173,  173, -137, -137

    },

    {
       23, -138, -138, -138, -138, -138, -138, -138,  174, -138,
     -138, -138, -138, -138, -138, -138, -138, -138, -138, -138,
      174,  174,  174,  174, -138, -138, -138, -138, -138, -138,
      174,  174,  174,  174,  174,  174,  174,  174, -138,  174,
      174,  174, -138, -138
    },

    {
       23, -139, -139, -139, -139, -139, -139, -139,   80, -139,
     -139, -139, -139, -139, -139, -139, -139, -139, -139, -139,
      139,  139,  139,  139, -139, -139, -139, -139, -139, -139,
      139,  139,  139,  139,  139,  139,  139,  139, -139,  139,
      139,  139, -139, -139

    },

    {
       23,  140,  140, -140, -140,  140,  140,  140,  140,  140,
      140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140
    },

    {
       23,  140,  140, -141, -141,  141,  140,  141,  140,  141,
      141,  140,  140,  140,  141,  141,  140,  141,  140,  141,
      140,  140,  140,  140,  140,  140,  141,  141,  141,  141,
      140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140

    },

    {
       23, -142, -142, -142, -142, -142, -142, -142, -142, -142,
     -142, -142, -142, -142, -142, -142, -142, -142, -142, -142,
      142,  142,  142,  142, -142, -142, -142, -142, -142, -142,
      143,  143,  144,  143,  143,  143,  143,  143, -142,  145,
      143,  143, -142, -142
    },

    {
       23, -143, -143, -143, -143, -143, -143, -143,  175, -143,
     -143, -143, -143, -143, -143, -143, -143, -143, -143, -143,
      175,  175,  175,  175, -143, -143, -143, -143, -143, -143,
      175,  175,  175,  175,  175,  175,  175,  175, -143,  175,
      175,  175, -143, -143

    },

    {
       23, -144, -144, -144, -144, -144, -144, -144,  175, -144,
     -144, -144, -144, -144, -144,  152, -144,  152, -144, -144,
      176,  176,  176,  176, -144, -144, -144, -144, -144, -144,
      175,  175,  175,  175,  175,  175,  175,  175, -144,  175,
      175,  175, -144, -144
    },

    {
       23, -145, -145, -145, -145, -145, -145, -145,  175, -145,
     -145, -145, -145, -145, -145, -145, -145, -145, -145, -145,
      177,  177,  177,  177, -145, -145, -145, -145, -145, -145,
      175,  175,  175,  175,  175,  175,  175,  175, -145,  175,
      175,  175, -145, -145

    },

    {
       23, -146, -146, -146, -146,  146, -146,  146, -146,  146,
      146, -146, -146, -146,  146,  146, -146,  146, -146,  146,
     -146, -146, -146, -146, -146, -146,  146,  146,  146,  146,
     -146, -146, -146, -146, -146, -146, -146, -146, -146, -146,
     -146, -146, -146, -146
    },

    {
       23, -147, -147, -147, -147, -147, -147, -147, -147, -147,
     -147, -147, -147, -147, -147, -147, -147, -147, -147, -147,
     -147, -147, -147, -147, -147, -147, -147, -147, -147, -147,
     -147, -147, -147, -147, -147, -147, -147, -147, -147, -147,
     -147, -147, -147, -147

    },

    {
       23, -148, -148, -148, -148, -148, -148, -148, -148, -148,
     -148, -148, -148, -148, -148, -148, -148, -148, -148, -148,
      178,  178,  178,  178, -148, -148, -148, -148, -148, -148,
      143,  143,  144,  143,  143,  143,  143,  143, -148,  179,
      143,  143, -148, -148
    },

    {
       23, -149, -149, -149, -149, -149, -149, -149,  149, -149,
     -149, -149, -149, -149, -149, -149, -149, -149, -149, -149,
      149,  149,  149,  149, -149, -149, -149, -149, -149, -149,
      149,  149,  149,  149,  149,  149,  149,  149, -149,  149,
      149,  149, -149, -149

    },

    {
       23, -150, -150, -150, -150, -150, -150, -150,  149, -150,
     -150, -150, -150, -150, -150, -150, -150, -150, -150, -150,
      150,  150,  149,  149, -150, -150, -150, -150, -150, -150,
      149,  149,  149,  149,  149,  149,  149,  149, -150,  180,
      149,  149, -150, -150
    },

    {
       23, -151, -151, -151, -151, -151, -151, -151,  149, -151,
     -151, -151, -151, -151, -151, -151, -151, -151, -151, -151,
      150,  150,  149,  149, -151, -151, -151, -151, -151, -151,
      149,  149,  149,  149,  149,  149,  149,  149, -151,  149,
      149,  149, -151, -151

    },

    {
       23, -152, -152, -152, -152, -152, -152, -152, -152, -152,
     -152, -152, -152, -152, -152, -152, -152, -152, -152, -152,
      181,  181,  181,  181, -152, -152, -152, -152, -152, -152,
     -152, -152, -152, -152, -152, -152, -152, -152, -152, -152,
     -152, -152, -152, -152
    },

    {
       23, -153, -153, -153, -153, -153, -153, -153,  149, -153,
     -153, -153, -153, -153, -153, -153, -153, -153, -153, -153,
      182,  182,  182,  182, -153, -153, -153, -153, -153, -153,
      183,  183,  183,  183,  183,  183,  183,  183, -153,  184,
      183,  183, -153, -153

    },

    {
       23, -154, -154, -154, -154, -154, -154, -154,  149, -154,
     -154, -154, -154, -154, -154, -154, -154, -154, -154, -154,
      154,  154,  154,  149, -154, -154, -154, -154, -154, -154,
      149,  149,  149,  149,  149,  149,  149,  149, -154,  185,
      149,  149, -154, -154
    },

    {
       23, -155, -155, -155, -155, -155, -155, -155,  149, -155,
     -155, -155, -155, -155, -155, -155, -155, -155, -155, -155,
      154,  154,  154,  149, -155, -155, -155, -155, -155, -155,
      149,  149,  149,  149,  149,  149,  149,  149, -155,  149,
      149,  149, -155, -155

    },

    {
       23, -156, -156, -156, -156, -156, -156, -156,  149, -156,
     -156, -156, -156, -156, -156, -156, -156, -156, -156, -156,
      156,  156,  156,  156, -156, -156, -156, -156, -156, -156,
      156,  156,  156,  149,  149,  149,  149,  149, -156,  186,
      149,  149, -156, -156
    },

    {
       23, -157, -157, -157, -157, -157, -157, -157,  149, -157,
     -157, -157, -157, -157, -157, -157, -157, -157, -157, -157,
      156,  156,  156,  156, -157, -157, -157, -157, -157, -157,
      156,  156,  156,  149,  149,  149,  149,  149, -157,  149,
      149,  149, -157, -157

    },

    {
       23, -158, -158, -158, -158, -158, -158, -158,  149, -158,
     -158, -158, -158, -158, -158, -158, -158, -158,   87, -158,
      158,  158,  158,  158, -158, -158, -158, -158, -158, -158,
      187,  187,  188,  187,  187,  187,  187,  187, -158,  189,
      187,  187, -158, -158
    },

    {
       23, -159, -159, -159, -159, -159,  190, -159, -159, -159,
     -159, -159, -159, -159, -159, -159, -159, -159, -159, -159,
      159,  159,  159,  159, -159, -159, -159, -159, -159, -159,
      159,  159,  159,  159,  159,  159,  159,  159, -159,  159,
      159,  159, -159, -159

    },

    {
       23, -160, -160, -160, -160, -160, -160, -160, -160, -160,
     -160,  191, -160, -160, -160, -160, -160, -160, -160, -160,
      160,  160,  160,  160, -160, -160, -160, -160, -160, -160,
      160,  160,  160,  160,  160,  160,  160,  160, -160,  160,
      160,  160, -160, -160
    },

    {
       23, -161, -161, -161, -161, -161, -161, -161, -161, -161,
     -161, -161, -161, -161, -161, -161, -161, -161, -161, -161,
      192,  192,  192,  192, -161, -161, -161, -161, -161, -161,
      192,  192,  192,  192,  192,  192,  192,  192, -161,  192,
      192,  192, -161, -161

    },

    {
       23, -162, -162, -162, -162, -162, -162, -162, -162, -162,
     -162, -162, -162, -162, -162, -162, -162, -162, -162, -162,
     -162, -162, -162, -162, -162, -162, -162, -162, -162, -162,
     -162, -162, -162, -162, -162, -162, -162, -162, -162, -162,
     -162, -162, -162, -162
    },

    {
       23, -163, -163, -163, -163, -163, -163, -163, -163, -163,
     -163, -163, -163, -163, -163, -163, -163, -163, -163, -163,
     -163, -163, -163, -163, -163, -163, -163, -163, -163, -163,
     -163, -163, -163, -163, -163, -163, -163, -163, -163, -163,
     -163, -163, -163, -163

    },

    {
       23, -164, -164, -164, -164,  164, -164,  164, -164,  164,
      164, -164, -164, -164,  164,  164, -164,  164, -164,  164,
     -164, -164, -164, -164, -164, -164,  164,  164,  164,  164,
     -164, -164, -164, -164, -164, -164, -164, -164, -164, -164,
     -164, -164, -164, -164
    },

    {
       23,  193,  194,  195,  195,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  196,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193

    },

    {
       23,  166,  167,  123,  123,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  168,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166
    },

    {
       23,  166,  167,  123,  123,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  168,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166

    },

    {
       23,  166,  167,  123,  123,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  197,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166
    },

    {
       23, -169, -169, -169, -169, -169, -169, -169, -169, -169,
     -169, -169, -169, -169, -169, -169, -169, -169, -169, -169,
      198,  198,  198, -169, -169, -169, -169, -169, -169, -169,
     -169, -169, -169, -169, -169, -169, -169, -169, -169, -169,
     -169, -169, -169, -169

    },

    {
       23, -170, -170, -170, -170, -170, -170, -170, -170, -170,
     -170, -170, -170, -170, -170, -170, -170, -170, -170, -170,
      199,  199,  199,  199, -170, -170, -170, -170, -170, -170,
      199,  199,  199, -170, -170, -170, -170, -170, -170, -170,
     -170, -170, -170, -170
    },

    {
       23, -171, -171, -171, -171, -171, -171, -171, -171, -171,
     -171, -171, -171, -171, -171, -171, -171, -171, -171, -171,
      200,  200,  200,  200, -171, -171, -171, -171, -171, -171,
      200,  200,  200, -171, -171, -171, -171, -171, -171, -171,
     -171, -171, -171, -171

    },

    {
       23, -172, -172, -172, -172, -172, -172, -172, -172, -172,
     -172, -172, -172, -172, -172, -172, -172, -172, -172, -172,
      201,  201,  201,  201, -172, -172, -172, -172, -172, -172,
      201,  201,  201, -172, -172, -172, -172, -172, -172, -172,
     -172, -172, -172, -172
    },

    {
       23, -173, -173, -173, -173, -173, -173, -173,  136, -173,
     -173, -173, -173, -173, -173, -173, -173, -173, -173, -173,
      173,  173,  173,  173, -173, -173, -173, -173, -173, -173,
      173,  173,  173,  173,  173,  173,  173,  173, -173,  173,
      173,  173, -173, -173

    },

    {
       23, -174, -174, -174, -174, -174, -174, -174,  174, -174,
     -174, -174, -174, -174, -174, -174, -174, -174, -174, -174,
      174,  174,  174,  174, -174, -174, -174, -174, -174, -174,
      174,  174,  174,  174,  174,  174,  174,  174, -174,  174,
      174,  174, -174, -174
    },

    {
       23, -175, -175, -175, -175, -175, -175, -175,  175, -175,
     -175, -175, -175, -175, -175, -175, -175, -175, -175, -175,
      175,  175,  175,  175, -175, -175, -175, -175, -175, -175,
      175,  175,  175,  175,  175,  175,  175,  175, -175,  175,
      175,  175, -175, -175

    },

    {
       23, -176, -176, -176, -176, -176, -176, -176,  175, -176,
     -176, -176, -176, -176, -176, -176, -176, -176, -176, -176,
      202,  202,  202,  202, -176, -176, -176, -176, -176, -176,
      203,  203,  203,  203,  203,  203,  203,  203, -176,  204,
      203,  203, -176, -176
    },

    {
       23, -177, -177, -177, -177, -177, -177, -177,  175, -177,
     -177, -177, -177, -177, -177, -177, -177, -177, -177, -177,
      177,  177,  177,  177, -177, -177, -177, -177, -177, -177,
      205,  205,  206,  205,  205,  205,  205,  205, -177,  207,
      205,  205, -177, -177

    },

    {
       23, -178, -178, -178, -178, -178, -178, -178, -178, -178,
     -178, -178, -178, -178, -178, -178, -178, -178, -178, -178,
      178,  178,  178,  178, -178, -178, -178, -178, -178, -178,
      143,  143,  144,  143,  143,  143,  143,  143, -178,  179,
      143,  143, -178, -178
    },

    {
       23, -179, -179, -179, -179, -179, -179, -179,  175, -179,
     -179, -179, -179, -179, -179, -179, -179, -179, -179, -179,
      208,  208,  208,  208, -179, -179, -179, -179, -179, -179,
      175,  175,  175,  175,  175,  175,  175,  175, -179,  175,
      175,  175, -179, -179

    },

    {
       23, -180, -180, -180, -180, -180, -180, -180,  149, -180,
     -180, -180, -180, -180, -180, -180, -180, -180, -180, -180,
      150,  150,  149,  149, -180, -180, -180, -180, -180, -180,
      149,  149,  149,  149,  149,  149,  149,  149, -180,  149,
      149,  149, -180, -180
    },

    {
       23, -181, -181, -181, -181, -181, -181, -181, -181, -181,
     -181, -181, -181, -181, -181, -181, -181, -181, -181, -181,
      209,  209,  209,  209, -181, -181, -181, -181, -181, -181,
      210,  210,  210,  210,  210,  210,  210,  210, -181,  211,
      210,  210, -181, -181

    },

    {
       23, -182, -182, -182, -182, -182, -182, -182,  149, -182,
     -182, -182, -182, -182, -182, -182, -182, -182, -182, -182,
      182,  182,  182,  182, -182, -182, -182, -182, -182, -182,
      183,  183,  183,  183,  183,  183,  183,  183, -182,  184,
      183,  183, -182, -182
    },

    {
       23, -183, -183, -183, -183, -183, -183, -183,  212, -183,
     -183, -183, -183, -183, -183, -183, -183, -183, -183, -183,
      212,  212,  212,  212, -183, -183, -183, -183, -183, -183,
      212,  212,  212,  212,  212,  212,  212,  212, -183,  212,
      212,  212, -183, -183

    },

    {
       23, -184, -184, -184, -184, -184, -184, -184,  212, -184,
     -184, -184, -184, -184, -184, -184, -184, -184, -184, -184,
      213,  213,  213,  213, -184, -184, -184, -184, -184, -184,
      212,  212,  212,  212,  212,  212,  212,  212, -184,  212,
      212,  212, -184, -184
    },

    {
       23, -185, -185, -185, -185, -185, -185, -185,  149, -185,
     -185, -185, -185, -185, -185, -185, -185, -185, -185, -185,
      154,  154,  154,  149, -185, -185, -185, -185, -185, -185,
      149,  149,  149,  149,  149,  149,  149,  149, -185,  149,
      149,  149, -185, -185

    },

    {
       23, -186, -186, -186, -186, -186, -186, -186,  149, -186,
     -186, -186, -186, -186, -186, -186, -186, -186, -186, -186,
      156,  156,  156,  156, -186, -186, -186, -186, -186, -186,
      156,  156,  156,  149,  149,  149,  149,  149, -186,  149,
      149,  149, -186, -186
    },

    {
       23, -187, -187, -187, -187, -187, -187, -187,  149, -187,
     -187, -187, -187, -187, -187, -187, -187, -187, -187, -187,
      149,  149,  149,  149, -187, -187, -187, -187, -187, -187,
      149,  149,  149,  149,  149,  149,  149,  149, -187,  149,
      149,  149, -187, -187

    },

    {
       23, -188, -188, -188, -188, -188, -188, -188,  149, -188,
     -188, -188, -188, -188, -188,  152, -188,  152, -188, -188,
      153,  153,  153,  153, -188, -188, -188, -188, -188, -188,
      149,  149,  149,  149,  149,  149,  149,  149, -188,  149,
      149,  149, -188, -188
    },

    {
       23, -189, -189, -189, -189, -189, -189, -189,  149, -189,
     -189, -189, -189, -189, -189, -189, -189, -189, -189, -189,
      158,  158,  158,  158, -189, -189, -189, -189, -189, -189,
      149,  149,  149,  149,  149,  149,  149,  149, -189,  149,
      149,  149, -189, -189

    },

    {
       23, -190, -190, -190, -190, -190, -190, -190, -190, -190,
     -190, -190, -190, -190, -190, -190, -190, -190, -190, -190,
     -190, -190, -190, -190, -190, -190, -190, -190, -190, -190,
     -190, -190, -190, -190, -190, -190, -190, -190, -190, -190,
     -190, -190, -190, -190
    },

    {
       23, -191, -191, -191, -191, -191, -191, -191, -191, -191,
     -191, -191, -191, -191, -191, -191, -191, -191, -191, -191,
     -191, -191, -191, -191, -191, -191, -191, -191, -191, -191,
     -191, -191, -191, -191, -191, -191, -191, -191, -191, -191,
     -191, -191, -191, -191

    },

    {
       23, -192, -192, -192, -192, -192, -192, -192, -192, -192,
     -192, -192, -192, -192, -192, -192, -192, -192, -192, -192,
      192,  192,  192,  192, -192, -192, -192, -192, -192, -192,
      192,  192,  192,  192,  192,  192,  192,  192, -192,  192,
      192,  192, -192,  214
    },

    {
       23,  193,  194,  195,  195,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  196,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193

    },

    {
       23,  193,  194,  195,  195,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  196,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193
    },

    {
       23, -195,  125,  125,  125, -195, -195, -195, -195, -195,
     -195,  126, -195, -195, -195, -195, -195,  127, -195, -195,
     -195, -195, -195, -195, -195, -195, -195, -195, -195, -195,
     -195, -195, -195, -195, -195, -195, -195, -195, -195, -195,
     -195, -195, -195, -195

    },

    {
       23,  193,  194,  195,  195,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  215,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193
    },

    {
       23,  166,  167,  123,  123,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  197,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166

    },

    {
       23, -198, -198, -198, -198, -198, -198, -198, -198, -198,
     -198, -198, -198, -198, -198, -198, -198, -198, -198, -198,
     -198, -198, -198, -198, -198, -198, -198, -198, -198, -198,
     -198, -198, -198, -198, -198, -198, -198, -198, -198, -198,
     -198, -198, -198, -198
    },

    {
       23, -199, -199, -199, -199, -199, -199, -199, -199, -199,
     -199, -199, -199, -199, -199, -199, -199, -199, -199, -199,
      216,  216,  216,  216, -199, -199, -199, -199, -199, -199,
      216,  216,  216, -199, -199, -199, -199, -199, -199, -199,
     -199, -199, -199, -199

    },

    {
       23, -200, -200, -200, -200, -200, -200, -200, -200, -200,
     -200, -200, -200, -200, -200, -200, -200, -200, -200, -200,
      217,  217,  217,  217, -200, -200, -200, -200, -200, -200,
      217,  217,  217, -200, -200, -200, -200, -200, -200, -200,
     -200, -200, -200, -200
    },

    {
       23, -201, -201, -201, -201, -201, -201, -201, -201, -201,
     -201, -201, -201, -201, -201, -201, -201, -201, -201, -201,
     -201, -201, -201, -201, -201, -201, -201, -201, -201, -201,
     -201, -201, -201, -201, -201, -201, -201, -201, -201, -201,
     -201, -201, -201, -201

    },

    {
       23, -202, -202, -202, -202, -202, -202, -202,  175, -202,
     -202, -202, -202, -202, -202, -202, -202, -202, -202, -202,
      202,  202,  202,  202, -202, -202, -202, -202, -202, -202,
      203,  203,  203,  203,  203,  203,  203,  203, -202,  204,
      203,  203, -202, -202
    },

    {
       23, -203, -203, -203, -203, -203, -203, -203,  218, -203,
     -203, -203, -203, -203, -203, -203, -203, -203, -203, -203,
      218,  218,  218,  218, -203, -203, -203, -203, -203, -203,
      218,  218,  218,  218,  218,  218,  218,  218, -203,  218,
      218,  218, -203, -203

    },

    {
       23, -204, -204, -204, -204, -204, -204, -204,  218, -204,
     -204, -204, -204, -204, -204, -204, -204, -204, -204, -204,
      219,  219,  219,  219, -204, -204, -204, -204, -204, -204,
      218,  218,  218,  218,  218,  218,  218,  218, -204,  218,
      218,  218, -204, -204
    },

    {
       23, -205, -205, -205, -205, -205, -205, -205,  175, -205,
     -205, -205, -205, -205, -205, -205, -205, -205, -205, -205,
      175,  175,  175,  175, -205, -205, -205, -205, -205, -205,
      175,  175,  175,  175,  175,  175,  175,  175, -205,  175,
      175,  175, -205, -205

    },

    {
       23, -206, -206, -206, -206, -206, -206, -206,  175, -206,
     -206, -206, -206, -206, -206,  152, -206,  152, -206, -206,
      176,  176,  176,  176, -206, -206, -206, -206, -206, -206,
      175,  175,  175,  175,  175,  175,  175,  175, -206,  175,
      175,  175, -206, -206
    },

    {
       23, -207, -207, -207, -207, -207, -207, -207,  175, -207,
     -207, -207, -207, -207, -207, -207, -207, -207, -207, -207,
      177,  177,  177,  177, -207, -207, -207, -207, -207, -207,
      175,  175,  175,  175,  175,  175,  175,  175, -207,  175,
      175,  175, -207, -207

    },

    {
       23, -208, -208, -208, -208, -208, -208, -208,  175, -208,
     -208, -208, -208, -208, -208, -208, -208, -208, -208, -208,
      208,  208,  208,  208, -208, -208, -208, -208, -208, -208,
      205,  205,  206,  205,  205,  205,  205,  205, -208,  220,
      205,  205, -208, -208
    },

    {
       23, -209, -209, -209, -209, -209, -209, -209, -209, -209,
     -209, -209, -209, -209, -209, -209, -209, -209, -209, -209,
      209,  209,  209,  209, -209, -209, -209, -209, -209, -209,
      210,  210,  210,  210,  210,  210,  210,  210, -209,  211,
      210,  210, -209, -209

    },

    {
       23, -210, -210, -210, -210, -210, -210, -210,  221, -210,
     -210, -210, -210, -210, -210, -210, -210, -210, -210, -210,
      221,  221,  221,  221, -210, -210, -210, -210, -210, -210,
      221,  221,  221,  221,  221,  221,  221,  221, -210,  221,
      221,  221, -210, -210
    },

    {
       23, -211, -211, -211, -211, -211, -211, -211,  221, -211,
     -211, -211, -211, -211, -211, -211, -211, -211, -211, -211,
      222,  222,  222,  222, -211, -211, -211, -211, -211, -211,
      221,  221,  221,  221,  221,  221,  221,  221, -211,  221,
      221,  221, -211, -211

    },

    {
       23, -212, -212, -212, -212, -212, -212, -212,  212, -212,
     -212, -212, -212, -212, -212, -212, -212, -212, -212, -212,
      212,  212,  212,  212, -212, -212, -212, -212, -212, -212,
      212,  212,  212,  212,  212,  212,  212,  212, -212,  212,
      212,  212, -212, -212
    },

    {
       23, -213, -213, -213, -213, -213, -213, -213,  212, -213,
     -213, -213, -213, -213, -213, -213, -213, -213, -213, -213,
      213,  213,  213,  213, -213, -213, -213, -213, -213, -213,
      223,  223,  223,  223,  223,  223,  223,  223, -213,  224,
      223,  223, -213, -213

    },

    {
       23, -214, -214, -214, -214, -214, -214, -214, -214, -214,
     -214, -214, -214, -214, -214, -214, -214, -214, -214, -214,
     -214, -214, -214, -214, -214, -214, -214, -214, -214, -214,
     -214, -214, -214, -214, -214, -214, -214, -214, -214, -214,
     -214, -214, -214, -214
    },

    {
       23,  193,  194,  195,  195,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  215,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  193,  193

    },

    {
       23, -216, -216, -216, -216, -216, -216, -216, -216, -216,
     -216, -216, -216, -216, -216, -216, -216, -216, -216, -216,
      225,  225,  225,  225, -216, -216, -216, -216, -216, -216,
      225,  225,  225, -216, -216, -216, -216, -216, -216, -216,
     -216, -216, -216, -216
    },

    {
       23, -217, -217, -217, -217, -217, -217, -217, -217, -217,
     -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
      226,  226,  226,  226, -217, -217, -217, -217, -217, -217,
      226,  226,  226, -217, -217, -217, -217, -217, -217, -217,
     -217, -217, -217, -217

    },

    {
       23, -218, -218, -218, -218, -218, -218, -218,  218, -218,
     -218, -218, -218, -218, -218, -218, -218, -218, -218, -218,
      218,  218,  218,  218, -218, -218, -218, -218, -218, -218,
      218,  218,  218,  218,  218,  218,  218,  218, -218,  218,
      218,  218, -218, -218
    },

    {
       23, -219, -219, -219, -219, -219, -219, -219,  218, -219,
     -219, -219, -219, -219, -219, -219, -219, -219, -219, -219,
      219,  219,  219,  219, -219, -219, -219, -219, -219, -219,
      227,  227,  227,  227,  227,  227,  227,  227, -219,  228,
      227,  227, -219, -219

    },

    {
       23, -220, -220, -220, -220, -220, -220, -220,  175, -220,
     -220, -220, -220, -220, -220, -220, -220, -220, -220, -220,
      208,  208,  208,  208, -220, -220, -220, -220, -220, -220,
      175,  175,  175,  175,  175,  175,  175,  175, -220,  175,
      175,  175, -220, -220
    },

    {
       23, -221, -221, -221, -221, -221, -221, -221,  221, -221,
     -221, -221, -221, -221, -221, -221, -221, -221, -221, -221,
      221,  221,  221,  221, -221, -221, -221, -221, -221, -221,
      221,  221,  221,  221,  221,  221,  221,  221, -221,  221,
      221,  221, -221, -221

    },

    {
       23, -222, -222, -222, -222, -222, -222, -222,  221, -222,
     -222, -222, -222, -222, -222, -222, -222, -222, -222, -222,
      222,  222,  222,  222, -222, -222, -222, -222, -222, -222,
      229,  229,  229,  229,  229,  229,  229,  229, -222,  230,
      229,  229, -222, -222
    },

    {
       23, -223, -223, -223, -223, -223, -223, -223,  212, -223,
     -223, -223, -223, -223, -223, -223, -223, -223, -223, -223,
      212,  212,  212,  212, -223, -223, -223, -223, -223, -223,
      212,  212,  212,  212,  212,  212,  212,  212, -223,  212,
      212,  212, -223, -223

    },

    {
       23, -224, -224, -224, -224, -224, -224, -224,  212, -224,
     -224, -224, -224, -224, -224, -224, -224, -224, -224, -224,
      213,  213,  213,  213, -224, -224, -224, -224, -224, -224,
      212,  212,  212,  212,  212,  212,  212,  212, -224,  212,
      212,  212, -224, -224
    },

    {
       23, -225, -225, -225, -225, -225, -225, -225, -225, -225,
     -225, -225, -225, -225, -225, -225, -225, -225, -225, -225,
      231,  231,  231,  231, -225, -225, -225, -225, -225, -225,
      231,  231,  231, -225, -225, -225, -225, -225, -225, -225,
     -225, -225, -225, -225

    },

    {
       23, -226, -226, -226, -226, -226, -226, -226, -226, -226,
     -226, -226, -226, -226, -226, -226, -226, -226, -226, -226,
     -226, -226, -226, -226, -226, -226, -226, -226, -226, -226,
     -226, -226, -226, -226, -226, -226, -226, -226, -226, -226,
     -226, -226, -226, -226
    },

    {
       23, -227, -227, -227, -227, -227, -227, -227,  218, -227,
     -227, -227, -227, -227, -227, -227, -227, -227, -227, -227,
      218,  218,  218,  218, -227, -227, -227, -227, -227, -227,
      218,  218,  218,  218,  218,  218,  218,  218, -227,  218,
      218,  218, -227, -227

    },

    {
       23, -228, -228, -228, -228, -228, -228, -228,  218, -228,
     -228, -228, -228, -228, -228, -228, -228, -228, -228, -228,
      219,  219,  219,  219, -228, -228, -228, -228, -228, -228,
      218,  218,  218,  218,  218,  218,  218,  218, -228,  218,
      218,  218, -228, -228
    },

    {
       23, -229, -229, -229, -229, -229, -229, -229,  221, -229,
     -229, -229, -229, -229, -229, -229, -229, -229, -229, -229,
      221,  221,  221,  221, -229, -229, -229, -229, -229, -229,
      221,  221,  221,  221,  221,  221,  221,  221, -229,  221,
      221,  221, -229, -229

    },

    {
       23, -230, -230, -230, -230, -230, -230, -230,  221, -230,
     -230, -230, -230, -230, -230, -230, -230, -230, -230, -230,
      222,  222,  222,  222, -230, -230, -230, -230, -230, -230,
      221,  221,  221,  221,  221,  221,  221,  221, -230,  221,
      221,  221, -230, -230
    },

    {
       23, -231, -231, -231, -231, -231, -231, -231, -231, -231,
     -231, -231, -231, -231, -231, -231, -231, -231, -231, -231,
      232,  232,  232,  232, -231, -231, -231, -231, -231, -231,
      232,  232,  232, -231, -231, -231, -231, -231, -231, -231,
     -231, -231, -231, -231

    },

    {
       23, -232, -232, -232, -232, -232, -232, -232, -232, -232,
     -232, -232, -232, -232, -232, -232, -232, -232, -232, -232,
      233,  233,  233,  233, -232, -232, -232, -232, -232, -232,
      233,  233,  233, -232, -232, -232, -232, -232, -232, -232,
     -232, -232, -232, -232
    },

    {
       23, -233, -233, -233, -233, -233, -233, -233, -233, -233,
     -233, -233, -233, -233, -233, -233, -233, -233, -233, -233,
      226,  226,  226,  226, -233, -233, -233, -233, -233, -233,
      226,  226,  226, -233, -233, -233, -233, -233, -233, -233,
     -233, -233, -233, -233

    },

    } ;

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 83
#define YY_END_OF_BUFFER 84
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[234] =
    {   0,
        0,    0,   10,   10,    0,    0,    0,    0,    9,    9,
        0,    0,   18,   18,    0,    0,    0,    0,    0,    0,
        0,    0,   84,   82,    1,    1,   64,   35,   64,   82,
       63,   13,   50,   51,   63,   63,   63,   63,   67,   67,
       63,   52,   63,   63,   63,   81,   81,   81,   81,   81,
       81,   54,   10,   16,    5,    5,    6,    6,   40,   37,
        9,   21,   16,   19,   18,   18,   18,   18,   22,   22,
       16,   28,   32,   32,   34,   38,    1,   64,   49,   29,
       65,   30,    1,   43,   74,    2,   74,   67,   78,   73,
       78,   72,   71,   78,   60,   59,   55,   42,   44,   62,

       46,   48,   45,   47,   81,    8,   14,   12,   41,   11,
       53,   10,    5,    7,    4,    3,   40,   39,    9,   21,
       20,   18,   18,   18,   18,   17,   18,   18,   22,   25,
       26,   24,   24,   25,   32,   31,   33,   66,   30,    1,
        1,   74,   79,   79,   79,    2,   75,   74,   78,   70,
       73,   77,   76,   69,   72,   68,   71,   67,   60,   59,
       61,   36,   15,    3,   18,   18,   18,   18,   26,   24,
       24,   27,   33,   66,   79,   76,   74,   74,   79,   78,
       76,   76,   78,   78,   78,   78,   78,   78,   78,   57,
       56,   61,   18,   18,   18,   18,   18,   26,   24,   24,

       27,   76,   79,   79,   79,   79,   79,   74,   76,   80,
       80,   78,   76,   58,   18,   24,   24,   79,   76,   79,
       80,   76,   78,   78,   24,   23,   79,   79,   80,   80,
       24,   24,   24
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
       22,   22,   22,   22,   22,   23,   23,   24,   25,   26,
       27,   28,   29,    7,   30,   31,   30,   30,   32,   30,
       33,   33,   33,   33,   33,   33,   33,   34,   35,   33,
       33,   33,   33,   33,   36,   33,   33,   37,   33,   33,
       16,   38,   16,    9,   39,    7,   30,   31,   30,   30,

       32,   30,   33,   33,   33,   33,   33,   33,   33,   34,
       35,   33,   33,   33,   33,   33,   40,   33,   33,   41,
       33,   33,   42,    7,   43,    7,    1,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,

       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"

#line 44 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"

/* LCOV_EXCL_START */

#include "fe_utils/psqlscan_int.h"

/*
 * We must have a typedef YYSTYPE for yylex's first argument, but this lexer
 * doesn't presently make use of that argument, so just declare it as int.
 */
typedef int YYSTYPE;


/* Return values from yylex() */
#define LEXRES_EOL			0	/* end of input */
#define LEXRES_SEMI			1	/* command-terminating semicolon found */
#define LEXRES_BACKSLASH	2	/* backslash command start */


#define ECHO psqlscan_emit(cur_state, yytext, yyleng)

#line 2697 "psqlscan.c"
#define YY_NO_INPUT 1
/*
 * Set the type of yyextra; we use it as a pointer back to the containing
 * PsqlScanState.
 */
/*
 * All of the following definitions and rules should exactly match
 * src/backend/parser/scan.l so far as the flex patterns are concerned.
 * The rule bodies are just ECHO as opposed to what the backend does,
 * however.  (But be sure to duplicate code that affects the lexing process,
 * such as BEGIN() and yyless().)  Also, psqlscan uses a single <<EOF>> rule
 * whereas scan.l has a separate one for each exclusive state.
 */
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal byte string
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *
 * Note: we intentionally don't mimic the backend's <xeu> state; we have
 * no need to distinguish it from <xe> state, and no good way to get out
 * of it in error cases.  The backend just throws yyerror() in those
 * cases, but that's not an option here.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * non_newline_space tracks all space characters except newlines.
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {numericfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* Positional parameters don't accept underscores. */
/*
 * An identifier immediately following an integer literal is disallowed because
 * in some cases it's ambiguous what is meant: for example, 0x1234 could be
 * either a hexinteger or a decinteger "0" and an identifier "x1234".  We can
 * detect such problems by seeing if integer_junk matches a longer substring
 * than any of the XXXinteger patterns (decinteger, hexinteger, octinteger,
 * bininteger).  One "junk" pattern is sufficient because
 * {decinteger}{identifier} will match all the same strings we'd match with
 * {hexinteger}{identifier} etc.
 *
 * Note that the rule for integer_junk must appear after the ones for
 * XXXinteger to make this work correctly: 0x1234 will match both hexinteger
 * and integer_junk, and we need hexinteger to be chosen in that case.
 *
 * Also disallow strings matched by numeric_junk, real_junk and param_junk
 * for consistency.
 */
/* psql-specific: characters allowed in variable names */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 2879 "psqlscan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xqs 6
#define xe 7
#define xdolq 8
#define xui 9
#define xus 10

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE PsqlScanState

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 385 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"



#line 389 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
		/* Declare some local variables inside yylex(), for convenience */
		PsqlScanState cur_state = yyextra;
		PQExpBuffer output_buf = cur_state->output_buf;

		/*
		 * Force flex into the state indicated by start_state.  This has a
		 * couple of purposes: it lets some of the functions below set a new
		 * starting state without ugly direct access to flex variables, and it
		 * allows us to transition from one flex lexer to another so that we
		 * can lex different parts of the source string using separate lexers.
		 */
		BEGIN(cur_state->start_state);


#line 3178 "psqlscan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
yy_match:
		while ( (yy_current_state = yy_nxt[yy_current_state][ yy_ec[YY_SC_TO_UI(*yy_cp)]  ]) > 0 )
			++yy_cp;

		yy_current_state = -yy_current_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 403 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/*
					 * Note that the whitespace rule includes both true
					 * whitespace and single-line ("--" style) comments.
					 * We suppress whitespace until we have collected some
					 * non-whitespace data.  (This interacts with some
					 * decisions in MainLoop(); see there for details.)
					 */
					if (output_buf->len > 0)
						ECHO;
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 415 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					cur_state->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					ECHO;
				}
	YY_BREAK

case 3:
YY_RULE_SETUP
#line 424 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					cur_state->xcdepth++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
					ECHO;
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 431 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					if (cur_state->xcdepth <= 0)
						BEGIN(INITIAL);
					else
						cur_state->xcdepth--;
					ECHO;
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 439 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 443 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 447 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
/* <xc> */
case 8:
YY_RULE_SETUP
#line 452 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					BEGIN(xb);
					ECHO;
				}
	YY_BREAK
case 9:
/* rule 9 can match eol */
#line 457 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 457 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 461 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					BEGIN(xh);
					ECHO;
				}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 472 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					yyless(1);	/* eat only 'n' this time */
					ECHO;
				}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 477 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					if (cur_state->std_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					ECHO;
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 484 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					BEGIN(xe);
					ECHO;
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 488 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					BEGIN(xus);
					ECHO;
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 493 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					cur_state->state_before_str_stop = YYSTATE;
					BEGIN(xqs);
					ECHO;
				}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 506 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(cur_state->state_before_str_stop);
					ECHO;
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
#line 516 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 516 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(INITIAL);
					/* There's nothing to echo ... */
				}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 527 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 530 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 533 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 536 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 539 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 542 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 545 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 548 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 551 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* This is only needed for \ just before EOF */
					ECHO;
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 556 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					cur_state->dolqstart = pg_strdup(yytext);
					BEGIN(xdolq);
					ECHO;
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 561 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* throw back all but the initial "$" */
					yyless(1);
					ECHO;
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 566 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					if (strcmp(yytext, cur_state->dolqstart) == 0)
					{
						free(cur_state->dolqstart);
						cur_state->dolqstart = NULL;
						BEGIN(INITIAL);
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						yyless(yyleng - 1);
					}
					ECHO;
				}
	YY_BREAK
case 32:
/* rule 32 can match eol */
YY_RULE_SETUP
#line 584 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 587 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 590 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* This is only needed for $ inside the quoted text */
					ECHO;
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 595 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					BEGIN(xd);
					ECHO;
				}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 599 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					BEGIN(xui);
					ECHO;
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 603 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					BEGIN(INITIAL);
					ECHO;
				}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 607 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					BEGIN(INITIAL);
					ECHO;
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 611 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 40:
/* rule 40 can match eol */
YY_RULE_SETUP
#line 614 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 618 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* throw back all but the initial u/U */
					yyless(1);
					ECHO;
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 624 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 628 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 632 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 636 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 640 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 644 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 648 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 652 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
/*
	 * These rules are specific to psql --- they implement parenthesis
	 * counting and detection of command-ending semicolon.  These must
	 * appear before the {self} rule so that they take precedence over it.
	 */
case 50:
YY_RULE_SETUP
#line 662 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					cur_state->paren_depth++;
					ECHO;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 667 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					if (cur_state->paren_depth > 0)
						cur_state->paren_depth--;
					ECHO;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 673 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
					if (cur_state->paren_depth == 0 && cur_state->begin_depth == 0)
					{
						/* Terminate lexing temporarily */
						cur_state->start_state = YY_START;
						cur_state->identifier_count = 0;
						return LEXRES_SEMI;
					}
				}
	YY_BREAK
/*
	 * psql-specific rules to handle backslash commands and variable
	 * substitution.  We want these before {self}, also.
	 */
case 53:
YY_RULE_SETUP
#line 689 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* Force a semi-colon or colon into the query buffer */
					psqlscan_emit(cur_state, yytext + 1, 1);
					if (yytext[1] == ';')
						cur_state->identifier_count = 0;
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 696 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* Terminate lexing temporarily */
					cur_state->start_state = YY_START;
					return LEXRES_BACKSLASH;
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 702 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* Possible psql variable substitution */
					char	   *varname;
					char	   *value;

					varname = psqlscan_extract_substring(cur_state,
														 yytext + 1,
														 yyleng - 1);
					if (cur_state->callbacks->get_variable)
						value = cur_state->callbacks->get_variable(varname,
																   PQUOTE_PLAIN,
																   cur_state->cb_passthrough);
					else
						value = NULL;

					if (value)
					{
						/* It is a variable, check for recursion */
						if (psqlscan_var_is_current_source(cur_state, varname))
						{
							/* Recursive expansion --- don't go there */
							pg_log_warning("skipping recursive expansion of variable \"%s\"",
															  varname);
							/* Instead copy the string as is */
							ECHO;
						}
						else
						{
							/* OK, perform substitution */
							psqlscan_push_new_buffer(cur_state, value, varname);
							/* yy_scan_string already made buffer active */
						}
						free(value);
					}
					else
					{
						/*
						 * if the variable doesn't exist we'll copy the string
						 * as is
						 */
						ECHO;
					}

					free(varname);
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 748 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					psqlscan_escape_variable(cur_state, yytext, yyleng,
											 PQUOTE_SQL_LITERAL);
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 753 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					psqlscan_escape_variable(cur_state, yytext, yyleng,
											 PQUOTE_SQL_IDENT);
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 758 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					psqlscan_test_variable(cur_state, yytext, yyleng);
				}
	YY_BREAK
/*
	 * These rules just avoid the need for scanner backup if one of the
	 * three rules above fails to match completely.
	 */
case 59:
YY_RULE_SETUP
#line 767 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* Throw back everything but the colon */
					yyless(1);
					ECHO;
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 773 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* Throw back everything but the colon */
					yyless(1);
					ECHO;
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 779 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* Throw back everything but the colon */
					yyless(1);
					ECHO;
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 784 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* Throw back everything but the colon */
					yyless(1);
					ECHO;
				}
	YY_BREAK
/*
	 * Back to backend-compatible rules.
	 */
case 63:
YY_RULE_SETUP
#line 794 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 798 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
					}
					ECHO;
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 865 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 868 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 872 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 875 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 878 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 881 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 884 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 887 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 890 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 893 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 896 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					ECHO;
				}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 901 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 904 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 907 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 910 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 913 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 918 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					/*
					 * We need to track if we are inside a BEGIN .. END block
					 * in a function definition, so that semicolons contained
					 * therein don't terminate the whole statement.  Short of
					 * writing a full parser here, the following heuristic
					 * should work.  First, we track whether the beginning of
					 * the statement matches CREATE [OR REPLACE]
					 * {FUNCTION|PROCEDURE}
					 */

					if (cur_state->identifier_count == 0)
						memset(cur_state->identifiers, 0, sizeof(cur_state->identifiers));

					if (pg_strcasecmp(yytext, "create") == 0 ||
						pg_strcasecmp(yytext, "function") == 0 ||
						pg_strcasecmp(yytext, "procedure") == 0 ||
						pg_strcasecmp(yytext, "or") == 0 ||
						pg_strcasecmp(yytext, "replace") == 0)
					{
						if (cur_state->identifier_count < sizeof(cur_state->identifiers))
							cur_state->identifiers[cur_state->identifier_count] = pg_tolower((unsigned char) yytext[0]);
					}

					cur_state->identifier_count++;

					if (cur_state->identifiers[0] == 'c' &&
						(cur_state->identifiers[1] == 'f' || cur_state->identifiers[1] == 'p' ||
						 (cur_state->identifiers[1] == 'o' && cur_state->identifiers[2] == 'r' &&
						  (cur_state->identifiers[3] == 'f' || cur_state->identifiers[3] == 'p'))) &&
						cur_state->paren_depth == 0)
					{
						if (pg_strcasecmp(yytext, "begin") == 0)
							cur_state->begin_depth++;
						else if (pg_strcasecmp(yytext, "case") == 0)
						{
							/*
							 * CASE also ends with END.  We only need to track
							 * this if we are already inside a BEGIN.
							 */
							if (cur_state->begin_depth >= 1)
								cur_state->begin_depth++;
						}
						else if (pg_strcasecmp(yytext, "end") == 0)
						{
							if (cur_state->begin_depth > 0)
								cur_state->begin_depth--;
						}
					}

					ECHO;
				}
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 971 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					ECHO;
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(xb):
case YY_STATE_EOF(xc):
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xh):
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xqs):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xdolq):
case YY_STATE_EOF(xui):
case YY_STATE_EOF(xus):
#line 975 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
{
					if (cur_state->buffer_stack == NULL)
					{
						cur_state->start_state = YY_START;
						return LEXRES_EOL;		/* end of input reached */
					}

					/*
					 * We were expanding a variable, so pop the inclusion
					 * stack and keep lexing
					 */
					psqlscan_pop_buffer_stack(cur_state);
					psqlscan_select_top_buffer(cur_state);
				}
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 990 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 4099 "psqlscan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state = yy_nxt[yy_current_state][(*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1)];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	yy_current_state = yy_nxt[yy_current_state][1];
	yy_is_jam = (yy_current_state <= 0);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 990 "/build/postgresql/src/build/../postgresql-18.0/src/fe_utils/psqlscan.l"


/* LCOV_EXCL_STOP */

/*
 * Create a lexer working state struct.
 *
 * callbacks is a struct of function pointers that encapsulate some
 * behavior we need from the surrounding program.  This struct must
 * remain valid for the lifespan of the PsqlScanState.
 */
PsqlScanState
psql_scan_create(const PsqlScanCallbacks *callbacks)
{
	PsqlScanState state;

	state = (PsqlScanStateData *) pg_malloc0(sizeof(PsqlScanStateData));

	state->callbacks = callbacks;

	yylex_init(&state->scanner);

	yyset_extra(state, state->scanner);

	psql_scan_reset(state);

	return state;
}

/*
 * Destroy a lexer working state struct, releasing all resources.
 */
void
psql_scan_destroy(PsqlScanState state)
{
	psql_scan_finish(state);

	psql_scan_reset(state);

	yylex_destroy(state->scanner);

	free(state);
}

/*
 * Set the callback passthrough pointer for the lexer.
 *
 * This could have been integrated into psql_scan_create, but keeping it
 * separate allows the application to change the pointer later, which might
 * be useful.
 */
void
psql_scan_set_passthrough(PsqlScanState state, void *passthrough)
{
	state->cb_passthrough = passthrough;
}

/*
 * Set up to perform lexing of the given input line.
 *
 * The text at *line, extending for line_len bytes, will be scanned by
 * subsequent calls to the psql_scan routines.  psql_scan_finish should
 * be called when scanning is complete.  Note that the lexer retains
 * a pointer to the storage at *line --- this string must not be altered
 * or freed until after psql_scan_finish is called.
 *
 * encoding is the libpq identifier for the character encoding in use,
 * and std_strings says whether standard_conforming_strings is on.
 */
void
psql_scan_setup(PsqlScanState state,
				const char *line, int line_len,
				int encoding, bool std_strings)
{
	/* Mustn't be scanning already */
	Assert(state->scanbufhandle == NULL);
	Assert(state->buffer_stack == NULL);

	/* Do we need to hack the character set encoding? */
	state->encoding = encoding;
	state->safe_encoding = pg_valid_server_encoding_id(encoding);

	/* Save standard-strings flag as well */
	state->std_strings = std_strings;

	/* Set up flex input buffer with appropriate translation and padding */
	state->scanbufhandle = psqlscan_prepare_buffer(state, line, line_len,
												   &state->scanbuf);
	state->scanline = line;

	/* Set lookaside data in case we have to map unsafe encoding */
	state->curline = state->scanbuf;
	state->refline = state->scanline;

	/* Initialize state for psql_scan_get_location() */
	state->cur_line_no = 0;		/* yylex not called yet */
	state->cur_line_ptr = state->scanbuf;
}

/*
 * Do lexical analysis of SQL command text.
 *
 * The text previously passed to psql_scan_setup is scanned, and appended
 * (possibly with transformation) to query_buf.
 *
 * The return value indicates the condition that stopped scanning:
 *
 * PSCAN_SEMICOLON: found a command-ending semicolon.  (The semicolon is
 * transferred to query_buf.)  The command accumulated in query_buf should
 * be executed, then clear query_buf and call again to scan the remainder
 * of the line.
 *
 * PSCAN_BACKSLASH: found a backslash that starts a special command.
 * Any previous data on the line has been transferred to query_buf.
 * The caller will typically next apply a separate flex lexer to scan
 * the special command.
 *
 * PSCAN_INCOMPLETE: the end of the line was reached, but we have an
 * incomplete SQL command.  *prompt is set to the appropriate prompt type.
 *
 * PSCAN_EOL: the end of the line was reached, and there is no lexical
 * reason to consider the command incomplete.  The caller may or may not
 * choose to send it.  *prompt is set to the appropriate prompt type if
 * the caller chooses to collect more input.
 *
 * In the PSCAN_INCOMPLETE and PSCAN_EOL cases, psql_scan_finish() should
 * be called next, then the cycle may be repeated with a fresh input line.
 *
 * In all cases, *prompt is set to an appropriate prompt type code for the
 * next line-input operation.
 */
PsqlScanResult
psql_scan(PsqlScanState state,
		  PQExpBuffer query_buf,
		  promptStatus_t *prompt)
{
	PsqlScanResult result;
	int			lexresult;

	/* Must be scanning already */
	Assert(state->scanbufhandle != NULL);

	/* Set current output target */
	state->output_buf = query_buf;

	/* Set input source */
	if (state->buffer_stack != NULL)
		yy_switch_to_buffer(state->buffer_stack->buf, state->scanner);
	else
		yy_switch_to_buffer(state->scanbufhandle, state->scanner);

	/* And lex. */
	lexresult = yylex(NULL, state->scanner);

	/* Notify psql_scan_get_location() that a yylex call has been made. */
	if (state->cur_line_no == 0)
		state->cur_line_no = 1;

	/*
	 * Check termination state and return appropriate result info.
	 */
	switch (lexresult)
	{
		case LEXRES_EOL:		/* end of input */
			switch (state->start_state)
			{
				case INITIAL:
				case xqs:		/* we treat this like INITIAL */
					if (state->paren_depth > 0)
					{
						result = PSCAN_INCOMPLETE;
						*prompt = PROMPT_PAREN;
					}
					else if (state->begin_depth > 0)
					{
						result = PSCAN_INCOMPLETE;
						*prompt = PROMPT_CONTINUE;
					}
					else if (query_buf->len > 0)
					{
						result = PSCAN_EOL;
						*prompt = PROMPT_CONTINUE;
					}
					else
					{
						/* never bother to send an empty buffer */
						result = PSCAN_INCOMPLETE;
						*prompt = PROMPT_READY;
					}
					break;
				case xb:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_SINGLEQUOTE;
					break;
				case xc:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_COMMENT;
					break;
				case xd:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_DOUBLEQUOTE;
					break;
				case xh:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_SINGLEQUOTE;
					break;
				case xe:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_SINGLEQUOTE;
					break;
				case xq:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_SINGLEQUOTE;
					break;
				case xdolq:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_DOLLARQUOTE;
					break;
				case xui:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_DOUBLEQUOTE;
					break;
				case xus:
					result = PSCAN_INCOMPLETE;
					*prompt = PROMPT_SINGLEQUOTE;
					break;
				default:
					/* can't get here */
					fprintf(stderr, "invalid YY_START\n");
					exit(1);
			}
			break;
		case LEXRES_SEMI:		/* semicolon */
			result = PSCAN_SEMICOLON;
			*prompt = PROMPT_READY;
			break;
		case LEXRES_BACKSLASH:	/* backslash */
			result = PSCAN_BACKSLASH;
			*prompt = PROMPT_READY;
			break;
		default:
			/* can't get here */
			fprintf(stderr, "invalid yylex result\n");
			exit(1);
	}

	return result;
}

/*
 * Clean up after scanning a string.  This flushes any unread input and
 * releases resources (but not the PsqlScanState itself).  Note however
 * that this does not reset the lexer scan state; that can be done by
 * psql_scan_reset(), which is an orthogonal operation.
 *
 * It is legal to call this when not scanning anything (makes it easier
 * to deal with error recovery).
 */
void
psql_scan_finish(PsqlScanState state)
{
	/* Drop any incomplete variable expansions. */
	while (state->buffer_stack != NULL)
		psqlscan_pop_buffer_stack(state);

	/* Done with the outer scan buffer, too */
	if (state->scanbufhandle)
		yy_delete_buffer(state->scanbufhandle, state->scanner);
	state->scanbufhandle = NULL;
	if (state->scanbuf)
		free(state->scanbuf);
	state->scanbuf = NULL;
}

/*
 * Reset lexer scanning state to start conditions.  This is appropriate
 * for executing \r psql commands (or any other time that we discard the
 * prior contents of query_buf).  It is not, however, necessary to do this
 * when we execute and clear the buffer after getting a PSCAN_SEMICOLON or
 * PSCAN_EOL scan result, because the scan state must be INITIAL when those
 * conditions are returned.
 *
 * Note that this is unrelated to flushing unread input; that task is
 * done by psql_scan_finish().
 */
void
psql_scan_reset(PsqlScanState state)
{
	state->start_state = INITIAL;
	state->paren_depth = 0;
	state->xcdepth = 0;			/* not really necessary */
	if (state->dolqstart)
		free(state->dolqstart);
	state->dolqstart = NULL;
	state->identifier_count = 0;
	state->begin_depth = 0;
}

/*
 * Reselect this lexer (psqlscan.l) after using another one.
 *
 * Currently and for foreseeable uses, it's sufficient to reset to INITIAL
 * state, because we'd never switch to another lexer in a different state.
 * However, we don't want to reset e.g. paren_depth, so this can't be
 * the same as psql_scan_reset().
 *
 * Note: psql setjmp error recovery just calls psql_scan_reset(), so that
 * must be a superset of this.
 *
 * Note: it seems likely that other lexers could just assign INITIAL for
 * themselves, since that probably has the value zero in every flex-generated
 * lexer.  But let's not assume that.
 */
void
psql_scan_reselect_sql_lexer(PsqlScanState state)
{
	state->start_state = INITIAL;
}

/*
 * Return true if lexer is currently in an "inside quotes" state.
 *
 * This is pretty grotty but is needed to preserve the old behavior
 * that mainloop.c drops blank lines not inside quotes without even
 * echoing them.
 */
bool
psql_scan_in_quote(PsqlScanState state)
{
	return state->start_state != INITIAL &&
		state->start_state != xqs;
}

/*
 * Return the current scanning location (end+1 of last scanned token),
 * as a line number counted from 1 and an offset from string start.
 *
 * This considers only the outermost input string, and therefore is of
 * limited use for programs that use psqlscan_push_new_buffer().
 *
 * It would be a bit easier probably to use "%option yylineno" to count
 * lines, but the flex manual says that has a performance cost, and only
 * a minority of programs using psqlscan have need for this functionality.
 * So we implement it ourselves without adding overhead to the lexer itself.
 */
void
psql_scan_get_location(PsqlScanState state,
					   int *lineno, int *offset)
{
	const char *line_end;

	/*
	 * We rely on flex's having stored a NUL after the current token in
	 * scanbuf.  Therefore we must specially handle the state before yylex()
	 * has been called, when obviously that won't have happened yet.
	 */
	if (state->cur_line_no == 0)
	{
		*lineno = 1;
		*offset = 0;
		return;
	}

	/*
	 * Advance cur_line_no/cur_line_ptr past whatever has been lexed so far.
	 * Doing this prevents repeated calls from being O(N^2) for long inputs.
	 */
	while ((line_end = strchr(state->cur_line_ptr, '\n')) != NULL)
	{
		state->cur_line_no++;
		state->cur_line_ptr = line_end + 1;
	}
	state->cur_line_ptr += strlen(state->cur_line_ptr);

	/* Report current location. */
	*lineno = state->cur_line_no;
	*offset = state->cur_line_ptr - state->scanbuf;
}

/*
 * Push the given string onto the stack of stuff to scan.
 *
 * NOTE SIDE EFFECT: the new buffer is made the active flex input buffer.
 */
void
psqlscan_push_new_buffer(PsqlScanState state, const char *newstr,
						 const char *varname)
{
	StackElem  *stackelem;

	stackelem = (StackElem *) pg_malloc(sizeof(StackElem));

	/*
	 * In current usage, the passed varname points at the current flex input
	 * buffer; we must copy it before calling psqlscan_prepare_buffer()
	 * because that will change the buffer state.
	 */
	stackelem->varname = varname ? pg_strdup(varname) : NULL;

	stackelem->buf = psqlscan_prepare_buffer(state, newstr, strlen(newstr),
											 &stackelem->bufstring);
	state->curline = stackelem->bufstring;
	if (state->safe_encoding)
	{
		stackelem->origstring = NULL;
		state->refline = stackelem->bufstring;
	}
	else
	{
		stackelem->origstring = pg_strdup(newstr);
		state->refline = stackelem->origstring;
	}
	stackelem->next = state->buffer_stack;
	state->buffer_stack = stackelem;
}

/*
 * Pop the topmost buffer stack item (there must be one!)
 *
 * NB: after this, the flex input state is unspecified; caller must
 * switch to an appropriate buffer to continue lexing.
 * See psqlscan_select_top_buffer().
 */
void
psqlscan_pop_buffer_stack(PsqlScanState state)
{
	StackElem  *stackelem = state->buffer_stack;

	state->buffer_stack = stackelem->next;
	yy_delete_buffer(stackelem->buf, state->scanner);
	free(stackelem->bufstring);
	if (stackelem->origstring)
		free(stackelem->origstring);
	if (stackelem->varname)
		free(stackelem->varname);
	free(stackelem);
}

/*
 * Select the topmost surviving buffer as the active input.
 */
void
psqlscan_select_top_buffer(PsqlScanState state)
{
	StackElem  *stackelem = state->buffer_stack;

	if (stackelem != NULL)
	{
		yy_switch_to_buffer(stackelem->buf, state->scanner);
		state->curline = stackelem->bufstring;
		state->refline = stackelem->origstring ? stackelem->origstring : stackelem->bufstring;
	}
	else
	{
		yy_switch_to_buffer(state->scanbufhandle, state->scanner);
		state->curline = state->scanbuf;
		state->refline = state->scanline;
	}
}

/*
 * Check if specified variable name is the source for any string
 * currently being scanned
 */
bool
psqlscan_var_is_current_source(PsqlScanState state, const char *varname)
{
	StackElem  *stackelem;

	for (stackelem = state->buffer_stack;
		 stackelem != NULL;
		 stackelem = stackelem->next)
	{
		if (stackelem->varname && strcmp(stackelem->varname, varname) == 0)
			return true;
	}
	return false;
}

/*
 * Set up a flex input buffer to scan the given data.  We always make a
 * copy of the data.  If working in an unsafe encoding, the copy has
 * multibyte sequences replaced by FFs to avoid fooling the lexer rules.
 *
 * NOTE SIDE EFFECT: the new buffer is made the active flex input buffer.
 */
YY_BUFFER_STATE
psqlscan_prepare_buffer(PsqlScanState state, const char *txt, int len,
						char **txtcopy)
{
	char	   *newtxt;

	/* Flex wants two \0 characters after the actual data */
	newtxt = pg_malloc(len + 2);
	*txtcopy = newtxt;
	newtxt[len] = newtxt[len + 1] = YY_END_OF_BUFFER_CHAR;

	if (state->safe_encoding)
		memcpy(newtxt, txt, len);
	else
	{
		/* Gotta do it the hard way */
		int			i = 0;

		while (i < len)
		{
			int			thislen = PQmblen(txt + i, state->encoding);

			/* first byte should always be okay... */
			newtxt[i] = txt[i];
			i++;
			while (--thislen > 0 && i < len)
				newtxt[i++] = (char) 0xFF;
		}
	}

	return yy_scan_buffer(newtxt, len + 2, state->scanner);
}

/*
 * psqlscan_emit() --- body for ECHO macro
 *
 * NB: this must be used for ALL and ONLY the text copied from the flex
 * input data.  If you pass it something that is not part of the yytext
 * string, you are making a mistake.  Internally generated text can be
 * appended directly to state->output_buf.
 */
void
psqlscan_emit(PsqlScanState state, const char *txt, int len)
{
	PQExpBuffer output_buf = state->output_buf;

	if (state->safe_encoding)
		appendBinaryPQExpBuffer(output_buf, txt, len);
	else
	{
		/* Gotta do it the hard way */
		const char *reference = state->refline;
		int			i;

		reference += (txt - state->curline);

		for (i = 0; i < len; i++)
		{
			char		ch = txt[i];

			if (ch == (char) 0xFF)
				ch = reference[i];
			appendPQExpBufferChar(output_buf, ch);
		}
	}
}

/*
 * psqlscan_extract_substring --- fetch value of (part of) the current token
 *
 * This is like psqlscan_emit(), except that the data is returned as a
 * malloc'd string rather than being pushed directly to state->output_buf.
 */
char *
psqlscan_extract_substring(PsqlScanState state, const char *txt, int len)
{
	char	   *result = (char *) pg_malloc(len + 1);

	if (state->safe_encoding)
		memcpy(result, txt, len);
	else
	{
		/* Gotta do it the hard way */
		const char *reference = state->refline;
		int			i;

		reference += (txt - state->curline);

		for (i = 0; i < len; i++)
		{
			char		ch = txt[i];

			if (ch == (char) 0xFF)
				ch = reference[i];
			result[i] = ch;
		}
	}
	result[len] = '\0';
	return result;
}

/*
 * psqlscan_escape_variable --- process :'VARIABLE' or :"VARIABLE"
 *
 * If the variable name is found, escape its value using the appropriate
 * quoting method and emit the value to output_buf.  (Since the result is
 * surely quoted, there is never any reason to rescan it.)	If we don't
 * find the variable or escaping fails, emit the token as-is.
 */
void
psqlscan_escape_variable(PsqlScanState state, const char *txt, int len,
						 PsqlScanQuoteType quote)
{
	char	   *varname;
	char	   *value;

	/* Variable lookup. */
	varname = psqlscan_extract_substring(state, txt + 2, len - 3);
	if (state->callbacks->get_variable)
		value = state->callbacks->get_variable(varname, quote,
											   state->cb_passthrough);
	else
		value = NULL;
	free(varname);

	if (value)
	{
		/* Emit the suitably-escaped value */
		appendPQExpBufferStr(state->output_buf, value);
		free(value);
	}
	else
	{
		/* Emit original token as-is */
		psqlscan_emit(state, txt, len);
	}
}

void
psqlscan_test_variable(PsqlScanState state, const char *txt, int len)
{
	char	   *varname;
	char	   *value;

	varname = psqlscan_extract_substring(state, txt + 3, len - 4);
	if (state->callbacks->get_variable)
		value = state->callbacks->get_variable(varname, PQUOTE_PLAIN,
											   state->cb_passthrough);
	else
		value = NULL;
	free(varname);

	if (value != NULL)
	{
		appendPQExpBufferStr(state->output_buf, "TRUE");
		free(value);
	}
	else
	{
		appendPQExpBufferStr(state->output_buf, "FALSE");
	}
}

