/* PageWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PageWindow.vala, do not modify */

/*
* Copyright (c) 2018 elementary, Inc. (https://elementary.io),
                2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* PageWindow is a Gtk.Window with essential functions for hosting a Page.  There may be more than*/
/* one PageWindow in the system, and closing one does not imply exiting the application.*/
/**/
/* PageWindow offers support for hosting a single Page; multiple Pages must be handled by the*/
/* subclass.  A subclass should set current_page to the user-visible Page for it to receive*/
/* various notifications.  It is the responsibility of the subclass to notify Pages when they're*/
/* switched to and from, and other aspects of the Page interface.*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <handy.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PAGE_WINDOW_0_PROPERTY,
	PAGE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* page_window_properties[PAGE_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PageWindowPrivate {
	Page* current_page;
	gint busy_counter;
};

static gint PageWindow_private_offset;
static gpointer page_window_parent_class = NULL;

static void page_window_real_switched_pages (PageWindow* self,
                                      Page* old_page,
                                      Page* new_page);
static void page_window_real_set_current_page (PageWindow* self,
                                        Page* page);
static void page_window_real_clear_current_page (PageWindow* self);
static gboolean page_window_real_key_press_event (GtkWidget* base,
                                           GdkEventKey* event);
static gboolean page_window_real_key_release_event (GtkWidget* base,
                                             GdkEventKey* event);
static gboolean page_window_real_focus_in_event (GtkWidget* base,
                                          GdkEventFocus* event);
static gboolean page_window_real_focus_out_event (GtkWidget* base,
                                           GdkEventFocus* event);
static gboolean page_window_real_configure_event (GtkWidget* base,
                                           GdkEventConfigure* event);
static GObject * page_window_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void page_window_finalize (GObject * obj);
static GType page_window_get_type_once (void);

static inline gpointer
page_window_get_instance_private (PageWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PageWindow_private_offset);
}

static void
page_window_real_switched_pages (PageWindow* self,
                                 Page* old_page,
                                 Page* new_page)
{
}

void
page_window_switched_pages (PageWindow* self,
                            Page* old_page,
                            Page* new_page)
{
	PageWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_WINDOW_GET_CLASS (self);
	if (_klass_->switched_pages) {
		_klass_->switched_pages (self, old_page, new_page);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Page*
page_window_get_current_page (PageWindow* self)
{
	Page* _tmp0_;
	Page* _tmp1_;
	Page* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_page;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
page_window_real_set_current_page (PageWindow* self,
                                   Page* page)
{
	Page* _tmp0_;
	Page* old_page = NULL;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->current_page;
	if (_tmp0_ != NULL) {
		Page* _tmp1_;
		_tmp1_ = self->priv->current_page;
		page_clear_container (_tmp1_);
	}
	_tmp2_ = self->priv->current_page;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	old_page = _tmp3_;
	_tmp4_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->current_page);
	self->priv->current_page = _tmp4_;
	_tmp5_ = self->priv->current_page;
	page_set_container (_tmp5_, (GtkWindow*) self);
	page_window_switched_pages (self, old_page, page);
	_g_object_unref0 (old_page);
}

void
page_window_set_current_page (PageWindow* self,
                              Page* page)
{
	PageWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_WINDOW_GET_CLASS (self);
	if (_klass_->set_current_page) {
		_klass_->set_current_page (self, page);
	}
}

static void
page_window_real_clear_current_page (PageWindow* self)
{
	Page* _tmp0_;
	Page* old_page = NULL;
	Page* _tmp2_;
	Page* _tmp3_;
	_tmp0_ = self->priv->current_page;
	if (_tmp0_ != NULL) {
		Page* _tmp1_;
		_tmp1_ = self->priv->current_page;
		page_clear_container (_tmp1_);
	}
	_tmp2_ = self->priv->current_page;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	old_page = _tmp3_;
	_g_object_unref0 (self->priv->current_page);
	self->priv->current_page = NULL;
	page_window_switched_pages (self, old_page, NULL);
	_g_object_unref0 (old_page);
}

void
page_window_clear_current_page (PageWindow* self)
{
	PageWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_WINDOW_GET_CLASS (self);
	if (_klass_->clear_current_page) {
		_klass_->clear_current_page (self);
	}
}

static gboolean
page_window_real_key_press_event (GtkWidget* base,
                                  GdkEventKey* event)
{
	PageWindow * self;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	gboolean _tmp4_ = FALSE;
	Page* _tmp5_;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	self = (PageWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = gtk_window_get_focus ((GtkWindow*) self);
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_entry_get_type ())) {
		GtkWidget* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = gtk_window_get_focus ((GtkWindow*) self);
		g_signal_emit_by_name (_tmp2_, "key-press-event", event, &_tmp3_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->current_page;
	if (_tmp5_ != NULL) {
		Page* _tmp6_;
		_tmp6_ = self->priv->current_page;
		_tmp4_ = page_notify_app_key_pressed (_tmp6_, event);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->key_press_event != NULL) {
		_tmp7_ = GTK_WIDGET_CLASS (page_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	} else {
		_tmp7_ = FALSE;
	}
	result = _tmp7_;
	return result;
}

static gboolean
page_window_real_key_release_event (GtkWidget* base,
                                    GdkEventKey* event)
{
	PageWindow * self;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	gboolean _tmp4_ = FALSE;
	Page* _tmp5_;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	self = (PageWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = gtk_window_get_focus ((GtkWindow*) self);
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_entry_get_type ())) {
		GtkWidget* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = gtk_window_get_focus ((GtkWindow*) self);
		g_signal_emit_by_name (_tmp2_, "key-release-event", event, &_tmp3_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->current_page;
	if (_tmp5_ != NULL) {
		Page* _tmp6_;
		_tmp6_ = self->priv->current_page;
		_tmp4_ = page_notify_app_key_released (_tmp6_, event);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->key_release_event != NULL) {
		_tmp7_ = GTK_WIDGET_CLASS (page_window_parent_class)->key_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	} else {
		_tmp7_ = FALSE;
	}
	result = _tmp7_;
	return result;
}

static gboolean
page_window_real_focus_in_event (GtkWidget* base,
                                 GdkEventFocus* event)
{
	PageWindow * self;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = (PageWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->current_page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		_tmp2_ = self->priv->current_page;
		_tmp0_ = page_notify_app_focus_in (_tmp2_, event);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->focus_in_event != NULL) {
		_tmp3_ = GTK_WIDGET_CLASS (page_window_parent_class)->focus_in_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static gboolean
page_window_real_focus_out_event (GtkWidget* base,
                                  GdkEventFocus* event)
{
	PageWindow * self;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = (PageWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->current_page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		_tmp2_ = self->priv->current_page;
		_tmp0_ = page_notify_app_focus_out (_tmp2_, event);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->focus_out_event != NULL) {
		_tmp3_ = GTK_WIDGET_CLASS (page_window_parent_class)->focus_out_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static gboolean
page_window_real_configure_event (GtkWidget* base,
                                  GdkEventConfigure* event)
{
	PageWindow * self;
	Page* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	self = (PageWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->current_page;
	if (_tmp0_ != NULL) {
		Page* _tmp1_;
		_tmp1_ = self->priv->current_page;
		if (page_notify_configure_event (_tmp1_, event)) {
			result = TRUE;
			return result;
		}
	}
	if (GTK_WIDGET_CLASS (page_window_parent_class)->configure_event != NULL) {
		_tmp2_ = GTK_WIDGET_CLASS (page_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}

void
page_window_set_busy_cursor (PageWindow* self)
{
	gint _tmp0_;
	GdkWindow* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->busy_counter;
	self->priv->busy_counter = _tmp0_ + 1;
	if (_tmp0_ > 0) {
		return;
	}
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_WATCH);
	_tmp4_ = _tmp3_;
	gdk_window_set_cursor (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	spin_event_loop ();
}

void
page_window_set_normal_cursor (PageWindow* self)
{
	GdkWindow* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->busy_counter <= 0) {
		self->priv->busy_counter = 0;
		return;
	} else {
		gint _tmp0_;
		self->priv->busy_counter = self->priv->busy_counter - 1;
		_tmp0_ = self->priv->busy_counter;
		if (_tmp0_ > 0) {
			return;
		}
	}
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_LEFT_PTR);
	_tmp4_ = _tmp3_;
	gdk_window_set_cursor (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	spin_event_loop ();
}

PageWindow*
page_window_construct (GType object_type)
{
	PageWindow * self = NULL;
	self = (PageWindow*) g_object_new (object_type, NULL);
	return self;
}

static GObject *
page_window_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PageWindow * self;
	GtkUIManager* _tmp0_;
	parent_class = G_OBJECT_CLASS (page_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_WINDOW, PageWindow);
	hdy_init ();
	gtk_widget_add_events ((GtkWidget*) self, (gint) ((GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK) | GDK_STRUCTURE_MASK));
	_tmp0_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->ui);
	self->ui = _tmp0_;
	return obj;
}

static void
page_window_class_init (PageWindowClass * klass,
                        gpointer klass_data)
{
	page_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PageWindow_private_offset);
	((PageWindowClass *) klass)->switched_pages = (void (*) (PageWindow*, Page*, Page*)) page_window_real_switched_pages;
	((PageWindowClass *) klass)->set_current_page = (void (*) (PageWindow*, Page*)) page_window_real_set_current_page;
	((PageWindowClass *) klass)->clear_current_page = (void (*) (PageWindow*)) page_window_real_clear_current_page;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) page_window_real_key_press_event;
	((GtkWidgetClass *) klass)->key_release_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) page_window_real_key_release_event;
	((GtkWidgetClass *) klass)->focus_in_event = (gboolean (*) (GtkWidget*, GdkEventFocus*)) page_window_real_focus_in_event;
	((GtkWidgetClass *) klass)->focus_out_event = (gboolean (*) (GtkWidget*, GdkEventFocus*)) page_window_real_focus_out_event;
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) page_window_real_configure_event;
	G_OBJECT_CLASS (klass)->constructor = page_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = page_window_finalize;
}

static void
page_window_instance_init (PageWindow * self,
                           gpointer klass)
{
	self->priv = page_window_get_instance_private (self);
	self->priv->current_page = NULL;
	self->priv->busy_counter = 0;
}

static void
page_window_finalize (GObject * obj)
{
	PageWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_WINDOW, PageWindow);
	_g_object_unref0 (self->ui);
	_g_object_unref0 (self->priv->current_page);
	G_OBJECT_CLASS (page_window_parent_class)->finalize (obj);
}

static GType
page_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageWindow), 0, (GInstanceInitFunc) page_window_instance_init, NULL };
	GType page_window_type_id;
	page_window_type_id = g_type_register_static (hdy_application_window_get_type (), "PageWindow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PageWindow_private_offset = g_type_add_instance_private (page_window_type_id, sizeof (PageWindowPrivate));
	return page_window_type_id;
}

GType
page_window_get_type (void)
{
	static volatile gsize page_window_type_id__once = 0;
	if (g_once_init_enter (&page_window_type_id__once)) {
		GType page_window_type_id;
		page_window_type_id = page_window_get_type_once ();
		g_once_init_leave (&page_window_type_id__once, page_window_type_id);
	}
	return page_window_type_id__once;
}

