// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "v4_22")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
use crate::RestoreReason;
use crate::{ApplicationInhibitFlags, Window, ffi};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkApplication")]
    pub struct Application(Object<ffi::GtkApplication, ffi::GtkApplicationClass>) @extends gio::Application, @implements gio::ActionGroup, gio::ActionMap;

    match fn {
        type_ => || ffi::gtk_application_get_type(),
    }
}

impl Application {
    pub const NONE: Option<&'static Application> = None;

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Application`] objects.
    ///
    /// This method returns an instance of [`ApplicationBuilder`](crate::builders::ApplicationBuilder) which can be used to create [`Application`] objects.
    pub fn builder() -> ApplicationBuilder {
        ApplicationBuilder::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Application`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ApplicationBuilder {
    builder: glib::object::ObjectBuilder<'static, Application>,
}

impl ApplicationBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    pub fn autosave_interval(self, autosave_interval: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("autosave-interval", autosave_interval),
        }
    }

    pub fn menubar(self, menubar: &impl IsA<gio::MenuModel>) -> Self {
        Self {
            builder: self.builder.property("menubar", menubar.clone().upcast()),
        }
    }

    #[cfg_attr(feature = "v4_22", deprecated = "Since 4.22")]
    pub fn register_session(self, register_session: bool) -> Self {
        Self {
            builder: self.builder.property("register-session", register_session),
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    pub fn support_save(self, support_save: bool) -> Self {
        Self {
            builder: self.builder.property("support-save", support_save),
        }
    }

    pub fn application_id(self, application_id: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("application-id", application_id.into()),
        }
    }

    pub fn flags(self, flags: gio::ApplicationFlags) -> Self {
        Self {
            builder: self.builder.property("flags", flags),
        }
    }

    pub fn inactivity_timeout(self, inactivity_timeout: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("inactivity-timeout", inactivity_timeout),
        }
    }

    pub fn resource_base_path(self, resource_base_path: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("resource-base-path", resource_base_path.into()),
        }
    }

    #[cfg(feature = "gio_v2_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gio_v2_80")))]
    pub fn version(self, version: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("version", version.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Application`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Application {
        let ret = self.builder.build();
        {
            Application::register_startup_hook(&ret);
        }
        ret
    }
}

pub trait GtkApplicationExt: IsA<Application> + 'static {
    #[doc(alias = "gtk_application_add_window")]
    fn add_window(&self, window: &impl IsA<Window>) {
        unsafe {
            ffi::gtk_application_add_window(
                self.as_ref().to_glib_none().0,
                window.as_ref().to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "gtk_application_forget")]
    fn forget(&self) {
        unsafe {
            ffi::gtk_application_forget(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_application_get_accels_for_action")]
    #[doc(alias = "get_accels_for_action")]
    fn accels_for_action(&self, detailed_action_name: &str) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_application_get_accels_for_action(
                self.as_ref().to_glib_none().0,
                detailed_action_name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_application_get_actions_for_accel")]
    #[doc(alias = "get_actions_for_accel")]
    fn actions_for_accel(&self, accel: &str) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_application_get_actions_for_accel(
                self.as_ref().to_glib_none().0,
                accel.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_application_get_active_window")]
    #[doc(alias = "get_active_window")]
    #[doc(alias = "active-window")]
    fn active_window(&self) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gtk_application_get_active_window(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_application_get_menu_by_id")]
    #[doc(alias = "get_menu_by_id")]
    fn menu_by_id(&self, id: &str) -> Option<gio::Menu> {
        unsafe {
            from_glib_none(ffi::gtk_application_get_menu_by_id(
                self.as_ref().to_glib_none().0,
                id.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_application_get_menubar")]
    #[doc(alias = "get_menubar")]
    fn menubar(&self) -> Option<gio::MenuModel> {
        unsafe {
            from_glib_none(ffi::gtk_application_get_menubar(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_application_get_window_by_id")]
    #[doc(alias = "get_window_by_id")]
    fn window_by_id(&self, id: u32) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gtk_application_get_window_by_id(
                self.as_ref().to_glib_none().0,
                id,
            ))
        }
    }

    #[doc(alias = "gtk_application_get_windows")]
    #[doc(alias = "get_windows")]
    fn windows(&self) -> Vec<Window> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_application_get_windows(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_application_inhibit")]
    fn inhibit(
        &self,
        window: Option<&impl IsA<Window>>,
        flags: ApplicationInhibitFlags,
        reason: Option<&str>,
    ) -> u32 {
        unsafe {
            ffi::gtk_application_inhibit(
                self.as_ref().to_glib_none().0,
                window.map(|p| p.as_ref()).to_glib_none().0,
                flags.into_glib(),
                reason.to_glib_none().0,
            )
        }
    }

    #[doc(alias = "gtk_application_list_action_descriptions")]
    fn list_action_descriptions(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_application_list_action_descriptions(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_application_remove_window")]
    fn remove_window(&self, window: &impl IsA<Window>) {
        unsafe {
            ffi::gtk_application_remove_window(
                self.as_ref().to_glib_none().0,
                window.as_ref().to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "gtk_application_save")]
    fn save(&self) {
        unsafe {
            ffi::gtk_application_save(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_application_set_accels_for_action")]
    fn set_accels_for_action(&self, detailed_action_name: &str, accels: &[&str]) {
        unsafe {
            ffi::gtk_application_set_accels_for_action(
                self.as_ref().to_glib_none().0,
                detailed_action_name.to_glib_none().0,
                accels.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_application_set_menubar")]
    #[doc(alias = "menubar")]
    fn set_menubar(&self, menubar: Option<&impl IsA<gio::MenuModel>>) {
        unsafe {
            ffi::gtk_application_set_menubar(
                self.as_ref().to_glib_none().0,
                menubar.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_application_uninhibit")]
    fn uninhibit(&self, cookie: u32) {
        unsafe {
            ffi::gtk_application_uninhibit(self.as_ref().to_glib_none().0, cookie);
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "autosave-interval")]
    fn autosave_interval(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "autosave-interval")
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "autosave-interval")]
    fn set_autosave_interval(&self, autosave_interval: u32) {
        ObjectExt::set_property(self.as_ref(), "autosave-interval", autosave_interval)
    }

    #[cfg_attr(feature = "v4_22", deprecated = "Since 4.22")]
    #[doc(alias = "register-session")]
    fn is_register_session(&self) -> bool {
        ObjectExt::property(self.as_ref(), "register-session")
    }

    #[cfg_attr(feature = "v4_22", deprecated = "Since 4.22")]
    #[doc(alias = "register-session")]
    fn set_register_session(&self, register_session: bool) {
        ObjectExt::set_property(self.as_ref(), "register-session", register_session)
    }

    #[doc(alias = "screensaver-active")]
    fn is_screensaver_active(&self) -> bool {
        ObjectExt::property(self.as_ref(), "screensaver-active")
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "support-save")]
    fn supports_save(&self) -> bool {
        ObjectExt::property(self.as_ref(), "support-save")
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "support-save")]
    fn set_support_save(&self, support_save: bool) {
        ObjectExt::set_property(self.as_ref(), "support-save", support_save)
    }

    #[doc(alias = "query-end")]
    fn connect_query_end<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn query_end_trampoline<P: IsA<Application>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkApplication,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Application::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"query-end".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    query_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "restore-state")]
    fn connect_restore_state<F: Fn(&Self, RestoreReason, &glib::Variant) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn restore_state_trampoline<
            P: IsA<Application>,
            F: Fn(&P, RestoreReason, &glib::Variant) -> bool + 'static,
        >(
            this: *mut ffi::GtkApplication,
            reason: ffi::GtkRestoreReason,
            state: *mut glib::ffi::GVariant,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Application::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(reason),
                    &from_glib_borrow(state),
                )
                .into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"restore-state".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    restore_state_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "restore-window")]
    fn connect_restore_window<F: Fn(&Self, RestoreReason, &glib::Variant) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn restore_window_trampoline<
            P: IsA<Application>,
            F: Fn(&P, RestoreReason, &glib::Variant) + 'static,
        >(
            this: *mut ffi::GtkApplication,
            reason: ffi::GtkRestoreReason,
            state: *mut glib::ffi::GVariant,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Application::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(reason),
                    &from_glib_borrow(state),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"restore-window".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    restore_window_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "save-state")]
    fn connect_save_state<F: Fn(&Self, &glib::VariantDict) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn save_state_trampoline<
            P: IsA<Application>,
            F: Fn(&P, &glib::VariantDict) -> bool + 'static,
        >(
            this: *mut ffi::GtkApplication,
            dict: *mut glib::ffi::GVariantDict,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Application::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(dict),
                )
                .into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"save-state".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    save_state_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "window-added")]
    fn connect_window_added<F: Fn(&Self, &Window) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn window_added_trampoline<
            P: IsA<Application>,
            F: Fn(&P, &Window) + 'static,
        >(
            this: *mut ffi::GtkApplication,
            window: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Application::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(window),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"window-added".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    window_added_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "window-removed")]
    fn connect_window_removed<F: Fn(&Self, &Window) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn window_removed_trampoline<
            P: IsA<Application>,
            F: Fn(&P, &Window) + 'static,
        >(
            this: *mut ffi::GtkApplication,
            window: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Application::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(window),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"window-removed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    window_removed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "active-window")]
    fn connect_active_window_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_active_window_trampoline<
            P: IsA<Application>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkApplication,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Application::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::active-window".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_active_window_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "autosave-interval")]
    fn connect_autosave_interval_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_autosave_interval_trampoline<
            P: IsA<Application>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkApplication,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Application::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::autosave-interval".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_autosave_interval_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "menubar")]
    fn connect_menubar_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_menubar_trampoline<P: IsA<Application>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkApplication,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Application::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::menubar".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_menubar_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg_attr(feature = "v4_22", deprecated = "Since 4.22")]
    #[doc(alias = "register-session")]
    fn connect_register_session_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_register_session_trampoline<
            P: IsA<Application>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkApplication,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Application::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::register-session".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_register_session_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "screensaver-active")]
    fn connect_screensaver_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_screensaver_active_trampoline<
            P: IsA<Application>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkApplication,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Application::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::screensaver-active".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_screensaver_active_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "support-save")]
    fn connect_support_save_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_support_save_trampoline<
            P: IsA<Application>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkApplication,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Application::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::support-save".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_support_save_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Application>> GtkApplicationExt for O {}
