/* PositionedWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PositionedWindow.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/window.h>
#include <glib.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <stdlib.h>
#include <string.h>
#include <mtk/mtk.h>
#include <meta/display.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW (greeter_compositor_positioned_window_get_type ())
#define GREETER_COMPOSITOR_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindow))
#define GREETER_COMPOSITOR_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindowClass))
#define GREETER_COMPOSITOR_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW))
#define GREETER_COMPOSITOR_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW))
#define GREETER_COMPOSITOR_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindowClass))

typedef struct _GreeterCompositorPositionedWindow GreeterCompositorPositionedWindow;
typedef struct _GreeterCompositorPositionedWindowClass GreeterCompositorPositionedWindowClass;
typedef struct _GreeterCompositorPositionedWindowPrivate GreeterCompositorPositionedWindowPrivate;
typedef enum  {
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_TOP,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_BOTTOM,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_CENTER,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_FULLSCREEN
} GreeterCompositorPositionedWindowPosition;

#define GREETER_COMPOSITOR_POSITIONED_WINDOW_TYPE_POSITION (greeter_compositor_positioned_window_position_get_type ())
enum  {
	GREETER_COMPOSITOR_POSITIONED_WINDOW_0_PROPERTY,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_WINDOW_PROPERTY,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_PROPERTY,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_DATA_PROPERTY,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_positioned_window_properties[GREETER_COMPOSITOR_POSITIONED_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _GreeterCompositorPositionedWindow {
	GObject parent_instance;
	GreeterCompositorPositionedWindowPrivate * priv;
};

struct _GreeterCompositorPositionedWindowClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorPositionedWindowPrivate {
	MetaWindow* _window;
	GreeterCompositorPositionedWindowPosition _position;
	GVariant* _position_data;
	gulong position_changed_id;
};

static gint GreeterCompositorPositionedWindow_private_offset;
static gpointer greeter_compositor_positioned_window_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorPositionedWindow, g_object_unref)
VALA_EXTERN GType greeter_compositor_positioned_window_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GreeterCompositorPositionedWindowPosition greeter_compositor_positioned_window_position_from_anchor (enum io_elementary_pantheon_panel_v1_anchor anchor);
static const char* _pantheon_desktop_anchor_to_string (enum io_elementary_pantheon_panel_v1_anchor value);
VALA_EXTERN GreeterCompositorPositionedWindow* greeter_compositor_positioned_window_new (MetaWindow* window,
                                                                             GreeterCompositorPositionedWindowPosition position,
                                                                             GVariant* position_data);
VALA_EXTERN GreeterCompositorPositionedWindow* greeter_compositor_positioned_window_construct (GType object_type,
                                                                                   MetaWindow* window,
                                                                                   GreeterCompositorPositionedWindowPosition position,
                                                                                   GVariant* position_data);
static void greeter_compositor_positioned_window_position_window (GreeterCompositorPositionedWindow* self);
VALA_EXTERN MetaWindow* greeter_compositor_positioned_window_get_window (GreeterCompositorPositionedWindow* self);
VALA_EXTERN GreeterCompositorPositionedWindowPosition greeter_compositor_positioned_window_get_position (GreeterCompositorPositionedWindow* self);
static void greeter_compositor_positioned_window_set_window (GreeterCompositorPositionedWindow* self,
                                                      MetaWindow* value);
VALA_EXTERN void greeter_compositor_positioned_window_set_position (GreeterCompositorPositionedWindow* self,
                                                        GreeterCompositorPositionedWindowPosition value);
VALA_EXTERN GVariant* greeter_compositor_positioned_window_get_position_data (GreeterCompositorPositionedWindow* self);
VALA_EXTERN void greeter_compositor_positioned_window_set_position_data (GreeterCompositorPositionedWindow* self,
                                                             GVariant* value);
static GObject * greeter_compositor_positioned_window_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
static void _greeter_compositor_positioned_window_position_window_meta_window_size_changed (MetaWindow* _sender,
                                                                                     gpointer self);
static void _greeter_compositor_positioned_window_position_window_meta_window_position_changed (MetaWindow* _sender,
                                                                                         gpointer self);
static void _greeter_compositor_positioned_window_position_window_meta_window_shown (MetaWindow* _sender,
                                                                              gpointer self);
static void _greeter_compositor_positioned_window_position_window_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                                  gpointer self);
static void _greeter_compositor_positioned_window_position_window_meta_monitor_manager_monitors_changed_internal (MetaMonitorManager* _sender,
                                                                                                           gpointer self);
static void _greeter_compositor_positioned_window_position_window_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self);
static void greeter_compositor_positioned_window_finalize (GObject * obj);
static GType greeter_compositor_positioned_window_get_type_once (void);
static void _vala_greeter_compositor_positioned_window_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_greeter_compositor_positioned_window_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static inline gpointer
greeter_compositor_positioned_window_get_instance_private (GreeterCompositorPositionedWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorPositionedWindow_private_offset);
}

static const char*
_pantheon_desktop_anchor_to_string (enum io_elementary_pantheon_panel_v1_anchor value)
{
	switch (value) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT";
	}
	return NULL;
}

GreeterCompositorPositionedWindowPosition
greeter_compositor_positioned_window_position_from_anchor (enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	GreeterCompositorPositionedWindowPosition result;
	if (anchor > 1) {
		const gchar* _tmp0_;
		_tmp0_ = _pantheon_desktop_anchor_to_string (anchor);
		g_warning ("PositionedWindow.vala:17: Position %s not supported yet", _tmp0_);
		result = GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_CENTER;
		return result;
	}
	result = (GreeterCompositorPositionedWindowPosition) anchor;
	return result;
}

static GType
greeter_compositor_positioned_window_position_get_type_once (void)
{
	static const GEnumValue values[] = {{GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_TOP, "GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_TOP", "top"}, {GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_BOTTOM, "GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_BOTTOM", "bottom"}, {GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_CENTER, "GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_CENTER", "center"}, {GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_FULLSCREEN, "GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_FULLSCREEN", "fullscreen"}, {0, NULL, NULL}};
	GType greeter_compositor_positioned_window_position_type_id;
	greeter_compositor_positioned_window_position_type_id = g_enum_register_static ("GreeterCompositorPositionedWindowPosition", values);
	return greeter_compositor_positioned_window_position_type_id;
}

GType
greeter_compositor_positioned_window_position_get_type (void)
{
	static volatile gsize greeter_compositor_positioned_window_position_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_positioned_window_position_type_id__once)) {
		GType greeter_compositor_positioned_window_position_type_id;
		greeter_compositor_positioned_window_position_type_id = greeter_compositor_positioned_window_position_get_type_once ();
		g_once_init_leave (&greeter_compositor_positioned_window_position_type_id__once, greeter_compositor_positioned_window_position_type_id);
	}
	return greeter_compositor_positioned_window_position_type_id__once;
}

GreeterCompositorPositionedWindow*
greeter_compositor_positioned_window_construct (GType object_type,
                                                MetaWindow* window,
                                                GreeterCompositorPositionedWindowPosition position,
                                                GVariant* position_data)
{
	GreeterCompositorPositionedWindow * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GreeterCompositorPositionedWindow*) g_object_new (object_type, "window", window, "position", position, "position-data", position_data, NULL);
	return self;
}

GreeterCompositorPositionedWindow*
greeter_compositor_positioned_window_new (MetaWindow* window,
                                          GreeterCompositorPositionedWindowPosition position,
                                          GVariant* position_data)
{
	return greeter_compositor_positioned_window_construct (GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, window, position, position_data);
}

static void
greeter_compositor_positioned_window_position_window (GreeterCompositorPositionedWindow* self)
{
	gint x = 0;
	gint y = 0;
	MtkRectangle window_rect = {0};
	MetaWindow* _tmp0_;
	MtkRectangle _tmp1_ = {0};
	gint width = 0;
	MtkRectangle _tmp2_;
	gint height = 0;
	MtkRectangle _tmp3_;
	MetaDisplay* display = NULL;
	MetaWindow* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaDisplay* _tmp6_;
	GreeterCompositorPositionedWindowPosition _tmp7_;
	MetaWindow* _tmp40_;
	MetaWindow* _tmp41_;
	MetaWindow* _tmp42_;
	g_return_if_fail (self != NULL);
	x = 0;
	y = 0;
	_tmp0_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp0_, &_tmp1_);
	window_rect = _tmp1_;
	_tmp2_ = window_rect;
	width = _tmp2_.width;
	_tmp3_ = window_rect;
	height = _tmp3_.height;
	_tmp4_ = self->priv->_window;
	_tmp5_ = meta_window_get_display (_tmp4_);
	_tmp6_ = _tmp5_;
	display = _tmp6_;
	_tmp7_ = self->priv->_position;
	switch (_tmp7_) {
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_CENTER:
		{
			MtkRectangle monitor_geom = {0};
			MetaDisplay* _tmp8_;
			MetaDisplay* _tmp9_;
			MtkRectangle _tmp10_ = {0};
			MtkRectangle _tmp11_;
			MtkRectangle _tmp12_;
			MtkRectangle _tmp13_;
			MtkRectangle _tmp14_;
			MtkRectangle _tmp15_;
			MtkRectangle _tmp16_;
			_tmp8_ = display;
			_tmp9_ = display;
			meta_display_get_monitor_geometry (_tmp8_, meta_display_get_primary_monitor (_tmp9_), &_tmp10_);
			monitor_geom = _tmp10_;
			_tmp11_ = monitor_geom;
			_tmp12_ = monitor_geom;
			_tmp13_ = window_rect;
			x = _tmp11_.x + ((_tmp12_.width - _tmp13_.width) / 2);
			_tmp14_ = monitor_geom;
			_tmp15_ = monitor_geom;
			_tmp16_ = window_rect;
			y = _tmp14_.y + ((_tmp15_.height - _tmp16_.height) / 2);
			break;
		}
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_TOP:
		{
			MtkRectangle monitor_geom = {0};
			MetaDisplay* _tmp17_;
			MetaDisplay* _tmp18_;
			MtkRectangle _tmp19_ = {0};
			MtkRectangle _tmp20_;
			MtkRectangle _tmp21_;
			MtkRectangle _tmp22_;
			MtkRectangle _tmp23_;
			_tmp17_ = display;
			_tmp18_ = display;
			meta_display_get_monitor_geometry (_tmp17_, meta_display_get_primary_monitor (_tmp18_), &_tmp19_);
			monitor_geom = _tmp19_;
			_tmp20_ = monitor_geom;
			_tmp21_ = monitor_geom;
			_tmp22_ = window_rect;
			x = _tmp20_.x + ((_tmp21_.width - _tmp22_.width) / 2);
			_tmp23_ = monitor_geom;
			y = _tmp23_.y;
			break;
		}
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_BOTTOM:
		{
			MtkRectangle monitor_geom = {0};
			MetaDisplay* _tmp24_;
			MetaDisplay* _tmp25_;
			MtkRectangle _tmp26_ = {0};
			MtkRectangle _tmp27_;
			MtkRectangle _tmp28_;
			MtkRectangle _tmp29_;
			MtkRectangle _tmp30_;
			MtkRectangle _tmp31_;
			MtkRectangle _tmp32_;
			_tmp24_ = display;
			_tmp25_ = display;
			meta_display_get_monitor_geometry (_tmp24_, meta_display_get_primary_monitor (_tmp25_), &_tmp26_);
			monitor_geom = _tmp26_;
			_tmp27_ = monitor_geom;
			_tmp28_ = monitor_geom;
			_tmp29_ = window_rect;
			x = _tmp27_.x + ((_tmp28_.width - _tmp29_.width) / 2);
			_tmp30_ = monitor_geom;
			_tmp31_ = monitor_geom;
			_tmp32_ = window_rect;
			y = (_tmp30_.y + _tmp31_.height) - _tmp32_.height;
			break;
		}
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_FULLSCREEN:
		{
			MtkRectangle monitor_geom = {0};
			MetaDisplay* _tmp33_;
			MetaDisplay* _tmp34_;
			MtkRectangle _tmp35_ = {0};
			MtkRectangle _tmp36_;
			MtkRectangle _tmp37_;
			MtkRectangle _tmp38_;
			MtkRectangle _tmp39_;
			_tmp33_ = display;
			_tmp34_ = display;
			meta_display_get_monitor_geometry (_tmp33_, meta_display_get_primary_monitor (_tmp34_), &_tmp35_);
			monitor_geom = _tmp35_;
			_tmp36_ = monitor_geom;
			x = _tmp36_.x;
			_tmp37_ = monitor_geom;
			y = _tmp37_.y;
			_tmp38_ = monitor_geom;
			width = _tmp38_.width;
			_tmp39_ = monitor_geom;
			height = _tmp39_.height;
			break;
		}
		default:
		break;
	}
	_tmp40_ = self->priv->_window;
	g_signal_handler_block (_tmp40_, self->priv->position_changed_id);
	_tmp41_ = self->priv->_window;
	meta_window_move_resize_frame (_tmp41_, FALSE, x, y, width, height);
	_tmp42_ = self->priv->_window;
	g_signal_handler_unblock (_tmp42_, self->priv->position_changed_id);
}

MetaWindow*
greeter_compositor_positioned_window_get_window (GreeterCompositorPositionedWindow* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_compositor_positioned_window_set_window (GreeterCompositorPositionedWindow* self,
                                                 MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_positioned_window_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_positioned_window_properties[GREETER_COMPOSITOR_POSITIONED_WINDOW_WINDOW_PROPERTY]);
	}
}

GreeterCompositorPositionedWindowPosition
greeter_compositor_positioned_window_get_position (GreeterCompositorPositionedWindow* self)
{
	GreeterCompositorPositionedWindowPosition result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_position;
	return result;
}

void
greeter_compositor_positioned_window_set_position (GreeterCompositorPositionedWindow* self,
                                                   GreeterCompositorPositionedWindowPosition value)
{
	GreeterCompositorPositionedWindowPosition old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_positioned_window_get_position (self);
	if (old_value != value) {
		self->priv->_position = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_positioned_window_properties[GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_PROPERTY]);
	}
}

GVariant*
greeter_compositor_positioned_window_get_position_data (GreeterCompositorPositionedWindow* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_position_data;
	result = _tmp0_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
greeter_compositor_positioned_window_set_position_data (GreeterCompositorPositionedWindow* self,
                                                        GVariant* value)
{
	GVariant* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_positioned_window_get_position_data (self);
	if (old_value != value) {
		GVariant* _tmp0_;
		_tmp0_ = _g_variant_ref0 (value);
		_g_variant_unref0 (self->priv->_position_data);
		self->priv->_position_data = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_positioned_window_properties[GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_DATA_PROPERTY]);
	}
}

static void
_greeter_compositor_positioned_window_position_window_meta_window_size_changed (MetaWindow* _sender,
                                                                                gpointer self)
{
	greeter_compositor_positioned_window_position_window ((GreeterCompositorPositionedWindow*) self);
}

static void
_greeter_compositor_positioned_window_position_window_meta_window_position_changed (MetaWindow* _sender,
                                                                                    gpointer self)
{
	greeter_compositor_positioned_window_position_window ((GreeterCompositorPositionedWindow*) self);
}

static void
_greeter_compositor_positioned_window_position_window_meta_window_shown (MetaWindow* _sender,
                                                                         gpointer self)
{
	greeter_compositor_positioned_window_position_window ((GreeterCompositorPositionedWindow*) self);
}

static void
_greeter_compositor_positioned_window_position_window_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                             gpointer self)
{
	greeter_compositor_positioned_window_position_window ((GreeterCompositorPositionedWindow*) self);
}

static void
_greeter_compositor_positioned_window_position_window_meta_monitor_manager_monitors_changed_internal (MetaMonitorManager* _sender,
                                                                                                      gpointer self)
{
	greeter_compositor_positioned_window_position_window ((GreeterCompositorPositionedWindow*) self);
}

static void
_greeter_compositor_positioned_window_position_window_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self)
{
	greeter_compositor_positioned_window_position_window ((GreeterCompositorPositionedWindow*) self);
}

static GObject *
greeter_compositor_positioned_window_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorPositionedWindow * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	gulong _tmp3_;
	MetaWindow* _tmp4_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaWindow* _tmp5_;
	MetaDisplay* _tmp6_;
	MetaDisplay* _tmp7_;
	MetaContext* _tmp8_;
	MetaBackend* _tmp9_;
	MetaMonitorManager* _tmp10_;
	MetaMonitorManager* _tmp11_;
	MetaMonitorManager* _tmp12_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_positioned_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindow);
	_tmp0_ = self->priv->_window;
	meta_window_stick (_tmp0_);
	_tmp1_ = self->priv->_window;
	g_signal_connect_object (_tmp1_, "size-changed", (GCallback) _greeter_compositor_positioned_window_position_window_meta_window_size_changed, self, 0);
	_tmp2_ = self->priv->_window;
	_tmp3_ = g_signal_connect_object (_tmp2_, "position-changed", (GCallback) _greeter_compositor_positioned_window_position_window_meta_window_position_changed, self, 0);
	self->priv->position_changed_id = _tmp3_;
	_tmp4_ = self->priv->_window;
	g_signal_connect_object (_tmp4_, "shown", (GCallback) _greeter_compositor_positioned_window_position_window_meta_window_shown, self, 0);
	_tmp5_ = self->priv->_window;
	_tmp6_ = meta_window_get_display (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = meta_display_get_context (_tmp7_);
	_tmp9_ = meta_context_get_backend (_tmp8_);
	_tmp10_ = meta_backend_get_monitor_manager (_tmp9_);
	monitor_manager = _tmp10_;
	_tmp11_ = monitor_manager;
	g_signal_connect_object (_tmp11_, "monitors-changed", (GCallback) _greeter_compositor_positioned_window_position_window_meta_monitor_manager_monitors_changed, self, 0);
	_tmp12_ = monitor_manager;
	g_signal_connect_object (_tmp12_, "monitors-changed-internal", (GCallback) _greeter_compositor_positioned_window_position_window_meta_monitor_manager_monitors_changed_internal, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::position", (GCallback) _greeter_compositor_positioned_window_position_window_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::position-data", (GCallback) _greeter_compositor_positioned_window_position_window_g_object_notify, self, 0);
	return obj;
}

static void
greeter_compositor_positioned_window_class_init (GreeterCompositorPositionedWindowClass * klass,
                                                 gpointer klass_data)
{
	greeter_compositor_positioned_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorPositionedWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_positioned_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_positioned_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_positioned_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_positioned_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_POSITIONED_WINDOW_WINDOW_PROPERTY, greeter_compositor_positioned_window_properties[GREETER_COMPOSITOR_POSITIONED_WINDOW_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * This may only be set after the window was shown.
	     * The initial position should only be given in the constructor.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_PROPERTY, greeter_compositor_positioned_window_properties[GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_PROPERTY] = g_param_spec_enum ("position", "position", "position", GREETER_COMPOSITOR_POSITIONED_WINDOW_TYPE_POSITION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_DATA_PROPERTY, greeter_compositor_positioned_window_properties[GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_DATA_PROPERTY] = g_param_spec_variant ("position-data", "position-data", "position-data", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
greeter_compositor_positioned_window_instance_init (GreeterCompositorPositionedWindow * self,
                                                    gpointer klass)
{
	self->priv = greeter_compositor_positioned_window_get_instance_private (self);
}

static void
greeter_compositor_positioned_window_finalize (GObject * obj)
{
	GreeterCompositorPositionedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindow);
	_g_object_unref0 (self->priv->_window);
	_g_variant_unref0 (self->priv->_position_data);
	G_OBJECT_CLASS (greeter_compositor_positioned_window_parent_class)->finalize (obj);
}

static GType
greeter_compositor_positioned_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorPositionedWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_positioned_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorPositionedWindow), 0, (GInstanceInitFunc) greeter_compositor_positioned_window_instance_init, NULL };
	GType greeter_compositor_positioned_window_type_id;
	greeter_compositor_positioned_window_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorPositionedWindow", &g_define_type_info, 0);
	GreeterCompositorPositionedWindow_private_offset = g_type_add_instance_private (greeter_compositor_positioned_window_type_id, sizeof (GreeterCompositorPositionedWindowPrivate));
	return greeter_compositor_positioned_window_type_id;
}

GType
greeter_compositor_positioned_window_get_type (void)
{
	static volatile gsize greeter_compositor_positioned_window_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_positioned_window_type_id__once)) {
		GType greeter_compositor_positioned_window_type_id;
		greeter_compositor_positioned_window_type_id = greeter_compositor_positioned_window_get_type_once ();
		g_once_init_leave (&greeter_compositor_positioned_window_type_id__once, greeter_compositor_positioned_window_type_id);
	}
	return greeter_compositor_positioned_window_type_id__once;
}

static void
_vala_greeter_compositor_positioned_window_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	GreeterCompositorPositionedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindow);
	switch (property_id) {
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_WINDOW_PROPERTY:
		g_value_set_object (value, greeter_compositor_positioned_window_get_window (self));
		break;
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_PROPERTY:
		g_value_set_enum (value, greeter_compositor_positioned_window_get_position (self));
		break;
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_DATA_PROPERTY:
		g_value_set_variant (value, greeter_compositor_positioned_window_get_position_data (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_positioned_window_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	GreeterCompositorPositionedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindow);
	switch (property_id) {
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_WINDOW_PROPERTY:
		greeter_compositor_positioned_window_set_window (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_PROPERTY:
		greeter_compositor_positioned_window_set_position (self, g_value_get_enum (value));
		break;
		case GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_DATA_PROPERTY:
		greeter_compositor_positioned_window_set_position_data (self, g_value_get_variant (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

