

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Enums
    ( 

 -- * Enumerations


-- ** AccessibleAnnouncementPriority #enum:AccessibleAnnouncementPriority#

    AccessibleAnnouncementPriority(..)      ,


-- ** AccessibleAutocomplete #enum:AccessibleAutocomplete#

    AccessibleAutocomplete(..)              ,


-- ** AccessibleInvalidState #enum:AccessibleInvalidState#

    AccessibleInvalidState(..)              ,


-- ** AccessiblePlatformState #enum:AccessiblePlatformState#

    AccessiblePlatformState(..)             ,


-- ** AccessibleProperty #enum:AccessibleProperty#

    AccessibleProperty(..)                  ,


-- ** AccessibleRelation #enum:AccessibleRelation#

    AccessibleRelation(..)                  ,


-- ** AccessibleRole #enum:AccessibleRole#

    AccessibleRole(..)                      ,


-- ** AccessibleSort #enum:AccessibleSort#

    AccessibleSort(..)                      ,


-- ** AccessibleState #enum:AccessibleState#

    AccessibleState(..)                     ,


-- ** AccessibleTextContentChange #enum:AccessibleTextContentChange#

    AccessibleTextContentChange(..)         ,


-- ** AccessibleTextGranularity #enum:AccessibleTextGranularity#

    AccessibleTextGranularity(..)           ,


-- ** AccessibleTristate #enum:AccessibleTristate#

    AccessibleTristate(..)                  ,


-- ** Align #enum:Align#

    Align(..)                               ,


-- ** ArrowType #enum:ArrowType#

    ArrowType(..)                           ,


-- ** AssistantPageType #enum:AssistantPageType#

    AssistantPageType(..)                   ,


-- ** BaselinePosition #enum:BaselinePosition#

    BaselinePosition(..)                    ,


-- ** BorderStyle #enum:BorderStyle#

    BorderStyle(..)                         ,


-- ** BuilderError #enum:BuilderError#

    BuilderError(..)                        ,
    catchBuilderError                       ,
    handleBuilderError                      ,


-- ** ButtonsType #enum:ButtonsType#

    ButtonsType(..)                         ,


-- ** CellRendererAccelMode #enum:CellRendererAccelMode#

    CellRendererAccelMode(..)               ,


-- ** CellRendererMode #enum:CellRendererMode#

    CellRendererMode(..)                    ,


-- ** Collation #enum:Collation#

    Collation(..)                           ,


-- ** ConstraintAttribute #enum:ConstraintAttribute#

    ConstraintAttribute(..)                 ,


-- ** ConstraintRelation #enum:ConstraintRelation#

    ConstraintRelation(..)                  ,


-- ** ConstraintStrength #enum:ConstraintStrength#

    ConstraintStrength(..)                  ,


-- ** ConstraintVflParserError #enum:ConstraintVflParserError#

    ConstraintVflParserError(..)            ,
    catchConstraintVflParserError           ,
    handleConstraintVflParserError          ,


-- ** ContentFit #enum:ContentFit#

    ContentFit(..)                          ,


-- ** CornerType #enum:CornerType#

    CornerType(..)                          ,


-- ** CssParserError #enum:CssParserError#

    CssParserError(..)                      ,
    catchCssParserError                     ,
    handleCssParserError                    ,


-- ** CssParserWarning #enum:CssParserWarning#

    CssParserWarning(..)                    ,


-- ** DeleteType #enum:DeleteType#

    DeleteType(..)                          ,


-- ** DialogError #enum:DialogError#

    DialogError(..)                         ,
    catchDialogError                        ,
    handleDialogError                       ,


-- ** DirectionType #enum:DirectionType#

    DirectionType(..)                       ,


-- ** EditableProperties #enum:EditableProperties#

    EditableProperties(..)                  ,


-- ** EntryIconPosition #enum:EntryIconPosition#

    EntryIconPosition(..)                   ,


-- ** EventSequenceState #enum:EventSequenceState#

    EventSequenceState(..)                  ,


-- ** FileChooserAction #enum:FileChooserAction#

    FileChooserAction(..)                   ,


-- ** FileChooserError #enum:FileChooserError#

    FileChooserError(..)                    ,
    catchFileChooserError                   ,
    handleFileChooserError                  ,


-- ** FilterChange #enum:FilterChange#

    FilterChange(..)                        ,


-- ** FilterMatch #enum:FilterMatch#

    FilterMatch(..)                         ,


-- ** FontLevel #enum:FontLevel#

    FontLevel(..)                           ,


-- ** FontRendering #enum:FontRendering#

    FontRendering(..)                       ,


-- ** GraphicsOffloadEnabled #enum:GraphicsOffloadEnabled#

    GraphicsOffloadEnabled(..)              ,


-- ** IconSize #enum:IconSize#

    IconSize(..)                            ,


-- ** IconThemeError #enum:IconThemeError#

    IconThemeError(..)                      ,
    catchIconThemeError                     ,
    handleIconThemeError                    ,


-- ** IconViewDropPosition #enum:IconViewDropPosition#

    IconViewDropPosition(..)                ,


-- ** ImageType #enum:ImageType#

    ImageType(..)                           ,


-- ** InputPurpose #enum:InputPurpose#

    InputPurpose(..)                        ,


-- ** InscriptionOverflow #enum:InscriptionOverflow#

    InscriptionOverflow(..)                 ,


-- ** InterfaceColorScheme #enum:InterfaceColorScheme#

    InterfaceColorScheme(..)                ,


-- ** InterfaceContrast #enum:InterfaceContrast#

    InterfaceContrast(..)                   ,


-- ** Justification #enum:Justification#

    Justification(..)                       ,


-- ** LevelBarMode #enum:LevelBarMode#

    LevelBarMode(..)                        ,


-- ** License #enum:License#

    License(..)                             ,


-- ** ListTabBehavior #enum:ListTabBehavior#

    ListTabBehavior(..)                     ,


-- ** MessageType #enum:MessageType#

    MessageType(..)                         ,


-- ** MovementStep #enum:MovementStep#

    MovementStep(..)                        ,


-- ** NaturalWrapMode #enum:NaturalWrapMode#

    NaturalWrapMode(..)                     ,


-- ** NotebookTab #enum:NotebookTab#

    NotebookTab(..)                         ,


-- ** NumberUpLayout #enum:NumberUpLayout#

    NumberUpLayout(..)                      ,


-- ** Ordering #enum:Ordering#

    Ordering(..)                            ,


-- ** Orientation #enum:Orientation#

    Orientation(..)                         ,


-- ** Overflow #enum:Overflow#

    Overflow(..)                            ,


-- ** PackType #enum:PackType#

    PackType(..)                            ,


-- ** PadActionType #enum:PadActionType#

    PadActionType(..)                       ,


-- ** PageOrientation #enum:PageOrientation#

    PageOrientation(..)                     ,


-- ** PageSet #enum:PageSet#

    PageSet(..)                             ,


-- ** PanDirection #enum:PanDirection#

    PanDirection(..)                        ,


-- ** PolicyType #enum:PolicyType#

    PolicyType(..)                          ,


-- ** PositionType #enum:PositionType#

    PositionType(..)                        ,


-- ** PrintDuplex #enum:PrintDuplex#

    PrintDuplex(..)                         ,


-- ** PrintError #enum:PrintError#

    PrintError(..)                          ,
    catchPrintError                         ,
    handlePrintError                        ,


-- ** PrintOperationAction #enum:PrintOperationAction#

    PrintOperationAction(..)                ,


-- ** PrintOperationResult #enum:PrintOperationResult#

    PrintOperationResult(..)                ,


-- ** PrintPages #enum:PrintPages#

    PrintPages(..)                          ,


-- ** PrintQuality #enum:PrintQuality#

    PrintQuality(..)                        ,


-- ** PrintStatus #enum:PrintStatus#

    PrintStatus(..)                         ,


-- ** PropagationLimit #enum:PropagationLimit#

    PropagationLimit(..)                    ,


-- ** PropagationPhase #enum:PropagationPhase#

    PropagationPhase(..)                    ,


-- ** RecentManagerError #enum:RecentManagerError#

    RecentManagerError(..)                  ,
    catchRecentManagerError                 ,
    handleRecentManagerError                ,


-- ** ResponseType #enum:ResponseType#

    ResponseType(..)                        ,


-- ** RevealerTransitionType #enum:RevealerTransitionType#

    RevealerTransitionType(..)              ,


-- ** ScrollStep #enum:ScrollStep#

    ScrollStep(..)                          ,


-- ** ScrollType #enum:ScrollType#

    ScrollType(..)                          ,


-- ** ScrollablePolicy #enum:ScrollablePolicy#

    ScrollablePolicy(..)                    ,


-- ** SelectionMode #enum:SelectionMode#

    SelectionMode(..)                       ,


-- ** SensitivityType #enum:SensitivityType#

    SensitivityType(..)                     ,


-- ** ShortcutScope #enum:ShortcutScope#

    ShortcutScope(..)                       ,


-- ** ShortcutType #enum:ShortcutType#

    ShortcutType(..)                        ,


-- ** SizeGroupMode #enum:SizeGroupMode#

    SizeGroupMode(..)                       ,


-- ** SizeRequestMode #enum:SizeRequestMode#

    SizeRequestMode(..)                     ,


-- ** SortType #enum:SortType#

    SortType(..)                            ,


-- ** SorterChange #enum:SorterChange#

    SorterChange(..)                        ,


-- ** SorterOrder #enum:SorterOrder#

    SorterOrder(..)                         ,


-- ** SpinButtonUpdatePolicy #enum:SpinButtonUpdatePolicy#

    SpinButtonUpdatePolicy(..)              ,


-- ** SpinType #enum:SpinType#

    SpinType(..)                            ,


-- ** StackTransitionType #enum:StackTransitionType#

    StackTransitionType(..)                 ,


-- ** StringFilterMatchMode #enum:StringFilterMatchMode#

    StringFilterMatchMode(..)               ,


-- ** SymbolicColor #enum:SymbolicColor#

    SymbolicColor(..)                       ,


-- ** SystemSetting #enum:SystemSetting#

    SystemSetting(..)                       ,


-- ** TextDirection #enum:TextDirection#

    TextDirection(..)                       ,


-- ** TextExtendSelection #enum:TextExtendSelection#

    TextExtendSelection(..)                 ,


-- ** TextViewLayer #enum:TextViewLayer#

    TextViewLayer(..)                       ,


-- ** TextWindowType #enum:TextWindowType#

    TextWindowType(..)                      ,


-- ** TreeViewColumnSizing #enum:TreeViewColumnSizing#

    TreeViewColumnSizing(..)                ,


-- ** TreeViewDropPosition #enum:TreeViewDropPosition#

    TreeViewDropPosition(..)                ,


-- ** TreeViewGridLines #enum:TreeViewGridLines#

    TreeViewGridLines(..)                   ,


-- ** Unit #enum:Unit#

    Unit(..)                                ,


-- ** WindowGravity #enum:WindowGravity#

    WindowGravity(..)                       ,


-- ** WrapMode #enum:WrapMode#

    WrapMode(..)                            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum WrapMode
-- | Describes a type of line wrapping.
data WrapMode = 
      WrapModeNone
    -- ^ do not wrap lines; just make the text area wider
    | WrapModeChar
    -- ^ wrap text, breaking lines anywhere the cursor can
    --   appear (between characters, usually - if you want to be technical,
    --   between graphemes, see 'GI.Pango.Functions.getLogAttrs')
    | WrapModeWord
    -- ^ wrap text, breaking lines in between words
    | WrapModeWordChar
    -- ^ wrap text, breaking lines in between words, or if
    --   that is not enough, also between graphemes
    | AnotherWrapMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WrapMode where
    fromEnum WrapModeNone = 0
    fromEnum WrapModeChar = 1
    fromEnum WrapModeWord = 2
    fromEnum WrapModeWordChar = 3
    fromEnum (AnotherWrapMode k) = k

    toEnum 0 = WrapModeNone
    toEnum 1 = WrapModeChar
    toEnum 2 = WrapModeWord
    toEnum 3 = WrapModeWordChar
    toEnum k = AnotherWrapMode k

instance P.Ord WrapMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WrapMode = '[]
instance O.HasParentTypes WrapMode

foreign import ccall "gtk_wrap_mode_get_type" c_gtk_wrap_mode_get_type :: 
    IO GType

instance B.Types.TypedObject WrapMode where
    glibType = c_gtk_wrap_mode_get_type

instance B.Types.BoxedEnum WrapMode

-- Enum WindowGravity
-- | Determines which point or edge of a window is meant to remain fixed
-- when a window changes size.
-- 
-- /Since: 4.20/
data WindowGravity = 
      WindowGravityTopLeft
    -- ^ The top left corner
    | WindowGravityTop
    -- ^ The top edge
    | WindowGravityTopRight
    -- ^ The top right corner
    | WindowGravityLeft
    -- ^ The left edge
    | WindowGravityCenter
    -- ^ The center pointer
    | WindowGravityRight
    -- ^ The right edge
    | WindowGravityBottomLeft
    -- ^ The bottom left corner
    | WindowGravityBottom
    -- ^ the bottom edge
    | WindowGravityBottomRight
    -- ^ The bottom right corner
    | WindowGravityTopStart
    -- ^ The top left or top right corner,
    --   depending on the text direction
    | WindowGravityTopEnd
    -- ^ The top right or top left corner,
    --   depending on the text direction
    | WindowGravityStart
    -- ^ The left or right edge,
    --   depending on the text direction
    | WindowGravityEnd
    -- ^ The right or left edge,
    --   depending on the text direction
    | WindowGravityBottomStart
    -- ^ The bottom left or top right corner,
    --   depending on the text direction
    | WindowGravityBottomEnd
    -- ^ The bottom right or top left corner,
    --   depending on the text direction
    | AnotherWindowGravity Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WindowGravity where
    fromEnum WindowGravityTopLeft = 0
    fromEnum WindowGravityTop = 1
    fromEnum WindowGravityTopRight = 2
    fromEnum WindowGravityLeft = 3
    fromEnum WindowGravityCenter = 4
    fromEnum WindowGravityRight = 5
    fromEnum WindowGravityBottomLeft = 6
    fromEnum WindowGravityBottom = 7
    fromEnum WindowGravityBottomRight = 8
    fromEnum WindowGravityTopStart = 9
    fromEnum WindowGravityTopEnd = 10
    fromEnum WindowGravityStart = 11
    fromEnum WindowGravityEnd = 12
    fromEnum WindowGravityBottomStart = 13
    fromEnum WindowGravityBottomEnd = 14
    fromEnum (AnotherWindowGravity k) = k

    toEnum 0 = WindowGravityTopLeft
    toEnum 1 = WindowGravityTop
    toEnum 2 = WindowGravityTopRight
    toEnum 3 = WindowGravityLeft
    toEnum 4 = WindowGravityCenter
    toEnum 5 = WindowGravityRight
    toEnum 6 = WindowGravityBottomLeft
    toEnum 7 = WindowGravityBottom
    toEnum 8 = WindowGravityBottomRight
    toEnum 9 = WindowGravityTopStart
    toEnum 10 = WindowGravityTopEnd
    toEnum 11 = WindowGravityStart
    toEnum 12 = WindowGravityEnd
    toEnum 13 = WindowGravityBottomStart
    toEnum 14 = WindowGravityBottomEnd
    toEnum k = AnotherWindowGravity k

instance P.Ord WindowGravity where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WindowGravity = '[]
instance O.HasParentTypes WindowGravity

foreign import ccall "gtk_window_gravity_get_type" c_gtk_window_gravity_get_type :: 
    IO GType

instance B.Types.TypedObject WindowGravity where
    glibType = c_gtk_window_gravity_get_type

instance B.Types.BoxedEnum WindowGravity

-- Enum Unit
-- | See also 'GI.Gtk.Objects.PrintSettings.printSettingsSetPaperWidth'.
data Unit = 
      UnitNone
    -- ^ No units.
    | UnitPoints
    -- ^ Dimensions in points.
    | UnitInch
    -- ^ Dimensions in inches.
    | UnitMm
    -- ^ Dimensions in millimeters
    | AnotherUnit Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Unit where
    fromEnum UnitNone = 0
    fromEnum UnitPoints = 1
    fromEnum UnitInch = 2
    fromEnum UnitMm = 3
    fromEnum (AnotherUnit k) = k

    toEnum 0 = UnitNone
    toEnum 1 = UnitPoints
    toEnum 2 = UnitInch
    toEnum 3 = UnitMm
    toEnum k = AnotherUnit k

instance P.Ord Unit where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Unit = '[]
instance O.HasParentTypes Unit

foreign import ccall "gtk_unit_get_type" c_gtk_unit_get_type :: 
    IO GType

instance B.Types.TypedObject Unit where
    glibType = c_gtk_unit_get_type

instance B.Types.BoxedEnum Unit

-- Enum TreeViewGridLines
{-# DEPRECATED TreeViewGridLines ["(Since version 4.20)","There is no replacement"] #-}
-- | Used to indicate which grid lines to draw in a tree view.
data TreeViewGridLines = 
      TreeViewGridLinesNone
    -- ^ No grid lines.
    | TreeViewGridLinesHorizontal
    -- ^ Horizontal grid lines.
    | TreeViewGridLinesVertical
    -- ^ Vertical grid lines.
    | TreeViewGridLinesBoth
    -- ^ Horizontal and vertical grid lines.
    | AnotherTreeViewGridLines Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TreeViewGridLines where
    fromEnum TreeViewGridLinesNone = 0
    fromEnum TreeViewGridLinesHorizontal = 1
    fromEnum TreeViewGridLinesVertical = 2
    fromEnum TreeViewGridLinesBoth = 3
    fromEnum (AnotherTreeViewGridLines k) = k

    toEnum 0 = TreeViewGridLinesNone
    toEnum 1 = TreeViewGridLinesHorizontal
    toEnum 2 = TreeViewGridLinesVertical
    toEnum 3 = TreeViewGridLinesBoth
    toEnum k = AnotherTreeViewGridLines k

instance P.Ord TreeViewGridLines where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TreeViewGridLines = '[]
instance O.HasParentTypes TreeViewGridLines

foreign import ccall "gtk_tree_view_grid_lines_get_type" c_gtk_tree_view_grid_lines_get_type :: 
    IO GType

instance B.Types.TypedObject TreeViewGridLines where
    glibType = c_gtk_tree_view_grid_lines_get_type

instance B.Types.BoxedEnum TreeViewGridLines

-- Enum TreeViewDropPosition
{-# DEPRECATED TreeViewDropPosition ["(Since version 4.20)","There is no replacement."] #-}
-- | An enum for determining where a dropped row goes.
data TreeViewDropPosition = 
      TreeViewDropPositionBefore
    -- ^ dropped row is inserted before
    | TreeViewDropPositionAfter
    -- ^ dropped row is inserted after
    | TreeViewDropPositionIntoOrBefore
    -- ^ dropped row becomes a child or is inserted before
    | TreeViewDropPositionIntoOrAfter
    -- ^ dropped row becomes a child or is inserted after
    | AnotherTreeViewDropPosition Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TreeViewDropPosition where
    fromEnum TreeViewDropPositionBefore = 0
    fromEnum TreeViewDropPositionAfter = 1
    fromEnum TreeViewDropPositionIntoOrBefore = 2
    fromEnum TreeViewDropPositionIntoOrAfter = 3
    fromEnum (AnotherTreeViewDropPosition k) = k

    toEnum 0 = TreeViewDropPositionBefore
    toEnum 1 = TreeViewDropPositionAfter
    toEnum 2 = TreeViewDropPositionIntoOrBefore
    toEnum 3 = TreeViewDropPositionIntoOrAfter
    toEnum k = AnotherTreeViewDropPosition k

instance P.Ord TreeViewDropPosition where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TreeViewDropPosition = '[]
instance O.HasParentTypes TreeViewDropPosition

foreign import ccall "gtk_tree_view_drop_position_get_type" c_gtk_tree_view_drop_position_get_type :: 
    IO GType

instance B.Types.TypedObject TreeViewDropPosition where
    glibType = c_gtk_tree_view_drop_position_get_type

instance B.Types.BoxedEnum TreeViewDropPosition

-- Enum TreeViewColumnSizing
{-# DEPRECATED TreeViewColumnSizing ["(Since version 4.20)","There is no replacement."] #-}
-- | The sizing method the column uses to determine its width.  Please note
-- that 'GI.Gtk.Enums.TreeViewColumnSizingAutosize' are inefficient for large views, and
-- can make columns appear choppy.
data TreeViewColumnSizing = 
      TreeViewColumnSizingGrowOnly
    -- ^ Columns only get bigger in reaction to changes in the model
    | TreeViewColumnSizingAutosize
    -- ^ Columns resize to be the optimal size every time the model changes.
    | TreeViewColumnSizingFixed
    -- ^ Columns are a fixed numbers of pixels wide.
    | AnotherTreeViewColumnSizing Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TreeViewColumnSizing where
    fromEnum TreeViewColumnSizingGrowOnly = 0
    fromEnum TreeViewColumnSizingAutosize = 1
    fromEnum TreeViewColumnSizingFixed = 2
    fromEnum (AnotherTreeViewColumnSizing k) = k

    toEnum 0 = TreeViewColumnSizingGrowOnly
    toEnum 1 = TreeViewColumnSizingAutosize
    toEnum 2 = TreeViewColumnSizingFixed
    toEnum k = AnotherTreeViewColumnSizing k

instance P.Ord TreeViewColumnSizing where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TreeViewColumnSizing = '[]
instance O.HasParentTypes TreeViewColumnSizing

foreign import ccall "gtk_tree_view_column_sizing_get_type" c_gtk_tree_view_column_sizing_get_type :: 
    IO GType

instance B.Types.TypedObject TreeViewColumnSizing where
    glibType = c_gtk_tree_view_column_sizing_get_type

instance B.Types.BoxedEnum TreeViewColumnSizing

-- Enum TextWindowType
-- | Used to reference the parts of @GtkTextView@.
data TextWindowType = 
      TextWindowTypeWidget
    -- ^ Window that floats over scrolling areas.
    | TextWindowTypeText
    -- ^ Scrollable text window.
    | TextWindowTypeLeft
    -- ^ Left side border window.
    | TextWindowTypeRight
    -- ^ Right side border window.
    | TextWindowTypeTop
    -- ^ Top border window.
    | TextWindowTypeBottom
    -- ^ Bottom border window.
    | AnotherTextWindowType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextWindowType where
    fromEnum TextWindowTypeWidget = 1
    fromEnum TextWindowTypeText = 2
    fromEnum TextWindowTypeLeft = 3
    fromEnum TextWindowTypeRight = 4
    fromEnum TextWindowTypeTop = 5
    fromEnum TextWindowTypeBottom = 6
    fromEnum (AnotherTextWindowType k) = k

    toEnum 1 = TextWindowTypeWidget
    toEnum 2 = TextWindowTypeText
    toEnum 3 = TextWindowTypeLeft
    toEnum 4 = TextWindowTypeRight
    toEnum 5 = TextWindowTypeTop
    toEnum 6 = TextWindowTypeBottom
    toEnum k = AnotherTextWindowType k

instance P.Ord TextWindowType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextWindowType = '[]
instance O.HasParentTypes TextWindowType

foreign import ccall "gtk_text_window_type_get_type" c_gtk_text_window_type_get_type :: 
    IO GType

instance B.Types.TypedObject TextWindowType where
    glibType = c_gtk_text_window_type_get_type

instance B.Types.BoxedEnum TextWindowType

-- Enum TextViewLayer
-- | Used to reference the layers of @GtkTextView@ for the purpose of customized
-- drawing with the [snapshot_layer](#g:signal:snapshot_layer) vfunc.
data TextViewLayer = 
      TextViewLayerBelowText
    -- ^ The layer rendered below the text (but above the background).
    | TextViewLayerAboveText
    -- ^ The layer rendered above the text.
    | AnotherTextViewLayer Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextViewLayer where
    fromEnum TextViewLayerBelowText = 0
    fromEnum TextViewLayerAboveText = 1
    fromEnum (AnotherTextViewLayer k) = k

    toEnum 0 = TextViewLayerBelowText
    toEnum 1 = TextViewLayerAboveText
    toEnum k = AnotherTextViewLayer k

instance P.Ord TextViewLayer where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextViewLayer = '[]
instance O.HasParentTypes TextViewLayer

foreign import ccall "gtk_text_view_layer_get_type" c_gtk_text_view_layer_get_type :: 
    IO GType

instance B.Types.TypedObject TextViewLayer where
    glibType = c_gtk_text_view_layer_get_type

instance B.Types.BoxedEnum TextViewLayer

-- Enum TextExtendSelection
-- | Granularity types that extend the text selection. Use the
-- @GtkTextView::extend-selection@ signal to customize the selection.
data TextExtendSelection = 
      TextExtendSelectionWord
    -- ^ Selects the current word. It is triggered by
    --   a double-click for example.
    | TextExtendSelectionLine
    -- ^ Selects the current line. It is triggered by
    --   a triple-click for example.
    | AnotherTextExtendSelection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextExtendSelection where
    fromEnum TextExtendSelectionWord = 0
    fromEnum TextExtendSelectionLine = 1
    fromEnum (AnotherTextExtendSelection k) = k

    toEnum 0 = TextExtendSelectionWord
    toEnum 1 = TextExtendSelectionLine
    toEnum k = AnotherTextExtendSelection k

instance P.Ord TextExtendSelection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextExtendSelection = '[]
instance O.HasParentTypes TextExtendSelection

foreign import ccall "gtk_text_extend_selection_get_type" c_gtk_text_extend_selection_get_type :: 
    IO GType

instance B.Types.TypedObject TextExtendSelection where
    glibType = c_gtk_text_extend_selection_get_type

instance B.Types.BoxedEnum TextExtendSelection

-- Enum TextDirection
-- | Reading directions for text.
data TextDirection = 
      TextDirectionNone
    -- ^ No direction.
    | TextDirectionLtr
    -- ^ Left to right text direction.
    | TextDirectionRtl
    -- ^ Right to left text direction.
    | AnotherTextDirection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextDirection where
    fromEnum TextDirectionNone = 0
    fromEnum TextDirectionLtr = 1
    fromEnum TextDirectionRtl = 2
    fromEnum (AnotherTextDirection k) = k

    toEnum 0 = TextDirectionNone
    toEnum 1 = TextDirectionLtr
    toEnum 2 = TextDirectionRtl
    toEnum k = AnotherTextDirection k

instance P.Ord TextDirection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextDirection = '[]
instance O.HasParentTypes TextDirection

foreign import ccall "gtk_text_direction_get_type" c_gtk_text_direction_get_type :: 
    IO GType

instance B.Types.TypedObject TextDirection where
    glibType = c_gtk_text_direction_get_type

instance B.Types.BoxedEnum TextDirection

-- Enum SystemSetting
-- | Values that can be passed to the t'GI.Gtk.Objects.Widget.Widget'.@/system_setting_changed/@()
-- vfunc.
-- 
-- The values indicate which system setting has changed.
-- Widgets may need to drop caches, or react otherwise.
-- 
-- Most of the values correspond to [class/@settings@/] properties.
-- 
-- More values may be added over time.
data SystemSetting = 
      SystemSettingDpi
    -- ^ the [Settings:gtkXftDpi]("GI.Gtk.Objects.Settings#g:attr:gtkXftDpi") setting has changed
    | SystemSettingFontName
    -- ^ The [Settings:gtkFontName]("GI.Gtk.Objects.Settings#g:attr:gtkFontName") setting has changed
    | SystemSettingFontConfig
    -- ^ The font configuration has changed in a way that
    --   requires text to be redrawn. This can be any of the
    --   [Settings:gtkXftAntialias]("GI.Gtk.Objects.Settings#g:attr:gtkXftAntialias"),
    --   [Settings:gtkXftHinting]("GI.Gtk.Objects.Settings#g:attr:gtkXftHinting"),
    --   [Settings:gtkXftHintstyle]("GI.Gtk.Objects.Settings#g:attr:gtkXftHintstyle"),
    --   [Settings:gtkXftRgba]("GI.Gtk.Objects.Settings#g:attr:gtkXftRgba") or
    --   [Settings:gtkFontconfigTimestamp]("GI.Gtk.Objects.Settings#g:attr:gtkFontconfigTimestamp") settings
    | SystemSettingDisplay
    -- ^ The display has changed
    | SystemSettingIconTheme
    -- ^ The icon theme has changed in a way that requires
    --   icons to be looked up again
    | AnotherSystemSetting Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SystemSetting where
    fromEnum SystemSettingDpi = 0
    fromEnum SystemSettingFontName = 1
    fromEnum SystemSettingFontConfig = 2
    fromEnum SystemSettingDisplay = 3
    fromEnum SystemSettingIconTheme = 4
    fromEnum (AnotherSystemSetting k) = k

    toEnum 0 = SystemSettingDpi
    toEnum 1 = SystemSettingFontName
    toEnum 2 = SystemSettingFontConfig
    toEnum 3 = SystemSettingDisplay
    toEnum 4 = SystemSettingIconTheme
    toEnum k = AnotherSystemSetting k

instance P.Ord SystemSetting where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SystemSetting = '[]
instance O.HasParentTypes SystemSetting

foreign import ccall "gtk_system_setting_get_type" c_gtk_system_setting_get_type :: 
    IO GType

instance B.Types.TypedObject SystemSetting where
    glibType = c_gtk_system_setting_get_type

instance B.Types.BoxedEnum SystemSetting

-- Enum SymbolicColor
-- | The indexes of colors passed to symbolic color rendering, such as
-- t'GI.Gtk.Interfaces.SymbolicPaintable.SymbolicPaintable'.@/snapshot_symbolic/@().
-- 
-- More values may be added over time.
-- 
-- /Since: 4.6/
data SymbolicColor = 
      SymbolicColorForeground
    -- ^ The default foreground color
    | SymbolicColorError
    -- ^ Indication color for errors
    | SymbolicColorWarning
    -- ^ Indication color for warnings
    | SymbolicColorSuccess
    -- ^ Indication color for success
    | AnotherSymbolicColor Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SymbolicColor where
    fromEnum SymbolicColorForeground = 0
    fromEnum SymbolicColorError = 1
    fromEnum SymbolicColorWarning = 2
    fromEnum SymbolicColorSuccess = 3
    fromEnum (AnotherSymbolicColor k) = k

    toEnum 0 = SymbolicColorForeground
    toEnum 1 = SymbolicColorError
    toEnum 2 = SymbolicColorWarning
    toEnum 3 = SymbolicColorSuccess
    toEnum k = AnotherSymbolicColor k

instance P.Ord SymbolicColor where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SymbolicColor = '[]
instance O.HasParentTypes SymbolicColor

foreign import ccall "gtk_symbolic_color_get_type" c_gtk_symbolic_color_get_type :: 
    IO GType

instance B.Types.TypedObject SymbolicColor where
    glibType = c_gtk_symbolic_color_get_type

instance B.Types.BoxedEnum SymbolicColor

-- Enum StringFilterMatchMode
-- | Specifies how search strings are matched inside text.
data StringFilterMatchMode = 
      StringFilterMatchModeExact
    -- ^ The search string and
    --   text must match exactly
    | StringFilterMatchModeSubstring
    -- ^ The search string
    --   must be contained as a substring inside the text
    | StringFilterMatchModePrefix
    -- ^ The text must begin
    --   with the search string
    | AnotherStringFilterMatchMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum StringFilterMatchMode where
    fromEnum StringFilterMatchModeExact = 0
    fromEnum StringFilterMatchModeSubstring = 1
    fromEnum StringFilterMatchModePrefix = 2
    fromEnum (AnotherStringFilterMatchMode k) = k

    toEnum 0 = StringFilterMatchModeExact
    toEnum 1 = StringFilterMatchModeSubstring
    toEnum 2 = StringFilterMatchModePrefix
    toEnum k = AnotherStringFilterMatchMode k

instance P.Ord StringFilterMatchMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes StringFilterMatchMode = '[]
instance O.HasParentTypes StringFilterMatchMode

foreign import ccall "gtk_string_filter_match_mode_get_type" c_gtk_string_filter_match_mode_get_type :: 
    IO GType

instance B.Types.TypedObject StringFilterMatchMode where
    glibType = c_gtk_string_filter_match_mode_get_type

instance B.Types.BoxedEnum StringFilterMatchMode

-- Enum StackTransitionType
-- | Possible transitions between pages in a @GtkStack@ widget.
-- 
-- New values may be added to this enumeration over time.
data StackTransitionType = 
      StackTransitionTypeNone
    -- ^ No transition
    | StackTransitionTypeCrossfade
    -- ^ A cross-fade
    | StackTransitionTypeSlideRight
    -- ^ Slide from left to right
    | StackTransitionTypeSlideLeft
    -- ^ Slide from right to left
    | StackTransitionTypeSlideUp
    -- ^ Slide from bottom up
    | StackTransitionTypeSlideDown
    -- ^ Slide from top down
    | StackTransitionTypeSlideLeftRight
    -- ^ Slide from left or right according to the children order
    | StackTransitionTypeSlideUpDown
    -- ^ Slide from top down or bottom up according to the order
    | StackTransitionTypeOverUp
    -- ^ Cover the old page by sliding up
    | StackTransitionTypeOverDown
    -- ^ Cover the old page by sliding down
    | StackTransitionTypeOverLeft
    -- ^ Cover the old page by sliding to the left
    | StackTransitionTypeOverRight
    -- ^ Cover the old page by sliding to the right
    | StackTransitionTypeUnderUp
    -- ^ Uncover the new page by sliding up
    | StackTransitionTypeUnderDown
    -- ^ Uncover the new page by sliding down
    | StackTransitionTypeUnderLeft
    -- ^ Uncover the new page by sliding to the left
    | StackTransitionTypeUnderRight
    -- ^ Uncover the new page by sliding to the right
    | StackTransitionTypeOverUpDown
    -- ^ Cover the old page sliding up or uncover the new page sliding down, according to order
    | StackTransitionTypeOverDownUp
    -- ^ Cover the old page sliding down or uncover the new page sliding up, according to order
    | StackTransitionTypeOverLeftRight
    -- ^ Cover the old page sliding left or uncover the new page sliding right, according to order
    | StackTransitionTypeOverRightLeft
    -- ^ Cover the old page sliding right or uncover the new page sliding left, according to order
    | StackTransitionTypeRotateLeft
    -- ^ Pretend the pages are sides of a cube and rotate that cube to the left
    | StackTransitionTypeRotateRight
    -- ^ Pretend the pages are sides of a cube and rotate that cube to the right
    | StackTransitionTypeRotateLeftRight
    -- ^ Pretend the pages are sides of a cube and rotate that cube to the left or right according to the children order
    | AnotherStackTransitionType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum StackTransitionType where
    fromEnum StackTransitionTypeNone = 0
    fromEnum StackTransitionTypeCrossfade = 1
    fromEnum StackTransitionTypeSlideRight = 2
    fromEnum StackTransitionTypeSlideLeft = 3
    fromEnum StackTransitionTypeSlideUp = 4
    fromEnum StackTransitionTypeSlideDown = 5
    fromEnum StackTransitionTypeSlideLeftRight = 6
    fromEnum StackTransitionTypeSlideUpDown = 7
    fromEnum StackTransitionTypeOverUp = 8
    fromEnum StackTransitionTypeOverDown = 9
    fromEnum StackTransitionTypeOverLeft = 10
    fromEnum StackTransitionTypeOverRight = 11
    fromEnum StackTransitionTypeUnderUp = 12
    fromEnum StackTransitionTypeUnderDown = 13
    fromEnum StackTransitionTypeUnderLeft = 14
    fromEnum StackTransitionTypeUnderRight = 15
    fromEnum StackTransitionTypeOverUpDown = 16
    fromEnum StackTransitionTypeOverDownUp = 17
    fromEnum StackTransitionTypeOverLeftRight = 18
    fromEnum StackTransitionTypeOverRightLeft = 19
    fromEnum StackTransitionTypeRotateLeft = 20
    fromEnum StackTransitionTypeRotateRight = 21
    fromEnum StackTransitionTypeRotateLeftRight = 22
    fromEnum (AnotherStackTransitionType k) = k

    toEnum 0 = StackTransitionTypeNone
    toEnum 1 = StackTransitionTypeCrossfade
    toEnum 2 = StackTransitionTypeSlideRight
    toEnum 3 = StackTransitionTypeSlideLeft
    toEnum 4 = StackTransitionTypeSlideUp
    toEnum 5 = StackTransitionTypeSlideDown
    toEnum 6 = StackTransitionTypeSlideLeftRight
    toEnum 7 = StackTransitionTypeSlideUpDown
    toEnum 8 = StackTransitionTypeOverUp
    toEnum 9 = StackTransitionTypeOverDown
    toEnum 10 = StackTransitionTypeOverLeft
    toEnum 11 = StackTransitionTypeOverRight
    toEnum 12 = StackTransitionTypeUnderUp
    toEnum 13 = StackTransitionTypeUnderDown
    toEnum 14 = StackTransitionTypeUnderLeft
    toEnum 15 = StackTransitionTypeUnderRight
    toEnum 16 = StackTransitionTypeOverUpDown
    toEnum 17 = StackTransitionTypeOverDownUp
    toEnum 18 = StackTransitionTypeOverLeftRight
    toEnum 19 = StackTransitionTypeOverRightLeft
    toEnum 20 = StackTransitionTypeRotateLeft
    toEnum 21 = StackTransitionTypeRotateRight
    toEnum 22 = StackTransitionTypeRotateLeftRight
    toEnum k = AnotherStackTransitionType k

instance P.Ord StackTransitionType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes StackTransitionType = '[]
instance O.HasParentTypes StackTransitionType

foreign import ccall "gtk_stack_transition_type_get_type" c_gtk_stack_transition_type_get_type :: 
    IO GType

instance B.Types.TypedObject StackTransitionType where
    glibType = c_gtk_stack_transition_type_get_type

instance B.Types.BoxedEnum StackTransitionType

-- Enum SpinType
-- | The values of the GtkSpinType enumeration are used to specify the
-- change to make in 'GI.Gtk.Objects.SpinButton.spinButtonSpin'.
data SpinType = 
      SpinTypeStepForward
    -- ^ Increment by the adjustments step increment.
    | SpinTypeStepBackward
    -- ^ Decrement by the adjustments step increment.
    | SpinTypePageForward
    -- ^ Increment by the adjustments page increment.
    | SpinTypePageBackward
    -- ^ Decrement by the adjustments page increment.
    | SpinTypeHome
    -- ^ Go to the adjustments lower bound.
    | SpinTypeEnd
    -- ^ Go to the adjustments upper bound.
    | SpinTypeUserDefined
    -- ^ Change by a specified amount.
    | AnotherSpinType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SpinType where
    fromEnum SpinTypeStepForward = 0
    fromEnum SpinTypeStepBackward = 1
    fromEnum SpinTypePageForward = 2
    fromEnum SpinTypePageBackward = 3
    fromEnum SpinTypeHome = 4
    fromEnum SpinTypeEnd = 5
    fromEnum SpinTypeUserDefined = 6
    fromEnum (AnotherSpinType k) = k

    toEnum 0 = SpinTypeStepForward
    toEnum 1 = SpinTypeStepBackward
    toEnum 2 = SpinTypePageForward
    toEnum 3 = SpinTypePageBackward
    toEnum 4 = SpinTypeHome
    toEnum 5 = SpinTypeEnd
    toEnum 6 = SpinTypeUserDefined
    toEnum k = AnotherSpinType k

instance P.Ord SpinType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SpinType = '[]
instance O.HasParentTypes SpinType

foreign import ccall "gtk_spin_type_get_type" c_gtk_spin_type_get_type :: 
    IO GType

instance B.Types.TypedObject SpinType where
    glibType = c_gtk_spin_type_get_type

instance B.Types.BoxedEnum SpinType

-- Enum SpinButtonUpdatePolicy
-- | Determines whether the spin button displays values outside the adjustment
-- bounds.
-- 
-- See 'GI.Gtk.Objects.SpinButton.spinButtonSetUpdatePolicy'.
data SpinButtonUpdatePolicy = 
      SpinButtonUpdatePolicyAlways
    -- ^ When refreshing your @GtkSpinButton@, the value is
    --   always displayed
    | SpinButtonUpdatePolicyIfValid
    -- ^ When refreshing your @GtkSpinButton@, the value is
    --   only displayed if it is valid within the bounds of the spin button\'s
    --   adjustment
    | AnotherSpinButtonUpdatePolicy Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SpinButtonUpdatePolicy where
    fromEnum SpinButtonUpdatePolicyAlways = 0
    fromEnum SpinButtonUpdatePolicyIfValid = 1
    fromEnum (AnotherSpinButtonUpdatePolicy k) = k

    toEnum 0 = SpinButtonUpdatePolicyAlways
    toEnum 1 = SpinButtonUpdatePolicyIfValid
    toEnum k = AnotherSpinButtonUpdatePolicy k

instance P.Ord SpinButtonUpdatePolicy where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SpinButtonUpdatePolicy = '[]
instance O.HasParentTypes SpinButtonUpdatePolicy

foreign import ccall "gtk_spin_button_update_policy_get_type" c_gtk_spin_button_update_policy_get_type :: 
    IO GType

instance B.Types.TypedObject SpinButtonUpdatePolicy where
    glibType = c_gtk_spin_button_update_policy_get_type

instance B.Types.BoxedEnum SpinButtonUpdatePolicy

-- Enum SorterOrder
-- | Describes the type of order that a @GtkSorter@ may produce.
data SorterOrder = 
      SorterOrderPartial
    -- ^ A partial order. Any @GtkOrdering@ is possible.
    | SorterOrderNone
    -- ^ No order, all elements are considered equal.
    --   'GI.Gtk.Objects.Sorter.sorterCompare' will only return 'GI.Gtk.Enums.OrderingEqual'.
    | SorterOrderTotal
    -- ^ A total order. 'GI.Gtk.Objects.Sorter.sorterCompare' will only
    --   return 'GI.Gtk.Enums.OrderingEqual' if an item is compared with itself. Two
    --   different items will never cause this value to be returned.
    | AnotherSorterOrder Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SorterOrder where
    fromEnum SorterOrderPartial = 0
    fromEnum SorterOrderNone = 1
    fromEnum SorterOrderTotal = 2
    fromEnum (AnotherSorterOrder k) = k

    toEnum 0 = SorterOrderPartial
    toEnum 1 = SorterOrderNone
    toEnum 2 = SorterOrderTotal
    toEnum k = AnotherSorterOrder k

instance P.Ord SorterOrder where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SorterOrder = '[]
instance O.HasParentTypes SorterOrder

foreign import ccall "gtk_sorter_order_get_type" c_gtk_sorter_order_get_type :: 
    IO GType

instance B.Types.TypedObject SorterOrder where
    glibType = c_gtk_sorter_order_get_type

instance B.Types.BoxedEnum SorterOrder

-- Enum SorterChange
-- | Describes changes in a sorter in more detail and allows users
-- to optimize resorting.
data SorterChange = 
      SorterChangeDifferent
    -- ^ The sorter change cannot be described
    --   by any of the other enumeration values
    | SorterChangeInverted
    -- ^ The sort order was inverted. Comparisons
    --   that returned 'GI.Gtk.Enums.OrderingSmaller' now return 'GI.Gtk.Enums.OrderingLarger'
    --   and vice versa. Other comparisons return the same values as before.
    | SorterChangeLessStrict
    -- ^ The sorter is less strict: Comparisons
    --   may now return 'GI.Gtk.Enums.OrderingEqual' that did not do so before.
    | SorterChangeMoreStrict
    -- ^ The sorter is more strict: Comparisons
    --   that did return 'GI.Gtk.Enums.OrderingEqual' may not do so anymore.
    | AnotherSorterChange Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SorterChange where
    fromEnum SorterChangeDifferent = 0
    fromEnum SorterChangeInverted = 1
    fromEnum SorterChangeLessStrict = 2
    fromEnum SorterChangeMoreStrict = 3
    fromEnum (AnotherSorterChange k) = k

    toEnum 0 = SorterChangeDifferent
    toEnum 1 = SorterChangeInverted
    toEnum 2 = SorterChangeLessStrict
    toEnum 3 = SorterChangeMoreStrict
    toEnum k = AnotherSorterChange k

instance P.Ord SorterChange where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SorterChange = '[]
instance O.HasParentTypes SorterChange

foreign import ccall "gtk_sorter_change_get_type" c_gtk_sorter_change_get_type :: 
    IO GType

instance B.Types.TypedObject SorterChange where
    glibType = c_gtk_sorter_change_get_type

instance B.Types.BoxedEnum SorterChange

-- Enum SortType
-- | Determines the direction of a sort.
data SortType = 
      SortTypeAscending
    -- ^ Sorting is in ascending order.
    | SortTypeDescending
    -- ^ Sorting is in descending order.
    | AnotherSortType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SortType where
    fromEnum SortTypeAscending = 0
    fromEnum SortTypeDescending = 1
    fromEnum (AnotherSortType k) = k

    toEnum 0 = SortTypeAscending
    toEnum 1 = SortTypeDescending
    toEnum k = AnotherSortType k

instance P.Ord SortType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SortType = '[]
instance O.HasParentTypes SortType

foreign import ccall "gtk_sort_type_get_type" c_gtk_sort_type_get_type :: 
    IO GType

instance B.Types.TypedObject SortType where
    glibType = c_gtk_sort_type_get_type

instance B.Types.BoxedEnum SortType

-- Enum SizeRequestMode
-- | Specifies a preference for height-for-width or
-- width-for-height geometry management.
data SizeRequestMode = 
      SizeRequestModeHeightForWidth
    -- ^ Prefer height-for-width geometry management
    | SizeRequestModeWidthForHeight
    -- ^ Prefer width-for-height geometry management
    | SizeRequestModeConstantSize
    -- ^ Don’t trade height-for-width or width-for-height
    | AnotherSizeRequestMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SizeRequestMode where
    fromEnum SizeRequestModeHeightForWidth = 0
    fromEnum SizeRequestModeWidthForHeight = 1
    fromEnum SizeRequestModeConstantSize = 2
    fromEnum (AnotherSizeRequestMode k) = k

    toEnum 0 = SizeRequestModeHeightForWidth
    toEnum 1 = SizeRequestModeWidthForHeight
    toEnum 2 = SizeRequestModeConstantSize
    toEnum k = AnotherSizeRequestMode k

instance P.Ord SizeRequestMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SizeRequestMode = '[]
instance O.HasParentTypes SizeRequestMode

foreign import ccall "gtk_size_request_mode_get_type" c_gtk_size_request_mode_get_type :: 
    IO GType

instance B.Types.TypedObject SizeRequestMode where
    glibType = c_gtk_size_request_mode_get_type

instance B.Types.BoxedEnum SizeRequestMode

-- Enum SizeGroupMode
-- | The mode of the size group determines the directions in which the size
-- group affects the requested sizes of its component widgets.
data SizeGroupMode = 
      SizeGroupModeNone
    -- ^ group has no effect
    | SizeGroupModeHorizontal
    -- ^ group affects horizontal requisition
    | SizeGroupModeVertical
    -- ^ group affects vertical requisition
    | SizeGroupModeBoth
    -- ^ group affects both horizontal and vertical requisition
    | AnotherSizeGroupMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SizeGroupMode where
    fromEnum SizeGroupModeNone = 0
    fromEnum SizeGroupModeHorizontal = 1
    fromEnum SizeGroupModeVertical = 2
    fromEnum SizeGroupModeBoth = 3
    fromEnum (AnotherSizeGroupMode k) = k

    toEnum 0 = SizeGroupModeNone
    toEnum 1 = SizeGroupModeHorizontal
    toEnum 2 = SizeGroupModeVertical
    toEnum 3 = SizeGroupModeBoth
    toEnum k = AnotherSizeGroupMode k

instance P.Ord SizeGroupMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SizeGroupMode = '[]
instance O.HasParentTypes SizeGroupMode

foreign import ccall "gtk_size_group_mode_get_type" c_gtk_size_group_mode_get_type :: 
    IO GType

instance B.Types.TypedObject SizeGroupMode where
    glibType = c_gtk_size_group_mode_get_type

instance B.Types.BoxedEnum SizeGroupMode

-- Enum ShortcutType
-- | GtkShortcutType specifies the kind of shortcut that is being described.
-- 
-- More values may be added to this enumeration over time.
data ShortcutType = 
      ShortcutTypeAccelerator
    -- ^ The shortcut is a keyboard accelerator. The GtkShortcutsShortcut:accelerator
    --   property will be used.
    | ShortcutTypeGesturePinch
    -- ^ The shortcut is a pinch gesture. GTK provides an icon and subtitle.
    | ShortcutTypeGestureStretch
    -- ^ The shortcut is a stretch gesture. GTK provides an icon and subtitle.
    | ShortcutTypeGestureRotateClockwise
    -- ^ The shortcut is a clockwise rotation gesture. GTK provides an icon and subtitle.
    | ShortcutTypeGestureRotateCounterclockwise
    -- ^ The shortcut is a counterclockwise rotation gesture. GTK provides an icon and subtitle.
    | ShortcutTypeGestureTwoFingerSwipeLeft
    -- ^ The shortcut is a two-finger swipe gesture. GTK provides an icon and subtitle.
    | ShortcutTypeGestureTwoFingerSwipeRight
    -- ^ The shortcut is a two-finger swipe gesture. GTK provides an icon and subtitle.
    | ShortcutTypeGesture
    -- ^ The shortcut is a gesture. The GtkShortcutsShortcut:icon property will be
    --   used.
    | ShortcutTypeGestureSwipeLeft
    -- ^ The shortcut is a swipe gesture. GTK provides an icon and subtitle.
    | ShortcutTypeGestureSwipeRight
    -- ^ The shortcut is a swipe gesture. GTK provides an icon and subtitle.
    | AnotherShortcutType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ShortcutType where
    fromEnum ShortcutTypeAccelerator = 0
    fromEnum ShortcutTypeGesturePinch = 1
    fromEnum ShortcutTypeGestureStretch = 2
    fromEnum ShortcutTypeGestureRotateClockwise = 3
    fromEnum ShortcutTypeGestureRotateCounterclockwise = 4
    fromEnum ShortcutTypeGestureTwoFingerSwipeLeft = 5
    fromEnum ShortcutTypeGestureTwoFingerSwipeRight = 6
    fromEnum ShortcutTypeGesture = 7
    fromEnum ShortcutTypeGestureSwipeLeft = 8
    fromEnum ShortcutTypeGestureSwipeRight = 9
    fromEnum (AnotherShortcutType k) = k

    toEnum 0 = ShortcutTypeAccelerator
    toEnum 1 = ShortcutTypeGesturePinch
    toEnum 2 = ShortcutTypeGestureStretch
    toEnum 3 = ShortcutTypeGestureRotateClockwise
    toEnum 4 = ShortcutTypeGestureRotateCounterclockwise
    toEnum 5 = ShortcutTypeGestureTwoFingerSwipeLeft
    toEnum 6 = ShortcutTypeGestureTwoFingerSwipeRight
    toEnum 7 = ShortcutTypeGesture
    toEnum 8 = ShortcutTypeGestureSwipeLeft
    toEnum 9 = ShortcutTypeGestureSwipeRight
    toEnum k = AnotherShortcutType k

instance P.Ord ShortcutType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ShortcutType = '[]
instance O.HasParentTypes ShortcutType

foreign import ccall "gtk_shortcut_type_get_type" c_gtk_shortcut_type_get_type :: 
    IO GType

instance B.Types.TypedObject ShortcutType where
    glibType = c_gtk_shortcut_type_get_type

instance B.Types.BoxedEnum ShortcutType

-- Enum ShortcutScope
-- | Describes where [class/@shortcut@/]s added to a
-- [class/@shortcutController@/] get handled.
data ShortcutScope = 
      ShortcutScopeLocal
    -- ^ Shortcuts are handled inside
    --   the widget the controller belongs to.
    | ShortcutScopeManaged
    -- ^ Shortcuts are handled by
    --   the first ancestor that is a [iface/@shortcutManager@/]
    | ShortcutScopeGlobal
    -- ^ Shortcuts are handled by
    --   the root widget.
    | AnotherShortcutScope Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ShortcutScope where
    fromEnum ShortcutScopeLocal = 0
    fromEnum ShortcutScopeManaged = 1
    fromEnum ShortcutScopeGlobal = 2
    fromEnum (AnotherShortcutScope k) = k

    toEnum 0 = ShortcutScopeLocal
    toEnum 1 = ShortcutScopeManaged
    toEnum 2 = ShortcutScopeGlobal
    toEnum k = AnotherShortcutScope k

instance P.Ord ShortcutScope where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ShortcutScope = '[]
instance O.HasParentTypes ShortcutScope

foreign import ccall "gtk_shortcut_scope_get_type" c_gtk_shortcut_scope_get_type :: 
    IO GType

instance B.Types.TypedObject ShortcutScope where
    glibType = c_gtk_shortcut_scope_get_type

instance B.Types.BoxedEnum ShortcutScope

-- Enum SensitivityType
-- | Determines how GTK handles the sensitivity of various controls,
-- such as combo box buttons.
data SensitivityType = 
      SensitivityTypeAuto
    -- ^ The control is made insensitive if no
    --   action can be triggered
    | SensitivityTypeOn
    -- ^ The control is always sensitive
    | SensitivityTypeOff
    -- ^ The control is always insensitive
    | AnotherSensitivityType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SensitivityType where
    fromEnum SensitivityTypeAuto = 0
    fromEnum SensitivityTypeOn = 1
    fromEnum SensitivityTypeOff = 2
    fromEnum (AnotherSensitivityType k) = k

    toEnum 0 = SensitivityTypeAuto
    toEnum 1 = SensitivityTypeOn
    toEnum 2 = SensitivityTypeOff
    toEnum k = AnotherSensitivityType k

instance P.Ord SensitivityType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SensitivityType = '[]
instance O.HasParentTypes SensitivityType

foreign import ccall "gtk_sensitivity_type_get_type" c_gtk_sensitivity_type_get_type :: 
    IO GType

instance B.Types.TypedObject SensitivityType where
    glibType = c_gtk_sensitivity_type_get_type

instance B.Types.BoxedEnum SensitivityType

-- Enum SelectionMode
-- | Used to control what selections users are allowed to make.
data SelectionMode = 
      SelectionModeNone
    -- ^ No selection is possible.
    | SelectionModeSingle
    -- ^ Zero or one element may be selected.
    | SelectionModeBrowse
    -- ^ Exactly one element is selected.
    --   In some circumstances, such as initially or during a search
    --   operation, it’s possible for no element to be selected with
    --   'GI.Gtk.Enums.SelectionModeBrowse'. What is really enforced is that the user
    --   can’t deselect a currently selected element except by selecting
    --   another element.
    | SelectionModeMultiple
    -- ^ Any number of elements may be selected.
    --   The Ctrl key may be used to enlarge the selection, and Shift
    --   key to select between the focus and the child pointed to.
    --   Some widgets may also allow Click-drag to select a range of elements.
    | AnotherSelectionMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SelectionMode where
    fromEnum SelectionModeNone = 0
    fromEnum SelectionModeSingle = 1
    fromEnum SelectionModeBrowse = 2
    fromEnum SelectionModeMultiple = 3
    fromEnum (AnotherSelectionMode k) = k

    toEnum 0 = SelectionModeNone
    toEnum 1 = SelectionModeSingle
    toEnum 2 = SelectionModeBrowse
    toEnum 3 = SelectionModeMultiple
    toEnum k = AnotherSelectionMode k

instance P.Ord SelectionMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SelectionMode = '[]
instance O.HasParentTypes SelectionMode

foreign import ccall "gtk_selection_mode_get_type" c_gtk_selection_mode_get_type :: 
    IO GType

instance B.Types.TypedObject SelectionMode where
    glibType = c_gtk_selection_mode_get_type

instance B.Types.BoxedEnum SelectionMode

-- Enum ScrollablePolicy
-- | Defines the policy to be used in a scrollable widget when updating
-- the scrolled window adjustments in a given orientation.
data ScrollablePolicy = 
      ScrollablePolicyMinimum
    -- ^ Scrollable adjustments are based on the minimum size
    | ScrollablePolicyNatural
    -- ^ Scrollable adjustments are based on the natural size
    | AnotherScrollablePolicy Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScrollablePolicy where
    fromEnum ScrollablePolicyMinimum = 0
    fromEnum ScrollablePolicyNatural = 1
    fromEnum (AnotherScrollablePolicy k) = k

    toEnum 0 = ScrollablePolicyMinimum
    toEnum 1 = ScrollablePolicyNatural
    toEnum k = AnotherScrollablePolicy k

instance P.Ord ScrollablePolicy where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScrollablePolicy = '[]
instance O.HasParentTypes ScrollablePolicy

foreign import ccall "gtk_scrollable_policy_get_type" c_gtk_scrollable_policy_get_type :: 
    IO GType

instance B.Types.TypedObject ScrollablePolicy where
    glibType = c_gtk_scrollable_policy_get_type

instance B.Types.BoxedEnum ScrollablePolicy

-- Enum ScrollType
-- | Scrolling types.
data ScrollType = 
      ScrollTypeNone
    -- ^ No scrolling.
    | ScrollTypeJump
    -- ^ Jump to new location.
    | ScrollTypeStepBackward
    -- ^ Step backward.
    | ScrollTypeStepForward
    -- ^ Step forward.
    | ScrollTypePageBackward
    -- ^ Page backward.
    | ScrollTypePageForward
    -- ^ Page forward.
    | ScrollTypeStepUp
    -- ^ Step up.
    | ScrollTypeStepDown
    -- ^ Step down.
    | ScrollTypePageUp
    -- ^ Page up.
    | ScrollTypePageDown
    -- ^ Page down.
    | ScrollTypeStepLeft
    -- ^ Step to the left.
    | ScrollTypeStepRight
    -- ^ Step to the right.
    | ScrollTypePageLeft
    -- ^ Page to the left.
    | ScrollTypePageRight
    -- ^ Page to the right.
    | ScrollTypeStart
    -- ^ Scroll to start.
    | ScrollTypeEnd
    -- ^ Scroll to end.
    | AnotherScrollType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScrollType where
    fromEnum ScrollTypeNone = 0
    fromEnum ScrollTypeJump = 1
    fromEnum ScrollTypeStepBackward = 2
    fromEnum ScrollTypeStepForward = 3
    fromEnum ScrollTypePageBackward = 4
    fromEnum ScrollTypePageForward = 5
    fromEnum ScrollTypeStepUp = 6
    fromEnum ScrollTypeStepDown = 7
    fromEnum ScrollTypePageUp = 8
    fromEnum ScrollTypePageDown = 9
    fromEnum ScrollTypeStepLeft = 10
    fromEnum ScrollTypeStepRight = 11
    fromEnum ScrollTypePageLeft = 12
    fromEnum ScrollTypePageRight = 13
    fromEnum ScrollTypeStart = 14
    fromEnum ScrollTypeEnd = 15
    fromEnum (AnotherScrollType k) = k

    toEnum 0 = ScrollTypeNone
    toEnum 1 = ScrollTypeJump
    toEnum 2 = ScrollTypeStepBackward
    toEnum 3 = ScrollTypeStepForward
    toEnum 4 = ScrollTypePageBackward
    toEnum 5 = ScrollTypePageForward
    toEnum 6 = ScrollTypeStepUp
    toEnum 7 = ScrollTypeStepDown
    toEnum 8 = ScrollTypePageUp
    toEnum 9 = ScrollTypePageDown
    toEnum 10 = ScrollTypeStepLeft
    toEnum 11 = ScrollTypeStepRight
    toEnum 12 = ScrollTypePageLeft
    toEnum 13 = ScrollTypePageRight
    toEnum 14 = ScrollTypeStart
    toEnum 15 = ScrollTypeEnd
    toEnum k = AnotherScrollType k

instance P.Ord ScrollType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScrollType = '[]
instance O.HasParentTypes ScrollType

foreign import ccall "gtk_scroll_type_get_type" c_gtk_scroll_type_get_type :: 
    IO GType

instance B.Types.TypedObject ScrollType where
    glibType = c_gtk_scroll_type_get_type

instance B.Types.BoxedEnum ScrollType

-- Enum ScrollStep
-- | Passed as argument to various keybinding signals.
data ScrollStep = 
      ScrollStepSteps
    -- ^ Scroll in steps.
    | ScrollStepPages
    -- ^ Scroll by pages.
    | ScrollStepEnds
    -- ^ Scroll to ends.
    | ScrollStepHorizontalSteps
    -- ^ Scroll in horizontal steps.
    | ScrollStepHorizontalPages
    -- ^ Scroll by horizontal pages.
    | ScrollStepHorizontalEnds
    -- ^ Scroll to the horizontal ends.
    | AnotherScrollStep Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScrollStep where
    fromEnum ScrollStepSteps = 0
    fromEnum ScrollStepPages = 1
    fromEnum ScrollStepEnds = 2
    fromEnum ScrollStepHorizontalSteps = 3
    fromEnum ScrollStepHorizontalPages = 4
    fromEnum ScrollStepHorizontalEnds = 5
    fromEnum (AnotherScrollStep k) = k

    toEnum 0 = ScrollStepSteps
    toEnum 1 = ScrollStepPages
    toEnum 2 = ScrollStepEnds
    toEnum 3 = ScrollStepHorizontalSteps
    toEnum 4 = ScrollStepHorizontalPages
    toEnum 5 = ScrollStepHorizontalEnds
    toEnum k = AnotherScrollStep k

instance P.Ord ScrollStep where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScrollStep = '[]
instance O.HasParentTypes ScrollStep

foreign import ccall "gtk_scroll_step_get_type" c_gtk_scroll_step_get_type :: 
    IO GType

instance B.Types.TypedObject ScrollStep where
    glibType = c_gtk_scroll_step_get_type

instance B.Types.BoxedEnum ScrollStep

-- Enum RevealerTransitionType
-- | These enumeration values describe the possible transitions
-- when the child of a @GtkRevealer@ widget is shown or hidden.
data RevealerTransitionType = 
      RevealerTransitionTypeNone
    -- ^ No transition
    | RevealerTransitionTypeCrossfade
    -- ^ Fade in
    | RevealerTransitionTypeSlideRight
    -- ^ Slide in from the left
    | RevealerTransitionTypeSlideLeft
    -- ^ Slide in from the right
    | RevealerTransitionTypeSlideUp
    -- ^ Slide in from the bottom
    | RevealerTransitionTypeSlideDown
    -- ^ Slide in from the top
    | RevealerTransitionTypeSwingRight
    -- ^ Floop in from the left
    | RevealerTransitionTypeSwingLeft
    -- ^ Floop in from the right
    | RevealerTransitionTypeSwingUp
    -- ^ Floop in from the bottom
    | RevealerTransitionTypeSwingDown
    -- ^ Floop in from the top
    | AnotherRevealerTransitionType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum RevealerTransitionType where
    fromEnum RevealerTransitionTypeNone = 0
    fromEnum RevealerTransitionTypeCrossfade = 1
    fromEnum RevealerTransitionTypeSlideRight = 2
    fromEnum RevealerTransitionTypeSlideLeft = 3
    fromEnum RevealerTransitionTypeSlideUp = 4
    fromEnum RevealerTransitionTypeSlideDown = 5
    fromEnum RevealerTransitionTypeSwingRight = 6
    fromEnum RevealerTransitionTypeSwingLeft = 7
    fromEnum RevealerTransitionTypeSwingUp = 8
    fromEnum RevealerTransitionTypeSwingDown = 9
    fromEnum (AnotherRevealerTransitionType k) = k

    toEnum 0 = RevealerTransitionTypeNone
    toEnum 1 = RevealerTransitionTypeCrossfade
    toEnum 2 = RevealerTransitionTypeSlideRight
    toEnum 3 = RevealerTransitionTypeSlideLeft
    toEnum 4 = RevealerTransitionTypeSlideUp
    toEnum 5 = RevealerTransitionTypeSlideDown
    toEnum 6 = RevealerTransitionTypeSwingRight
    toEnum 7 = RevealerTransitionTypeSwingLeft
    toEnum 8 = RevealerTransitionTypeSwingUp
    toEnum 9 = RevealerTransitionTypeSwingDown
    toEnum k = AnotherRevealerTransitionType k

instance P.Ord RevealerTransitionType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes RevealerTransitionType = '[]
instance O.HasParentTypes RevealerTransitionType

foreign import ccall "gtk_revealer_transition_type_get_type" c_gtk_revealer_transition_type_get_type :: 
    IO GType

instance B.Types.TypedObject RevealerTransitionType where
    glibType = c_gtk_revealer_transition_type_get_type

instance B.Types.BoxedEnum RevealerTransitionType

-- Enum ResponseType
{-# DEPRECATED ResponseType ["(Since version 4.20)","There is no replacement."] #-}
-- | Predefined values for use as response ids in 'GI.Gtk.Objects.Dialog.dialogAddButton'.
-- 
-- All predefined values are negative; GTK leaves values of 0 or greater for
-- application-defined response ids.
data ResponseType = 
      ResponseTypeNone
    -- ^ Returned if an action widget has no response id,
    --   or if the dialog gets programmatically hidden or destroyed
    | ResponseTypeReject
    -- ^ Generic response id, not used by GTK dialogs
    | ResponseTypeAccept
    -- ^ Generic response id, not used by GTK dialogs
    | ResponseTypeDeleteEvent
    -- ^ Returned if the dialog is deleted
    | ResponseTypeOk
    -- ^ Returned by OK buttons in GTK dialogs
    | ResponseTypeCancel
    -- ^ Returned by Cancel buttons in GTK dialogs
    | ResponseTypeClose
    -- ^ Returned by Close buttons in GTK dialogs
    | ResponseTypeYes
    -- ^ Returned by Yes buttons in GTK dialogs
    | ResponseTypeNo
    -- ^ Returned by No buttons in GTK dialogs
    | ResponseTypeApply
    -- ^ Returned by Apply buttons in GTK dialogs
    | ResponseTypeHelp
    -- ^ Returned by Help buttons in GTK dialogs
    | AnotherResponseType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ResponseType where
    fromEnum ResponseTypeNone = -1
    fromEnum ResponseTypeReject = -2
    fromEnum ResponseTypeAccept = -3
    fromEnum ResponseTypeDeleteEvent = -4
    fromEnum ResponseTypeOk = -5
    fromEnum ResponseTypeCancel = -6
    fromEnum ResponseTypeClose = -7
    fromEnum ResponseTypeYes = -8
    fromEnum ResponseTypeNo = -9
    fromEnum ResponseTypeApply = -10
    fromEnum ResponseTypeHelp = -11
    fromEnum (AnotherResponseType k) = k

    toEnum -1 = ResponseTypeNone
    toEnum -2 = ResponseTypeReject
    toEnum -3 = ResponseTypeAccept
    toEnum -4 = ResponseTypeDeleteEvent
    toEnum -5 = ResponseTypeOk
    toEnum -6 = ResponseTypeCancel
    toEnum -7 = ResponseTypeClose
    toEnum -8 = ResponseTypeYes
    toEnum -9 = ResponseTypeNo
    toEnum -10 = ResponseTypeApply
    toEnum -11 = ResponseTypeHelp
    toEnum k = AnotherResponseType k

instance P.Ord ResponseType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ResponseType = '[]
instance O.HasParentTypes ResponseType

foreign import ccall "gtk_response_type_get_type" c_gtk_response_type_get_type :: 
    IO GType

instance B.Types.TypedObject ResponseType where
    glibType = c_gtk_response_type_get_type

instance B.Types.BoxedEnum ResponseType

-- Enum RecentManagerError
-- | Error codes for @GtkRecentManager@ operations
data RecentManagerError = 
      RecentManagerErrorNotFound
    -- ^ the URI specified does not exists in
    --   the recently used resources list.
    | RecentManagerErrorInvalidUri
    -- ^ the URI specified is not valid.
    | RecentManagerErrorInvalidEncoding
    -- ^ the supplied string is not
    --   UTF-8 encoded.
    | RecentManagerErrorNotRegistered
    -- ^ no application has registered
    --   the specified item.
    | RecentManagerErrorRead
    -- ^ failure while reading the recently used
    --   resources file.
    | RecentManagerErrorWrite
    -- ^ failure while writing the recently used
    --   resources file.
    | RecentManagerErrorUnknown
    -- ^ unspecified error.
    | AnotherRecentManagerError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum RecentManagerError where
    fromEnum RecentManagerErrorNotFound = 0
    fromEnum RecentManagerErrorInvalidUri = 1
    fromEnum RecentManagerErrorInvalidEncoding = 2
    fromEnum RecentManagerErrorNotRegistered = 3
    fromEnum RecentManagerErrorRead = 4
    fromEnum RecentManagerErrorWrite = 5
    fromEnum RecentManagerErrorUnknown = 6
    fromEnum (AnotherRecentManagerError k) = k

    toEnum 0 = RecentManagerErrorNotFound
    toEnum 1 = RecentManagerErrorInvalidUri
    toEnum 2 = RecentManagerErrorInvalidEncoding
    toEnum 3 = RecentManagerErrorNotRegistered
    toEnum 4 = RecentManagerErrorRead
    toEnum 5 = RecentManagerErrorWrite
    toEnum 6 = RecentManagerErrorUnknown
    toEnum k = AnotherRecentManagerError k

instance P.Ord RecentManagerError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass RecentManagerError where
    gerrorClassDomain _ = "gtk-recent-manager-error-quark"

-- | Catch exceptions of type `RecentManagerError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchRecentManagerError ::
    IO a ->
    (RecentManagerError -> GErrorMessage -> IO a) ->
    IO a
catchRecentManagerError = catchGErrorJustDomain

-- | Handle exceptions of type `RecentManagerError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleRecentManagerError ::
    (RecentManagerError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleRecentManagerError = handleGErrorJustDomain

type instance O.ParentTypes RecentManagerError = '[]
instance O.HasParentTypes RecentManagerError

foreign import ccall "gtk_recent_manager_error_get_type" c_gtk_recent_manager_error_get_type :: 
    IO GType

instance B.Types.TypedObject RecentManagerError where
    glibType = c_gtk_recent_manager_error_get_type

instance B.Types.BoxedEnum RecentManagerError

-- Enum PropagationPhase
-- | Describes the stage at which events are fed into a [class/@eventController@/].
data PropagationPhase = 
      PropagationPhaseNone
    -- ^ Events are not delivered.
    | PropagationPhaseCapture
    -- ^ Events are delivered in the capture phase. The
    --   capture phase happens before the bubble phase, runs from the toplevel down
    --   to the event widget. This option should only be used on containers that
    --   might possibly handle events before their children do.
    | PropagationPhaseBubble
    -- ^ Events are delivered in the bubble phase. The bubble
    --   phase happens after the capture phase, and before the default handlers
    --   are run. This phase runs from the event widget, up to the toplevel.
    | PropagationPhaseTarget
    -- ^ Events are delivered in the default widget event handlers,
    --   note that widget implementations must chain up on button, motion, touch and
    --   grab broken handlers for controllers in this phase to be run.
    | AnotherPropagationPhase Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PropagationPhase where
    fromEnum PropagationPhaseNone = 0
    fromEnum PropagationPhaseCapture = 1
    fromEnum PropagationPhaseBubble = 2
    fromEnum PropagationPhaseTarget = 3
    fromEnum (AnotherPropagationPhase k) = k

    toEnum 0 = PropagationPhaseNone
    toEnum 1 = PropagationPhaseCapture
    toEnum 2 = PropagationPhaseBubble
    toEnum 3 = PropagationPhaseTarget
    toEnum k = AnotherPropagationPhase k

instance P.Ord PropagationPhase where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PropagationPhase = '[]
instance O.HasParentTypes PropagationPhase

foreign import ccall "gtk_propagation_phase_get_type" c_gtk_propagation_phase_get_type :: 
    IO GType

instance B.Types.TypedObject PropagationPhase where
    glibType = c_gtk_propagation_phase_get_type

instance B.Types.BoxedEnum PropagationPhase

-- Enum PropagationLimit
-- | Describes limits of a [class/@eventController@/] for handling events
-- targeting other widgets.
data PropagationLimit = 
      PropagationLimitNone
    -- ^ Events are handled regardless of what their
    --   target is.
    | PropagationLimitSameNative
    -- ^ Events are only handled if their target is in
    --   the same [iface/@native@/] (or widget with [Widget:limitEvents]("GI.Gtk.Objects.Widget#g:attr:limitEvents")
    --   set) as the event controllers widget.
    --   Note that some event types have two targets (origin and destination).
    | AnotherPropagationLimit Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PropagationLimit where
    fromEnum PropagationLimitNone = 0
    fromEnum PropagationLimitSameNative = 1
    fromEnum (AnotherPropagationLimit k) = k

    toEnum 0 = PropagationLimitNone
    toEnum 1 = PropagationLimitSameNative
    toEnum k = AnotherPropagationLimit k

instance P.Ord PropagationLimit where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PropagationLimit = '[]
instance O.HasParentTypes PropagationLimit

foreign import ccall "gtk_propagation_limit_get_type" c_gtk_propagation_limit_get_type :: 
    IO GType

instance B.Types.TypedObject PropagationLimit where
    glibType = c_gtk_propagation_limit_get_type

instance B.Types.BoxedEnum PropagationLimit

-- Enum PrintStatus
-- | The status gives a rough indication of the completion of a running
-- print operation.
data PrintStatus = 
      PrintStatusInitial
    -- ^ The printing has not started yet; this
    --   status is set initially, and while the print dialog is shown.
    | PrintStatusPreparing
    -- ^ This status is set while the begin-print
    --   signal is emitted and during pagination.
    | PrintStatusGeneratingData
    -- ^ This status is set while the
    --   pages are being rendered.
    | PrintStatusSendingData
    -- ^ The print job is being sent off to the
    --   printer.
    | PrintStatusPending
    -- ^ The print job has been sent to the printer,
    --   but is not printed for some reason, e.g. the printer may be stopped.
    | PrintStatusPendingIssue
    -- ^ Some problem has occurred during
    --   printing, e.g. a paper jam.
    | PrintStatusPrinting
    -- ^ The printer is processing the print job.
    | PrintStatusFinished
    -- ^ The printing has been completed successfully.
    | PrintStatusFinishedAborted
    -- ^ The printing has been aborted.
    | AnotherPrintStatus Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PrintStatus where
    fromEnum PrintStatusInitial = 0
    fromEnum PrintStatusPreparing = 1
    fromEnum PrintStatusGeneratingData = 2
    fromEnum PrintStatusSendingData = 3
    fromEnum PrintStatusPending = 4
    fromEnum PrintStatusPendingIssue = 5
    fromEnum PrintStatusPrinting = 6
    fromEnum PrintStatusFinished = 7
    fromEnum PrintStatusFinishedAborted = 8
    fromEnum (AnotherPrintStatus k) = k

    toEnum 0 = PrintStatusInitial
    toEnum 1 = PrintStatusPreparing
    toEnum 2 = PrintStatusGeneratingData
    toEnum 3 = PrintStatusSendingData
    toEnum 4 = PrintStatusPending
    toEnum 5 = PrintStatusPendingIssue
    toEnum 6 = PrintStatusPrinting
    toEnum 7 = PrintStatusFinished
    toEnum 8 = PrintStatusFinishedAborted
    toEnum k = AnotherPrintStatus k

instance P.Ord PrintStatus where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PrintStatus = '[]
instance O.HasParentTypes PrintStatus

foreign import ccall "gtk_print_status_get_type" c_gtk_print_status_get_type :: 
    IO GType

instance B.Types.TypedObject PrintStatus where
    glibType = c_gtk_print_status_get_type

instance B.Types.BoxedEnum PrintStatus

-- Enum PrintQuality
-- | See also 'GI.Gtk.Objects.PrintSettings.printSettingsSetQuality'.
data PrintQuality = 
      PrintQualityLow
    -- ^ Low quality.
    | PrintQualityNormal
    -- ^ Normal quality.
    | PrintQualityHigh
    -- ^ High quality.
    | PrintQualityDraft
    -- ^ Draft quality.
    | AnotherPrintQuality Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PrintQuality where
    fromEnum PrintQualityLow = 0
    fromEnum PrintQualityNormal = 1
    fromEnum PrintQualityHigh = 2
    fromEnum PrintQualityDraft = 3
    fromEnum (AnotherPrintQuality k) = k

    toEnum 0 = PrintQualityLow
    toEnum 1 = PrintQualityNormal
    toEnum 2 = PrintQualityHigh
    toEnum 3 = PrintQualityDraft
    toEnum k = AnotherPrintQuality k

instance P.Ord PrintQuality where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PrintQuality = '[]
instance O.HasParentTypes PrintQuality

foreign import ccall "gtk_print_quality_get_type" c_gtk_print_quality_get_type :: 
    IO GType

instance B.Types.TypedObject PrintQuality where
    glibType = c_gtk_print_quality_get_type

instance B.Types.BoxedEnum PrintQuality

-- Enum PrintPages
-- | See also 'GI.Gtk.Objects.PrintJob.printJobSetPages'
data PrintPages = 
      PrintPagesAll
    -- ^ All pages.
    | PrintPagesCurrent
    -- ^ Current page.
    | PrintPagesRanges
    -- ^ Range of pages.
    | PrintPagesSelection
    -- ^ Selected pages.
    | AnotherPrintPages Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PrintPages where
    fromEnum PrintPagesAll = 0
    fromEnum PrintPagesCurrent = 1
    fromEnum PrintPagesRanges = 2
    fromEnum PrintPagesSelection = 3
    fromEnum (AnotherPrintPages k) = k

    toEnum 0 = PrintPagesAll
    toEnum 1 = PrintPagesCurrent
    toEnum 2 = PrintPagesRanges
    toEnum 3 = PrintPagesSelection
    toEnum k = AnotherPrintPages k

instance P.Ord PrintPages where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PrintPages = '[]
instance O.HasParentTypes PrintPages

foreign import ccall "gtk_print_pages_get_type" c_gtk_print_pages_get_type :: 
    IO GType

instance B.Types.TypedObject PrintPages where
    glibType = c_gtk_print_pages_get_type

instance B.Types.BoxedEnum PrintPages

-- Enum PrintOperationResult
-- | The result of a print operation.
-- 
-- A value of this type is returned by 'GI.Gtk.Objects.PrintOperation.printOperationRun'.
data PrintOperationResult = 
      PrintOperationResultError
    -- ^ An error has occurred.
    | PrintOperationResultApply
    -- ^ The print settings should be stored.
    | PrintOperationResultCancel
    -- ^ The print operation has been canceled,
    --   the print settings should not be stored.
    | PrintOperationResultInProgress
    -- ^ The print operation is not complete
    --   yet. This value will only be returned when running asynchronously.
    | AnotherPrintOperationResult Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PrintOperationResult where
    fromEnum PrintOperationResultError = 0
    fromEnum PrintOperationResultApply = 1
    fromEnum PrintOperationResultCancel = 2
    fromEnum PrintOperationResultInProgress = 3
    fromEnum (AnotherPrintOperationResult k) = k

    toEnum 0 = PrintOperationResultError
    toEnum 1 = PrintOperationResultApply
    toEnum 2 = PrintOperationResultCancel
    toEnum 3 = PrintOperationResultInProgress
    toEnum k = AnotherPrintOperationResult k

instance P.Ord PrintOperationResult where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PrintOperationResult = '[]
instance O.HasParentTypes PrintOperationResult

foreign import ccall "gtk_print_operation_result_get_type" c_gtk_print_operation_result_get_type :: 
    IO GType

instance B.Types.TypedObject PrintOperationResult where
    glibType = c_gtk_print_operation_result_get_type

instance B.Types.BoxedEnum PrintOperationResult

-- Enum PrintOperationAction
-- | Determines what action the print operation should perform.
-- 
-- A parameter of this typs is passed to 'GI.Gtk.Objects.PrintOperation.printOperationRun'.
data PrintOperationAction = 
      PrintOperationActionPrintDialog
    -- ^ Show the print dialog.
    | PrintOperationActionPrint
    -- ^ Start to print without showing
    --   the print dialog, based on the current print settings, if possible.
    --   Depending on the platform, a print dialog might appear anyway.
    | PrintOperationActionPreview
    -- ^ Show the print preview.
    | PrintOperationActionExport
    -- ^ Export to a file. This requires
    --   the export-filename property to be set.
    | AnotherPrintOperationAction Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PrintOperationAction where
    fromEnum PrintOperationActionPrintDialog = 0
    fromEnum PrintOperationActionPrint = 1
    fromEnum PrintOperationActionPreview = 2
    fromEnum PrintOperationActionExport = 3
    fromEnum (AnotherPrintOperationAction k) = k

    toEnum 0 = PrintOperationActionPrintDialog
    toEnum 1 = PrintOperationActionPrint
    toEnum 2 = PrintOperationActionPreview
    toEnum 3 = PrintOperationActionExport
    toEnum k = AnotherPrintOperationAction k

instance P.Ord PrintOperationAction where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PrintOperationAction = '[]
instance O.HasParentTypes PrintOperationAction

foreign import ccall "gtk_print_operation_action_get_type" c_gtk_print_operation_action_get_type :: 
    IO GType

instance B.Types.TypedObject PrintOperationAction where
    glibType = c_gtk_print_operation_action_get_type

instance B.Types.BoxedEnum PrintOperationAction

-- Enum PrintError
-- | Error codes that identify various errors that can occur while
-- using the GTK printing support.
data PrintError = 
      PrintErrorGeneral
    -- ^ An unspecified error occurred.
    | PrintErrorInternalError
    -- ^ An internal error occurred.
    | PrintErrorNomem
    -- ^ A memory allocation failed.
    | PrintErrorInvalidFile
    -- ^ An error occurred while loading a page setup
    --   or paper size from a key file.
    | AnotherPrintError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PrintError where
    fromEnum PrintErrorGeneral = 0
    fromEnum PrintErrorInternalError = 1
    fromEnum PrintErrorNomem = 2
    fromEnum PrintErrorInvalidFile = 3
    fromEnum (AnotherPrintError k) = k

    toEnum 0 = PrintErrorGeneral
    toEnum 1 = PrintErrorInternalError
    toEnum 2 = PrintErrorNomem
    toEnum 3 = PrintErrorInvalidFile
    toEnum k = AnotherPrintError k

instance P.Ord PrintError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass PrintError where
    gerrorClassDomain _ = "gtk-print-error-quark"

-- | Catch exceptions of type `PrintError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchPrintError ::
    IO a ->
    (PrintError -> GErrorMessage -> IO a) ->
    IO a
catchPrintError = catchGErrorJustDomain

-- | Handle exceptions of type `PrintError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handlePrintError ::
    (PrintError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handlePrintError = handleGErrorJustDomain

type instance O.ParentTypes PrintError = '[]
instance O.HasParentTypes PrintError

foreign import ccall "gtk_print_error_get_type" c_gtk_print_error_get_type :: 
    IO GType

instance B.Types.TypedObject PrintError where
    glibType = c_gtk_print_error_get_type

instance B.Types.BoxedEnum PrintError

-- Enum PrintDuplex
-- | See also 'GI.Gtk.Objects.PrintSettings.printSettingsSetDuplex'.
data PrintDuplex = 
      PrintDuplexSimplex
    -- ^ No duplex.
    | PrintDuplexHorizontal
    -- ^ Horizontal duplex.
    | PrintDuplexVertical
    -- ^ Vertical duplex.
    | AnotherPrintDuplex Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PrintDuplex where
    fromEnum PrintDuplexSimplex = 0
    fromEnum PrintDuplexHorizontal = 1
    fromEnum PrintDuplexVertical = 2
    fromEnum (AnotherPrintDuplex k) = k

    toEnum 0 = PrintDuplexSimplex
    toEnum 1 = PrintDuplexHorizontal
    toEnum 2 = PrintDuplexVertical
    toEnum k = AnotherPrintDuplex k

instance P.Ord PrintDuplex where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PrintDuplex = '[]
instance O.HasParentTypes PrintDuplex

foreign import ccall "gtk_print_duplex_get_type" c_gtk_print_duplex_get_type :: 
    IO GType

instance B.Types.TypedObject PrintDuplex where
    glibType = c_gtk_print_duplex_get_type

instance B.Types.BoxedEnum PrintDuplex

-- Enum PositionType
-- | Describes which edge of a widget a certain feature is positioned at.
-- 
-- For examples, see the tabs of a [class/@notebook@/], or the label
-- of a [class/@scale@/].
data PositionType = 
      PositionTypeLeft
    -- ^ The feature is at the left edge.
    | PositionTypeRight
    -- ^ The feature is at the right edge.
    | PositionTypeTop
    -- ^ The feature is at the top edge.
    | PositionTypeBottom
    -- ^ The feature is at the bottom edge.
    | AnotherPositionType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PositionType where
    fromEnum PositionTypeLeft = 0
    fromEnum PositionTypeRight = 1
    fromEnum PositionTypeTop = 2
    fromEnum PositionTypeBottom = 3
    fromEnum (AnotherPositionType k) = k

    toEnum 0 = PositionTypeLeft
    toEnum 1 = PositionTypeRight
    toEnum 2 = PositionTypeTop
    toEnum 3 = PositionTypeBottom
    toEnum k = AnotherPositionType k

instance P.Ord PositionType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PositionType = '[]
instance O.HasParentTypes PositionType

foreign import ccall "gtk_position_type_get_type" c_gtk_position_type_get_type :: 
    IO GType

instance B.Types.TypedObject PositionType where
    glibType = c_gtk_position_type_get_type

instance B.Types.BoxedEnum PositionType

-- Enum PolicyType
-- | Determines how the size should be computed to achieve the one of the
-- visibility mode for the scrollbars.
data PolicyType = 
      PolicyTypeAlways
    -- ^ The scrollbar is always visible. The view size is
    --   independent of the content.
    | PolicyTypeAutomatic
    -- ^ The scrollbar will appear and disappear as necessary.
    --   For example, when all of a @GtkTreeView@ can not be seen.
    | PolicyTypeNever
    -- ^ The scrollbar should never appear. In this mode the
    --   content determines the size.
    | PolicyTypeExternal
    -- ^ Don\'t show a scrollbar, but don\'t force the
    --   size to follow the content. This can be used e.g. to make multiple
    --   scrolled windows share a scrollbar.
    | AnotherPolicyType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PolicyType where
    fromEnum PolicyTypeAlways = 0
    fromEnum PolicyTypeAutomatic = 1
    fromEnum PolicyTypeNever = 2
    fromEnum PolicyTypeExternal = 3
    fromEnum (AnotherPolicyType k) = k

    toEnum 0 = PolicyTypeAlways
    toEnum 1 = PolicyTypeAutomatic
    toEnum 2 = PolicyTypeNever
    toEnum 3 = PolicyTypeExternal
    toEnum k = AnotherPolicyType k

instance P.Ord PolicyType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PolicyType = '[]
instance O.HasParentTypes PolicyType

foreign import ccall "gtk_policy_type_get_type" c_gtk_policy_type_get_type :: 
    IO GType

instance B.Types.TypedObject PolicyType where
    glibType = c_gtk_policy_type_get_type

instance B.Types.BoxedEnum PolicyType

-- Enum PanDirection
-- | Describes the panning direction of a [class/@gesturePan@/].
data PanDirection = 
      PanDirectionLeft
    -- ^ panned towards the left
    | PanDirectionRight
    -- ^ panned towards the right
    | PanDirectionUp
    -- ^ panned upwards
    | PanDirectionDown
    -- ^ panned downwards
    | AnotherPanDirection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PanDirection where
    fromEnum PanDirectionLeft = 0
    fromEnum PanDirectionRight = 1
    fromEnum PanDirectionUp = 2
    fromEnum PanDirectionDown = 3
    fromEnum (AnotherPanDirection k) = k

    toEnum 0 = PanDirectionLeft
    toEnum 1 = PanDirectionRight
    toEnum 2 = PanDirectionUp
    toEnum 3 = PanDirectionDown
    toEnum k = AnotherPanDirection k

instance P.Ord PanDirection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PanDirection = '[]
instance O.HasParentTypes PanDirection

foreign import ccall "gtk_pan_direction_get_type" c_gtk_pan_direction_get_type :: 
    IO GType

instance B.Types.TypedObject PanDirection where
    glibType = c_gtk_pan_direction_get_type

instance B.Types.BoxedEnum PanDirection

-- Enum PageSet
-- | See also 'GI.Gtk.Objects.PrintJob.printJobSetPageSet'.
data PageSet = 
      PageSetAll
    -- ^ All pages.
    | PageSetEven
    -- ^ Even pages.
    | PageSetOdd
    -- ^ Odd pages.
    | AnotherPageSet Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PageSet where
    fromEnum PageSetAll = 0
    fromEnum PageSetEven = 1
    fromEnum PageSetOdd = 2
    fromEnum (AnotherPageSet k) = k

    toEnum 0 = PageSetAll
    toEnum 1 = PageSetEven
    toEnum 2 = PageSetOdd
    toEnum k = AnotherPageSet k

instance P.Ord PageSet where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PageSet = '[]
instance O.HasParentTypes PageSet

foreign import ccall "gtk_page_set_get_type" c_gtk_page_set_get_type :: 
    IO GType

instance B.Types.TypedObject PageSet where
    glibType = c_gtk_page_set_get_type

instance B.Types.BoxedEnum PageSet

-- Enum PageOrientation
-- | See also 'GI.Gtk.Objects.PrintSettings.printSettingsSetOrientation'.
data PageOrientation = 
      PageOrientationPortrait
    -- ^ Portrait mode.
    | PageOrientationLandscape
    -- ^ Landscape mode.
    | PageOrientationReversePortrait
    -- ^ Reverse portrait mode.
    | PageOrientationReverseLandscape
    -- ^ Reverse landscape mode.
    | AnotherPageOrientation Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PageOrientation where
    fromEnum PageOrientationPortrait = 0
    fromEnum PageOrientationLandscape = 1
    fromEnum PageOrientationReversePortrait = 2
    fromEnum PageOrientationReverseLandscape = 3
    fromEnum (AnotherPageOrientation k) = k

    toEnum 0 = PageOrientationPortrait
    toEnum 1 = PageOrientationLandscape
    toEnum 2 = PageOrientationReversePortrait
    toEnum 3 = PageOrientationReverseLandscape
    toEnum k = AnotherPageOrientation k

instance P.Ord PageOrientation where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PageOrientation = '[]
instance O.HasParentTypes PageOrientation

foreign import ccall "gtk_page_orientation_get_type" c_gtk_page_orientation_get_type :: 
    IO GType

instance B.Types.TypedObject PageOrientation where
    glibType = c_gtk_page_orientation_get_type

instance B.Types.BoxedEnum PageOrientation

-- Enum PadActionType
-- | The type of a pad action.
data PadActionType = 
      PadActionTypeButton
    -- ^ Action is triggered by a pad button
    | PadActionTypeRing
    -- ^ Action is triggered by a pad ring
    | PadActionTypeStrip
    -- ^ Action is triggered by a pad strip
    | PadActionTypeDial
    -- ^ Action is triggered by a pad dial
    | AnotherPadActionType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PadActionType where
    fromEnum PadActionTypeButton = 0
    fromEnum PadActionTypeRing = 1
    fromEnum PadActionTypeStrip = 2
    fromEnum PadActionTypeDial = 3
    fromEnum (AnotherPadActionType k) = k

    toEnum 0 = PadActionTypeButton
    toEnum 1 = PadActionTypeRing
    toEnum 2 = PadActionTypeStrip
    toEnum 3 = PadActionTypeDial
    toEnum k = AnotherPadActionType k

instance P.Ord PadActionType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PadActionType = '[]
instance O.HasParentTypes PadActionType

foreign import ccall "gtk_pad_action_type_get_type" c_gtk_pad_action_type_get_type :: 
    IO GType

instance B.Types.TypedObject PadActionType where
    glibType = c_gtk_pad_action_type_get_type

instance B.Types.BoxedEnum PadActionType

-- Enum PackType
-- | Represents the packing location of a children in its parent.
-- 
-- See [class/@windowControls@/] for example.
data PackType = 
      PackTypeStart
    -- ^ The child is packed into the start of the widget
    | PackTypeEnd
    -- ^ The child is packed into the end of the widget
    | AnotherPackType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PackType where
    fromEnum PackTypeStart = 0
    fromEnum PackTypeEnd = 1
    fromEnum (AnotherPackType k) = k

    toEnum 0 = PackTypeStart
    toEnum 1 = PackTypeEnd
    toEnum k = AnotherPackType k

instance P.Ord PackType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PackType = '[]
instance O.HasParentTypes PackType

foreign import ccall "gtk_pack_type_get_type" c_gtk_pack_type_get_type :: 
    IO GType

instance B.Types.TypedObject PackType where
    glibType = c_gtk_pack_type_get_type

instance B.Types.BoxedEnum PackType

-- Enum Overflow
-- | Defines how content overflowing a given area should be handled.
-- 
-- This is used in 'GI.Gtk.Objects.Widget.widgetSetOverflow'. The
-- [Widget:overflow]("GI.Gtk.Objects.Widget#g:attr:overflow") property is modeled after the
-- CSS overflow property, but implements it only partially.
data Overflow = 
      OverflowVisible
    -- ^ No change is applied. Content is drawn at the specified
    --   position.
    | OverflowHidden
    -- ^ Content is clipped to the bounds of the area. Content
    --   outside the area is not drawn and cannot be interacted with.
    | AnotherOverflow Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Overflow where
    fromEnum OverflowVisible = 0
    fromEnum OverflowHidden = 1
    fromEnum (AnotherOverflow k) = k

    toEnum 0 = OverflowVisible
    toEnum 1 = OverflowHidden
    toEnum k = AnotherOverflow k

instance P.Ord Overflow where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Overflow = '[]
instance O.HasParentTypes Overflow

foreign import ccall "gtk_overflow_get_type" c_gtk_overflow_get_type :: 
    IO GType

instance B.Types.TypedObject Overflow where
    glibType = c_gtk_overflow_get_type

instance B.Types.BoxedEnum Overflow

-- Enum Orientation
-- | Represents the orientation of widgets and other objects.
-- 
-- Typical examples are [class/@box@/] or [class/@gesturePan@/].
data Orientation = 
      OrientationHorizontal
    -- ^ The element is in horizontal orientation.
    | OrientationVertical
    -- ^ The element is in vertical orientation.
    | AnotherOrientation Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Orientation where
    fromEnum OrientationHorizontal = 0
    fromEnum OrientationVertical = 1
    fromEnum (AnotherOrientation k) = k

    toEnum 0 = OrientationHorizontal
    toEnum 1 = OrientationVertical
    toEnum k = AnotherOrientation k

instance P.Ord Orientation where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Orientation = '[]
instance O.HasParentTypes Orientation

foreign import ccall "gtk_orientation_get_type" c_gtk_orientation_get_type :: 
    IO GType

instance B.Types.TypedObject Orientation where
    glibType = c_gtk_orientation_get_type

instance B.Types.BoxedEnum Orientation

-- Enum Ordering
-- | Describes the way two values can be compared.
-- 
-- These values can be used with a [callback/@gLib@/.CompareFunc]. However,
-- a @GCompareFunc@ is allowed to return any integer values.
-- For converting such a value to a @GtkOrdering@ value, use
-- t'GI.Gtk.Enums.Ordering'.@/from_cmpfunc/@().
data Ordering = 
      OrderingSmaller
    -- ^ the first value is smaller than the second
    | OrderingEqual
    -- ^ the two values are equal
    | OrderingLarger
    -- ^ the first value is larger than the second
    | AnotherOrdering Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Ordering where
    fromEnum OrderingSmaller = -1
    fromEnum OrderingEqual = 0
    fromEnum OrderingLarger = 1
    fromEnum (AnotherOrdering k) = k

    toEnum -1 = OrderingSmaller
    toEnum 0 = OrderingEqual
    toEnum 1 = OrderingLarger
    toEnum k = AnotherOrdering k

instance P.Ord Ordering where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Ordering = '[]
instance O.HasParentTypes Ordering

foreign import ccall "gtk_ordering_get_type" c_gtk_ordering_get_type :: 
    IO GType

instance B.Types.TypedObject Ordering where
    glibType = c_gtk_ordering_get_type

instance B.Types.BoxedEnum Ordering

-- Enum NumberUpLayout
-- | Used to determine the layout of pages on a sheet when printing
-- multiple pages per sheet.
data NumberUpLayout = 
      NumberUpLayoutLrtb
    -- ^ <<https://docs.gtk.org/gtk4/layout-lrtb.png>>
    | NumberUpLayoutLrbt
    -- ^ <<https://docs.gtk.org/gtk4/layout-lrbt.png>>
    | NumberUpLayoutRltb
    -- ^ <<https://docs.gtk.org/gtk4/layout-rltb.png>>
    | NumberUpLayoutRlbt
    -- ^ <<https://docs.gtk.org/gtk4/layout-rlbt.png>>
    | NumberUpLayoutTblr
    -- ^ <<https://docs.gtk.org/gtk4/layout-tblr.png>>
    | NumberUpLayoutTbrl
    -- ^ <<https://docs.gtk.org/gtk4/layout-tbrl.png>>
    | NumberUpLayoutBtlr
    -- ^ <<https://docs.gtk.org/gtk4/layout-btlr.png>>
    | NumberUpLayoutBtrl
    -- ^ <<https://docs.gtk.org/gtk4/layout-btrl.png>>
    | AnotherNumberUpLayout Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NumberUpLayout where
    fromEnum NumberUpLayoutLrtb = 0
    fromEnum NumberUpLayoutLrbt = 1
    fromEnum NumberUpLayoutRltb = 2
    fromEnum NumberUpLayoutRlbt = 3
    fromEnum NumberUpLayoutTblr = 4
    fromEnum NumberUpLayoutTbrl = 5
    fromEnum NumberUpLayoutBtlr = 6
    fromEnum NumberUpLayoutBtrl = 7
    fromEnum (AnotherNumberUpLayout k) = k

    toEnum 0 = NumberUpLayoutLrtb
    toEnum 1 = NumberUpLayoutLrbt
    toEnum 2 = NumberUpLayoutRltb
    toEnum 3 = NumberUpLayoutRlbt
    toEnum 4 = NumberUpLayoutTblr
    toEnum 5 = NumberUpLayoutTbrl
    toEnum 6 = NumberUpLayoutBtlr
    toEnum 7 = NumberUpLayoutBtrl
    toEnum k = AnotherNumberUpLayout k

instance P.Ord NumberUpLayout where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes NumberUpLayout = '[]
instance O.HasParentTypes NumberUpLayout

foreign import ccall "gtk_number_up_layout_get_type" c_gtk_number_up_layout_get_type :: 
    IO GType

instance B.Types.TypedObject NumberUpLayout where
    glibType = c_gtk_number_up_layout_get_type

instance B.Types.BoxedEnum NumberUpLayout

-- Enum NotebookTab
-- | The parameter used in the action signals of @GtkNotebook@.
data NotebookTab = 
      NotebookTabFirst
    -- ^ the first tab in the notebook
    | NotebookTabLast
    -- ^ the last tab in the notebook
    | AnotherNotebookTab Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NotebookTab where
    fromEnum NotebookTabFirst = 0
    fromEnum NotebookTabLast = 1
    fromEnum (AnotherNotebookTab k) = k

    toEnum 0 = NotebookTabFirst
    toEnum 1 = NotebookTabLast
    toEnum k = AnotherNotebookTab k

instance P.Ord NotebookTab where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes NotebookTab = '[]
instance O.HasParentTypes NotebookTab

foreign import ccall "gtk_notebook_tab_get_type" c_gtk_notebook_tab_get_type :: 
    IO GType

instance B.Types.TypedObject NotebookTab where
    glibType = c_gtk_notebook_tab_get_type

instance B.Types.BoxedEnum NotebookTab

-- Enum NaturalWrapMode
-- | Options for selecting a different wrap mode for natural size
-- requests.
-- 
-- See for example the [Label:naturalWrapMode]("GI.Gtk.Objects.Label#g:attr:naturalWrapMode") property.
-- 
-- /Since: 4.6/
data NaturalWrapMode = 
      NaturalWrapModeInherit
    -- ^ Inherit the minimum size request.
    --   In particular, this should be used with 'GI.Pango.Enums.WrapModeChar'.
    | NaturalWrapModeNone
    -- ^ Try not to wrap the text. This mode is the
    --   closest to GTK3\'s behavior but can lead to a wide label leaving
    --   lots of empty space below the text.
    | NaturalWrapModeWord
    -- ^ Attempt to wrap at word boundaries. This
    --   is useful in particular when using 'GI.Pango.Enums.WrapModeWordChar' as the
    --   wrap mode.
    | AnotherNaturalWrapMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NaturalWrapMode where
    fromEnum NaturalWrapModeInherit = 0
    fromEnum NaturalWrapModeNone = 1
    fromEnum NaturalWrapModeWord = 2
    fromEnum (AnotherNaturalWrapMode k) = k

    toEnum 0 = NaturalWrapModeInherit
    toEnum 1 = NaturalWrapModeNone
    toEnum 2 = NaturalWrapModeWord
    toEnum k = AnotherNaturalWrapMode k

instance P.Ord NaturalWrapMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes NaturalWrapMode = '[]
instance O.HasParentTypes NaturalWrapMode

foreign import ccall "gtk_natural_wrap_mode_get_type" c_gtk_natural_wrap_mode_get_type :: 
    IO GType

instance B.Types.TypedObject NaturalWrapMode where
    glibType = c_gtk_natural_wrap_mode_get_type

instance B.Types.BoxedEnum NaturalWrapMode

-- Enum MovementStep
-- | Passed as argument to various keybinding signals for moving the
-- cursor position.
data MovementStep = 
      MovementStepLogicalPositions
    -- ^ Move forward or back by graphemes
    | MovementStepVisualPositions
    -- ^ Move left or right by graphemes
    | MovementStepWords
    -- ^ Move forward or back by words
    | MovementStepDisplayLines
    -- ^ Move up or down lines (wrapped lines)
    | MovementStepDisplayLineEnds
    -- ^ Move to either end of a line
    | MovementStepParagraphs
    -- ^ Move up or down paragraphs (newline-ended lines)
    | MovementStepParagraphEnds
    -- ^ Move to either end of a paragraph
    | MovementStepPages
    -- ^ Move by pages
    | MovementStepBufferEnds
    -- ^ Move to ends of the buffer
    | MovementStepHorizontalPages
    -- ^ Move horizontally by pages
    | AnotherMovementStep Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MovementStep where
    fromEnum MovementStepLogicalPositions = 0
    fromEnum MovementStepVisualPositions = 1
    fromEnum MovementStepWords = 2
    fromEnum MovementStepDisplayLines = 3
    fromEnum MovementStepDisplayLineEnds = 4
    fromEnum MovementStepParagraphs = 5
    fromEnum MovementStepParagraphEnds = 6
    fromEnum MovementStepPages = 7
    fromEnum MovementStepBufferEnds = 8
    fromEnum MovementStepHorizontalPages = 9
    fromEnum (AnotherMovementStep k) = k

    toEnum 0 = MovementStepLogicalPositions
    toEnum 1 = MovementStepVisualPositions
    toEnum 2 = MovementStepWords
    toEnum 3 = MovementStepDisplayLines
    toEnum 4 = MovementStepDisplayLineEnds
    toEnum 5 = MovementStepParagraphs
    toEnum 6 = MovementStepParagraphEnds
    toEnum 7 = MovementStepPages
    toEnum 8 = MovementStepBufferEnds
    toEnum 9 = MovementStepHorizontalPages
    toEnum k = AnotherMovementStep k

instance P.Ord MovementStep where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MovementStep = '[]
instance O.HasParentTypes MovementStep

foreign import ccall "gtk_movement_step_get_type" c_gtk_movement_step_get_type :: 
    IO GType

instance B.Types.TypedObject MovementStep where
    glibType = c_gtk_movement_step_get_type

instance B.Types.BoxedEnum MovementStep

-- Enum MessageType
-- | The type of message being displayed in a [class/@messageDialog@/].
data MessageType = 
      MessageTypeInfo
    -- ^ Informational message
    | MessageTypeWarning
    -- ^ Non-fatal warning message
    | MessageTypeQuestion
    -- ^ Question requiring a choice
    | MessageTypeError
    -- ^ Fatal error message
    | MessageTypeOther
    -- ^ None of the above
    | AnotherMessageType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MessageType where
    fromEnum MessageTypeInfo = 0
    fromEnum MessageTypeWarning = 1
    fromEnum MessageTypeQuestion = 2
    fromEnum MessageTypeError = 3
    fromEnum MessageTypeOther = 4
    fromEnum (AnotherMessageType k) = k

    toEnum 0 = MessageTypeInfo
    toEnum 1 = MessageTypeWarning
    toEnum 2 = MessageTypeQuestion
    toEnum 3 = MessageTypeError
    toEnum 4 = MessageTypeOther
    toEnum k = AnotherMessageType k

instance P.Ord MessageType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MessageType = '[]
instance O.HasParentTypes MessageType

foreign import ccall "gtk_message_type_get_type" c_gtk_message_type_get_type :: 
    IO GType

instance B.Types.TypedObject MessageType where
    glibType = c_gtk_message_type_get_type

instance B.Types.BoxedEnum MessageType

-- Enum ListTabBehavior
-- | Used to configure the focus behavior in the @GTK_DIR_TAB_FORWARD@
-- and @GTK_DIR_TAB_BACKWARD@ direction, like the \<kbd>Tab\<\/kbd> key
-- in a t'GI.Gtk.Objects.ListView.ListView'.
-- 
-- /Since: 4.12/
data ListTabBehavior = 
      ListTabBehaviorAll
    -- ^ Cycle through all focusable items of the list
    | ListTabBehaviorItem
    -- ^ Cycle through a single list element, then move
    --   focus out of the list. Moving focus between items needs to be
    --   done with the arrow keys.
    | ListTabBehaviorCell
    -- ^ Cycle only through a single cell, then
    --   move focus out of the list. Moving focus between cells needs to
    --   be done with the arrow keys. This is only relevant for
    --   cell-based widgets like t'GI.Gtk.Objects.ColumnView.ColumnView', otherwise it behaves
    --   like @GTK_LIST_TAB_ITEM@.
    | AnotherListTabBehavior Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ListTabBehavior where
    fromEnum ListTabBehaviorAll = 0
    fromEnum ListTabBehaviorItem = 1
    fromEnum ListTabBehaviorCell = 2
    fromEnum (AnotherListTabBehavior k) = k

    toEnum 0 = ListTabBehaviorAll
    toEnum 1 = ListTabBehaviorItem
    toEnum 2 = ListTabBehaviorCell
    toEnum k = AnotherListTabBehavior k

instance P.Ord ListTabBehavior where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ListTabBehavior = '[]
instance O.HasParentTypes ListTabBehavior

foreign import ccall "gtk_list_tab_behavior_get_type" c_gtk_list_tab_behavior_get_type :: 
    IO GType

instance B.Types.TypedObject ListTabBehavior where
    glibType = c_gtk_list_tab_behavior_get_type

instance B.Types.BoxedEnum ListTabBehavior

-- Enum License
-- | The type of license for an application.
-- 
-- This enumeration can be expanded at later date.
data License = 
      LicenseUnknown
    -- ^ No license specified
    | LicenseCustom
    -- ^ A license text is going to be specified by the
    --   developer
    | LicenseGpl20
    -- ^ The GNU General Public License, version 2.0 or later
    | LicenseGpl30
    -- ^ The GNU General Public License, version 3.0 or later
    | LicenseLgpl21
    -- ^ The GNU Lesser General Public License, version 2.1 or later
    | LicenseLgpl30
    -- ^ The GNU Lesser General Public License, version 3.0 or later
    | LicenseBsd
    -- ^ The BSD standard license
    | LicenseMitX11
    -- ^ The MIT\/X11 standard license
    | LicenseArtistic
    -- ^ The Artistic License, version 2.0
    | LicenseGpl20Only
    -- ^ The GNU General Public License, version 2.0 only
    | LicenseGpl30Only
    -- ^ The GNU General Public License, version 3.0 only
    | LicenseLgpl21Only
    -- ^ The GNU Lesser General Public License, version 2.1 only
    | LicenseLgpl30Only
    -- ^ The GNU Lesser General Public License, version 3.0 only
    | LicenseAgpl30
    -- ^ The GNU Affero General Public License, version 3.0 or later
    | LicenseAgpl30Only
    -- ^ The GNU Affero General Public License, version 3.0 only
    | LicenseBsd3
    -- ^ The 3-clause BSD licence
    | LicenseApache20
    -- ^ The Apache License, version 2.0
    | LicenseMpl20
    -- ^ The Mozilla Public License, version 2.0
    | License0bsd
    -- ^ Zero-Clause BSD license
    | AnotherLicense Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum License where
    fromEnum LicenseUnknown = 0
    fromEnum LicenseCustom = 1
    fromEnum LicenseGpl20 = 2
    fromEnum LicenseGpl30 = 3
    fromEnum LicenseLgpl21 = 4
    fromEnum LicenseLgpl30 = 5
    fromEnum LicenseBsd = 6
    fromEnum LicenseMitX11 = 7
    fromEnum LicenseArtistic = 8
    fromEnum LicenseGpl20Only = 9
    fromEnum LicenseGpl30Only = 10
    fromEnum LicenseLgpl21Only = 11
    fromEnum LicenseLgpl30Only = 12
    fromEnum LicenseAgpl30 = 13
    fromEnum LicenseAgpl30Only = 14
    fromEnum LicenseBsd3 = 15
    fromEnum LicenseApache20 = 16
    fromEnum LicenseMpl20 = 17
    fromEnum License0bsd = 18
    fromEnum (AnotherLicense k) = k

    toEnum 0 = LicenseUnknown
    toEnum 1 = LicenseCustom
    toEnum 2 = LicenseGpl20
    toEnum 3 = LicenseGpl30
    toEnum 4 = LicenseLgpl21
    toEnum 5 = LicenseLgpl30
    toEnum 6 = LicenseBsd
    toEnum 7 = LicenseMitX11
    toEnum 8 = LicenseArtistic
    toEnum 9 = LicenseGpl20Only
    toEnum 10 = LicenseGpl30Only
    toEnum 11 = LicenseLgpl21Only
    toEnum 12 = LicenseLgpl30Only
    toEnum 13 = LicenseAgpl30
    toEnum 14 = LicenseAgpl30Only
    toEnum 15 = LicenseBsd3
    toEnum 16 = LicenseApache20
    toEnum 17 = LicenseMpl20
    toEnum 18 = License0bsd
    toEnum k = AnotherLicense k

instance P.Ord License where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes License = '[]
instance O.HasParentTypes License

foreign import ccall "gtk_license_get_type" c_gtk_license_get_type :: 
    IO GType

instance B.Types.TypedObject License where
    glibType = c_gtk_license_get_type

instance B.Types.BoxedEnum License

-- Enum LevelBarMode
-- | Describes how [class/@levelBar@/] contents should be rendered.
-- 
-- Note that this enumeration could be extended with additional modes
-- in the future.
data LevelBarMode = 
      LevelBarModeContinuous
    -- ^ the bar has a continuous mode
    | LevelBarModeDiscrete
    -- ^ the bar has a discrete mode
    | AnotherLevelBarMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum LevelBarMode where
    fromEnum LevelBarModeContinuous = 0
    fromEnum LevelBarModeDiscrete = 1
    fromEnum (AnotherLevelBarMode k) = k

    toEnum 0 = LevelBarModeContinuous
    toEnum 1 = LevelBarModeDiscrete
    toEnum k = AnotherLevelBarMode k

instance P.Ord LevelBarMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes LevelBarMode = '[]
instance O.HasParentTypes LevelBarMode

foreign import ccall "gtk_level_bar_mode_get_type" c_gtk_level_bar_mode_get_type :: 
    IO GType

instance B.Types.TypedObject LevelBarMode where
    glibType = c_gtk_level_bar_mode_get_type

instance B.Types.BoxedEnum LevelBarMode

-- Enum Justification
-- | Used for justifying the text inside a [class/@label@/] widget.
data Justification = 
      JustificationLeft
    -- ^ The text is placed at the left edge of the label.
    | JustificationRight
    -- ^ The text is placed at the right edge of the label.
    | JustificationCenter
    -- ^ The text is placed in the center of the label.
    | JustificationFill
    -- ^ The text is placed is distributed across the label.
    | AnotherJustification Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Justification where
    fromEnum JustificationLeft = 0
    fromEnum JustificationRight = 1
    fromEnum JustificationCenter = 2
    fromEnum JustificationFill = 3
    fromEnum (AnotherJustification k) = k

    toEnum 0 = JustificationLeft
    toEnum 1 = JustificationRight
    toEnum 2 = JustificationCenter
    toEnum 3 = JustificationFill
    toEnum k = AnotherJustification k

instance P.Ord Justification where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Justification = '[]
instance O.HasParentTypes Justification

foreign import ccall "gtk_justification_get_type" c_gtk_justification_get_type :: 
    IO GType

instance B.Types.TypedObject Justification where
    glibType = c_gtk_justification_get_type

instance B.Types.BoxedEnum Justification

-- Enum InterfaceContrast
-- | Values for the [Settings:gtkInterfaceContrast]("GI.Gtk.Objects.Settings#g:attr:gtkInterfaceContrast")
-- and [CssProvider:prefersContrast]("GI.Gtk.Objects.CssProvider#g:attr:prefersContrast") properties
-- that indicates the preferred level of contrast.
-- 
-- This information can be used inside CSS via media queries.
-- 
-- More values may be added to this enumeration. Unknown values
-- should be treated the same as @GTK_INTERFACE_CONTRAST_NO_PREFERENCE@.
-- 
-- /Since: 4.20/
data InterfaceContrast = 
      InterfaceContrastUnsupported
    -- ^ The system doesn\'t support contrast levels
    | InterfaceContrastNoPreference
    -- ^ No particular preference for contrast
    | InterfaceContrastMore
    -- ^ More contrast is preferred
    | InterfaceContrastLess
    -- ^ Less contrast is preferred
    | AnotherInterfaceContrast Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InterfaceContrast where
    fromEnum InterfaceContrastUnsupported = 0
    fromEnum InterfaceContrastNoPreference = 1
    fromEnum InterfaceContrastMore = 2
    fromEnum InterfaceContrastLess = 3
    fromEnum (AnotherInterfaceContrast k) = k

    toEnum 0 = InterfaceContrastUnsupported
    toEnum 1 = InterfaceContrastNoPreference
    toEnum 2 = InterfaceContrastMore
    toEnum 3 = InterfaceContrastLess
    toEnum k = AnotherInterfaceContrast k

instance P.Ord InterfaceContrast where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InterfaceContrast = '[]
instance O.HasParentTypes InterfaceContrast

foreign import ccall "gtk_interface_contrast_get_type" c_gtk_interface_contrast_get_type :: 
    IO GType

instance B.Types.TypedObject InterfaceContrast where
    glibType = c_gtk_interface_contrast_get_type

instance B.Types.BoxedEnum InterfaceContrast

-- Enum InterfaceColorScheme
-- | Values for the [Settings:gtkInterfaceColorScheme]("GI.Gtk.Objects.Settings#g:attr:gtkInterfaceColorScheme")
-- and [CssProvider:prefersColorScheme]("GI.Gtk.Objects.CssProvider#g:attr:prefersColorScheme") properties
-- that indicates what color scheme is used.
-- 
-- This information can be used inside CSS via media queries.
-- 
-- More values may be added to this enumeration. Unknown values
-- should be treated the same as @GTK_INTERFACE_COLOR_SCHEME_DEFAULT@.
-- 
-- /Since: 4.20/
data InterfaceColorScheme = 
      InterfaceColorSchemeUnsupported
    -- ^ The system doesn\'t support color schemes
    | InterfaceColorSchemeDefault
    -- ^ The default color scheme is used
    | InterfaceColorSchemeDark
    -- ^ A dark color scheme is used
    | InterfaceColorSchemeLight
    -- ^ A light color scheme is used
    | AnotherInterfaceColorScheme Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InterfaceColorScheme where
    fromEnum InterfaceColorSchemeUnsupported = 0
    fromEnum InterfaceColorSchemeDefault = 1
    fromEnum InterfaceColorSchemeDark = 2
    fromEnum InterfaceColorSchemeLight = 3
    fromEnum (AnotherInterfaceColorScheme k) = k

    toEnum 0 = InterfaceColorSchemeUnsupported
    toEnum 1 = InterfaceColorSchemeDefault
    toEnum 2 = InterfaceColorSchemeDark
    toEnum 3 = InterfaceColorSchemeLight
    toEnum k = AnotherInterfaceColorScheme k

instance P.Ord InterfaceColorScheme where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InterfaceColorScheme = '[]
instance O.HasParentTypes InterfaceColorScheme

foreign import ccall "gtk_interface_color_scheme_get_type" c_gtk_interface_color_scheme_get_type :: 
    IO GType

instance B.Types.TypedObject InterfaceColorScheme where
    glibType = c_gtk_interface_color_scheme_get_type

instance B.Types.BoxedEnum InterfaceColorScheme

-- Enum InscriptionOverflow
-- | The different methods to handle text in t'GI.Gtk.Objects.Inscription.Inscription' when it doesn\'t
-- fit the available space.
-- 
-- /Since: 4.8/
data InscriptionOverflow = 
      InscriptionOverflowClip
    -- ^ Clip the remaining text
    | InscriptionOverflowEllipsizeStart
    -- ^ Omit characters at the start of the text
    | InscriptionOverflowEllipsizeMiddle
    -- ^ Omit characters at the middle of the text
    | InscriptionOverflowEllipsizeEnd
    -- ^ Omit characters at the end of the text
    | AnotherInscriptionOverflow Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InscriptionOverflow where
    fromEnum InscriptionOverflowClip = 0
    fromEnum InscriptionOverflowEllipsizeStart = 1
    fromEnum InscriptionOverflowEllipsizeMiddle = 2
    fromEnum InscriptionOverflowEllipsizeEnd = 3
    fromEnum (AnotherInscriptionOverflow k) = k

    toEnum 0 = InscriptionOverflowClip
    toEnum 1 = InscriptionOverflowEllipsizeStart
    toEnum 2 = InscriptionOverflowEllipsizeMiddle
    toEnum 3 = InscriptionOverflowEllipsizeEnd
    toEnum k = AnotherInscriptionOverflow k

instance P.Ord InscriptionOverflow where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InscriptionOverflow = '[]
instance O.HasParentTypes InscriptionOverflow

foreign import ccall "gtk_inscription_overflow_get_type" c_gtk_inscription_overflow_get_type :: 
    IO GType

instance B.Types.TypedObject InscriptionOverflow where
    glibType = c_gtk_inscription_overflow_get_type

instance B.Types.BoxedEnum InscriptionOverflow

-- Enum InputPurpose
-- | Describes primary purpose of the input widget.
-- 
-- This information is useful for on-screen keyboards and similar input
-- methods to decide which keys should be presented to the user.
-- 
-- Note that the purpose is not meant to impose a totally strict rule
-- about allowed characters, and does not replace input validation.
-- It is fine for an on-screen keyboard to let the user override the
-- character set restriction that is expressed by the purpose. The
-- application is expected to validate the entry contents, even if
-- it specified a purpose.
-- 
-- The difference between 'GI.Gtk.Enums.InputPurposeDigits' and
-- 'GI.Gtk.Enums.InputPurposeNumber' is that the former accepts only digits
-- while the latter also some punctuation (like commas or points, plus,
-- minus) and “e” or “E” as in 3.14E+000.
-- 
-- This enumeration may be extended in the future; input methods should
-- interpret unknown values as “free form”.
data InputPurpose = 
      InputPurposeFreeForm
    -- ^ Allow any character
    | InputPurposeAlpha
    -- ^ Allow only alphabetic characters
    | InputPurposeDigits
    -- ^ Allow only digits
    | InputPurposeNumber
    -- ^ Edited field expects numbers
    | InputPurposePhone
    -- ^ Edited field expects phone number
    | InputPurposeUrl
    -- ^ Edited field expects URL
    | InputPurposeEmail
    -- ^ Edited field expects email address
    | InputPurposeName
    -- ^ Edited field expects the name of a person
    | InputPurposePassword
    -- ^ Like 'GI.Gtk.Enums.InputPurposeFreeForm', but characters are hidden
    | InputPurposePin
    -- ^ Like 'GI.Gtk.Enums.InputPurposeDigits', but characters are hidden
    | InputPurposeTerminal
    -- ^ Allow any character, in addition to control codes
    | AnotherInputPurpose Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InputPurpose where
    fromEnum InputPurposeFreeForm = 0
    fromEnum InputPurposeAlpha = 1
    fromEnum InputPurposeDigits = 2
    fromEnum InputPurposeNumber = 3
    fromEnum InputPurposePhone = 4
    fromEnum InputPurposeUrl = 5
    fromEnum InputPurposeEmail = 6
    fromEnum InputPurposeName = 7
    fromEnum InputPurposePassword = 8
    fromEnum InputPurposePin = 9
    fromEnum InputPurposeTerminal = 10
    fromEnum (AnotherInputPurpose k) = k

    toEnum 0 = InputPurposeFreeForm
    toEnum 1 = InputPurposeAlpha
    toEnum 2 = InputPurposeDigits
    toEnum 3 = InputPurposeNumber
    toEnum 4 = InputPurposePhone
    toEnum 5 = InputPurposeUrl
    toEnum 6 = InputPurposeEmail
    toEnum 7 = InputPurposeName
    toEnum 8 = InputPurposePassword
    toEnum 9 = InputPurposePin
    toEnum 10 = InputPurposeTerminal
    toEnum k = AnotherInputPurpose k

instance P.Ord InputPurpose where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InputPurpose = '[]
instance O.HasParentTypes InputPurpose

foreign import ccall "gtk_input_purpose_get_type" c_gtk_input_purpose_get_type :: 
    IO GType

instance B.Types.TypedObject InputPurpose where
    glibType = c_gtk_input_purpose_get_type

instance B.Types.BoxedEnum InputPurpose

-- Enum ImageType
-- | Describes the image data representation used by a t'GI.Gtk.Objects.Image.Image'.
-- 
-- If you want to get the image from the widget, you can only get the
-- currently-stored representation; for instance, if the 'GI.Gtk.Objects.Image.imageGetStorageType'
-- returns 'GI.Gtk.Enums.ImageTypePaintable', then you can call 'GI.Gtk.Objects.Image.imageGetPaintable'.
-- 
-- For empty images, you can request any storage type (call any of the \"get\"
-- functions), but they will all return 'P.Nothing' values.
data ImageType = 
      ImageTypeEmpty
    -- ^ there is no image displayed by the widget
    | ImageTypeIconName
    -- ^ the widget contains a named icon
    | ImageTypeGicon
    -- ^ the widget contains a @GIcon@
    | ImageTypePaintable
    -- ^ the widget contains a @GdkPaintable@
    | AnotherImageType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ImageType where
    fromEnum ImageTypeEmpty = 0
    fromEnum ImageTypeIconName = 1
    fromEnum ImageTypeGicon = 2
    fromEnum ImageTypePaintable = 3
    fromEnum (AnotherImageType k) = k

    toEnum 0 = ImageTypeEmpty
    toEnum 1 = ImageTypeIconName
    toEnum 2 = ImageTypeGicon
    toEnum 3 = ImageTypePaintable
    toEnum k = AnotherImageType k

instance P.Ord ImageType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ImageType = '[]
instance O.HasParentTypes ImageType

foreign import ccall "gtk_image_type_get_type" c_gtk_image_type_get_type :: 
    IO GType

instance B.Types.TypedObject ImageType where
    glibType = c_gtk_image_type_get_type

instance B.Types.BoxedEnum ImageType

-- Enum IconViewDropPosition
{-# DEPRECATED IconViewDropPosition ["(Since version 4.20)","There is no replacement."] #-}
-- | An enum for determining where a dropped item goes.
data IconViewDropPosition = 
      IconViewDropPositionNoDrop
    -- ^ no drop possible
    | IconViewDropPositionDropInto
    -- ^ dropped item replaces the item
    | IconViewDropPositionDropLeft
    -- ^ dropped item is inserted to the left
    | IconViewDropPositionDropRight
    -- ^ dropped item is inserted to the right
    | IconViewDropPositionDropAbove
    -- ^ dropped item is inserted above
    | IconViewDropPositionDropBelow
    -- ^ dropped item is inserted below
    | AnotherIconViewDropPosition Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IconViewDropPosition where
    fromEnum IconViewDropPositionNoDrop = 0
    fromEnum IconViewDropPositionDropInto = 1
    fromEnum IconViewDropPositionDropLeft = 2
    fromEnum IconViewDropPositionDropRight = 3
    fromEnum IconViewDropPositionDropAbove = 4
    fromEnum IconViewDropPositionDropBelow = 5
    fromEnum (AnotherIconViewDropPosition k) = k

    toEnum 0 = IconViewDropPositionNoDrop
    toEnum 1 = IconViewDropPositionDropInto
    toEnum 2 = IconViewDropPositionDropLeft
    toEnum 3 = IconViewDropPositionDropRight
    toEnum 4 = IconViewDropPositionDropAbove
    toEnum 5 = IconViewDropPositionDropBelow
    toEnum k = AnotherIconViewDropPosition k

instance P.Ord IconViewDropPosition where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes IconViewDropPosition = '[]
instance O.HasParentTypes IconViewDropPosition

foreign import ccall "gtk_icon_view_drop_position_get_type" c_gtk_icon_view_drop_position_get_type :: 
    IO GType

instance B.Types.TypedObject IconViewDropPosition where
    glibType = c_gtk_icon_view_drop_position_get_type

instance B.Types.BoxedEnum IconViewDropPosition

-- Enum IconThemeError
-- | Error codes for @GtkIconTheme@ operations.
data IconThemeError = 
      IconThemeErrorNotFound
    -- ^ The icon specified does not exist in the theme
    | IconThemeErrorFailed
    -- ^ An unspecified error occurred.
    | AnotherIconThemeError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IconThemeError where
    fromEnum IconThemeErrorNotFound = 0
    fromEnum IconThemeErrorFailed = 1
    fromEnum (AnotherIconThemeError k) = k

    toEnum 0 = IconThemeErrorNotFound
    toEnum 1 = IconThemeErrorFailed
    toEnum k = AnotherIconThemeError k

instance P.Ord IconThemeError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass IconThemeError where
    gerrorClassDomain _ = "gtk-icon-theme-error-quark"

-- | Catch exceptions of type `IconThemeError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchIconThemeError ::
    IO a ->
    (IconThemeError -> GErrorMessage -> IO a) ->
    IO a
catchIconThemeError = catchGErrorJustDomain

-- | Handle exceptions of type `IconThemeError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleIconThemeError ::
    (IconThemeError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleIconThemeError = handleGErrorJustDomain

type instance O.ParentTypes IconThemeError = '[]
instance O.HasParentTypes IconThemeError

foreign import ccall "gtk_icon_theme_error_get_type" c_gtk_icon_theme_error_get_type :: 
    IO GType

instance B.Types.TypedObject IconThemeError where
    glibType = c_gtk_icon_theme_error_get_type

instance B.Types.BoxedEnum IconThemeError

-- Enum IconSize
-- | Built-in icon sizes.
-- 
-- Icon sizes default to being inherited. Where they cannot be
-- inherited, text size is the default.
-- 
-- All widgets which use @GtkIconSize@ set the normal-icons or
-- large-icons style classes correspondingly, and let themes
-- determine the actual size to be used with the
-- @-gtk-icon-size@ CSS property.
data IconSize = 
      IconSizeInherit
    -- ^ Keep the size of the parent element
    | IconSizeNormal
    -- ^ Size similar to text size
    | IconSizeLarge
    -- ^ Large size, for example in an icon view
    | AnotherIconSize Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IconSize where
    fromEnum IconSizeInherit = 0
    fromEnum IconSizeNormal = 1
    fromEnum IconSizeLarge = 2
    fromEnum (AnotherIconSize k) = k

    toEnum 0 = IconSizeInherit
    toEnum 1 = IconSizeNormal
    toEnum 2 = IconSizeLarge
    toEnum k = AnotherIconSize k

instance P.Ord IconSize where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes IconSize = '[]
instance O.HasParentTypes IconSize

foreign import ccall "gtk_icon_size_get_type" c_gtk_icon_size_get_type :: 
    IO GType

instance B.Types.TypedObject IconSize where
    glibType = c_gtk_icon_size_get_type

instance B.Types.BoxedEnum IconSize

-- Enum GraphicsOffloadEnabled
-- | Represents the state of graphics offloading.
-- 
-- /Since: 4.14/
data GraphicsOffloadEnabled = 
      GraphicsOffloadEnabledEnabled
    -- ^ Graphics offloading is enabled.
    | GraphicsOffloadEnabledDisabled
    -- ^ Graphics offloading is disabled.
    | AnotherGraphicsOffloadEnabled Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum GraphicsOffloadEnabled where
    fromEnum GraphicsOffloadEnabledEnabled = 0
    fromEnum GraphicsOffloadEnabledDisabled = 1
    fromEnum (AnotherGraphicsOffloadEnabled k) = k

    toEnum 0 = GraphicsOffloadEnabledEnabled
    toEnum 1 = GraphicsOffloadEnabledDisabled
    toEnum k = AnotherGraphicsOffloadEnabled k

instance P.Ord GraphicsOffloadEnabled where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes GraphicsOffloadEnabled = '[]
instance O.HasParentTypes GraphicsOffloadEnabled

foreign import ccall "gtk_graphics_offload_enabled_get_type" c_gtk_graphics_offload_enabled_get_type :: 
    IO GType

instance B.Types.TypedObject GraphicsOffloadEnabled where
    glibType = c_gtk_graphics_offload_enabled_get_type

instance B.Types.BoxedEnum GraphicsOffloadEnabled

-- Enum FontRendering
-- | Values for the [Settings:gtkFontRendering]("GI.Gtk.Objects.Settings#g:attr:gtkFontRendering") setting
-- that influence how GTK renders fonts.
-- 
-- /Since: 4.16/
data FontRendering = 
      FontRenderingAutomatic
    -- ^ Set up font rendering automatically,
    --   taking factors like screen resolution and scale into account
    | FontRenderingManual
    -- ^ Follow low-level font-related settings
    --   when configuring font rendering
    | AnotherFontRendering Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FontRendering where
    fromEnum FontRenderingAutomatic = 0
    fromEnum FontRenderingManual = 1
    fromEnum (AnotherFontRendering k) = k

    toEnum 0 = FontRenderingAutomatic
    toEnum 1 = FontRenderingManual
    toEnum k = AnotherFontRendering k

instance P.Ord FontRendering where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FontRendering = '[]
instance O.HasParentTypes FontRendering

foreign import ccall "gtk_font_rendering_get_type" c_gtk_font_rendering_get_type :: 
    IO GType

instance B.Types.TypedObject FontRendering where
    glibType = c_gtk_font_rendering_get_type

instance B.Types.BoxedEnum FontRendering

-- Enum FontLevel
-- | The level of granularity for the font selection.
-- 
-- Depending on this value, the @PangoFontDescription@ that
-- is returned by 'GI.Gtk.Objects.FontDialogButton.fontDialogButtonGetFontDesc'
-- will have more or less fields set.
-- 
-- /Since: 4.10/
data FontLevel = 
      FontLevelFamily
    -- ^ Select a font family
    | FontLevelFace
    -- ^ Select a font face (i.e. a family and a style)
    | FontLevelFont
    -- ^ Select a font (i.e. a face with a size, and possibly font variations)
    | FontLevelFeatures
    -- ^ Select a font and font features
    | AnotherFontLevel Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FontLevel where
    fromEnum FontLevelFamily = 0
    fromEnum FontLevelFace = 1
    fromEnum FontLevelFont = 2
    fromEnum FontLevelFeatures = 3
    fromEnum (AnotherFontLevel k) = k

    toEnum 0 = FontLevelFamily
    toEnum 1 = FontLevelFace
    toEnum 2 = FontLevelFont
    toEnum 3 = FontLevelFeatures
    toEnum k = AnotherFontLevel k

instance P.Ord FontLevel where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FontLevel = '[]
instance O.HasParentTypes FontLevel

foreign import ccall "gtk_font_level_get_type" c_gtk_font_level_get_type :: 
    IO GType

instance B.Types.TypedObject FontLevel where
    glibType = c_gtk_font_level_get_type

instance B.Types.BoxedEnum FontLevel

-- Enum FilterMatch
-- | Describes the known strictness of a filter.
-- 
-- Note that for filters where the strictness is not known,
-- @GTK_FILTER_MATCH_SOME@ is always an acceptable value,
-- even if a filter does match all or no items.
data FilterMatch = 
      FilterMatchSome
    -- ^ The filter matches some items,
    --   'GI.Gtk.Objects.Filter.filterMatch' may return true or false
    | FilterMatchNone
    -- ^ The filter does not match any item,
    --   'GI.Gtk.Objects.Filter.filterMatch' will always return false
    | FilterMatchAll
    -- ^ The filter matches all items,
    --   'GI.Gtk.Objects.Filter.filterMatch' will alays return true
    | AnotherFilterMatch Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FilterMatch where
    fromEnum FilterMatchSome = 0
    fromEnum FilterMatchNone = 1
    fromEnum FilterMatchAll = 2
    fromEnum (AnotherFilterMatch k) = k

    toEnum 0 = FilterMatchSome
    toEnum 1 = FilterMatchNone
    toEnum 2 = FilterMatchAll
    toEnum k = AnotherFilterMatch k

instance P.Ord FilterMatch where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FilterMatch = '[]
instance O.HasParentTypes FilterMatch

foreign import ccall "gtk_filter_match_get_type" c_gtk_filter_match_get_type :: 
    IO GType

instance B.Types.TypedObject FilterMatch where
    glibType = c_gtk_filter_match_get_type

instance B.Types.BoxedEnum FilterMatch

-- Enum FilterChange
-- | Describes changes in a filter in more detail and allows objects
-- using the filter to optimize refiltering items.
-- 
-- If you are writing an implementation and are not sure which
-- value to pass, @GTK_FILTER_CHANGE_DIFFERENT@ is always a correct
-- choice.
-- 
-- New values may be added in the future.
data FilterChange = 
      FilterChangeDifferent
    -- ^ The filter change cannot be
    --   described with any of the other enumeration values
    | FilterChangeLessStrict
    -- ^ The filter is less strict than
    --   it was before: All items that it used to return true
    --   still return true, others now may, too.
    | FilterChangeMoreStrict
    -- ^ The filter is more strict than
    --   it was before: All items that it used to return false
    --   still return false, others now may, too.
    | FilterChangeDifferentRewatch
    -- ^ Similar to 'GI.Gtk.Enums.FilterChangeDifferent',
    -- but signs that item watches should be recreated. This is used by
    -- t'GI.Gtk.Objects.FilterListModel.FilterListModel' to keep the list up-to-date when items
    -- change.
    -- 
    -- /Since: 4.20/
    | FilterChangeLessStrictRewatch
    -- ^ Similar to 'GI.Gtk.Enums.FilterChangeLessStrict',
    -- but signs that item watches should be recreated. This is used by
    -- t'GI.Gtk.Objects.FilterListModel.FilterListModel' to keep the list up-to-date when items
    -- change.
    -- 
    -- /Since: 4.20/
    | FilterChangeMoreStrictRewatch
    -- ^ Similar to 'GI.Gtk.Enums.FilterChangeMoreStrict',
    -- but signs that item watches should be recreated. This is used by
    -- t'GI.Gtk.Objects.FilterListModel.FilterListModel' to keep the list up-to-date when items
    -- change.
    -- 
    -- /Since: 4.20/
    | AnotherFilterChange Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FilterChange where
    fromEnum FilterChangeDifferent = 0
    fromEnum FilterChangeLessStrict = 1
    fromEnum FilterChangeMoreStrict = 2
    fromEnum FilterChangeDifferentRewatch = 3
    fromEnum FilterChangeLessStrictRewatch = 4
    fromEnum FilterChangeMoreStrictRewatch = 5
    fromEnum (AnotherFilterChange k) = k

    toEnum 0 = FilterChangeDifferent
    toEnum 1 = FilterChangeLessStrict
    toEnum 2 = FilterChangeMoreStrict
    toEnum 3 = FilterChangeDifferentRewatch
    toEnum 4 = FilterChangeLessStrictRewatch
    toEnum 5 = FilterChangeMoreStrictRewatch
    toEnum k = AnotherFilterChange k

instance P.Ord FilterChange where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FilterChange = '[]
instance O.HasParentTypes FilterChange

foreign import ccall "gtk_filter_change_get_type" c_gtk_filter_change_get_type :: 
    IO GType

instance B.Types.TypedObject FilterChange where
    glibType = c_gtk_filter_change_get_type

instance B.Types.BoxedEnum FilterChange

-- Enum FileChooserError
{-# DEPRECATED FileChooserError ["(Since version 4.20)","There is no replacement"] #-}
-- | These identify the various errors that can occur while calling
-- @GtkFileChooser@ functions.
data FileChooserError = 
      FileChooserErrorNonexistent
    -- ^ Indicates that a file does not exist.
    | FileChooserErrorBadFilename
    -- ^ Indicates a malformed filename.
    | FileChooserErrorAlreadyExists
    -- ^ Indicates a duplicate path (e.g. when
    --  adding a bookmark).
    | FileChooserErrorIncompleteHostname
    -- ^ Indicates an incomplete hostname
    --  (e.g. \"http:\/\/foo\" without a slash after that).
    | AnotherFileChooserError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileChooserError where
    fromEnum FileChooserErrorNonexistent = 0
    fromEnum FileChooserErrorBadFilename = 1
    fromEnum FileChooserErrorAlreadyExists = 2
    fromEnum FileChooserErrorIncompleteHostname = 3
    fromEnum (AnotherFileChooserError k) = k

    toEnum 0 = FileChooserErrorNonexistent
    toEnum 1 = FileChooserErrorBadFilename
    toEnum 2 = FileChooserErrorAlreadyExists
    toEnum 3 = FileChooserErrorIncompleteHostname
    toEnum k = AnotherFileChooserError k

instance P.Ord FileChooserError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass FileChooserError where
    gerrorClassDomain _ = "gtk-file-chooser-error-quark"

-- | Catch exceptions of type `FileChooserError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchFileChooserError ::
    IO a ->
    (FileChooserError -> GErrorMessage -> IO a) ->
    IO a
catchFileChooserError = catchGErrorJustDomain

-- | Handle exceptions of type `FileChooserError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleFileChooserError ::
    (FileChooserError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleFileChooserError = handleGErrorJustDomain

type instance O.ParentTypes FileChooserError = '[]
instance O.HasParentTypes FileChooserError

foreign import ccall "gtk_file_chooser_error_get_type" c_gtk_file_chooser_error_get_type :: 
    IO GType

instance B.Types.TypedObject FileChooserError where
    glibType = c_gtk_file_chooser_error_get_type

instance B.Types.BoxedEnum FileChooserError

-- Enum FileChooserAction
-- | Describes whether a @GtkFileChooser@ is being used to open existing files
-- or to save to a possibly new file.
data FileChooserAction = 
      FileChooserActionOpen
    -- ^ Indicates open mode.  The file chooser
    --  will only let the user pick an existing file.
    | FileChooserActionSave
    -- ^ Indicates save mode.  The file chooser
    --  will let the user pick an existing file, or type in a new
    --  filename.
    | FileChooserActionSelectFolder
    -- ^ Indicates an Open mode for
    --  selecting folders.  The file chooser will let the user pick an
    --  existing folder.
    | AnotherFileChooserAction Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileChooserAction where
    fromEnum FileChooserActionOpen = 0
    fromEnum FileChooserActionSave = 1
    fromEnum FileChooserActionSelectFolder = 2
    fromEnum (AnotherFileChooserAction k) = k

    toEnum 0 = FileChooserActionOpen
    toEnum 1 = FileChooserActionSave
    toEnum 2 = FileChooserActionSelectFolder
    toEnum k = AnotherFileChooserAction k

instance P.Ord FileChooserAction where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileChooserAction = '[]
instance O.HasParentTypes FileChooserAction

foreign import ccall "gtk_file_chooser_action_get_type" c_gtk_file_chooser_action_get_type :: 
    IO GType

instance B.Types.TypedObject FileChooserAction where
    glibType = c_gtk_file_chooser_action_get_type

instance B.Types.BoxedEnum FileChooserAction

-- Enum EventSequenceState
-- | Describes the state of a t'GI.Gdk.Structs.EventSequence.EventSequence' in a [class/@gesture@/].
data EventSequenceState = 
      EventSequenceStateNone
    -- ^ The sequence is handled, but not grabbed.
    | EventSequenceStateClaimed
    -- ^ The sequence is handled and grabbed.
    | EventSequenceStateDenied
    -- ^ The sequence is denied.
    | AnotherEventSequenceState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EventSequenceState where
    fromEnum EventSequenceStateNone = 0
    fromEnum EventSequenceStateClaimed = 1
    fromEnum EventSequenceStateDenied = 2
    fromEnum (AnotherEventSequenceState k) = k

    toEnum 0 = EventSequenceStateNone
    toEnum 1 = EventSequenceStateClaimed
    toEnum 2 = EventSequenceStateDenied
    toEnum k = AnotherEventSequenceState k

instance P.Ord EventSequenceState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes EventSequenceState = '[]
instance O.HasParentTypes EventSequenceState

foreign import ccall "gtk_event_sequence_state_get_type" c_gtk_event_sequence_state_get_type :: 
    IO GType

instance B.Types.TypedObject EventSequenceState where
    glibType = c_gtk_event_sequence_state_get_type

instance B.Types.BoxedEnum EventSequenceState

-- Enum EntryIconPosition
-- | Specifies the side of the entry at which an icon is placed.
data EntryIconPosition = 
      EntryIconPositionPrimary
    -- ^ At the beginning of the entry (depending on the text direction).
    | EntryIconPositionSecondary
    -- ^ At the end of the entry (depending on the text direction).
    | AnotherEntryIconPosition Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EntryIconPosition where
    fromEnum EntryIconPositionPrimary = 0
    fromEnum EntryIconPositionSecondary = 1
    fromEnum (AnotherEntryIconPosition k) = k

    toEnum 0 = EntryIconPositionPrimary
    toEnum 1 = EntryIconPositionSecondary
    toEnum k = AnotherEntryIconPosition k

instance P.Ord EntryIconPosition where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes EntryIconPosition = '[]
instance O.HasParentTypes EntryIconPosition

foreign import ccall "gtk_entry_icon_position_get_type" c_gtk_entry_icon_position_get_type :: 
    IO GType

instance B.Types.TypedObject EntryIconPosition where
    glibType = c_gtk_entry_icon_position_get_type

instance B.Types.BoxedEnum EntryIconPosition

-- Enum EditableProperties
-- | The identifiers for t'GI.Gtk.Interfaces.Editable.Editable' properties.
-- 
-- See 'GI.Gtk.Interfaces.Editable.editableInstallProperties' for details on how to
-- implement the @GtkEditable@ interface.
data EditableProperties = 
      EditablePropertiesPropText
    -- ^ the property id for [Editable:text]("GI.Gtk.Interfaces.Editable#g:attr:text")
    | EditablePropertiesPropCursorPosition
    -- ^ the property id for [Editable:cursorPosition]("GI.Gtk.Interfaces.Editable#g:attr:cursorPosition")
    | EditablePropertiesPropSelectionBound
    -- ^ the property id for [Editable:selectionBound]("GI.Gtk.Interfaces.Editable#g:attr:selectionBound")
    | EditablePropertiesPropEditable
    -- ^ the property id for [Editable:editable]("GI.Gtk.Interfaces.Editable#g:attr:editable")
    | EditablePropertiesPropWidthChars
    -- ^ the property id for [Editable:widthChars]("GI.Gtk.Interfaces.Editable#g:attr:widthChars")
    | EditablePropertiesPropMaxWidthChars
    -- ^ the property id for [Editable:maxWidthChars]("GI.Gtk.Interfaces.Editable#g:attr:maxWidthChars")
    | EditablePropertiesPropXalign
    -- ^ the property id for [Editable:xalign]("GI.Gtk.Interfaces.Editable#g:attr:xalign")
    | EditablePropertiesPropEnableUndo
    -- ^ the property id for [Editable:enableUndo]("GI.Gtk.Interfaces.Editable#g:attr:enableUndo")
    | EditablePropertiesNumProperties
    -- ^ the number of properties
    | AnotherEditableProperties Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EditableProperties where
    fromEnum EditablePropertiesPropText = 0
    fromEnum EditablePropertiesPropCursorPosition = 1
    fromEnum EditablePropertiesPropSelectionBound = 2
    fromEnum EditablePropertiesPropEditable = 3
    fromEnum EditablePropertiesPropWidthChars = 4
    fromEnum EditablePropertiesPropMaxWidthChars = 5
    fromEnum EditablePropertiesPropXalign = 6
    fromEnum EditablePropertiesPropEnableUndo = 7
    fromEnum EditablePropertiesNumProperties = 8
    fromEnum (AnotherEditableProperties k) = k

    toEnum 0 = EditablePropertiesPropText
    toEnum 1 = EditablePropertiesPropCursorPosition
    toEnum 2 = EditablePropertiesPropSelectionBound
    toEnum 3 = EditablePropertiesPropEditable
    toEnum 4 = EditablePropertiesPropWidthChars
    toEnum 5 = EditablePropertiesPropMaxWidthChars
    toEnum 6 = EditablePropertiesPropXalign
    toEnum 7 = EditablePropertiesPropEnableUndo
    toEnum 8 = EditablePropertiesNumProperties
    toEnum k = AnotherEditableProperties k

instance P.Ord EditableProperties where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes EditableProperties = '[]
instance O.HasParentTypes EditableProperties

foreign import ccall "gtk_editable_properties_get_type" c_gtk_editable_properties_get_type :: 
    IO GType

instance B.Types.TypedObject EditableProperties where
    glibType = c_gtk_editable_properties_get_type

instance B.Types.BoxedEnum EditableProperties

-- Enum DirectionType
-- | Focus movement types.
data DirectionType = 
      DirectionTypeTabForward
    -- ^ Move forward.
    | DirectionTypeTabBackward
    -- ^ Move backward.
    | DirectionTypeUp
    -- ^ Move up.
    | DirectionTypeDown
    -- ^ Move down.
    | DirectionTypeLeft
    -- ^ Move left.
    | DirectionTypeRight
    -- ^ Move right.
    | AnotherDirectionType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DirectionType where
    fromEnum DirectionTypeTabForward = 0
    fromEnum DirectionTypeTabBackward = 1
    fromEnum DirectionTypeUp = 2
    fromEnum DirectionTypeDown = 3
    fromEnum DirectionTypeLeft = 4
    fromEnum DirectionTypeRight = 5
    fromEnum (AnotherDirectionType k) = k

    toEnum 0 = DirectionTypeTabForward
    toEnum 1 = DirectionTypeTabBackward
    toEnum 2 = DirectionTypeUp
    toEnum 3 = DirectionTypeDown
    toEnum 4 = DirectionTypeLeft
    toEnum 5 = DirectionTypeRight
    toEnum k = AnotherDirectionType k

instance P.Ord DirectionType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DirectionType = '[]
instance O.HasParentTypes DirectionType

foreign import ccall "gtk_direction_type_get_type" c_gtk_direction_type_get_type :: 
    IO GType

instance B.Types.TypedObject DirectionType where
    glibType = c_gtk_direction_type_get_type

instance B.Types.BoxedEnum DirectionType

-- Enum DialogError
-- | Error codes in the @GTK_DIALOG_ERROR@ domain that can be returned
-- by async dialog functions.
-- 
-- /Since: 4.10/
data DialogError = 
      DialogErrorFailed
    -- ^ Generic error condition for when
    --   an operation fails and no more specific code is applicable
    | DialogErrorCancelled
    -- ^ The async function call was cancelled
    --   via its @GCancellable@
    | DialogErrorDismissed
    -- ^ The operation was cancelled
    --   by the user (via a Cancel or Close button)
    | AnotherDialogError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DialogError where
    fromEnum DialogErrorFailed = 0
    fromEnum DialogErrorCancelled = 1
    fromEnum DialogErrorDismissed = 2
    fromEnum (AnotherDialogError k) = k

    toEnum 0 = DialogErrorFailed
    toEnum 1 = DialogErrorCancelled
    toEnum 2 = DialogErrorDismissed
    toEnum k = AnotherDialogError k

instance P.Ord DialogError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass DialogError where
    gerrorClassDomain _ = "gtk-dialog-error-quark"

-- | Catch exceptions of type `DialogError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchDialogError ::
    IO a ->
    (DialogError -> GErrorMessage -> IO a) ->
    IO a
catchDialogError = catchGErrorJustDomain

-- | Handle exceptions of type `DialogError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleDialogError ::
    (DialogError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleDialogError = handleGErrorJustDomain

type instance O.ParentTypes DialogError = '[]
instance O.HasParentTypes DialogError

foreign import ccall "gtk_dialog_error_get_type" c_gtk_dialog_error_get_type :: 
    IO GType

instance B.Types.TypedObject DialogError where
    glibType = c_gtk_dialog_error_get_type

instance B.Types.BoxedEnum DialogError

-- Enum DeleteType
-- | Passed to various keybinding signals for deleting text.
data DeleteType = 
      DeleteTypeChars
    -- ^ Delete characters.
    | DeleteTypeWordEnds
    -- ^ Delete only the portion of the word to the
    --   left\/right of cursor if we’re in the middle of a word.
    | DeleteTypeWords
    -- ^ Delete words.
    | DeleteTypeDisplayLines
    -- ^ Delete display-lines. Display-lines
    --   refers to the visible lines, with respect to the current line
    --   breaks. As opposed to paragraphs, which are defined by line
    --   breaks in the input.
    | DeleteTypeDisplayLineEnds
    -- ^ Delete only the portion of the
    --   display-line to the left\/right of cursor.
    | DeleteTypeParagraphEnds
    -- ^ Delete to the end of the
    --   paragraph. Like C-k in Emacs (or its reverse).
    | DeleteTypeParagraphs
    -- ^ Delete entire line. Like C-k in pico.
    | DeleteTypeWhitespace
    -- ^ Delete only whitespace. Like M-\\ in Emacs.
    | AnotherDeleteType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DeleteType where
    fromEnum DeleteTypeChars = 0
    fromEnum DeleteTypeWordEnds = 1
    fromEnum DeleteTypeWords = 2
    fromEnum DeleteTypeDisplayLines = 3
    fromEnum DeleteTypeDisplayLineEnds = 4
    fromEnum DeleteTypeParagraphEnds = 5
    fromEnum DeleteTypeParagraphs = 6
    fromEnum DeleteTypeWhitespace = 7
    fromEnum (AnotherDeleteType k) = k

    toEnum 0 = DeleteTypeChars
    toEnum 1 = DeleteTypeWordEnds
    toEnum 2 = DeleteTypeWords
    toEnum 3 = DeleteTypeDisplayLines
    toEnum 4 = DeleteTypeDisplayLineEnds
    toEnum 5 = DeleteTypeParagraphEnds
    toEnum 6 = DeleteTypeParagraphs
    toEnum 7 = DeleteTypeWhitespace
    toEnum k = AnotherDeleteType k

instance P.Ord DeleteType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DeleteType = '[]
instance O.HasParentTypes DeleteType

foreign import ccall "gtk_delete_type_get_type" c_gtk_delete_type_get_type :: 
    IO GType

instance B.Types.TypedObject DeleteType where
    glibType = c_gtk_delete_type_get_type

instance B.Types.BoxedEnum DeleteType

-- Enum CssParserWarning
-- | Warnings that can occur while parsing CSS.
-- 
-- Unlike @GtkCssParserError@s, warnings do not cause the parser to
-- skip any input, but they indicate issues that should be fixed.
data CssParserWarning = 
      CssParserWarningDeprecated
    -- ^ The given construct is
    --   deprecated and will be removed in a future version
    | CssParserWarningSyntax
    -- ^ A syntax construct was used
    --   that should be avoided
    | CssParserWarningUnimplemented
    -- ^ A feature is not implemented
    | AnotherCssParserWarning Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CssParserWarning where
    fromEnum CssParserWarningDeprecated = 0
    fromEnum CssParserWarningSyntax = 1
    fromEnum CssParserWarningUnimplemented = 2
    fromEnum (AnotherCssParserWarning k) = k

    toEnum 0 = CssParserWarningDeprecated
    toEnum 1 = CssParserWarningSyntax
    toEnum 2 = CssParserWarningUnimplemented
    toEnum k = AnotherCssParserWarning k

instance P.Ord CssParserWarning where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum CssParserError
-- | Errors that can occur while parsing CSS.
-- 
-- These errors are unexpected and will cause parts of the given CSS
-- to be ignored.
data CssParserError = 
      CssParserErrorFailed
    -- ^ Unknown failure.
    | CssParserErrorSyntax
    -- ^ The given text does not form valid syntax
    | CssParserErrorImport
    -- ^ Failed to import a resource
    | CssParserErrorName
    -- ^ The given name has not been defined
    | CssParserErrorUnknownValue
    -- ^ The given value is not correct
    | AnotherCssParserError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CssParserError where
    fromEnum CssParserErrorFailed = 0
    fromEnum CssParserErrorSyntax = 1
    fromEnum CssParserErrorImport = 2
    fromEnum CssParserErrorName = 3
    fromEnum CssParserErrorUnknownValue = 4
    fromEnum (AnotherCssParserError k) = k

    toEnum 0 = CssParserErrorFailed
    toEnum 1 = CssParserErrorSyntax
    toEnum 2 = CssParserErrorImport
    toEnum 3 = CssParserErrorName
    toEnum 4 = CssParserErrorUnknownValue
    toEnum k = AnotherCssParserError k

instance P.Ord CssParserError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass CssParserError where
    gerrorClassDomain _ = "gtk-css-parser-error-quark"

-- | Catch exceptions of type `CssParserError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchCssParserError ::
    IO a ->
    (CssParserError -> GErrorMessage -> IO a) ->
    IO a
catchCssParserError = catchGErrorJustDomain

-- | Handle exceptions of type `CssParserError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleCssParserError ::
    (CssParserError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleCssParserError = handleGErrorJustDomain

-- Enum CornerType
-- | Specifies which corner a child widget should be placed in when packed into
-- a @GtkScrolledWindow.@
-- 
-- This is effectively the opposite of where the scroll bars are placed.
data CornerType = 
      CornerTypeTopLeft
    -- ^ Place the scrollbars on the right and bottom of the
    --   widget (default behaviour).
    | CornerTypeBottomLeft
    -- ^ Place the scrollbars on the top and right of the
    --   widget.
    | CornerTypeTopRight
    -- ^ Place the scrollbars on the left and bottom of the
    --   widget.
    | CornerTypeBottomRight
    -- ^ Place the scrollbars on the top and left of the
    --   widget.
    | AnotherCornerType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CornerType where
    fromEnum CornerTypeTopLeft = 0
    fromEnum CornerTypeBottomLeft = 1
    fromEnum CornerTypeTopRight = 2
    fromEnum CornerTypeBottomRight = 3
    fromEnum (AnotherCornerType k) = k

    toEnum 0 = CornerTypeTopLeft
    toEnum 1 = CornerTypeBottomLeft
    toEnum 2 = CornerTypeTopRight
    toEnum 3 = CornerTypeBottomRight
    toEnum k = AnotherCornerType k

instance P.Ord CornerType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CornerType = '[]
instance O.HasParentTypes CornerType

foreign import ccall "gtk_corner_type_get_type" c_gtk_corner_type_get_type :: 
    IO GType

instance B.Types.TypedObject CornerType where
    glibType = c_gtk_corner_type_get_type

instance B.Types.BoxedEnum CornerType

-- Enum ContentFit
-- | Controls how a content should be made to fit inside an allocation.
-- 
-- /Since: 4.8/
data ContentFit = 
      ContentFitFill
    -- ^ Make the content fill the entire allocation,
    --   without taking its aspect ratio in consideration. The resulting
    --   content will appear as stretched if its aspect ratio is different
    --   from the allocation aspect ratio.
    | ContentFitContain
    -- ^ Scale the content to fit the allocation,
    --   while taking its aspect ratio in consideration. The resulting
    --   content will appear as letterboxed if its aspect ratio is different
    --   from the allocation aspect ratio.
    | ContentFitCover
    -- ^ Cover the entire allocation, while taking
    --   the content aspect ratio in consideration. The resulting content
    --   will appear as clipped if its aspect ratio is different from the
    --   allocation aspect ratio.
    | ContentFitScaleDown
    -- ^ The content is scaled down to fit the
    --   allocation, if needed, otherwise its original size is used.
    | AnotherContentFit Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ContentFit where
    fromEnum ContentFitFill = 0
    fromEnum ContentFitContain = 1
    fromEnum ContentFitCover = 2
    fromEnum ContentFitScaleDown = 3
    fromEnum (AnotherContentFit k) = k

    toEnum 0 = ContentFitFill
    toEnum 1 = ContentFitContain
    toEnum 2 = ContentFitCover
    toEnum 3 = ContentFitScaleDown
    toEnum k = AnotherContentFit k

instance P.Ord ContentFit where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ContentFit = '[]
instance O.HasParentTypes ContentFit

foreign import ccall "gtk_content_fit_get_type" c_gtk_content_fit_get_type :: 
    IO GType

instance B.Types.TypedObject ContentFit where
    glibType = c_gtk_content_fit_get_type

instance B.Types.BoxedEnum ContentFit

-- Enum ConstraintVflParserError
-- | Domain for VFL parsing errors.
data ConstraintVflParserError = 
      ConstraintVflParserErrorSymbol
    -- ^ Invalid or unknown symbol
    | ConstraintVflParserErrorAttribute
    -- ^ Invalid or unknown attribute
    | ConstraintVflParserErrorView
    -- ^ Invalid or unknown view
    | ConstraintVflParserErrorMetric
    -- ^ Invalid or unknown metric
    | ConstraintVflParserErrorPriority
    -- ^ Invalid or unknown priority
    | ConstraintVflParserErrorRelation
    -- ^ Invalid or unknown relation
    | AnotherConstraintVflParserError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ConstraintVflParserError where
    fromEnum ConstraintVflParserErrorSymbol = 0
    fromEnum ConstraintVflParserErrorAttribute = 1
    fromEnum ConstraintVflParserErrorView = 2
    fromEnum ConstraintVflParserErrorMetric = 3
    fromEnum ConstraintVflParserErrorPriority = 4
    fromEnum ConstraintVflParserErrorRelation = 5
    fromEnum (AnotherConstraintVflParserError k) = k

    toEnum 0 = ConstraintVflParserErrorSymbol
    toEnum 1 = ConstraintVflParserErrorAttribute
    toEnum 2 = ConstraintVflParserErrorView
    toEnum 3 = ConstraintVflParserErrorMetric
    toEnum 4 = ConstraintVflParserErrorPriority
    toEnum 5 = ConstraintVflParserErrorRelation
    toEnum k = AnotherConstraintVflParserError k

instance P.Ord ConstraintVflParserError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass ConstraintVflParserError where
    gerrorClassDomain _ = "gtk-constraint-vfl-parser-error-quark"

-- | Catch exceptions of type `ConstraintVflParserError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchConstraintVflParserError ::
    IO a ->
    (ConstraintVflParserError -> GErrorMessage -> IO a) ->
    IO a
catchConstraintVflParserError = catchGErrorJustDomain

-- | Handle exceptions of type `ConstraintVflParserError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleConstraintVflParserError ::
    (ConstraintVflParserError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleConstraintVflParserError = handleGErrorJustDomain

type instance O.ParentTypes ConstraintVflParserError = '[]
instance O.HasParentTypes ConstraintVflParserError

foreign import ccall "gtk_constraint_vfl_parser_error_get_type" c_gtk_constraint_vfl_parser_error_get_type :: 
    IO GType

instance B.Types.TypedObject ConstraintVflParserError where
    glibType = c_gtk_constraint_vfl_parser_error_get_type

instance B.Types.BoxedEnum ConstraintVflParserError

-- Enum ConstraintStrength
-- | The strength of a constraint, expressed as a symbolic constant.
-- 
-- The strength of a [class/@constraint@/] can be expressed with any positive
-- integer; the values of this enumeration can be used for readability.
data ConstraintStrength = 
      ConstraintStrengthRequired
    -- ^ The constraint is required towards solving the layout
    | ConstraintStrengthStrong
    -- ^ A strong constraint
    | ConstraintStrengthMedium
    -- ^ A medium constraint
    | ConstraintStrengthWeak
    -- ^ A weak constraint
    | AnotherConstraintStrength Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ConstraintStrength where
    fromEnum ConstraintStrengthRequired = 1001001000
    fromEnum ConstraintStrengthStrong = 1000000000
    fromEnum ConstraintStrengthMedium = 1000
    fromEnum ConstraintStrengthWeak = 1
    fromEnum (AnotherConstraintStrength k) = k

    toEnum 1001001000 = ConstraintStrengthRequired
    toEnum 1000000000 = ConstraintStrengthStrong
    toEnum 1000 = ConstraintStrengthMedium
    toEnum 1 = ConstraintStrengthWeak
    toEnum k = AnotherConstraintStrength k

instance P.Ord ConstraintStrength where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ConstraintStrength = '[]
instance O.HasParentTypes ConstraintStrength

foreign import ccall "gtk_constraint_strength_get_type" c_gtk_constraint_strength_get_type :: 
    IO GType

instance B.Types.TypedObject ConstraintStrength where
    glibType = c_gtk_constraint_strength_get_type

instance B.Types.BoxedEnum ConstraintStrength

-- Enum ConstraintRelation
-- | The relation between two terms of a constraint.
data ConstraintRelation = 
      ConstraintRelationLe
    -- ^ Less than, or equal
    | ConstraintRelationEq
    -- ^ Equal
    | ConstraintRelationGe
    -- ^ Greater than, or equal
    | AnotherConstraintRelation Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ConstraintRelation where
    fromEnum ConstraintRelationLe = -1
    fromEnum ConstraintRelationEq = 0
    fromEnum ConstraintRelationGe = 1
    fromEnum (AnotherConstraintRelation k) = k

    toEnum -1 = ConstraintRelationLe
    toEnum 0 = ConstraintRelationEq
    toEnum 1 = ConstraintRelationGe
    toEnum k = AnotherConstraintRelation k

instance P.Ord ConstraintRelation where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ConstraintRelation = '[]
instance O.HasParentTypes ConstraintRelation

foreign import ccall "gtk_constraint_relation_get_type" c_gtk_constraint_relation_get_type :: 
    IO GType

instance B.Types.TypedObject ConstraintRelation where
    glibType = c_gtk_constraint_relation_get_type

instance B.Types.BoxedEnum ConstraintRelation

-- Enum ConstraintAttribute
-- | The widget attributes that can be used when creating a [class/@constraint@/].
data ConstraintAttribute = 
      ConstraintAttributeNone
    -- ^ No attribute, used for constant
    --   relations
    | ConstraintAttributeLeft
    -- ^ The left edge of a widget, regardless of
    --   text direction
    | ConstraintAttributeRight
    -- ^ The right edge of a widget, regardless
    --   of text direction
    | ConstraintAttributeTop
    -- ^ The top edge of a widget
    | ConstraintAttributeBottom
    -- ^ The bottom edge of a widget
    | ConstraintAttributeStart
    -- ^ The leading edge of a widget, depending
    --   on text direction; equivalent to 'GI.Gtk.Enums.ConstraintAttributeLeft' for LTR
    --   languages, and 'GI.Gtk.Enums.ConstraintAttributeRight' for RTL ones
    | ConstraintAttributeEnd
    -- ^ The trailing edge of a widget, depending
    --   on text direction; equivalent to 'GI.Gtk.Enums.ConstraintAttributeRight' for LTR
    --   languages, and 'GI.Gtk.Enums.ConstraintAttributeLeft' for RTL ones
    | ConstraintAttributeWidth
    -- ^ The width of a widget
    | ConstraintAttributeHeight
    -- ^ The height of a widget
    | ConstraintAttributeCenterX
    -- ^ The center of a widget, on the
    --   horizontal axis
    | ConstraintAttributeCenterY
    -- ^ The center of a widget, on the
    --   vertical axis
    | ConstraintAttributeBaseline
    -- ^ The baseline of a widget
    | AnotherConstraintAttribute Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ConstraintAttribute where
    fromEnum ConstraintAttributeNone = 0
    fromEnum ConstraintAttributeLeft = 1
    fromEnum ConstraintAttributeRight = 2
    fromEnum ConstraintAttributeTop = 3
    fromEnum ConstraintAttributeBottom = 4
    fromEnum ConstraintAttributeStart = 5
    fromEnum ConstraintAttributeEnd = 6
    fromEnum ConstraintAttributeWidth = 7
    fromEnum ConstraintAttributeHeight = 8
    fromEnum ConstraintAttributeCenterX = 9
    fromEnum ConstraintAttributeCenterY = 10
    fromEnum ConstraintAttributeBaseline = 11
    fromEnum (AnotherConstraintAttribute k) = k

    toEnum 0 = ConstraintAttributeNone
    toEnum 1 = ConstraintAttributeLeft
    toEnum 2 = ConstraintAttributeRight
    toEnum 3 = ConstraintAttributeTop
    toEnum 4 = ConstraintAttributeBottom
    toEnum 5 = ConstraintAttributeStart
    toEnum 6 = ConstraintAttributeEnd
    toEnum 7 = ConstraintAttributeWidth
    toEnum 8 = ConstraintAttributeHeight
    toEnum 9 = ConstraintAttributeCenterX
    toEnum 10 = ConstraintAttributeCenterY
    toEnum 11 = ConstraintAttributeBaseline
    toEnum k = AnotherConstraintAttribute k

instance P.Ord ConstraintAttribute where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ConstraintAttribute = '[]
instance O.HasParentTypes ConstraintAttribute

foreign import ccall "gtk_constraint_attribute_get_type" c_gtk_constraint_attribute_get_type :: 
    IO GType

instance B.Types.TypedObject ConstraintAttribute where
    glibType = c_gtk_constraint_attribute_get_type

instance B.Types.BoxedEnum ConstraintAttribute

-- Enum Collation
-- | Describes how a t'GI.Gtk.Objects.StringSorter.StringSorter' turns strings into sort keys to
-- compare them.
-- 
-- Note that the result of sorting will in general depend on the current locale
-- unless the mode is /@gTKCOLLATIONNONE@/.
-- 
-- /Since: 4.10/
data Collation = 
      CollationNone
    -- ^ Don\'t do any collation
    | CollationUnicode
    -- ^ Use 'GI.GLib.Functions.utf8CollateKey'
    | CollationFilename
    -- ^ Use 'GI.GLib.Functions.utf8CollateKeyForFilename'
    | AnotherCollation Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Collation where
    fromEnum CollationNone = 0
    fromEnum CollationUnicode = 1
    fromEnum CollationFilename = 2
    fromEnum (AnotherCollation k) = k

    toEnum 0 = CollationNone
    toEnum 1 = CollationUnicode
    toEnum 2 = CollationFilename
    toEnum k = AnotherCollation k

instance P.Ord Collation where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Collation = '[]
instance O.HasParentTypes Collation

foreign import ccall "gtk_collation_get_type" c_gtk_collation_get_type :: 
    IO GType

instance B.Types.TypedObject Collation where
    glibType = c_gtk_collation_get_type

instance B.Types.BoxedEnum Collation

-- Enum CellRendererMode
{-# DEPRECATED CellRendererMode ["(Since version 4.20)","There is no replacement."] #-}
-- | Identifies how the user can interact with a particular cell.
data CellRendererMode = 
      CellRendererModeInert
    -- ^ The cell is just for display
    --  and cannot be interacted with.  Note that this doesn’t mean that eg. the
    --  row being drawn can’t be selected -- just that a particular element of
    --  it cannot be individually modified.
    | CellRendererModeActivatable
    -- ^ The cell can be clicked.
    | CellRendererModeEditable
    -- ^ The cell can be edited or otherwise modified.
    | AnotherCellRendererMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CellRendererMode where
    fromEnum CellRendererModeInert = 0
    fromEnum CellRendererModeActivatable = 1
    fromEnum CellRendererModeEditable = 2
    fromEnum (AnotherCellRendererMode k) = k

    toEnum 0 = CellRendererModeInert
    toEnum 1 = CellRendererModeActivatable
    toEnum 2 = CellRendererModeEditable
    toEnum k = AnotherCellRendererMode k

instance P.Ord CellRendererMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CellRendererMode = '[]
instance O.HasParentTypes CellRendererMode

foreign import ccall "gtk_cell_renderer_mode_get_type" c_gtk_cell_renderer_mode_get_type :: 
    IO GType

instance B.Types.TypedObject CellRendererMode where
    glibType = c_gtk_cell_renderer_mode_get_type

instance B.Types.BoxedEnum CellRendererMode

-- Enum CellRendererAccelMode
{-# DEPRECATED CellRendererAccelMode ["(Since version 4.20)","There is no replacement"] #-}
-- | The available modes for [CellRendererAccel:accelMode]("GI.Gtk.Objects.CellRendererAccel#g:attr:accelMode").
data CellRendererAccelMode = 
      CellRendererAccelModeGtk
    -- ^ GTK accelerators mode
    | CellRendererAccelModeOther
    -- ^ Other accelerator mode
    | AnotherCellRendererAccelMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CellRendererAccelMode where
    fromEnum CellRendererAccelModeGtk = 0
    fromEnum CellRendererAccelModeOther = 1
    fromEnum (AnotherCellRendererAccelMode k) = k

    toEnum 0 = CellRendererAccelModeGtk
    toEnum 1 = CellRendererAccelModeOther
    toEnum k = AnotherCellRendererAccelMode k

instance P.Ord CellRendererAccelMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CellRendererAccelMode = '[]
instance O.HasParentTypes CellRendererAccelMode

foreign import ccall "gtk_cell_renderer_accel_mode_get_type" c_gtk_cell_renderer_accel_mode_get_type :: 
    IO GType

instance B.Types.TypedObject CellRendererAccelMode where
    glibType = c_gtk_cell_renderer_accel_mode_get_type

instance B.Types.BoxedEnum CellRendererAccelMode

-- Enum ButtonsType
-- | Prebuilt sets of buttons for @GtkDialog@.
-- 
-- If none of these choices are appropriate, simply use
-- 'GI.Gtk.Enums.ButtonsTypeNone' and call t'GI.Gtk.Objects.Dialog.Dialog'.@/add_buttons/@().
-- 
-- > Please note that 'GI.Gtk.Enums.ButtonsTypeOk', 'GI.Gtk.Enums.ButtonsTypeYesNo'
-- > and 'GI.Gtk.Enums.ButtonsTypeOkCancel' are discouraged by the
-- > <https://developer.gnome.org/hig/ GNOME Human Interface Guidelines>.
data ButtonsType = 
      ButtonsTypeNone
    -- ^ no buttons at all
    | ButtonsTypeOk
    -- ^ an OK button
    | ButtonsTypeClose
    -- ^ a Close button
    | ButtonsTypeCancel
    -- ^ a Cancel button
    | ButtonsTypeYesNo
    -- ^ Yes and No buttons
    | ButtonsTypeOkCancel
    -- ^ OK and Cancel buttons
    | AnotherButtonsType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ButtonsType where
    fromEnum ButtonsTypeNone = 0
    fromEnum ButtonsTypeOk = 1
    fromEnum ButtonsTypeClose = 2
    fromEnum ButtonsTypeCancel = 3
    fromEnum ButtonsTypeYesNo = 4
    fromEnum ButtonsTypeOkCancel = 5
    fromEnum (AnotherButtonsType k) = k

    toEnum 0 = ButtonsTypeNone
    toEnum 1 = ButtonsTypeOk
    toEnum 2 = ButtonsTypeClose
    toEnum 3 = ButtonsTypeCancel
    toEnum 4 = ButtonsTypeYesNo
    toEnum 5 = ButtonsTypeOkCancel
    toEnum k = AnotherButtonsType k

instance P.Ord ButtonsType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ButtonsType = '[]
instance O.HasParentTypes ButtonsType

foreign import ccall "gtk_buttons_type_get_type" c_gtk_buttons_type_get_type :: 
    IO GType

instance B.Types.TypedObject ButtonsType where
    glibType = c_gtk_buttons_type_get_type

instance B.Types.BoxedEnum ButtonsType

-- Enum BuilderError
-- | Error codes that identify various errors that can occur while using
-- @GtkBuilder@.
data BuilderError = 
      BuilderErrorInvalidTypeFunction
    -- ^ A type-func attribute didn’t name
    --  a function that returns a @GType@.
    | BuilderErrorUnhandledTag
    -- ^ The input contained a tag that @GtkBuilder@
    --  can’t handle.
    | BuilderErrorMissingAttribute
    -- ^ An attribute that is required by
    --  @GtkBuilder@ was missing.
    | BuilderErrorInvalidAttribute
    -- ^ @GtkBuilder@ found an attribute that
    --  it doesn’t understand.
    | BuilderErrorInvalidTag
    -- ^ @GtkBuilder@ found a tag that
    --  it doesn’t understand.
    | BuilderErrorMissingPropertyValue
    -- ^ A required property value was
    --  missing.
    | BuilderErrorInvalidValue
    -- ^ @GtkBuilder@ couldn’t parse
    --  some attribute value.
    | BuilderErrorVersionMismatch
    -- ^ The input file requires a newer version
    --  of GTK.
    | BuilderErrorDuplicateId
    -- ^ An object id occurred twice.
    | BuilderErrorObjectTypeRefused
    -- ^ A specified object type is of the same type or
    --  derived from the type of the composite class being extended with builder XML.
    | BuilderErrorTemplateMismatch
    -- ^ The wrong type was specified in a composite class’s template XML
    | BuilderErrorInvalidProperty
    -- ^ The specified property is unknown for the object class.
    | BuilderErrorInvalidSignal
    -- ^ The specified signal is unknown for the object class.
    | BuilderErrorInvalidId
    -- ^ An object id is unknown.
    | BuilderErrorInvalidFunction
    -- ^ A function could not be found. This often happens
    --   when symbols are set to be kept private. Compiling code with -rdynamic or using the
    --   @gmodule-export-2.0@ pkgconfig module can fix this problem.
    | AnotherBuilderError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BuilderError where
    fromEnum BuilderErrorInvalidTypeFunction = 0
    fromEnum BuilderErrorUnhandledTag = 1
    fromEnum BuilderErrorMissingAttribute = 2
    fromEnum BuilderErrorInvalidAttribute = 3
    fromEnum BuilderErrorInvalidTag = 4
    fromEnum BuilderErrorMissingPropertyValue = 5
    fromEnum BuilderErrorInvalidValue = 6
    fromEnum BuilderErrorVersionMismatch = 7
    fromEnum BuilderErrorDuplicateId = 8
    fromEnum BuilderErrorObjectTypeRefused = 9
    fromEnum BuilderErrorTemplateMismatch = 10
    fromEnum BuilderErrorInvalidProperty = 11
    fromEnum BuilderErrorInvalidSignal = 12
    fromEnum BuilderErrorInvalidId = 13
    fromEnum BuilderErrorInvalidFunction = 14
    fromEnum (AnotherBuilderError k) = k

    toEnum 0 = BuilderErrorInvalidTypeFunction
    toEnum 1 = BuilderErrorUnhandledTag
    toEnum 2 = BuilderErrorMissingAttribute
    toEnum 3 = BuilderErrorInvalidAttribute
    toEnum 4 = BuilderErrorInvalidTag
    toEnum 5 = BuilderErrorMissingPropertyValue
    toEnum 6 = BuilderErrorInvalidValue
    toEnum 7 = BuilderErrorVersionMismatch
    toEnum 8 = BuilderErrorDuplicateId
    toEnum 9 = BuilderErrorObjectTypeRefused
    toEnum 10 = BuilderErrorTemplateMismatch
    toEnum 11 = BuilderErrorInvalidProperty
    toEnum 12 = BuilderErrorInvalidSignal
    toEnum 13 = BuilderErrorInvalidId
    toEnum 14 = BuilderErrorInvalidFunction
    toEnum k = AnotherBuilderError k

instance P.Ord BuilderError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass BuilderError where
    gerrorClassDomain _ = "gtk-builder-error-quark"

-- | Catch exceptions of type `BuilderError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchBuilderError ::
    IO a ->
    (BuilderError -> GErrorMessage -> IO a) ->
    IO a
catchBuilderError = catchGErrorJustDomain

-- | Handle exceptions of type `BuilderError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleBuilderError ::
    (BuilderError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleBuilderError = handleGErrorJustDomain

type instance O.ParentTypes BuilderError = '[]
instance O.HasParentTypes BuilderError

foreign import ccall "gtk_builder_error_get_type" c_gtk_builder_error_get_type :: 
    IO GType

instance B.Types.TypedObject BuilderError where
    glibType = c_gtk_builder_error_get_type

instance B.Types.BoxedEnum BuilderError

-- Enum BorderStyle
-- | Describes how the border of a UI element should be rendered.
data BorderStyle = 
      BorderStyleNone
    -- ^ No visible border
    | BorderStyleHidden
    -- ^ Same as 'GI.Gtk.Enums.BorderStyleNone'
    | BorderStyleSolid
    -- ^ A single line segment
    | BorderStyleInset
    -- ^ Looks as if the content is sunken into the canvas
    | BorderStyleOutset
    -- ^ Looks as if the content is coming out of the canvas
    | BorderStyleDotted
    -- ^ A series of round dots
    | BorderStyleDashed
    -- ^ A series of square-ended dashes
    | BorderStyleDouble
    -- ^ Two parallel lines with some space between them
    | BorderStyleGroove
    -- ^ Looks as if it were carved in the canvas
    | BorderStyleRidge
    -- ^ Looks as if it were coming out of the canvas
    | AnotherBorderStyle Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BorderStyle where
    fromEnum BorderStyleNone = 0
    fromEnum BorderStyleHidden = 1
    fromEnum BorderStyleSolid = 2
    fromEnum BorderStyleInset = 3
    fromEnum BorderStyleOutset = 4
    fromEnum BorderStyleDotted = 5
    fromEnum BorderStyleDashed = 6
    fromEnum BorderStyleDouble = 7
    fromEnum BorderStyleGroove = 8
    fromEnum BorderStyleRidge = 9
    fromEnum (AnotherBorderStyle k) = k

    toEnum 0 = BorderStyleNone
    toEnum 1 = BorderStyleHidden
    toEnum 2 = BorderStyleSolid
    toEnum 3 = BorderStyleInset
    toEnum 4 = BorderStyleOutset
    toEnum 5 = BorderStyleDotted
    toEnum 6 = BorderStyleDashed
    toEnum 7 = BorderStyleDouble
    toEnum 8 = BorderStyleGroove
    toEnum 9 = BorderStyleRidge
    toEnum k = AnotherBorderStyle k

instance P.Ord BorderStyle where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BorderStyle = '[]
instance O.HasParentTypes BorderStyle

foreign import ccall "gtk_border_style_get_type" c_gtk_border_style_get_type :: 
    IO GType

instance B.Types.TypedObject BorderStyle where
    glibType = c_gtk_border_style_get_type

instance B.Types.BoxedEnum BorderStyle

-- Enum BaselinePosition
-- | Baseline position in a row of widgets.
-- 
-- Whenever a container has some form of natural row it may align
-- children in that row along a common typographical baseline. If
-- the amount of vertical space in the row is taller than the total
-- requested height of the baseline-aligned children then it can use a
-- @GtkBaselinePosition@ to select where to put the baseline inside the
-- extra available space.
data BaselinePosition = 
      BaselinePositionTop
    -- ^ Align the baseline at the top
    | BaselinePositionCenter
    -- ^ Center the baseline
    | BaselinePositionBottom
    -- ^ Align the baseline at the bottom
    | AnotherBaselinePosition Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BaselinePosition where
    fromEnum BaselinePositionTop = 0
    fromEnum BaselinePositionCenter = 1
    fromEnum BaselinePositionBottom = 2
    fromEnum (AnotherBaselinePosition k) = k

    toEnum 0 = BaselinePositionTop
    toEnum 1 = BaselinePositionCenter
    toEnum 2 = BaselinePositionBottom
    toEnum k = AnotherBaselinePosition k

instance P.Ord BaselinePosition where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BaselinePosition = '[]
instance O.HasParentTypes BaselinePosition

foreign import ccall "gtk_baseline_position_get_type" c_gtk_baseline_position_get_type :: 
    IO GType

instance B.Types.TypedObject BaselinePosition where
    glibType = c_gtk_baseline_position_get_type

instance B.Types.BoxedEnum BaselinePosition

-- Enum AssistantPageType
{-# DEPRECATED AssistantPageType ["(Since version 4.10)","@GtkAssistant@ will be removed in GTK 5"] #-}
-- | Determines the role of a page inside a @GtkAssistant@.
-- 
-- The role is used to handle buttons sensitivity and visibility.
-- 
-- Note that an assistant needs to end its page flow with a page of type
-- 'GI.Gtk.Enums.AssistantPageTypeConfirm', 'GI.Gtk.Enums.AssistantPageTypeSummary' or
-- 'GI.Gtk.Enums.AssistantPageTypeProgress' to be correct.
-- 
-- The Cancel button will only be shown if the page isn’t “committed”.
-- See 'GI.Gtk.Objects.Assistant.assistantCommit' for details.
data AssistantPageType = 
      AssistantPageTypeContent
    -- ^ The page has regular contents. Both the
    --  Back and forward buttons will be shown.
    | AssistantPageTypeIntro
    -- ^ The page contains an introduction to the
    --  assistant task. Only the Forward button will be shown if there is a
    --   next page.
    | AssistantPageTypeConfirm
    -- ^ The page lets the user confirm or deny the
    --  changes. The Back and Apply buttons will be shown.
    | AssistantPageTypeSummary
    -- ^ The page informs the user of the changes
    --  done. Only the Close button will be shown.
    | AssistantPageTypeProgress
    -- ^ Used for tasks that take a long time to
    --  complete, blocks the assistant until the page is marked as complete.
    --   Only the back button will be shown.
    | AssistantPageTypeCustom
    -- ^ Used for when other page types are not
    --  appropriate. No buttons will be shown, and the application must
    --  add its own buttons through 'GI.Gtk.Objects.Assistant.assistantAddActionWidget'.
    | AnotherAssistantPageType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AssistantPageType where
    fromEnum AssistantPageTypeContent = 0
    fromEnum AssistantPageTypeIntro = 1
    fromEnum AssistantPageTypeConfirm = 2
    fromEnum AssistantPageTypeSummary = 3
    fromEnum AssistantPageTypeProgress = 4
    fromEnum AssistantPageTypeCustom = 5
    fromEnum (AnotherAssistantPageType k) = k

    toEnum 0 = AssistantPageTypeContent
    toEnum 1 = AssistantPageTypeIntro
    toEnum 2 = AssistantPageTypeConfirm
    toEnum 3 = AssistantPageTypeSummary
    toEnum 4 = AssistantPageTypeProgress
    toEnum 5 = AssistantPageTypeCustom
    toEnum k = AnotherAssistantPageType k

instance P.Ord AssistantPageType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AssistantPageType = '[]
instance O.HasParentTypes AssistantPageType

foreign import ccall "gtk_assistant_page_type_get_type" c_gtk_assistant_page_type_get_type :: 
    IO GType

instance B.Types.TypedObject AssistantPageType where
    glibType = c_gtk_assistant_page_type_get_type

instance B.Types.BoxedEnum AssistantPageType

-- Enum ArrowType
-- | Indicates the direction in which an arrow should point.
data ArrowType = 
      ArrowTypeUp
    -- ^ Represents an upward pointing arrow.
    | ArrowTypeDown
    -- ^ Represents a downward pointing arrow.
    | ArrowTypeLeft
    -- ^ Represents a left pointing arrow.
    | ArrowTypeRight
    -- ^ Represents a right pointing arrow.
    | ArrowTypeNone
    -- ^ No arrow.
    | AnotherArrowType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ArrowType where
    fromEnum ArrowTypeUp = 0
    fromEnum ArrowTypeDown = 1
    fromEnum ArrowTypeLeft = 2
    fromEnum ArrowTypeRight = 3
    fromEnum ArrowTypeNone = 4
    fromEnum (AnotherArrowType k) = k

    toEnum 0 = ArrowTypeUp
    toEnum 1 = ArrowTypeDown
    toEnum 2 = ArrowTypeLeft
    toEnum 3 = ArrowTypeRight
    toEnum 4 = ArrowTypeNone
    toEnum k = AnotherArrowType k

instance P.Ord ArrowType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ArrowType = '[]
instance O.HasParentTypes ArrowType

foreign import ccall "gtk_arrow_type_get_type" c_gtk_arrow_type_get_type :: 
    IO GType

instance B.Types.TypedObject ArrowType where
    glibType = c_gtk_arrow_type_get_type

instance B.Types.BoxedEnum ArrowType

-- Enum Align
-- | Controls how a widget deals with extra space in a single dimension.
-- 
-- Alignment only matters if the widget receives a “too large” allocation,
-- for example if you packed the widget with the [Widget:hexpand]("GI.Gtk.Objects.Widget#g:attr:hexpand")
-- property inside a [class/@box@/], then the widget might get extra space.
-- If you have for example a 16x16 icon inside a 32x32 space, the icon
-- could be scaled and stretched, it could be centered, or it could be
-- positioned to one side of the space.
-- 
-- Note that in horizontal context @GTK_ALIGN_START@ and @GTK_ALIGN_END@
-- are interpreted relative to text direction.
-- 
-- Baseline support is optional for containers and widgets, and is only available
-- for vertical alignment. @GTK_ALIGN_BASELINE_CENTER@ and @GTK_ALIGN_BASELINE_FILL@
-- are treated similar to @GTK_ALIGN_CENTER@ and @GTK_ALIGN_FILL@, except that it
-- positions the widget to line up the baselines, where that is supported.
data Align = 
      AlignFill
    -- ^ stretch to fill all space if possible, center if
    --   no meaningful way to stretch
    | AlignStart
    -- ^ snap to left or top side, leaving space on right or bottom
    | AlignEnd
    -- ^ snap to right or bottom side, leaving space on left or top
    | AlignCenter
    -- ^ center natural width of widget inside the allocation
    | AlignBaselineFill
    -- ^ a different name for @GTK_ALIGN_BASELINE@.
    -- 
    -- /Since: 4.12/
    | AlignBaseline
    -- ^ align the widget according to the baseline.
    | AlignBaselineCenter
    -- ^ stretch to fill all space, but align the baseline.
    -- 
    -- /Since: 4.12/
    | AnotherAlign Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Align where
    fromEnum AlignFill = 0
    fromEnum AlignStart = 1
    fromEnum AlignEnd = 2
    fromEnum AlignCenter = 3
    fromEnum AlignBaselineFill = 4
    fromEnum AlignBaseline = 4
    fromEnum AlignBaselineCenter = 5
    fromEnum (AnotherAlign k) = k

    toEnum 0 = AlignFill
    toEnum 1 = AlignStart
    toEnum 2 = AlignEnd
    toEnum 3 = AlignCenter
    toEnum 4 = AlignBaselineFill
    toEnum 5 = AlignBaselineCenter
    toEnum k = AnotherAlign k

instance P.Ord Align where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Align = '[]
instance O.HasParentTypes Align

foreign import ccall "gtk_align_get_type" c_gtk_align_get_type :: 
    IO GType

instance B.Types.TypedObject Align where
    glibType = c_gtk_align_get_type

instance B.Types.BoxedEnum Align

-- Enum AccessibleTristate
-- | The possible values for the 'GI.Gtk.Enums.AccessibleStatePressed'
-- accessible state.
-- 
-- Note that the 'GI.Gtk.Enums.AccessibleTristateFalse' and
-- 'GI.Gtk.Enums.AccessibleTristateTrue' have the same values
-- as 'P.False' and 'P.True'.
data AccessibleTristate = 
      AccessibleTristateFalse
    -- ^ The state is @false@
    | AccessibleTristateTrue
    -- ^ The state is @true@
    | AccessibleTristateMixed
    -- ^ The state is @mixed@
    | AnotherAccessibleTristate Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleTristate where
    fromEnum AccessibleTristateFalse = 0
    fromEnum AccessibleTristateTrue = 1
    fromEnum AccessibleTristateMixed = 2
    fromEnum (AnotherAccessibleTristate k) = k

    toEnum 0 = AccessibleTristateFalse
    toEnum 1 = AccessibleTristateTrue
    toEnum 2 = AccessibleTristateMixed
    toEnum k = AnotherAccessibleTristate k

instance P.Ord AccessibleTristate where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleTristate = '[]
instance O.HasParentTypes AccessibleTristate

foreign import ccall "gtk_accessible_tristate_get_type" c_gtk_accessible_tristate_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleTristate where
    glibType = c_gtk_accessible_tristate_get_type

instance B.Types.BoxedEnum AccessibleTristate

-- Enum AccessibleTextGranularity
-- | The granularity for queries about the text contents of a t'GI.Gtk.Interfaces.AccessibleText.AccessibleText'
-- implementation.
-- 
-- /Since: 4.14/
data AccessibleTextGranularity = 
      AccessibleTextGranularityCharacter
    -- ^ Use the boundary between
    --   characters (including non-printing characters)
    | AccessibleTextGranularityWord
    -- ^ Use the boundary between words,
    --   starting from the beginning of the current word and ending at the
    --   beginning of the next word
    | AccessibleTextGranularitySentence
    -- ^ Use the boundary between
    --   sentences, starting from the beginning of the current sentence and
    --   ending at the beginning of the next sentence
    | AccessibleTextGranularityLine
    -- ^ Use the boundary between lines,
    --   starting from the beginning of the current line and ending at the
    --   beginning of the next line
    | AccessibleTextGranularityParagraph
    -- ^ Use the boundary between
    --   paragraphs, starting from the beginning of the current paragraph and
    --   ending at the beginning of the next paragraph
    | AnotherAccessibleTextGranularity Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleTextGranularity where
    fromEnum AccessibleTextGranularityCharacter = 0
    fromEnum AccessibleTextGranularityWord = 1
    fromEnum AccessibleTextGranularitySentence = 2
    fromEnum AccessibleTextGranularityLine = 3
    fromEnum AccessibleTextGranularityParagraph = 4
    fromEnum (AnotherAccessibleTextGranularity k) = k

    toEnum 0 = AccessibleTextGranularityCharacter
    toEnum 1 = AccessibleTextGranularityWord
    toEnum 2 = AccessibleTextGranularitySentence
    toEnum 3 = AccessibleTextGranularityLine
    toEnum 4 = AccessibleTextGranularityParagraph
    toEnum k = AnotherAccessibleTextGranularity k

instance P.Ord AccessibleTextGranularity where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleTextGranularity = '[]
instance O.HasParentTypes AccessibleTextGranularity

foreign import ccall "gtk_accessible_text_granularity_get_type" c_gtk_accessible_text_granularity_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleTextGranularity where
    glibType = c_gtk_accessible_text_granularity_get_type

instance B.Types.BoxedEnum AccessibleTextGranularity

-- Enum AccessibleTextContentChange
-- | The type of contents change operation.
-- 
-- /Since: 4.14/
data AccessibleTextContentChange = 
      AccessibleTextContentChangeInsert
    -- ^ contents change as the result of
    --   an insert operation
    | AccessibleTextContentChangeRemove
    -- ^ contents change as the result of
    --   a remove operation
    | AnotherAccessibleTextContentChange Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleTextContentChange where
    fromEnum AccessibleTextContentChangeInsert = 0
    fromEnum AccessibleTextContentChangeRemove = 1
    fromEnum (AnotherAccessibleTextContentChange k) = k

    toEnum 0 = AccessibleTextContentChangeInsert
    toEnum 1 = AccessibleTextContentChangeRemove
    toEnum k = AnotherAccessibleTextContentChange k

instance P.Ord AccessibleTextContentChange where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleTextContentChange = '[]
instance O.HasParentTypes AccessibleTextContentChange

foreign import ccall "gtk_accessible_text_content_change_get_type" c_gtk_accessible_text_content_change_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleTextContentChange where
    glibType = c_gtk_accessible_text_content_change_get_type

instance B.Types.BoxedEnum AccessibleTextContentChange

-- Enum AccessibleState
-- | The possible accessible states of a [iface/@accessible@/].
data AccessibleState = 
      AccessibleStateBusy
    -- ^ A “busy” state. This state has boolean values
    | AccessibleStateChecked
    -- ^ A “checked” state; indicates the current
    --   state of a [class/@checkButton@/]. Value type: [enum/@accessibleTristate@/]
    | AccessibleStateDisabled
    -- ^ A “disabled” state; corresponds to the
    --   [property/@widget@/:sensitive] property. It indicates a UI element
    --   that is perceivable, but not editable or operable. Value type: boolean
    | AccessibleStateExpanded
    -- ^ An “expanded” state; corresponds to the
    --   [property/@expander@/:expanded] property. Value type: boolean
    --   or undefined
    | AccessibleStateHidden
    -- ^ A “hidden” state; corresponds to the
    --   [property/@widget@/:visible] property. You can use this state
    --   explicitly on UI elements that should not be exposed to an assistive
    --   technology. Value type: boolean
    --   See also: 'GI.Gtk.Enums.AccessibleStateDisabled'
    | AccessibleStateInvalid
    -- ^ An “invalid” state; set when a widget
    --   is showing an error. Value type: [enum/@accessibleInvalidState@/]
    | AccessibleStatePressed
    -- ^ A “pressed” state; indicates the current
    --   state of a [class/@toggleButton@/]. Value type: [enum/@accessibleTristate@/]
    --   enumeration
    | AccessibleStateSelected
    -- ^ A “selected” state; set when a widget
    --   is selected. Value type: boolean or undefined
    | AccessibleStateVisited
    -- ^ Indicates that a widget with the GTK_ACCESSIBLE_ROLE_LINK has been visited.
    -- Value type: boolean.
    -- 
    -- /Since: 4.12/
    | AnotherAccessibleState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleState where
    fromEnum AccessibleStateBusy = 0
    fromEnum AccessibleStateChecked = 1
    fromEnum AccessibleStateDisabled = 2
    fromEnum AccessibleStateExpanded = 3
    fromEnum AccessibleStateHidden = 4
    fromEnum AccessibleStateInvalid = 5
    fromEnum AccessibleStatePressed = 6
    fromEnum AccessibleStateSelected = 7
    fromEnum AccessibleStateVisited = 8
    fromEnum (AnotherAccessibleState k) = k

    toEnum 0 = AccessibleStateBusy
    toEnum 1 = AccessibleStateChecked
    toEnum 2 = AccessibleStateDisabled
    toEnum 3 = AccessibleStateExpanded
    toEnum 4 = AccessibleStateHidden
    toEnum 5 = AccessibleStateInvalid
    toEnum 6 = AccessibleStatePressed
    toEnum 7 = AccessibleStateSelected
    toEnum 8 = AccessibleStateVisited
    toEnum k = AnotherAccessibleState k

instance P.Ord AccessibleState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleState = '[]
instance O.HasParentTypes AccessibleState

foreign import ccall "gtk_accessible_state_get_type" c_gtk_accessible_state_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleState where
    glibType = c_gtk_accessible_state_get_type

instance B.Types.BoxedEnum AccessibleState

-- Enum AccessibleSort
-- | The possible values for the 'GI.Gtk.Enums.AccessiblePropertySort'
-- accessible property.
data AccessibleSort = 
      AccessibleSortNone
    -- ^ There is no defined sort applied to the column.
    | AccessibleSortAscending
    -- ^ Items are sorted in ascending order by this column.
    | AccessibleSortDescending
    -- ^ Items are sorted in descending order by this column.
    | AccessibleSortOther
    -- ^ A sort algorithm other than ascending or
    --    descending has been applied.
    | AnotherAccessibleSort Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleSort where
    fromEnum AccessibleSortNone = 0
    fromEnum AccessibleSortAscending = 1
    fromEnum AccessibleSortDescending = 2
    fromEnum AccessibleSortOther = 3
    fromEnum (AnotherAccessibleSort k) = k

    toEnum 0 = AccessibleSortNone
    toEnum 1 = AccessibleSortAscending
    toEnum 2 = AccessibleSortDescending
    toEnum 3 = AccessibleSortOther
    toEnum k = AnotherAccessibleSort k

instance P.Ord AccessibleSort where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleSort = '[]
instance O.HasParentTypes AccessibleSort

foreign import ccall "gtk_accessible_sort_get_type" c_gtk_accessible_sort_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleSort where
    glibType = c_gtk_accessible_sort_get_type

instance B.Types.BoxedEnum AccessibleSort

-- Enum AccessibleRole
-- | The accessible role for a [iface/@accessible@/] implementation.
-- 
-- Abstract roles are only used as part of the ontology; application
-- developers must not use abstract roles in their code.
data AccessibleRole = 
      AccessibleRoleAlert
    -- ^ An element with important, and usually
    --   time-sensitive, information
    | AccessibleRoleAlertDialog
    -- ^ A type of dialog that contains an
    --   alert message
    | AccessibleRoleBanner
    -- ^ Unused
    | AccessibleRoleButton
    -- ^ An input element that allows for
    --   user-triggered actions when clicked or pressed
    | AccessibleRoleCaption
    -- ^ Unused
    | AccessibleRoleCell
    -- ^ Unused
    | AccessibleRoleCheckbox
    -- ^ A checkable input element that has
    --   three possible values: @true@, @false@, or @mixed@
    | AccessibleRoleColumnHeader
    -- ^ A header in a columned list.
    | AccessibleRoleComboBox
    -- ^ An input that controls another element,
    --   such as a list or a grid, that can dynamically pop up to help the user
    --   set the value of the input
    | AccessibleRoleCommand
    -- ^ Abstract role.
    | AccessibleRoleComposite
    -- ^ Abstract role.
    | AccessibleRoleDialog
    -- ^ A dialog is a window that is designed to interrupt
    --   the current processing of an application in order to prompt the user to enter
    --   information or require a response.
    | AccessibleRoleDocument
    -- ^ Content that assistive technology users may want to
    --   browse in a reading mode.
    | AccessibleRoleFeed
    -- ^ Unused
    | AccessibleRoleForm
    -- ^ Unused
    | AccessibleRoleGeneric
    -- ^ A nameless container that has no semantic meaning
    --   of its own. This is the role that GTK uses by default for widgets.
    | AccessibleRoleGrid
    -- ^ A grid of items.
    | AccessibleRoleGridCell
    -- ^ An item in a grid or tree grid.
    | AccessibleRoleGroup
    -- ^ An element that groups multiple related widgets. GTK uses
    --   this role for various containers, like t'GI.Gtk.Objects.HeaderBar.HeaderBar' or t'GI.Gtk.Objects.Notebook.Notebook'.
    | AccessibleRoleHeading
    -- ^ Unused
    | AccessibleRoleImg
    -- ^ An image.
    | AccessibleRoleInput
    -- ^ Abstract role.
    | AccessibleRoleLabel
    -- ^ A visible name or caption for a user interface component.
    | AccessibleRoleLandmark
    -- ^ Abstract role.
    | AccessibleRoleLegend
    -- ^ Unused
    | AccessibleRoleLink
    -- ^ A clickable link.
    | AccessibleRoleList
    -- ^ A list of items.
    | AccessibleRoleListBox
    -- ^ Unused.
    | AccessibleRoleListItem
    -- ^ An item in a list.
    | AccessibleRoleLog
    -- ^ Unused
    | AccessibleRoleMain
    -- ^ Unused
    | AccessibleRoleMarquee
    -- ^ Unused
    | AccessibleRoleMath
    -- ^ Unused
    | AccessibleRoleMeter
    -- ^ An element that represents a value within a known range.
    | AccessibleRoleMenu
    -- ^ A menu.
    | AccessibleRoleMenuBar
    -- ^ A menubar.
    | AccessibleRoleMenuItem
    -- ^ An item in a menu.
    | AccessibleRoleMenuItemCheckbox
    -- ^ A check item in a menu.
    | AccessibleRoleMenuItemRadio
    -- ^ A radio item in a menu.
    | AccessibleRoleNavigation
    -- ^ Unused
    | AccessibleRoleNone
    -- ^ An element that is not represented to accessibility technologies.
    --   This role is synonymous to /@gTKACCESSIBLEROLEPRESENTATION@/.
    | AccessibleRoleNote
    -- ^ Unused
    | AccessibleRoleOption
    -- ^ Unused
    | AccessibleRolePresentation
    -- ^ An element that is not represented to accessibility technologies.
    --   This role is synonymous to /@gTKACCESSIBLEROLENONE@/.
    | AccessibleRoleProgressBar
    -- ^ An element that displays the progress
    --   status for tasks that take a long time.
    | AccessibleRoleRadio
    -- ^ A checkable input in a group of radio roles,
    --   only one of which can be checked at a time.
    | AccessibleRoleRadioGroup
    -- ^ Unused
    | AccessibleRoleRange
    -- ^ Abstract role.
    | AccessibleRoleRegion
    -- ^ Unused
    | AccessibleRoleRow
    -- ^ A row in a columned list.
    | AccessibleRoleRowGroup
    -- ^ Unused
    | AccessibleRoleRowHeader
    -- ^ Unused
    | AccessibleRoleScrollbar
    -- ^ A graphical object that controls the scrolling
    --   of content within a viewing area, regardless of whether the content is fully
    --   displayed within the viewing area.
    | AccessibleRoleSearch
    -- ^ Unused
    | AccessibleRoleSearchBox
    -- ^ A type of textbox intended for specifying
    --   search criteria.
    | AccessibleRoleSection
    -- ^ Abstract role.
    | AccessibleRoleSectionHead
    -- ^ Abstract role.
    | AccessibleRoleSelect
    -- ^ Abstract role.
    | AccessibleRoleSeparator
    -- ^ A divider that separates and distinguishes
    --   sections of content or groups of menuitems.
    | AccessibleRoleSlider
    -- ^ A user input where the user selects a value
    --   from within a given range.
    | AccessibleRoleSpinButton
    -- ^ A form of range that expects the user to
    --   select from among discrete choices.
    | AccessibleRoleStatus
    -- ^ Unused
    | AccessibleRoleStructure
    -- ^ Abstract role.
    | AccessibleRoleSwitch
    -- ^ A type of checkbox that represents on\/off values,
    --   as opposed to checked\/unchecked values.
    | AccessibleRoleTab
    -- ^ An item in a list of tab used for switching pages.
    | AccessibleRoleTable
    -- ^ Unused
    | AccessibleRoleTabList
    -- ^ A list of tabs for switching pages.
    | AccessibleRoleTabPanel
    -- ^ A page in a notebook or stack.
    | AccessibleRoleTextBox
    -- ^ A type of input that allows free-form text
    --   as its value.
    | AccessibleRoleTime
    -- ^ Unused
    | AccessibleRoleTimer
    -- ^ Unused
    | AccessibleRoleToolbar
    -- ^ Unused
    | AccessibleRoleTooltip
    -- ^ Unused
    | AccessibleRoleTree
    -- ^ Unused
    | AccessibleRoleTreeGrid
    -- ^ A treeview-like, columned list.
    | AccessibleRoleTreeItem
    -- ^ Unused
    | AccessibleRoleWidget
    -- ^ Abstract role for interactive components of a
    --   graphical user interface
    | AccessibleRoleWindow
    -- ^ Abstract role for windows.
    | AccessibleRoleToggleButton
    -- ^ A type of push button which stays pressed until depressed by a second
    -- activation.
    -- 
    -- /Since: 4.10/
    | AccessibleRoleApplication
    -- ^ A toplevel element of a graphical user interface.
    -- 
    -- This is the role that GTK uses by default for windows.
    -- 
    -- /Since: 4.12/
    | AccessibleRoleParagraph
    -- ^ A paragraph of content.
    -- 
    -- /Since: 4.14/
    | AccessibleRoleBlockQuote
    -- ^ A section of content that is quoted from another source.
    -- 
    -- /Since: 4.14/
    | AccessibleRoleArticle
    -- ^ A section of a page that consists of a composition that forms an independent
    -- part of a document, page, or site.
    -- 
    -- /Since: 4.14/
    | AccessibleRoleComment
    -- ^ A comment contains content expressing reaction to other content.
    -- 
    -- /Since: 4.14/
    | AccessibleRoleTerminal
    -- ^ A virtual terminal.
    -- 
    -- /Since: 4.14/
    | AnotherAccessibleRole Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleRole where
    fromEnum AccessibleRoleAlert = 0
    fromEnum AccessibleRoleAlertDialog = 1
    fromEnum AccessibleRoleBanner = 2
    fromEnum AccessibleRoleButton = 3
    fromEnum AccessibleRoleCaption = 4
    fromEnum AccessibleRoleCell = 5
    fromEnum AccessibleRoleCheckbox = 6
    fromEnum AccessibleRoleColumnHeader = 7
    fromEnum AccessibleRoleComboBox = 8
    fromEnum AccessibleRoleCommand = 9
    fromEnum AccessibleRoleComposite = 10
    fromEnum AccessibleRoleDialog = 11
    fromEnum AccessibleRoleDocument = 12
    fromEnum AccessibleRoleFeed = 13
    fromEnum AccessibleRoleForm = 14
    fromEnum AccessibleRoleGeneric = 15
    fromEnum AccessibleRoleGrid = 16
    fromEnum AccessibleRoleGridCell = 17
    fromEnum AccessibleRoleGroup = 18
    fromEnum AccessibleRoleHeading = 19
    fromEnum AccessibleRoleImg = 20
    fromEnum AccessibleRoleInput = 21
    fromEnum AccessibleRoleLabel = 22
    fromEnum AccessibleRoleLandmark = 23
    fromEnum AccessibleRoleLegend = 24
    fromEnum AccessibleRoleLink = 25
    fromEnum AccessibleRoleList = 26
    fromEnum AccessibleRoleListBox = 27
    fromEnum AccessibleRoleListItem = 28
    fromEnum AccessibleRoleLog = 29
    fromEnum AccessibleRoleMain = 30
    fromEnum AccessibleRoleMarquee = 31
    fromEnum AccessibleRoleMath = 32
    fromEnum AccessibleRoleMeter = 33
    fromEnum AccessibleRoleMenu = 34
    fromEnum AccessibleRoleMenuBar = 35
    fromEnum AccessibleRoleMenuItem = 36
    fromEnum AccessibleRoleMenuItemCheckbox = 37
    fromEnum AccessibleRoleMenuItemRadio = 38
    fromEnum AccessibleRoleNavigation = 39
    fromEnum AccessibleRoleNone = 40
    fromEnum AccessibleRoleNote = 41
    fromEnum AccessibleRoleOption = 42
    fromEnum AccessibleRolePresentation = 43
    fromEnum AccessibleRoleProgressBar = 44
    fromEnum AccessibleRoleRadio = 45
    fromEnum AccessibleRoleRadioGroup = 46
    fromEnum AccessibleRoleRange = 47
    fromEnum AccessibleRoleRegion = 48
    fromEnum AccessibleRoleRow = 49
    fromEnum AccessibleRoleRowGroup = 50
    fromEnum AccessibleRoleRowHeader = 51
    fromEnum AccessibleRoleScrollbar = 52
    fromEnum AccessibleRoleSearch = 53
    fromEnum AccessibleRoleSearchBox = 54
    fromEnum AccessibleRoleSection = 55
    fromEnum AccessibleRoleSectionHead = 56
    fromEnum AccessibleRoleSelect = 57
    fromEnum AccessibleRoleSeparator = 58
    fromEnum AccessibleRoleSlider = 59
    fromEnum AccessibleRoleSpinButton = 60
    fromEnum AccessibleRoleStatus = 61
    fromEnum AccessibleRoleStructure = 62
    fromEnum AccessibleRoleSwitch = 63
    fromEnum AccessibleRoleTab = 64
    fromEnum AccessibleRoleTable = 65
    fromEnum AccessibleRoleTabList = 66
    fromEnum AccessibleRoleTabPanel = 67
    fromEnum AccessibleRoleTextBox = 68
    fromEnum AccessibleRoleTime = 69
    fromEnum AccessibleRoleTimer = 70
    fromEnum AccessibleRoleToolbar = 71
    fromEnum AccessibleRoleTooltip = 72
    fromEnum AccessibleRoleTree = 73
    fromEnum AccessibleRoleTreeGrid = 74
    fromEnum AccessibleRoleTreeItem = 75
    fromEnum AccessibleRoleWidget = 76
    fromEnum AccessibleRoleWindow = 77
    fromEnum AccessibleRoleToggleButton = 78
    fromEnum AccessibleRoleApplication = 79
    fromEnum AccessibleRoleParagraph = 80
    fromEnum AccessibleRoleBlockQuote = 81
    fromEnum AccessibleRoleArticle = 82
    fromEnum AccessibleRoleComment = 83
    fromEnum AccessibleRoleTerminal = 84
    fromEnum (AnotherAccessibleRole k) = k

    toEnum 0 = AccessibleRoleAlert
    toEnum 1 = AccessibleRoleAlertDialog
    toEnum 2 = AccessibleRoleBanner
    toEnum 3 = AccessibleRoleButton
    toEnum 4 = AccessibleRoleCaption
    toEnum 5 = AccessibleRoleCell
    toEnum 6 = AccessibleRoleCheckbox
    toEnum 7 = AccessibleRoleColumnHeader
    toEnum 8 = AccessibleRoleComboBox
    toEnum 9 = AccessibleRoleCommand
    toEnum 10 = AccessibleRoleComposite
    toEnum 11 = AccessibleRoleDialog
    toEnum 12 = AccessibleRoleDocument
    toEnum 13 = AccessibleRoleFeed
    toEnum 14 = AccessibleRoleForm
    toEnum 15 = AccessibleRoleGeneric
    toEnum 16 = AccessibleRoleGrid
    toEnum 17 = AccessibleRoleGridCell
    toEnum 18 = AccessibleRoleGroup
    toEnum 19 = AccessibleRoleHeading
    toEnum 20 = AccessibleRoleImg
    toEnum 21 = AccessibleRoleInput
    toEnum 22 = AccessibleRoleLabel
    toEnum 23 = AccessibleRoleLandmark
    toEnum 24 = AccessibleRoleLegend
    toEnum 25 = AccessibleRoleLink
    toEnum 26 = AccessibleRoleList
    toEnum 27 = AccessibleRoleListBox
    toEnum 28 = AccessibleRoleListItem
    toEnum 29 = AccessibleRoleLog
    toEnum 30 = AccessibleRoleMain
    toEnum 31 = AccessibleRoleMarquee
    toEnum 32 = AccessibleRoleMath
    toEnum 33 = AccessibleRoleMeter
    toEnum 34 = AccessibleRoleMenu
    toEnum 35 = AccessibleRoleMenuBar
    toEnum 36 = AccessibleRoleMenuItem
    toEnum 37 = AccessibleRoleMenuItemCheckbox
    toEnum 38 = AccessibleRoleMenuItemRadio
    toEnum 39 = AccessibleRoleNavigation
    toEnum 40 = AccessibleRoleNone
    toEnum 41 = AccessibleRoleNote
    toEnum 42 = AccessibleRoleOption
    toEnum 43 = AccessibleRolePresentation
    toEnum 44 = AccessibleRoleProgressBar
    toEnum 45 = AccessibleRoleRadio
    toEnum 46 = AccessibleRoleRadioGroup
    toEnum 47 = AccessibleRoleRange
    toEnum 48 = AccessibleRoleRegion
    toEnum 49 = AccessibleRoleRow
    toEnum 50 = AccessibleRoleRowGroup
    toEnum 51 = AccessibleRoleRowHeader
    toEnum 52 = AccessibleRoleScrollbar
    toEnum 53 = AccessibleRoleSearch
    toEnum 54 = AccessibleRoleSearchBox
    toEnum 55 = AccessibleRoleSection
    toEnum 56 = AccessibleRoleSectionHead
    toEnum 57 = AccessibleRoleSelect
    toEnum 58 = AccessibleRoleSeparator
    toEnum 59 = AccessibleRoleSlider
    toEnum 60 = AccessibleRoleSpinButton
    toEnum 61 = AccessibleRoleStatus
    toEnum 62 = AccessibleRoleStructure
    toEnum 63 = AccessibleRoleSwitch
    toEnum 64 = AccessibleRoleTab
    toEnum 65 = AccessibleRoleTable
    toEnum 66 = AccessibleRoleTabList
    toEnum 67 = AccessibleRoleTabPanel
    toEnum 68 = AccessibleRoleTextBox
    toEnum 69 = AccessibleRoleTime
    toEnum 70 = AccessibleRoleTimer
    toEnum 71 = AccessibleRoleToolbar
    toEnum 72 = AccessibleRoleTooltip
    toEnum 73 = AccessibleRoleTree
    toEnum 74 = AccessibleRoleTreeGrid
    toEnum 75 = AccessibleRoleTreeItem
    toEnum 76 = AccessibleRoleWidget
    toEnum 77 = AccessibleRoleWindow
    toEnum 78 = AccessibleRoleToggleButton
    toEnum 79 = AccessibleRoleApplication
    toEnum 80 = AccessibleRoleParagraph
    toEnum 81 = AccessibleRoleBlockQuote
    toEnum 82 = AccessibleRoleArticle
    toEnum 83 = AccessibleRoleComment
    toEnum 84 = AccessibleRoleTerminal
    toEnum k = AnotherAccessibleRole k

instance P.Ord AccessibleRole where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleRole = '[]
instance O.HasParentTypes AccessibleRole

foreign import ccall "gtk_accessible_role_get_type" c_gtk_accessible_role_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleRole where
    glibType = c_gtk_accessible_role_get_type

instance B.Types.BoxedEnum AccessibleRole

-- Enum AccessibleRelation
-- | The possible accessible relations of a [iface/@accessible@/].
-- 
-- Accessible relations can be references to other widgets,
-- integers or strings.
data AccessibleRelation = 
      AccessibleRelationActiveDescendant
    -- ^ Identifies the currently active
    --    element when focus is on a composite widget, combobox, textbox, group,
    --    or application. Value type: reference
    | AccessibleRelationColCount
    -- ^ Defines the total number of columns
    --    in a table, grid, or treegrid. Value type: integer
    | AccessibleRelationColIndex
    -- ^ Defines an element\'s column index or
    --    position with respect to the total number of columns within a table,
    --    grid, or treegrid. Value type: integer
    | AccessibleRelationColIndexText
    -- ^ Defines a human readable text
    --   alternative of 'GI.Gtk.Enums.AccessibleRelationColIndex'. Value type: string
    | AccessibleRelationColSpan
    -- ^ Defines the number of columns spanned
    --   by a cell or gridcell within a table, grid, or treegrid. Value type: integer
    | AccessibleRelationControls
    -- ^ Identifies the element (or elements) whose
    --    contents or presence are controlled by the current element. Value type: reference
    | AccessibleRelationDescribedBy
    -- ^ Identifies the element (or elements)
    --    that describes the object. Value type: reference
    | AccessibleRelationDetails
    -- ^ Identifies the element (or elements) that
    --    provide additional information related to the object. Value type: reference
    | AccessibleRelationErrorMessage
    -- ^ Identifies the element (or elements) that
    --    provide an error message for an object. Value type: reference
    | AccessibleRelationFlowTo
    -- ^ Identifies the next element (or elements)
    --    in an alternate reading order of content which, at the user\'s discretion,
    --    allows assistive technology to override the general default of reading in
    --    document source order. Value type: reference
    | AccessibleRelationLabelledBy
    -- ^ Identifies the element (or elements)
    --    that labels the current element. Value type: reference
    | AccessibleRelationOwns
    -- ^ Identifies an element (or elements) in order
    --    to define a visual, functional, or contextual parent\/child relationship
    --    between elements where the widget hierarchy cannot be used to represent
    --    the relationship. Value type: reference
    | AccessibleRelationPosInSet
    -- ^ Defines an element\'s number or position
    --    in the current set of listitems or treeitems. Value type: integer
    | AccessibleRelationRowCount
    -- ^ Defines the total number of rows in a table,
    --    grid, or treegrid. Value type: integer
    | AccessibleRelationRowIndex
    -- ^ Defines an element\'s row index or position
    --    with respect to the total number of rows within a table, grid, or treegrid.
    --    Value type: integer
    | AccessibleRelationRowIndexText
    -- ^ Defines a human readable text
    --    alternative of 'GI.Gtk.Enums.AccessibleRelationRowIndex'. Value type: string
    | AccessibleRelationRowSpan
    -- ^ Defines the number of rows spanned by a
    --    cell or gridcell within a table, grid, or treegrid. Value type: integer
    | AccessibleRelationSetSize
    -- ^ Defines the number of items in the current
    --    set of listitems or treeitems. Value type: integer
    | AccessibleRelationLabelFor
    -- ^ Identifies the element (or elements) that are labeled by the
    -- current element. Value type: reference
    -- 
    -- This relation is managed by GTK and should not be set from application code.
    -- 
    -- /Since: 4.18/
    | AccessibleRelationDescriptionFor
    -- ^ Identifies the element (or elements) that are described by
    -- the current element. Value type: reference
    -- 
    -- This relation is managed by GTK and should not be set from application code.
    -- 
    -- /Since: 4.18/
    | AccessibleRelationControlledBy
    -- ^ Identifies the element (or elements) that the current
    -- element is controlled by. Value type: reference
    -- 
    -- This relation is managed by GTK and should not be set from application code.
    -- 
    -- /Since: 4.18/
    | AccessibleRelationDetailsFor
    -- ^ Identifies the element (or elements) for which the current
    -- element provides additional information. Value type: reference
    -- 
    -- This relation is managed by GTK and should not be set from application code.
    -- 
    -- /Since: 4.18/
    | AccessibleRelationErrorMessageFor
    -- ^ Identifies the element (or elements) for which the current
    -- element provides an error message. Value type: reference
    -- 
    -- This relation is managed by GTK and should not be set from application code.
    -- 
    -- /Since: 4.18/
    | AccessibleRelationFlowFrom
    -- ^ Identifies the previous element (or elements) in an alternate
    -- reading order of content which, at the user\'s discretion, allows
    -- assistive technology to override the general default of reading in
    -- document source order. Value type: reference
    -- 
    -- This relation is managed by GTK and should not be set from application code.
    -- 
    -- /Since: 4.18/
    | AnotherAccessibleRelation Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleRelation where
    fromEnum AccessibleRelationActiveDescendant = 0
    fromEnum AccessibleRelationColCount = 1
    fromEnum AccessibleRelationColIndex = 2
    fromEnum AccessibleRelationColIndexText = 3
    fromEnum AccessibleRelationColSpan = 4
    fromEnum AccessibleRelationControls = 5
    fromEnum AccessibleRelationDescribedBy = 6
    fromEnum AccessibleRelationDetails = 7
    fromEnum AccessibleRelationErrorMessage = 8
    fromEnum AccessibleRelationFlowTo = 9
    fromEnum AccessibleRelationLabelledBy = 10
    fromEnum AccessibleRelationOwns = 11
    fromEnum AccessibleRelationPosInSet = 12
    fromEnum AccessibleRelationRowCount = 13
    fromEnum AccessibleRelationRowIndex = 14
    fromEnum AccessibleRelationRowIndexText = 15
    fromEnum AccessibleRelationRowSpan = 16
    fromEnum AccessibleRelationSetSize = 17
    fromEnum AccessibleRelationLabelFor = 18
    fromEnum AccessibleRelationDescriptionFor = 19
    fromEnum AccessibleRelationControlledBy = 20
    fromEnum AccessibleRelationDetailsFor = 21
    fromEnum AccessibleRelationErrorMessageFor = 22
    fromEnum AccessibleRelationFlowFrom = 23
    fromEnum (AnotherAccessibleRelation k) = k

    toEnum 0 = AccessibleRelationActiveDescendant
    toEnum 1 = AccessibleRelationColCount
    toEnum 2 = AccessibleRelationColIndex
    toEnum 3 = AccessibleRelationColIndexText
    toEnum 4 = AccessibleRelationColSpan
    toEnum 5 = AccessibleRelationControls
    toEnum 6 = AccessibleRelationDescribedBy
    toEnum 7 = AccessibleRelationDetails
    toEnum 8 = AccessibleRelationErrorMessage
    toEnum 9 = AccessibleRelationFlowTo
    toEnum 10 = AccessibleRelationLabelledBy
    toEnum 11 = AccessibleRelationOwns
    toEnum 12 = AccessibleRelationPosInSet
    toEnum 13 = AccessibleRelationRowCount
    toEnum 14 = AccessibleRelationRowIndex
    toEnum 15 = AccessibleRelationRowIndexText
    toEnum 16 = AccessibleRelationRowSpan
    toEnum 17 = AccessibleRelationSetSize
    toEnum 18 = AccessibleRelationLabelFor
    toEnum 19 = AccessibleRelationDescriptionFor
    toEnum 20 = AccessibleRelationControlledBy
    toEnum 21 = AccessibleRelationDetailsFor
    toEnum 22 = AccessibleRelationErrorMessageFor
    toEnum 23 = AccessibleRelationFlowFrom
    toEnum k = AnotherAccessibleRelation k

instance P.Ord AccessibleRelation where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleRelation = '[]
instance O.HasParentTypes AccessibleRelation

foreign import ccall "gtk_accessible_relation_get_type" c_gtk_accessible_relation_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleRelation where
    glibType = c_gtk_accessible_relation_get_type

instance B.Types.BoxedEnum AccessibleRelation

-- Enum AccessibleProperty
-- | The possible accessible properties of a [iface/@accessible@/].
data AccessibleProperty = 
      AccessiblePropertyAutocomplete
    -- ^ Indicates whether inputting text
    --    could trigger display of one or more predictions of the user\'s intended
    --    value for a combobox, searchbox, or textbox and specifies how predictions
    --    would be presented if they were made. Value type: [enum/@accessibleAutocomplete@/]
    | AccessiblePropertyDescription
    -- ^ Defines a string value that describes
    --    or annotates the current element. Value type: string
    | AccessiblePropertyHasPopup
    -- ^ Indicates the availability and type of
    --    interactive popup element, such as menu or dialog, that can be triggered
    --    by an element.
    | AccessiblePropertyKeyShortcuts
    -- ^ Indicates keyboard shortcuts that an
    --    author has implemented to activate or give focus to an element. Value type:
    --    string. The format of the value is a space-separated list of shortcuts, with
    --    each shortcut consisting of one or more modifiers (@Control@, @Alt@ or @Shift@),
    --    followed by a non-modifier key, all separated by @+@.
    --    Examples: @F2@, @Alt-F@, @Control+Shift+N@
    | AccessiblePropertyLabel
    -- ^ Defines a string value that labels the current
    --    element. Value type: string
    | AccessiblePropertyLevel
    -- ^ Defines the hierarchical level of an element
    --    within a structure. Value type: integer
    | AccessiblePropertyModal
    -- ^ Indicates whether an element is modal when
    --    displayed. Value type: boolean
    | AccessiblePropertyMultiLine
    -- ^ Indicates whether a text box accepts
    --    multiple lines of input or only a single line. Value type: boolean
    | AccessiblePropertyMultiSelectable
    -- ^ Indicates that the user may select
    --    more than one item from the current selectable descendants. Value type:
    --    boolean
    | AccessiblePropertyOrientation
    -- ^ Indicates whether the element\'s
    --    orientation is horizontal, vertical, or unknown\/ambiguous. Value type:
    --    [enum/@orientation@/]
    | AccessiblePropertyPlaceholder
    -- ^ Defines a short hint (a word or short
    --    phrase) intended to aid the user with data entry when the control has no
    --    value. A hint could be a sample value or a brief description of the expected
    --    format. Value type: string
    | AccessiblePropertyReadOnly
    -- ^ Indicates that the element is not editable,
    --    but is otherwise operable. Value type: boolean
    | AccessiblePropertyRequired
    -- ^ Indicates that user input is required on
    --    the element before a form may be submitted. Value type: boolean
    | AccessiblePropertyRoleDescription
    -- ^ Defines a human-readable,
    --    author-localized description for the role of an element. Value type: string
    | AccessiblePropertySort
    -- ^ Indicates if items in a table or grid are
    --    sorted in ascending or descending order. Value type: [enum/@accessibleSort@/]
    | AccessiblePropertyValueMax
    -- ^ Defines the maximum allowed value for a
    --    range widget. Value type: double
    | AccessiblePropertyValueMin
    -- ^ Defines the minimum allowed value for a
    --    range widget. Value type: double
    | AccessiblePropertyValueNow
    -- ^ Defines the current value for a range widget.
    --    Value type: double
    | AccessiblePropertyValueText
    -- ^ Defines the human readable text alternative
    --    of 'GI.Gtk.Enums.AccessiblePropertyValueNow' for a range widget. Value type: string
    | AccessiblePropertyHelpText
    -- ^ Defines a string value that provides a description of non-standard keyboard
    -- interactions of the current element. Value type: string
    -- 
    -- /Since: 4.16/
    | AnotherAccessibleProperty Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleProperty where
    fromEnum AccessiblePropertyAutocomplete = 0
    fromEnum AccessiblePropertyDescription = 1
    fromEnum AccessiblePropertyHasPopup = 2
    fromEnum AccessiblePropertyKeyShortcuts = 3
    fromEnum AccessiblePropertyLabel = 4
    fromEnum AccessiblePropertyLevel = 5
    fromEnum AccessiblePropertyModal = 6
    fromEnum AccessiblePropertyMultiLine = 7
    fromEnum AccessiblePropertyMultiSelectable = 8
    fromEnum AccessiblePropertyOrientation = 9
    fromEnum AccessiblePropertyPlaceholder = 10
    fromEnum AccessiblePropertyReadOnly = 11
    fromEnum AccessiblePropertyRequired = 12
    fromEnum AccessiblePropertyRoleDescription = 13
    fromEnum AccessiblePropertySort = 14
    fromEnum AccessiblePropertyValueMax = 15
    fromEnum AccessiblePropertyValueMin = 16
    fromEnum AccessiblePropertyValueNow = 17
    fromEnum AccessiblePropertyValueText = 18
    fromEnum AccessiblePropertyHelpText = 19
    fromEnum (AnotherAccessibleProperty k) = k

    toEnum 0 = AccessiblePropertyAutocomplete
    toEnum 1 = AccessiblePropertyDescription
    toEnum 2 = AccessiblePropertyHasPopup
    toEnum 3 = AccessiblePropertyKeyShortcuts
    toEnum 4 = AccessiblePropertyLabel
    toEnum 5 = AccessiblePropertyLevel
    toEnum 6 = AccessiblePropertyModal
    toEnum 7 = AccessiblePropertyMultiLine
    toEnum 8 = AccessiblePropertyMultiSelectable
    toEnum 9 = AccessiblePropertyOrientation
    toEnum 10 = AccessiblePropertyPlaceholder
    toEnum 11 = AccessiblePropertyReadOnly
    toEnum 12 = AccessiblePropertyRequired
    toEnum 13 = AccessiblePropertyRoleDescription
    toEnum 14 = AccessiblePropertySort
    toEnum 15 = AccessiblePropertyValueMax
    toEnum 16 = AccessiblePropertyValueMin
    toEnum 17 = AccessiblePropertyValueNow
    toEnum 18 = AccessiblePropertyValueText
    toEnum 19 = AccessiblePropertyHelpText
    toEnum k = AnotherAccessibleProperty k

instance P.Ord AccessibleProperty where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleProperty = '[]
instance O.HasParentTypes AccessibleProperty

foreign import ccall "gtk_accessible_property_get_type" c_gtk_accessible_property_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleProperty where
    glibType = c_gtk_accessible_property_get_type

instance B.Types.BoxedEnum AccessibleProperty

-- Enum AccessiblePlatformState
-- | The various platform states which can be queried
-- using 'GI.Gtk.Interfaces.Accessible.accessibleGetPlatformState'.
-- 
-- /Since: 4.10/
data AccessiblePlatformState = 
      AccessiblePlatformStateFocusable
    -- ^ whether the accessible can be focused
    | AccessiblePlatformStateFocused
    -- ^ whether the accessible has focus
    | AccessiblePlatformStateActive
    -- ^ whether the accessible is active
    | AnotherAccessiblePlatformState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessiblePlatformState where
    fromEnum AccessiblePlatformStateFocusable = 0
    fromEnum AccessiblePlatformStateFocused = 1
    fromEnum AccessiblePlatformStateActive = 2
    fromEnum (AnotherAccessiblePlatformState k) = k

    toEnum 0 = AccessiblePlatformStateFocusable
    toEnum 1 = AccessiblePlatformStateFocused
    toEnum 2 = AccessiblePlatformStateActive
    toEnum k = AnotherAccessiblePlatformState k

instance P.Ord AccessiblePlatformState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessiblePlatformState = '[]
instance O.HasParentTypes AccessiblePlatformState

foreign import ccall "gtk_accessible_platform_state_get_type" c_gtk_accessible_platform_state_get_type :: 
    IO GType

instance B.Types.TypedObject AccessiblePlatformState where
    glibType = c_gtk_accessible_platform_state_get_type

instance B.Types.BoxedEnum AccessiblePlatformState

-- Enum AccessibleInvalidState
-- | The possible values for the 'GI.Gtk.Enums.AccessibleStateInvalid'
-- accessible state.
-- 
-- Note that the 'GI.Gtk.Enums.AccessibleInvalidStateFalse' and
-- 'GI.Gtk.Enums.AccessibleInvalidStateTrue' have the same values
-- as 'P.False' and 'P.True'.
data AccessibleInvalidState = 
      AccessibleInvalidStateFalse
    -- ^ There are no detected errors in the value
    | AccessibleInvalidStateTrue
    -- ^ The value entered by the user has failed validation
    | AccessibleInvalidStateGrammar
    -- ^ A grammatical error was detected
    | AccessibleInvalidStateSpelling
    -- ^ A spelling error was detected
    | AnotherAccessibleInvalidState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleInvalidState where
    fromEnum AccessibleInvalidStateFalse = 0
    fromEnum AccessibleInvalidStateTrue = 1
    fromEnum AccessibleInvalidStateGrammar = 2
    fromEnum AccessibleInvalidStateSpelling = 3
    fromEnum (AnotherAccessibleInvalidState k) = k

    toEnum 0 = AccessibleInvalidStateFalse
    toEnum 1 = AccessibleInvalidStateTrue
    toEnum 2 = AccessibleInvalidStateGrammar
    toEnum 3 = AccessibleInvalidStateSpelling
    toEnum k = AnotherAccessibleInvalidState k

instance P.Ord AccessibleInvalidState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleInvalidState = '[]
instance O.HasParentTypes AccessibleInvalidState

foreign import ccall "gtk_accessible_invalid_state_get_type" c_gtk_accessible_invalid_state_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleInvalidState where
    glibType = c_gtk_accessible_invalid_state_get_type

instance B.Types.BoxedEnum AccessibleInvalidState

-- Enum AccessibleAutocomplete
-- | The possible values for the 'GI.Gtk.Enums.AccessiblePropertyAutocomplete'
-- accessible property.
data AccessibleAutocomplete = 
      AccessibleAutocompleteNone
    -- ^ Automatic suggestions are not displayed.
    | AccessibleAutocompleteInline
    -- ^ When a user is providing input, text
    --    suggesting one way to complete the provided input may be dynamically
    --    inserted after the caret.
    | AccessibleAutocompleteList
    -- ^ When a user is providing input, an element
    --    containing a collection of values that could complete the provided input
    --    may be displayed.
    | AccessibleAutocompleteBoth
    -- ^ When a user is providing input, an element
    --    containing a collection of values that could complete the provided input
    --    may be displayed. If displayed, one value in the collection is automatically
    --    selected, and the text needed to complete the automatically selected value
    --    appears after the caret in the input.
    | AnotherAccessibleAutocomplete Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleAutocomplete where
    fromEnum AccessibleAutocompleteNone = 0
    fromEnum AccessibleAutocompleteInline = 1
    fromEnum AccessibleAutocompleteList = 2
    fromEnum AccessibleAutocompleteBoth = 3
    fromEnum (AnotherAccessibleAutocomplete k) = k

    toEnum 0 = AccessibleAutocompleteNone
    toEnum 1 = AccessibleAutocompleteInline
    toEnum 2 = AccessibleAutocompleteList
    toEnum 3 = AccessibleAutocompleteBoth
    toEnum k = AnotherAccessibleAutocomplete k

instance P.Ord AccessibleAutocomplete where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleAutocomplete = '[]
instance O.HasParentTypes AccessibleAutocomplete

foreign import ccall "gtk_accessible_autocomplete_get_type" c_gtk_accessible_autocomplete_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleAutocomplete where
    glibType = c_gtk_accessible_autocomplete_get_type

instance B.Types.BoxedEnum AccessibleAutocomplete

-- Enum AccessibleAnnouncementPriority
-- | The priority of an accessibility announcement.
-- 
-- /Since: 4.14/
data AccessibleAnnouncementPriority = 
      AccessibleAnnouncementPriorityLow
    -- ^ The announcement is low priority,
    --   and might be read only on the user\'s request.
    | AccessibleAnnouncementPriorityMedium
    -- ^ The announcement is of medium
    --   priority, and is usually spoken at the next opportunity, such as at the
    --   end of speaking the current sentence or when the user pauses typing.
    | AccessibleAnnouncementPriorityHigh
    -- ^ The announcement is of high
    --   priority, and is usually spoken immediately. Because an interruption
    --   might disorient users or cause them to not complete their current task,
    --   authors SHOULD NOT use high priority announcements unless the
    --   interruption is imperative. An example would be a notification about a
    --   critical battery power level.
    | AnotherAccessibleAnnouncementPriority Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AccessibleAnnouncementPriority where
    fromEnum AccessibleAnnouncementPriorityLow = 0
    fromEnum AccessibleAnnouncementPriorityMedium = 1
    fromEnum AccessibleAnnouncementPriorityHigh = 2
    fromEnum (AnotherAccessibleAnnouncementPriority k) = k

    toEnum 0 = AccessibleAnnouncementPriorityLow
    toEnum 1 = AccessibleAnnouncementPriorityMedium
    toEnum 2 = AccessibleAnnouncementPriorityHigh
    toEnum k = AnotherAccessibleAnnouncementPriority k

instance P.Ord AccessibleAnnouncementPriority where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AccessibleAnnouncementPriority = '[]
instance O.HasParentTypes AccessibleAnnouncementPriority

foreign import ccall "gtk_accessible_announcement_priority_get_type" c_gtk_accessible_announcement_priority_get_type :: 
    IO GType

instance B.Types.TypedObject AccessibleAnnouncementPriority where
    glibType = c_gtk_accessible_announcement_priority_get_type

instance B.Types.BoxedEnum AccessibleAnnouncementPriority


