{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Base type for snapshot operations.
-- 
-- The subclass of @GdkSnapshot@ used by GTK is <http://developer.gnome.org/gdk/stable/../gtk4/class.Snapshot.html GtkSnapshot>.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Snapshot
    ( 

-- * Exported types
    Snapshot(..)                            ,
    IsSnapshot                              ,
    toSnapshot                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSnapshotMethod                   ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Snapshot = Snapshot (SP.ManagedPtr Snapshot)
    deriving (Eq)

instance SP.ManagedPtrNewtype Snapshot where
    toManagedPtr (Snapshot p) = p

foreign import ccall "gdk_snapshot_get_type"
    c_gdk_snapshot_get_type :: IO B.Types.GType

instance B.Types.TypedObject Snapshot where
    glibType = c_gdk_snapshot_get_type

instance B.Types.GObject Snapshot

-- | Type class for types which can be safely cast to t'Snapshot', for instance with `toSnapshot`.
class (SP.GObject o, O.IsDescendantOf Snapshot o) => IsSnapshot o
instance (SP.GObject o, O.IsDescendantOf Snapshot o) => IsSnapshot o

instance O.HasParentTypes Snapshot
type instance O.ParentTypes Snapshot = '[GObject.Object.Object]

-- | Cast to t'Snapshot', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSnapshot :: (MIO.MonadIO m, IsSnapshot o) => o -> m Snapshot
toSnapshot = MIO.liftIO . B.ManagedPtr.unsafeCastTo Snapshot

-- | Convert t'Snapshot' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Snapshot) where
    gvalueGType_ = c_gdk_snapshot_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Snapshot)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Snapshot)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Snapshot ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSnapshotMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSnapshotMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSnapshotMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSnapshotMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSnapshotMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSnapshotMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSnapshotMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSnapshotMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSnapshotMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSnapshotMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSnapshotMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSnapshotMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSnapshotMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSnapshotMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSnapshotMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSnapshotMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSnapshotMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSnapshotMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSnapshotMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSnapshotMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSnapshotMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSnapshotMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSnapshotMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSnapshotMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSnapshotMethod t Snapshot, O.OverloadedMethod info Snapshot p) => OL.IsLabel t (Snapshot -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSnapshotMethod t Snapshot, O.OverloadedMethod info Snapshot p, R.HasField t Snapshot p) => R.HasField t Snapshot p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSnapshotMethod t Snapshot, O.OverloadedMethodInfo info Snapshot) => OL.IsLabel t (O.MethodProxy info Snapshot) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Snapshot
type instance O.AttributeList Snapshot = SnapshotAttributeList
type SnapshotAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Snapshot = SnapshotSignalList
type SnapshotSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


