/* do not edit automatically generated by mc from M2StackWord.  */
/* M2StackWord.mod provides a generic stack for WORD sized objects.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2StackWord_C

#include "GM2StackWord.h"
#   include "GStorage.h"
#   include "GM2Error.h"
#   include "GM2Debug.h"

#   define MaxBucket 10
typedef struct M2StackWord_BucketWord_r M2StackWord_BucketWord;

typedef struct M2StackWord_StackDescriptor_r M2StackWord_StackDescriptor;

typedef struct M2StackWord__T1_a M2StackWord__T1;

typedef M2StackWord_BucketWord *M2StackWord_StackBucketWord;

typedef M2StackWord_StackDescriptor *M2StackWord_StackOfWord__opaque;

struct M2StackWord_StackDescriptor_r {
                                       M2StackWord_StackBucketWord tail;
                                     };

struct M2StackWord__T1_a { unsigned int array[(MaxBucket-1)+1]; };
struct M2StackWord_BucketWord_r {
                                  M2StackWord__T1 bucket;
                                  unsigned int items;
                                  M2StackWord_StackBucketWord last;
                                };


/*
   InitStackWord - creates and returns a new stack.
*/

extern "C" M2StackWord_StackOfWord M2StackWord_InitStackWord (void);

/*
   KillStackWord - destroys a stack, returning NIL.
*/

extern "C" M2StackWord_StackOfWord M2StackWord_KillStackWord (M2StackWord_StackOfWord s);

/*
   PushWord - pushes a word, w, onto, s.
*/

extern "C" void M2StackWord_PushWord (M2StackWord_StackOfWord s, unsigned int w);

/*
   PopWord - pops an element from stack, s.
*/

extern "C" unsigned int M2StackWord_PopWord (M2StackWord_StackOfWord s);

/*
   IsEmptyWord - returns TRUE if stack, s, is empty.
*/

extern "C" bool M2StackWord_IsEmptyWord (M2StackWord_StackOfWord s);

/*
   PeepWord - returns the element at, n, items below in the stack.
              Top of stack can be seen via Peep(s, 1)
*/

extern "C" unsigned int M2StackWord_PeepWord (M2StackWord_StackOfWord s, unsigned int n);

/*
   ReduceWord - reduce the stack by n elements.
*/

extern "C" void M2StackWord_ReduceWord (M2StackWord_StackOfWord s, unsigned int n);

/*
   RemoveTop - throw away the top element of the stack.
*/

extern "C" void M2StackWord_RemoveTop (M2StackWord_StackOfWord s);

/*
   NoOfItemsInStackWord - returns the number of items held in the stack, s.
*/

extern "C" unsigned int M2StackWord_NoOfItemsInStackWord (M2StackWord_StackOfWord s);

/*
   KillBucket - destroys a StackBucketWord and returns, NIL.
*/

static M2StackWord_StackBucketWord KillBucket (M2StackWord_StackBucketWord b);

/*
   InitBucket - returns an empty StackBucketWord.
*/

static M2StackWord_StackBucketWord InitBucket (M2StackWord_StackBucketWord l);


/*
   KillBucket - destroys a StackBucketWord and returns, NIL.
*/

static M2StackWord_StackBucketWord KillBucket (M2StackWord_StackBucketWord b)
{
  if (b != NULL)
    {
      b = KillBucket (b->last);
      Storage_DEALLOCATE ((void **) &b, sizeof (M2StackWord_BucketWord));
    }
  return NULL;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitBucket - returns an empty StackBucketWord.
*/

static M2StackWord_StackBucketWord InitBucket (M2StackWord_StackBucketWord l)
{
  M2StackWord_StackBucketWord b;

  Storage_ALLOCATE ((void **) &b, sizeof (M2StackWord_BucketWord));
  b->items = 0;
  b->last = l;
  return b;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitStackWord - creates and returns a new stack.
*/

extern "C" M2StackWord_StackOfWord M2StackWord_InitStackWord (void)
{
  M2StackWord_StackOfWord__opaque s;

  Storage_ALLOCATE ((void **) &s, sizeof (M2StackWord_StackDescriptor));
  s->tail = NULL;
  return static_cast<M2StackWord_StackOfWord> (s);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillStackWord - destroys a stack, returning NIL.
*/

extern "C" M2StackWord_StackOfWord M2StackWord_KillStackWord (M2StackWord_StackOfWord s)
{
  if (s != NULL)
    {
      static_cast<M2StackWord_StackOfWord__opaque> (s)->tail = KillBucket (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail);
      Storage_DEALLOCATE ((void **) &s, sizeof (M2StackWord_StackDescriptor));
    }
  return static_cast<M2StackWord_StackOfWord> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushWord - pushes a word, w, onto, s.
*/

extern "C" void M2StackWord_PushWord (M2StackWord_StackOfWord s, unsigned int w)
{
  if (s == NULL)
    {
      M2Error_InternalError ((const char *) "stack has not been initialized", 30);
    }
  else
    {
      if ((static_cast<M2StackWord_StackOfWord__opaque> (s)->tail == NULL) || (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items == MaxBucket))
        {
          static_cast<M2StackWord_StackOfWord__opaque> (s)->tail = InitBucket (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail);
        }
      if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items < MaxBucket)
        {
          static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->bucket.array[static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items] = w;
          static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items += 1;
        }
    }
}


/*
   PopWord - pops an element from stack, s.
*/

extern "C" unsigned int M2StackWord_PopWord (M2StackWord_StackOfWord s)
{
  M2StackWord_StackBucketWord b;

  if (s == NULL)
    {
      M2Error_InternalError ((const char *) "stack has not been initialized", 30);
    }
  else
    {
      if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail == NULL)
        {
          M2Error_InternalError ((const char *) "stack underflow", 15);
        }
      else
        {
          if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items == 0)
            {
              b = static_cast<M2StackWord_StackOfWord__opaque> (s)->tail;
              if (b == NULL)
                {
                  M2Error_InternalError ((const char *) "stack underflow", 15);
                }
              else
                {
                  static_cast<M2StackWord_StackOfWord__opaque> (s)->tail = b->last;
                }
              Storage_DEALLOCATE ((void **) &b, sizeof (M2StackWord_BucketWord));
            }
          static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items -= 1;
          return static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->bucket.array[static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items];
        }
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2StackWord.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsEmptyWord - returns TRUE if stack, s, is empty.
*/

extern "C" bool M2StackWord_IsEmptyWord (M2StackWord_StackOfWord s)
{
  return (s == NULL) || (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail == NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PeepWord - returns the element at, n, items below in the stack.
              Top of stack can be seen via Peep(s, 1)
*/

extern "C" unsigned int M2StackWord_PeepWord (M2StackWord_StackOfWord s, unsigned int n)
{
  M2StackWord_StackBucketWord b;

  if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail == NULL)
    {
      M2Error_InternalError ((const char *) "stack underflow", 15);
    }
  else
    {
      if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items == 0)
        {
          b = static_cast<M2StackWord_StackOfWord__opaque> (s)->tail;
          if (b == NULL)
            {
              M2Error_InternalError ((const char *) "stack underflow", 15);
            }
          else
            {
              static_cast<M2StackWord_StackOfWord__opaque> (s)->tail = b->last;
            }
          Storage_DEALLOCATE ((void **) &b, sizeof (M2StackWord_BucketWord));
        }
      b = static_cast<M2StackWord_StackOfWord__opaque> (s)->tail;
      while (n >= 1)
        {
          if (b == NULL)
            {
              M2Error_InternalError ((const char *) "stack underflow", 15);
            }
          else if (b->items >= n)
            {
              /* avoid dangling else.  */
              return b->bucket.array[b->items-n];
            }
          else
            {
              /* avoid dangling else.  */
              M2Debug_Assert (b->items < n);
              n -= b->items;
              b = b->last;
            }
        }
      M2Error_InternalError ((const char *) "stack underflow", 15);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2StackWord.def", 20, 1);
  __builtin_unreachable ();
}


/*
   ReduceWord - reduce the stack by n elements.
*/

extern "C" void M2StackWord_ReduceWord (M2StackWord_StackOfWord s, unsigned int n)
{
  M2StackWord_StackBucketWord b;

  if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail == NULL)
    {
      M2Error_InternalError ((const char *) "stack underflow", 15);
    }
  else
    {
      if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items == 0)
        {
          b = static_cast<M2StackWord_StackOfWord__opaque> (s)->tail;
          if (b == NULL)
            {
              M2Error_InternalError ((const char *) "stack underflow", 15);
            }
          else
            {
              static_cast<M2StackWord_StackOfWord__opaque> (s)->tail = b->last;
            }
          Storage_DEALLOCATE ((void **) &b, sizeof (M2StackWord_BucketWord));
        }
      for (;;)
      {
        if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail == NULL)
          {
            M2Error_InternalError ((const char *) "stack underflow", 15);
          }
        else if (static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items >= n)
          {
            /* avoid dangling else.  */
            static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->items -= n;
            return;  /* all done exit  */
          }
        else
          {
            /* avoid dangling else.  */
            b = static_cast<M2StackWord_StackOfWord__opaque> (s)->tail;
            n -= b->items;
            static_cast<M2StackWord_StackOfWord__opaque> (s)->tail = static_cast<M2StackWord_StackOfWord__opaque> (s)->tail->last;
            Storage_DEALLOCATE ((void **) &b, sizeof (M2StackWord_BucketWord));
          }
      }
    }
}


/*
   RemoveTop - throw away the top element of the stack.
*/

extern "C" void M2StackWord_RemoveTop (M2StackWord_StackOfWord s)
{
  M2StackWord_ReduceWord (s, 1);
}


/*
   NoOfItemsInStackWord - returns the number of items held in the stack, s.
*/

extern "C" unsigned int M2StackWord_NoOfItemsInStackWord (M2StackWord_StackOfWord s)
{
  M2StackWord_StackBucketWord b;
  unsigned int n;

  if (M2StackWord_IsEmptyWord (s))
    {
      return 0;
    }
  else
    {
      n = 0;
      b = static_cast<M2StackWord_StackOfWord__opaque> (s)->tail;
      while (b != NULL)
        {
          n += b->items;
          b = b->last;
        }
      return n;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2StackWord_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2StackWord_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
