/* do not edit automatically generated by mc from M2Scaffold.  */
/* M2Scaffold.mod declare and create scaffold entities.

Copyright (C) 2022-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Scaffold_C

#include "GM2Scaffold.h"
#   include "GSymbolTable.h"
#   include "GNameKey.h"
#   include "GM2Base.h"
#   include "GM2System.h"
#   include "GM2LexBuf.h"
#   include "GAssertion.h"
#   include "GLists.h"
#   include "GM2MetaError.h"
#   include "GM2Search.h"
#   include "GSFIO.h"
#   include "GFIO.h"
#   include "GFormatStrings.h"
#   include "GM2Options.h"
#   include "GM2Quads.h"
#   include "GM2Batch.h"
#   include "GM2Printf.h"
#   include "GDynamicStrings.h"
#   include "GM2Graph.h"

#   define Comment '#'
#   define Debugging false
static Lists_List uselistModules;
static Lists_List ctorModules;
static Lists_List ctorGlobals;
static unsigned int ctorArrayType;
static bool initialized;
static unsigned int ctorTok;

/*
   DeclareScaffold - declare scaffold related entities.
*/

extern "C" void M2Scaffold_DeclareScaffold (unsigned int tokno);

/*
   DeclareArgEnvParams - declares (int argc, void *argv, void *envp)
*/

extern "C" void M2Scaffold_DeclareArgEnvParams (unsigned int tokno, unsigned int proc);

/*
   PopulateCtorArray - assign each element of the ctorArray to the external module ctor.
                       This is only used to force the linker to pull in the ctors from
                       a library.
*/

extern "C" void M2Scaffold_PopulateCtorArray (unsigned int tok);

/*
   ForeachModuleCallInit - is only called when -fscaffold-static is enabled.
                           precondition: the module list will be ordered.
                           postcondition: foreach module in the application universe
                                             call _M2_module_init (argc, argv, envp);
*/

extern "C" void M2Scaffold_ForeachModuleCallInit (unsigned int tok, unsigned int argc, unsigned int argv, unsigned int envp);

/*
   ForeachModuleCallFinish - precondition: the module list will be ordered.
                             postcondition: foreach module in the application universe
                                               call _M2_module_fini (argc, argv, envp);
*/

extern "C" void M2Scaffold_ForeachModuleCallFinish (unsigned int tok, unsigned int argc, unsigned int argv, unsigned int envp);

/*
   DeclareCtorArrayType - declare an ARRAY [0..high] OF PROC which will
                          be used to reference every module ctor.
*/

static unsigned int DeclareCtorArrayType (unsigned int tokenno, unsigned int high);

/*
   DeclareCtorGlobal - declare the ctorArray variable.
*/

static void DeclareCtorGlobal (unsigned int tokenno);

/*
   LookupModuleSym - returns a defimp module.  It looks up an existing
                     module and if this does not exist creates a new one.
*/

static unsigned int LookupModuleSym (unsigned int tok, NameKey_Name name);

/*
   addDependentStatement -
*/

static void addDependentStatement (M2Graph_Graph graph, unsigned int moduleSym, Lists_List list);

/*
   addDependentImport - adds dependent imports of moduleSym into the graph.
*/

static void addDependentImport (M2Graph_Graph graph, unsigned int moduleSym, Lists_List importList);

/*
   TopologicallySortList - topologically sort the list based on import graph.
                           A new list is returned.
*/

static Lists_List TopologicallySortList (Lists_List list, unsigned int topModule);

/*
   AddEntry - adds an entry to the ctorGlobals and uselistModules.
*/

static void AddEntry (unsigned int tok, NameKey_Name name);

/*
   ReadModules - populate ctorGlobals with the modules specified by -fuse-list=filename.
*/

static void ReadModules (unsigned int tok, DynamicStrings_String filename);

/*
   AddModuleToCtor - adds moduleSym to the uselistModules and
                     sets all modules ctors as extern.
*/

static void AddModuleToCtor (unsigned int moduleSym);

/*
   WriteList - writes the list to GetGenModuleFilename
               providing the filename is not NIL and not '-'.
*/

static void WriteList (unsigned int tok, Lists_List list);

/*
   CreateCtorListFromImports - if GenModuleList then populate
                               the ctor list from all modules which are
                               not FOR 'C'.
*/

static bool CreateCtorListFromImports (unsigned int tok);

/*
   CreateCtorList - uses GetUselistFilename and then reads the list of modules.
*/

static bool CreateCtorList (unsigned int tok);

/*
   DeclareModuleExtern - declare the extern _M2_modulename_ctor, _M2_modulename_init,
                         _M2_modulename_fini, _M2_modulename_dep for each external module.
*/

static void DeclareModuleExtern (unsigned int tokenno);

/*
   DeclareScaffoldFunctions - declare main, _M2_init,_M2_finish
                              and _M2_link to the modula-2
                              front end.
*/

static void DeclareScaffoldFunctions (unsigned int tokenno);


/*
   DeclareCtorArrayType - declare an ARRAY [0..high] OF PROC which will
                          be used to reference every module ctor.
*/

static unsigned int DeclareCtorArrayType (unsigned int tokenno, unsigned int high)
{
  unsigned int subscript;
  unsigned int subrange;

  /* ctorArrayType = ARRAY [0..n] OF PROC ;  */
  ctorArrayType = SymbolTable_MakeArray (tokenno, NameKey_MakeKey ((const char *) "ctorGlobalType", 14));
  SymbolTable_PutArray (ctorArrayType, M2Base_Proc);
  subrange = SymbolTable_MakeSubrange (tokenno, NameKey_NulName);
  SymbolTable_PutSubrange (subrange, SymbolTable_MakeConstant (tokenno, 0), SymbolTable_MakeConstant (tokenno, high), M2Base_Cardinal);
  subscript = SymbolTable_MakeSubscript ();
  SymbolTable_PutSubscript (subscript, subrange);
  SymbolTable_PutArraySubscript (ctorArrayType, subscript);
  return ctorArrayType;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareCtorGlobal - declare the ctorArray variable.
*/

static void DeclareCtorGlobal (unsigned int tokenno)
{
  unsigned int n;

  n = Lists_NoOfItemsInList (ctorGlobals);
  ctorArrayType = DeclareCtorArrayType (tokenno, n);
  M2Scaffold_ctorArray = SymbolTable_MakeVar (tokenno, NameKey_MakeKey ((const char *) "_M2_ctorArray", 13));
  SymbolTable_PutVar (M2Scaffold_ctorArray, ctorArrayType);
}


/*
   LookupModuleSym - returns a defimp module.  It looks up an existing
                     module and if this does not exist creates a new one.
*/

static unsigned int LookupModuleSym (unsigned int tok, NameKey_Name name)
{
  unsigned int sym;
  DynamicStrings_String FileName;
  DynamicStrings_String LibName;

  sym = M2Batch_Get (name);
  if (sym == SymbolTable_NulSym)
    {
      LibName = static_cast<DynamicStrings_String> (NULL);
      FileName = static_cast<DynamicStrings_String> (NULL);
      if (M2Search_FindSourceDefFile (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name)), &FileName, &LibName))
        {
          /* avoid dangling else.  */
          sym = SymbolTable_MakeDefImp (tok, name);
          SymbolTable_PutLibName (sym, NameKey_makekey (DynamicStrings_string (LibName)));
          if (sym != (SymbolTable_GetMainModule ()))
            {
              SymbolTable_PutModuleCtorExtern (tok, sym, ! M2Options_WholeProgram);
            }
        }
      else
        {
          M2MetaError_MetaErrorStringT0 (tok, FormatStrings_Sprintf1 (DynamicStrings_InitString ((const char *) "the definition module file for {%%1a} cannot be found", 53), (const unsigned char *) &name, (sizeof (name)-1)));
        }
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   addDependentStatement -
*/

static void addDependentStatement (M2Graph_Graph graph, unsigned int moduleSym, Lists_List list)
{
  NameKey_Name n1;
  NameKey_Name n2;
  unsigned int import;
  unsigned int depmod;
  unsigned int i;
  unsigned int n;

  n = Lists_NoOfItemsInList (list);
  i = 1;
  while (i <= n)
    {
      import = static_cast<unsigned int> (Lists_GetItemFromList (list, i));
      Assertion_Assert (SymbolTable_IsImport (import));
      depmod = SymbolTable_GetImportModule (import);
      M2Graph_AddDependent (graph, moduleSym, depmod);
      if (Debugging)
        {
          n1 = SymbolTable_GetSymName (moduleSym);
          n2 = SymbolTable_GetSymName (depmod);
          M2Printf_printf2 ((const char *) "AddDependent (%a, %a)\\n", 23, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
        }
      i += 1;
    }
}


/*
   addDependentImport - adds dependent imports of moduleSym into the graph.
*/

static void addDependentImport (M2Graph_Graph graph, unsigned int moduleSym, Lists_List importList)
{
  unsigned int stmt;
  unsigned int i;
  unsigned int n;

  n = Lists_NoOfItemsInList (importList);
  i = 1;
  while (i <= n)
    {
      stmt = static_cast<unsigned int> (Lists_GetItemFromList (importList, i));
      Assertion_Assert (SymbolTable_IsImportStatement (stmt));
      addDependentStatement (graph, moduleSym, SymbolTable_GetImportStatementList (stmt));
      i += 1;
    }
}


/*
   TopologicallySortList - topologically sort the list based on import graph.
                           A new list is returned.
*/

static Lists_List TopologicallySortList (Lists_List list, unsigned int topModule)
{
  M2Graph_Graph graph;
  unsigned int i;
  unsigned int n;
  unsigned int moduleSym;

  graph = M2Graph_InitGraph ();
  n = Lists_NoOfItemsInList (list);
  i = 1;
  while (i <= n)
    {
      moduleSym = static_cast<unsigned int> (Lists_GetItemFromList (uselistModules, i));
      addDependentImport (graph, moduleSym, SymbolTable_GetModuleDefImportStatementList (moduleSym));
      addDependentImport (graph, moduleSym, SymbolTable_GetModuleModImportStatementList (moduleSym));
      i += 1;
    }
  /* Ensure that topModule is also in the graph.  */
  if (! (Lists_IsItemInList (list, topModule)))
    {
      addDependentImport (graph, topModule, SymbolTable_GetModuleDefImportStatementList (topModule));
      addDependentImport (graph, topModule, SymbolTable_GetModuleModImportStatementList (topModule));
    }
  return M2Graph_SortGraph (graph, topModule);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddEntry - adds an entry to the ctorGlobals and uselistModules.
*/

static void AddEntry (unsigned int tok, NameKey_Name name)
{
  if (ctorGlobals != NULL)
    {
      Lists_IncludeItemIntoList (ctorGlobals, name);
    }
  Lists_IncludeItemIntoList (uselistModules, LookupModuleSym (tok, name));
}


/*
   ReadModules - populate ctorGlobals with the modules specified by -fuse-list=filename.
*/

static void ReadModules (unsigned int tok, DynamicStrings_String filename)
{
  FIO_File f;
  DynamicStrings_String s;

  Lists_InitList (&ctorGlobals);
  Lists_InitList (&uselistModules);
  f = SFIO_OpenToRead (filename);
  while (! (FIO_EOF (f)))
    {
      s = SFIO_ReadS (f);
      s = DynamicStrings_RemoveComment (DynamicStrings_RemoveWhitePrefix (s), Comment);
      if ((! (DynamicStrings_Equal (DynamicStrings_Mark (DynamicStrings_InitStringChar (Comment)), DynamicStrings_Mark (DynamicStrings_Slice (s, 0, static_cast<int> ((DynamicStrings_Length (DynamicStrings_Mark (DynamicStrings_InitStringChar (Comment))))-1)))))) && (! (DynamicStrings_EqualArray (s, (const char *) "", 0))))
        {
          AddEntry (tok, NameKey_makekey (DynamicStrings_string (s)));
        }
      s = DynamicStrings_KillString (s);
    }
  FIO_Close (f);
}


/*
   AddModuleToCtor - adds moduleSym to the uselistModules and
                     sets all modules ctors as extern.
*/

static void AddModuleToCtor (unsigned int moduleSym)
{
  if ((SymbolTable_IsModule (moduleSym)) || (! (SymbolTable_IsDefinitionForC (moduleSym))))
    {
      if ((moduleSym != (SymbolTable_GetMainModule ())) && (! (SymbolTable_IsModuleBuiltin (moduleSym))))
        {
          SymbolTable_PutModuleCtorExtern (ctorTok, moduleSym, ! M2Options_WholeProgram);
          Lists_IncludeItemIntoList (uselistModules, moduleSym);
        }
    }
}


/*
   WriteList - writes the list to GetGenModuleFilename
               providing the filename is not NIL and not '-'.
*/

static void WriteList (unsigned int tok, Lists_List list)
{
  FIO_File fo;
  NameKey_Name name;
  unsigned int moduleSym;
  unsigned int i;
  unsigned int n;
  DynamicStrings_String s;

  if (((M2Options_GetGenModuleFilename ()) != NULL) && (! (DynamicStrings_EqualArray (M2Options_GetGenModuleFilename (), (const char *) "-", 1))))
    {
      fo = SFIO_OpenToWrite (M2Options_GetGenModuleFilename ());
      if (FIO_IsNoError (fo))
        {
          i = 1;
          n = Lists_NoOfItemsInList (list);
          while (i <= n)
            {
              moduleSym = static_cast<unsigned int> (Lists_GetItemFromList (list, i));
              name = SymbolTable_GetSymName (moduleSym);
              s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name));
              s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "\\n", 2)));
              s = FormatStrings_HandleEscape (s);
              s = SFIO_WriteS (fo, s);
              s = DynamicStrings_KillString (s);
              i += 1;
            }
          FIO_Close (fo);
        }
      else
        {
          s = DynamicStrings_InitString ((const char *) "unable to create file containing ctor module list: ", 51);
          s = DynamicStrings_ConCat (s, M2Options_GetGenModuleFilename ());
          M2MetaError_MetaErrorStringT0 (tok, s);
        }
    }
}


/*
   CreateCtorListFromImports - if GenModuleList then populate
                               the ctor list from all modules which are
                               not FOR 'C'.
*/

static bool CreateCtorListFromImports (unsigned int tok)
{
  Lists_List newlist;
  unsigned int i;
  unsigned int n;

  if (M2Options_GenModuleList)
    {
      Lists_InitList (&uselistModules);
      ctorTok = tok;
      SymbolTable_ForeachModuleDo ((SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) AddModuleToCtor});
      newlist = TopologicallySortList (uselistModules, SymbolTable_GetMainModule ());
      Lists_KillList (&uselistModules);
      uselistModules = newlist;
      /* Now create the ctorGlobals using uselistModules and retain the same order.  */
      Lists_InitList (&ctorGlobals);
      i = 1;
      n = Lists_NoOfItemsInList (uselistModules);
      while (i <= n)
        {
          Lists_IncludeItemIntoList (ctorGlobals, SymbolTable_GetSymName (Lists_GetItemFromList (uselistModules, i)));
          i += 1;
        }
      WriteList (tok, uselistModules);
      return true;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CreateCtorList - uses GetUselistFilename and then reads the list of modules.
*/

static bool CreateCtorList (unsigned int tok)
{
  DynamicStrings_String filename;

  if (M2Options_GetUselist ())
    {
      filename = M2Options_GetUselistFilename ();
      if (filename != NULL)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (SFIO_Exists (filename))
            {
              ReadModules (tok, filename);
              return true;
            }
          else
            {
              if (! (DynamicStrings_EqualArray (filename, (const char *) "-", 1)))
                {
                  M2MetaError_MetaErrorT0 (tok, (const char *) "{%E}the filename specified by the -fuse-list= option does not exist", 67);
                }
            }
        }
      return false;
    }
  else
    {
      return CreateCtorListFromImports (tok);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareModuleExtern - declare the extern _M2_modulename_ctor, _M2_modulename_init,
                         _M2_modulename_fini, _M2_modulename_dep for each external module.
*/

static void DeclareModuleExtern (unsigned int tokenno)
{
  NameKey_Name n1;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;
  unsigned int ctor;
  unsigned int module;
  unsigned int n;
  unsigned int i;

  Lists_InitList (&ctorModules);
  i = 1;
  n = Lists_NoOfItemsInList (uselistModules);
  while (i <= n)
    {
      module = static_cast<unsigned int> (Lists_GetItemFromList (uselistModules, i));
      if (module != (SymbolTable_GetMainModule ()))
        {
          SymbolTable_PutModuleCtorExtern (tokenno, module, ! M2Options_WholeProgram);
        }
      SymbolTable_GetModuleCtors (module, &ctor, &init, &fini, &dep);
      Lists_IncludeItemIntoList (ctorModules, ctor);
      if (Debugging)
        {
          n1 = SymbolTable_GetSymName (module);
          M2Printf_printf1 ((const char *) "%a_ctor added to ctorModules\\n", 30, (const unsigned char *) &n1, (sizeof (n1)-1));
        }
      i += 1;
    }
}


/*
   DeclareScaffoldFunctions - declare main, _M2_init,_M2_finish
                              and _M2_link to the modula-2
                              front end.
*/

static void DeclareScaffoldFunctions (unsigned int tokenno)
{
  if (CreateCtorList (tokenno))
    {
      DeclareCtorGlobal (tokenno);
      DeclareModuleExtern (tokenno);
      M2Scaffold_linkFunction = SymbolTable_MakeProcedure (tokenno, NameKey_MakeKey ((const char *) "_M2_link", 8));
      SymbolTable_PutMonoName (M2Scaffold_linkFunction, true);
      SymbolTable_PutProcedureDefined (M2Scaffold_linkFunction, SymbolTable_ProperProcedure);
    }
  else if (M2Options_ScaffoldDynamic && ! M2Options_cflag)
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "{%O}dynamic linking enabled but no module ctor list has been created, hint use -fuse-list=filename or -fgen-module-list=-", 121);
    }
  M2Scaffold_initFunction = SymbolTable_MakeProcedure (tokenno, NameKey_MakeKey ((const char *) "_M2_init", 8));
  SymbolTable_PutMonoName (M2Scaffold_initFunction, true);
  SymbolTable_PutProcedureDefined (M2Scaffold_initFunction, SymbolTable_ProperProcedure);
  M2Scaffold_finiFunction = SymbolTable_MakeProcedure (tokenno, NameKey_MakeKey ((const char *) "_M2_fini", 8));
  SymbolTable_PutMonoName (M2Scaffold_finiFunction, true);
  SymbolTable_PutProcedureDefined (M2Scaffold_initFunction, SymbolTable_ProperProcedure);
  if (M2Options_SharedFlag)
    {
      SymbolTable_PutCtor (M2Scaffold_initFunction, true);
      SymbolTable_PutCtor (M2Scaffold_finiFunction, true);
    }
  else
    {
      M2Scaffold_DeclareArgEnvParams (tokenno, M2Scaffold_initFunction);
      M2Scaffold_DeclareArgEnvParams (tokenno, M2Scaffold_finiFunction);
      M2Scaffold_mainFunction = SymbolTable_MakeProcedure (tokenno, NameKey_MakeKey ((const char *) "main", 4));
      SymbolTable_PutMonoName (M2Scaffold_mainFunction, true);
      SymbolTable_StartScope (M2Scaffold_mainFunction);
      SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Scaffold_mainFunction, SymbolTable_ProperProcedure, M2Base_Integer);
      M2Scaffold_DeclareArgEnvParams (tokenno, M2Scaffold_mainFunction);
      SymbolTable_PutPublic (M2Scaffold_mainFunction, true);
      SymbolTable_PutProcedureDefined (M2Scaffold_mainFunction, SymbolTable_ProperProcedure);
      SymbolTable_EndScope ();
    }
}


/*
   DeclareScaffold - declare scaffold related entities.
*/

extern "C" void M2Scaffold_DeclareScaffold (unsigned int tokno)
{
  if (! initialized)
    {
      initialized = true;
      DeclareScaffoldFunctions (tokno);
    }
}


/*
   DeclareArgEnvParams - declares (int argc, void *argv, void *envp)
*/

extern "C" void M2Scaffold_DeclareArgEnvParams (unsigned int tokno, unsigned int proc)
{
  Assertion_Assert (SymbolTable_IsProcedure (proc));
  SymbolTable_StartScope (proc);
  Assertion_Assert (SymbolTable_PutParam (tokno, proc, SymbolTable_ProperProcedure, 1, NameKey_MakeKey ((const char *) "argc", 4), M2Base_Integer, false, tokno));
  Assertion_Assert (SymbolTable_PutParam (tokno, proc, SymbolTable_ProperProcedure, 2, NameKey_MakeKey ((const char *) "argv", 4), M2System_Address, false, tokno));
  Assertion_Assert (SymbolTable_PutParam (tokno, proc, SymbolTable_ProperProcedure, 3, NameKey_MakeKey ((const char *) "envp", 4), M2System_Address, false, tokno));
  SymbolTable_PutProcedureParametersDefined (proc, SymbolTable_ProperProcedure);
  SymbolTable_PutProcedureDeclaredTok (proc, SymbolTable_ProperProcedure, tokno);
  SymbolTable_EndScope ();
}


/*
   PopulateCtorArray - assign each element of the ctorArray to the external module ctor.
                       This is only used to force the linker to pull in the ctors from
                       a library.
*/

extern "C" void M2Scaffold_PopulateCtorArray (unsigned int tok)
{
  unsigned int i;
  unsigned int n;

  n = Lists_NoOfItemsInList (ctorModules);
  i = 1;
  while (i <= n)
    {
      M2Quads_PushTFtok (M2Scaffold_ctorArray, ctorArrayType, tok);
      M2Quads_PushTtok (SymbolTable_MakeConstant (tok, i), tok);
      M2Quads_BuildDesignatorArray ();
      M2Quads_PushTtok (Lists_GetItemFromList (ctorModules, i), tok);
      M2Quads_BuildAssignment (tok);
      i += 1;
    }
}


/*
   ForeachModuleCallInit - is only called when -fscaffold-static is enabled.
                           precondition: the module list will be ordered.
                           postcondition: foreach module in the application universe
                                             call _M2_module_init (argc, argv, envp);
*/

extern "C" void M2Scaffold_ForeachModuleCallInit (unsigned int tok, unsigned int argc, unsigned int argv, unsigned int envp)
{
  unsigned int module;
  unsigned int i;
  unsigned int n;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  i = 1;
  n = Lists_NoOfItemsInList (uselistModules);
  while (i <= n)
    {
      module = static_cast<unsigned int> (Lists_GetItemFromList (uselistModules, i));
      if (module != SymbolTable_NulSym)
        {
          SymbolTable_GetModuleCtors (module, &ctor, &init, &fini, &dep);
          if (init != SymbolTable_NulSym)
            {
              M2Quads_PushTtok (init, tok);
              M2Quads_PushTtok (argc, tok);
              M2Quads_PushTtok (argv, tok);
              M2Quads_PushTtok (envp, tok);
              M2Quads_PushT (static_cast<unsigned int> (3));
              M2Quads_BuildProcedureCall (tok);
            }
        }
      i += 1;
    }
}


/*
   ForeachModuleCallFinish - precondition: the module list will be ordered.
                             postcondition: foreach module in the application universe
                                               call _M2_module_fini (argc, argv, envp);
*/

extern "C" void M2Scaffold_ForeachModuleCallFinish (unsigned int tok, unsigned int argc, unsigned int argv, unsigned int envp)
{
  unsigned int module;
  unsigned int i;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  i = Lists_NoOfItemsInList (uselistModules);
  while (i >= 1)
    {
      module = static_cast<unsigned int> (Lists_GetItemFromList (uselistModules, i));
      if (module != SymbolTable_NulSym)
        {
          SymbolTable_GetModuleCtors (module, &ctor, &init, &fini, &dep);
          if (fini != SymbolTable_NulSym)
            {
              M2Quads_PushTtok (fini, tok);
              M2Quads_PushTtok (argc, tok);
              M2Quads_PushTtok (argv, tok);
              M2Quads_PushTtok (envp, tok);
              M2Quads_PushT (static_cast<unsigned int> (3));
              M2Quads_BuildProcedureCall (tok);
            }
        }
      i -= 1;
    }
}

extern "C" void _M2_M2Scaffold_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  initialized = false;
  M2Scaffold_finiFunction = SymbolTable_NulSym;
  M2Scaffold_initFunction = SymbolTable_NulSym;
  M2Scaffold_mainFunction = SymbolTable_NulSym;
  M2Scaffold_linkFunction = SymbolTable_NulSym;
  M2Scaffold_ctorArray = SymbolTable_NulSym;
  ctorGlobals = static_cast<Lists_List> (NULL);
  ctorModules = static_cast<Lists_List> (NULL);
  uselistModules = static_cast<Lists_List> (NULL);
}

extern "C" void _M2_M2Scaffold_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
