/* do not edit automatically generated by mc from M2Debug.  */
/* M2Debug.mod simple debugging facilities in the Modula-2 compiler.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _M2Debug_C

#include "GM2Debug.h"
#   include "GStrIO.h"
#   include "GM2Error.h"
#   include "GM2Options.h"


/*
   Assert - tests the boolean, q. If false then an error is reported
            and the execution is HALTed.
*/

extern "C" void M2Debug_Assert (bool q);

/*
   WriteDebug - only writes a string if the debugging mode is on.
*/

extern "C" void M2Debug_WriteDebug (const char *a_, unsigned int _a_high);


/*
   Assert - tests the boolean, q. If false then an error is reported
            and the execution is HALTed.
*/

extern "C" void M2Debug_Assert (bool q)
{
  if (! q)
    {
      M2Error_InternalError ((const char *) "assert failed", 13);
    }
}


/*
   WriteDebug - only writes a string if the debugging mode is on.
*/

extern "C" void M2Debug_WriteDebug (const char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  if (M2Options_CompilerDebugging)
    {
      StrIO_WriteString ((const char *) a, _a_high);
      StrIO_WriteLn ();
    }
}

extern "C" void _M2_M2Debug_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2Debug_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
