/* do not edit automatically generated by mc from DynamicPath.  */
/* DynamicPath.mod implements a path for DynamicStrings.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _DynamicPath_C

#include "GDynamicPath.h"
#   include "GStorage.h"
#   include "GDynamicStrings.h"
#   include "GSFIO.h"
#   include "GFIO.h"
#   include "GM2Printf.h"

#   define Directory '/'
#   define Debugging false
typedef struct DynamicPath__T1_r DynamicPath__T1;

typedef DynamicPath__T1 *DynamicPath_PathList__opaque;

struct DynamicPath__T1_r {
                           DynamicPath_PathList__opaque tail;
                           DynamicPath_PathList__opaque next;
                           DynamicStrings_String entry;
                         };

static DynamicPath_PathList__opaque FreeList;

/*
   InitPathList - creates a new empty path list.
                  It takes a copy of the string.
*/

extern "C" DynamicPath_PathList DynamicPath_InitPathList (DynamicStrings_String str);

/*
   KillPathList - places list pl onto the freelist.
                  Postcondition: pl will be NIL.
*/

extern "C" void DynamicPath_KillPathList (DynamicPath_PathList *pl);

/*
   Cons - appends str to the end of a path list.
          If pl is NIL a new list is created and returned
          containing str.
*/

extern "C" DynamicPath_PathList DynamicPath_Cons (DynamicPath_PathList pl, DynamicStrings_String str);

/*
   ConsList - concatenates path list left and right together.
*/

extern "C" DynamicPath_PathList DynamicPath_ConsList (DynamicPath_PathList left, DynamicPath_PathList right);

/*
   Stash - returns pl before setting pl to NIL.
*/

extern "C" DynamicPath_PathList DynamicPath_Stash (DynamicPath_PathList *pl);

/*
   FindFileName - returns NIL if a file cannot be found otherwise
                  it returns the path including the filename.
*/

extern "C" DynamicStrings_String DynamicPath_FindFileName (DynamicStrings_String filename, DynamicPath_PathList pl);

/*
   DumpPath - debugging dump of the pathlist.
*/

extern "C" void DynamicPath_DumpPath (DynamicStrings_String name, DynamicPath_PathList pl);

/*
   AddDir - if str is not empty and does not end with / then add
            a directory.
            Postcondition: str is returned (with a '/' at the end)
            or is empty.
*/

static DynamicStrings_String AddDir (DynamicStrings_String str);


/*
   AddDir - if str is not empty and does not end with / then add
            a directory.
            Postcondition: str is returned (with a '/' at the end)
            or is empty.
*/

static DynamicStrings_String AddDir (DynamicStrings_String str)
{
  if ((DynamicStrings_Length (str)) > 0)
    {
      if ((DynamicStrings_char (str, -1)) != Directory)
        {
          str = DynamicStrings_ConCatChar (str, Directory);
        }
    }
  return str;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitPathList - creates a new empty path list.
                  It takes a copy of the string.
*/

extern "C" DynamicPath_PathList DynamicPath_InitPathList (DynamicStrings_String str)
{
  DynamicPath_PathList__opaque pl;

  Storage_ALLOCATE ((void **) &pl, sizeof (DynamicPath__T1));
  pl->tail = pl;
  pl->next = static_cast<DynamicPath_PathList__opaque> (NULL);
  pl->entry = DynamicStrings_Dup (str);
  return static_cast<DynamicPath_PathList> (pl);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillPathList - places list pl onto the freelist.
                  Postcondition: pl will be NIL.
*/

extern "C" void DynamicPath_KillPathList (DynamicPath_PathList *pl)
{
  if ((*pl) != NULL)
    {
      static_cast<DynamicPath_PathList__opaque> ((*pl))->tail->next = FreeList;
      FreeList = static_cast<DynamicPath_PathList__opaque> ((*pl));
      (*pl) = static_cast<DynamicPath_PathList> (NULL);
    }
}


/*
   Cons - appends str to the end of a path list.
          If pl is NIL a new list is created and returned
          containing str.
*/

extern "C" DynamicPath_PathList DynamicPath_Cons (DynamicPath_PathList pl, DynamicStrings_String str)
{
  if (pl == NULL)
    {
      pl = DynamicPath_InitPathList (str);
    }
  else
    {
      pl = DynamicPath_ConsList (pl, DynamicPath_InitPathList (str));
    }
  return pl;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConsList - concatenates path list left and right together.
*/

extern "C" DynamicPath_PathList DynamicPath_ConsList (DynamicPath_PathList left, DynamicPath_PathList right)
{
  if (right != NULL)
    {
      static_cast<DynamicPath_PathList__opaque> (left)->tail->next = static_cast<DynamicPath_PathList__opaque> (right);
      static_cast<DynamicPath_PathList__opaque> (left)->tail = static_cast<DynamicPath_PathList__opaque> (right)->tail;
    }
  return left;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Stash - returns pl before setting pl to NIL.
*/

extern "C" DynamicPath_PathList DynamicPath_Stash (DynamicPath_PathList *pl)
{
  DynamicPath_PathList__opaque old;

  old = static_cast<DynamicPath_PathList__opaque> ((*pl));
  (*pl) = static_cast<DynamicPath_PathList> (NULL);
  return static_cast<DynamicPath_PathList> (old);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FindFileName - returns NIL if a file cannot be found otherwise
                  it returns the path including the filename.
*/

extern "C" DynamicStrings_String DynamicPath_FindFileName (DynamicStrings_String filename, DynamicPath_PathList pl)
{
  DynamicStrings_String s;

  while (pl != NULL)
    {
      s = DynamicStrings_ConCat (AddDir (DynamicStrings_Dup (static_cast<DynamicPath_PathList__opaque> (pl)->entry)), DynamicStrings_Dup (filename));
      if (Debugging)
        {
          M2Printf_fprintf1 (FIO_StdErr, (const char *) "testing for %s: ", 16, (const unsigned char *) &s, (sizeof (s)-1));
        }
      if (SFIO_Exists (s))
        {
          if (Debugging)
            {
              M2Printf_fprintf0 (FIO_StdErr, (const char *) "yes\\n", 5);
            }
          return s;
        }
      if (Debugging)
        {
          M2Printf_fprintf0 (FIO_StdErr, (const char *) "no\\n", 4);
        }
      s = DynamicStrings_KillString (s);
      pl = static_cast<DynamicPath_PathList> (static_cast<DynamicPath_PathList__opaque> (pl)->next);
    }
  if (Debugging)
    {
      M2Printf_fprintf1 (FIO_StdErr, (const char *) "FindFileName did not find: %s in path\\n", 39, (const unsigned char *) &filename, (sizeof (filename)-1));
    }
  return static_cast<DynamicStrings_String> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DumpPath - debugging dump of the pathlist.
*/

extern "C" void DynamicPath_DumpPath (DynamicStrings_String name, DynamicPath_PathList pl)
{
  M2Printf_fprintf1 (FIO_StdErr, (const char *) "%s:", 3, (const unsigned char *) &name, (sizeof (name)-1));
  while (pl != NULL)
    {
      M2Printf_fprintf0 (FIO_StdErr, (const char *) " {", 2);
      M2Printf_fprintf1 (FIO_StdErr, (const char *) "%s", 2, (const unsigned char *) &static_cast<DynamicPath_PathList__opaque> (pl)->entry, (sizeof (static_cast<DynamicPath_PathList__opaque> (pl)->entry)-1));
      M2Printf_fprintf0 (FIO_StdErr, (const char *) "}", 1);
      pl = static_cast<DynamicPath_PathList> (static_cast<DynamicPath_PathList__opaque> (pl)->next);
    }
  M2Printf_fprintf0 (FIO_StdErr, (const char *) "\\n", 2);
}

extern "C" void _M2_DynamicPath_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  FreeList = static_cast<DynamicPath_PathList__opaque> (NULL);
}

extern "C" void _M2_DynamicPath_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
