/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern4 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  switch (GET_CODE (x4))
    {
    case AND:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      if (!register_operand (operands[2], E_QImode))
        return -1;
      return pattern3 (x2); /* [-1, 1] */

    case PLUS:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      if (!nonimmediate_operand (operands[2], E_QImode))
        return -1;
      res = pattern3 (x2);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[3] = x6;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      x7 = XEXP (x4, 1);
      operands[2] = x7;
      if (!nonimmediate_operand (operands[2], E_QImode))
        return -1;
      res = pattern2 (x2);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return 6;

    default:
      return -1;
    }
}

int
pattern33 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      return pattern5 (x3, 
E_V32QImode); /* [-1, 0] */

    case E_V16HImode:
      if (pattern5 (x3, 
E_V16HImode) != 0)
        return -1;
      return 1;

    case E_V8SImode:
      if (pattern5 (x3, 
E_V8SImode) != 0)
        return -1;
      return 2;

    case E_V16SImode:
      if (pattern5 (x3, 
E_V16SImode) != 0)
        return -1;
      return 3;

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode)
        return -1;
      return 4;

    case E_V8DImode:
      if (pattern5 (x3, 
E_V8DImode) != 0)
        return -1;
      return 5;

    case E_V4DImode:
      if (pattern5 (x3, 
E_V4DImode) != 0)
        return -1;
      return 6;

    case E_V2DImode:
      if (pattern5 (x3, 
E_V2DImode) != 0)
        return -1;
      return 7;

    case E_V64QImode:
      if (pattern5 (x3, 
E_V64QImode) != 0)
        return -1;
      return 8;

    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode)
        return -1;
      return 9;

    case E_V32HImode:
      if (pattern5 (x3, 
E_V32HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern42 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_TImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  return pattern41 (x2, 
E_DImode, 
E_TImode); /* [-1, 0] */
}

int
pattern46 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!flags_reg_operand (operands[0], E_VOIDmode))
    return -1;
  operands[1] = x2;
  if (!compare_operator (operands[1], E_VOIDmode))
    return -1;
  x5 = XEXP (x2, 0);
  x6 = XEXP (x5, 0);
  operands[2] = x6;
  if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
    return -1;
  x7 = XEXP (x5, 1);
  operands[3] = x7;
  if (!const_int_operand (operands[3], E_QImode))
    return -1;
  x8 = XEXP (x5, 2);
  operands[4] = x8;
  if (!const_int_operand (operands[4], E_QImode))
    return -1;
  switch (GET_MODE (x5))
    {
    case E_HImode:
      return 0;

    case E_SImode:
      return 1;

    case E_DImode:
      return 2;

    default:
      return -1;
    }
}

int
pattern56 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern57 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x4 = XEXP (x1, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern62 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern61 (x3, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (pattern61 (x3, 
E_SFmode) != 0)
        return -1;
      return 1;

    case E_DFmode:
      if (pattern61 (x3, 
E_DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern70 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  return pattern69 (x1); /* [-1, 2] */
}

int
pattern76 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x1, 0);
  switch (GET_CODE (x4))
    {
    case STRICT_LOW_PART:
      return pattern72 (x1, pnum_clobbers); /* [-1, 1] */

    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (pattern73 (x2, pnum_clobbers) != 0)
            return -1;
          return 2;

        case E_HImode:
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V2SFmode:
          if (pattern7 (x2, 
E_V2SFmode) != 0)
            return -1;
          return 4;

        case E_V2BFmode:
          if (pattern7 (x2, 
E_V2BFmode) != 0)
            return -1;
          return 5;

        case E_V4BFmode:
          if (pattern7 (x2, 
E_V4BFmode) != 0)
            return -1;
          return 6;

        case E_V2HFmode:
          if (pattern7 (x2, 
E_V2HFmode) != 0)
            return -1;
          return 7;

        case E_V4HFmode:
          if (pattern7 (x2, 
E_V4HFmode) != 0)
            return -1;
          return 8;

        case E_V8QImode:
          if (pattern8 (x2, 
E_V8QImode) != 0)
            return -1;
          return 9;

        case E_V4HImode:
          if (pattern8 (x2, 
E_V4HImode) != 0)
            return -1;
          return 10;

        case E_V2SImode:
          if (pattern8 (x2, 
E_V2SImode) != 0)
            return -1;
          return 11;

        case E_V4QImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V4QImode) != 0)
            return -1;
          return 12;

        case E_V2QImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V2QImode) != 0)
            return -1;
          return 13;

        case E_V2HImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V2HImode) != 0)
            return -1;
          return 14;

        case E_BFmode:
          if (pattern7 (x2, 
E_BFmode) != 0)
            return -1;
          return 15;

        case E_HFmode:
          if (pattern7 (x2, 
E_HFmode) != 0)
            return -1;
          return 16;

        case E_SFmode:
          if (pattern7 (x2, 
E_SFmode) != 0)
            return -1;
          return 17;

        case E_DFmode:
          if (pattern7 (x2, 
E_DFmode) != 0)
            return -1;
          return 18;

        case E_TFmode:
          if (pattern25 (x2, 
E_TFmode) != 0)
            return -1;
          return 19;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern109 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      switch (GET_MODE (x2))
        {
        case E_SImode:
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          return 0;

        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode)
              || !nonmemory_operand (operands[2], E_QImode))
            return -1;
          return 1;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode)
              || !nonmemory_operand (operands[2], E_QImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonmemory_operand (operands[2], E_QImode))
        return -1;
      switch (GET_MODE (x2))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode))
            return -1;
          return 3;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern128 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern140 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 2);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!nonimmediate_operand (operands[0], E_V16QImode)
          || GET_MODE (x1) != E_V16QImode
          || GET_MODE (x2) != E_V16QImode
          || !nonimm_or_0_operand (operands[2], E_V16QImode)
          || !register_operand (operands[3], E_HImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16SImode:
          if (!register_operand (operands[1], E_V16SImode))
            return -1;
          return 0;

        case E_V16HImode:
          if (!register_operand (operands[1], E_V16HImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V16HImode:
      if (pattern139 (x1, 
E_V16HImode, 
E_HImode, 
E_V16SImode) != 0)
        return -1;
      return 2;

    case E_V8SImode:
      if (pattern139 (x1, 
E_V8SImode, 
E_QImode, 
E_V8DImode) != 0)
        return -1;
      return 3;

    case E_V8HImode:
      if (!nonimmediate_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode
          || GET_MODE (x2) != E_V8HImode
          || !nonimm_or_0_operand (operands[2], E_V8HImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8DImode:
          if (!register_operand (operands[1], E_V8DImode))
            return -1;
          return 4;

        case E_V8SImode:
          if (!register_operand (operands[1], E_V8SImode))
            return -1;
          return 5;

        default:
          return -1;
        }

    case E_V32QImode:
      if (pattern139 (x1, 
E_V32QImode, 
E_SImode, 
E_V32HImode) != 0)
        return -1;
      return 6;

    case E_V4SImode:
      if (pattern139 (x1, 
E_V4SImode, 
E_QImode, 
E_V4DImode) != 0)
        return -1;
      return 7;

    default:
      return -1;
    }
}

int
pattern158 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i2))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i2))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern163 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2))
    return -1;
  return 0;
}

int
pattern166 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      return pattern165 (x3, 
E_V32HFmode, 
E_V64QImode, 
E_V32QImode); /* [-1, 0] */

    case E_V16QImode:
      if (pattern165 (x3, 
E_V16HFmode, 
E_V32QImode, 
E_V16QImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern176 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HImode:
      return pattern172 (x3, 
E_V32HImode); /* [-1, 0] */

    case E_V16SImode:
      if (pattern172 (x3, 
E_V16SImode) != 0)
        return -1;
      return 1;

    case E_V8DImode:
      if (pattern172 (x3, 
E_V8DImode) != 0)
        return -1;
      return 2;

    case E_V16HImode:
      if (pattern172 (x3, 
E_V16HImode) != 0)
        return -1;
      return 3;

    case E_V8SImode:
      if (pattern172 (x3, 
E_V8SImode) != 0)
        return -1;
      return 4;

    case E_V4DImode:
      if (pattern172 (x3, 
E_V4DImode) != 0)
        return -1;
      return 5;

    case E_V8HImode:
      if (pattern172 (x3, 
E_V8HImode) != 0)
        return -1;
      return 6;

    case E_V4SImode:
      if (pattern172 (x3, 
E_V4SImode) != 0)
        return -1;
      return 7;

    case E_V2DImode:
      if (pattern172 (x3, 
E_V2DImode) != 0)
        return -1;
      return 8;

    default:
      return -1;
    }
}

int
pattern190 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_CONCAT)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != VEC_SELECT)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != VEC_CONCAT)
    return -1;
  x7 = XEXP (x5, 1);
  if (GET_CODE (x7) != PARALLEL)
    return -1;
  x8 = XEXP (x3, 0);
  operands[1] = x8;
  x9 = XEXP (x3, 1);
  operands[2] = x9;
  x10 = XEXP (x6, 0);
  if (!rtx_equal_p (x10, operands[1]))
    return -1;
  x11 = XEXP (x6, 1);
  if (!rtx_equal_p (x11, operands[2]))
    return -1;
  switch (XVECLEN (x4, 0))
    {
    case 16:
      return pattern188 (x1); /* [-1, 0] */

    case 8:
      x12 = XVECEXP (x4, 0, 0);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x13 = XVECEXP (x4, 0, 1);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x14 = XVECEXP (x4, 0, 2);
      if (GET_CODE (x14) != CONST_INT)
        return -1;
      x15 = XVECEXP (x4, 0, 3);
      if (GET_CODE (x15) != CONST_INT)
        return -1;
      x16 = XVECEXP (x4, 0, 4);
      if (GET_CODE (x16) != CONST_INT)
        return -1;
      x17 = XVECEXP (x4, 0, 5);
      if (GET_CODE (x17) != CONST_INT)
        return -1;
      x18 = XVECEXP (x4, 0, 6);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
        return -1;
      x19 = XVECEXP (x4, 0, 7);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x7, 0) != 8)
        return -1;
      x20 = XVECEXP (x7, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x21 = XVECEXP (x7, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x22 = XVECEXP (x7, 0, 2);
      if (GET_CODE (x22) != CONST_INT)
        return -1;
      x23 = XVECEXP (x7, 0, 3);
      if (GET_CODE (x23) != CONST_INT)
        return -1;
      x24 = XVECEXP (x7, 0, 4);
      if (GET_CODE (x24) != CONST_INT)
        return -1;
      x25 = XVECEXP (x7, 0, 5);
      if (GET_CODE (x25) != CONST_INT)
        return -1;
      x26 = XVECEXP (x7, 0, 6);
      if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
        return -1;
      x27 = XVECEXP (x7, 0, 7);
      if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
        return -1;
      switch (XWINT (x14, 0))
        {
        case 4L:
          if (XWINT (x15, 0) != 6L
              || XWINT (x16, 0) != 8L
              || XWINT (x17, 0) != 10L
              || XWINT (x22, 0) != 5L
              || XWINT (x23, 0) != 7L
              || XWINT (x24, 0) != 9L
              || XWINT (x25, 0) != 11L
              || pattern189 (x1, 
E_V16HImode, 
E_V8HImode) != 0)
            return -1;
          return 1;

        case 8L:
          if (XWINT (x15, 0) != 10L
              || XWINT (x16, 0) != 4L
              || XWINT (x17, 0) != 6L
              || XWINT (x22, 0) != 9L
              || XWINT (x23, 0) != 11L
              || XWINT (x24, 0) != 5L
              || XWINT (x25, 0) != 7L
              || pattern187 (x1, 
E_V16SImode, 
E_V8SImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case 4:
      x12 = XVECEXP (x4, 0, 0);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x13 = XVECEXP (x4, 0, 1);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x14 = XVECEXP (x4, 0, 2);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x15 = XVECEXP (x4, 0, 3);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x7, 0) != 4)
        return -1;
      x20 = XVECEXP (x7, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x21 = XVECEXP (x7, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x22 = XVECEXP (x7, 0, 2);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x23 = XVECEXP (x7, 0, 3);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern189 (x1, 
E_V8SImode, 
E_V4SImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern220 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UMOD)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x6, 1);
  operands[3] = x8;
  x9 = XEXP (x2, 0);
  operands[1] = x9;
  x10 = XEXP (x3, 0);
  if (!rtx_equal_p (x10, operands[2]))
    return -1;
  x11 = XEXP (x3, 1);
  if (!rtx_equal_p (x11, operands[3]))
    return -1;
  switch (GET_CODE (operands[3]))
    {
    case REG:
    case SUBREG:
    case MEM:
      return 0;

    case CONST_INT:
      return 1;

    default:
      return -1;
    }
}

int
pattern230 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != MEM)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PLUS)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  return 0;
}

int
pattern238 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern237 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern237 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern237 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern237 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern249 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != VEC_SELECT)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != PARALLEL
      || XVECLEN (x2, 0) != 1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern253 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SUBREG
      || maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[2] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x1, 0);
      if (GET_CODE (x8) != ZERO_EXTRACT)
        return -1;
      x9 = XEXP (x8, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x8, 2);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!int248_register_operand (operands[0], E_VOIDmode))
        return -1;
      x12 = XEXP (x5, 0);
      operands[1] = x12;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      switch (GET_MODE (x8))
        {
        case E_HImode:
          if (GET_MODE (x2) != E_HImode
              || !extract_operator (operands[2], E_HImode))
            return -1;
          return 0;

        case E_SImode:
          if (GET_MODE (x2) != E_SImode
              || !extract_operator (operands[2], E_SImode))
            return -1;
          return 1;

        case E_DImode:
          if (GET_MODE (x2) != E_DImode
              || !extract_operator (operands[2], E_DImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern283 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern282 (x1); /* [-1, 1] */

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode))
            return -1;
          return 2;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode))
            return -1;
          return 3;

        case E_SImode:
          if (pnum_clobbers == NULL
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern296 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], E_DImode)
      || GET_MODE (x1) != E_DImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_V8QImode:
      return pattern99 (); /* [-1, 2] */

    case E_V4HImode:
      switch (GET_MODE (operands[1]))
        {
        case E_V4SImode:
          if (!register_operand (operands[1], E_V4SImode))
            return -1;
          return 3;

        case E_V4DImode:
          if (!register_operand (operands[1], E_V4DImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    case E_V2SImode:
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern308 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern316 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1)
      || !const_0_to_7_operand (operands[5], E_SImode))
    return -1;
  return 0;
}

int
pattern322 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x1) != E_V16SFmode
          || !nonimmediate_operand (operands[1], E_V16SFmode))
        return -1;
      return 0;

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x1) != E_V8SFmode
          || !nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      return 1;

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x1) != E_V4SFmode
          || !nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 2;

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x1) != E_V8DFmode
          || !nonimmediate_operand (operands[1], E_V8DFmode))
        return -1;
      return 3;

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x1) != E_V4DFmode
          || !nonimmediate_operand (operands[1], E_V4DFmode))
        return -1;
      return 4;

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x1) != E_V2DFmode
          || !nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern333 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern336 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !bcst_vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern340 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  return 0;
}

int
pattern342 (rtx x1, int *pnum_clobbers, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != i1
      || GET_MODE (x6) != E_SImode)
    return -1;
  x7 = XEXP (x2, 0);
  operands[0] = x7;
  if (!register_operand (operands[0], E_DImode)
      || GET_MODE (x3) != E_DImode)
    return -1;
  return 0;
}

int
pattern346 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  return pattern345 (x6); /* [-1, 5] */
}

int
pattern350 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return pattern349 (x1); /* [-1, 5] */
}

int
pattern354 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[2], i2))
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_MODE (x5) != i1
      || !nonimmediate_operand (operands[4], i2)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern358 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17)
    return -1;
  x6 = XEXP (x4, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x7) != CLOBBER)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCmode)
    return -1;
  x9 = XEXP (x2, 0);
  operands[0] = x9;
  x10 = XEXP (x3, 1);
  operands[1] = x10;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return 0;

    case E_HImode:
      return 1;

    case E_SImode:
      return 2;

    case E_DImode:
      return 3;

    default:
      return -1;
    }
}

int
pattern367 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x2, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17)
    return -1;
  x6 = XEXP (x3, 0);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x6, 1);
  operands[2] = x8;
  x9 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x9))
    {
    case SET:
      x10 = XEXP (x9, 0);
      operands[0] = x10;
      return 0;

    case CLOBBER:
      x10 = XEXP (x9, 0);
      operands[0] = x10;
      switch (GET_MODE (x6))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_QImode))
            return -1;
          return 1;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_HImode))
            return -1;
          return 2;

        case E_SImode:
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_SImode))
            return -1;
          return 3;

        case E_DImode:
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !const_1_to_63_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_DImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern392 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern400 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern407 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern414 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!general_reg_operand (operands[0], i1)
      || GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != 2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (!commutative_operator (x3, i1))
    return -1;
  operands[3] = x3;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XEXP (x3, 1);
  operands[2] = x6;
  if (!memory_operand (operands[2], i1))
    return -1;
  x7 = XEXP (x3, 0);
  if (!rtx_equal_p (x7, operands[0]))
    return -1;
  x8 = XEXP (x2, 0);
  if (!rtx_equal_p (x8, operands[0]))
    return -1;
  return 0;
}

int
pattern425 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern432 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  operands[3] = x5;
  if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
    return -1;
  x6 = XEXP (x2, 1);
  operands[1] = x6;
  x7 = XEXP (x1, 1);
  operands[2] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return 0;

    case E_HImode:
      return 1;

    default:
      return -1;
    }
}

int
pattern445 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !x86_64_general_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern450 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  if (maybe_ne (SUBREG_BYTE (x2), 0)
      || GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      return pattern449 (x1); /* [-1, 1] */

    case PLUS:
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern448 (x1);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      x4 = XEXP (x3, 0);
      operands[3] = x4;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern16 (x1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern466 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i4)
      || !nonimmediate_operand (operands[2], i3)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern472 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XEXP (x1, 1);
  switch (GET_CODE (x6))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x6;
      x7 = XEXP (x1, 2);
      if (GET_CODE (x7) != UNSPEC
          || XVECLEN (x7, 0) != 1
          || XINT (x7, 1) != 223)
        return -1;
      x8 = XVECEXP (x7, 0, 0);
      operands[5] = x8;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (!register_operand (operands[0], E_V32HFmode)
              || GET_MODE (x1) != E_V32HFmode
              || GET_MODE (x2) != E_V32HFmode
              || !vector_operand (operands[1], E_V32HFmode)
              || !vector_operand (operands[2], E_V32HFmode)
              || !vector_operand (operands[3], E_V32HFmode)
              || !const0_operand (operands[4], E_V32HFmode)
              || GET_MODE (x7) != E_SImode
              || !register_operand (operands[5], E_HImode))
            return -1;
          return 0;

        case E_V16HFmode:
          if (pattern470 (x1, 
E_HImode, 
E_V16HFmode) != 0)
            return -1;
          return 1;

        case E_V8HFmode:
          if (pattern470 (x1, 
E_QImode, 
E_V8HFmode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      x7 = XEXP (x1, 2);
      switch (GET_CODE (x7))
        {
        case UNSPEC:
          if (XVECLEN (x7, 0) != 1
              || XINT (x7, 1) != 223)
            return -1;
          x8 = XVECEXP (x7, 0, 0);
          operands[4] = x8;
          if (!rtx_equal_p (x6, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (!register_operand (operands[0], E_V32HFmode)
                  || GET_MODE (x1) != E_V32HFmode
                  || GET_MODE (x2) != E_V32HFmode
                  || !vector_operand (operands[1], E_V32HFmode)
                  || !vector_operand (operands[2], E_V32HFmode)
                  || !vector_operand (operands[3], E_V32HFmode)
                  || GET_MODE (x7) != E_SImode
                  || !register_operand (operands[4], E_HImode))
                return -1;
              return 3;

            case E_V16HFmode:
              if (pattern471 (x1, 
E_HImode, 
E_V16HFmode) != 0)
                return -1;
              return 4;

            case E_V8HFmode:
              if (pattern471 (x1, 
E_QImode, 
E_V8HFmode) != 0)
                return -1;
              return 5;

            default:
              return -1;
            }

        case CONST_INT:
          if (XWINT (x7, 0) != 3L
              || !register_operand (operands[0], E_V8HFmode)
              || GET_MODE (x1) != E_V8HFmode
              || GET_MODE (x2) != E_V8HFmode
              || !vector_operand (operands[1], E_V8HFmode)
              || !vector_operand (operands[2], E_V8HFmode)
              || !vector_operand (operands[3], E_V8HFmode)
              || !rtx_equal_p (x6, operands[2]))
            return -1;
          return 6;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern505 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i2
      || !nonimm_or_0_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4SImode:
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern512 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x1) != E_V16QImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_V4QImode:
          return pattern511 (
E_V12QImode); /* [-1, 1] */

        case E_V2QImode:
          if (!register_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V14QImode))
            return -1;
          return 2;

        case E_V8QImode:
          if (!const0_operand (operands[2], E_V8QImode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8SImode:
              if (!register_operand (operands[1], E_V8SImode))
                return -1;
              return 3;

            case E_V8HImode:
              if (!register_operand (operands[1], E_V8HImode))
                return -1;
              return 4;

            default:
              return -1;
            }

        default:
          return -1;
        }

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_V4HImode:
          res = pattern511 (
E_V4HImode);
          if (res >= 0)
            return res + 5; /* [5, 6] */
          return -1;

        case E_V2HImode:
          if (!register_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V6HImode))
            return -1;
          return 7;

        default:
          return -1;
        }

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode)
        return -1;
      x2 = XEXP (x1, 0);
      if (GET_MODE (x2) != E_V2SImode
          || !register_operand (operands[1], E_V2DImode)
          || !const0_operand (operands[2], E_V2SImode))
        return -1;
      return 8;

    default:
      return -1;
    }
}

int
pattern534 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x1, 1);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      return pattern530 (x1, 
E_V32HFmode); /* [-1, 0] */

    case E_V16HFmode:
      if (pattern530 (x1, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V8HFmode:
      if (pattern530 (x1, 
E_V8HFmode) != 0)
        return -1;
      return 2;

    case E_V32BFmode:
      if (pattern530 (x1, 
E_V32BFmode) != 0)
        return -1;
      return 3;

    case E_V16BFmode:
      if (pattern530 (x1, 
E_V16BFmode) != 0)
        return -1;
      return 4;

    case E_V8BFmode:
      if (pattern530 (x1, 
E_V8BFmode) != 0)
        return -1;
      return 5;

    case E_V16SFmode:
      if (pattern530 (x1, 
E_V16SFmode) != 0)
        return -1;
      return 6;

    case E_V8SFmode:
      if (pattern530 (x1, 
E_V8SFmode) != 0)
        return -1;
      return 7;

    case E_V4SFmode:
      if (pattern530 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 8;

    case E_V8DFmode:
      if (pattern530 (x1, 
E_V8DFmode) != 0)
        return -1;
      return 9;

    case E_V4DFmode:
      if (pattern530 (x1, 
E_V4DFmode) != 0)
        return -1;
      return 10;

    case E_V2DFmode:
      if (pattern530 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern543 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  if (!register_operand (operands[0], E_XFmode))
    return -1;
  x7 = XVECEXP (x3, 0, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_XFmode))
    return -1;
  return 0;
}

int
pattern548 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_V2SFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != UNSPEC
      || XVECLEN (x4, 0) != 1
      || XINT (x4, 1) != 110)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  if (!register_operand (operands[0], E_V2SFmode))
    return -1;
  x7 = XVECEXP (x3, 0, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_V2SFmode))
    return -1;
  x8 = XVECEXP (x3, 0, 1);
  operands[2] = x8;
  if (!nonimmediate_operand (operands[2], E_V2SFmode))
    return -1;
  return 0;
}

int
pattern558 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || pattern557 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern561 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern567 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != E_QImode)
    return -1;
  return 0;
}

int
pattern571 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_SImode
      || !register_operand (operands[0], E_SImode)
      || !register_operand (operands[1], E_SImode)
      || !register_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern576 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  if (!const_int_operand (operands[3], E_QImode))
    return -1;
  return pattern574 (x1); /* [-1, 3] */
}

int
pattern582 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  return 0;
}

int
pattern586 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != UNSPEC
      || XVECLEN (x4, 0) != 1
      || XINT (x4, 1) != 32)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 17
      || GET_MODE (x7) != E_CCmode)
    return -1;
  x8 = XVECEXP (x1, 0, 0);
  x9 = XEXP (x8, 0);
  operands[0] = x9;
  return pattern585 (x1); /* [-1, 1] */
}

int
pattern593 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[5] = x2;
  if (!memory_operand (operands[5], i1))
    return -1;
  x3 = XEXP (x1, 1);
  operands[0] = x3;
  if (!general_reg_operand (operands[0], i1))
    return -1;
  x4 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x4, 0);
  operands[1] = x6;
  if (!memory_operand (operands[1], i1))
    return -1;
  x7 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x7) != SET)
    return -1;
  x8 = XEXP (x7, 1);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x9 = XEXP (x7, 0);
  operands[2] = x9;
  if (!memory_operand (operands[2], i1))
    return -1;
  x10 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x10) != SET)
    return -1;
  x11 = XEXP (x10, 1);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x12 = XEXP (x10, 0);
  operands[3] = x12;
  if (!memory_operand (operands[3], i1))
    return -1;
  x13 = PATTERN (peep2_next_insn (4));
  if (GET_CODE (x13) != SET)
    return -1;
  x14 = XEXP (x13, 1);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x15 = XEXP (x13, 0);
  operands[4] = x15;
  if (!memory_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern609 (rtx x1, int *pnum_clobbers, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern616 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[2] = x4;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[1] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern615 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern615 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern626 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern632 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
      operands[4] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          return 0;

        case E_V16HFmode:
          return 1;

        case E_V8HFmode:
          return 2;

        case E_V16SFmode:
          return 3;

        case E_V8SFmode:
          return 4;

        case E_V4SFmode:
          return 5;

        case E_V8DFmode:
          return 6;

        case E_V4DFmode:
          return 7;

        case E_V2DFmode:
          return 8;

        case E_V32BFmode:
          return 9;

        case E_V16BFmode:
          return 10;

        case E_V8BFmode:
          return 11;

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x2, 0) != 1L)
        return -1;
      x3 = XEXP (x1, 1);
      if (!rtx_equal_p (x3, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return 12;

        case E_V4SFmode:
          return 13;

        case E_V2DFmode:
          return 14;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern644 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XVECEXP (x1, 0, 1);
  if (!const_4_or_8_to_11_operand (x6, E_SImode))
    return -1;
  x7 = XEXP (x2, 2);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
      operands[4] = x7;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      operands[5] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          return pattern641 (x1, 
E_V32HFmode, 
E_SImode); /* [-1, 0] */

        case E_V16HFmode:
          if (pattern641 (x1, 
E_V16HFmode, 
E_HImode) != 0)
            return -1;
          return 1;

        case E_V8HFmode:
          if (pattern641 (x1, 
E_V8HFmode, 
E_QImode) != 0)
            return -1;
          return 2;

        case E_V16SFmode:
          if (pattern641 (x1, 
E_V16SFmode, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V8SFmode:
          if (pattern641 (x1, 
E_V8SFmode, 
E_QImode) != 0)
            return -1;
          return 4;

        case E_V4SFmode:
          if (pattern641 (x1, 
E_V4SFmode, 
E_QImode) != 0)
            return -1;
          return 5;

        case E_V8DFmode:
          if (pattern641 (x1, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          return 6;

        case E_V4DFmode:
          if (pattern641 (x1, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          return 7;

        case E_V2DFmode:
          if (pattern641 (x1, 
E_V2DFmode, 
E_QImode) != 0)
            return -1;
          return 8;

        default:
          return -1;
        }

    case CONST_INT:
      res = pattern643 (x1);
      if (res >= 0)
        return res + 9; /* [9, 11] */
      return -1;

    default:
      return -1;
    }
}

int
pattern663 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V2SImode)
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_CODE (x3) != CONST_VECTOR
      || XVECLEN (x3, 0) != 2
      || GET_MODE (x3) != E_V2SImode)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
      || !register_operand (operands[0], E_V4SImode)
      || GET_MODE (x1) != E_V4SImode
      || !nonimmediate_operand (operands[1], E_V2DFmode))
    return -1;
  return 0;
}

int
pattern671 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XVECEXP (x3, 0, 2);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x3, 0, 3);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
      || GET_MODE (x2) != i2)
    return -1;
  x8 = XEXP (x2, 0);
  if (GET_MODE (x8) != i1)
    return -1;
  return pattern27 (x1); /* [-1, 1] */
}

int
pattern681 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XEXP (x3, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x7) != CLOBBER)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCmode)
    return -1;
  x9 = XEXP (x2, 0);
  operands[0] = x9;
  if (!register_operand (operands[0], E_QImode)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x10 = XEXP (x4, 0);
  operands[1] = x10;
  x11 = XEXP (x4, 2);
  operands[2] = x11;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_SImode:
      if (!register_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern693 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_TFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      return pattern690 (x5, 
E_TFmode); /* [-1, 0] */

    case E_HFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V8HFmode, 
E_HFmode) != 0)
        return -1;
      return 1;

    case E_SFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V4SFmode, 
E_SFmode) != 0)
        return -1;
      return 2;

    case E_DFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V2DFmode, 
E_DFmode) != 0)
        return -1;
      return 3;

    case E_V2SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern691 (x5) != 0)
        return -1;
      return 4;

    case E_V2BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V2BFmode) != 0)
        return -1;
      return 5;

    case E_V4BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V4BFmode) != 0)
        return -1;
      return 6;

    case E_V2HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V2HFmode) != 0)
        return -1;
      return 7;

    case E_V4HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V4HFmode) != 0)
        return -1;
      return 8;

    case E_V32BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V32BFmode) != 0)
        return -1;
      return 9;

    case E_V16BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16BFmode) != 0)
        return -1;
      return 10;

    case E_V8BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8BFmode) != 0)
        return -1;
      return 11;

    case E_V32HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V32HFmode) != 0)
        return -1;
      return 12;

    case E_V16HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16HFmode) != 0)
        return -1;
      return 13;

    case E_V8HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8HFmode) != 0)
        return -1;
      return 14;

    case E_V16SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16SFmode) != 0)
        return -1;
      return 15;

    case E_V8SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8SFmode) != 0)
        return -1;
      return 16;

    case E_V4SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V4SFmode) != 0)
        return -1;
      return 17;

    case E_V8DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8DFmode) != 0)
        return -1;
      return 18;

    case E_V4DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V4DFmode) != 0)
        return -1;
      return 19;

    case E_V2DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V2DFmode) != 0)
        return -1;
      return 20;

    default:
      return -1;
    }
}

int
pattern741 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !ix86_comparison_uns_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern748 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern747 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern747 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern754 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern761 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  switch (GET_CODE (x2))
    {
    case UNSPEC:
      if (XVECLEN (x2, 0) != 3
          || XINT (x2, 1) != 59)
        return -1;
      x3 = XVECEXP (x2, 0, 2);
      if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x4 = XEXP (x1, 0);
      operands[3] = x4;
      x5 = XEXP (x1, 1);
      operands[4] = x5;
      x6 = XVECEXP (x2, 0, 0);
      operands[1] = x6;
      x7 = XVECEXP (x2, 0, 1);
      operands[2] = x7;
      switch (GET_MODE (x1))
        {
        case E_V32QImode:
          return pattern760 (x2, 
E_V32QImode, 
E_SImode); /* [-1, 0] */

        case E_V16QImode:
          if (pattern760 (x2, 
E_V16QImode, 
E_HImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[1] = x2;
      x4 = XEXP (x1, 0);
      operands[2] = x4;
      x5 = XEXP (x1, 1);
      operands[3] = x5;
      switch (GET_MODE (x1))
        {
        case E_V16QImode:
          if (!vector_all_ones_operand (operands[2], E_V16QImode)
              || !const0_operand (operands[3], E_V16QImode)
              || !register_operand (operands[1], E_HImode))
            return -1;
          return 2;

        case E_V32QImode:
          if (!vector_all_ones_operand (operands[2], E_V32QImode)
              || !const0_operand (operands[3], E_V32QImode)
              || !register_operand (operands[1], E_SImode))
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern789 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern794 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !ix86_comparison_int_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern803 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1)
      || !bcst_vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern809 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17
      || GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern814 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case CLOBBER:
      x2 = XEXP (x1, 0);
      if (GET_CODE (x2) != REG
          || REGNO (x2) != 17
          || GET_MODE (x2) != E_CCmode)
        return -1;
      return 0;

    case UNSPEC:
      if (XVECLEN (x1, 0) != 1
          || XINT (x1, 1) != 174)
        return -1;
      x3 = XVECEXP (x1, 0, 0);
      if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          return 1;

        case E_HImode:
          return 2;

        case E_SImode:
          return 3;

        case E_DImode:
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern822 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !nonmemory_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern824 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  return pattern440 (x1); /* [-1, 1] */
}

int
pattern828 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  return 0;
}

int
pattern835 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != 2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x3) != SET)
    return -1;
  x4 = XEXP (x3, 1);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  return 0;
}

int
pattern839 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != VEC_SELECT)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 1)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != VEC_SELECT)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 1)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern847 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_CONCAT)
    return -1;
  x4 = XEXP (x1, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x5, 1);
  operands[2] = x7;
  x8 = XEXP (x3, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  x9 = XEXP (x3, 1);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  x10 = XEXP (x4, 1);
  switch (XVECLEN (x10, 0))
    {
    case 4:
      x11 = XVECEXP (x10, 0, 0);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x12 = XVECEXP (x10, 0, 1);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x13 = XVECEXP (x10, 0, 2);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x14 = XVECEXP (x10, 0, 3);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x15 = XEXP (x2, 1);
      if (XVECLEN (x15, 0) != 4)
        return -1;
      x16 = XVECEXP (x15, 0, 0);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x17 = XVECEXP (x15, 0, 1);
      if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x18 = XVECEXP (x15, 0, 2);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x19 = XVECEXP (x15, 0, 3);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern846 (x1, 
E_V8HImode, 
E_V4HImode) != 0)
        return -1;
      return 0;

    case 2:
      x11 = XVECEXP (x10, 0, 0);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x12 = XVECEXP (x10, 0, 1);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x15 = XEXP (x2, 1);
      if (XVECLEN (x15, 0) != 2)
        return -1;
      x16 = XVECEXP (x15, 0, 0);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x17 = XVECEXP (x15, 0, 1);
      if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
          || pattern846 (x1, 
E_V4SImode, 
E_V2SImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern877 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern887 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4SImode:
      if (!nonimmediate_operand (operands[1], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!nonimmediate_operand (operands[1], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern899 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern905 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern907 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern911 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern913 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern918 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  return 0;
}

int
pattern926 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!memory_operand (operands[2], E_DImode))
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  return pattern388 (x5); /* [-1, 2] */
}

int
pattern932 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x3, 1);
  operands[2] = x6;
  x7 = XEXP (x4, 1);
  switch (GET_CODE (x7))
    {
    case NE:
      return pattern931 (x3); /* [-1, 3] */

    case EQ:
      res = pattern931 (x3);
      if (res >= 0)
        return res + 4; /* [4, 7] */
      return -1;

    default:
      return -1;
    }
}

int
pattern942 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern949 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[6] = x2;
  x3 = XEXP (x1, 1);
  operands[7] = x3;
  if (!memory_operand (operands[7], i1))
    return -1;
  x4 = PATTERN (peep2_next_insn (1));
  x5 = XEXP (x4, 1);
  operands[9] = x5;
  if (!memory_operand (operands[9], i1))
    return -1;
  x6 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 2)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (GET_CODE (x7) != SET)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != COMPARE
      || GET_MODE (x8) != E_CCCmode)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_CODE (x9) != ZERO_EXTEND
      || GET_MODE (x9) != i2)
    return -1;
  x10 = XEXP (x8, 1);
  if (GET_CODE (x10) != PLUS
      || GET_MODE (x10) != i2)
    return -1;
  x11 = XEXP (x10, 0);
  if (!ix86_carry_flag_operator (x11, i2))
    return -1;
  operands[4] = x11;
  x12 = XEXP (x11, 1);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x13 = XEXP (x10, 1);
  if (GET_CODE (x13) != ZERO_EXTEND
      || GET_MODE (x13) != i2)
    return -1;
  x14 = XEXP (x7, 0);
  if (GET_CODE (x14) != REG
      || REGNO (x14) != 17
      || GET_MODE (x14) != E_CCCmode)
    return -1;
  x15 = XVECEXP (x6, 0, 1);
  if (GET_CODE (x15) != SET)
    return -1;
  x16 = XEXP (x15, 1);
  if (GET_CODE (x16) != MINUS
      || GET_MODE (x16) != i1)
    return -1;
  x17 = XEXP (x16, 0);
  if (GET_CODE (x17) != MINUS
      || GET_MODE (x17) != i1)
    return -1;
  x18 = XEXP (x17, 1);
  if (!ix86_carry_flag_operator (x18, i1))
    return -1;
  operands[5] = x18;
  x19 = XEXP (x18, 1);
  if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x20 = XEXP (x9, 0);
  operands[0] = x20;
  if (!general_reg_operand (operands[0], i1))
    return -1;
  x21 = XEXP (x11, 0);
  operands[3] = x21;
  if (!flags_reg_operand (operands[3], E_VOIDmode))
    return -1;
  x22 = XEXP (x13, 0);
  operands[2] = x22;
  if (!general_reg_operand (operands[2], i1))
    return -1;
  x23 = XEXP (x17, 0);
  if (!rtx_equal_p (x23, operands[0]))
    return -1;
  x24 = XEXP (x18, 0);
  if (!rtx_equal_p (x24, operands[3]))
    return -1;
  x25 = XEXP (x16, 1);
  if (!rtx_equal_p (x25, operands[2]))
    return -1;
  x26 = XEXP (x15, 0);
  if (!rtx_equal_p (x26, operands[0]))
    return -1;
  x27 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x27) != SET)
    return -1;
  x28 = XEXP (x27, 1);
  switch (GET_CODE (x28))
    {
    case REG:
      if (!rtx_equal_p (x28, operands[0]))
        return -1;
      x29 = XEXP (x27, 0);
      operands[1] = x29;
      if (!memory_operand (operands[1], i1))
        return -1;
      return 0;

    case LTU:
      if (peep2_current_count < 5
          || peep2_current_count < 6
          || GET_MODE (x28) != E_QImode)
        return -1;
      x30 = XEXP (x28, 0);
      if (GET_CODE (x30) != REG
          || REGNO (x30) != 17
          || GET_MODE (x30) != E_CCCmode)
        return -1;
      x31 = XEXP (x28, 1);
      if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x29 = XEXP (x27, 0);
      operands[10] = x29;
      if (!general_reg_operand (operands[10], E_QImode))
        return -1;
      x32 = PATTERN (peep2_next_insn (4));
      if (GET_CODE (x32) != SET)
        return -1;
      x33 = XEXP (x32, 1);
      if (GET_CODE (x33) != ZERO_EXTEND
          || GET_MODE (x33) != i1)
        return -1;
      x34 = XEXP (x32, 0);
      operands[11] = x34;
      if (!general_reg_operand (operands[11], i1))
        return -1;
      x35 = XEXP (x33, 0);
      if (!rtx_equal_p (x35, operands[10]))
        return -1;
      x36 = PATTERN (peep2_next_insn (5));
      if (GET_CODE (x36) != SET)
        return -1;
      x37 = XEXP (x36, 0);
      operands[1] = x37;
      if (!memory_operand (operands[1], i1))
        return -1;
      x38 = XEXP (x36, 1);
      if (!rtx_equal_p (x38, operands[0]))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern984 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V4DImode)
      || GET_MODE (x1) != E_V4DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V4DImode
      || !nonimm_or_0_operand (operands[2], E_V4DImode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V4DFmode:
      if (!vector_operand (operands[1], E_V4DFmode))
        return -1;
      return 1;

    case E_V4SFmode:
      if (!vector_operand (operands[1], E_V4SFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern996 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[2], i1)
      || !reg_or_0_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1005 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_comparison_uns_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1011 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !const48_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern1018 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1029 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case PLUS:
      return pattern1026 (x1); /* [-1, 0] */

    case MINUS:
      if (pattern1026 (x1) != 0)
        return -1;
      return 1;

    case AND:
      if (pattern1026 (x1) != 0)
        return -1;
      return 2;

    case IOR:
      if (pattern1026 (x1) != 0)
        return -1;
      return 3;

    case XOR:
      if (pattern1026 (x1) != 0)
        return -1;
      return 4;

    case NEG:
      if (GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != SUBREG
          || maybe_ne (SUBREG_BYTE (x4), 0)
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          operands[2] = x5;
          x6 = XEXP (x5, 1);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x7 = XEXP (x5, 2);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x8 = XEXP (x1, 0);
          if (GET_CODE (x8) != ZERO_EXTRACT)
            return -1;
          x9 = XEXP (x8, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x10 = XEXP (x8, 2);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x11 = XEXP (x8, 0);
          operands[0] = x11;
          if (!int248_register_operand (operands[0], E_VOIDmode))
            return -1;
          x12 = XEXP (x5, 0);
          operands[1] = x12;
          if (!int248_register_operand (operands[1], E_VOIDmode))
            return -1;
          switch (GET_MODE (x8))
            {
            case E_HImode:
              if (GET_MODE (x2) != E_HImode
                  || !extract_operator (operands[2], E_HImode))
                return -1;
              return 5;

            case E_SImode:
              if (GET_MODE (x2) != E_SImode
                  || !extract_operator (operands[2], E_SImode))
                return -1;
              return 6;

            case E_DImode:
              if (GET_MODE (x2) != E_DImode
                  || !extract_operator (operands[2], E_DImode))
                return -1;
              return 7;

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ASHIFT:
      if (GET_MODE (x3) != E_QImode)
        return -1;
      res = pattern1028 (x1);
      if (res >= 0)
        return res + 8; /* [8, 10] */
      return -1;

    case LSHIFTRT:
      return 11;

    case ASHIFTRT:
      return 12;

    default:
      return -1;
    }
}

int
pattern1055 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != ZERO_EXTRACT)
    return -1;
  x3 = XEXP (x2, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x4 = XEXP (x2, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x5 = XEXP (x2, 0);
  operands[2] = x5;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x6 = XEXP (x1, 1);
  operands[3] = x6;
  switch (GET_MODE (x2))
    {
    case E_HImode:
      if (!const_int_operand (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!const_int_operand (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!const_int_operand (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1068 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern1081 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1087 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1090 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V2DImode)
      || GET_MODE (x1) != E_V2DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V2DImode
      || !nonimm_or_0_operand (operands[2], E_V2DImode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      return 0;

    case E_V2DFmode:
      return 1;

    default:
      return -1;
    }
}

int
pattern1095 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i3))
    return -1;
  return 0;
}

int
pattern1103 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1110 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  x6 = XEXP (x4, 0);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x5, 0);
  operands[2] = x8;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HImode:
      return pattern1109 (x1, 
E_SImode, 
E_V32HImode, 
E_V32SImode); /* [-1, 0] */

    case E_V16HImode:
      if (pattern1109 (x1, 
E_HImode, 
E_V16HImode, 
E_V16SImode) != 0)
        return -1;
      return 1;

    case E_V8HImode:
      if (pattern1109 (x1, 
E_QImode, 
E_V8HImode, 
E_V8SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1123 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !bcst_vector_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1126 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i2)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1134 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      return pattern1133 (x5, 
E_SImode); /* [-1, 1] */

    case E_DImode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      res = pattern1133 (x5, 
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1143 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1151 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case AND:
      x2 = XEXP (x1, 0);
      operands[2] = x2;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      x3 = XEXP (x1, 1);
      operands[3] = x3;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      return 0;

    case PLUS:
      x2 = XEXP (x1, 0);
      operands[2] = x2;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      x3 = XEXP (x1, 1);
      operands[3] = x3;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      return 1;

    case MINUS:
      x2 = XEXP (x1, 0);
      operands[3] = x2;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x3 = XEXP (x1, 1);
      operands[2] = x3;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1167 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case SUBREG:
      if (maybe_ne (SUBREG_BYTE (x2), 0)
          || GET_MODE (x2) != E_QImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[1] = x3;
      return pattern1155 (x1); /* [-1, 11] */

    case CONST_INT:
      return 12;

    default:
      return -1;
    }
}

int
pattern1176 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1182 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30;
  int res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[0]))
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  switch (GET_CODE (x5))
    {
    case COMPARE:
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != REG
          || REGNO (x6) != 17)
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x7) != SET)
        return -1;
      x8 = XEXP (x7, 1);
      if (GET_MODE (x8) != i1)
        return -1;
      x9 = XEXP (x7, 0);
      if (!rtx_equal_p (x9, operands[0]))
        return -1;
      x10 = XEXP (x2, 0);
      if (!rtx_equal_p (x10, operands[1]))
        return -1;
      x11 = XEXP (x5, 0);
      switch (GET_CODE (x11))
        {
        case REG:
          return pattern1177 (x1, 
i1); /* [-1, 0] */

        case ZERO_EXTEND:
          if (GET_MODE (x11) != i2)
            return -1;
          x12 = XEXP (x5, 1);
          if (GET_CODE (x12) != PLUS
              || GET_MODE (x12) != i2)
            return -1;
          x13 = XEXP (x12, 0);
          if (!ix86_carry_flag_operator (x13, i2))
            return -1;
          operands[4] = x13;
          x14 = XEXP (x13, 1);
          if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x15 = XEXP (x12, 1);
          if (GET_CODE (x15) != ZERO_EXTEND
              || GET_MODE (x15) != i2
              || GET_MODE (x6) != E_CCCmode
              || GET_MODE (x5) != E_CCCmode)
            return -1;
          x16 = XEXP (x11, 0);
          switch (GET_CODE (x16))
            {
            case PLUS:
              if (GET_MODE (x16) != i1)
                return -1;
              x17 = XEXP (x16, 0);
              if (GET_CODE (x17) != PLUS
                  || GET_MODE (x17) != i1)
                return -1;
              x18 = XEXP (x17, 0);
              if (!ix86_carry_flag_operator (x18, i1))
                return -1;
              operands[5] = x18;
              x19 = XEXP (x18, 1);
              if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
                  || GET_CODE (x8) != PLUS)
                return -1;
              x20 = XEXP (x8, 0);
              if (GET_CODE (x20) != PLUS
                  || GET_MODE (x20) != i1)
                return -1;
              x21 = XEXP (x20, 0);
              switch (GET_CODE (x21))
                {
                case LTU:
                case UNLT:
                  if (!rtx_equal_p (x21, operands[5]))
                    return -1;
                  x22 = XEXP (x18, 0);
                  operands[3] = x22;
                  if (!flags_reg_operand (operands[3], E_VOIDmode))
                    return -1;
                  x23 = XEXP (x16, 1);
                  operands[2] = x23;
                  if (!memory_operand (operands[2], i1))
                    return -1;
                  x24 = XEXP (x17, 1);
                  if (!rtx_equal_p (x24, operands[0]))
                    return -1;
                  x25 = XEXP (x13, 0);
                  if (!rtx_equal_p (x25, operands[3]))
                    return -1;
                  x26 = XEXP (x15, 0);
                  if (!rtx_equal_p (x26, operands[2]))
                    return -1;
                  x27 = XEXP (x20, 1);
                  if (!rtx_equal_p (x27, operands[0]))
                    return -1;
                  x28 = XEXP (x8, 1);
                  if (!rtx_equal_p (x28, operands[2]))
                    return -1;
                  return 1;

                default:
                  return -1;
                }

            case REG:
              if (!rtx_equal_p (x16, operands[0])
                  || GET_CODE (x8) != MINUS)
                return -1;
              x20 = XEXP (x8, 0);
              if (GET_CODE (x20) != MINUS
                  || GET_MODE (x20) != i1)
                return -1;
              x27 = XEXP (x20, 1);
              if (!ix86_carry_flag_operator (x27, i1))
                return -1;
              operands[5] = x27;
              x29 = XEXP (x27, 1);
              if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x25 = XEXP (x13, 0);
              operands[3] = x25;
              if (!flags_reg_operand (operands[3], E_VOIDmode))
                return -1;
              x26 = XEXP (x15, 0);
              operands[2] = x26;
              if (!memory_operand (operands[2], i1))
                return -1;
              x21 = XEXP (x20, 0);
              if (!rtx_equal_p (x21, operands[0]))
                return -1;
              x30 = XEXP (x27, 0);
              if (!rtx_equal_p (x30, operands[3]))
                return -1;
              x28 = XEXP (x8, 1);
              if (!rtx_equal_p (x28, operands[2]))
                return -1;
              return 2;

            default:
              return -1;
            }

        case PLUS:
          if (pattern1178 (x1, 
i1) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    case PLUS:
      res = pattern1180 (x1, 
i1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    case MINUS:
      res = pattern1181 (x1, 
i1);
      if (res >= 0)
        return res + 6; /* [6, 7] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1252 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (maybe_ne (SUBREG_BYTE (x3), 0)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[4] = x4;
      x5 = XEXP (x4, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x6 = XEXP (x4, 2);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      return pattern1251 (x1); /* [-1, 5] */

    default:
      return -1;
    }
}

int
pattern1262 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[4], i3))
    return -1;
  return 0;
}

int
pattern1271 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i4
      || !nonimmediate_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern1282 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1293 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || GET_MODE (x2) != i2
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1)
      || !const_4_or_8_to_11_operand (operands[4], E_SImode))
    return -1;
  return 0;
}

int
pattern1299 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1303 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  if (!vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1309 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (!rtx_equal_p (x4, operands[1]))
    return -1;
  x5 = XEXP (x3, 1);
  if (!rtx_equal_p (x5, operands[2]))
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XEXP (x7, 0);
  switch (GET_MODE (x8))
    {
    case E_QImode:
      return pattern1308 (x3, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern1308 (x3, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern1308 (x3, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !const_1_to_63_operand (operands[2], E_QImode)
          || !nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1329 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!general_reg_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  x4 = PATTERN (peep2_next_insn (2));
  x5 = XEXP (x4, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  x6 = XEXP (x4, 0);
  if (!rtx_equal_p (x6, operands[2]))
    return -1;
  return 0;
}

int
pattern1336 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  if (!general_reg_operand (operands[0], i1))
    return -1;
  switch (GET_CODE (x1))
    {
    case SET:
      x2 = XEXP (x1, 1);
      switch (GET_CODE (x2))
        {
        case CONST_INT:
          if (XWINT (x2, 0) != 0L)
            return -1;
          x3 = XEXP (x1, 0);
          if (GET_CODE (x3) != ZERO_EXTRACT)
            return -1;
          x4 = XEXP (x3, 1);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x5 = XEXP (x3, 2);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x6 = XEXP (x3, 0);
          operands[1] = x6;
          if (!int248_register_operand (operands[1], E_VOIDmode))
            return -1;
          switch (GET_MODE (x3))
            {
            case E_HImode:
              return 0;

            case E_SImode:
              return 1;

            case E_DImode:
              return 2;

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[2] = x2;
          x3 = XEXP (x1, 0);
          if (GET_CODE (x3) != STRICT_LOW_PART)
            return -1;
          x6 = XEXP (x3, 0);
          operands[1] = x6;
          res = pattern1328 ();
          if (res >= 0)
            return res + 3; /* [3, 4] */
          return -1;

        default:
          return -1;
        }

    case PARALLEL:
      if (XVECLEN (x1, 0) != 2)
        return -1;
      x7 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x7) != SET)
        return -1;
      x8 = XEXP (x7, 1);
      switch (GET_CODE (x8))
        {
        case PLUS:
          if (GET_MODE (x8) != i1
              || pattern1331 (x1) != 0)
            return -1;
          return 5;

        case IOR:
          if (GET_MODE (x8) != i1
              || pattern1331 (x1) != 0)
            return -1;
          return 6;

        case XOR:
          if (GET_MODE (x8) != i1
              || pattern1331 (x1) != 0)
            return -1;
          return 7;

        case UNSPEC:
          if (peep2_current_count < 3
              || peep2_current_count < 4
              || XVECLEN (x8, 0) != 2
              || XINT (x8, 1) != 40
              || GET_MODE (x8) != E_CCCmode)
            return -1;
          x9 = XVECEXP (x8, 0, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x10 = XEXP (x7, 0);
          if (GET_CODE (x10) != REG
              || REGNO (x10) != 17
              || GET_MODE (x10) != E_CCCmode)
            return -1;
          x11 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x11) != SET)
            return -1;
          x12 = XEXP (x11, 1);
          if (GET_CODE (x12) != NEG
              || GET_MODE (x12) != i1)
            return -1;
          x13 = XVECEXP (x8, 0, 0);
          operands[1] = x13;
          if (!general_reg_operand (operands[1], i1))
            return -1;
          x14 = XEXP (x12, 0);
          if (!rtx_equal_p (x14, operands[1]))
            return -1;
          x15 = XEXP (x11, 0);
          if (!rtx_equal_p (x15, operands[1]))
            return -1;
          x16 = PATTERN (peep2_next_insn (2));
          if (pattern1183 (x16, 
i1) != 0)
            return -1;
          return 8;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1395 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 2);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
      operands[4] = x3;
      x4 = XVECEXP (x1, 0, 1);
      operands[5] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          return 0;

        case E_V16SFmode:
          return 1;

        case E_V8DFmode:
          return 2;

        case E_V16HFmode:
          return 3;

        case E_V8HFmode:
          return 4;

        case E_V8SFmode:
          return 5;

        case E_V4SFmode:
          return 6;

        case E_V4DFmode:
          return 7;

        case E_V2DFmode:
          return 8;

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 1L)
        return -1;
      x4 = XVECEXP (x1, 0, 1);
      operands[4] = x4;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return 9;

        case E_V4SFmode:
          return 10;

        case E_V2DFmode:
          return 11;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1414 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !scratch_operand (operands[0], i1))
    return -1;
  return 0;
}

int
pattern1422 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case AND:
      return pattern1421 (x3); /* [-1, 1] */

    case PLUS:
      res = pattern1421 (x3);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      x6 = XEXP (x5, 0);
      operands[3] = x6;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x7 = XEXP (x5, 1);
      operands[2] = x7;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern198 (x3);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1436 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const_int_operand (operands[2], E_VOIDmode))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_SImode:
      return pattern1435 (x3, 
E_SImode); /* [-1, 2] */

    case E_DImode:
      res = pattern1435 (x3, 
E_DImode);
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1446 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x3, 2);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1457 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 12);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
    return -1;
  x3 = XVECEXP (x1, 0, 13);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x4 = XVECEXP (x1, 0, 14);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
    return -1;
  x5 = XVECEXP (x1, 0, 15);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  return 0;
}

int
pattern1464 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1471 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 4);
  operands[2] = x2;
  if (!const_4_to_7_operand (operands[2], E_VOIDmode))
    return -1;
  x3 = XVECEXP (x1, 0, 5);
  operands[3] = x3;
  if (!const_4_to_7_operand (operands[3], E_VOIDmode))
    return -1;
  x4 = XVECEXP (x1, 0, 6);
  operands[4] = x4;
  if (!const_4_to_7_operand (operands[4], E_VOIDmode))
    return -1;
  x5 = XVECEXP (x1, 0, 7);
  operands[5] = x5;
  if (!const_4_to_7_operand (operands[5], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1482 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[2], i1)
      || !scratch_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1493 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode)
          || !nonimmediate_operand (operands[2], E_V8HFmode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!register_operand (operands[1], E_V4SFmode)
          || !nonimmediate_operand (operands[2], E_V4SFmode))
        return -1;
      return 1;

    case E_V2DFmode:
      if (!register_operand (operands[1], E_V2DFmode)
          || !nonimmediate_operand (operands[2], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1507 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_carry_flag_operator (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1515 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case COMPARE:
      x4 = XEXP (x2, 0);
      if (GET_CODE (x4) != REG
          || REGNO (x4) != 17)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != SET)
        return -1;
      x6 = XEXP (x5, 1);
      if (GET_MODE (x6) != i1)
        return -1;
      x7 = XEXP (x5, 0);
      if (!rtx_equal_p (x7, operands[0]))
        return -1;
      x8 = PATTERN (peep2_next_insn (2));
      x9 = XEXP (x8, 0);
      if (!rtx_equal_p (x9, operands[1]))
        return -1;
      x10 = XEXP (x3, 0);
      switch (GET_CODE (x10))
        {
        case REG:
          return pattern1177 (x1, 
i1); /* [-1, 0] */

        case PLUS:
          if (pattern1178 (x1, 
i1) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case PLUS:
      res = pattern1180 (x1, 
i1);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      res = pattern1181 (x1, 
i1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1533 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1542 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i2
      || !sext_operand (operands[2], i1)
      || pattern714 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1552 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case UNSPEC:
      if (pnum_clobbers == NULL
          || XVECLEN (x1, 0) != 1
          || XINT (x1, 1) != 32)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      return 0;

    case CLOBBER:
      x3 = XEXP (x1, 0);
      if (GET_CODE (x3) != REG
          || REGNO (x3) != 17
          || GET_MODE (x3) != E_CCmode)
        return -1;
      return 1;

    case USE:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x1, 0);
      operands[4] = x3;
      if (!register_operand (operands[4], E_SImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1563 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1571 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || pattern1570 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1580 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x5 = XEXP (x3, 2);
  if (GET_MODE (x5) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || !register_operand (operands[5], E_QImode))
    return -1;
  return 0;
}

int
pattern1593 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1600 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[6], E_QImode)
      || !vsib_mem_operator (operands[5], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1599 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1599 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1611 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1617 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1626 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      return pattern1625 (x1, 
E_V8HFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern1625 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V2DFmode:
      if (pattern1625 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1635 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1634 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1634 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1649 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (XWINT (x2, 0) != 2L)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (XWINT (x3, 0) != 2L)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (XWINT (x5, 0) != 4L)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (XWINT (x6, 0) != 6L)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (XWINT (x7, 0) != 6L)
    return -1;
  return 0;
}

int
pattern1661 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_DImode))
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_DImode))
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != E_DImode)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_TImode)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != E_TImode)
    return -1;
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  if (!register_operand (operands[2], E_DImode))
    return -1;
  x8 = XEXP (x5, 1);
  operands[4] = x8;
  if (!const_0_to_255_operand (operands[4], E_QImode))
    return -1;
  return 0;
}

int
pattern1673 (rtx x1, int i1, int i2, int i3, int i4, int i5)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 12);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 13);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 14);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 15);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x6 = XVECEXP (x1, 0, 16);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + i5])
    return -1;
  return 0;
}

int
pattern1683 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V16SImode:
      if (!register_operand (operands[2], E_V16SImode)
          || !register_operand (operands[6], E_HImode)
          || !register_operand (operands[3], E_V16SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode)
          || !register_operand (operands[6], E_QImode)
          || !register_operand (operands[3], E_V8SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1695 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!vsib_mem_operator (operands[5], i1)
      || !register_operand (operands[6], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !scratch_operand (operands[1], E_QImode))
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return 0;

    case E_DImode:
      return 1;

    default:
      return -1;
    }
}

int
pattern1706 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V4SImode:
      if (!register_operand (operands[2], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1713 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[3] = x5;
  if (!any_QIreg_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1720 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 2);
  if (GET_MODE (x6) != i1
      || !register_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1728 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1)
      || !scratch_operand (operands[2], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1727 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1727 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1744 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1751 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (XWINT (x2, 0) != 1L)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (XWINT (x3, 0) != 2L)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  if (XWINT (x4, 0) != 3L)
    return -1;
  x5 = XVECEXP (x1, 0, 4);
  if (XWINT (x5, 0) != 4L)
    return -1;
  x6 = XVECEXP (x1, 0, 5);
  if (XWINT (x6, 0) != 5L)
    return -1;
  x7 = XVECEXP (x1, 0, 6);
  if (XWINT (x7, 0) != 6L)
    return -1;
  x8 = XVECEXP (x1, 0, 7);
  if (XWINT (x8, 0) != 7L)
    return -1;
  x9 = XVECEXP (x1, 0, 8);
  if (XWINT (x9, 0) != 8L)
    return -1;
  x10 = XVECEXP (x1, 0, 9);
  if (XWINT (x10, 0) != 9L)
    return -1;
  x11 = XVECEXP (x1, 0, 10);
  if (XWINT (x11, 0) != 10L)
    return -1;
  x12 = XVECEXP (x1, 0, 11);
  if (XWINT (x12, 0) != 11L)
    return -1;
  x13 = XVECEXP (x1, 0, 12);
  if (XWINT (x13, 0) != 12L)
    return -1;
  x14 = XVECEXP (x1, 0, 13);
  if (XWINT (x14, 0) != 13L)
    return -1;
  x15 = XVECEXP (x1, 0, 14);
  if (XWINT (x15, 0) != 14L)
    return -1;
  x16 = XVECEXP (x1, 0, 15);
  if (XWINT (x16, 0) != 15L)
    return -1;
  return 0;
}

int
pattern1769 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_SImode:
      if (!vsib_address_operand (operands[4], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!vsib_address_operand (operands[4], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1776 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !vsib_mem_operator (operands[7], i2)
      || !register_operand (operands[5], i1)
      || !scratch_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1775 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1775 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1789 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  if (!const_int_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (XVECLEN (x3, 0) != 4
      || XINT (x3, 1) != 109)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC_VOLATILE
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != 109)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x7) != SET)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != UNSPEC_VOLATILE
      || XVECLEN (x8, 0) != 1
      || XINT (x8, 1) != 109
      || GET_MODE (x8) != E_CCZmode)
    return -1;
  x9 = XVECEXP (x8, 0, 0);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x10 = XEXP (x7, 0);
  if (GET_CODE (x10) != REG
      || REGNO (x10) != 17
      || GET_MODE (x10) != E_CCZmode)
    return -1;
  x11 = XEXP (x2, 0);
  operands[2] = x11;
  x12 = XVECEXP (x3, 0, 0);
  operands[3] = x12;
  x13 = XVECEXP (x3, 0, 2);
  operands[4] = x13;
  x14 = XVECEXP (x3, 0, 3);
  operands[5] = x14;
  if (!const_int_operand (operands[5], E_SImode))
    return -1;
  x15 = XVECEXP (x3, 0, 1);
  if (!rtx_equal_p (x15, operands[2]))
    return -1;
  x16 = XEXP (x4, 0);
  if (!rtx_equal_p (x16, operands[3]))
    return -1;
  x17 = PATTERN (peep2_next_insn (2));
  x18 = XEXP (x17, 1);
  x19 = XEXP (x18, 0);
  if (!rtx_equal_p (x19, operands[2]))
    return -1;
  x20 = XEXP (x18, 1);
  if (!rtx_equal_p (x20, operands[1]))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_QImode:
      return pattern1788 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern1788 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern1788 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern1788 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1818 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V8SImode:
      if (!register_operand (operands[3], E_V8SImode)
          || !register_operand (operands[4], E_V8SFmode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode)
          || !register_operand (operands[4], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1825 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_MODE (x4) != i2
      || !ix86_carry_flag_operator (operands[4], i2)
      || !const_scalar_int_operand (operands[6], i2)
      || !nonimmediate_operand (operands[0], i1))
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i1)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i1
      || !ix86_carry_flag_operator (operands[5], i1)
      || !x86_64_immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1836 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_15_operand (operands[2], E_VOIDmode)
      || !const_0_to_15_operand (operands[3], E_VOIDmode)
      || !const_0_to_15_operand (operands[4], E_VOIDmode)
      || !const_0_to_15_operand (operands[5], E_VOIDmode)
      || !const_0_to_15_operand (operands[6], E_VOIDmode)
      || !const_0_to_15_operand (operands[7], E_VOIDmode)
      || !const_0_to_15_operand (operands[8], E_VOIDmode)
      || !const_0_to_15_operand (operands[9], E_VOIDmode)
      || !const_0_to_15_operand (operands[10], E_VOIDmode)
      || !const_0_to_15_operand (operands[11], E_VOIDmode)
      || !const_0_to_15_operand (operands[12], E_VOIDmode)
      || !const_0_to_15_operand (operands[13], E_VOIDmode)
      || !const_0_to_15_operand (operands[14], E_VOIDmode)
      || !const_0_to_15_operand (operands[15], E_VOIDmode)
      || !const_0_to_15_operand (operands[16], E_VOIDmode)
      || !const_0_to_15_operand (operands[17], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1844 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 28);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 29);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 30);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 31);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern1849 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[4], i1)
      || GET_MODE (x1) != i1
      || !nonmemory_operand (operands[2], i1))
    return -1;
  x2 = PATTERN (peep2_next_insn (3));
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[4]))
    return -1;
  x4 = PATTERN (peep2_next_insn (4));
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  operands[5] = x6;
  x7 = XEXP (x5, 1);
  operands[6] = x7;
  return 0;
}

int
pattern1856 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x7 = XEXP (x4, 1);
  if (GET_MODE (x7) != i2
      || !x86_64_sext_operand (operands[2], i1)
      || pattern1854 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1864 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  return 0;
}

 int
recog_1 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x2, 1);
  switch (GET_CODE (x6))
    {
    case COMPARE:
      if (GET_MODE (x6) != E_CCmode)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != MINUS)
        return -1;
      x8 = XEXP (x6, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != UNSPEC
          || XVECLEN (x9, 0) != 1
          || XINT (x9, 1) != 109
          || GET_MODE (x9) != E_CCmode)
        return -1;
      x10 = XEXP (x1, 0);
      operands[0] = x10;
      if (!flags_reg_operand (operands[0], E_CCmode)
          || GET_MODE (x2) != E_CCmode
          || !comparison_operator (operands[1], E_VOIDmode)
          || GET_MODE (x4) != E_CCmode)
        return -1;
      x11 = XEXP (x7, 0);
      operands[2] = x11;
      x12 = XEXP (x7, 1);
      operands[3] = x12;
      x13 = XVECEXP (x9, 0, 0);
      operands[4] = x13;
      if (!const_0_to_15_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (x7))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[2], E_QImode)
              || !general_operand (operands[3], E_QImode)
              || !
#line 1539 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 1; /* ccmpqi */

        case E_HImode:
          if (!nonimmediate_operand (operands[2], E_HImode)
              || !general_operand (operands[3], E_HImode)
              || !
#line 1539 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 2; /* ccmphi */

        case E_SImode:
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !x86_64_general_operand (operands[3], E_SImode)
              || !
#line 1539 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 3; /* ccmpsi */

        case E_DImode:
          if (!nonimmediate_operand (operands[2], E_DImode)
              || !x86_64_general_operand (operands[3], E_DImode)
              || !(
#line 1539 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4; /* ccmpdi */

        default:
          return -1;
        }

    case LABEL_REF:
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return -1;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC
          || !ix86_comparison_operator (operands[1], E_VOIDmode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[0] = x7;
      return 1458; /* *jcc */

    case REG:
    case SUBREG:
    case MEM:
      operands[2] = x6;
      x10 = XEXP (x1, 0);
      operands[0] = x10;
      x9 = XEXP (x2, 2);
      operands[3] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (pattern1185 (x2, 
E_HImode) != 0
              || !
#line 26357 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1803; /* *movhicc_noc */

        case E_QImode:
          if (pattern1186 (x2) != 0
              || !
#line 26431 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && !TARGET_PARTIAL_REG_STALL))
            return -1;
          return 1808; /* *movqicc_noc */

        case E_XFmode:
          if (!register_operand (operands[0], E_XFmode)
              || GET_MODE (x2) != E_XFmode
              || !fcmov_comparison_operator (operands[1], E_VOIDmode)
              || !register_operand (operands[2], E_XFmode)
              || !register_operand (operands[3], E_XFmode)
              || !
#line 26625 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE))
            return -1;
          return 1810; /* *movxfcc_1 */

        case E_DFmode:
          if (!register_operand (operands[0], E_DFmode)
              || pattern1244 (x2, 
E_DFmode) != 0
              || !
#line 26640 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1811; /* *movdfcc_1 */

        case E_SFmode:
          if (!register_operand (operands[0], E_SFmode)
              || pattern1244 (x2, 
E_SFmode) != 0
              || !
#line 26675 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1812; /* *movsfcc_1_387 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_14 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XVECLEN (x2, 0))
    {
    case 1:
      return recog_13 (x1, insn, pnum_clobbers);

    case 2:
      return recog_12 (x1, insn, pnum_clobbers);

    case 3:
      switch (XINT (x2, 1))
        {
        case 39:
          if (pnum_clobbers == NULL
              || GET_MODE (x2) != E_CCGZmode)
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          if (GET_CODE (x3) != LTU)
            return -1;
          x4 = XEXP (x3, 0);
          if (GET_CODE (x4) != REG
              || REGNO (x4) != 17
              || GET_MODE (x4) != E_CCmode)
            return -1;
          x5 = XEXP (x3, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x6 = XEXP (x1, 0);
          if (GET_CODE (x6) != REG
              || REGNO (x6) != 17
              || GET_MODE (x6) != E_CCGZmode)
            return -1;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          switch (GET_MODE (operands[1]))
            {
            case E_SImode:
              if (!register_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || GET_MODE (x3) != E_SImode
                  || !
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 521; /* subsi3_carry_ccgz */

            case E_DImode:
              if (!register_operand (operands[1], E_DImode)
                  || !x86_64_general_operand (operands[2], E_DImode)
                  || GET_MODE (x3) != E_DImode
                  || !
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 522; /* subdi3_carry_ccgz */

            default:
              return -1;
            }

        case 59:
          return recog_11 (x1, insn, pnum_clobbers);

        case 48:
          if (GET_MODE (x2) != E_HFmode)
            return -1;
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          if (!nonimmediate_operand (operands[0], E_HFmode))
            return -1;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          if (!nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          if (!nonimm_or_0_operand (operands[2], E_HFmode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!register_operand (operands[3], E_QImode)
              || !
#line 26591 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 1809; /* movhf_mask */

        case 51:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          x3 = XVECEXP (x2, 0, 2);
          switch (GET_CODE (x3))
            {
            case LT:
              switch (pattern731 (x2))
                {
                case 0:
                  if (
#line 26824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[3])
      && rtx_equal_p (operands[2], operands[4]))
  && ix86_pre_reload_split ()))
                    return 1827; /* *ieee_maxsf3_1 */
                  if (!
#line 26845 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[4])
      && rtx_equal_p (operands[2], operands[3]))
  && ix86_pre_reload_split ()))
                    return -1;
                  return 1829; /* *ieee_minsf3_1 */

                case 1:
                  if (
#line 26824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[3])
      && rtx_equal_p (operands[2], operands[4]))
  && ix86_pre_reload_split ()))
                    return 1828; /* *ieee_maxdf3_1 */
                  if (!
#line 26845 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[4])
      && rtx_equal_p (operands[2], operands[3]))
  && ix86_pre_reload_split ()))
                    return -1;
                  return 1830; /* *ieee_mindf3_1 */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              operands[3] = x3;
              switch (GET_MODE (operands[0]))
                {
                case E_V2SFmode:
                  if (pattern956 (x2, 
E_V2SFmode) == 0
                      && 
#line 1317 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                    return 2075; /* mmx_blendvps */
                  break;

                case E_V8QImode:
                  if (pattern956 (x2, 
E_V8QImode) == 0
                      && 
#line 4314 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                    return 2241; /* mmx_pblendvb_v8qi */
                  break;

                case E_V4QImode:
                  if (pattern956 (x2, 
E_V4QImode) == 0
                      && 
#line 4390 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2245; /* mmx_pblendvb_v4qi */
                  break;

                case E_V2QImode:
                  if (pattern956 (x2, 
E_V2QImode) == 0
                      && 
#line 4390 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2246; /* mmx_pblendvb_v2qi */
                  break;

                case E_V2HImode:
                  if (pattern956 (x2, 
E_V2HImode) == 0
                      && 
#line 4390 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2247; /* mmx_pblendvb_v2hi */
                  break;

                case E_SFmode:
                  if (pattern956 (x2, 
E_SFmode) == 0
                      && 
#line 23547 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8614; /* sse4_1_blendvss */
                  break;

                case E_DFmode:
                  if (pattern956 (x2, 
E_DFmode) == 0
                      && 
#line 23547 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8615; /* sse4_1_blendvsd */
                  break;

                default:
                  break;
                }
              if (GET_CODE (x3) != SUBREG)
                return -1;
              switch (pattern841 (x2))
                {
                case 0:
                  if (!
#line 4366 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2243; /* *mmx_pblendvb_v8qi_2 */

                case 1:
                  if (!
#line 4366 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2244; /* *mmx_pblendvb_v8qi_2 */

                case 2:
                  if (!
#line 4442 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2251; /* *mmx_pblendvb_v4qi_2 */

                default:
                  return -1;
                }

            case EQ:
              switch (pattern733 (x2))
                {
                case 0:
                  if (!
#line 4338 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2242; /* *mmx_pblendvb_v8qi_1 */

                case 1:
                  if (!
#line 4414 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2248; /* *mmx_pblendvb_v4qi_1 */

                case 2:
                  if (!
#line 4414 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2249; /* *mmx_pblendvb_v2qi_1 */

                case 3:
                  if (!
#line 4414 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2250; /* *mmx_pblendvb_v2hi_1 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 50:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[2] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[1] = x8;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V2SFmode:
              if (pattern957 (x2, 
E_V2SFmode) != 0
                  || !
#line 1261 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                return -1;
              return 2072; /* sse4_1_insertps_v2sf */

            case E_V2SImode:
              if (pattern957 (x2, 
E_V2SImode) != 0
                  || !
#line 1261 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                return -1;
              return 2073; /* sse4_1_insertps_v2si */

            default:
              return -1;
            }

        case 53:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!nonimmediate_operand (operands[3], E_V16QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V8QImode:
              if (pattern958 (x2, 
E_V8QImode) != 0
                  || !
#line 4512 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP && TARGET_MMX_WITH_SSE))
                return -1;
              return 2263; /* mmx_ppermv64 */

            case E_V4QImode:
              if (pattern958 (x2, 
E_V4QImode) != 0
                  || !
#line 4524 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
                return -1;
              return 2264; /* mmx_ppermv32 */

            default:
              return -1;
            }

        case 47:
          if (GET_MODE (x2) != E_V8QImode)
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          if (GET_CODE (x3) != MEM
              || GET_MODE (x3) != E_V8QImode)
            return -1;
          x6 = XEXP (x1, 0);
          if (GET_CODE (x6) != MEM
              || GET_MODE (x6) != E_V8QImode)
            return -1;
          x9 = XEXP (x6, 0);
          operands[0] = x9;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          switch (pattern1059 (x2, 
E_V8QImode))
            {
            case 0:
              if (!(
#line 6860 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE || TARGET_3DNOW_A) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 2385; /* *mmx_maskmovq */

            case 1:
              if (!(
#line 6860 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE || TARGET_3DNOW_A) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 2386; /* *mmx_maskmovq */

            default:
              return -1;
            }

        case 157:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          switch (GET_CODE (x7))
            {
            case CONST_INT:
            case CONST_DOUBLE:
            case CONST_VECTOR:
            case REG:
            case SUBREG:
            case MEM:
              operands[1] = x7;
              x3 = XVECEXP (x2, 0, 2);
              if (GET_CODE (x3) != CONST_INT)
                return -1;
              x8 = XVECEXP (x2, 0, 1);
              operands[2] = x8;
              if (XWINT (x3, 0) == 0L)
                {
                  switch (pattern955 (x2))
                    {
                    case 0:
                      if ((
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3462; /* *avx512vl_eqv16qi3_1 */
                      break;

                    case 1:
                      if ((
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3474; /* *avx512vl_eqv16hi3_1 */
                      break;

                    case 2:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 3530; /* *avx512f_eqv16si3_1 */
                      break;

                    case 3:
                      if ((
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3478; /* *avx512vl_eqv8hi3_1 */
                      break;

                    case 4:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3534; /* *avx512vl_eqv8si3_1 */
                      break;

                    case 5:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3538; /* *avx512vl_eqv4si3_1 */
                      break;

                    case 6:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 3542; /* *avx512f_eqv8di3_1 */
                      break;

                    case 7:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3546; /* *avx512vl_eqv4di3_1 */
                      break;

                    case 8:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3550; /* *avx512vl_eqv2di3_1 */
                      break;

                    default:
                      break;
                    }
                }
              operands[3] = x3;
              if (!const_0_to_7_operand (operands[3], E_SImode))
                return -1;
              switch (pattern67 (x2))
                {
                case 0:
                  if (!(
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3482; /* avx512vl_ucmpv16qi3 */

                case 1:
                  if (!(
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3488; /* avx512vl_ucmpv16hi3 */

                case 2:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3552; /* avx512f_ucmpv16si3 */

                case 3:
                  if (!(
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3490; /* avx512vl_ucmpv8hi3 */

                case 4:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3554; /* avx512vl_ucmpv8si3 */

                case 5:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3556; /* avx512vl_ucmpv4si3 */

                case 6:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3558; /* avx512f_ucmpv8di3 */

                case 7:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3560; /* avx512vl_ucmpv4di3 */

                case 8:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3562; /* avx512vl_ucmpv2di3 */

                default:
                  return -1;
                }

            case US_MINUS:
              switch (pattern420 (x2))
                {
                case 0:
                  if (!(
#line 4792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V16QImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3609; /* *avx512vl_ucmpv16qi3_1 */

                case 1:
                  if (!(
#line 4792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V16HImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3615; /* *avx512vl_ucmpv16hi3_1 */

                case 2:
                  if (!(
#line 4792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V8HImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3617; /* *avx512vl_ucmpv8hi3_1 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 52:
          if (pattern59 (x1, pnum_clobbers, 
E_V8QImode) != 0)
            return -1;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          if (!register_mmxmem_operand (operands[2], E_V8QImode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[4] = x3;
          if (!reg_or_const_vector_operand (operands[4], E_V4SImode)
              || !
#line 23153 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          *pnum_clobbers = 1;
          return 8557; /* *ssse3_pshufbv8qi3 */

        case 132:
          if (pnum_clobbers == NULL
              || pattern251 (x1) != 0
              || !nonimmediate_operand (operands[3], E_V16QImode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[4] = x3;
          if (!const_0_to_255_operand (operands[4], E_SImode)
              || !
#line 26074 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
            return -1;
          *pnum_clobbers = 2;
          return 8911; /* sse4_2_pcmpistr_cconly */

        default:
          return -1;
        }

    case 5:
      if (pnum_clobbers == NULL
          || XINT (x2, 1) != 131
          || pattern251 (x1) != 0
          || !register_operand (operands[3], E_SImode))
        return -1;
      x3 = XVECEXP (x2, 0, 2);
      operands[4] = x3;
      if (!nonimmediate_operand (operands[4], E_V16QImode))
        return -1;
      x10 = XVECEXP (x2, 0, 3);
      operands[5] = x10;
      if (!register_operand (operands[5], E_SImode))
        return -1;
      x11 = XVECEXP (x2, 0, 4);
      operands[6] = x11;
      if (!const_0_to_255_operand (operands[6], E_SImode)
          || !
#line 25949 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
        return -1;
      *pnum_clobbers = 2;
      return 8907; /* sse4_2_pcmpestr_cconly */

    default:
      return -1;
    }
}

 int
recog_28 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_DFmode:
      if (GET_MODE (x3) != E_DFmode)
        return -1;
      if (nonimm_ssenomem_operand (operands[0], E_DFmode)
          && nonimmediate_operand (operands[1], E_SFmode)
          && 
#line 5307 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)))
        return 200; /* *extendsfdf2 */
      if (!register_operand (operands[0], E_DFmode)
          || !nonimmediate_operand (operands[1], E_HFmode)
          || !
#line 5463 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
        return -1;
      return 202; /* *extendhfdf2 */

    case E_SFmode:
      if (!register_operand (operands[0], E_SFmode)
          || GET_MODE (x3) != E_SFmode
          || !nonimmediate_operand (operands[1], E_HFmode)
          || !
#line 5463 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
        return -1;
      return 201; /* *extendhfsf2 */

    case E_XFmode:
      if (!nonimmediate_operand (operands[0], E_XFmode))
        return -1;
      switch (pattern425 (x3, 
E_XFmode))
        {
        case 0:
          if (!
#line 5525 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 204; /* *extendsfxf2_i387 */

        case 1:
          if (!
#line 5525 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 205; /* *extenddfxf2_i387 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_30 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (GET_MODE (x3) != E_SImode)
        return -1;
      if (register_operand (operands[0], E_SImode))
        {
          switch (pattern263 ())
            {
            case 0:
              if (
#line 5781 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
                return 212; /* fix_trunchfsi2 */
              break;

            case 1:
              if (
#line 5957 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)))
                return 225; /* fix_truncsfsi_sse */
              break;

            case 2:
              if (
#line 5957 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)))
                return 227; /* fix_truncdfsi_sse */
              break;

            default:
              break;
            }
        }
      if (pnum_clobbers == NULL
          || !nonimmediate_operand (operands[0], E_SImode)
          || !register_operand (operands[1], E_VOIDmode))
        return -1;
      if (
#line 5987 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || SImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 230; /* fix_truncsi_i387_fisttp */
        }
      if (!
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || SImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 233; /* *fix_truncsi_i387_1 */

    case E_DImode:
      if (GET_MODE (x3) != E_DImode)
        return -1;
      if (register_operand (operands[0], E_DImode))
        {
          switch (pattern263 ())
            {
            case 0:
              if ((
#line 5781 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 214; /* fix_trunchfdi2 */
              break;

            case 1:
              if ((
#line 5957 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 226; /* fix_truncsfdi_sse */
              break;

            case 2:
              if ((
#line 5957 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 228; /* fix_truncdfdi_sse */
              break;

            default:
              break;
            }
        }
      if (pnum_clobbers == NULL
          || !nonimmediate_operand (operands[0], E_DImode)
          || !register_operand (operands[1], E_VOIDmode))
        return -1;
      if (
#line 5987 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || DImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 231; /* fix_truncdi_i387_fisttp */
        }
      if (!
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || DImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 234; /* *fix_truncdi_i387_1 */

    case E_HImode:
      if (pattern262 (x3, pnum_clobbers, 
E_VOIDmode, 
E_HImode) != 0)
        return -1;
      if (
#line 5987 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || HImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 229; /* fix_trunchi_i387_fisttp */
        }
      if (!
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || HImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 232; /* *fix_trunchi_i387_1 */

    case E_V2SImode:
      if (!register_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode
          || !vector_operand (operands[1], E_V2DFmode)
          || !
#line 8922 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return -1;
      return 4828; /* sse2_cvttpd2pi */

    default:
      return -1;
    }
}

 int
recog_38 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case XOR:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (pattern739 (x2, 
E_HImode) != 0
              || !
#line 13621 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 835; /* *notxorhi_1 */

        case E_QImode:
          if (pattern739 (x2, 
E_QImode) != 0
              || !
#line 13821 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 871; /* *notxorqi_1 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (pattern40 (x1))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_TImode:
              if (!nonimmediate_operand (operands[0], E_TImode)
                  || GET_MODE (x2) != E_TImode
                  || !nonimmediate_operand (operands[1], E_TImode)
                  || !(
#line 14990 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1031; /* *one_cmplti2_doubleword */

            case E_HImode:
              if (!nonimmediate_operand (operands[0], E_HImode)
                  || GET_MODE (x2) != E_HImode
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 15003 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1032; /* *one_cmplhi2_1 */

            case E_QImode:
              if (!nonimmediate_operand (operands[0], E_QImode)
                  || GET_MODE (x2) != E_QImode
                  || !nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 15047 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1041; /* *one_cmplqi2_1 */

            case E_V4QImode:
              if (!register_operand (operands[0], E_V4QImode)
                  || GET_MODE (x2) != E_V4QImode
                  || !register_operand (operands[1], E_V4QImode))
                return -1;
              return 2265; /* one_cmplv4qi2 */

            case E_V2QImode:
              if (!register_operand (operands[0], E_V2QImode)
                  || GET_MODE (x2) != E_V2QImode
                  || !register_operand (operands[1], E_V2QImode))
                return -1;
              return 2266; /* one_cmplv2qi2 */

            case E_V2HImode:
              if (!register_operand (operands[0], E_V2HImode)
                  || GET_MODE (x2) != E_V2HImode
                  || !register_operand (operands[1], E_V2HImode))
                return -1;
              return 2267; /* one_cmplv2hi2 */

            default:
              return -1;
            }

        case 1:
          if (!
#line 15073 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 1042; /* *one_cmplqi_1_slp */

        case 2:
          if (!
#line 15073 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 1043; /* *one_cmplhi_1_slp */

        default:
          return -1;
        }

    case ZERO_EXTRACT:
      if (pnum_clobbers == NULL
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XEXP (x3, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x4 = XEXP (x1, 0);
      if (GET_CODE (x4) != ZERO_EXTRACT
          || GET_MODE (x4) != E_DImode)
        return -1;
      x7 = XEXP (x4, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x8 = XEXP (x4, 0);
      operands[0] = x8;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x9 = XEXP (x4, 2);
      operands[1] = x9;
      if (!const_0_to_63_operand (operands[1], E_QImode)
          || GET_MODE (x2) != E_DImode)
        return -1;
      x5 = XEXP (x3, 0);
      if (!rtx_equal_p (x5, operands[0]))
        return -1;
      x10 = XEXP (x3, 2);
      if (!rtx_equal_p (x10, operands[1])
          || !
#line 19072 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && (TARGET_USE_BT || reload_completed)))
        return -1;
      *pnum_clobbers = 1;
      return 1415; /* *btcq_imm */

    case UNSPEC:
      if (XVECLEN (x3, 0) != 3)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x11 = XVECEXP (x3, 0, 0);
      operands[1] = x11;
      x12 = XVECEXP (x3, 0, 1);
      operands[2] = x12;
      x13 = XVECEXP (x3, 0, 2);
      operands[3] = x13;
      switch (XINT (x3, 1))
        {
        case 59:
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              switch (pattern960 (x2))
                {
                case 0:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3381; /* *avx512f_cmpv16si3 */

                case 1:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3388; /* *avx512vl_cmpv16hf3 */

                case 2:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3390; /* *avx512f_cmpv16sf3 */

                case 3:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3446; /* *avx512vl_cmpv16qi3 */

                case 4:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3452; /* *avx512vl_cmpv16hi3 */

                default:
                  return -1;
                }

            case E_QImode:
              switch (pattern961 (x2))
                {
                case 0:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3382; /* *avx512vl_cmpv8si3 */

                case 1:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3383; /* *avx512vl_cmpv4si3 */

                case 2:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3384; /* *avx512f_cmpv8di3 */

                case 3:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3385; /* *avx512vl_cmpv4di3 */

                case 4:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3386; /* *avx512vl_cmpv2di3 */

                case 5:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3389; /* *avx512fp16_cmpv8hf3 */

                case 6:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3391; /* *avx512vl_cmpv8sf3 */

                case 7:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3392; /* *avx512vl_cmpv4sf3 */

                case 8:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3393; /* *avx512f_cmpv8df3 */

                case 9:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3394; /* *avx512vl_cmpv4df3 */

                case 10:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3395; /* *avx512vl_cmpv2df3 */

                case 11:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3454; /* *avx512vl_cmpv8hi3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 157:
          if (!const_0_to_7_operand (operands[3], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              switch (pattern1064 (x2))
                {
                case 0:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3447; /* *avx512vl_cmpv16qi3 */

                case 1:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3453; /* *avx512vl_cmpv16hi3 */

                case 2:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3600; /* *avx512f_ucmpv16si3 */

                default:
                  return -1;
                }

            case E_QImode:
              switch (pattern1065 (x2))
                {
                case 0:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3455; /* *avx512vl_cmpv8hi3 */

                case 1:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3601; /* *avx512vl_ucmpv8si3 */

                case 2:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3602; /* *avx512vl_ucmpv4si3 */

                case 3:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3603; /* *avx512f_ucmpv8di3 */

                case 4:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3604; /* *avx512vl_ucmpv4di3 */

                case 5:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3605; /* *avx512vl_ucmpv2di3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_55 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x3;
      res = recog_54 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (pnum_clobbers == NULL
          || GET_CODE (x3) != SUBREG
          || maybe_ne (SUBREG_BYTE (x3), 0)
          || GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          operands[3] = x4;
          x5 = XEXP (x4, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x6 = XEXP (x4, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x7 = XEXP (x2, 1);
          if (pattern596 (x7) != 0)
            return -1;
          x8 = XEXP (x7, 0);
          operands[4] = x8;
          x9 = XEXP (x8, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x10 = XEXP (x8, 2);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8]
              || GET_MODE (x2) != E_QImode)
            return -1;
          switch (pattern1251 (x1))
            {
            case 0:
              if (!
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 408; /* *subqi_exthi_2_slp */

            case 1:
              if (!
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 409; /* *subqi_extsi_2_slp */

            case 2:
              if (!(
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 410; /* *subqi_extdi_2_slp */

            case 3:
              *pnum_clobbers = 1;
              return 419; /* *subqi_ext2hi_0 */

            case 4:
              *pnum_clobbers = 1;
              return 420; /* *subqi_ext2si_0 */

            case 5:
              if (!
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 421; /* *subqi_ext2di_0 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case MINUS:
      if (pnum_clobbers == NULL)
        return -1;
      x11 = XEXP (x1, 0);
      operands[0] = x11;
      switch (pattern291 (x2))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern1345 (x2, 
E_QImode) != 0
                  || !
#line 9289 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 487; /* subqi3_carry */

            case E_HImode:
              if (pattern1345 (x2, 
E_HImode) != 0
                  || !
#line 9289 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 488; /* subhi3_carry */

            default:
              return -1;
            }

        case 1:
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern1256 (x2, 
E_QImode) != 0
                  || !
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 570; /* *subqi3_eq */

            case E_HImode:
              if (pattern1256 (x2, 
E_HImode) != 0
                  || !
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 571; /* *subhi3_eq */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      switch (pattern91 (x1))
        {
        case 0:
          x4 = XEXP (x3, 0);
          operands[1] = x4;
          if (pattern962 (x2) != 0)
            return -1;
          x7 = XEXP (x2, 1);
          x8 = XEXP (x7, 0);
          if (!rtx_equal_p (x8, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (pattern1494 (x2, 
E_SFmode, 
E_V2SFmode) != 0
                  || !
#line 1058 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE3 && TARGET_MMX_WITH_SSE && ix86_partial_vec_fp_math
   && ix86_pre_reload_split ()))
                return -1;
              return 2067; /* *mmx_hsubv2sf3_low */

            case E_DFmode:
              if (pattern1494 (x2, 
E_DFmode, 
E_V2DFmode) != 0
                  || !
#line 3772 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3 && TARGET_V2DF_REDUCTION_PREFER_HADDPD))
                return -1;
              return 3154; /* *sse3_hsubv2df3_low */

            default:
              return -1;
            }

        case 1:
          switch (pattern847 (x2))
            {
            case 0:
              if (!
#line 22618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
                return -1;
              return 8524; /* ssse3_phsubwv4hi3 */

            case 1:
              if (!
#line 22705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
                return -1;
              return 8531; /* ssse3_phsubdv2si3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_62 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  x5 = XEXP (x2, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      return recog_61 (x1, insn, pnum_clobbers);

    case VEC_CONCAT:
      switch (pattern275 (x2))
        {
        case 0:
          x6 = XVECEXP (x3, 0, 1);
          if (GET_CODE (x6) == CONST_INT)
            {
              switch (pattern966 (x2))
                {
                case 0:
                  if (
#line 1691 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
                    return 2087; /* *vec_interleave_lowv2sf */
                  break;

                case 1:
                  if (
#line 4991 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return 2303; /* mmx_punpckldq */
                  break;

                case 2:
                  if (
#line 1708 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
                    return 2088; /* *vec_interleave_highv2sf */
                  break;

                case 3:
                  if (
#line 4970 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return 2302; /* mmx_punpckhdq */
                  break;

                default:
                  break;
                }
            }
          x7 = XVECEXP (x3, 0, 0);
          operands[3] = x7;
          switch (pattern967 (x2))
            {
            case 0:
              if (!
#line 6197 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2368; /* *punpckwd */

            case 1:
              if (!
#line 6197 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2369; /* *punpckwd */

            case 2:
              if (!
#line 6197 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2370; /* *punpckwd */

            default:
              return -1;
            }

        case 1:
          if (!
#line 4850 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2296; /* mmx_punpckhbw */

        case 2:
          if (!
#line 4890 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2298; /* mmx_punpcklbw */

        case 3:
          if (!
#line 4871 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2297; /* mmx_punpckhbw_low */

        case 4:
          if (!
#line 4928 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2300; /* mmx_punpckhwd */

        case 5:
          if (!
#line 4911 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2299; /* mmx_punpcklbw_low */

        case 6:
          if (!
#line 4949 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2301; /* mmx_punpcklwd */

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern276 (x2) != 0
          || !
#line 8409 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE))
        return -1;
      return 4716; /* sse_cvtps2pi */

    case FIX:
      if (pattern278 (x2) != 0
          || !
#line 8473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE))
        return -1;
      return 4718; /* sse_cvttps2pi */

    default:
      return -1;
    }
}

 int
recog_66 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 1);
  operands[2] = x4;
  x5 = XEXP (x3, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      operands[1] = x5;
      x6 = XEXP (x3, 2);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 5918 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3760; /* *fma_fmadd_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 5946 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3775; /* *fma_fmadd_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 5918 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3761; /* *fma_fmadd_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 5946 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3784; /* *fma_fmadd_df */

            case E_HFmode:
              if (pattern857 (x3, 
E_HFmode) != 0
                  || !(
#line 5946 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3774; /* *fma_fmadd_hf */

            default:
              return -1;
            }

        case NEG:
          x7 = XEXP (x6, 0);
          operands[3] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode
                  || GET_MODE (x6) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3823; /* *fma_fmsub_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3838; /* *fma_fmsub_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode
                  || GET_MODE (x6) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3824; /* *fma_fmsub_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3847; /* *fma_fmsub_df */

            case E_HFmode:
              if (pattern858 (x3, 
E_HFmode) != 0
                  || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3837; /* *fma_fmsub_hf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NEG:
      x8 = XEXP (x5, 0);
      operands[1] = x8;
      x6 = XEXP (x3, 2);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode
                  || GET_MODE (x5) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6123 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3886; /* *fma_fnmadd_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3901; /* *fma_fnmadd_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode
                  || GET_MODE (x5) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6123 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3887; /* *fma_fnmadd_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3910; /* *fma_fnmadd_df */

            case E_HFmode:
              if (pattern859 (x3, 
E_HFmode) != 0
                  || !(
#line 6155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3900; /* *fma_fnmadd_hf */

            default:
              return -1;
            }

        case NEG:
          x7 = XEXP (x6, 0);
          operands[3] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (pattern860 (x3, 
E_SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3943; /* *fma_fnmsub_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3972; /* *fma_fnmsub_sf */

            case E_DFmode:
              if (pattern860 (x3, 
E_DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3945; /* *fma_fnmsub_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3981; /* *fma_fnmsub_df */

            case E_HFmode:
              if (pattern861 (x3, 
E_HFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3971; /* *fma_fnmsub_hf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_73 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 1)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  operands[2] = x5;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      switch (pattern973 (x2, 
E_SImode))
        {
        case 0:
          if (
#line 5437 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)))
            return 2324; /* *mmx_pextrw_zext */
          break;

        case 1:
          if (
#line 6098 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2362; /* *pextrw_zext */
          break;

        case 2:
          if (
#line 21102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return 8389; /* *vec_extractv8hi_zext */
          break;

        case 3:
          if (
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2328; /* *mmx_pextrb_zext */
          break;

        case 4:
          if (
#line 6130 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2366; /* *pextrb_zext */
          break;

        case 5:
          if ((
#line 21102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 21045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1)))
            return 8387; /* *vec_extractv16qi_zext */
          break;

        default:
          break;
        }
      break;

    case E_DImode:
      switch (pattern973 (x2, 
E_DImode))
        {
        case 0:
          if ((
#line 5437 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2325; /* *mmx_pextrw_zext */
          break;

        case 1:
          if ((
#line 6098 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2363; /* *pextrw_zext */
          break;

        case 2:
          if ((
#line 21102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 8390; /* *vec_extractv8hi_zext */
          break;

        case 3:
          if ((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2329; /* *mmx_pextrb_zext */
          break;

        case 4:
          if ((
#line 6130 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2367; /* *pextrb_zext */
          break;

        case 5:
          if ((
#line 21102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && (
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))))
            return 8388; /* *vec_extractv16qi_zext */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  if (!register_operand (operands[0], E_DImode)
      || GET_MODE (x2) != E_DImode
      || GET_MODE (x3) != E_SImode)
    return -1;
  operands[1] = x6;
  switch (XWINT (x5, 0))
    {
    case 0L:
      switch (GET_MODE (operands[1]))
        {
        case E_V2SImode:
          if (register_operand (operands[1], E_V2SImode))
            {
              if (
#line 5749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE4_1))
                return 2350; /* *vec_extractv2si_0_zext_sse4 */
              if (
#line 5764 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_FROM_VEC))
                return 2351; /* *vec_extractv2si_0_zext */
            }
          break;

        case E_V4SImode:
          if (register_operand (operands[1], E_V4SImode))
            {
              if (
#line 21202 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE4_1))
                return 8397; /* *vec_extractv4si_0_zext_sse4 */
              if (
#line 21217 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_FROM_VEC))
                return 8398; /* *vec_extractv4si_0_zext */
            }
          break;

        default:
          break;
        }
      break;

    case 1L:
      if (register_operand (operands[1], E_V2SImode)
          && 
#line 5826 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_64BIT && TARGET_SSE4_1))
        return 2353; /* *vec_extractv2si_1_zext */
      break;

    default:
      break;
    }
  operands[2] = x5;
  switch (GET_MODE (operands[1]))
    {
    case E_V2SImode:
      if (!memory_operand (operands[1], E_V2SImode)
          || !const_0_to_1_operand (operands[2], E_SImode)
          || !
#line 5842 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_64BIT))
        return -1;
      return 2354; /* *vec_extractv2si_zext_mem */

    case E_V4SImode:
      if (!const_0_to_3_operand (operands[2], E_SImode))
        return -1;
      if (register_operand (operands[1], E_V4SImode)
          && 
#line 21278 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE4_1))
        return 8400; /* *vec_extractv4si_zext */
      if (!memory_operand (operands[1], E_V4SImode)
          || !
#line 21301 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
        return -1;
      return 8402; /* *vec_extractv4si_zext_mem */

    default:
      return -1;
    }
}

 int
recog_79 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      x5 = XEXP (x3, 1);
      switch (GET_CODE (x5))
        {
        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          x6 = XEXP (x2, 1);
          switch (GET_CODE (x6))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
              operands[3] = x6;
              operands[1] = x4;
              operands[2] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (pattern599 (x2, 
E_SImode) != 0
                      || !
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[3])
   < (HOST_WIDE_INT_1U << INTVAL (operands[2]))))
                    return -1;
                  return 376; /* *leasi_general_4 */

                case E_DImode:
                  if (GET_MODE (x2) != E_DImode
                      || GET_MODE (x3) != E_DImode)
                    return -1;
                  if (register_operand (operands[0], E_DImode)
                      && register_no_SP_operand (operands[1], E_DImode)
                      && const_0_to_3_operand (operands[2], E_VOIDmode)
                      && const_int_operand (operands[3], E_VOIDmode)
                      && (
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[3])
   < (HOST_WIDE_INT_1U << INTVAL (operands[2]))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 378; /* *leadi_general_4 */
                  if (!nonimmediate_operand (operands[0], E_DImode)
                      || !register_operand (operands[1], E_DImode)
                      || !const_int_operand (operands[2], E_QImode)
                      || !const_scalar_int_operand (operands[3], E_DImode)
                      || !(
#line 14151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT / 2
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                    return -1;
                  return 929; /* *concatsidi3_5 */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              if (GET_MODE (x6) != E_DImode
                  || !nonimmediate_operand (operands[0], E_DImode)
                  || GET_MODE (x2) != E_DImode
                  || GET_MODE (x3) != E_DImode)
                return -1;
              operands[1] = x4;
              if (!register_operand (operands[1], E_DImode))
                return -1;
              operands[2] = x5;
              if (!const_int_operand (operands[2], E_QImode))
                return -1;
              x7 = XEXP (x6, 0);
              operands[3] = x7;
              if (!nonimmediate_operand (operands[3], E_SImode)
                  || !(
#line 14074 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 893; /* *concatsidi3_1 */

            case SUBREG:
              switch (pattern439 (x2, 
LSHIFTRT))
                {
                case 0:
                  operands[2] = x5;
                  if (pattern1347 (x2) == 0)
                    {
                      if (
#line 15451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && TARGET_APX_NF))
                        return 1066; /* x86_64_shld_1_nf */
                      if (pnum_clobbers != NULL
                          && 
#line 15451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && true))
                        {
                          *pnum_clobbers = 1;
                          return 1067; /* x86_64_shld_1 */
                        }
                    }
                  operands[3] = x5;
                  if (pattern1348 (x2) != 0)
                    return -1;
                  if (
#line 15473 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && TARGET_APX_NF))
                    return 1068; /* x86_64_shld_ndd_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15473 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1069; /* x86_64_shld_ndd_1 */

                case 1:
                  operands[2] = x5;
                  if (pattern1349 (x2) == 0)
                    {
                      if (
#line 15683 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
  && TARGET_APX_NF))
                        return 1078; /* x86_shld_1_nf */
                      if (pnum_clobbers != NULL
                          && 
#line 15683 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
  && true))
                        {
                          *pnum_clobbers = 1;
                          return 1079; /* x86_shld_1 */
                        }
                    }
                  operands[3] = x5;
                  if (pattern1350 (x2) != 0)
                    return -1;
                  if (
#line 15705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD 
   && INTVAL (operands[4]) == 32 - INTVAL (operands[3])
   && TARGET_APX_NF))
                    return 1080; /* x86_shld_ndd_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD 
   && INTVAL (operands[4]) == 32 - INTVAL (operands[3])
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1081; /* x86_shld_ndd_1 */

                default:
                  return -1;
                }

            case LSHIFTRT:
              switch (pattern442 (x2, pnum_clobbers))
                {
                case 0:
                  if (
#line 15489 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_APX_NF
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return 1070; /* *x86_64_shld_shrd_1_nozext_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15545 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1071; /* *x86_64_shld_shrd_1_nozext */

                case 1:
                  if (
#line 15721 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF
   && INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return 1082; /* *x86_shld_shrd_1_nozext_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15777 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1083; /* *x86_shld_shrd_1_nozext */

                case 2:
                  x7 = XEXP (x6, 0);
                  operands[1] = x7;
                  if (nonimmediate_operand (operands[0], E_DImode))
                    {
                      operands[2] = x5;
                      if (rtx_equal_p (x4, operands[0]))
                        {
                          x8 = XEXP (x6, 1);
                          x9 = XEXP (x8, 1);
                          if (rtx_equal_p (x9, operands[2])
                              && 
#line 15598 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            {
                              *pnum_clobbers = 1;
                              return 1072; /* *x86_64_shld_2 */
                            }
                        }
                    }
                  operands[2] = x7;
                  if (!register_operand (operands[0], E_DImode))
                    return -1;
                  operands[1] = x4;
                  if (!nonimmediate_operand (operands[1], E_DImode))
                    return -1;
                  operands[3] = x5;
                  x8 = XEXP (x6, 1);
                  x9 = XEXP (x8, 1);
                  if (!rtx_equal_p (x9, operands[3])
                      || !
#line 15619 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1073; /* *x86_64_shld_ndd_2 */

                case 3:
                  x7 = XEXP (x6, 0);
                  operands[1] = x7;
                  if (nonimmediate_operand (operands[0], E_SImode))
                    {
                      operands[2] = x5;
                      if (rtx_equal_p (x4, operands[0]))
                        {
                          x8 = XEXP (x6, 1);
                          x9 = XEXP (x8, 1);
                          if (rtx_equal_p (x9, operands[2])
                              && 
#line 15829 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            {
                              *pnum_clobbers = 1;
                              return 1084; /* *x86_shld_2 */
                            }
                        }
                    }
                  operands[2] = x7;
                  if (!register_operand (operands[0], E_SImode))
                    return -1;
                  operands[1] = x4;
                  if (!nonimmediate_operand (operands[1], E_SImode))
                    return -1;
                  operands[3] = x5;
                  x8 = XEXP (x6, 1);
                  x9 = XEXP (x8, 1);
                  if (!rtx_equal_p (x9, operands[3])
                      || !
#line 15850 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1085; /* *x86_shld_ndd_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case AND:
          switch (pattern290 (x2, 
LSHIFTRT))
            {
            case 0:
              x6 = XEXP (x2, 1);
              x7 = XEXP (x6, 0);
              x10 = XEXP (x7, 0);
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              if (nonimmediate_operand (operands[0], E_DImode))
                {
                  res = recog_77 (x1, insn, pnum_clobbers);
                  if (res >= 0)
                    return res;
                }
              operands[2] = x11;
              if (!register_operand (operands[0], E_DImode))
                return -1;
              operands[1] = x4;
              if (!nonimmediate_operand (operands[1], E_DImode))
                return -1;
              x12 = XEXP (x5, 0);
              operands[3] = x12;
              x13 = XEXP (x7, 1);
              x14 = XEXP (x13, 1);
              x15 = XEXP (x14, 0);
              if (!rtx_equal_p (x15, operands[3]))
                return -1;
              if (
#line 15436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
                return 1064; /* x86_64_shld_ndd_nf */
              if (pnum_clobbers == NULL
                  || !
#line 15436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              *pnum_clobbers = 1;
              return 1065; /* x86_64_shld_ndd */

            case 1:
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || pattern289 (x2, 
E_SImode, 
E_DImode) != 0)
                return -1;
              x6 = XEXP (x2, 1);
              x7 = XEXP (x6, 0);
              x10 = XEXP (x7, 0);
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              x12 = XEXP (x5, 0);
              operands[2] = x12;
              if (rtx_equal_p (x4, operands[0]))
                {
                  x13 = XEXP (x7, 1);
                  x14 = XEXP (x13, 1);
                  x15 = XEXP (x14, 0);
                  if (rtx_equal_p (x15, operands[2]))
                    {
                      if (
#line 15645 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF))
                        return 1074; /* x86_shld_nf */
                      if (pnum_clobbers != NULL)
                        {
                          *pnum_clobbers = 1;
                          return 1075; /* x86_shld */
                        }
                    }
                }
              operands[2] = x11;
              operands[1] = x4;
              if (!nonimmediate_operand (operands[1], E_SImode))
                return -1;
              operands[3] = x12;
              x13 = XEXP (x7, 1);
              x14 = XEXP (x13, 1);
              x15 = XEXP (x14, 0);
              if (!rtx_equal_p (x15, operands[3]))
                return -1;
              if (
#line 15667 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
                return 1076; /* x86_shld_ndd_nf */
              if (pnum_clobbers == NULL
                  || !
#line 15667 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              *pnum_clobbers = 1;
              return 1077; /* x86_shld_ndd */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SIGN_EXTEND:
      switch (pattern260 (x2, 
E_SImode, 
E_DImode))
        {
        case 0:
          if (!(
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 905; /* *concatsidi3_3 */

        case 1:
          if (!(
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 935; /* *concatsidi3_6 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      switch (pattern260 (x2, 
E_SImode, 
E_DImode))
        {
        case 0:
          if (!(
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 908; /* *concatsidi3_3 */

        case 1:
          if (!(
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 938; /* *concatsidi3_6 */

        default:
          return -1;
        }

    case CONST_INT:
      switch (pattern288 (x2, pnum_clobbers))
        {
        case 0:
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          if (register_operand (operands[2], E_QImode))
            {
              switch (pattern748 (x2))
                {
                case 0:
                  if (
#line 18837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT))
                    {
                      *pnum_clobbers = 1;
                      return 1391; /* *btssi */
                    }
                  break;

                case 1:
                  if ((
#line 18837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pnum_clobbers = 1;
                      return 1393; /* *btsdi */
                    }
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x5) != SUBREG)
            return -1;
          switch (pattern757 (x2))
            {
            case 0:
              if (!
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 1395; /* *btssi_mask */

            case 1:
              if (!(
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1397; /* *btsdi_mask */

            default:
              return -1;
            }

        case 1:
          if (!
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1399; /* *btssi_mask_1 */

        case 2:
          if (!(
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1401; /* *btsdi_mask_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_98 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (pnum_clobbers != NULL)
        {
          x2 = XEXP (x1, 1);
          if (pattern734 (x2, 
E_DImode, 
E_QImode) == 0
              && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            {
              *pnum_clobbers = 1;
              return 1131; /* ashrdi3_doubleword */
            }
        }
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      if (nonimmediate_operand (operands[0], E_DImode)
          && const_int_operand (operands[2], E_QImode))
        {
          if ((
#line 17258 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == GET_MODE_BITSIZE (DImode)-1
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1168; /* ashrdi3_cvt_nf */
          if (pnum_clobbers != NULL
              && (
#line 17258 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == GET_MODE_BITSIZE (DImode)-1
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1169; /* ashrdi3_cvt */
            }
        }
      if (register_operand (operands[0], E_DImode)
          && register_operand (operands[2], E_DImode)
          && (
#line 17327 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1174; /* *bmi2_ashrdi3_1 */
      if (!nonimmediate_operand (operands[0], E_DImode)
          || !nonmemory_operand (operands[2], E_QImode))
        return -1;
      if ((
#line 17337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1177; /* *ashrdi3_1_nf */
      if (pnum_clobbers == NULL
          || !(
#line 17337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1178; /* *ashrdi3_1 */

    case E_SImode:
      x2 = XEXP (x1, 1);
      if (pattern619 (x2, 
E_SImode) != 0)
        return -1;
      if (
#line 17337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
        return 1175; /* *ashrsi3_1_nf */
      if (pnum_clobbers == NULL
          || !
#line 17337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)
   && true))
        return -1;
      *pnum_clobbers = 1;
      return 1176; /* *ashrsi3_1 */

    default:
      return -1;
    }
}

 int
recog_103 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) == SUBREG
      && known_eq (SUBREG_BYTE (x2), 0))
    {
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      if (register_operand (operands[0], E_QImode))
        {
          x4 = XEXP (x1, 1);
          x5 = XEXP (x4, 2);
          operands[2] = x5;
          if (register_operand (operands[2], E_QImode))
            {
              switch (GET_MODE (x2))
                {
                case E_SImode:
                  if (GET_MODE (x4) == E_SImode
                      && register_operand (operands[1], E_SImode)
                      && 
#line 19356 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                    {
                      *pnum_clobbers = 1;
                      return 1434; /* *btsi_setcqi */
                    }
                  break;

                case E_DImode:
                  if (GET_MODE (x4) == E_DImode
                      && register_operand (operands[1], E_DImode)
                      && (
#line 19356 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pnum_clobbers = 1;
                      return 1435; /* *btdi_setcqi */
                    }
                  break;

                default:
                  break;
                }
            }
        }
    }
  x4 = XEXP (x1, 1);
  x5 = XEXP (x4, 2);
  if (GET_CODE (x5) != SUBREG
      || maybe_ne (SUBREG_BYTE (x5), 0)
      || GET_MODE (x5) != E_QImode)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != AND)
    return -1;
  operands[0] = x2;
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x6, 1);
  operands[3] = x8;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (pattern1439 (x4, 
E_SImode) != 0
          || !
#line 19437 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1442; /* *btsi_setcsi_mask */

    case E_DImode:
      if (pattern1439 (x4, 
E_DImode) != 0
          || !(
#line 19437 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1443; /* *btdi_setcdi_mask */

    default:
      return -1;
    }
}

 int
recog_104 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (XWINT (x3, 0) == 1L)
    {
      res = recog_103 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  operands[2] = x3;
  if (!const_0_to_255_operand (operands[2], E_QImode))
    return -1;
  x6 = XEXP (x2, 2);
  operands[3] = x6;
  if (!const_0_to_255_operand (operands[3], E_QImode))
    return -1;
  switch (pattern126 (x2))
    {
    case 0:
      if (!
#line 22184 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
        return -1;
      *pnum_clobbers = 1;
      return 1604; /* tbm_bextri_si */

    case 1:
      if (!(
#line 22184 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1605; /* tbm_bextri_di */

    default:
      return -1;
    }
}

 int
recog_107 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 17:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      return 1487; /* *memory_blockage */

    case 14:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case CONST_INT:
          if (XWINT (x4, 0) != 0L)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pnum_clobbers == NULL
                  || !register_operand (operands[0], E_SImode)
                  || GET_MODE (x2) != E_SImode
                  || !
#line 20785 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 1498; /* *set_got */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x2) != E_DImode
                  || !
#line 20815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 1500; /* set_got_rex64 */

            default:
              return -1;
            }

        case LABEL_REF:
          if (pnum_clobbers == NULL
              || !register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode)
            return -1;
          x5 = XEXP (x4, 0);
          operands[1] = x5;
          if (!
#line 20807 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1499; /* *set_got_labelled */

        default:
          return -1;
        }

    case 15:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (GET_CODE (x4) != LABEL_REF)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_DImode))
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!
#line 20824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      return 1501; /* set_rip_rex64 */

    case 16:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (GET_CODE (x4) != LABEL_REF)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_DImode))
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!
#line 20835 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LP64))
        return -1;
      return 1502; /* set_got_offset_rex64 */

    case 97:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern302 (x2))
        {
        case 0:
          if ((
#line 21678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return 1546; /* tzcnt_si_nf */
          if (pnum_clobbers == NULL
              || !
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          *pnum_clobbers = 1;
          return 1550; /* tzcnt_si */

        case 1:
          if ((
#line 21678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && (((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))))
            return 1548; /* tzcnt_di_nf */
          if (pnum_clobbers == NULL
              || !(((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return -1;
          *pnum_clobbers = 1;
          return 1552; /* tzcnt_di */

        default:
          return -1;
        }

    case 96:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern302 (x2))
        {
        case 0:
          if ((
#line 21678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return 1547; /* lzcnt_si_nf */
          if (pnum_clobbers == NULL
              || !
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          *pnum_clobbers = 1;
          return 1551; /* lzcnt_si */

        case 1:
          if ((
#line 21678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && (((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))))
            return 1549; /* lzcnt_di_nf */
          if (pnum_clobbers == NULL
              || !(((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return -1;
          *pnum_clobbers = 1;
          return 1553; /* lzcnt_di */

        default:
          return -1;
        }

    case 19:
      x4 = XVECEXP (x2, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern23 (x2))
        {
        case 0:
          if (!
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode))
            return -1;
          return 1658; /* *load_tp_si */

        case 1:
          if (!
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode))
            return -1;
          return 1659; /* *load_tp_di */

        default:
          return -1;
        }

    case 22:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!tls_symbolic_operand (operands[1], E_VOIDmode))
        return -1;
      switch (pattern23 (x2))
        {
        case 0:
          if (!(
#line 23372 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
            return -1;
          return 1667; /* *tls_dynamic_gnu2_lea_64_si */

        case 1:
          if (!(
#line 23372 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
            return -1;
          return 1668; /* *tls_dynamic_gnu2_lea_64_di */

        default:
          return -1;
        }

    case 70:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_XFmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pnum_clobbers == NULL
              || !nonimmediate_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !
#line 25151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          *pnum_clobbers = 1;
          return 1733; /* lrintxfdi2 */

        case E_SImode:
          if (!nonimmediate_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !
#line 25160 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          return 1735; /* lrintxfsi2 */

        default:
          return -1;
        }

    case 78:
      switch (pattern120 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1746; /* *fistsi2_floor_1 */

        case 1:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1748; /* *fistdi2_floor_1 */

        default:
          return -1;
        }

    case 79:
      switch (pattern120 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1747; /* *fistsi2_ceil_1 */

        case 1:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1749; /* *fistdi2_ceil_1 */

        default:
          return -1;
        }

    case 49:
      return recog_106 (x1, insn, pnum_clobbers);

    case 18:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!memory_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !const0_operand (operands[1], E_SImode)
              || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
            return -1;
          *pnum_clobbers = 1;
          return 1861; /* probe_stack_1_si */

        case E_DImode:
          if (!memory_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !const0_operand (operands[1], E_DImode)
              || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
            return -1;
          *pnum_clobbers = 1;
          return 1862; /* probe_stack_1_di */

        default:
          return -1;
        }

    case 33:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      return 1955; /* *pause */

    case 102:
      switch (pattern121 (x1))
        {
        case 0:
          if (!
#line 29831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIRI))
            return -1;
          return 1986; /* movdirisi */

        case 1:
          if (!(
#line 29831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIRI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1987; /* movdiridi */

        default:
          return -1;
        }

    case 103:
      if (GET_MODE (x2) != E_XImode)
        return -1;
      x3 = XEXP (x1, 0);
      if (GET_CODE (x3) != MEM
          || GET_MODE (x3) != E_XImode)
        return -1;
      x6 = XEXP (x3, 0);
      operands[0] = x6;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!memory_operand (operands[1], E_XImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || !(
#line 29839 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIR64B) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1988; /* movdir64b_si */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || !(
#line 29839 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIR64B) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1989; /* movdir64b_di */

        default:
          return -1;
        }

    case 111:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DImode)
          || !
#line 636 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)))
        return -1;
      return 2048; /* sse_movntq */

    case 117:
      switch (pattern121 (x1))
        {
        case 0:
          if (!
#line 2012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 2561; /* sse2_movntisi */

        case 1:
          if (!(
#line 2012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 2562; /* sse2_movntidi */

        default:
          return -1;
        }

    case 156:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case VEC_SELECT:
          switch (pattern453 (x4))
            {
            case 0:
              switch (pattern1086 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4474; /* avx512fp16_vcvtsh2usi */

                case 1:
                  if (!
#line 9013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                    return -1;
                  return 4834; /* avx512f_vcvtss2usi */

                case 2:
                  if (!
#line 9049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                    return -1;
                  return 4846; /* avx512f_vcvtsd2usi */

                default:
                  return -1;
                }

            case 1:
              switch (pattern1086 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4478; /* avx512fp16_vcvtsh2usiq */

                case 1:
                  if (!(
#line 9013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4836; /* avx512f_vcvtss2usiq */

                case 2:
                  if (!(
#line 9049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4848; /* avx512f_vcvtsd2usiq */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x4;
          if (!nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          switch (pattern23 (x2))
            {
            case 0:
              if (!
#line 7826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4482; /* avx512fp16_vcvtsh2usi_2 */

            case 1:
              if (!(
#line 7826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 4484; /* avx512fp16_vcvtsh2usiq_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 46:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case VEC_SELECT:
          switch (pattern453 (x4))
            {
            case 0:
              switch (pattern1087 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4476; /* avx512fp16_vcvtsh2si */

                case 1:
                  if (!
#line 8542 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 4723; /* sse_cvtss2si */

                case 2:
                  if (!
#line 9085 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 4858; /* sse2_cvtsd2si */

                default:
                  return -1;
                }

            case 1:
              switch (pattern1087 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4480; /* avx512fp16_vcvtsh2siq */

                case 1:
                  if (!(
#line 8542 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4725; /* sse_cvtss2siq */

                case 2:
                  if (!(
#line 9085 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4860; /* sse2_cvtsd2siq */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              switch (pattern762 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4483; /* avx512fp16_vcvtsh2si_2 */

                case 1:
                  if (!
#line 8555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 4727; /* sse_cvtss2si_2 */

                case 2:
                  if (!
#line 9099 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 4862; /* sse2_cvtsd2si_2 */

                default:
                  return -1;
                }

            case E_DImode:
              switch (pattern762 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4485; /* avx512fp16_vcvtsh2siq_2 */

                case 1:
                  if (!(
#line 8555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4728; /* sse_cvtss2siq_2 */

                case 2:
                  if (!(
#line 9099 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4863; /* sse2_cvtsd2siq_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 172:
      switch (pattern123 (x1))
        {
        case 0:
          if (!
#line 7980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return -1;
          return 4626; /* unspec_avx512fp16_fix_truncsi2 */

        case 1:
          if (!
#line 8570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 4729; /* unspec_sse_cvttss2si */

        case 2:
          if (!
#line 9114 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 4864; /* unspec_sse2_cvttsd2si */

        case 3:
          if (!(
#line 7980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4630; /* unspec_avx512fp16_fix_truncdi2 */

        case 4:
          if (!(
#line 8570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4731; /* unspec_sse_cvttss2siq */

        case 5:
          if (!(
#line 9114 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4866; /* unspec_sse2_cvttsd2siq */

        default:
          return -1;
        }

    case 173:
      switch (pattern123 (x1))
        {
        case 0:
          if (!
#line 7980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return -1;
          return 4628; /* unspec_avx512fp16_fixuns_truncsi2 */

        case 1:
          if (!
#line 9024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 4838; /* unspec_avx512f_vcvttss2usi */

        case 2:
          if (!
#line 9060 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 4850; /* unspec_avx512f_vcvttsd2usi */

        case 3:
          if (!(
#line 7980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4632; /* unspec_avx512fp16_fixuns_truncdi2 */

        case 4:
          if (!(
#line 9024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4840; /* unspec_avx512f_vcvttss2usiq */

        case 5:
          if (!(
#line 9060 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4852; /* unspec_avx512f_vcvttsd2usiq */

        default:
          return -1;
        }

    case 191:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !register_operand (operands[1], E_V64QImode)
              || !(
#line 10246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5099; /* avx512bw_cvtb2maskv64qi */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V32QImode:
              if (!register_operand (operands[1], E_V32QImode)
                  || !(
#line 10246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 5101; /* avx512vl_cvtb2maskv32qi */

            case E_V32HImode:
              if (!register_operand (operands[1], E_V32HImode)
                  || !(
#line 10246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 5102; /* avx512bw_cvtw2maskv32hi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 275:
      switch (pattern125 (x1))
        {
        case 0:
          if (!
#line 32618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10808; /* avx10_2_vcvttsd2sissi */

        case 1:
          if (!
#line 32631 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10816; /* avx10_2_vcvttss2sissi */

        case 2:
          if (!(
#line 32618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10812; /* avx10_2_vcvttsd2sisdi */

        case 3:
          if (!(
#line 32631 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10820; /* avx10_2_vcvttss2sisdi */

        default:
          return -1;
        }

    case 276:
      switch (pattern125 (x1))
        {
        case 0:
          if (!
#line 32618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10810; /* avx10_2_vcvttsd2usissi */

        case 1:
          if (!
#line 32631 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10818; /* avx10_2_vcvttss2usissi */

        case 2:
          if (!(
#line 32618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10814; /* avx10_2_vcvttsd2usisdi */

        case 3:
          if (!(
#line 32631 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10822; /* avx10_2_vcvttss2usisdi */

        default:
          return -1;
        }

    case 280:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0])
          || !
#line 60 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE2))
        return -1;
      return 10902; /* *sse2_lfence */

    case 281:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0])
          || !
#line 79 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE || TARGET_3DNOW_A))
        return -1;
      return 10903; /* *sse_sfence */

    case 282:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      if (
#line 98 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_64BIT || TARGET_SSE2))
        return 10904; /* mfence_sse2 */
      if (pnum_clobbers == NULL)
        return -1;
      *pnum_clobbers = 1;
      return 10905; /* mfence_nosse */

    case 284:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DFmode)
          || !
#line 356 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_80387))
        return -1;
      return 10913; /* storedi_via_fpu */

    case 286:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DFmode)
          || !
#line 382 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE))
        return -1;
      return 10915; /* storedi_via_sse */

    default:
      return -1;
    }
}

 int
recog_146 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (XVECLEN (x4, 0))
    {
    case 1:
      x5 = XEXP (x2, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      x8 = XEXP (x3, 2);
      operands[4] = x8;
      if (!register_operand (operands[4], E_QImode))
        return -1;
      x9 = XEXP (x2, 1);
      operands[2] = x9;
      switch (XINT (x4, 1))
        {
        case 54:
          if (pattern1270 (x2) != 0
              || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2982 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2886; /* avx512fp16_vmrcpv8hf2_mask */

        case 161:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1358 (x2, 
E_V4SFmode) != 0
                  || !
#line 3038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2902; /* srcp14v4sf_mask */

            case E_V2DFmode:
              if (pattern1358 (x2, 
E_V2DFmode) != 0
                  || !(
#line 3038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2903; /* srcp14v2df_mask */

            default:
              return -1;
            }

        case 162:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1358 (x2, 
E_V4SFmode) != 0
                  || !
#line 3192 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2974; /* rsqrt14_v4sf_mask */

            case E_V2DFmode:
              if (pattern1358 (x2, 
E_V2DFmode) != 0
                  || !(
#line 3192 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2975; /* rsqrt14_v2df_mask */

            default:
              return -1;
            }

        case 55:
          if (pattern1270 (x2) != 0
              || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3240 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2979; /* avx512fp16_vmrsqrtv8hf2_mask */

        default:
          return -1;
        }

    case 2:
      x5 = XEXP (x2, 2);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      switch (XINT (x4, 1))
        {
        case 63:
          switch (pattern764 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3122; /* avx512fp16_ieee_vmmaxv8hf3_mask */

            case 1:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 3130; /* sse_ieee_vmmaxv4sf3_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3138; /* sse2_ieee_vmmaxv2df3_mask */

            default:
              return -1;
            }

        case 62:
          switch (pattern764 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3126; /* avx512fp16_ieee_vmminv8hf3_mask */

            case 1:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 3134; /* sse_ieee_vmminv4sf3_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3142; /* sse2_ieee_vmminv2df3_mask */

            default:
              return -1;
            }

        case 221:
          if (pattern765 (x2) != 0
              || !(
#line 389 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4330; /* avx512fp16_fmulcsh_v8hf_mask */

        case 222:
          if (pattern765 (x2) != 0
              || !(
#line 389 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4334; /* avx512fp16_fcmulcsh_v8hf_mask */

        case 58:
          switch (pattern764 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 5322; /* avx512f_vmscalefv8hf_mask */

            case 1:
              if (!
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 5326; /* avx512f_vmscalefv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 5330; /* avx512f_vmscalefv2df_mask */

            default:
              return -1;
            }

        case 165:
          switch (pattern764 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 6983; /* avx512f_sgetexpv8hf_mask */

            case 1:
              if (!
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 6987; /* avx512f_sgetexpv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 6991; /* avx512f_sgetexpv2df_mask */

            default:
              return -1;
            }

        case 94:
          if (XWINT (x5, 0) != 1L)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[2] = x6;
          x10 = XVECEXP (x4, 0, 1);
          operands[3] = x10;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          x7 = XEXP (x3, 1);
          operands[4] = x7;
          x8 = XEXP (x3, 2);
          operands[5] = x8;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          operands[1] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1522 (x2, 
E_V8HFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 7099; /* avx512f_rndscalev8hf_mask */

            case E_V4SFmode:
              if (pattern1522 (x2, 
E_V4SFmode) != 0
                  || !
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 7103; /* avx512f_rndscalev4sf_mask */

            case E_V2DFmode:
              if (pattern1522 (x2, 
E_V2DFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 7107; /* avx512f_rndscalev2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 3:
      x5 = XEXP (x2, 2);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x10 = XVECEXP (x4, 0, 1);
      operands[2] = x10;
      x11 = XVECEXP (x4, 0, 2);
      operands[3] = x11;
      switch (XINT (x4, 1))
        {
        case 192:
          switch (pattern1100 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3196; /* reducesv8hf_mask */

            case 1:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode)))))
                return -1;
              return 3200; /* reducesv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3204; /* reducesv2df_mask */

            default:
              return -1;
            }

        case 217:
          switch (pattern1101 (x2))
            {
            case 0:
              if (!(
#line 371 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4317; /* avx512fp16_fma_fmaddcsh_v8hf_maskz */

            case 1:
              if (!
#line 7511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4324; /* avx512fp16_fmaddcsh_v8hf_mask */

            default:
              return -1;
            }

        case 219:
          switch (pattern1101 (x2))
            {
            case 0:
              if (!(
#line 371 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4321; /* avx512fp16_fma_fcmaddcsh_v8hf_maskz */

            case 1:
              if (!
#line 7511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4326; /* avx512fp16_fcmaddcsh_v8hf_mask */

            default:
              return -1;
            }

        case 194:
          if (XWINT (x5, 0) != 1L
              || !const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          x7 = XEXP (x3, 1);
          operands[4] = x7;
          x8 = XEXP (x3, 2);
          operands[5] = x8;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1098 (x2, 
E_V4SFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                return -1;
              return 9901; /* avx512dq_rangesv4sf_mask */

            case E_V2DFmode:
              if (pattern1098 (x2, 
E_V2DFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 9905; /* avx512dq_rangesv2df_mask */

            default:
              return -1;
            }

        case 166:
          if (XWINT (x5, 0) != 1L
              || !const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          switch (pattern1099 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29906 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 9969; /* avx512f_vgetmantv8hf_mask */

            case 1:
              if (!
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 9973; /* avx512f_vgetmantv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29906 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 9977; /* avx512f_vgetmantv2df_mask */

            default:
              return -1;
            }

        case 278:
          switch (pattern1100 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32671 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 10867; /* avx10_2_minmaxsv8hf_mask */

            case 1:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32671 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10871; /* avx10_2_minmaxsv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32671 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 10875; /* avx10_2_minmaxsv2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 4:
      if (XINT (x4, 1) != 163)
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x10 = XVECEXP (x4, 0, 1);
      operands[2] = x10;
      x11 = XVECEXP (x4, 0, 2);
      operands[3] = x11;
      x12 = XVECEXP (x4, 0, 3);
      operands[4] = x12;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      x7 = XEXP (x3, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[5] = x7;
          x5 = XEXP (x2, 2);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x8 = XEXP (x3, 2);
          operands[6] = x8;
          if (!register_operand (operands[6], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[2]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1618 (x2, 
E_V4SFmode, 
E_V4SImode) != 0
                  || !
#line 154 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 7052; /* avx512f_sfixupimmv4sf_maskz_1 */

            case E_V2DFmode:
              if (pattern1618 (x2, 
E_V2DFmode, 
E_V2DImode) != 0
                  || !(
#line 154 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14180 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 7056; /* avx512f_sfixupimmv2df_maskz_1 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          if (!rtx_equal_p (x7, operands[2]))
            return -1;
          x8 = XEXP (x3, 2);
          if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x5 = XEXP (x2, 2);
          operands[5] = x5;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1619 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
                  || !
#line 14199 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 7058; /* avx512f_sfixupimmv4sf_mask */

            case E_V2DFmode:
              if (pattern1619 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
                  || !(
#line 14199 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 7060; /* avx512f_sfixupimmv2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_158 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x3;
      x4 = XEXP (x2, 2);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
          operands[5] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1376 (x2, 
E_V4SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4SFmode)
                  && nonimmediate_operand (operands[2], E_V4SFmode)
                  && nonimmediate_operand (operands[3], E_V4SFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3948; /* *fma_fnmsub_v4sf */
              if (!bcst_vector_operand (operands[1], E_V4SFmode)
                  || !bcst_vector_operand (operands[2], E_V4SFmode)
                  || !bcst_vector_operand (operands[3], E_V4SFmode)
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3980; /* fma_fnmsub_v4sf_maskz_1 */

            case E_V2DFmode:
              if (pattern1376 (x2, 
E_V2DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V2DFmode)
                  && nonimmediate_operand (operands[2], E_V2DFmode)
                  && nonimmediate_operand (operands[3], E_V2DFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3952; /* *fma_fnmsub_v2df */
              if (!bcst_vector_operand (operands[1], E_V2DFmode)
                  || !bcst_vector_operand (operands[2], E_V2DFmode)
                  || !bcst_vector_operand (operands[3], E_V2DFmode)
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3989; /* fma_fnmsub_v2df_maskz_1 */

            case E_V8SFmode:
              if (pattern1376 (x2, 
E_V8SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V8SFmode)
                  && nonimmediate_operand (operands[2], E_V8SFmode)
                  && nonimmediate_operand (operands[3], E_V8SFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3956; /* *fma_fnmsub_v8sf */
              if (!bcst_vector_operand (operands[1], E_V8SFmode)
                  || !bcst_vector_operand (operands[2], E_V8SFmode)
                  || !bcst_vector_operand (operands[3], E_V8SFmode)
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3978; /* fma_fnmsub_v8sf_maskz_1 */

            case E_V4DFmode:
              if (pattern1376 (x2, 
E_V4DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4DFmode)
                  && nonimmediate_operand (operands[2], E_V4DFmode)
                  && nonimmediate_operand (operands[3], E_V4DFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3960; /* *fma_fnmsub_v4df */
              if (!bcst_vector_operand (operands[1], E_V4DFmode)
                  || !bcst_vector_operand (operands[2], E_V4DFmode)
                  || !bcst_vector_operand (operands[3], E_V4DFmode)
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3987; /* fma_fnmsub_v4df_maskz_1 */

            case E_V32HFmode:
              if (pattern1377 (x2, 
E_SImode, 
E_V32HFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5931 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 3964; /* fma_fnmsub_v32hf_maskz_1 */

            case E_V16HFmode:
              if (pattern1377 (x2, 
E_HImode, 
E_V16HFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3968; /* fma_fnmsub_v16hf_maskz_1 */

            case E_V8HFmode:
              if (pattern1377 (x2, 
E_QImode, 
E_V8HFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5933 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3970; /* fma_fnmsub_v8hf_maskz_1 */

            case E_V16SFmode:
              if (pattern1377 (x2, 
E_HImode, 
E_V16SFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5935 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3974; /* fma_fnmsub_v16sf_maskz_1 */

            case E_V8DFmode:
              if (pattern1377 (x2, 
E_QImode, 
E_V8DFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5937 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3983; /* fma_fnmsub_v8df_maskz_1 */

            case E_V32BFmode:
              if (pattern1378 (x2, 
E_SImode, 
E_V32BFmode) != 0
                  || !
#line 32350 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10591; /* avx10_2_fnmsubbf16_v32bf_maskz_1 */

            case E_V16BFmode:
              if (pattern1378 (x2, 
E_HImode, 
E_V16BFmode) != 0
                  || !
#line 32350 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10593; /* avx10_2_fnmsubbf16_v16bf_maskz_1 */

            case E_V8BFmode:
              if (pattern1378 (x2, 
E_QImode, 
E_V8BFmode) != 0
                  || !
#line 32350 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10595; /* avx10_2_fnmsubbf16_v8bf_maskz_1 */

            default:
              return -1;
            }

        case CONST_INT:
          if (XWINT (x4, 0) != 1L)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1379 (x2, 
E_V4SFmode) != 0
                  || !
#line 7008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA4))
                return -1;
              return 4250; /* *fma4i_vmfnmsub_v4sf */

            case E_V2DFmode:
              if (pattern1379 (x2, 
E_V2DFmode) != 0
                  || !(
#line 7008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA4) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 4251; /* *fma4i_vmfnmsub_v2df */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (pattern632 (x2))
        {
        case 0:
          if (pattern1283 (x2, 
E_V32HFmode, 
E_SImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V32HFmode)
              && vector_operand (operands[3], E_V32HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return 3990; /* avx512bw_fnmsub_v32hf_mask */
          if (!vector_operand (operands[1], E_V32HFmode)
              || !nonimmediate_operand (operands[3], E_V32HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return -1;
          return 4002; /* avx512bw_fnmsub_v32hf_mask3 */

        case 1:
          if (pattern1283 (x2, 
E_V16HFmode, 
E_HImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V16HFmode)
              && vector_operand (operands[3], E_V16HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return 3992; /* avx512vl_fnmsub_v16hf_mask */
          if (!vector_operand (operands[1], E_V16HFmode)
              || !nonimmediate_operand (operands[3], E_V16HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4004; /* avx512vl_fnmsub_v16hf_mask3 */

        case 2:
          if (pattern1283 (x2, 
E_V8HFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8HFmode)
              && vector_operand (operands[3], E_V8HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return 3993; /* avx512fp16_fnmsub_v8hf_mask */
          if (!vector_operand (operands[1], E_V8HFmode)
              || !nonimmediate_operand (operands[3], E_V8HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4006; /* avx512fp16_fnmsub_v8hf_mask3 */

        case 3:
          if (pattern1283 (x2, 
E_V16SFmode, 
E_HImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V16SFmode)
              && vector_operand (operands[3], E_V16SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 3994; /* avx512f_fnmsub_v16sf_mask */
          if (!vector_operand (operands[1], E_V16SFmode)
              || !nonimmediate_operand (operands[3], E_V16SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4008; /* avx512f_fnmsub_v16sf_mask3 */

        case 4:
          if (pattern1283 (x2, 
E_V8SFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8SFmode)
              && vector_operand (operands[3], E_V8SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3996; /* avx512vl_fnmsub_v8sf_mask */
          if (!vector_operand (operands[1], E_V8SFmode)
              || !nonimmediate_operand (operands[3], E_V8SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4010; /* avx512vl_fnmsub_v8sf_mask3 */

        case 5:
          if (pattern1283 (x2, 
E_V4SFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V4SFmode)
              && vector_operand (operands[3], E_V4SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3997; /* avx512vl_fnmsub_v4sf_mask */
          if (!vector_operand (operands[1], E_V4SFmode)
              || !nonimmediate_operand (operands[3], E_V4SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4012; /* avx512vl_fnmsub_v4sf_mask3 */

        case 6:
          if (pattern1283 (x2, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8DFmode)
              && vector_operand (operands[3], E_V8DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 3998; /* avx512f_fnmsub_v8df_mask */
          if (!vector_operand (operands[1], E_V8DFmode)
              || !nonimmediate_operand (operands[3], E_V8DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4014; /* avx512f_fnmsub_v8df_mask3 */

        case 7:
          if (pattern1283 (x2, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V4DFmode)
              && vector_operand (operands[3], E_V4DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4000; /* avx512vl_fnmsub_v4df_mask */
          if (!vector_operand (operands[1], E_V4DFmode)
              || !nonimmediate_operand (operands[3], E_V4DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4016; /* avx512vl_fnmsub_v4df_mask3 */

        case 8:
          if (pattern1283 (x2, 
E_V2DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V2DFmode)
              && vector_operand (operands[3], E_V2DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4001; /* avx512vl_fnmsub_v2df_mask */
          if (!vector_operand (operands[1], E_V2DFmode)
              || !nonimmediate_operand (operands[3], E_V2DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4018; /* avx512vl_fnmsub_v2df_mask3 */

        case 9:
          if (pattern1284 (x2, 
E_SImode, 
E_V32BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10596; /* avx10_2_fnmsubbf16_v32bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10599; /* avx10_2_fnmsubbf16_v32bf_mask3 */

        case 10:
          if (pattern1284 (x2, 
E_HImode, 
E_V16BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10597; /* avx10_2_fnmsubbf16_v16bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10600; /* avx10_2_fnmsubbf16_v16bf_mask3 */

        case 11:
          if (pattern1284 (x2, 
E_QImode, 
E_V8BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10598; /* avx10_2_fnmsubbf16_v8bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10601; /* avx10_2_fnmsubbf16_v8bf_mask3 */

        case 12:
          if (pattern1380 (x2, 
E_V8HFmode) != 0
              || !(
#line 6655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4166; /* *fmai_fnmsub_v8hf */

        case 13:
          if (pattern1380 (x2, 
E_V4SFmode) != 0
              || !
#line 6655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F))
            return -1;
          return 4168; /* *fmai_fnmsub_v4sf */

        case 14:
          if (pattern1380 (x2, 
E_V2DFmode) != 0
              || !(
#line 6655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 4170; /* *fmai_fnmsub_v2df */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_166 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  operands[2] = x5;
  if (const_0_to_7_operand (operands[2], E_VOIDmode))
    {
      x6 = XVECEXP (x4, 0, 1);
      operands[3] = x6;
      if (const_0_to_7_operand (operands[3], E_VOIDmode))
        {
          x7 = XEXP (x2, 1);
          operands[4] = x7;
          x8 = XEXP (x2, 2);
          operands[5] = x8;
          if (register_operand (operands[5], E_QImode))
            {
              switch (GET_MODE (operands[0]))
                {
                case E_V2DFmode:
                  if (pattern1527 (x2, 
E_V2DFmode, 
E_V8DFmode) == 0
                      && (
#line 12421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && INTVAL (operands[2]) % 2 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[4]))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return 5240; /* avx512dq_vextractf64x2_1_mask */
                  break;

                case E_V2DImode:
                  if (pattern1527 (x2, 
E_V2DImode, 
E_V8DImode) == 0
                      && (
#line 12421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && INTVAL (operands[2]) % 2 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[4]))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return 5241; /* avx512dq_vextracti64x2_1_mask */
                  break;

                default:
                  break;
                }
            }
        }
    }
  x6 = XVECEXP (x4, 0, 1);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XEXP (x2, 1);
  operands[2] = x7;
  x8 = XEXP (x2, 2);
  operands[3] = x8;
  if (!register_operand (operands[3], E_QImode))
    return -1;
  switch (XWINT (x5, 0))
    {
    case 0L:
      if (XWINT (x6, 0) != 1L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (!nonimmediate_operand (operands[0], E_V2DImode)
              || pattern1528 (x2, 
E_V2DImode, 
E_V4DImode) != 0
              || !
#line 12851 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5264; /* vec_extract_lo_v4di_mask */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[0], E_V2DFmode)
              || pattern1528 (x2, 
E_V2DFmode, 
E_V4DFmode) != 0
              || !
#line 12851 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5265; /* vec_extract_lo_v4df_mask */

        default:
          return -1;
        }

    case 2L:
      if (XWINT (x6, 0) != 3L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (!nonimmediate_operand (operands[0], E_V2DImode)
              || pattern1528 (x2, 
E_V2DImode, 
E_V4DImode) != 0
              || !
#line 12888 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5268; /* vec_extract_hi_v4di_mask */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[0], E_V2DFmode)
              || pattern1528 (x2, 
E_V2DFmode, 
E_V4DFmode) != 0
              || !
#line 12888 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5269; /* vec_extract_hi_v4df_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_173 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 1);
  operands[3] = x5;
  x6 = XVECEXP (x4, 0, 2);
  operands[4] = x6;
  x7 = XVECEXP (x4, 0, 3);
  operands[5] = x7;
  x8 = XVECEXP (x4, 0, 5);
  operands[7] = x8;
  x9 = XVECEXP (x4, 0, 6);
  operands[8] = x9;
  x10 = XVECEXP (x4, 0, 7);
  operands[9] = x10;
  x11 = XVECEXP (x4, 0, 8);
  operands[10] = x11;
  x12 = XVECEXP (x4, 0, 9);
  operands[11] = x12;
  x13 = XVECEXP (x4, 0, 10);
  operands[12] = x13;
  x14 = XVECEXP (x4, 0, 11);
  operands[13] = x14;
  x15 = XVECEXP (x4, 0, 12);
  operands[14] = x15;
  x16 = XVECEXP (x4, 0, 13);
  operands[15] = x16;
  x17 = XVECEXP (x4, 0, 14);
  operands[16] = x17;
  x18 = XVECEXP (x4, 0, 15);
  operands[17] = x18;
  x19 = XEXP (x2, 1);
  operands[18] = x19;
  x20 = XEXP (x2, 2);
  operands[19] = x20;
  if (!register_operand (operands[19], E_HImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x2) != E_V16SFmode
          || GET_MODE (x3) != E_V16SFmode
          || !register_operand (operands[1], E_V16SFmode)
          || pattern1836 () != 0
          || !nonimm_or_0_operand (operands[18], E_V16SFmode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20453 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 8361; /* *avx512f_shuf_f32x4_1_mask_1 */

    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x2) != E_V16SImode
          || GET_MODE (x3) != E_V16SImode
          || !nonimm_or_0_operand (operands[18], E_V16SImode))
        return -1;
      if (register_operand (operands[1], E_V16SImode)
          && pattern1836 () == 0
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20453 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 8363; /* *avx512f_shuf_i32x4_1_mask_1 */
      if (!nonimmediate_operand (operands[1], E_V16SImode)
          || pattern1792 () != 0
          || !const_8_to_11_operand (operands[10], E_VOIDmode)
          || !const_8_to_11_operand (operands[11], E_VOIDmode)
          || !const_8_to_11_operand (operands[12], E_VOIDmode)
          || !const_8_to_11_operand (operands[13], E_VOIDmode)
          || !const_12_to_15_operand (operands[14], E_VOIDmode)
          || !const_12_to_15_operand (operands[15], E_VOIDmode)
          || !const_12_to_15_operand (operands[16], E_VOIDmode)
          || !const_12_to_15_operand (operands[17], E_VOIDmode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 20535 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512
   && INTVAL (operands[2]) + 4 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 4 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 4 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 4 == INTVAL (operands[9])
   && INTVAL (operands[2]) + 8 == INTVAL (operands[10])
   && INTVAL (operands[3]) + 8 == INTVAL (operands[11])
   && INTVAL (operands[4]) + 8 == INTVAL (operands[12])
   && INTVAL (operands[5]) + 8 == INTVAL (operands[13])
   && INTVAL (operands[2]) + 12 == INTVAL (operands[14])
   && INTVAL (operands[3]) + 12 == INTVAL (operands[15])
   && INTVAL (operands[4]) + 12 == INTVAL (operands[16])
   && INTVAL (operands[5]) + 12 == INTVAL (operands[17]))))
        return -1;
      return 8365; /* avx512f_pshufd_1_mask */

    default:
      return -1;
    }
}

 int
recog_184 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x2, 2);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V16HImode:
      if (pattern129 (x2, 
E_HImode, 
E_V16HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 793 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7536; /* ashrv16hi3_mask */
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28916 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9494; /* avx512vl_ashrvv16hi_mask */

    case E_V8HImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 793 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7538; /* ashrv8hi3_mask */
      if (!register_operand (operands[1], E_V8HImode)
          || !nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28916 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9492; /* avx512vl_ashrvv8hi_mask */

    case E_V8SImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7540; /* ashrv8si3_mask */
      if (!register_operand (operands[1], E_V8SImode)
          || !nonimmediate_operand (operands[2], E_V8SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9482; /* avx2_ashrvv8si_mask */

    case E_V4SImode:
      if (pattern129 (x2, 
E_QImode, 
E_V4SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7542; /* ashrv4si3_mask */
      if (!register_operand (operands[1], E_V4SImode)
          || !nonimmediate_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9480; /* avx2_ashrvv4si_mask */

    case E_V2DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V2DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7544; /* ashrv2di3_mask */
      if (!register_operand (operands[1], E_V2DImode)
          || !nonimmediate_operand (operands[2], E_V2DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL)) && 
#line 681 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9486; /* avx2_ashrvv2di_mask */

    case E_V32HImode:
      if (pattern129 (x2, 
E_SImode, 
E_V32HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 788 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
        return 7554; /* ashrv32hi3_mask */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28916 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9496; /* avx512bw_ashrvv32hi_mask */

    case E_V4DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V4DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7556; /* ashrv4di3_mask */
      if (!register_operand (operands[1], E_V4DImode)
          || !nonimmediate_operand (operands[2], E_V4DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL)) && 
#line 681 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9488; /* avx2_ashrvv4di_mask */

    case E_V16SImode:
      if (pattern129 (x2, 
E_HImode, 
E_V16SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7558; /* ashrv16si3_mask */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 680 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9484; /* avx512f_ashrvv16si_mask */

    case E_V8DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7560; /* ashrv8di3_mask */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 682 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9490; /* avx512f_ashrvv8di_mask */

    default:
      return -1;
    }
}

 int
recog_186 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern142 (x2))
    {
    case 0:
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7573; /* lshrv16hi3_mask */
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9528; /* avx512vl_lshrvv16hi_mask */

    case 1:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7577; /* lshrv8hi3_mask */
      if (!register_operand (operands[1], E_V8HImode)
          || !nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9524; /* avx512vl_lshrvv8hi_mask */

    case 2:
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7581; /* lshrv8si3_mask */
      if (!register_operand (operands[1], E_V8SImode)
          || !nonimmediate_operand (operands[2], E_V8SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9504; /* avx2_lshrvv8si_mask */

    case 3:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7585; /* lshrv4si3_mask */
      if (!register_operand (operands[1], E_V4SImode)
          || !nonimmediate_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9508; /* avx2_lshrvv4si_mask */

    case 4:
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7589; /* lshrv4di3_mask */
      if (!register_operand (operands[1], E_V4DImode)
          || !nonimmediate_operand (operands[2], E_V4DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9516; /* avx2_lshrvv4di_mask */

    case 5:
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7593; /* lshrv2di3_mask */
      if (!register_operand (operands[1], E_V2DImode)
          || !nonimmediate_operand (operands[2], E_V2DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9520; /* avx2_lshrvv2di_mask */

    case 6:
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
        return 7613; /* lshrv32hi3_mask */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9532; /* avx512bw_lshrvv32hi_mask */

    case 7:
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7617; /* lshrv16si3_mask */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9500; /* avx512f_lshrvv16si_mask */

    case 8:
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7621; /* lshrv8di3_mask */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9512; /* avx512f_lshrvv8di_mask */

    default:
      return -1;
    }
}

 int
recog_191 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  switch (GET_CODE (x6))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case REG:
    case SUBREG:
    case MEM:
      switch (pattern488 (x2))
        {
        case 0:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V32HFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
            return -1;
          return 2689; /* *subv32hf3_mask */

        case 1:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V16HFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 2697; /* *subv16hf3_mask */

        case 2:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8HFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 2705; /* *subv8hf3_mask */

        case 3:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V16SFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 2713; /* *subv16sf3_mask */

        case 4:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8SFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 2721; /* *subv8sf3_mask */

        case 5:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V4SFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1)))
            return -1;
          return 2729; /* *subv4sf3_mask */

        case 6:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8DFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 2737; /* *subv8df3_mask */

        case 7:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V4DFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 2745; /* *subv4df3_mask */

        case 8:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V2DFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2753; /* *subv2df3_mask */

        case 9:
          if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V16SImode, operands)) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7414; /* *subv16si3_mask */

        case 10:
          if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V8SImode, operands)) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7416; /* *subv8si3_mask */

        case 11:
          if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V4SImode, operands)) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7418; /* *subv4si3_mask */

        case 12:
          if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V8DImode, operands)) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7420; /* *subv8di3_mask */

        case 13:
          if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V4DImode, operands)) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7422; /* *subv4di3_mask */

        case 14:
          if (!(
#line 16271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V2DImode, operands)) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7424; /* *subv2di3_mask */

        case 15:
          if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V64QImode, operands)) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7426; /* *subv64qi3_mask */

        case 16:
          if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V16QImode, operands)) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7428; /* *subv16qi3_mask */

        case 17:
          if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V32QImode, operands)) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7430; /* *subv32qi3_mask */

        case 18:
          if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V32HImode, operands)) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7432; /* *subv32hi3_mask */

        case 19:
          if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V16HImode, operands)) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7434; /* *subv16hi3_mask */

        case 20:
          if (!(
#line 16285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V8HImode, operands)) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7436; /* *subv8hi3_mask */

        case 21:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10533; /* avx10_2_subbf16_v32bf_mask */

        case 22:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10541; /* avx10_2_subbf16_v16bf_mask */

        case 23:
          if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10549; /* avx10_2_subbf16_v8bf_mask */

        case 24:
          if (!(
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2765; /* avx512fp16_vmsubv8hf3 */

        case 25:
          if (!
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2773; /* sse_vmsubv4sf3 */

        case 26:
          if (!(
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2781; /* sse2_vmsubv2df3 */

        default:
          return -1;
        }

    case PLUS:
      x7 = XEXP (x2, 2);
      if (GET_CODE (x7) != CONST_INT)
        return -1;
      x8 = XEXP (x6, 0);
      if (!rtx_equal_p (x8, operands[1]))
        return -1;
      x9 = XEXP (x6, 1);
      if (!rtx_equal_p (x9, operands[2]))
        return -1;
      switch (XWINT (x7, 0))
        {
        case 85L:
          if (pattern1102 (x2, 
E_V8SFmode) != 0
              || !(
#line 3510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3145; /* vec_addsubv8sf3 */

        case 5L:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1102 (x2, 
E_V4SFmode) != 0
                  || !
#line 3510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3))
                return -1;
              return 3146; /* vec_addsubv4sf3 */

            case E_V4DFmode:
              if (pattern1102 (x2, 
E_V4DFmode) != 0
                  || !(
#line 3510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3147; /* vec_addsubv4df3 */

            default:
              return -1;
            }

        case 1L:
          if (pattern1102 (x2, 
E_V2DFmode) != 0
              || !(
#line 3510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3148; /* vec_addsubv2df3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_200 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern138 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4548; /* avx512fp16_fixuns_truncv8hi2_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4556; /* avx512fp16_fixuns_truncv16hi2_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4564; /* avx512fp16_fixuns_truncv32hi2_mask */

    case 3:
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4572; /* avx512fp16_fixuns_truncv8si2_mask */

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 4963; /* fixuns_truncv8dfv8si2_mask */

        case E_V8SFmode:
          if (!nonimmediate_operand (operands[1], E_V8SFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9900 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 440 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 5063; /* fixuns_truncv8sfv8si2_mask */

        default:
          return -1;
        }

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4580; /* avx512fp16_fixuns_truncv16si2_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 4814; /* fixuns_truncv16sfv16si2_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4588; /* avx512fp16_fixuns_truncv8di2_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 5000; /* fixuns_truncv8dfv8di2_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 5044; /* fixuns_truncv8sfv8di2_mask */

    case 9:
      switch (GET_MODE (operands[1]))
        {
        case E_V4HFmode:
          if (!memory_operand (operands[1], E_V4HFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7919 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4609; /* *avx512fp16_fixuns_truncv4si2_load_mask */

        case E_V4DFmode:
          if (!nonimmediate_operand (operands[1], E_V4DFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512F)))
            return -1;
          return 4977; /* fixuns_truncv4dfv4si2_mask */

        case E_V4SFmode:
          if (!nonimmediate_operand (operands[1], E_V4SFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9900 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5065; /* fixuns_truncv4sfv4si2_mask */

        default:
          return -1;
        }

    case 10:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7919 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4613; /* *avx512fp16_fixuns_truncv4di2_load_mask */

    case 11:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5005; /* fixuns_truncv4dfv4di2_mask */

    case 12:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5049; /* fixuns_truncv4sfv4di2_mask */

    case 13:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4625; /* *avx512fp16_fixuns_truncv2di2_load_mask */

    case 14:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5009; /* fixuns_truncv2dfv2di2_mask */

    case 15:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7909 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4601; /* avx512fp16_fixuns_truncv4si2_mask */

    case 16:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7909 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4605; /* avx512fp16_fixuns_truncv4di2_mask */

    case 17:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7959 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4621; /* avx512fp16_fixuns_truncv2di2_mask */

    case 18:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9752 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL)))
        return -1;
      return 5057; /* avx512dq_fixuns_truncv2sfv2di2_mask */

    default:
      return -1;
    }
}

 int
recog_212 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x2) != E_V8SFmode
          || !vector_operand (operands[1], E_V8SFmode)
          || !(
#line 3138 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 440 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2952; /* avx_rsqrtv8sf2 */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x2) != E_V4SFmode
          || !vector_operand (operands[1], E_V4SFmode)
          || !
#line 3138 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 2953; /* sse_rsqrtv4sf2 */

    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || GET_MODE (x2) != E_V32HFmode
          || !vector_operand (operands[1], E_V32HFmode)
          || !(
#line 3150 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2954; /* avx512fp16_rsqrtv32hf2 */

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || GET_MODE (x2) != E_V16HFmode
          || !vector_operand (operands[1], E_V16HFmode)
          || !(
#line 3150 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2956; /* avx512fp16_rsqrtv16hf2 */

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x2) != E_V8HFmode
          || !vector_operand (operands[1], E_V8HFmode)
          || !(
#line 3150 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2958; /* avx512fp16_rsqrtv8hf2 */

    case E_V32BFmode:
      if (!register_operand (operands[0], E_V32BFmode)
          || GET_MODE (x2) != E_V32BFmode
          || !nonimmediate_operand (operands[1], E_V32BFmode)
          || !
#line 32400 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10602; /* avx10_2_rsqrtbf16_v32bf */

    case E_V16BFmode:
      if (!register_operand (operands[0], E_V16BFmode)
          || GET_MODE (x2) != E_V16BFmode
          || !nonimmediate_operand (operands[1], E_V16BFmode)
          || !
#line 32400 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10604; /* avx10_2_rsqrtbf16_v16bf */

    case E_V8BFmode:
      if (!register_operand (operands[0], E_V8BFmode)
          || GET_MODE (x2) != E_V8BFmode
          || !nonimmediate_operand (operands[1], E_V8BFmode)
          || !
#line 32400 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10606; /* avx10_2_rsqrtbf16_v8bf */

    default:
      return -1;
    }
}

 int
recog_219 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 0);
  x5 = XVECEXP (x4, 0, 0);
  operands[1] = x5;
  x6 = XEXP (x3, 1);
  operands[2] = x6;
  x7 = XEXP (x3, 2);
  operands[3] = x7;
  x8 = XVECEXP (x2, 0, 1);
  operands[4] = x8;
  switch (XINT (x4, 1))
    {
    case 156:
      if (!const_4_or_8_to_11_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HImode:
          if (pattern1288 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4339; /* avx512fp16_vcvtph2uw_v32hi_mask_round */

        case E_V16SImode:
          if (pattern1298 (x2, 
E_V16SImode, 
E_HImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V16HFmode:
              if (!register_operand (operands[1], E_V16HFmode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4347; /* avx512fp16_vcvtph2udq_v16si_mask_round */

            case E_V16SFmode:
              if (!nonimmediate_operand (operands[1], E_V16SFmode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4775; /* avx512f_fixuns_notruncv16sfv16si_mask_round */

            default:
              return -1;
            }

        case E_V8DImode:
          switch (pattern1460 (x2, 
E_V8DImode))
            {
            case 0:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4355; /* avx512fp16_vcvtph2uqq_v8di_mask_round */

            case 1:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
							      || V8DImode == V8DFmode
							      || V8DImode == V8DImode
							      || V8DImode == V16SImode
							      || V8DImode == V32HFmode)) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4795; /* avx512dq_cvtps2uqqv8di_mask_round */

            case 2:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 5021; /* fixuns_notruncv8dfv8di2_mask_round */

            default:
              return -1;
            }

        case E_V16HImode:
          if (pattern1288 (x2, 
E_HImode, 
E_V16HImode, 
E_V16HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4363; /* avx512fp16_vcvtph2uw_v16hi_mask_round */

        case E_V8SImode:
          switch (pattern1460 (x2, 
E_V8SImode))
            {
            case 0:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4371; /* avx512fp16_vcvtph2udq_v8si_mask_round */

            case 1:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4779; /* avx512vl_fixuns_notruncv8sfv8si_mask_round */

            case 2:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4941; /* fixuns_notruncv8dfv8si2_mask_round */

            default:
              return -1;
            }

        case E_V4DImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V4DImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4379; /* avx512fp16_vcvtph2uqq_v4di_mask_round */

        case E_V8HImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V8HImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4387; /* avx512fp16_vcvtph2uw_v8hi_mask_round */

        case E_V4SImode:
          if (pattern1298 (x2, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!register_operand (operands[1], E_V8HFmode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4395; /* avx512fp16_vcvtph2udq_v4si_mask_round */

            case E_V4SFmode:
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4783; /* avx512vl_fixuns_notruncv4sfv4si_mask_round */

            case E_V4DFmode:
              if (!nonimmediate_operand (operands[1], E_V4DFmode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4945; /* fixuns_notruncv4dfv4si2_mask_round */

            default:
              return -1;
            }

        case E_V2DImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V2DImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4403; /* avx512fp16_vcvtph2uqq_v2di_mask_round */

        default:
          return -1;
        }

    case 46:
      if (!const_4_or_8_to_11_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HImode:
          if (pattern1288 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4343; /* avx512fp16_vcvtph2w_v32hi_mask_round */

        case E_V16SImode:
          switch (pattern1290 (x2))
            {
            case 0:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4351; /* avx512fp16_vcvtph2dq_v16si_mask_round */

            case 1:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 4771; /* avx512f_fix_notruncv16sfv16si_mask_round */

            default:
              return -1;
            }

        case E_V8DImode:
          if (pattern1298 (x2, 
E_V8DImode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!register_operand (operands[1], E_V8HFmode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4359; /* avx512fp16_vcvtph2qq_v8di_mask_round */

            case E_V8SFmode:
              if (!nonimmediate_operand (operands[1], E_V8SFmode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8707 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
							      || V8DImode == V8DFmode
							      || V8DImode == V8DImode
							      || V8DImode == V16SImode
							      || V8DImode == V32HFmode)) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4787; /* avx512dq_cvtps2qqv8di_mask_round */

            case E_V8DFmode:
              if (!register_operand (operands[1], E_V8DFmode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 5013; /* fix_notruncv8dfv8di2_mask_round */

            default:
              return -1;
            }

        case E_V16HImode:
          if (pattern1288 (x2, 
E_HImode, 
E_V16HImode, 
E_V16HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4367; /* avx512fp16_vcvtph2w_v16hi_mask_round */

        case E_V8SImode:
          switch (pattern1289 (x2))
            {
            case 0:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4375; /* avx512fp16_vcvtph2dq_v8si_mask_round */

            case 1:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9388 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 4931; /* avx512f_cvtpd2dq512_mask_round */

            default:
              return -1;
            }

        case E_V4DImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V4DImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4383; /* avx512fp16_vcvtph2qq_v4di_mask_round */

        case E_V8HImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V8HImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4391; /* avx512fp16_vcvtph2w_v8hi_mask_round */

        case E_V4SImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V4SImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4399; /* avx512fp16_vcvtph2dq_v4si_mask_round */

        case E_V2DImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V2DImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4407; /* avx512fp16_vcvtph2qq_v2di_mask_round */

        default:
          return -1;
        }

    case 172:
      switch (pattern1291 (x2))
        {
        case 0:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4497; /* unspec_avx512fp16_fix_truncv8hi2_mask_round */

        case 1:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4505; /* unspec_avx512fp16_fix_truncv16hi2_mask_round */

        case 2:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4513; /* unspec_avx512fp16_fix_truncv32hi2_mask_round */

        case 3:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4521; /* unspec_avx512fp16_fix_truncv8si2_mask_round */

        case 4:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9547 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4952; /* unspec_fix_truncv8dfv8si2_mask_round */

        case 5:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4529; /* unspec_avx512fp16_fix_truncv16si2_mask_round */

        case 6:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8754 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4803; /* unspec_fix_truncv16sfv16si2_mask_round */

        case 7:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4537; /* unspec_avx512fp16_fix_truncv8di2_mask_round */

        case 8:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9676 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4981; /* unspec_fix_truncv8dfv8di2_mask_round */

        case 9:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9719 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 5029; /* unspec_fix_truncv8sfv8di2_mask_round */

        default:
          return -1;
        }

    case 173:
      switch (pattern1291 (x2))
        {
        case 0:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4501; /* unspec_avx512fp16_fixuns_truncv8hi2_mask_round */

        case 1:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4509; /* unspec_avx512fp16_fixuns_truncv16hi2_mask_round */

        case 2:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4517; /* unspec_avx512fp16_fixuns_truncv32hi2_mask_round */

        case 3:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4525; /* unspec_avx512fp16_fixuns_truncv8si2_mask_round */

        case 4:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9547 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4956; /* unspec_fixuns_truncv8dfv8si2_mask_round */

        case 5:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4533; /* unspec_avx512fp16_fixuns_truncv16si2_mask_round */

        case 6:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8754 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4807; /* unspec_fixuns_truncv16sfv16si2_mask_round */

        case 7:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4541; /* unspec_avx512fp16_fixuns_truncv8di2_mask_round */

        case 8:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9676 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4985; /* unspec_fixuns_truncv8dfv8di2_mask_round */

        case 9:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9719 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 5033; /* unspec_fixuns_truncv8sfv8di2_mask_round */

        default:
          return -1;
        }

    case 165:
      if (!const48_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern1461 (x2, 
E_V32HFmode, 
E_SImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 6949; /* avx512bw_getexpv32hf_mask_round */

        case E_V16HFmode:
          if (pattern1461 (x2, 
E_V16HFmode, 
E_HImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 6953; /* avx512vl_getexpv16hf_mask_round */

        case E_V8HFmode:
          if (pattern1461 (x2, 
E_V8HFmode, 
E_QImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 6957; /* avx512fp16_getexpv8hf_mask_round */

        case E_V16SFmode:
          if (pattern1461 (x2, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 6961; /* avx512f_getexpv16sf_mask_round */

        case E_V8SFmode:
          if (pattern1461 (x2, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 6965; /* avx512vl_getexpv8sf_mask_round */

        case E_V4SFmode:
          if (pattern1461 (x2, 
E_V4SFmode, 
E_QImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 6969; /* avx512vl_getexpv4sf_mask_round */

        case E_V8DFmode:
          if (pattern1461 (x2, 
E_V8DFmode, 
E_QImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 6973; /* avx512f_getexpv8df_mask_round */

        case E_V4DFmode:
          if (pattern1461 (x2, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 6977; /* avx512vl_getexpv4df_mask_round */

        case E_V2DFmode:
          if (pattern1461 (x2, 
E_V2DFmode, 
E_QImode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 6981; /* avx512vl_getexpv2df_mask_round */

        default:
          return -1;
        }

    case 149:
      if (pattern1292 (x2, 
E_HImode, 
E_V16SFmode, 
E_V16HImode) != 0
          || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29112 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9582; /* avx512f_vcvtph2ps512_mask_round */

    case 265:
      if (pattern1293 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
          || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32519 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 561 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10683; /* avx10_2_cvtph2ibsv32hf_mask_round */

    case 266:
      if (pattern1293 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
          || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32519 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 561 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10687; /* avx10_2_cvtph2iubsv32hf_mask_round */

    case 271:
      if (pattern1292 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
          || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 561 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10699; /* avx10_2_cvttph2ibsv32hf_mask_round */

    case 272:
      if (pattern1292 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
          || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 561 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10703; /* avx10_2_cvttph2iubsv32hf_mask_round */

    case 267:
      if (pattern1293 (x2, 
E_HImode, 
E_V16SImode, 
E_V16SFmode) != 0
          || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32549 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 545 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10715; /* avx10_2_cvtps2ibsv16sf_mask_round */

    case 268:
      if (pattern1293 (x2, 
E_HImode, 
E_V16SImode, 
E_V16SFmode) != 0
          || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32549 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 545 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10719; /* avx10_2_cvtps2iubsv16sf_mask_round */

    case 273:
      if (pattern1292 (x2, 
E_HImode, 
E_V16SImode, 
E_V16SFmode) != 0
          || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32564 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 545 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10731; /* avx10_2_cvttps2ibsv16sf_mask_round */

    case 274:
      if (pattern1292 (x2, 
E_HImode, 
E_V16SImode, 
E_V16SFmode) != 0
          || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32564 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 545 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10735; /* avx10_2_cvttps2iubsv16sf_mask_round */

    case 275:
      switch (pattern1294 (x2))
        {
        case 0:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 385 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10747; /* avx10_2_vcvttps2dqsv16sf_mask_round */

        case 1:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 386 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10763; /* avx10_2_vcvttpd2dqsv8df_mask_round */

        case 2:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32594 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 450 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10779; /* avx10_2_vcvttpd2qqsv8df_mask_round */

        case 3:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 617 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10795; /* avx10_2_vcvttps2qqsv8di_mask_round */

        default:
          return -1;
        }

    case 276:
      switch (pattern1294 (x2))
        {
        case 0:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 385 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10751; /* avx10_2_vcvttps2udqsv16sf_mask_round */

        case 1:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 386 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10767; /* avx10_2_vcvttpd2udqsv8df_mask_round */

        case 2:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32594 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 450 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10783; /* avx10_2_vcvttpd2uqqsv8df_mask_round */

        case 3:
          if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 617 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10799; /* avx10_2_vcvttps2uqqsv8di_mask_round */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_241 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != E_V16QImode)
    return -1;
  x4 = XEXP (x1, 0);
  if (GET_CODE (x4) != MEM
      || GET_MODE (x4) != E_V16QImode)
    return -1;
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  if (GET_MODE (x2) != E_V16QImode)
    return -1;
  switch (pattern1059 (x2, 
E_V16QImode))
    {
    case 0:
      if (!(
#line 22464 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return -1;
      return 8506; /* *sse2_maskmovdqu */

    case 1:
      if (!(
#line 22464 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return -1;
      return 8507; /* *sse2_maskmovdqu */

    default:
      return -1;
    }
}

 int
recog_247 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  switch (GET_CODE (x4))
    {
    case CONST_VECTOR:
      switch (pattern495 (x3))
        {
        case 0:
          if (!
#line 21586 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512VBMI
   && ix86_pre_reload_split ()))
            return -1;
          return 8411; /* *vec_concatv16qi_permt2 */

        case 1:
          if (!
#line 21611 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW
   && ix86_pre_reload_split ()))
            return -1;
          return 8412; /* *vec_concatv8hi_permt2 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x3, 0, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern172 (x3, 
E_V16SImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28134 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9308; /* avx512f_vpermt2varv16si3 */

        case E_V16SFmode:
          if (pattern1019 (x3, 
E_V16SFmode, 
E_V16SImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28134 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9310; /* avx512f_vpermt2varv16sf3 */

        case E_V8DImode:
          if (pattern172 (x3, 
E_V8DImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28135 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9312; /* avx512f_vpermt2varv8di3 */

        case E_V8DFmode:
          if (pattern1019 (x3, 
E_V8DFmode, 
E_V8DImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28135 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9314; /* avx512f_vpermt2varv8df3 */

        case E_V8SImode:
          if (pattern172 (x3, 
E_V8SImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28136 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9316; /* avx512vl_vpermt2varv8si3 */

        case E_V8SFmode:
          if (pattern1019 (x3, 
E_V8SFmode, 
E_V8SImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28136 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9318; /* avx512vl_vpermt2varv8sf3 */

        case E_V4DImode:
          if (pattern172 (x3, 
E_V4DImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28137 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9320; /* avx512vl_vpermt2varv4di3 */

        case E_V4DFmode:
          if (pattern1019 (x3, 
E_V4DFmode, 
E_V4DImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28137 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9322; /* avx512vl_vpermt2varv4df3 */

        case E_V4SImode:
          if (pattern172 (x3, 
E_V4SImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28138 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9324; /* avx512vl_vpermt2varv4si3 */

        case E_V4SFmode:
          if (pattern1019 (x3, 
E_V4SFmode, 
E_V4SImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28138 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9326; /* avx512vl_vpermt2varv4sf3 */

        case E_V2DImode:
          if (pattern172 (x3, 
E_V2DImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28139 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9328; /* avx512vl_vpermt2varv2di3 */

        case E_V2DFmode:
          if (pattern1019 (x3, 
E_V2DFmode, 
E_V2DImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28139 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9330; /* avx512vl_vpermt2varv2df3 */

        case E_V32HImode:
          if (pattern172 (x3, 
E_V32HImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28140 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 9332; /* avx512bw_vpermt2varv32hi3 */

        case E_V16HImode:
          if (pattern172 (x3, 
E_V16HImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28141 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_AVX512VL)))
            return -1;
          return 9334; /* avx512vl_vpermt2varv16hi3 */

        case E_V8HImode:
          if (pattern172 (x3, 
E_V8HImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28142 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_AVX512VL)))
            return -1;
          return 9336; /* avx512vl_vpermt2varv8hi3 */

        case E_V64QImode:
          if (pattern172 (x3, 
E_V64QImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28143 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI && TARGET_EVEX512)))
            return -1;
          return 9338; /* avx512bw_vpermt2varv64qi3 */

        case E_V32QImode:
          if (pattern172 (x3, 
E_V32QImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28144 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI && TARGET_AVX512VL)))
            return -1;
          return 9340; /* avx512vl_vpermt2varv32qi3 */

        case E_V16QImode:
          if (pattern172 (x3, 
E_V16QImode) != 0
              || !(
#line 28227 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 28145 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI && TARGET_AVX512VL)))
            return -1;
          return 9342; /* avx512vl_vpermt2varv16qi3 */

        case E_V32HFmode:
          if (pattern1019 (x3, 
E_V32HFmode, 
E_V32HImode) != 0
              || !(
#line 28242 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9344; /* avx512bw_vpermt2varv32hf3 */

        case E_V16HFmode:
          if (pattern1019 (x3, 
E_V16HFmode, 
E_V16HImode) != 0
              || !(
#line 28242 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9346; /* avx512vl_vpermt2varv16hf3 */

        case E_V8HFmode:
          if (pattern1019 (x3, 
E_V8HFmode, 
E_V8HImode) != 0
              || !(
#line 28242 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9348; /* avx512fp16_vpermt2varv8hf3 */

        case E_V32BFmode:
          if (pattern1019 (x3, 
E_V32BFmode, 
E_V32HImode) != 0
              || !(
#line 28242 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9350; /* avx512bw_vpermt2varv32bf3 */

        case E_V16BFmode:
          if (pattern1019 (x3, 
E_V16BFmode, 
E_V16HImode) != 0
              || !(
#line 28242 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9352; /* avx512vl_vpermt2varv16bf3 */

        case E_V8BFmode:
          if (pattern1019 (x3, 
E_V8BFmode, 
E_V8HImode) != 0
              || !(
#line 28242 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9354; /* avx512vl_vpermt2varv8bf3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_248 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 2);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 1);
  if (!rtx_equal_p (x6, operands[0]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      if (pattern904 (x3, 
E_HImode, 
E_V16SImode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9830; /* avx512f_compressstorev16si_mask */

    case E_V16SFmode:
      if (pattern904 (x3, 
E_HImode, 
E_V16SFmode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9831; /* avx512f_compressstorev16sf_mask */

    case E_V8DImode:
      if (pattern904 (x3, 
E_QImode, 
E_V8DImode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9832; /* avx512f_compressstorev8di_mask */

    case E_V8DFmode:
      if (pattern904 (x3, 
E_QImode, 
E_V8DFmode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9833; /* avx512f_compressstorev8df_mask */

    case E_V8SImode:
      if (pattern904 (x3, 
E_QImode, 
E_V8SImode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9834; /* avx512vl_compressstorev8si_mask */

    case E_V8SFmode:
      if (pattern904 (x3, 
E_QImode, 
E_V8SFmode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9835; /* avx512vl_compressstorev8sf_mask */

    case E_V4DImode:
      if (pattern904 (x3, 
E_QImode, 
E_V4DImode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9836; /* avx512vl_compressstorev4di_mask */

    case E_V4DFmode:
      if (pattern904 (x3, 
E_QImode, 
E_V4DFmode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9837; /* avx512vl_compressstorev4df_mask */

    case E_V4SImode:
      if (pattern904 (x3, 
E_QImode, 
E_V4SImode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9838; /* avx512vl_compressstorev4si_mask */

    case E_V4SFmode:
      if (pattern904 (x3, 
E_QImode, 
E_V4SFmode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9839; /* avx512vl_compressstorev4sf_mask */

    case E_V2DImode:
      if (pattern904 (x3, 
E_QImode, 
E_V2DImode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9840; /* avx512vl_compressstorev2di_mask */

    case E_V2DFmode:
      if (pattern904 (x3, 
E_QImode, 
E_V2DFmode) != 0
          || !(
#line 29683 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9841; /* avx512vl_compressstorev2df_mask */

    case E_V64QImode:
      if (pattern904 (x3, 
E_DImode, 
E_V64QImode) != 0
          || !(
#line 29697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9842; /* compressstorev64qi_mask */

    case E_V16QImode:
      if (pattern904 (x3, 
E_HImode, 
E_V16QImode) != 0
          || !(
#line 29697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9843; /* compressstorev16qi_mask */

    case E_V32QImode:
      if (pattern904 (x3, 
E_SImode, 
E_V32QImode) != 0
          || !(
#line 29697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9844; /* compressstorev32qi_mask */

    case E_V32HImode:
      if (pattern904 (x3, 
E_SImode, 
E_V32HImode) != 0
          || !(
#line 29697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9845; /* compressstorev32hi_mask */

    case E_V16HImode:
      if (pattern904 (x3, 
E_HImode, 
E_V16HImode) != 0
          || !(
#line 29697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9846; /* compressstorev16hi_mask */

    case E_V8HImode:
      if (pattern904 (x3, 
E_QImode, 
E_V8HImode) != 0
          || !(
#line 29697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9847; /* compressstorev8hi_mask */

    default:
      return -1;
    }
}

 int
recog_256 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern175 (x1))
    {
    case 0:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10109; /* vpshrd_v32hi */

    case 1:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10111; /* vpshrd_v16si */

    case 2:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10113; /* vpshrd_v8di */

    case 3:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10115; /* vpshrd_v16hi */

    case 4:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10117; /* vpshrd_v8si */

    case 5:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10119; /* vpshrd_v4di */

    case 6:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10121; /* vpshrd_v8hi */

    case 7:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10123; /* vpshrd_v4si */

    case 8:
      if (!(
#line 30399 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10125; /* vpshrd_v2di */

    default:
      return -1;
    }
}

 int
recog_263 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 175:
      return recog_236 (x1, insn, pnum_clobbers);

    case 178:
      return recog_229 (x1, insn, pnum_clobbers);

    case 63:
      switch (pattern153 (x1))
        {
        case 0:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return -1;
          return 3043; /* ieee_maxv32hf3 */

        case 1:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 3051; /* ieee_maxv16hf3 */

        case 2:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 3055; /* ieee_maxv8hf3 */

        case 3:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 3059; /* ieee_maxv16sf3 */

        case 4:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3067; /* ieee_maxv8sf3 */

        case 5:
          if (!
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1))
            return -1;
          return 3071; /* ieee_maxv4sf3 */

        case 6:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 3075; /* ieee_maxv8df3 */

        case 7:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3083; /* ieee_maxv4df3 */

        case 8:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3087; /* ieee_maxv2df3 */

        default:
          return -1;
        }

    case 62:
      switch (pattern153 (x1))
        {
        case 0:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return -1;
          return 3047; /* ieee_minv32hf3 */

        case 1:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 3053; /* ieee_minv16hf3 */

        case 2:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 3057; /* ieee_minv8hf3 */

        case 3:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 3063; /* ieee_minv16sf3 */

        case 4:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3069; /* ieee_minv8sf3 */

        case 5:
          if (!
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1))
            return -1;
          return 3073; /* ieee_minv4sf3 */

        case 6:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 3079; /* ieee_minv8df3 */

        case 7:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3085; /* ieee_minv4df3 */

        case 8:
          if (!(
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3089; /* ieee_minv2df3 */

        default:
          return -1;
        }

    case 192:
      return recog_235 (x1, insn, pnum_clobbers);

    case 221:
      switch (pattern155 (x1))
        {
        case 0:
          if (!(
#line 7322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4300; /* avx512bw_fmulc_v32hf */

        case 1:
          if (!(
#line 7322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4308; /* avx512vl_fmulc_v16hf */

        case 2:
          if (!(
#line 7322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4312; /* avx512fp16_fmulc_v8hf */

        default:
          return -1;
        }

    case 222:
      switch (pattern155 (x1))
        {
        case 0:
          if (!(
#line 7322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4304; /* avx512bw_fcmulc_v32hf */

        case 1:
          if (!(
#line 7322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4310; /* avx512vl_fcmulc_v16hf */

        case 2:
          if (!(
#line 7322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4314; /* avx512fp16_fcmulc_v8hf */

        default:
          return -1;
        }

    case 58:
      return recog_237 (x1, insn, pnum_clobbers);

    case 94:
      return recog_232 (x1, insn, pnum_clobbers);

    case 188:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern163 (x2, 
E_V16SImode, 
E_V32HImode) != 0
              || !(
#line 16657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && 1) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7515; /* avx512bw_pmaddwd512v32hi */

        case E_V8SImode:
          if (pattern163 (x2, 
E_V8SImode, 
E_V16HImode) != 0
              || !(
#line 16657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && 1) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7517; /* avx512bw_pmaddwd512v16hi */

        case E_V4SImode:
          if (pattern163 (x2, 
E_V4SImode, 
E_V8HImode) != 0
              || !
#line 16657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && 1))
            return -1;
          return 7519; /* avx512bw_pmaddwd512v8hi */

        default:
          return -1;
        }

    case 57:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V64QImode:
          if (pattern729 (x2, 
E_V32HImode, 
E_V64QImode) != 0
              || !(
#line 19362 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1) && 
#line 632 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8240; /* avx512bw_packuswb */

        case E_V32QImode:
          if (pattern729 (x2, 
E_V16HImode, 
E_V32QImode) != 0
              || !(
#line 19362 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1) && 
#line 632 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8242; /* avx2_packuswb */

        case E_V16QImode:
          if (pattern729 (x2, 
E_V8HImode, 
E_V16QImode) != 0
              || !
#line 19362 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
            return -1;
          return 8244; /* sse2_packuswb */

        case E_V32HImode:
          if (pattern729 (x2, 
E_V16SImode, 
E_V32HImode) != 0
              || !(
#line 23844 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8655; /* avx512bw_packusdw */

        case E_V16HImode:
          if (pattern729 (x2, 
E_V8SImode, 
E_V16HImode) != 0
              || !(
#line 23844 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1) && 
#line 652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8657; /* avx2_packusdw */

        case E_V8HImode:
          if (pattern729 (x2, 
E_V4SImode, 
E_V8HImode) != 0
              || !
#line 23844 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1))
            return -1;
          return 8659; /* sse4_1_packusdw */

        default:
          return -1;
        }

    case 190:
      if (pattern156 (x1) != 0
          || !
#line 20701 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
        return -1;
      return 8370; /* *avx512bw_pshuflwv32hi */

    case 189:
      if (pattern156 (x1) != 0
          || !
#line 20877 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
        return -1;
      return 8376; /* *avx512bw_pshufhwv32hi */

    case 56:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DImode:
          if (pattern776 (x2, 
E_V64QImode, 
E_V8DImode) != 0
              || !(
#line 21917 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ix86_binary_operator_ok (PLUS, V64QImode, operands)) && 
#line 701 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8432; /* *avx512f_psadbw */

        case E_V4DImode:
          if (pattern776 (x2, 
E_V32QImode, 
E_V4DImode) != 0
              || !(
#line 21917 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ix86_binary_operator_ok (PLUS, V32QImode, operands)) && 
#line 701 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8433; /* *avx2_psadbw */

        case E_V2DImode:
          if (pattern776 (x2, 
E_V16QImode, 
E_V2DImode) != 0
              || !
#line 21917 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && ix86_binary_operator_ok (PLUS, V16QImode, operands)))
            return -1;
          return 8434; /* *sse2_psadbw */

        default:
          return -1;
        }

    case 187:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HImode:
          if (pattern163 (x2, 
E_V8HImode, 
E_V16QImode) != 0
              || !(
#line 22795 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8533; /* avx512bw_pmaddubsw512v8hi */

        case E_V16HImode:
          if (pattern163 (x2, 
E_V16HImode, 
E_V32QImode) != 0
              || !(
#line 22795 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8535; /* avx512bw_pmaddubsw512v16hi */

        case E_V32HImode:
          if (pattern163 (x2, 
E_V32HImode, 
E_V64QImode) != 0
              || !(
#line 22795 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8537; /* avx512bw_pmaddubsw512v32hi */

        default:
          return -1;
        }

    case 52:
      switch (pattern157 (x1))
        {
        case 0:
          if (!(
#line 23120 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && 1 && 1) && 
#line 632 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8551; /* avx512bw_pshufbv64qi3 */

        case 1:
          if (!(
#line 23120 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && 1 && 1) && 
#line 632 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8553; /* avx2_pshufbv32qi3 */

        case 2:
          if (!
#line 23120 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && 1 && 1))
            return -1;
          return 8555; /* ssse3_pshufbv16qi3 */

        default:
          return -1;
        }

    case 120:
      return recog_240 (x1, insn, pnum_clobbers);

    case 123:
      if (pattern158 (x1, 
E_V16QImode, 
E_V2DImode) != 0
          || !
#line 23450 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4A))
        return -1;
      return 8603; /* sse4a_extrq */

    case 125:
      if (pattern159 (x1, 
E_V2DImode) != 0
          || !
#line 23476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4A))
        return -1;
      return 8605; /* sse4a_insertq */

    case 130:
      return recog_231 (x1, insn, pnum_clobbers);

    case 137:
      if (pattern160 (x1, 
E_V2DImode) != 0
          || !
#line 27101 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AES || (TARGET_VAES && TARGET_AVX512VL)))
        return -1;
      return 9008; /* aesenc */

    case 138:
      if (pattern160 (x1, 
E_V2DImode) != 0
          || !
#line 27119 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AES || (TARGET_VAES && TARGET_AVX512VL)))
        return -1;
      return 9009; /* aesenclast */

    case 139:
      if (pattern160 (x1, 
E_V2DImode) != 0
          || !
#line 27137 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AES || (TARGET_VAES && TARGET_AVX512VL)))
        return -1;
      return 9010; /* aesdec */

    case 140:
      if (pattern160 (x1, 
E_V2DImode) != 0
          || !
#line 27155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AES || (TARGET_VAES && TARGET_AVX512VL)))
        return -1;
      return 9011; /* aesdeclast */

    case 142:
      if (GET_MODE (x2) != E_V2DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_V2DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!vector_operand (operands[1], E_V2DImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_SImode)
          || !
#line 27185 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AES))
        return -1;
      return 9013; /* aeskeygenassist */

    case 151:
      return recog_233 (x1, insn, pnum_clobbers);

    case 144:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern779 (x2, 
E_V16SImode, 
E_V16SFmode) != 0
              || !(
#line 28125 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1) && 
#line 374 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9278; /* avx512f_vpermilvarv16sf3 */

        case E_V8SFmode:
          if (pattern779 (x2, 
E_V8SImode, 
E_V8SFmode) != 0
              || !(
#line 28125 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1) && 
#line 374 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 9280; /* avx_vpermilvarv8sf3 */

        case E_V4SFmode:
          if (pattern779 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
              || !
#line 28125 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
            return -1;
          return 9282; /* avx_vpermilvarv4sf3 */

        case E_V8DFmode:
          if (pattern779 (x2, 
E_V8DImode, 
E_V8DFmode) != 0
              || !(
#line 28125 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1) && 
#line 375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9284; /* avx512f_vpermilvarv8df3 */

        case E_V4DFmode:
          if (pattern779 (x2, 
E_V4DImode, 
E_V4DFmode) != 0
              || !(
#line 28125 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1) && 
#line 375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 9286; /* avx_vpermilvarv4df3 */

        case E_V2DFmode:
          if (pattern779 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
              || !(
#line 28125 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1) && 
#line 376 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 9288; /* avx_vpermilvarv2df3 */

        default:
          return -1;
        }

    case 47:
      return recog_238 (x1, insn, pnum_clobbers);

    case 150:
      return recog_239 (x1, insn, pnum_clobbers);

    case 160:
      return recog_230 (x1, insn, pnum_clobbers);

    case 166:
      return recog_234 (x1, insn, pnum_clobbers);

    case 179:
      if (pattern160 (x1, 
E_V4SImode) != 0
          || !
#line 29961 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10010; /* sha1msg1 */

    case 180:
      if (pattern160 (x1, 
E_V4SImode) != 0
          || !
#line 29972 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10011; /* sha1msg2 */

    case 181:
      if (pattern160 (x1, 
E_V4SImode) != 0
          || !
#line 29983 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10012; /* sha1nexte */

    case 183:
      if (pattern160 (x1, 
E_V4SImode) != 0
          || !
#line 30007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10014; /* sha256msg1 */

    case 184:
      if (pattern160 (x1, 
E_V4SImode) != 0
          || !
#line 30018 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10015; /* sha256msg2 */

    case 239:
      if (pattern158 (x1, 
E_V2DImode, 
E_V4DImode) != 0
          || !
#line 30080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA512))
        return -1;
      return 10020; /* vsha512msg1 */

    case 240:
      if (pattern159 (x1, 
E_V4DImode) != 0
          || !
#line 30091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA512))
        return -1;
      return 10021; /* vsha512msg2 */

    case 242:
      switch (pattern161 (x1))
        {
        case 0:
          if (!(
#line 30114 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM4) && 
#line 677 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10023; /* vsm4key4_v16si */

        case 1:
          if (!
#line 30114 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM4))
            return -1;
          return 10024; /* vsm4key4_v8si */

        case 2:
          if (!
#line 30114 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM4))
            return -1;
          return 10025; /* vsm4key4_v4si */

        default:
          return -1;
        }

    case 243:
      switch (pattern161 (x1))
        {
        case 0:
          if (!(
#line 30127 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM4) && 
#line 677 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10026; /* vsm4rnds4_v16si */

        case 1:
          if (!
#line 30127 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM4))
            return -1;
          return 10027; /* vsm4rnds4_v8si */

        case 2:
          if (!
#line 30127 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM4))
            return -1;
          return 10028; /* vsm4rnds4_v4si */

        default:
          return -1;
        }

    case 197:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V64QImode:
          if (pattern61 (x2, 
E_V64QImode) != 0
              || !(
#line 30273 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI) && 
#line 327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 10053; /* vpmultishiftqbv64qi */

        case E_V16QImode:
          if (pattern61 (x2, 
E_V16QImode) != 0
              || !(
#line 30273 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI) && 
#line 327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10055; /* vpmultishiftqbv16qi */

        case E_V32QImode:
          if (pattern61 (x2, 
E_V32QImode) != 0
              || !(
#line 30273 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI) && 
#line 327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10057; /* vpmultishiftqbv32qi */

        default:
          return -1;
        }

    case 200:
      switch (pattern157 (x1))
        {
        case 0:
          if (!(
#line 30382 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10103; /* vgf2p8mulb_v64qi */

        case 1:
          if (!(
#line 30382 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10105; /* vgf2p8mulb_v32qi */

        case 2:
          if (!
#line 30382 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI))
            return -1;
          return 10107; /* vgf2p8mulb_v16qi */

        default:
          return -1;
        }

    case 209:
      switch (pattern162 (x1))
        {
        case 0:
          if (!
#line 30858 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES))
            return -1;
          return 10235; /* vaesdec_v32qi */

        case 1:
          if (!(
#line 30858 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES) && 
#line 698 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10236; /* vaesdec_v16qi */

        case 2:
          if (!(
#line 30858 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES) && 
#line 698 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10237; /* vaesdec_v64qi */

        default:
          return -1;
        }

    case 210:
      switch (pattern162 (x1))
        {
        case 0:
          if (!
#line 30876 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES))
            return -1;
          return 10238; /* vaesdeclast_v32qi */

        case 1:
          if (!(
#line 30876 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES) && 
#line 698 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10239; /* vaesdeclast_v16qi */

        case 2:
          if (!(
#line 30876 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES) && 
#line 698 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10240; /* vaesdeclast_v64qi */

        default:
          return -1;
        }

    case 211:
      switch (pattern162 (x1))
        {
        case 0:
          if (!
#line 30894 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES))
            return -1;
          return 10241; /* vaesenc_v32qi */

        case 1:
          if (!(
#line 30894 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES) && 
#line 698 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10242; /* vaesenc_v16qi */

        case 2:
          if (!(
#line 30894 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES) && 
#line 698 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10243; /* vaesenc_v64qi */

        default:
          return -1;
        }

    case 212:
      switch (pattern162 (x1))
        {
        case 0:
          if (!
#line 30912 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES))
            return -1;
          return 10244; /* vaesenclast_v32qi */

        case 1:
          if (!(
#line 30912 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES) && 
#line 698 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10245; /* vaesenclast_v16qi */

        case 2:
          if (!(
#line 30912 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VAES) && 
#line 698 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10246; /* vaesenclast_v64qi */

        default:
          return -1;
        }

    case 249:
      switch (pattern164 (x1))
        {
        case 0:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10371; /* vcvt2ph2bf8v32hf */

        case 1:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10379; /* vcvt2ph2bf8v16hf */

        case 2:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10387; /* vcvt2ph2bf8v8hf */

        default:
          return -1;
        }

    case 250:
      switch (pattern164 (x1))
        {
        case 0:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10373; /* vcvt2ph2bf8sv32hf */

        case 1:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10381; /* vcvt2ph2bf8sv16hf */

        case 2:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10389; /* vcvt2ph2bf8sv8hf */

        default:
          return -1;
        }

    case 251:
      switch (pattern164 (x1))
        {
        case 0:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10375; /* vcvt2ph2hf8v32hf */

        case 1:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10383; /* vcvt2ph2hf8v16hf */

        case 2:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10391; /* vcvt2ph2hf8v8hf */

        default:
          return -1;
        }

    case 252:
      switch (pattern164 (x1))
        {
        case 0:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10377; /* vcvt2ph2hf8sv32hf */

        case 1:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10385; /* vcvt2ph2hf8sv16hf */

        case 2:
          if (!
#line 31749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10393; /* vcvt2ph2hf8sv8hf */

        default:
          return -1;
        }

    case 245:
      switch (pattern166 (x1))
        {
        case 0:
          if (!
#line 31838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10403; /* vcvtbiasph2bf8v32hf */

        case 1:
          if (!
#line 31838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10411; /* vcvtbiasph2bf8v16hf */

        default:
          return -1;
        }

    case 246:
      switch (pattern166 (x1))
        {
        case 0:
          if (!
#line 31838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10405; /* vcvtbiasph2bf8sv32hf */

        case 1:
          if (!
#line 31838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10413; /* vcvtbiasph2bf8sv16hf */

        default:
          return -1;
        }

    case 247:
      switch (pattern166 (x1))
        {
        case 0:
          if (!
#line 31838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10407; /* vcvtbiasph2hf8v32hf */

        case 1:
          if (!
#line 31838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10415; /* vcvtbiasph2hf8v16hf */

        default:
          return -1;
        }

    case 248:
      switch (pattern166 (x1))
        {
        case 0:
          if (!
#line 31838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10409; /* vcvtbiasph2hf8sv32hf */

        case 1:
          if (!
#line 31838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10417; /* vcvtbiasph2hf8sv16hf */

        default:
          return -1;
        }

    case 258:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V32BFmode:
          if (pattern61 (x2, 
E_V32BFmode) != 0
              || !
#line 32105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10512; /* avx10_2_scalefbf16_v32bf */

        case E_V16BFmode:
          if (pattern61 (x2, 
E_V16BFmode) != 0
              || !
#line 32105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10514; /* avx10_2_scalefbf16_v16bf */

        case E_V8BFmode:
          if (pattern61 (x2, 
E_V8BFmode) != 0
              || !
#line 32105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10516; /* avx10_2_scalefbf16_v8bf */

        default:
          return -1;
        }

    case 259:
      switch (pattern167 (x1))
        {
        case 0:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10626; /* avx10_2_rndscalebf16_v32bf */

        case 1:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10632; /* avx10_2_rndscalebf16_v16bf */

        case 2:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10638; /* avx10_2_rndscalebf16_v8bf */

        default:
          return -1;
        }

    case 260:
      switch (pattern167 (x1))
        {
        case 0:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10628; /* avx10_2_reducebf16_v32bf */

        case 1:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10634; /* avx10_2_reducebf16_v16bf */

        case 2:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10640; /* avx10_2_reducebf16_v8bf */

        default:
          return -1;
        }

    case 261:
      switch (pattern167 (x1))
        {
        case 0:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10630; /* avx10_2_getmantbf16_v32bf */

        case 1:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10636; /* avx10_2_getmantbf16_v16bf */

        case 2:
          if (!
#line 32446 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10642; /* avx10_2_getmantbf16_v8bf */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_288 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (GET_CODE (x5) == CONST_INT)
    {
      res = recog_285 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  operands[2] = x4;
  res = recog_287 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x4, 0) != 0L
      || x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XVECEXP (x3, 0, 2);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x3, 0, 3);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
      || !register_operand (operands[0], E_V8HImode)
      || GET_MODE (x2) != E_V8HImode
      || !vector_operand (operands[1], E_V8HImode)
      || pattern1471 (x3) != 0
      || !
#line 20991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
    return -1;
  return 8380; /* sse2_pshufhw_1 */
}

 int
recog_295 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (XVECLEN (x3, 0))
    {
    case 2:
      res = recog_282 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case 4:
      res = recog_284 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case 8:
      res = recog_288 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case 16:
      res = recog_292 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case 32:
      res = recog_293 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    default:
      break;
    }
  if (XVECLEN (x3, 0) >= 1)
    {
      operands[2] = x3;
      res = recog_294 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  switch (XVECLEN (x3, 0))
    {
    case 4:
      if (pattern669 (x2, 
E_V4DFmode) != 0
          || !
#line 27555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9098; /* avx2_permv4df_1 */

    case 8:
      if (pattern669 (x2, 
E_V8DFmode) != 0)
        return -1;
      x4 = XVECEXP (x3, 0, 4);
      operands[6] = x4;
      if (!const_4_to_7_operand (operands[6], E_VOIDmode))
        return -1;
      x5 = XVECEXP (x3, 0, 5);
      operands[7] = x5;
      if (!const_4_to_7_operand (operands[7], E_VOIDmode))
        return -1;
      x6 = XVECEXP (x3, 0, 6);
      operands[8] = x6;
      if (!const_4_to_7_operand (operands[8], E_VOIDmode))
        return -1;
      x7 = XVECEXP (x3, 0, 7);
      operands[9] = x7;
      if (!const_4_to_7_operand (operands[9], E_VOIDmode)
          || !(
#line 27626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1
   && (INTVAL (operands[2]) == (INTVAL (operands[6]) - 4)
       && INTVAL (operands[3]) == (INTVAL (operands[7]) - 4)
       && INTVAL (operands[4]) == (INTVAL (operands[8]) - 4)
       && INTVAL (operands[5]) == (INTVAL (operands[9]) - 4))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9100; /* avx512f_permv8df_1 */

    default:
      return -1;
    }
}

 int
recog_300 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case NOT:
      switch (pattern337 (x2))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_V16BFmode:
              if (pattern608 (x2, 
E_V16BFmode) != 0
                  || !(
#line 5239 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)) && 
#line 426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3655; /* avx512bf16_andnotv16bf3 */

            case E_V8BFmode:
              if (pattern608 (x2, 
E_V8BFmode) != 0
                  || !(
#line 5239 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)) && 
#line 426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 3656; /* avx512bf16_andnotv8bf3 */

            case E_V16HFmode:
              if (pattern608 (x2, 
E_V16HFmode) != 0
                  || !(
#line 5239 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)) && 
#line 427 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3657; /* avx512fp16_andnotv16hf3 */

            case E_V8HFmode:
              if (pattern608 (x2, 
E_V8HFmode) != 0
                  || !(
#line 5239 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)) && 
#line 427 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 3658; /* avx512fp16_andnotv8hf3 */

            case E_V8SFmode:
              if (pattern608 (x2, 
E_V8SFmode) != 0
                  || !(
#line 5239 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 32 != 16)) && 
#line 428 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3659; /* avx_andnotv8sf3 */

            case E_V4SFmode:
              if (pattern608 (x2, 
E_V4SFmode) != 0
                  || !
#line 5239 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 32 != 16)))
                return -1;
              return 3661; /* sse_andnotv4sf3 */

            case E_V4DFmode:
              if (pattern608 (x2, 
E_V4DFmode) != 0
                  || !(
#line 5239 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 64 != 16)) && 
#line 429 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3663; /* avx_andnotv4df3 */

            case E_V2DFmode:
              if (pattern608 (x2, 
E_V2DFmode) != 0
                  || !(
#line 5239 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 64 != 16)) && 
#line 429 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 3665; /* sse2_andnotv2df3 */

            case E_V32BFmode:
              if (pattern735 (x2, 
E_V32BFmode) != 0
                  || !(
#line 5314 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (!false || 16 != 16)) && 
#line 491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3667; /* avx512bf16_andnotv32bf3 */

            case E_V32HFmode:
              if (pattern735 (x2, 
E_V32HFmode) != 0
                  || !(
#line 5314 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (!false || 16 != 16)) && 
#line 492 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3668; /* avx512fp16_andnotv32hf3 */

            case E_V16SFmode:
              if (pattern735 (x2, 
E_V16SFmode) != 0
                  || !(
#line 5314 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (!false || 32 != 16)) && 
#line 493 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3669; /* avx512f_andnotv16sf3 */

            case E_V8DFmode:
              if (pattern735 (x2, 
E_V8DFmode) != 0
                  || !(
#line 5314 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (!false || 64 != 16)) && 
#line 494 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3671; /* avx512f_andnotv8df3 */

            case E_V1TImode:
              if (pattern608 (x2, 
E_V1TImode) != 0
                  || !
#line 5605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return -1;
              return 3744; /* *andnotv1ti3 */

            case E_V16SImode:
              if (pattern921 (x2, 
E_V16SImode) != 0
                  || !(
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V16SImode)
       || register_operand (operands[2], V16SImode))) && 
#line 568 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7913; /* *andnotv16si3 */

            case E_V8DImode:
              if (pattern921 (x2, 
E_V8DImode) != 0
                  || !(
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V8DImode)
       || register_operand (operands[2], V8DImode))) && 
#line 569 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7914; /* *andnotv8di3 */

            case E_V64QImode:
              if (pattern921 (x2, 
E_V64QImode) != 0
                  || !(
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V64QImode)
       || register_operand (operands[2], V64QImode))) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 7915; /* *andnotv64qi3 */

            case E_V32QImode:
              if (pattern921 (x2, 
E_V32QImode) != 0
                  || !(
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V32QImode)
       || register_operand (operands[2], V32QImode))) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7916; /* *andnotv32qi3 */

            case E_V16QImode:
              if (pattern921 (x2, 
E_V16QImode) != 0
                  || !
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V16QImode)
       || register_operand (operands[2], V16QImode))))
                return -1;
              return 7917; /* *andnotv16qi3 */

            case E_V32HImode:
              if (pattern921 (x2, 
E_V32HImode) != 0
                  || !(
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V32HImode)
       || register_operand (operands[2], V32HImode))) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 7918; /* *andnotv32hi3 */

            case E_V16HImode:
              if (pattern921 (x2, 
E_V16HImode) != 0
                  || !(
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V16HImode)
       || register_operand (operands[2], V16HImode))) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7919; /* *andnotv16hi3 */

            case E_V8HImode:
              if (pattern921 (x2, 
E_V8HImode) != 0
                  || !
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V8HImode)
       || register_operand (operands[2], V8HImode))))
                return -1;
              return 7920; /* *andnotv8hi3 */

            case E_V8SImode:
              if (pattern921 (x2, 
E_V8SImode) != 0
                  || !(
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V8SImode)
       || register_operand (operands[2], V8SImode))) && 
#line 572 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7921; /* *andnotv8si3 */

            case E_V4SImode:
              if (pattern921 (x2, 
E_V4SImode) != 0
                  || !
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V4SImode)
       || register_operand (operands[2], V4SImode))))
                return -1;
              return 7922; /* *andnotv4si3 */

            case E_V4DImode:
              if (pattern921 (x2, 
E_V4DImode) != 0
                  || !(
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V4DImode)
       || register_operand (operands[2], V4DImode))) && 
#line 573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7923; /* *andnotv4di3 */

            case E_V2DImode:
              if (pattern921 (x2, 
E_V2DImode) != 0
                  || !
#line 18473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[1], V2DImode)
       || register_operand (operands[2], V2DImode))))
                return -1;
              return 7924; /* *andnotv2di3 */

            default:
              return -1;
            }

        case 1:
          if (!(
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16SImode)
       || register_operand (operands[2], V16SImode))) && 
#line 568 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 8012; /* *norv16si3 */

        case 2:
          if (!(
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8DImode)
       || register_operand (operands[2], V8DImode))) && 
#line 569 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 8014; /* *norv8di3 */

        case 3:
          if (!(
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V64QImode)
       || register_operand (operands[2], V64QImode))) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8016; /* *norv64qi3 */

        case 4:
          if (!(
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V32QImode)
       || register_operand (operands[2], V32QImode))) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 8018; /* *norv32qi3 */

        case 5:
          if (!
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16QImode)
       || register_operand (operands[2], V16QImode))))
            return -1;
          return 8020; /* *norv16qi3 */

        case 6:
          if (!(
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V32HImode)
       || register_operand (operands[2], V32HImode))) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8022; /* *norv32hi3 */

        case 7:
          if (!(
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16HImode)
       || register_operand (operands[2], V16HImode))) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 8024; /* *norv16hi3 */

        case 8:
          if (!
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8HImode)
       || register_operand (operands[2], V8HImode))))
            return -1;
          return 8026; /* *norv8hi3 */

        case 9:
          if (!(
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8SImode)
       || register_operand (operands[2], V8SImode))) && 
#line 572 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 8028; /* *norv8si3 */

        case 10:
          if (!
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V4SImode)
       || register_operand (operands[2], V4SImode))))
            return -1;
          return 8030; /* *norv4si3 */

        case 11:
          if (!(
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V4DImode)
       || register_operand (operands[2], V4DImode))) && 
#line 573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 8032; /* *norv4di3 */

        case 12:
          if (!
#line 19007 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V2DImode)
       || register_operand (operands[2], V2DImode))))
            return -1;
          return 8034; /* *norv2di3 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      return recog_297 (x1, insn, pnum_clobbers);

    case AND:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern529 (x2))
            {
            case 0:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5428; /* *avx512bw_vpternlogv64qi_1 */

            case 1:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5455; /* *avx512vl_vpternlogv32qi_1 */

            case 2:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5482; /* *avx512vl_vpternlogv16qi_1 */

            case 3:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5509; /* *avx512bw_vpternlogv32hi_1 */

            case 4:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5536; /* *avx512vl_vpternlogv16hi_1 */

            case 5:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5563; /* *avx512vl_vpternlogv8hi_1 */

            case 6:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5590; /* *avx512f_vpternlogv16si_1 */

            case 7:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5617; /* *avx512vl_vpternlogv8si_1 */

            case 8:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5644; /* *avx512vl_vpternlogv4si_1 */

            case 9:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5671; /* *avx512f_vpternlogv8di_1 */

            case 10:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5698; /* *avx512vl_vpternlogv4di_1 */

            case 11:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5725; /* *avx512vl_vpternlogv2di_1 */

            case 12:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5431; /* *avx512bw_vpternlogv64qi_1 */

            case 13:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5458; /* *avx512vl_vpternlogv32qi_1 */

            case 14:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5485; /* *avx512vl_vpternlogv16qi_1 */

            case 15:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5512; /* *avx512bw_vpternlogv32hi_1 */

            case 16:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5539; /* *avx512vl_vpternlogv16hi_1 */

            case 17:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5566; /* *avx512vl_vpternlogv8hi_1 */

            case 18:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5593; /* *avx512f_vpternlogv16si_1 */

            case 19:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5620; /* *avx512vl_vpternlogv8si_1 */

            case 20:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5647; /* *avx512vl_vpternlogv4si_1 */

            case 21:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5674; /* *avx512f_vpternlogv8di_1 */

            case 22:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5701; /* *avx512vl_vpternlogv4di_1 */

            case 23:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5728; /* *avx512vl_vpternlogv2di_1 */

            case 24:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5434; /* *avx512bw_vpternlogv64qi_1 */

            case 25:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5461; /* *avx512vl_vpternlogv32qi_1 */

            case 26:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5488; /* *avx512vl_vpternlogv16qi_1 */

            case 27:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5515; /* *avx512bw_vpternlogv32hi_1 */

            case 28:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5542; /* *avx512vl_vpternlogv16hi_1 */

            case 29:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5569; /* *avx512vl_vpternlogv8hi_1 */

            case 30:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5596; /* *avx512f_vpternlogv16si_1 */

            case 31:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5623; /* *avx512vl_vpternlogv8si_1 */

            case 32:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5650; /* *avx512vl_vpternlogv4si_1 */

            case 33:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5677; /* *avx512f_vpternlogv8di_1 */

            case 34:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5704; /* *avx512vl_vpternlogv4di_1 */

            case 35:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5731; /* *avx512vl_vpternlogv2di_1 */

            case 36:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6724; /* *avx512bw_vpternlogv64qi_3 */

            case 37:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6733; /* *avx512vl_vpternlogv32qi_3 */

            case 38:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6742; /* *avx512vl_vpternlogv16qi_3 */

            case 39:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6751; /* *avx512bw_vpternlogv32hi_3 */

            case 40:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6760; /* *avx512vl_vpternlogv16hi_3 */

            case 41:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6769; /* *avx512vl_vpternlogv8hi_3 */

            case 42:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6778; /* *avx512f_vpternlogv16si_3 */

            case 43:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6787; /* *avx512vl_vpternlogv8si_3 */

            case 44:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6796; /* *avx512vl_vpternlogv4si_3 */

            case 45:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6805; /* *avx512f_vpternlogv8di_3 */

            case 46:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6814; /* *avx512vl_vpternlogv4di_3 */

            case 47:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6823; /* *avx512vl_vpternlogv2di_3 */

            default:
              return -1;
            }

        case AND:
          switch (pattern531 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6076; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6103; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6130; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6157; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6184; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6211; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6238; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6265; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6292; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6319; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6346; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6373; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        case IOR:
          switch (pattern531 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6079; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6106; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6133; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6160; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6187; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6214; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6241; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6268; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6295; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6322; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6349; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6376; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        case XOR:
          switch (pattern531 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6082; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6109; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6136; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6163; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6190; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6217; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6244; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6271; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6298; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6325; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6352; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6379; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case IOR:
      return recog_299 (x1, insn, pnum_clobbers);

    case XOR:
      return recog_298 (x1, insn, pnum_clobbers);

    case GT:
      switch (pattern339 (x2))
        {
        case 0:
          if (!(
#line 17311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2 && ix86_pre_reload_split ()) && 
#line 704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7606; /* *avx2_lshrv4di3_1 */

        case 1:
          if (!
#line 17311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2 && ix86_pre_reload_split ()))
            return -1;
          return 7607; /* *avx2_lshrv2di3_1 */

        default:
          return -1;
        }

    case LT:
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      x6 = XEXP (x2, 1);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V4DImode:
          if (pattern922 (x2, 
E_V4DImode) != 0
              || !(
#line 17328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7608; /* *avx2_lshrv4di3_2 */

        case E_V2DImode:
          if (pattern922 (x2, 
E_V2DImode) != 0
              || !
#line 17328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return -1;
          return 7609; /* *avx2_lshrv2di3_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_316 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      switch (pattern183 (x3))
        {
        case 0:
          if (!(
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V32HFmode, operands)
   && 1 && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return -1;
          return 2683; /* *addv32hf3 */

        case 1:
          if (!(
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V16HFmode, operands)
   && 1 && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 2691; /* *addv16hf3 */

        case 2:
          if (!(
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8HFmode, operands)
   && 1 && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 2699; /* *addv8hf3 */

        case 3:
          if (!(
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V16SFmode, operands)
   && 1 && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 2707; /* *addv16sf3 */

        case 4:
          if (!(
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8SFmode, operands)
   && 1 && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 2715; /* *addv8sf3 */

        case 5:
          if (!
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V4SFmode, operands)
   && 1 && 1))
            return -1;
          return 2723; /* *addv4sf3 */

        case 6:
          if (!(
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8DFmode, operands)
   && 1 && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 2731; /* *addv8df3 */

        case 7:
          if (!(
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V4DFmode, operands)
   && 1 && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 2739; /* *addv4df3 */

        case 8:
          if (!(
#line 2664 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V2DFmode, operands)
   && 1 && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2747; /* *addv2df3 */

        case 9:
          if (!(
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V64QImode, operands)) && 
#line 587 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7389; /* *addv64qi3 */

        case 10:
          if (!(
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V32QImode, operands)) && 
#line 587 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7391; /* *addv32qi3 */

        case 11:
          if (!
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V16QImode, operands)))
            return -1;
          return 7393; /* *addv16qi3 */

        case 12:
          if (!(
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V32HImode, operands)) && 
#line 588 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7395; /* *addv32hi3 */

        case 13:
          if (!(
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V16HImode, operands)) && 
#line 588 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7397; /* *addv16hi3 */

        case 14:
          if (!
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V8HImode, operands)))
            return -1;
          return 7399; /* *addv8hi3 */

        case 15:
          if (!(
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V16SImode, operands)) && 
#line 589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 7401; /* *addv16si3 */

        case 16:
          if (!(
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V8SImode, operands)) && 
#line 589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7403; /* *addv8si3 */

        case 17:
          if (!
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V4SImode, operands)))
            return -1;
          return 7405; /* *addv4si3 */

        case 18:
          if (!(
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V8DImode, operands)) && 
#line 590 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 7407; /* *addv8di3 */

        case 19:
          if (!(
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V4DImode, operands)) && 
#line 590 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7409; /* *addv4di3 */

        case 20:
          if (!
#line 16253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_binary_operator_ok (PLUS, V2DImode, operands)))
            return -1;
          return 7411; /* *addv2di3 */

        case 21:
          if (!
#line 32131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10530; /* avx10_2_addbf16_v32bf */

        case 22:
          if (!
#line 32131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10538; /* avx10_2_addbf16_v16bf */

        case 23:
          if (!
#line 32131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10546; /* avx10_2_addbf16_v8bf */

        default:
          return -1;
        }

    case UNSPEC:
      switch (pattern186 (x3))
        {
        case 0:
          if (!(
#line 7178 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4268; /* fma_v32hf_fadd_fmul */

        case 1:
          if (!(
#line 7178 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4269; /* fma_v16hf_fadd_fmul */

        case 2:
          if (!(
#line 7178 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4270; /* fma_v8hf_fadd_fmul */

        case 3:
          if (!(
#line 7195 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4271; /* fma_v32hf_fadd_fcmul */

        case 4:
          if (!(
#line 7195 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4272; /* fma_v16hf_fadd_fcmul */

        case 5:
          if (!(
#line 7195 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4273; /* fma_v8hf_fadd_fcmul */

        case 6:
          if (!(
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4274; /* fma_fmaddc_v32hf_fma_zero */

        case 7:
          if (!(
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4276; /* fma_fmaddc_v16hf_fma_zero */

        case 8:
          if (!(
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4278; /* fma_fmaddc_v8hf_fma_zero */

        case 9:
          if (!(
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4275; /* fma_fcmaddc_v32hf_fma_zero */

        case 10:
          if (!(
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4277; /* fma_fcmaddc_v16hf_fma_zero */

        case 11:
          if (!(
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4279; /* fma_fcmaddc_v8hf_fma_zero */

        default:
          return -1;
        }

    case MULT:
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTEND:
          if (pattern329 (x4) != 0)
            return -1;
          x6 = XEXP (x5, 0);
          x7 = XEXP (x6, 1);
          switch (XVECLEN (x7, 0))
            {
            case 8:
              if (pattern1301 (x4) != 0)
                return -1;
              x8 = XEXP (x3, 1);
              if (GET_CODE (x8) != MULT
                  || GET_MODE (x8) != E_V8SImode)
                return -1;
              x9 = XEXP (x8, 0);
              if (GET_CODE (x9) != SIGN_EXTEND
                  || GET_MODE (x9) != E_V8SImode)
                return -1;
              x10 = XEXP (x9, 0);
              if (GET_CODE (x10) != VEC_SELECT
                  || GET_MODE (x10) != E_V8HImode)
                return -1;
              x11 = XEXP (x10, 1);
              if (GET_CODE (x11) != PARALLEL
                  || pattern1847 (x11, 
8) != 0)
                return -1;
              x12 = XEXP (x8, 1);
              if (pattern1827 (x12, 
E_V8HImode, 
E_V8SImode) != 0)
                return -1;
              x13 = XEXP (x12, 0);
              x14 = XEXP (x13, 1);
              if (pattern1864 (x14, 
8) != 0
                  || !register_operand (operands[0], E_V8SImode)
                  || GET_MODE (x3) != E_V8SImode
                  || GET_MODE (x4) != E_V8SImode
                  || GET_MODE (x5) != E_V8SImode
                  || GET_MODE (x6) != E_V8HImode
                  || !nonimmediate_operand (operands[1], E_V16HImode))
                return -1;
              x15 = XEXP (x4, 1);
              if (GET_MODE (x15) != E_V8SImode)
                return -1;
              x16 = XEXP (x15, 0);
              if (GET_MODE (x16) != E_V8HImode
                  || !nonimmediate_operand (operands[2], E_V16HImode))
                return -1;
              x17 = XEXP (x10, 0);
              if (!rtx_equal_p (x17, operands[1]))
                return -1;
              x18 = XEXP (x13, 0);
              if (!rtx_equal_p (x18, operands[2])
                  || !
#line 16728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 7521; /* *avx2_pmaddwd */

            case 4:
              x19 = XVECEXP (x7, 0, 0);
              if (GET_CODE (x19) != CONST_INT)
                return -1;
              x20 = XVECEXP (x7, 0, 1);
              if (GET_CODE (x20) != CONST_INT)
                return -1;
              x21 = XVECEXP (x7, 0, 2);
              if (GET_CODE (x21) != CONST_INT)
                return -1;
              x22 = XVECEXP (x7, 0, 3);
              if (GET_CODE (x22) != CONST_INT)
                return -1;
              x15 = XEXP (x4, 1);
              x16 = XEXP (x15, 0);
              x23 = XEXP (x16, 1);
              if (XVECLEN (x23, 0) != 4)
                return -1;
              x24 = XVECEXP (x23, 0, 0);
              if (GET_CODE (x24) != CONST_INT)
                return -1;
              x25 = XVECEXP (x23, 0, 1);
              if (GET_CODE (x25) != CONST_INT)
                return -1;
              x26 = XVECEXP (x23, 0, 2);
              if (GET_CODE (x26) != CONST_INT)
                return -1;
              x27 = XVECEXP (x23, 0, 3);
              if (GET_CODE (x27) != CONST_INT
                  || pattern876 (x3, 
E_V4HImode, 
E_V4SImode) != 0
                  || GET_MODE (x15) != E_V4SImode
                  || GET_MODE (x16) != E_V4HImode)
                return -1;
              switch (XWINT (x19, 0))
                {
                case 0L:
                  if (XWINT (x20, 0) != 2L
                      || XWINT (x21, 0) != 4L
                      || XWINT (x22, 0) != 6L
                      || XWINT (x24, 0) != 0L
                      || XWINT (x25, 0) != 2L
                      || XWINT (x26, 0) != 4L
                      || XWINT (x27, 0) != 6L)
                    return -1;
                  x8 = XEXP (x3, 1);
                  if (pattern1767 (x8, 
E_V4HImode, 
E_V4SImode, 
SIGN_EXTEND) != 0
                      || !vector_operand (operands[1], E_V8HImode)
                      || !vector_operand (operands[2], E_V8HImode))
                    return -1;
                  x9 = XEXP (x8, 0);
                  x10 = XEXP (x9, 0);
                  x17 = XEXP (x10, 0);
                  if (!rtx_equal_p (x17, operands[1]))
                    return -1;
                  x12 = XEXP (x8, 1);
                  x13 = XEXP (x12, 0);
                  x18 = XEXP (x13, 0);
                  if (!rtx_equal_p (x18, operands[2])
                      || !
#line 16783 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 7522; /* *sse2_pmaddwd */

                case 1L:
                  if (XWINT (x20, 0) != 3L
                      || XWINT (x21, 0) != 5L
                      || XWINT (x22, 0) != 7L
                      || XWINT (x24, 0) != 1L
                      || XWINT (x25, 0) != 3L
                      || XWINT (x26, 0) != 5L
                      || XWINT (x27, 0) != 7L
                      || !nonimmediate_operand (operands[1], E_V8HImode)
                      || !nonimmediate_operand (operands[2], E_V8HImode))
                    return -1;
                  x8 = XEXP (x3, 1);
                  operands[3] = x8;
                  if (!register_operand (operands[3], E_V4SImode)
                      || !
#line 26169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8920; /* xop_pmacswd */

                default:
                  return -1;
                }

            case 2:
              if (pattern1302 (x3) != 0)
                return -1;
              x15 = XEXP (x4, 1);
              if (GET_MODE (x15) != E_V2DImode)
                return -1;
              x16 = XEXP (x15, 0);
              if (GET_MODE (x16) != E_V2SImode
                  || !nonimmediate_operand (operands[2], E_V4SImode))
                return -1;
              x8 = XEXP (x3, 1);
              operands[3] = x8;
              switch (pattern1811 (x4))
                {
                case 0:
                  if (!
#line 26128 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8916; /* xop_pmacsdql */

                case 1:
                  if (!
#line 26147 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8918; /* xop_pmacsdqh */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          switch (pattern331 (x3))
            {
            case 0:
              if (!
#line 26109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8912; /* xop_pmacsww */

            case 1:
              if (!
#line 26109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8914; /* xop_pmacsdd */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      switch (pattern190 (x3))
        {
        case 0:
          if (!
#line 22570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 8514; /* avx2_phaddwv16hi3 */

        case 1:
          if (!
#line 22593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
            return -1;
          return 8518; /* ssse3_phaddwv8hi3 */

        case 2:
          if (!
#line 22660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 8526; /* avx2_phadddv8si3 */

        case 3:
          if (!
#line 22681 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
            return -1;
          return 8528; /* ssse3_phadddv4si3 */

        default:
          return -1;
        }

    case PLUS:
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case MULT:
          if (pattern332 (x5) != 0)
            return -1;
          x28 = XEXP (x5, 1);
          if (GET_MODE (x28) != E_V4SImode)
            return -1;
          x29 = XEXP (x28, 0);
          if (GET_CODE (x29) != VEC_SELECT
              || GET_MODE (x29) != E_V4HImode)
            return -1;
          x30 = XEXP (x29, 1);
          if (GET_CODE (x30) != PARALLEL
              || XVECLEN (x30, 0) != 4)
            return -1;
          x31 = XVECEXP (x30, 0, 0);
          if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x32 = XVECEXP (x30, 0, 1);
          if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
            return -1;
          x33 = XVECEXP (x30, 0, 2);
          if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
            return -1;
          x34 = XVECEXP (x30, 0, 3);
          if (x34 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
            return -1;
          x15 = XEXP (x4, 1);
          if (GET_CODE (x15) != MULT
              || GET_MODE (x15) != E_V4SImode)
            return -1;
          x16 = XEXP (x15, 0);
          if (GET_CODE (x16) != SIGN_EXTEND
              || GET_MODE (x16) != E_V4SImode)
            return -1;
          x35 = XEXP (x16, 0);
          if (GET_CODE (x35) != VEC_SELECT
              || GET_MODE (x35) != E_V4HImode)
            return -1;
          x36 = XEXP (x35, 1);
          if (GET_CODE (x36) != PARALLEL
              || XVECLEN (x36, 0) != 4)
            return -1;
          x37 = XVECEXP (x36, 0, 0);
          if (x37 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x38 = XVECEXP (x36, 0, 1);
          if (x38 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
            return -1;
          x39 = XVECEXP (x36, 0, 2);
          if (x39 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
            return -1;
          x40 = XVECEXP (x36, 0, 3);
          if (x40 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
            return -1;
          x41 = XEXP (x15, 1);
          if (GET_CODE (x41) != SIGN_EXTEND
              || GET_MODE (x41) != E_V4SImode)
            return -1;
          x42 = XEXP (x41, 0);
          if (GET_CODE (x42) != VEC_SELECT
              || GET_MODE (x42) != E_V4HImode)
            return -1;
          x43 = XEXP (x42, 1);
          if (GET_CODE (x43) != PARALLEL
              || XVECLEN (x43, 0) != 4)
            return -1;
          x44 = XVECEXP (x43, 0, 0);
          if (x44 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x45 = XVECEXP (x43, 0, 1);
          if (x45 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
            return -1;
          x46 = XVECEXP (x43, 0, 2);
          if (x46 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
            return -1;
          x47 = XVECEXP (x43, 0, 3);
          if (x47 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
              || !register_operand (operands[0], E_V4SImode)
              || GET_MODE (x3) != E_V4SImode
              || GET_MODE (x4) != E_V4SImode
              || pattern1867 (x3) != 0
              || !
#line 26202 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8922; /* xop_pmadcswd */

        case SIGN_EXTEND:
          switch (pattern335 (x3, 
SIGN_EXTEND))
            {
            case 0:
              if (!
#line 26296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8942; /* xop_phaddbd */

            case 1:
              if (!
#line 26392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8948; /* xop_phaddwq */

            default:
              return -1;
            }

        case ZERO_EXTEND:
          switch (pattern335 (x3, 
ZERO_EXTEND))
            {
            case 0:
              if (!
#line 26296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8943; /* xop_phaddubd */

            case 1:
              if (!
#line 26392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8949; /* xop_phadduwq */

            default:
              return -1;
            }

        case PLUS:
          if (GET_MODE (x5) != E_V2DImode)
            return -1;
          x15 = XEXP (x4, 1);
          if (GET_CODE (x15) != PLUS
              || GET_MODE (x15) != E_V2DImode)
            return -1;
          x8 = XEXP (x3, 1);
          if (GET_CODE (x8) != PLUS
              || GET_MODE (x8) != E_V2DImode
              || pattern1022 (x8, 
E_V2DImode, 
PLUS) != 0
              || !register_operand (operands[0], E_V2DImode)
              || GET_MODE (x3) != E_V2DImode
              || GET_MODE (x4) != E_V2DImode
              || pattern1535 (x3, 
E_V2DImode) != 0)
            return -1;
          x6 = XEXP (x5, 0);
          switch (GET_CODE (x6))
            {
            case SIGN_EXTEND:
              if (pattern1800 (x3, 
SIGN_EXTEND) != 0
                  || !
#line 26344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8944; /* xop_phaddbq */

            case ZERO_EXTEND:
              if (pattern1800 (x3, 
ZERO_EXTEND) != 0
                  || !
#line 26344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8945; /* xop_phaddubq */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SIGN_EXTEND:
      switch (pattern192 (x3, 
SIGN_EXTEND))
        {
        case 0:
          if (!
#line 26264 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8940; /* xop_phaddbw */

        case 1:
          if (!
#line 26364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8946; /* xop_phaddwd */

        case 2:
          if (!
#line 26410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8950; /* xop_phadddq */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      switch (pattern192 (x3, 
ZERO_EXTEND))
        {
        case 0:
          if (!
#line 26264 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8941; /* xop_phaddubw */

        case 1:
          if (!
#line 26364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8947; /* xop_phadduwd */

        case 2:
          if (!
#line 26410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8951; /* xop_phaddudq */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_320 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55, x56, x57;
  rtx x58, x59, x60, x61, x62, x63, x64, x65;
  rtx x66, x67, x68, x69, x70, x71, x72, x73;
  rtx x74, x75, x76;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      switch (pattern51 (x3))
        {
        case 0:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_PLUS, V64QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7437; /* *avx512bw_ssaddv64qi3 */

        case 1:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_PLUS, V32QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7445; /* *avx2_ssaddv32qi3 */

        case 2:
          if (!
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_PLUS, V16QImode, operands)))
            return -1;
          return 7453; /* *sse2_ssaddv16qi3 */

        case 3:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_PLUS, V32HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7461; /* *avx512bw_ssaddv32hi3 */

        case 4:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_PLUS, V16HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7469; /* *avx2_ssaddv16hi3 */

        case 5:
          if (!
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_PLUS, V8HImode, operands)))
            return -1;
          return 7477; /* *sse2_ssaddv8hi3 */

        default:
          return -1;
        }

    case VEC_SELECT:
      switch (pattern196 (x3))
        {
        case 0:
          if (!
#line 22570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 8515; /* avx2_phaddswv16hi3 */

        case 1:
          if (!
#line 22593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
            return -1;
          return 8519; /* ssse3_phaddswv8hi3 */

        default:
          return -1;
        }

    case MULT:
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case ZERO_EXTEND:
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != VEC_SELECT)
            return -1;
          x7 = XEXP (x6, 1);
          if (GET_CODE (x7) != PARALLEL)
            return -1;
          x8 = XEXP (x4, 1);
          if (GET_CODE (x8) != SIGN_EXTEND)
            return -1;
          x9 = XEXP (x8, 0);
          if (GET_CODE (x9) != VEC_SELECT)
            return -1;
          x10 = XEXP (x9, 1);
          if (GET_CODE (x10) != PARALLEL)
            return -1;
          x11 = XEXP (x3, 1);
          if (GET_CODE (x11) != MULT)
            return -1;
          x12 = XEXP (x11, 0);
          if (GET_CODE (x12) != ZERO_EXTEND)
            return -1;
          x13 = XEXP (x12, 0);
          if (GET_CODE (x13) != VEC_SELECT)
            return -1;
          x14 = XEXP (x13, 1);
          if (GET_CODE (x14) != PARALLEL)
            return -1;
          x15 = XEXP (x11, 1);
          if (GET_CODE (x15) != SIGN_EXTEND)
            return -1;
          x16 = XEXP (x15, 0);
          if (GET_CODE (x16) != VEC_SELECT)
            return -1;
          x17 = XEXP (x16, 1);
          if (GET_CODE (x17) != PARALLEL)
            return -1;
          x18 = XEXP (x6, 0);
          operands[1] = x18;
          x19 = XEXP (x9, 0);
          operands[2] = x19;
          x20 = XEXP (x13, 0);
          if (!rtx_equal_p (x20, operands[1]))
            return -1;
          x21 = XEXP (x16, 0);
          if (!rtx_equal_p (x21, operands[2]))
            return -1;
          switch (XVECLEN (x7, 0))
            {
            case 16:
              if (pattern1068 (x7, 
6, 
4, 
2, 
0) != 0)
                return -1;
              x22 = XVECEXP (x7, 0, 4);
              if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
                return -1;
              x23 = XVECEXP (x7, 0, 5);
              if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
                return -1;
              x24 = XVECEXP (x7, 0, 6);
              if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
                return -1;
              x25 = XVECEXP (x7, 0, 7);
              if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
                return -1;
              x26 = XVECEXP (x7, 0, 8);
              if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 16])
                return -1;
              x27 = XVECEXP (x7, 0, 9);
              if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 18])
                return -1;
              x28 = XVECEXP (x7, 0, 10);
              if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 20])
                return -1;
              x29 = XVECEXP (x7, 0, 11);
              if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 22])
                return -1;
              x30 = XVECEXP (x7, 0, 12);
              if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 24])
                return -1;
              x31 = XVECEXP (x7, 0, 13);
              if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 26])
                return -1;
              x32 = XVECEXP (x7, 0, 14);
              if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 28])
                return -1;
              x33 = XVECEXP (x7, 0, 15);
              if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 30]
                  || pattern1300 (x10, 
16) != 0)
                return -1;
              x34 = XVECEXP (x10, 0, 8);
              if (x34 != const_int_rtx[MAX_SAVED_CONST_INT + 16])
                return -1;
              x35 = XVECEXP (x10, 0, 9);
              if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 18])
                return -1;
              x36 = XVECEXP (x10, 0, 10);
              if (x36 != const_int_rtx[MAX_SAVED_CONST_INT + 20])
                return -1;
              x37 = XVECEXP (x10, 0, 11);
              if (x37 != const_int_rtx[MAX_SAVED_CONST_INT + 22])
                return -1;
              x38 = XVECEXP (x10, 0, 12);
              if (x38 != const_int_rtx[MAX_SAVED_CONST_INT + 24])
                return -1;
              x39 = XVECEXP (x10, 0, 13);
              if (x39 != const_int_rtx[MAX_SAVED_CONST_INT + 26])
                return -1;
              x40 = XVECEXP (x10, 0, 14);
              if (x40 != const_int_rtx[MAX_SAVED_CONST_INT + 28])
                return -1;
              x41 = XVECEXP (x10, 0, 15);
              if (x41 != const_int_rtx[MAX_SAVED_CONST_INT + 30]
                  || pattern1847 (x14, 
16) != 0)
                return -1;
              x42 = XVECEXP (x14, 0, 8);
              if (x42 != const_int_rtx[MAX_SAVED_CONST_INT + 17])
                return -1;
              x43 = XVECEXP (x14, 0, 9);
              if (x43 != const_int_rtx[MAX_SAVED_CONST_INT + 19])
                return -1;
              x44 = XVECEXP (x14, 0, 10);
              if (x44 != const_int_rtx[MAX_SAVED_CONST_INT + 21])
                return -1;
              x45 = XVECEXP (x14, 0, 11);
              if (x45 != const_int_rtx[MAX_SAVED_CONST_INT + 23])
                return -1;
              x46 = XVECEXP (x14, 0, 12);
              if (x46 != const_int_rtx[MAX_SAVED_CONST_INT + 25])
                return -1;
              x47 = XVECEXP (x14, 0, 13);
              if (x47 != const_int_rtx[MAX_SAVED_CONST_INT + 27])
                return -1;
              x48 = XVECEXP (x14, 0, 14);
              if (x48 != const_int_rtx[MAX_SAVED_CONST_INT + 29])
                return -1;
              x49 = XVECEXP (x14, 0, 15);
              if (x49 != const_int_rtx[MAX_SAVED_CONST_INT + 31]
                  || pattern1864 (x17, 
16) != 0)
                return -1;
              x50 = XVECEXP (x17, 0, 8);
              if (x50 != const_int_rtx[MAX_SAVED_CONST_INT + 17])
                return -1;
              x51 = XVECEXP (x17, 0, 9);
              if (x51 != const_int_rtx[MAX_SAVED_CONST_INT + 19])
                return -1;
              x52 = XVECEXP (x17, 0, 10);
              if (x52 != const_int_rtx[MAX_SAVED_CONST_INT + 21])
                return -1;
              x53 = XVECEXP (x17, 0, 11);
              if (x53 != const_int_rtx[MAX_SAVED_CONST_INT + 23])
                return -1;
              x54 = XVECEXP (x17, 0, 12);
              if (x54 != const_int_rtx[MAX_SAVED_CONST_INT + 25])
                return -1;
              x55 = XVECEXP (x17, 0, 13);
              if (x55 != const_int_rtx[MAX_SAVED_CONST_INT + 27])
                return -1;
              x56 = XVECEXP (x17, 0, 14);
              if (x56 != const_int_rtx[MAX_SAVED_CONST_INT + 29])
                return -1;
              x57 = XVECEXP (x17, 0, 15);
              if (x57 != const_int_rtx[MAX_SAVED_CONST_INT + 31]
                  || pattern1870 (x3, 
E_V32QImode, 
E_V16QImode, 
E_V16HImode) != 0
                  || GET_MODE (x8) != E_V16HImode
                  || GET_MODE (x9) != E_V16QImode
                  || !nonimmediate_operand (operands[2], E_V32QImode)
                  || pattern333 (x11, 
E_V16QImode, 
E_V16HImode) != 0
                  || !
#line 22780 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 8532; /* avx2_pmaddubsw256 */

            case 8:
              if (pattern1301 (x4) != 0
                  || pattern1847 (x14, 
8) != 0
                  || pattern1864 (x17, 
8) != 0
                  || pattern1870 (x3, 
E_V16QImode, 
E_V8QImode, 
E_V8HImode) != 0
                  || GET_MODE (x8) != E_V8HImode
                  || GET_MODE (x9) != E_V8QImode
                  || !vector_operand (operands[2], E_V16QImode)
                  || pattern333 (x11, 
E_V8QImode, 
E_V8HImode) != 0
                  || !
#line 22867 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
                return -1;
              return 8541; /* ssse3_pmaddubsw128 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          switch (pattern331 (x3))
            {
            case 0:
              if (!
#line 26109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8913; /* xop_pmacssww */

            case 1:
              if (!
#line 26109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8915; /* xop_pmacssdd */

            default:
              return -1;
            }

        case SIGN_EXTEND:
          if (pattern329 (x4) != 0)
            return -1;
          x11 = XEXP (x3, 1);
          operands[3] = x11;
          x6 = XEXP (x5, 0);
          x7 = XEXP (x6, 1);
          switch (XVECLEN (x7, 0))
            {
            case 2:
              if (pattern1302 (x3) != 0)
                return -1;
              x8 = XEXP (x4, 1);
              if (GET_MODE (x8) != E_V2DImode)
                return -1;
              x9 = XEXP (x8, 0);
              if (GET_MODE (x9) != E_V2SImode
                  || !nonimmediate_operand (operands[2], E_V4SImode))
                return -1;
              switch (pattern1811 (x4))
                {
                case 0:
                  if (!
#line 26128 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8917; /* xop_pmacssdql */

                case 1:
                  if (!
#line 26147 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8919; /* xop_pmacssdqh */

                default:
                  return -1;
                }

            case 4:
              if (pattern1068 (x7, 
7, 
5, 
3, 
1) != 0)
                return -1;
              x8 = XEXP (x4, 1);
              x9 = XEXP (x8, 0);
              x10 = XEXP (x9, 1);
              if (pattern1602 (x10, 
7, 
5, 
3, 
1) != 0
                  || !register_operand (operands[0], E_V4SImode)
                  || GET_MODE (x3) != E_V4SImode
                  || GET_MODE (x4) != E_V4SImode
                  || GET_MODE (x5) != E_V4SImode
                  || GET_MODE (x6) != E_V4HImode
                  || !nonimmediate_operand (operands[1], E_V8HImode)
                  || GET_MODE (x8) != E_V4SImode
                  || GET_MODE (x9) != E_V4HImode
                  || !nonimmediate_operand (operands[2], E_V8HImode)
                  || !register_operand (operands[3], E_V4SImode)
                  || !
#line 26169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8921; /* xop_pmacsswd */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      if (GET_MODE (x4) != E_V4SImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != MULT
          || pattern332 (x5) != 0)
        return -1;
      x58 = XEXP (x5, 1);
      if (GET_MODE (x58) != E_V4SImode)
        return -1;
      x59 = XEXP (x58, 0);
      if (GET_CODE (x59) != VEC_SELECT
          || GET_MODE (x59) != E_V4HImode)
        return -1;
      x60 = XEXP (x59, 1);
      if (GET_CODE (x60) != PARALLEL
          || XVECLEN (x60, 0) != 4)
        return -1;
      x61 = XVECEXP (x60, 0, 0);
      if (x61 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x62 = XVECEXP (x60, 0, 1);
      if (x62 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x63 = XVECEXP (x60, 0, 2);
      if (x63 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x64 = XVECEXP (x60, 0, 3);
      if (x64 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x8 = XEXP (x4, 1);
      if (GET_CODE (x8) != MULT
          || GET_MODE (x8) != E_V4SImode)
        return -1;
      x9 = XEXP (x8, 0);
      if (GET_CODE (x9) != SIGN_EXTEND
          || GET_MODE (x9) != E_V4SImode)
        return -1;
      x19 = XEXP (x9, 0);
      if (GET_CODE (x19) != VEC_SELECT
          || GET_MODE (x19) != E_V4HImode)
        return -1;
      x65 = XEXP (x19, 1);
      if (GET_CODE (x65) != PARALLEL
          || XVECLEN (x65, 0) != 4)
        return -1;
      x66 = XVECEXP (x65, 0, 0);
      if (x66 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x67 = XVECEXP (x65, 0, 1);
      if (x67 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x68 = XVECEXP (x65, 0, 2);
      if (x68 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x69 = XVECEXP (x65, 0, 3);
      if (x69 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x70 = XEXP (x8, 1);
      if (GET_CODE (x70) != SIGN_EXTEND
          || GET_MODE (x70) != E_V4SImode)
        return -1;
      x71 = XEXP (x70, 0);
      if (GET_CODE (x71) != VEC_SELECT
          || GET_MODE (x71) != E_V4HImode)
        return -1;
      x72 = XEXP (x71, 1);
      if (GET_CODE (x72) != PARALLEL
          || XVECLEN (x72, 0) != 4)
        return -1;
      x73 = XVECEXP (x72, 0, 0);
      if (x73 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x74 = XVECEXP (x72, 0, 1);
      if (x74 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x75 = XVECEXP (x72, 0, 2);
      if (x75 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x76 = XVECEXP (x72, 0, 3);
      if (x76 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || !register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || pattern1867 (x3) != 0
          || !
#line 26202 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8923; /* xop_pmadcsswd */

    default:
      return -1;
    }
}

 int
recog_325 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern29 (x1))
    {
    case 0:
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
        return 7572; /* *lshrv16hi3 */
      if (!register_operand (operands[1], E_V16HImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && (
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 774 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return 7595; /* lshrv16hi3 */
      if (!nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9527; /* avx512vl_lshrvv16hi */

    case 1:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
        return 7576; /* *lshrv8hi3 */
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return 7597; /* lshrv8hi3 */
      if (!nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9523; /* avx512vl_lshrvv8hi */

    case 2:
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7580; /* *lshrv8si3 */
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && (
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return 7599; /* lshrv8si3 */
      if (!nonimmediate_operand (operands[2], E_V8SImode)
          || !
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9503; /* avx2_lshrvv8si */

    case 3:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7584; /* *lshrv4si3 */
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return 7601; /* lshrv4si3 */
      if (!nonimmediate_operand (operands[2], E_V4SImode)
          || !
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9507; /* avx2_lshrvv4si */

    case 4:
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7588; /* *lshrv4di3 */
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && (
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 776 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return 7603; /* lshrv4di3 */
      if (!nonimmediate_operand (operands[2], E_V4DImode)
          || !
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9515; /* avx2_lshrvv4di */

    case 5:
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7592; /* *lshrv2di3 */
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return 7605; /* lshrv2di3 */
      if (!nonimmediate_operand (operands[2], E_V2DImode)
          || !
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9519; /* avx2_lshrvv2di */

    case 6:
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return 7612; /* lshrv32hi3 */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9531; /* avx512bw_lshrvv32hi */

    case 7:
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 7616; /* lshrv16si3 */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1) && 
#line 803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 9499; /* avx512f_lshrvv16si */

    case 8:
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 7620; /* lshrv8di3 */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1) && 
#line 804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 9511; /* avx512f_lshrvv8di */

    case 9:
      if (register_operand (operands[1], E_V1TImode)
          && const_0_to_255_not_mul_8_operand (operands[2], E_SImode)
          && 
#line 17468 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()))
        return 7623; /* *lshrv1ti3_internal */
      if (!const_0_to_255_mul_8_operand (operands[2], E_SImode))
        return -1;
      if (nonimmediate_operand (operands[1], E_V1TImode)
          && (
#line 17583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7632; /* avx512bw_lshrv1ti3 */
      if (!register_operand (operands[1], E_V1TImode)
          || !
#line 17598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return -1;
      return 7636; /* sse2_lshrv1ti3 */

    case 10:
      if (!(
#line 17583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7628; /* avx512bw_lshrv4ti3 */

    case 11:
      if (nonimmediate_operand (operands[1], E_V2TImode)
          && (
#line 17583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7630; /* avx512bw_lshrv2ti3 */
      if (!register_operand (operands[1], E_V2TImode)
          || !(
#line 17598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 7634; /* avx2_lshrv2ti3 */

    default:
      return -1;
    }
}

 int
recog_330 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  switch (pattern34 (x1))
    {
    case 0:
      if (!
#line 24121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1 && 1))
        return -1;
      return 8682; /* avx2_zero_extendv16qiv16hi2 */

    case 1:
      if (!
#line 24175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
        return -1;
      return 8690; /* avx512bw_zero_extendv32qiv32hi2 */

    case 2:
      if (!
#line 24245 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1))
        return -1;
      return 8702; /* *sse4_1_zero_extendv8qiv8hi2_1 */

    case 3:
      if (!
#line 24370 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8714; /* *avx512f_zero_extendv16qiv16si2 */

    case 4:
      if (!
#line 24513 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8742; /* avx512f_zero_extendv16hiv16si2 */

    case 5:
      if (!
#line 24402 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8722; /* *avx2_zero_extendv8qiv8si2_1 */

    case 6:
      if (!
#line 24566 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8750; /* avx2_zero_extendv8hiv8si2 */

    case 7:
      if (!
#line 24463 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8734; /* *sse4_1_zero_extendv4qiv4si2_1 */

    case 8:
      if (!
#line 24636 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8762; /* *sse4_1_zero_extendv4hiv4si2_1 */

    case 9:
      if (!
#line 24767 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8778; /* *avx512f_zero_extendv8qiv8di2_1 */

    case 10:
      if (!
#line 24938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8809; /* avx512f_zero_extendv8hiv8di2 */

    case 11:
      if (!
#line 25075 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8837; /* avx512f_zero_extendv8siv8di2 */

    case 12:
      if (!
#line 24825 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8790; /* *avx2_zero_extendv4qiv4di2_1 */

    case 13:
      if (!
#line 24968 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8817; /* *avx2_zero_extendv4hiv4di2_1 */

    case 14:
      if (!
#line 25126 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8843; /* avx2_zero_extendv4siv4di2 */

    case 15:
      if (!
#line 24887 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8802; /* *sse4_1_zero_extendv2qiv2di2_1 */

    case 16:
      if (!
#line 25026 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8829; /* *sse4_1_zero_extendv2hiv2di2_1 */

    case 17:
      if (!
#line 25192 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8853; /* *sse4_1_zero_extendv2siv2di2_1 */

    case 18:
      x2 = XEXP (x1, 1);
      x3 = XEXP (x2, 0);
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      switch (pattern537 (x2))
        {
        case 0:
          if (
#line 24233 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1))
            return 8698; /* sse4_1_zero_extendv8qiv8hi2 */
          break;

        case 1:
          if (
#line 24391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
            return 8718; /* avx2_zero_extendv8qiv8si2 */
          break;

        case 2:
          if (
#line 24757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return 8774; /* avx512f_zero_extendv8qiv8di2 */
          break;

        case 3:
          if (
#line 24451 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8730; /* sse4_1_zero_extendv4qiv4si2 */
          break;

        case 4:
          if (
#line 24624 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8758; /* sse4_1_zero_extendv4hiv4si2 */
          break;

        case 5:
          if (
#line 24814 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
            return 8786; /* avx2_zero_extendv4qiv4di2 */
          break;

        case 6:
          if (
#line 24957 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
            return 8813; /* avx2_zero_extendv4hiv4di2 */
          break;

        case 7:
          if (
#line 24875 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8798; /* sse4_1_zero_extendv2qiv2di2 */
          break;

        case 8:
          if (
#line 25014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8825; /* sse4_1_zero_extendv2hiv2di2 */
          break;

        case 9:
          if (
#line 25180 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8849; /* sse4_1_zero_extendv2siv2di2 */
          break;

        default:
          break;
        }
      if (GET_CODE (x4) != SUBREG
          || maybe_ne (SUBREG_BYTE (x4), 0))
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case VEC_CONCAT:
          switch (pattern673 (x2))
            {
            case 0:
              if (!
#line 24269 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1
   && ix86_pre_reload_split ()))
                return -1;
              return 8706; /* *sse4_1_zero_extendv8qiv8hi2_2 */

            case 1:
              if (!
#line 24421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()))
                return -1;
              return 8726; /* *avx2_zero_extendv8qiv8si2_2 */

            case 2:
              if (!
#line 24785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512 && ix86_pre_reload_split ()))
                return -1;
              return 8782; /* *avx512f_zero_extendv8qiv8di2_2 */

            case 3:
              if (!
#line 24655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()))
                return -1;
              return 8766; /* *sse4_1_zero_extendv4hiv4si2_2 */

            case 4:
              if (!
#line 24985 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()))
                return -1;
              return 8821; /* *avx2_zero_extendv4hiv4di2_2 */

            case 5:
              if (!
#line 25210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()))
                return -1;
              return 8857; /* *sse4_1_zero_extendv2siv2di2_2 */

            default:
              return -1;
            }

        case VEC_MERGE:
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != VEC_DUPLICATE)
            return -1;
          if (GET_MODE (x6) == E_V4SImode)
            {
              switch (pattern1024 (x2))
                {
                case 0:
                  if (
#line 24486 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()))
                    return 8738; /* *sse4_1_zero_extendv4qiv4si2_2 */
                  break;

                case 1:
                  if (
#line 24846 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()))
                    return 8794; /* *avx2_zero_extendv4qiv4di2_2 */
                  break;

                case 2:
                  if (
#line 25048 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()))
                    return 8833; /* *sse4_1_zero_extendv2hiv2di2_2 */
                  break;

                default:
                  break;
                }
            }
          x7 = XEXP (x5, 2);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          switch (pattern1025 (x2))
            {
            case 0:
              if (!
#line 24922 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()))
                return -1;
              return 8804; /* *sse4_1_zero_extendv2qiv2di2_2 */

            case 1:
              if (!
#line 24922 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()))
                return -1;
              return 8805; /* *sse4_1_zero_extendv2qiv2di2_2 */

            case 2:
              if (!
#line 24922 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()))
                return -1;
              return 8806; /* *sse4_1_zero_extendv2qiv2di2_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_339 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (GET_CODE (x3))
    {
    case AND:
      res = recog_300 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case IOR:
      res = recog_312 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case XOR:
      res = recog_305 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case NOT:
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) == XOR)
        {
          x5 = XEXP (x4, 0);
          operands[1] = x5;
          x6 = XEXP (x4, 1);
          operands[2] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SImode:
              if (pattern803 (x3, 
E_V16SImode) == 0
                  && (
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16SImode)
       || register_operand (operands[2], V16SImode))) && 
#line 568 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return 8000; /* *xnorv16si3 */
              break;

            case E_V8DImode:
              if (pattern803 (x3, 
E_V8DImode) == 0
                  && (
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8DImode)
       || register_operand (operands[2], V8DImode))) && 
#line 569 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return 8001; /* *xnorv8di3 */
              break;

            case E_V64QImode:
              if (pattern803 (x3, 
E_V64QImode) == 0
                  && (
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V64QImode)
       || register_operand (operands[2], V64QImode))) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return 8002; /* *xnorv64qi3 */
              break;

            case E_V32QImode:
              if (pattern803 (x3, 
E_V32QImode) == 0
                  && (
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V32QImode)
       || register_operand (operands[2], V32QImode))) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 8003; /* *xnorv32qi3 */
              break;

            case E_V16QImode:
              if (pattern803 (x3, 
E_V16QImode) == 0
                  && 
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16QImode)
       || register_operand (operands[2], V16QImode))))
                return 8004; /* *xnorv16qi3 */
              break;

            case E_V32HImode:
              if (pattern803 (x3, 
E_V32HImode) == 0
                  && (
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V32HImode)
       || register_operand (operands[2], V32HImode))) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return 8005; /* *xnorv32hi3 */
              break;

            case E_V16HImode:
              if (pattern803 (x3, 
E_V16HImode) == 0
                  && (
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16HImode)
       || register_operand (operands[2], V16HImode))) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 8006; /* *xnorv16hi3 */
              break;

            case E_V8HImode:
              if (pattern803 (x3, 
E_V8HImode) == 0
                  && 
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8HImode)
       || register_operand (operands[2], V8HImode))))
                return 8007; /* *xnorv8hi3 */
              break;

            case E_V8SImode:
              if (pattern803 (x3, 
E_V8SImode) == 0
                  && (
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8SImode)
       || register_operand (operands[2], V8SImode))) && 
#line 572 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 8008; /* *xnorv8si3 */
              break;

            case E_V4SImode:
              if (pattern803 (x3, 
E_V4SImode) == 0
                  && 
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V4SImode)
       || register_operand (operands[2], V4SImode))))
                return 8009; /* *xnorv4si3 */
              break;

            case E_V4DImode:
              if (pattern803 (x3, 
E_V4DImode) == 0
                  && (
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V4DImode)
       || register_operand (operands[2], V4DImode))) && 
#line 573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 8010; /* *xnorv4di3 */
              break;

            case E_V2DImode:
              if (pattern803 (x3, 
E_V2DImode) == 0
                  && 
#line 18976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V2DImode)
       || register_operand (operands[2], V2DImode))))
                return 8011; /* *xnorv2di3 */
              break;

            default:
              break;
            }
        }
      break;

    default:
      break;
    }
  operands[1] = x3;
  switch (pattern195 ())
    {
    case 0:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return 5416; /* *avx512bw_vpternlogv32hf_0 */
      break;

    case 1:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 5417; /* *avx512vl_vpternlogv16hf_0 */
      break;

    case 2:
      if (
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
        return 5418; /* *avx512fp16_vpternlogv8hf_0 */
      break;

    case 3:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return 5419; /* *avx512bw_vpternlogv32bf_0 */
      break;

    case 4:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 5420; /* *avx512vl_vpternlogv16bf_0 */
      break;

    case 5:
      if (
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
        return 5421; /* *avx512vl_vpternlogv8bf_0 */
      break;

    case 6:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return 5422; /* *avx512f_vpternlogv16sf_0 */
      break;

    case 7:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 5423; /* *avx512vl_vpternlogv8sf_0 */
      break;

    case 8:
      if (
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
        return 5424; /* *avx512vl_vpternlogv4sf_0 */
      break;

    case 9:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return 5425; /* *avx512f_vpternlogv8df_0 */
      break;

    case 10:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 5426; /* *avx512vl_vpternlogv4df_0 */
      break;

    case 11:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return 5427; /* *avx512vl_vpternlogv2df_0 */
      break;

    default:
      break;
    }
  switch (GET_CODE (x3))
    {
    case AND:
      return recog_311 (x1, insn, pnum_clobbers);

    case IOR:
      return recog_310 (x1, insn, pnum_clobbers);

    case XOR:
      return recog_309 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_348 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern32 (x1))
    {
    case 0:
      if (!
#line 17568 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()))
        return -1;
      return 7626; /* *rotrv1ti3_internal */

    case 1:
      if (!(
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7663; /* avx512f_rorv16si */

    case 2:
      if (!(
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7667; /* avx512vl_rorv8si */

    case 3:
      if (const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7671; /* avx512vl_rorv4si */
      if (!const_0_to_31_operand (operands[2], E_SImode)
          || !
#line 26615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8965; /* xop_rotrv4si3 */

    case 4:
      if (!(
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7675; /* avx512f_rorv8di */

    case 5:
      if (!(
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7679; /* avx512vl_rorv4di */

    case 6:
      if (const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7683; /* avx512vl_rorv2di */
      if (!const_0_to_63_operand (operands[2], E_SImode)
          || !
#line 26615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8966; /* xop_rotrv2di3 */

    case 7:
      if (!
#line 26615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8963; /* xop_rotrv16qi3 */

    case 8:
      if (!
#line 26615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8964; /* xop_rotrv8hi3 */

    case 9:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7639; /* avx512f_rorvv16si */

    case 10:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7643; /* avx512vl_rorvv8si */

    case 11:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7647; /* avx512vl_rorvv4si */

    case 12:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7651; /* avx512f_rorvv8di */

    case 13:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7655; /* avx512vl_rorvv4di */

    case 14:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7659; /* avx512vl_rorvv2di */

    default:
      return -1;
    }
}

 int
recog_357 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (pattern231 (x5, 
E_CCmode, 
17) != 0)
    return -1;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  res = recog_356 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x4, 0) != 8L
      || pattern713 (x2) != 0)
    return -1;
  switch (pattern1405 (x2))
    {
    case 0:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 800; /* *andqi_exthi_3 */

    case 1:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 803; /* *andqi_extsi_3 */

    case 2:
      if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 806; /* *andqi_extdi_3 */

    case 3:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 801; /* *iorqi_exthi_3 */

    case 4:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 804; /* *iorqi_extsi_3 */

    case 5:
      if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 807; /* *iorqi_extdi_3 */

    case 6:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 802; /* *xorqi_exthi_3 */

    case 7:
      if (!
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])))
        return -1;
      return 805; /* *xorqi_extsi_3 */

    case 8:
      if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 808; /* *xorqi_extdi_3 */

    default:
      return -1;
    }
}

 int
recog_362 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (XINT (x3, 1))
    {
    case 106:
      if (pattern538 (x1) != 0)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!pop_operand (operands[1], E_TImode))
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!register_operand (operands[2], E_DImode)
          || !
#line 3913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_PUSH2POP2))
        return -1;
      return 160; /* pop2_di */

    case 14:
      if (GET_MODE (x3) != E_SImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (pattern353 (x6) != 0)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      switch (GET_CODE (x5))
        {
        case CONST_INT:
          if (XWINT (x5, 0) != 0L
              || !
#line 20785 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1498; /* *set_got */

        case LABEL_REF:
          x8 = XEXP (x5, 0);
          operands[1] = x8;
          if (!
#line 20807 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1499; /* *set_got_labelled */

        default:
          return -1;
        }

    case 97:
      switch (pattern541 (x1))
        {
        case 0:
          if (!
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          return 1550; /* tzcnt_si */

        case 1:
          if (!(((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return -1;
          return 1552; /* tzcnt_di */

        case 2:
          if (!(
#line 21750 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(true) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return -1;
          return 1563; /* tzcnt_hi */

        case 3:
          if ((
#line 21724 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return 1554; /* *tzcnt_si_falsedep_nf */
          if (pnum_clobbers == NULL
              || !
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          *pnum_clobbers = 1;
          return 1558; /* *tzcnt_si_falsedep */

        case 4:
          if ((
#line 21724 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && ((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return 1556; /* *tzcnt_di_falsedep_nf */
          if (pnum_clobbers == NULL
              || !((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1560; /* *tzcnt_di_falsedep */

        default:
          return -1;
        }

    case 96:
      switch (pattern541 (x1))
        {
        case 0:
          if (!
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          return 1551; /* lzcnt_si */

        case 1:
          if (!(((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return -1;
          return 1553; /* lzcnt_di */

        case 2:
          if (!(
#line 21750 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(true) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return -1;
          return 1565; /* lzcnt_hi */

        case 3:
          if ((
#line 21724 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return 1555; /* *lzcnt_si_falsedep_nf */
          if (pnum_clobbers == NULL
              || !
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          *pnum_clobbers = 1;
          return 1559; /* *lzcnt_si_falsedep */

        case 4:
          if ((
#line 21724 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && ((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return 1557; /* *lzcnt_di_falsedep_nf */
          if (pnum_clobbers == NULL
              || !((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1561; /* *lzcnt_di_falsedep */

        default:
          return -1;
        }

    case 27:
      if (GET_MODE (x3) != E_CCmode
          || pattern676 (x1, 
CLOBBER, 
E_CCmode) != 0)
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[0] = x5;
      if (!register_operand (operands[0], E_HImode))
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      x7 = XEXP (x6, 0);
      if (!rtx_equal_p (x7, operands[0]))
        return -1;
      return 1647; /* parityhi2_cmp */

    case 80:
      if (pattern542 (x1, 
81) != 0
          || !
#line 24090 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      return 1719; /* sincosxf3 */

    case 82:
      if (pattern542 (x1, 
83) != 0
          || !
#line 24605 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      return 1724; /* fxtractxf3_i387 */

    case 70:
      if (GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!register_operand (operands[1], E_XFmode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!scratch_operand (operands[2], E_XFmode)
          || !
#line 25151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
        return -1;
      return 1733; /* lrintxfdi2 */

    case 74:
      if (pattern543 (x1) != 0
          || !
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()))
        return -1;
      return 1736; /* frndintxf2_roundeven */

    case 75:
      if (pattern543 (x1) != 0
          || !
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()))
        return -1;
      return 1737; /* frndintxf2_floor */

    case 76:
      if (pattern543 (x1) != 0
          || !
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()))
        return -1;
      return 1738; /* frndintxf2_ceil */

    case 77:
      if (pattern543 (x1) != 0
          || !
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()))
        return -1;
      return 1739; /* frndintxf2_trunc */

    case 78:
      switch (pattern545 (x1))
        {
        case 0:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1744; /* *fisthi2_floor_1 */

        case 1:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1746; /* *fistsi2_floor_1 */

        case 2:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1748; /* *fistdi2_floor_1 */

        default:
          return -1;
        }

    case 79:
      switch (pattern545 (x1))
        {
        case 0:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1745; /* *fisthi2_ceil_1 */

        case 1:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1747; /* *fistsi2_ceil_1 */

        case 2:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          return 1749; /* *fistdi2_ceil_1 */

        default:
          return -1;
        }

    case 18:
      if (pattern546 (x1) != 0)
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!memory_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || !const0_operand (operands[1], E_SImode)
              || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
            return -1;
          return 1861; /* probe_stack_1_si */

        case E_DImode:
          if (!memory_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || !const0_operand (operands[1], E_DImode)
              || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
            return -1;
          return 1862; /* probe_stack_1_di */

        default:
          return -1;
        }

    case 92:
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != SET)
        return -1;
      if (pnum_clobbers != NULL)
        {
          res = recog_358 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
        }
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      x5 = XVECEXP (x3, 0, 0);
      operands[3] = x5;
      x7 = XEXP (x6, 0);
      operands[1] = x7;
      x9 = XEXP (x6, 1);
      operands[2] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          switch (pattern1217 (x3, 
E_SImode))
            {
            case 0:
              if (general_operand (operands[2], E_SImode)
                  && (
#line 27493 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
                return 1871; /* *stack_protect_set_2_si_si */
              if (address_no_seg_operand (operands[2], E_SImode)
                  && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode))
                return 1875; /* *stack_protect_set_3_si_si */
              break;

            case 1:
              if (general_operand (operands[2], E_DImode)
                  && (
#line 27512 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
                return 1873; /* *stack_protect_set_2_si_di */
              if (address_no_seg_operand (operands[2], E_DImode)
                  && ((
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1876; /* *stack_protect_set_3_si_di */
              break;

            default:
              break;
            }
          break;

        case E_DImode:
          switch (pattern1217 (x3, 
E_DImode))
            {
            case 0:
              if (general_operand (operands[2], E_SImode)
                  && (
#line 27493 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
                return 1872; /* *stack_protect_set_2_di_si */
              if (address_no_seg_operand (operands[2], E_SImode)
                  && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode))
                return 1877; /* *stack_protect_set_3_di_si */
              break;

            case 1:
              if (general_operand (operands[2], E_DImode)
                  && (
#line 27512 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
                return 1874; /* *stack_protect_set_2_di_di */
              if (address_no_seg_operand (operands[2], E_DImode)
                  && ((
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1878; /* *stack_protect_set_3_di_di */
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      if (!register_operand (operands[1], E_DImode)
          || GET_MODE (x9) != E_DImode)
        return -1;
      switch (GET_CODE (x9))
        {
        case ZERO_EXTEND:
          switch (pattern1307 (x1))
            {
            case 0:
              if (!(
#line 27606 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
                return -1;
              return 1879; /* *stack_protect_set_4z_si_di */

            case 1:
              if (!(
#line 27606 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
                return -1;
              return 1880; /* *stack_protect_set_4z_di_di */

            default:
              return -1;
            }

        case SIGN_EXTEND:
          switch (pattern1307 (x1))
            {
            case 0:
              if (!(
#line 27624 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
                return -1;
              return 1881; /* *stack_protect_set_4s_si_di */

            case 1:
              if (!(
#line 27624 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
                return -1;
              return 1882; /* *stack_protect_set_4s_di_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 118:
      if (GET_MODE (x3) != E_V4SImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_V4SImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!nonimmediate_operand (operands[1], E_DImode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!scratch_operand (operands[2], E_V4SImode)
          || !
#line 1881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC))
        return -1;
      return 2558; /* movdi_to_sse */

    case 282:
      if (GET_MODE (x3) != E_BLKmode
          || pattern340 (x1) != 0)
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      if (!rtx_equal_p (x5, operands[0]))
        return -1;
      return 10905; /* mfence_nosse */

    case 287:
      if (pnum_clobbers == NULL
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!memory_operand (operands[1], E_DImode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!memory_operand (operands[2], E_DImode)
          || !
#line 196 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)))
        return -1;
      *pnum_clobbers = 1;
      return 10906; /* atomic_loaddi_fpu */

    case 288:
      if (pnum_clobbers == NULL
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      if (!nonimmediate_operand (operands[1], E_DImode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!memory_operand (operands[2], E_DImode)
          || !
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)))
        return -1;
      *pnum_clobbers = 1;
      return 10911; /* atomic_storedi_fpu */

    default:
      return -1;
    }
}

 int
recog_372 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  switch (pattern554 (x1))
    {
    case 0:
      x2 = XVECEXP (x1, 0, 1);
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != REG
          || REGNO (x3) != 17
          || GET_MODE (x3) != E_CCmode)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!nonimmediate_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (GET_MODE (x5) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode))
            return -1;
          if (x86_64_hilo_general_operand (operands[2], E_DImode)
              && (
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 266; /* *adddi3_doubleword */
          if (!x86_64_general_operand (operands[2], E_DImode)
              || !(
#line 6627 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
  && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 285; /* *adddi_1 */

        case E_TImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern560 (x5, 
E_TImode) != 0
              || !(
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 267; /* *addti3_doubleword */

        case E_SImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern562 (x5) != 0
              || !
#line 6627 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          return 283; /* *addsi_1 */

        case E_HImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern561 (x5, 
E_HImode) != 0
              || !
#line 6825 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          return 298; /* *addhi_1 */

        case E_QImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern561 (x5, 
E_QImode) != 0
              || !
#line 6882 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          return 300; /* *addqi_1 */

        case E_V2QImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern564 (x5, 
E_V2QImode) != 0
              || !
#line 3241 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size || TARGET_SSE2))
            return -1;
          return 2136; /* addv2qi3 */

        default:
          return -1;
        }

    case 1:
      x2 = XVECEXP (x1, 0, 1);
      if (XVECLEN (x2, 0) != 1)
        return -1;
      x6 = XVECEXP (x2, 0, 0);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      switch (XINT (x2, 1))
        {
        case 110:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern212 (x5, 
E_V2SFmode) != 0
              || !
#line 746 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (PLUS, V2SFmode, operands)))
            return -1;
          return 2052; /* *mmx_addv2sf3 */

        case 174:
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              x4 = XVECEXP (x1, 0, 0);
              x5 = XEXP (x4, 1);
              if (pattern564 (x5, 
E_QImode) != 0
                  || !(
#line 2256 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2082 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                return -1;
              return 2597; /* kaddqi */

            case E_HImode:
              x4 = XVECEXP (x1, 0, 0);
              x5 = XEXP (x4, 1);
              if (pattern564 (x5, 
E_HImode) != 0
                  || !(
#line 2256 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2082 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                return -1;
              return 2598; /* kaddhi */

            case E_SImode:
              x4 = XVECEXP (x1, 0, 0);
              x5 = XEXP (x4, 1);
              if (pattern564 (x5, 
E_SImode) != 0
                  || !(
#line 2256 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return -1;
              return 2599; /* kaddsi */

            case E_DImode:
              x4 = XVECEXP (x1, 0, 0);
              x5 = XEXP (x4, 1);
              if (pattern564 (x5, 
E_DImode) != 0
                  || !(
#line 2256 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return -1;
              return 2600; /* kadddi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 2:
      if (!
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      return 301; /* *addqi_1_slp */

    case 3:
      if (!
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      return 302; /* *addhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_379 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  if (pattern578 (x1, 
PLUS, 
E_CCZmode) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_CCZmode)
    return -1;
  x4 = XEXP (x3, 0);
  x5 = XVECEXP (x4, 0, 0);
  operands[0] = x5;
  x6 = XVECEXP (x4, 0, 1);
  operands[3] = x6;
  if (!const_int_operand (operands[3], E_SImode))
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  x8 = XEXP (x7, 1);
  x9 = XEXP (x8, 1);
  operands[1] = x9;
  x10 = XEXP (x8, 0);
  if (!rtx_equal_p (x10, operands[0]))
    return -1;
  x11 = XEXP (x7, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_QImode:
      if (pattern1736 (x8, 
E_QImode) != 0
          || !
#line 778 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[1])
   == -(unsigned HOST_WIDE_INT) INTVAL (operands[2])))
        return -1;
      return 10926; /* *atomic_fetch_add_cmpqi */

    case E_HImode:
      if (pattern1736 (x8, 
E_HImode) != 0
          || !
#line 778 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[1])
   == -(unsigned HOST_WIDE_INT) INTVAL (operands[2])))
        return -1;
      return 10927; /* *atomic_fetch_add_cmphi */

    case E_SImode:
      if (pattern1736 (x8, 
E_SImode) != 0
          || !
#line 778 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[1])
   == -(unsigned HOST_WIDE_INT) INTVAL (operands[2])))
        return -1;
      return 10928; /* *atomic_fetch_add_cmpsi */

    case E_DImode:
      if (pattern1736 (x8, 
E_DImode) != 0
          || !(
#line 778 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[1])
   == -(unsigned HOST_WIDE_INT) INTVAL (operands[2])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 10929; /* *atomic_fetch_add_cmpdi */

    default:
      return -1;
    }
}

 int
recog_382 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x6;
      res = recog_378 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (GET_CODE (x6) != SUBREG)
        return -1;
      switch (pattern810 (x1))
        {
        case 0:
          if (!
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
            return -1;
          return 782; /* *andqi_exthi_1_cc */

        case 1:
          if (!
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
            return -1;
          return 785; /* *andqi_extsi_1_cc */

        case 2:
          if (!(
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 788; /* *andqi_extdi_1_cc */

        default:
          return -1;
        }

    case NOT:
      x7 = XEXP (x2, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17)
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != CLOBBER)
        return -1;
      x9 = XEXP (x6, 0);
      operands[1] = x9;
      x10 = XEXP (x5, 1);
      operands[2] = x10;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      switch (GET_MODE (x5))
        {
        case E_SImode:
          if (pattern1414 (x6, 
E_SImode) != 0
              || !
#line 13400 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)))
            return -1;
          return 817; /* *andn_si_ccno */

        case E_DImode:
          if (pattern1414 (x6, 
E_DImode) != 0
              || !(
#line 13400 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 818; /* *andn_di_ccno */

        default:
          return -1;
        }

    case NEG:
      x7 = XEXP (x2, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17)
        return -1;
      x9 = XEXP (x6, 0);
      operands[1] = x9;
      x10 = XEXP (x5, 1);
      if (!rtx_equal_p (x10, operands[1]))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x8))
        {
        case SET:
          x12 = XEXP (x8, 1);
          if (GET_CODE (x12) != AND)
            return -1;
          x13 = XEXP (x12, 0);
          if (GET_CODE (x13) != NEG)
            return -1;
          x11 = XEXP (x8, 0);
          operands[0] = x11;
          switch (pattern1477 (x1))
            {
            case 0:
              if (!
#line 21822 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)))
                return -1;
              return 1572; /* *bmi_blsi_si_cmp */

            case 1:
              if (!(
#line 21822 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1573; /* *bmi_blsi_di_cmp */

            default:
              return -1;
            }

        case CLOBBER:
          switch (pattern1220 (x1))
            {
            case 0:
              if (!
#line 21881 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)))
                return -1;
              return 1576; /* *bmi_blsi_si_ccno */

            case 1:
              if (!(
#line 21881 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1577; /* *bmi_blsi_di_ccno */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      x14 = XEXP (x6, 1);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + -1]
          || pattern809 (x2, 
E_CCZmode) != 0)
        return -1;
      x9 = XEXP (x6, 0);
      operands[1] = x9;
      x10 = XEXP (x5, 1);
      if (!rtx_equal_p (x10, operands[1]))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x8))
        {
        case SET:
          x12 = XEXP (x8, 1);
          if (GET_CODE (x12) != AND)
            return -1;
          x13 = XEXP (x12, 0);
          if (GET_CODE (x13) != PLUS)
            return -1;
          x15 = XEXP (x13, 1);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
            return -1;
          x11 = XEXP (x8, 0);
          operands[0] = x11;
          switch (pattern1477 (x1))
            {
            case 0:
              if (!
#line 21974 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1584; /* *bmi_blsr_si_cmp */

            case 1:
              if (!(
#line 21974 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1585; /* *bmi_blsr_di_cmp */

            default:
              return -1;
            }

        case CLOBBER:
          switch (pattern1220 (x1))
            {
            case 0:
              if (!
#line 22031 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1588; /* *bmi_blsr_si_ccz */

            case 1:
              if (!(
#line 22031 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1589; /* *bmi_blsr_di_ccz */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC_VOLATILE:
      switch (pattern365 (x1, 
AND))
        {
        case 0:
          return 10979; /* atomic_and_fetch_cmp_0qi_1 */

        case 1:
          return 10982; /* atomic_and_fetch_cmp_0hi_1 */

        case 2:
          return 10985; /* atomic_and_fetch_cmp_0si_1 */

        case 3:
          if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 10988; /* atomic_and_fetch_cmp_0di_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_387 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  switch (GET_CODE (x4))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[2] = x4;
      res = recog_386 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (GET_CODE (x4) != SUBREG
          || pattern811 (x4) != 0)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern231 (x5, 
E_CCmode, 
17) != 0
          || GET_MODE (x3) != E_QImode
          || !nonimmediate_operand (operands[1], E_QImode))
        return -1;
      x6 = XEXP (x4, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      x8 = XEXP (x2, 0);
      switch (GET_CODE (x8))
        {
        case STRICT_LOW_PART:
          x9 = XEXP (x8, 0);
          operands[0] = x9;
          if (!register_operand (operands[0], E_QImode))
            return -1;
          switch (pattern1782 ())
            {
            case 0:
              if (!
#line 8227 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 405; /* *subqi_exthi_1_slp */

            case 1:
              if (!
#line 8227 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              return 406; /* *subqi_extsi_1_slp */

            case 2:
              if (!(
#line 8227 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 407; /* *subqi_extdi_1_slp */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[0] = x8;
          if (!nonimmediate_operand (operands[0], E_QImode))
            return -1;
          switch (pattern1782 ())
            {
            case 0:
              return 416; /* *subqi_exthi_0 */

            case 1:
              return 417; /* *subqi_extsi_0 */

            case 2:
              if (!
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 418; /* *subqi_extdi_0 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTEND:
      x5 = XVECEXP (x1, 0, 1);
      if (pattern374 (x5) != 0)
        return -1;
      switch (pattern1149 (x2))
        {
        case 0:
          if (!(
#line 8115 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 382; /* *subdi3_doubleword_zext */

        case 1:
          if (!(
#line 8115 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 383; /* *subti3_doubleword_zext */

        default:
          return -1;
        }

    case LTU:
    case UNLT:
      switch (pattern682 (x1))
        {
        case 0:
          if (pattern1545 (x3, 
E_QImode) != 0
              || !
#line 9361 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 491; /* *subqi3_carry_0 */

        case 1:
          if (pattern1545 (x3, 
E_HImode) != 0
              || !
#line 9361 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 492; /* *subhi3_carry_0 */

        case 2:
          if (pattern1545 (x3, 
E_SImode) != 0
              || !
#line 9361 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 493; /* *subsi3_carry_0 */

        case 3:
          if (pattern1545 (x3, 
E_DImode) != 0
              || !(
#line 9361 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 494; /* *subdi3_carry_0 */

        default:
          return -1;
        }

    case GE:
    case GEU:
      switch (pattern682 (x1))
        {
        case 0:
          if (pattern1546 (x3, 
E_QImode) != 0
              || !
#line 9375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 495; /* *subqi3_carry_0r */

        case 1:
          if (pattern1546 (x3, 
E_HImode) != 0
              || !
#line 9375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 496; /* *subhi3_carry_0r */

        case 2:
          if (pattern1546 (x3, 
E_SImode) != 0
              || !
#line 9375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 497; /* *subsi3_carry_0r */

        case 3:
          if (pattern1546 (x3, 
E_DImode) != 0
              || !(
#line 9375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 498; /* *subdi3_carry_0r */

        default:
          return -1;
        }

    case EQ:
      switch (pattern686 (x1))
        {
        case 0:
          if (!
#line 10319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, QImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 582; /* *subqi3_eq_0 */

        case 1:
          if (!
#line 10319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, HImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 583; /* *subhi3_eq_0 */

        case 2:
          if (!
#line 10319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, SImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 584; /* *subsi3_eq_0 */

        case 3:
          if (!(
#line 10319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 585; /* *subdi3_eq_0 */

        default:
          return -1;
        }

    case NE:
      switch (pattern686 (x1))
        {
        case 0:
          if (!
#line 10340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, QImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 586; /* *subqi3_ne_0 */

        case 1:
          if (!
#line 10340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, HImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 587; /* *subhi3_ne_0 */

        case 2:
          if (!
#line 10340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, SImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 588; /* *subsi3_ne_0 */

        case 3:
          if (!(
#line 10340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 589; /* *subdi3_ne_0 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_393 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case ASHIFT:
      return recog_392 (x1, insn, pnum_clobbers);

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (pattern566 (x1))
        {
        case 0:
          if (
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 726; /* *iorqi_1_slp */
          break;

        case 1:
          if (
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 729; /* *iorhi_1_slp */
          break;

        case 2:
          if (x86_64_hilo_general_operand (operands[2], E_DImode)
              && (
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 819; /* *iordi3_doubleword */
          if (x86_64_general_operand (operands[2], E_DImode)
              && (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 832; /* *iordi_1 */
          if (const_int_operand (operands[2], E_DImode)
              && 
#line 13647 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (IOR, DImode, operands)
   && IN_RANGE (exact_log2 (INTVAL (operands[2])), 31, 63)))
            return 838; /* *iordi_1_bts */
          break;

        case 3:
          if ((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 821; /* *iorti3_doubleword */
          break;

        case 4:
          if (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, HImode, operands, TARGET_APX_NDD)
   && true))
            return 824; /* *iorhi_1 */
          break;

        case 5:
          if (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)
   && true))
            return 828; /* *iorsi_1 */
          break;

        case 6:
          if (
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (IOR, V4QImode, operands)))
            return 2284; /* *iorv4qi3 */
          break;

        case 7:
          if (
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (IOR, V2QImode, operands)))
            return 2287; /* *iorv2qi3 */
          break;

        case 8:
          if (
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (IOR, V2HImode, operands)))
            return 2290; /* *iorv2hi3 */
          break;

        case 9:
          if (
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2573; /* kiorqi */
          break;

        case 10:
          if (
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2576; /* kiorhi */
          break;

        case 11:
          if ((
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2579; /* kiorsi */
          break;

        case 12:
          if ((
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2582; /* kiordi */
          break;

        default:
          break;
        }
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != CLOBBER
          || pattern567 (x1) != 0)
        return -1;
      if (GET_CODE (x4) == SUBREG
          && pattern555 (x4) == 0)
        {
          x6 = XEXP (x4, 0);
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          switch (pattern1606 (x2))
            {
            case 0:
              if (
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 732; /* *iorqi_exthi_1_slp */
              break;

            case 1:
              if (
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 735; /* *iorqi_extsi_1_slp */
              break;

            case 2:
              if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 738; /* *iorqi_extdi_1_slp */
              break;

            case 3:
              return 756; /* *iorqi_exthi_0 */

            case 4:
              return 759; /* *iorqi_extsi_0 */

            case 5:
              if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return 762; /* *iorqi_extdi_0 */
              break;

            default:
              break;
            }
          x8 = XEXP (x3, 1);
          if (GET_CODE (x8) == SUBREG)
            {
              switch (pattern1607 (x2))
                {
                case 0:
                  if (
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 741; /* *iorqi_exthi_2_slp */
                  break;

                case 1:
                  if (
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 744; /* *iorqi_extsi_2_slp */
                  break;

                case 2:
                  if ((
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 747; /* *iorqi_extdi_2_slp */
                  break;

                case 3:
                  return 765; /* *iorqi_ext2hi_0 */

                case 4:
                  return 768; /* *iorqi_ext2si_0 */

                case 5:
                  if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 771; /* *iorqi_ext2di_0 */
                  break;

                default:
                  break;
                }
            }
        }
      x9 = XEXP (x2, 0);
      operands[0] = x9;
      if (!nonimmediate_operand (operands[0], E_QImode))
        return -1;
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_QImode))
        return -1;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      if (!general_operand (operands[2], E_QImode)
          || !
#line 13789 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, QImode, operands, TARGET_APX_NDD)
   && true))
        return -1;
      return 868; /* *iorqi_1 */

    case ZERO_EXTEND:
      if (pattern370 (x1) != 0
          || !
#line 13776 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)))
        return -1;
      return 865; /* *iorsi_1_zext_imm */

    case LSHIFTRT:
      if (pattern340 (x1) != 0)
        return -1;
      switch (pattern1039 (x3, 
ASHIFT))
        {
        case 0:
          x8 = XEXP (x3, 1);
          x10 = XEXP (x8, 0);
          x11 = XEXP (x10, 0);
          x12 = XEXP (x11, 0);
          operands[1] = x12;
          if (nonimmediate_operand (operands[0], E_DImode))
            {
              x13 = XEXP (x4, 1);
              x14 = XEXP (x13, 0);
              operands[2] = x14;
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0]))
                {
                  x15 = XEXP (x10, 1);
                  x16 = XEXP (x15, 1);
                  x17 = XEXP (x16, 0);
                  if (rtx_equal_p (x17, operands[2])
                      && 
#line 16800 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && true))
                    return 1143; /* x86_64_shrd */
                }
            }
          operands[2] = x12;
          if (!register_operand (operands[0], E_DImode))
            return -1;
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_DImode))
            return -1;
          x13 = XEXP (x4, 1);
          x14 = XEXP (x13, 0);
          operands[3] = x14;
          x15 = XEXP (x10, 1);
          x16 = XEXP (x15, 1);
          x17 = XEXP (x16, 0);
          if (!rtx_equal_p (x17, operands[3])
              || !
#line 16821 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1145; /* x86_64_shrd_ndd */

        case 1:
          if (pattern1038 (x3, 
E_SImode, 
E_DImode) != 0)
            return -1;
          x8 = XEXP (x3, 1);
          x10 = XEXP (x8, 0);
          x11 = XEXP (x10, 0);
          x12 = XEXP (x11, 0);
          operands[1] = x12;
          if (nonimmediate_operand (operands[0], E_SImode))
            {
              x13 = XEXP (x4, 1);
              x14 = XEXP (x13, 0);
              operands[2] = x14;
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0]))
                {
                  x15 = XEXP (x10, 1);
                  x16 = XEXP (x15, 1);
                  x17 = XEXP (x16, 0);
                  if (rtx_equal_p (x17, operands[2]))
                    return 1155; /* x86_shrd */
                }
            }
          operands[2] = x12;
          if (!register_operand (operands[0], E_SImode))
            return -1;
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x13 = XEXP (x4, 1);
          x14 = XEXP (x13, 0);
          operands[3] = x14;
          x15 = XEXP (x10, 1);
          x16 = XEXP (x15, 1);
          x17 = XEXP (x16, 0);
          if (!rtx_equal_p (x17, operands[3])
              || !
#line 17052 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1157; /* x86_shrd_ndd */

        case 2:
          x8 = XEXP (x3, 1);
          switch (GET_CODE (x8))
            {
            case SUBREG:
              switch (pattern1223 (x3, 
ASHIFT))
                {
                case 0:
                  x13 = XEXP (x4, 1);
                  operands[2] = x13;
                  if (pattern1660 (x3) == 0
                      && 
#line 16836 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && true))
                    return 1147; /* x86_64_shrd_1 */
                  operands[3] = x13;
                  if (pattern1661 (x3) != 0
                      || !
#line 16858 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && true))
                    return -1;
                  return 1149; /* x86_64_shrd_ndd_1 */

                case 1:
                  x13 = XEXP (x4, 1);
                  operands[2] = x13;
                  if (pattern1662 (x3) == 0
                      && 
#line 17067 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && true))
                    return 1159; /* x86_shrd_1 */
                  operands[3] = x13;
                  if (pattern1663 (x3) != 0
                      || !
#line 17089 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && (INTVAL (operands[4]) == 32 - INTVAL (operands[3]))
   && true))
                    return -1;
                  return 1161; /* x86_shrd_ndd_1 */

                default:
                  return -1;
                }

            case ASHIFT:
              switch (pattern1225 (x3))
                {
                case 0:
                  if (!
#line 16930 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1151; /* *x86_64_shrd_shld_1_nozext */

                case 1:
                  if (!
#line 17161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1163; /* *x86_shrd_shld_1_nozext */

                case 2:
                  x10 = XEXP (x8, 0);
                  operands[1] = x10;
                  if (nonimmediate_operand (operands[0], E_DImode))
                    {
                      x13 = XEXP (x4, 1);
                      operands[2] = x13;
                      x6 = XEXP (x4, 0);
                      if (rtx_equal_p (x6, operands[0]))
                        {
                          x18 = XEXP (x8, 1);
                          x19 = XEXP (x18, 1);
                          if (rtx_equal_p (x19, operands[2])
                              && 
#line 16983 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            return 1152; /* *x86_64_shrd_2 */
                        }
                    }
                  operands[2] = x10;
                  if (!register_operand (operands[0], E_DImode))
                    return -1;
                  x6 = XEXP (x4, 0);
                  operands[1] = x6;
                  if (!nonimmediate_operand (operands[1], E_DImode))
                    return -1;
                  x13 = XEXP (x4, 1);
                  operands[3] = x13;
                  x18 = XEXP (x8, 1);
                  x19 = XEXP (x18, 1);
                  if (!rtx_equal_p (x19, operands[2])
                      || !
#line 17004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
  && ix86_pre_reload_split ()))
                    return -1;
                  return 1153; /* *x86_64_shrd_ndd_2 */

                case 3:
                  x10 = XEXP (x8, 0);
                  operands[1] = x10;
                  if (nonimmediate_operand (operands[0], E_SImode))
                    {
                      x13 = XEXP (x4, 1);
                      operands[2] = x13;
                      x6 = XEXP (x4, 0);
                      if (rtx_equal_p (x6, operands[0]))
                        {
                          x18 = XEXP (x8, 1);
                          x19 = XEXP (x18, 1);
                          if (rtx_equal_p (x19, operands[2])
                              && 
#line 17213 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            return 1164; /* *x86_shrd_2 */
                        }
                    }
                  operands[2] = x10;
                  if (!register_operand (operands[0], E_SImode))
                    return -1;
                  x6 = XEXP (x4, 0);
                  operands[1] = x6;
                  if (!nonimmediate_operand (operands[1], E_SImode))
                    return -1;
                  x13 = XEXP (x4, 1);
                  operands[3] = x13;
                  x18 = XEXP (x8, 1);
                  x19 = XEXP (x18, 1);
                  if (!rtx_equal_p (x19, operands[3])
                      || !
#line 17234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1165; /* *x86_shrd_ndd_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NOT:
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != PLUS)
        return -1;
      x20 = XEXP (x6, 1);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || pattern340 (x1) != 0)
        return -1;
      x7 = XEXP (x6, 0);
      operands[1] = x7;
      x8 = XEXP (x3, 1);
      if (!rtx_equal_p (x8, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || GET_MODE (x4) != E_SImode
              || GET_MODE (x6) != E_SImode
              || !nonimmediate_operand (operands[1], E_SImode)
              || !
#line 22214 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
            return -1;
          return 1608; /* *tbm_blci_si */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || GET_MODE (x4) != E_DImode
              || GET_MODE (x6) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode)
              || !(
#line 22214 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1609; /* *tbm_blci_di */

        default:
          return -1;
        }

    case PLUS:
      x13 = XEXP (x4, 1);
      if (GET_CODE (x13) != CONST_INT
          || pattern347 (x1) != 0)
        return -1;
      switch (XWINT (x13, 0))
        {
        case 1L:
          switch (pattern1315 (x3))
            {
            case 0:
              if (!
#line 22254 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1614; /* *tbm_blcs_si */

            case 1:
              if (!(
#line 22254 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1615; /* *tbm_blcs_di */

            case 2:
              if (!
#line 22295 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1620; /* *tbm_t1mskc_si */

            case 3:
              if (!(
#line 22295 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1621; /* *tbm_t1mskc_di */

            default:
              return -1;
            }

        case -1L:
          switch (pattern1315 (x3))
            {
            case 0:
              if (!
#line 22267 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1616; /* *tbm_blsfill_si */

            case 1:
              if (!(
#line 22267 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1617; /* *tbm_blsfill_di */

            case 2:
              if (!
#line 22281 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1618; /* *tbm_blsic_si */

            case 3:
              if (!(
#line 22281 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1619; /* *tbm_blsic_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_409 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      x6 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x6))
        {
        case CLOBBER:
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != REG
              || REGNO (x7) != 17
              || GET_MODE (x7) != E_CCmode)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || GET_MODE (x4) != E_SImode
                  || !nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 22343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT))
                return -1;
              return 1626; /* popcountsi2 */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x4) != E_DImode
                  || !nonimmediate_operand (operands[1], E_DImode)
                  || !(
#line 22343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1627; /* popcountdi2 */

            case E_HImode:
              if (!register_operand (operands[0], E_HImode)
                  || GET_MODE (x4) != E_HImode
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 22548 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && true))
                return -1;
              return 1639; /* popcounthi2 */

            default:
              return -1;
            }

        case UNSPEC:
          switch (pattern699 (x1))
            {
            case 0:
              if (
#line 22374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_POPCNT))
                return 1628; /* *popcountsi2_falsedep_nf */
              if (pnum_clobbers == NULL
                  || !
#line 22393 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT))
                return -1;
              *pnum_clobbers = 1;
              return 1630; /* *popcountsi2_falsedep */

            case 1:
              if ((
#line 22374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_POPCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1629; /* *popcountdi2_falsedep_nf */
              if (pnum_clobbers == NULL
                  || !(
#line 22393 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1631; /* *popcountdi2_falsedep */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (GET_MODE (x5) != E_SImode)
        return -1;
      x6 = XVECEXP (x1, 0, 1);
      if (pattern231 (x6, 
E_CCmode, 
17) != 0
          || !register_operand (operands[0], E_SImode)
          || GET_MODE (x4) != E_SImode)
        return -1;
      x8 = XEXP (x5, 0);
      operands[1] = x8;
      if (!nonimmediate_operand (operands[1], E_HImode)
          || !
#line 22513 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()))
        return -1;
      return 1636; /* *popcounthi2_1 */

    default:
      return -1;
    }
}

 int
recog_416 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (XVECLEN (x3, 0))
    {
    case 1:
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      switch (XINT (x3, 1))
        {
        case 106:
          if (pattern538 (x1) != 0)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != UNSPEC
              || XVECLEN (x6, 0) != 1
              || XINT (x6, 1) != 108
              || GET_MODE (x6) != E_DImode)
            return -1;
          x7 = XVECEXP (x6, 0, 0);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_DImode)
              || !pop_operand (operands[1], E_TImode))
            return -1;
          x8 = XVECEXP (x1, 0, 1);
          x9 = XEXP (x8, 0);
          operands[2] = x9;
          if (!register_operand (operands[2], E_DImode)
              || !
#line 3953 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_PUSH2POP2 && TARGET_APX_PPX))
            return -1;
          return 164; /* pop2p_di */

        case 97:
          switch (pattern815 (x1))
            {
            case 0:
              if (!
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1558; /* *tzcnt_si_falsedep */

            case 1:
              if (!((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1560; /* *tzcnt_di_falsedep */

            default:
              return -1;
            }

        case 96:
          switch (pattern815 (x1))
            {
            case 0:
              if (!
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
                return -1;
              return 1559; /* *lzcnt_si_falsedep */

            case 1:
              if (!((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1561; /* *lzcnt_di_falsedep */

            default:
              return -1;
            }

        case 74:
          if (pattern816 (x1) != 0
              || !
#line 25276 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)))
            return -1;
          return 1740; /* frndintxf2_roundeven_i387 */

        case 75:
          if (pattern816 (x1) != 0
              || !
#line 25276 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)))
            return -1;
          return 1741; /* frndintxf2_floor_i387 */

        case 76:
          if (pattern816 (x1) != 0
              || !
#line 25276 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)))
            return -1;
          return 1742; /* frndintxf2_ceil_i387 */

        case 77:
          if (pattern816 (x1) != 0
              || !
#line 25276 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)))
            return -1;
          return 1743; /* frndintxf2_trunc_i387 */

        case 78:
          switch (pattern818 (x1, pnum_clobbers))
            {
            case 0:
              if (!
#line 25394 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              *pnum_clobbers = 1;
              return 1750; /* fistdi2_floor */

            case 1:
              if (!
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1752; /* fisthi2_floor */

            case 2:
              if (!
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1754; /* fistsi2_floor */

            default:
              return -1;
            }

        case 79:
          switch (pattern818 (x1, pnum_clobbers))
            {
            case 0:
              if (!
#line 25394 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              *pnum_clobbers = 1;
              return 1751; /* fistdi2_ceil */

            case 1:
              if (!
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1753; /* fisthi2_ceil */

            case 2:
              if (!
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1755; /* fistsi2_ceil */

            default:
              return -1;
            }

        case 92:
          x8 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x8) != SET)
            return -1;
          x10 = XEXP (x8, 1);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (pattern941 (x6, 
E_CCmode, 
17) != 0)
            return -1;
          switch (pattern1134 (x1))
            {
            case 0:
              if (!(
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
                return -1;
              return 1867; /* stack_protect_set_1_si_si */

            case 1:
              if (!(
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
                return -1;
              return 1869; /* stack_protect_set_1_si_di */

            case 2:
              if (!(
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
                return -1;
              return 1868; /* stack_protect_set_1_di_si */

            case 3:
              if (!(
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
                return -1;
              return 1870; /* stack_protect_set_1_di_di */

            default:
              return -1;
            }

        case 287:
          if (GET_MODE (x3) != E_DImode)
            return -1;
          x8 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x8) != CLOBBER)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != CLOBBER
              || !nonimmediate_operand (operands[0], E_DImode)
              || !memory_operand (operands[1], E_DImode))
            return -1;
          x9 = XEXP (x8, 0);
          operands[2] = x9;
          if (!memory_operand (operands[2], E_DImode))
            return -1;
          x11 = XEXP (x6, 0);
          operands[3] = x11;
          if (!scratch_operand (operands[3], E_DFmode)
              || !
#line 196 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)))
            return -1;
          return 10906; /* atomic_loaddi_fpu */

        case 288:
          if (GET_MODE (x3) != E_DImode)
            return -1;
          x8 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x8) != CLOBBER)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != CLOBBER
              || !memory_operand (operands[0], E_DImode)
              || !nonimmediate_operand (operands[1], E_DImode))
            return -1;
          x9 = XEXP (x8, 0);
          operands[2] = x9;
          if (!memory_operand (operands[2], E_DImode))
            return -1;
          x11 = XEXP (x6, 0);
          operands[3] = x11;
          if (!scratch_operand (operands[3], E_DFmode)
              || !
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)))
            return -1;
          return 10911; /* atomic_storedi_fpu */

        default:
          return -1;
        }

    case 2:
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != SET)
        return -1;
      x10 = XEXP (x8, 1);
      if (GET_CODE (x10) != UNSPEC
          || XVECLEN (x10, 0) != 2
          || GET_MODE (x10) != E_XFmode)
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x6) != SET)
        return -1;
      x12 = XEXP (x6, 1);
      if (GET_CODE (x12) != UNSPEC
          || XVECLEN (x12, 0) != 2
          || XINT (x12, 1) != 90
          || GET_MODE (x12) != E_CCFPmode)
        return -1;
      x11 = XEXP (x6, 0);
      if (GET_CODE (x11) != REG
          || REGNO (x11) != 18
          || GET_MODE (x11) != E_CCFPmode)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_XFmode)
          || GET_MODE (x3) != E_XFmode
          || pattern1407 (x1) != 0)
        return -1;
      x13 = XVECEXP (x12, 0, 0);
      if (!rtx_equal_p (x13, operands[2]))
        return -1;
      x14 = XVECEXP (x12, 0, 1);
      if (!rtx_equal_p (x14, operands[3]))
        return -1;
      switch (XINT (x3, 1))
        {
        case 86:
          if (XINT (x10, 1) != 87
              || !
#line 23913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          return 1715; /* fpremxf4_i387 */

        case 88:
          if (XINT (x10, 1) != 89
              || !
#line 23985 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          return 1716; /* fprem1xf4_i387 */

        default:
          return -1;
        }

    case 4:
      if (XINT (x3, 1) != 23)
        return -1;
      x5 = XVECEXP (x3, 0, 0);
      if (GET_CODE (x5) != MEM
          || GET_MODE (x5) != E_BLKmode)
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != CLOBBER
          || pattern821 (x1) != 0)
        return -1;
      switch (pattern1136 (x1))
        {
        case 0:
          if (!(
#line 26153 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[AX_REG] || fixed_regs[CX_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1793; /* *strlenqi_1 */

        case 1:
          if (!(
#line 26153 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[AX_REG] || fixed_regs[CX_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1794; /* *strlenqi_1 */

        default:
          return -1;
        }

    case 5:
      if (XINT (x3, 1) != 131)
        return -1;
      if (GET_MODE (x3) == E_SImode
          && pattern705 (x1, 
131, 
5) == 0
          && pattern1710 (x1) == 0
          && 
#line 25846 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2
   && ix86_pre_reload_split ()))
        return 8904; /* sse4_2_pcmpestr */
      if (GET_MODE (x3) != E_CCmode
          || pattern706 (x1) != 0
          || !register_operand (operands[3], E_SImode))
        return -1;
      x15 = XVECEXP (x3, 0, 2);
      operands[4] = x15;
      if (!nonimmediate_operand (operands[4], E_V16QImode))
        return -1;
      x16 = XVECEXP (x3, 0, 3);
      operands[5] = x16;
      if (!register_operand (operands[5], E_SImode))
        return -1;
      x17 = XVECEXP (x3, 0, 4);
      operands[6] = x17;
      if (!const_0_to_255_operand (operands[6], E_SImode))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      x9 = XEXP (x8, 0);
      operands[0] = x9;
      if (!scratch_operand (operands[0], E_V16QImode))
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      x11 = XEXP (x6, 0);
      operands[1] = x11;
      if (!scratch_operand (operands[1], E_SImode)
          || !
#line 25949 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
        return -1;
      return 8907; /* sse4_2_pcmpestr_cconly */

    case 3:
      if (XINT (x3, 1) != 132)
        return -1;
      if (GET_MODE (x3) == E_SImode
          && pattern705 (x1, 
132, 
3) == 0
          && pattern1711 (x1) == 0
          && 
#line 25983 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2
   && ix86_pre_reload_split ()))
        return 8908; /* sse4_2_pcmpistr */
      if (GET_MODE (x3) != E_CCmode
          || pattern706 (x1) != 0
          || !nonimmediate_operand (operands[3], E_V16QImode))
        return -1;
      x15 = XVECEXP (x3, 0, 2);
      operands[4] = x15;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      x9 = XEXP (x8, 0);
      operands[0] = x9;
      if (!scratch_operand (operands[0], E_V16QImode))
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      x11 = XEXP (x6, 0);
      operands[1] = x11;
      if (!scratch_operand (operands[1], E_SImode)
          || !
#line 26074 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
        return -1;
      return 8911; /* sse4_2_pcmpistr_cconly */

    default:
      return -1;
    }
}

 rtx_insn *
split_1 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  switch (GET_CODE (operands[0]))
    {
    case MEM:
      switch (GET_MODE (operands[0]))
        {
        case E_V1TImode:
          if (push_operand (operands[0], E_V1TImode)
              && register_operand (operands[1], E_V1TImode))
            {
              if (((
#line 2175 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 2177 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_3 (insn, operands);
              if (((
#line 2175 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 2177 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_4 (insn, operands);
            }
          break;

        case E_DImode:
          if (push_operand (operands[0], E_DImode))
            {
              if (general_gr_operand (operands[1], E_DImode)
                  && (
#line 2199 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return gen_split_5 (insn, operands);
              if (immediate_operand (operands[1], E_DImode)
                  && 
#line 2232 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && epilogue_completed
   && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode)))
                return gen_split_7 (insn, operands);
              if (sse_reg_operand (operands[1], E_DImode))
                {
                  if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return gen_split_9 (insn, operands);
                  if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return gen_split_12 (insn, operands);
                }
            }
          break;

        case E_TImode:
          if (push_operand (operands[0], E_TImode))
            {
              if (general_gr_operand (operands[1], E_TImode)
                  && (
#line 2199 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_6 (insn, operands);
              if (sse_reg_operand (operands[1], E_TImode))
                {
                  if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && (((
#line 1202 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return gen_split_10 (insn, operands);
                  if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && (((
#line 1202 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return gen_split_13 (insn, operands);
                }
            }
          break;

        case E_SImode:
          if (push_operand (operands[0], E_SImode)
              && sse_reg_operand (operands[1], E_SImode))
            {
              if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_8 (insn, operands);
              if ((
#line 2269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_11 (insn, operands);
            }
          break;

        case E_TFmode:
          if (push_operand (operands[0], E_TFmode)
              && sse_reg_operand (operands[1], E_TFmode))
            {
              if ((
#line 3791 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_37 (insn, operands);
              if ((
#line 3791 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE && reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_38 (insn, operands);
            }
          break;

        case E_XFmode:
          if (push_operand (operands[0], E_XFmode)
              && fp_register_operand (operands[1], E_XFmode))
            {
              if ((
#line 3826 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_39 (insn, operands);
              if ((
#line 3826 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_40 (insn, operands);
            }
          break;

        case E_DFmode:
          if (push_operand (operands[0], E_DFmode)
              && any_fp_register_operand (operands[1], E_DFmode))
            {
              if ((
#line 3860 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_41 (insn, operands);
              if ((
#line 3860 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_42 (insn, operands);
            }
          break;

        case E_SFmode:
          if (push_operand (operands[0], E_SFmode))
            {
              if (any_fp_register_operand (operands[1], E_SFmode))
                {
                  if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                    return gen_split_43 (insn, operands);
                  if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                    return gen_split_46 (insn, operands);
                }
              if (memory_operand (operands[1], E_SFmode)
                  && 
#line 4014 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && find_constant_src (insn)))
                return gen_split_49 (insn, operands);
            }
          break;

        case E_HFmode:
          if (push_operand (operands[0], E_HFmode)
              && any_fp_register_operand (operands[1], E_HFmode))
            {
              if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_44 (insn, operands);
              if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_47 (insn, operands);
            }
          break;

        case E_BFmode:
          if (push_operand (operands[0], E_BFmode)
              && any_fp_register_operand (operands[1], E_BFmode))
            {
              if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return gen_split_45 (insn, operands);
              if ((
#line 3991 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return gen_split_48 (insn, operands);
            }
          break;

        default:
          break;
        }
      break;

    case REG:
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (sse_reg_operand (operands[0], E_TImode)
              && general_reg_operand (operands[1], E_TImode)
              && 
#line 2574 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_SSE4_1
   && reload_completed))
            return gen_split_20 (insn, operands);
          if (general_reg_operand (operands[0], E_TImode)
              && sse_reg_operand (operands[1], E_TImode)
              && (
#line 2765 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1
   && reload_completed) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return gen_split_22 (insn, operands);
          break;

        case E_DImode:
          if (general_reg_operand (operands[0], E_DImode)
              && sse_reg_operand (operands[1], E_DImode)
              && (
#line 2765 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1
   && reload_completed) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return gen_split_21 (insn, operands);
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (nonimmediate_gr_operand (operands[0], E_DImode)
          && general_gr_operand (operands[1], E_DImode)
          && (
#line 2782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
        return gen_split_23 (insn, operands);
      if (sse_reg_operand (operands[0], E_DImode)
          && general_reg_operand (operands[1], E_DImode)
          && 
#line 2789 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_SSE4_1
   && reload_completed))
        return gen_split_25 (insn, operands);
      break;

    case E_TImode:
      if (nonimmediate_gr_operand (operands[0], E_TImode)
          && general_gr_operand (operands[1], E_TImode)
          && (
#line 2782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return gen_split_24 (insn, operands);
      break;

    default:
      break;
    }
  if (push_operand (operands[0], E_VOIDmode)
      && general_gr_operand (operands[1], E_VOIDmode)
      && 
#line 4022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (GET_MODE (operands[0]) == TFmode
       || GET_MODE (operands[0]) == XFmode
       || GET_MODE (operands[0]) == DFmode)))
    return gen_split_50 (insn, operands);
  switch (GET_MODE (operands[0]))
    {
    case E_TFmode:
      if (nonimmediate_gr_operand (operands[0], E_TFmode)
          && general_gr_operand (operands[1], E_TFmode)
          && 
#line 4095 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        return gen_split_51 (insn, operands);
      break;

    case E_XFmode:
      if (nonimmediate_gr_operand (operands[0], E_XFmode)
          && general_gr_operand (operands[1], E_XFmode)
          && 
#line 4168 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        return gen_split_52 (insn, operands);
      break;

    case E_DFmode:
      if (nonimmediate_gr_operand (operands[0], E_DFmode)
          && general_gr_operand (operands[1], E_DFmode)
          && 
#line 4346 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && reload_completed))
        return gen_split_53 (insn, operands);
      break;

    default:
      break;
    }
  if (any_fp_register_operand (operands[0], E_VOIDmode)
      && memory_operand (operands[1], E_VOIDmode)
      && 
#line 4614 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (GET_MODE (operands[0]) == TFmode
       || GET_MODE (operands[0]) == XFmode
       || GET_MODE (operands[0]) == DFmode
       || GET_MODE (operands[0]) == SFmode)
   && ix86_standard_x87sse_constant_load_p (insn, operands[0])))
    return gen_split_54 (insn, operands);
  if (fp_register_operand (operands[0], E_SFmode)
      && immediate_operand (operands[1], E_SFmode)
      && 
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (standard_80387_constant_p (operands[1]) == 8
       || standard_80387_constant_p (operands[1]) == 9)))
    return gen_split_56 (insn, operands);
  if (fp_register_operand (operands[0], E_DFmode)
      && immediate_operand (operands[1], E_DFmode)
      && 
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (standard_80387_constant_p (operands[1]) == 8
       || standard_80387_constant_p (operands[1]) == 9)))
    return gen_split_57 (insn, operands);
  if (!fp_register_operand (operands[0], E_XFmode)
      || !immediate_operand (operands[1], E_XFmode)
      || !
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && (standard_80387_constant_p (operands[1]) == 8
       || standard_80387_constant_p (operands[1]) == 9)))
    return NULL;
  return gen_split_58 (insn, operands);
}

 rtx_insn *
split_10 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  x5 = XEXP (x3, 1);
  switch (GET_CODE (x5))
    {
    case XOR:
      x6 = XEXP (x5, 1);
      if (GET_CODE (x6) != CONST_INT)
        return NULL;
      x7 = XEXP (x5, 0);
      switch (GET_CODE (x7))
        {
        case MINUS:
          if (GET_MODE (x7) != E_SImode)
            return NULL;
          x8 = XEXP (x7, 0);
          if (GET_CODE (x8) != CONST_INT
              || pattern1047 (x3, 
E_SImode) != 0)
            return NULL;
          x9 = XEXP (x7, 1);
          if (GET_MODE (x9) != E_SImode)
            return NULL;
          switch (XWINT (x8, 0))
            {
            case 63L:
              if (GET_CODE (x9) != SUBREG
                  || maybe_ne (SUBREG_BYTE (x9), 0))
                return NULL;
              x10 = XEXP (x9, 0);
              if (GET_CODE (x10) != CLZ
                  || GET_MODE (x10) != E_DImode
                  || XWINT (x6, 0) != 63L)
                return NULL;
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              if (!nonimmediate_operand (operands[1], E_DImode)
                  || !
#line 21390 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_886 (insn, operands);

            case 31L:
              if (GET_CODE (x9) != CLZ
                  || XWINT (x6, 0) != 31L)
                return NULL;
              x10 = XEXP (x9, 0);
              operands[1] = x10;
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 21415 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_887 (insn, operands);

            default:
              return NULL;
            }

        case SIGN_EXTEND:
          if (pattern825 (x7, 
SUBREG, 
63, 
E_DImode) != 0)
            return NULL;
          x8 = XEXP (x7, 0);
          x12 = XEXP (x8, 1);
          if (maybe_ne (SUBREG_BYTE (x12), 0)
              || GET_MODE (x12) != E_SImode)
            return NULL;
          x13 = XEXP (x12, 0);
          if (GET_CODE (x13) != CLZ
              || GET_MODE (x13) != E_DImode
              || XWINT (x6, 0) != 63L
              || pattern1047 (x3, 
E_DImode) != 0)
            return NULL;
          x14 = XEXP (x13, 0);
          operands[1] = x14;
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !
#line 21441 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT
   && TARGET_64BIT
   && ix86_pre_reload_split ()
   && ((unsigned HOST_WIDE_INT)
       trunc_int_for_mode (UINTVAL (operands[2]) - 63, SImode)
       == UINTVAL (operands[2]) - 63)))
            return NULL;
          return gen_split_888 (insn, operands);

        default:
          return NULL;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x5) != E_DImode)
        return NULL;
      x7 = XEXP (x5, 0);
      if (GET_CODE (x7) != XOR
          || pattern825 (x7, 
CLZ, 
31, 
E_SImode) != 0)
        return NULL;
      x8 = XEXP (x7, 0);
      x12 = XEXP (x8, 1);
      if (GET_MODE (x12) != E_SImode)
        return NULL;
      x9 = XEXP (x7, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 31]
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || !const_int_operand (operands[2], E_DImode))
        return NULL;
      x13 = XEXP (x12, 0);
      operands[1] = x13;
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !
#line 21470 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT
   && TARGET_64BIT
   && ix86_pre_reload_split ()
   && ((unsigned HOST_WIDE_INT)
       trunc_int_for_mode (UINTVAL (operands[2]) - 31, SImode)
       == UINTVAL (operands[2]) - 31)))
        return NULL;
      return gen_split_889 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_12 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case NE:
    case EQ:
      operands[5] = x3;
      if (bt_comparison_operator (operands[5], E_VOIDmode))
        {
          res = split_3 (x1, insn);
          if (res != NULL_RTX)
            return res;
        }
      x4 = XEXP (x3, 0);
      if (!ix86_comparison_operator (x4, E_VOIDmode))
        return NULL;
      operands[0] = x4;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != REG
          || REGNO (x5) != 17)
        return NULL;
      x6 = XEXP (x4, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x7 = XEXP (x3, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x8 = XEXP (x2, 1);
      if (GET_CODE (x8) != LABEL_REF)
        return NULL;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return NULL;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC)
        return NULL;
      x11 = XEXP (x8, 0);
      operands[1] = x11;
      switch (GET_CODE (x3))
        {
        case NE:
          return gen_split_872 (insn, operands);

        case EQ:
          return gen_split_873 (insn, operands);

        default:
          return NULL;
        }

    case GEU:
    case LTU:
      operands[1] = x3;
      if (!add_comparison_operator (operands[1], E_VOIDmode))
        return NULL;
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != NOT)
        return NULL;
      x8 = XEXP (x2, 1);
      if (GET_CODE (x8) != LABEL_REF)
        return NULL;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return NULL;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      switch (GET_MODE (x4))
        {
        case E_QImode:
          if (!register_operand (operands[2], E_QImode)
              || !nonimmediate_operand (operands[3], E_QImode))
            return NULL;
          return gen_split_867 (insn, operands);

        case E_HImode:
          if (!register_operand (operands[2], E_HImode)
              || !nonimmediate_operand (operands[3], E_HImode))
            return NULL;
          return gen_split_868 (insn, operands);

        case E_SImode:
          if (!register_operand (operands[2], E_SImode)
              || !nonimmediate_operand (operands[3], E_SImode))
            return NULL;
          return gen_split_869 (insn, operands);

        case E_DImode:
          if (!register_operand (operands[2], E_DImode)
              || !nonimmediate_operand (operands[3], E_DImode)
              || !
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return NULL;
          return gen_split_870 (insn, operands);

        default:
          return NULL;
        }

    case GTU:
    case LEU:
      operands[1] = x3;
      if (!shr_comparison_operator (operands[1], E_VOIDmode))
        return NULL;
      x8 = XEXP (x2, 1);
      if (GET_CODE (x8) != LABEL_REF)
        return NULL;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return NULL;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC)
        return NULL;
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!register_operand (operands[2], E_DImode))
        return NULL;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return NULL;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!
#line 19761 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3]) + 1), 32, 63)))
        return NULL;
      return gen_split_871 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_15 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (pattern1164 (x2))
    {
    case 0:
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          x3 = XEXP (x2, 1);
          if (GET_MODE (x3) != E_DImode)
            return NULL;
          if (nonimmediate_operand (operands[0], E_DImode)
              && nonimmediate_operand (operands[1], E_DImode)
              && x86_64_hilo_general_operand (operands[2], E_DImode)
              && ((
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6479 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return gen_split_104 (insn, operands);
          if (!register_operand (operands[0], E_DImode)
              || !register_operand (operands[1], E_DImode)
              || !x86_64_nonmemory_operand (operands[2], E_DImode))
            return NULL;
          if ((
#line 7065 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_avoid_lea_for_add (insn, operands)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return gen_split_129 (insn, operands);
          if (!(
#line 7091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_lea_for_add_ok (insn, operands)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_134 (insn, operands);

        case E_TImode:
          x3 = XEXP (x2, 1);
          if (pattern560 (x3, 
E_TImode) != 0
              || !((
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6479 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_105 (insn, operands);

        case E_SImode:
          x3 = XEXP (x2, 1);
          if (pattern1487 (x3, 
E_SImode) != 0)
            return NULL;
          if (
#line 7065 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_avoid_lea_for_add (insn, operands)))
            return gen_split_128 (insn, operands);
          if (!
#line 7091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_133 (insn, operands);

        case E_QImode:
          x3 = XEXP (x2, 1);
          if (pattern1233 (x3, 
E_QImode) != 0
              || !
#line 7091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_131 (insn, operands);

        case E_HImode:
          if (!register_operand (operands[0], E_HImode))
            return NULL;
          x3 = XEXP (x2, 1);
          if (GET_MODE (x3) != E_HImode
              || !register_operand (operands[1], E_HImode)
              || !nonmemory_operand (operands[2], E_HImode)
              || !
#line 7091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_132 (insn, operands);

        default:
          return NULL;
        }

    case 1:
      if (!(
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 6981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
        return NULL;
      return gen_split_120 (insn, operands);

    case 2:
      if (!(
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 6981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
        return NULL;
      return gen_split_121 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_22 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x5;
      switch (pattern1166 (x3))
        {
        case 0:
          if ((
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
            return gen_split_294 (insn, operands);
          break;

        case 1:
          if ((
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
            return gen_split_297 (insn, operands);
          break;

        case 2:
          if (nonimmediate_operand (operands[0], E_DImode)
              && nonimmediate_operand (operands[1], E_DImode))
            {
              if (x86_64_hilo_general_operand (operands[2], E_DImode)
                  && ((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 13543 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_393 (insn, operands);
              if (const_int_operand (operands[2], E_DImode)
                  && (
#line 13647 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (IOR, DImode, operands)
   && IN_RANGE (exact_log2 (INTVAL (operands[2])), 31, 63)) && 
#line 13651 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_400 (insn, operands);
            }
          if (const_int_operand (operands[2], E_DImode))
            {
              if (QIreg_operand (operands[0], E_DImode)
                  && register_operand (operands[1], E_DImode)
                  && (
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_428 (insn, operands);
              if (any_QIreg_operand (operands[0], E_DImode)
                  && general_operand (operands[1], E_DImode)
                  && (
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_434 (insn, operands);
            }
          break;

        case 3:
          if (((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (IOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13543 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return gen_split_395 (insn, operands);
          break;

        case 4:
          if (QIreg_operand (operands[0], E_HImode)
              && register_operand (operands[1], E_HImode)
              && 
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))))
            return gen_split_424 (insn, operands);
          if (any_QIreg_operand (operands[0], E_HImode)
              && general_operand (operands[1], E_HImode)
              && 
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_430 (insn, operands);
          break;

        case 5:
          if (QIreg_operand (operands[0], E_SImode)
              && register_operand (operands[1], E_SImode)
              && 
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))))
            return gen_split_426 (insn, operands);
          if (any_QIreg_operand (operands[0], E_SImode)
              && general_operand (operands[1], E_SImode)
              && 
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_432 (insn, operands);
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG
          || pattern1165 (x4) != 0)
        return NULL;
      x6 = XEXP (x5, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      switch (pattern1666 (x3))
        {
        case 0:
          if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_300 (insn, operands);
          break;

        case 1:
          if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_303 (insn, operands);
          break;

        case 2:
          if (((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_306 (insn, operands);
          break;

        default:
          break;
        }
      operands[1] = x7;
      switch (pattern1667 (x3))
        {
        case 0:
          if (!(
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_309 (insn, operands);

        case 1:
          if (!(
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_312 (insn, operands);

        case 2:
          if (!((
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_315 (insn, operands);

        case 3:
          if (!
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_329 (insn, operands);

        case 4:
          if (!
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_332 (insn, operands);

        case 5:
          if (!(
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_335 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      x6 = XEXP (x5, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
          x9 = XEXP (x4, 1);
          if (GET_CODE (x9) != LSHIFTRT)
            return NULL;
          switch (pattern1225 (x4))
            {
            case 0:
              if (!(
#line 15545 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()) && 
#line 15549 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_569 (insn, operands);

            case 1:
              if (!(
#line 15777 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()) && 
#line 15780 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_573 (insn, operands);

            case 2:
              x10 = XEXP (x9, 0);
              operands[1] = x10;
              if (nonimmediate_operand (operands[0], E_DImode))
                {
                  x11 = XEXP (x5, 1);
                  operands[2] = x11;
                  if (rtx_equal_p (x6, operands[0]))
                    {
                      x12 = XEXP (x9, 1);
                      x13 = XEXP (x12, 1);
                      if (rtx_equal_p (x13, operands[2])
                          && (
#line 15598 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 15600 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_570 (insn, operands);
                    }
                }
              operands[2] = x10;
              if (!register_operand (operands[0], E_DImode))
                return NULL;
              operands[1] = x6;
              if (!nonimmediate_operand (operands[1], E_DImode))
                return NULL;
              x11 = XEXP (x5, 1);
              operands[3] = x11;
              x12 = XEXP (x9, 1);
              x13 = XEXP (x12, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !(
#line 15619 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()) && 
#line 15622 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_571 (insn, operands);

            case 3:
              x10 = XEXP (x9, 0);
              operands[1] = x10;
              if (nonimmediate_operand (operands[0], E_SImode))
                {
                  x11 = XEXP (x5, 1);
                  operands[2] = x11;
                  if (rtx_equal_p (x6, operands[0]))
                    {
                      x12 = XEXP (x9, 1);
                      x13 = XEXP (x12, 1);
                      if (rtx_equal_p (x13, operands[2])
                          && (
#line 15829 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 15831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_574 (insn, operands);
                    }
                }
              operands[2] = x10;
              if (!register_operand (operands[0], E_SImode))
                return NULL;
              operands[1] = x6;
              if (!nonimmediate_operand (operands[1], E_SImode))
                return NULL;
              x11 = XEXP (x5, 1);
              operands[3] = x11;
              x12 = XEXP (x9, 1);
              x13 = XEXP (x12, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !(
#line 15850 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()) && 
#line 15853 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_575 (insn, operands);

            default:
              return NULL;
            }

        case CONST_INT:
          if (XWINT (x6, 0) != 1L)
            return NULL;
          switch (pattern1049 (x4))
            {
            case 0:
              if (!(
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18861 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_802 (insn, operands);

            case 1:
              if (!((
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18861 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_804 (insn, operands);

            case 2:
              if (!(
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_806 (insn, operands);

            case 3:
              if (!((
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_808 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case LSHIFTRT:
      x9 = XEXP (x4, 1);
      if (GET_CODE (x9) != ASHIFT)
        return NULL;
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      switch (pattern1225 (x4))
        {
        case 0:
          if (!(
#line 16930 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()) && 
#line 16934 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_616 (insn, operands);

        case 1:
          if (!(
#line 17161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()) && 
#line 17164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_620 (insn, operands);

        case 2:
          x10 = XEXP (x9, 0);
          operands[1] = x10;
          if (nonimmediate_operand (operands[0], E_DImode))
            {
              x11 = XEXP (x5, 1);
              operands[2] = x11;
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[0]))
                {
                  x12 = XEXP (x9, 1);
                  x13 = XEXP (x12, 1);
                  if (rtx_equal_p (x13, operands[2])
                      && (
#line 16983 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 16985 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return gen_split_617 (insn, operands);
                }
            }
          operands[2] = x10;
          if (!register_operand (operands[0], E_DImode))
            return NULL;
          x6 = XEXP (x5, 0);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_DImode))
            return NULL;
          x11 = XEXP (x5, 1);
          operands[3] = x11;
          x12 = XEXP (x9, 1);
          x13 = XEXP (x12, 1);
          if (!rtx_equal_p (x13, operands[2])
              || !(
#line 17004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
  && ix86_pre_reload_split ()) && 
#line 17007 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_618 (insn, operands);

        case 3:
          x10 = XEXP (x9, 0);
          operands[1] = x10;
          if (nonimmediate_operand (operands[0], E_SImode))
            {
              x11 = XEXP (x5, 1);
              operands[2] = x11;
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[0]))
                {
                  x12 = XEXP (x9, 1);
                  x13 = XEXP (x12, 1);
                  if (rtx_equal_p (x13, operands[2])
                      && (
#line 17213 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 17215 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return gen_split_621 (insn, operands);
                }
            }
          operands[2] = x10;
          if (!register_operand (operands[0], E_SImode))
            return NULL;
          x6 = XEXP (x5, 0);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return NULL;
          x11 = XEXP (x5, 1);
          operands[3] = x11;
          x12 = XEXP (x9, 1);
          x13 = XEXP (x12, 1);
          if (!rtx_equal_p (x13, operands[3])
              || !(
#line 17234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()) && 
#line 17237 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_622 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_34 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_CODE (x2))
    {
    case SET:
      x3 = XEXP (x2, 1);
      switch (GET_CODE (x3))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[1] = x3;
          if (pattern340 (x1) == 0)
            {
              switch (GET_MODE (operands[0]))
                {
                case E_HImode:
                  if (memory_operand (operands[0], E_HImode)
                      && const0_operand (operands[1], E_HImode)
                      && (
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 2438 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_14 (insn, operands);
                  if (nonimmediate_operand (operands[0], E_HImode)
                      && constm1_operand (operands[1], E_HImode)
                      && (
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 2453 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_17 (insn, operands);
                  break;

                case E_SImode:
                  if (memory_operand (operands[0], E_SImode)
                      && const0_operand (operands[1], E_SImode)
                      && (
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 2438 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_15 (insn, operands);
                  if (nonimmediate_operand (operands[0], E_SImode)
                      && constm1_operand (operands[1], E_SImode)
                      && (
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 2453 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_18 (insn, operands);
                  break;

                case E_DImode:
                  if (memory_operand (operands[0], E_DImode)
                      && const0_operand (operands[1], E_DImode)
                      && ((
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 2438 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_16 (insn, operands);
                  if (nonimmediate_operand (operands[0], E_DImode)
                      && constm1_operand (operands[1], E_DImode)
                      && ((
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 2453 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( !(optimize_insn_for_size_p () && optimize_size > 1))))
                    return gen_split_19 (insn, operands);
                  break;

                default:
                  break;
                }
            }
          if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return NULL;
          x4 = XEXP (x2, 0);
          if (GET_CODE (x4) != ZERO_EXTRACT
              || GET_MODE (x4) != E_HImode)
            return NULL;
          x5 = XEXP (x4, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (pattern231 (x6, 
E_CCmode, 
17) != 0)
            return NULL;
          x7 = XEXP (x4, 0);
          operands[0] = x7;
          x8 = XEXP (x4, 2);
          operands[1] = x8;
          if (!register_operand (operands[1], E_QImode))
            return NULL;
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (nonimmediate_operand (operands[0], E_QImode)
                  && (
#line 18995 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 18997 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( MEM_P (operands[0]))))
                return gen_split_816 (insn, operands);
              if (!register_operand (operands[0], E_QImode)
                  || !
#line 19019 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_818 (insn, operands);

            case E_HImode:
              if (nonimmediate_operand (operands[0], E_HImode)
                  && (
#line 18995 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 18997 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( MEM_P (operands[0]))))
                return gen_split_817 (insn, operands);
              if (!register_operand (operands[0], E_HImode)
                  || !
#line 19019 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_819 (insn, operands);

            default:
              return NULL;
            }

        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          x9 = XEXP (x3, 1);
          if (GET_CODE (x9) != CONST_INT)
            return NULL;
          if (XWINT (x9, 0) == 1L)
            {
              res = split_14 (x1, insn);
              if (res != NULL_RTX)
                return res;
            }
          if (XWINT (x9, 0) != 8L
              || pattern713 (x2) != 0)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (pattern231 (x6, 
E_CCmode, 
17) != 0)
            return NULL;
          switch (pattern1405 (x2))
            {
            case 0:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_364 (insn, operands);

            case 1:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_367 (insn, operands);

            case 2:
              if (!((
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_370 (insn, operands);

            case 3:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_365 (insn, operands);

            case 4:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_368 (insn, operands);

            case 5:
              if (!((
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_371 (insn, operands);

            case 6:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_366 (insn, operands);

            case 7:
              if (!(
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_369 (insn, operands);

            case 8:
              if (!((
#line 13242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(GET_MODE (operands[1]) == GET_MODE (operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13246 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
                return NULL;
              return gen_split_372 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          return split_30 (x1, insn);

        case FIX:
          x6 = XVECEXP (x1, 0, 1);
          if (pattern353 (x6) != 0)
            return NULL;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          x10 = XEXP (x3, 0);
          operands[1] = x10;
          if (!register_operand (operands[1], E_VOIDmode))
            return NULL;
          switch (pattern544 (x3))
            {
            case 0:
              if (!(
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || HImode != DImode))
   && ix86_pre_reload_split ()) && 
#line 6011 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_82 (insn, operands);

            case 1:
              if (!(
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || SImode != DImode))
   && ix86_pre_reload_split ()) && 
#line 6011 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_83 (insn, operands);

            case 2:
              if (!(
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || DImode != DImode))
   && ix86_pre_reload_split ()) && 
#line 6011 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_84 (insn, operands);

            default:
              return NULL;
            }

        case MULT:
          if (pattern340 (x1) != 0)
            return NULL;
          x10 = XEXP (x3, 0);
          switch (GET_CODE (x10))
            {
            case REG:
              if (!rtx_equal_p (x10, operands[0]))
                return NULL;
              x9 = XEXP (x3, 1);
              operands[1] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (!general_reg_operand (operands[0], E_SImode)
                      || GET_MODE (x3) != E_SImode
                      || !const1248_operand (operands[1], E_SImode)
                      || !
#line 6432 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                    return NULL;
                  return gen_split_100 (insn, operands);

                case E_DImode:
                  if (!general_reg_operand (operands[0], E_DImode)
                      || GET_MODE (x3) != E_DImode
                      || !const1248_operand (operands[1], E_DImode)
                      || !(
#line 6432 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return NULL;
                  return gen_split_101 (insn, operands);

                default:
                  return NULL;
                }

            case ZERO_EXTEND:
              x9 = XEXP (x3, 1);
              if (GET_CODE (x9) != ZERO_EXTEND)
                return NULL;
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              x12 = XEXP (x9, 0);
              operands[2] = x12;
              switch (GET_MODE (operands[0]))
                {
                case E_DImode:
                  if (pattern558 (x3, 
E_SImode, 
E_DImode) != 0
                      || !(
#line 11033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed
  && REGNO (operands[1]) == DX_REG) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                    return NULL;
                  return gen_split_244 (insn, operands);

                case E_TImode:
                  if (pattern558 (x3, 
E_DImode, 
E_TImode) != 0
                      || !(
#line 11033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed
  && REGNO (operands[1]) == DX_REG) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return NULL;
                  return gen_split_245 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case PLUS:
          return split_25 (x1, insn);

        case SUBREG:
          return split_24 (x1, insn);

        case NE:
        case EQ:
        case GE:
        case GT:
        case LE:
        case LT:
        case LTGT:
        case GEU:
        case GTU:
        case LEU:
        case LTU:
        case UNORDERED:
        case ORDERED:
        case UNEQ:
        case UNGE:
        case UNGT:
        case UNLE:
        case UNLT:
          if (GET_CODE (x3) == EQ)
            {
              x10 = XEXP (x3, 0);
              switch (GET_CODE (x10))
                {
                case PLUS:
                  switch (pattern717 (x1, 
PLUS))
                    {
                    case 0:
                      if (((
#line 7725 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 7727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_152 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 7725 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 7727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_153 (insn, operands);
                      break;

                    case 2:
                      if (((
#line 7771 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 7775 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_154 (insn, operands);
                      break;

                    case 3:
                      if (((
#line 7771 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 7775 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_155 (insn, operands);
                      break;

                    default:
                      break;
                    }
                  break;

                case MINUS:
                  switch (pattern717 (x1, 
MINUS))
                    {
                    case 0:
                      if (((
#line 8497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 8499 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_192 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 8497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8499 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_193 (insn, operands);
                      break;

                    case 2:
                      if (((
#line 8541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 8545 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_194 (insn, operands);
                      break;

                    case 3:
                      if (((
#line 8541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8545 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                        return gen_split_195 (insn, operands);
                      break;

                    default:
                      break;
                    }
                  break;

                case ZERO_EXTRACT:
                  switch (pattern681 (x1))
                    {
                    case 0:
                      if ((
#line 19416 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 19418 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_848 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 19416 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19418 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_849 (insn, operands);
                      break;

                    default:
                      break;
                    }
                  break;

                default:
                  break;
                }
            }
          operands[1] = x3;
          switch (pattern369 (x1))
            {
            case 0:
              if (!(
#line 19529 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL
   && TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 19532 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_858 (insn, operands);

            case 1:
              if (!(
#line 19529 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL
   && TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 19532 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_859 (insn, operands);

            default:
              return NULL;
            }

        case MINUS:
          x6 = XVECEXP (x1, 0, 1);
          if (pattern231 (x6, 
E_CCmode, 
17) != 0)
            return NULL;
          x10 = XEXP (x3, 0);
          switch (GET_CODE (x10))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
            case CONST_POLY_INT:
            case CONST_FIXED:
            case CONST_DOUBLE:
            case CONST_VECTOR:
            case CONST:
            case REG:
            case SUBREG:
            case MEM:
            case LABEL_REF:
            case SYMBOL_REF:
            case HIGH:
              operands[1] = x10;
              res = split_16 (x1, insn);
              if (res != NULL_RTX)
                return res;
              if (GET_CODE (x10) != SUBREG)
                return NULL;
              switch (pattern1037 (x2))
                {
                case 0:
                  if (!(
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8262 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_183 (insn, operands);

                case 1:
                  if (!(
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8262 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_184 (insn, operands);

                case 2:
                  if (!((
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8262 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_185 (insn, operands);

                case 3:
                  if (!
#line 8351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
                    return NULL;
                  return gen_split_186 (insn, operands);

                case 4:
                  if (!
#line 8351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
                    return NULL;
                  return gen_split_187 (insn, operands);

                case 5:
                  if (!(
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 8351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_188 (insn, operands);

                default:
                  return NULL;
                }

            case MINUS:
              x13 = XEXP (x10, 1);
              if (GET_CODE (x13) != EQ)
                return NULL;
              x14 = XEXP (x13, 1);
              if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return NULL;
              x4 = XEXP (x2, 0);
              operands[0] = x4;
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              x15 = XEXP (x13, 0);
              operands[3] = x15;
              if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
                return NULL;
              x9 = XEXP (x3, 1);
              operands[2] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1547 (x3, 
E_QImode) != 0
                      || !(
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10245 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_224 (insn, operands);

                case E_HImode:
                  if (pattern1547 (x3, 
E_HImode) != 0
                      || !(
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10245 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_225 (insn, operands);

                case E_SImode:
                  if (pattern1548 (x3, 
E_SImode) != 0
                      || !(
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10245 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_226 (insn, operands);

                case E_DImode:
                  if (pattern1548 (x3, 
E_DImode) != 0
                      || !((
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10245 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_227 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case IF_THEN_ELSE:
          x10 = XEXP (x3, 0);
          if (!bt_comparison_operator (x10, E_VOIDmode))
            return NULL;
          x13 = XEXP (x10, 1);
          if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return NULL;
          switch (pattern687 (x1))
            {
            case 0:
              x11 = XEXP (x10, 0);
              operands[2] = x11;
              x9 = XEXP (x3, 1);
              if (GET_CODE (x9) != PLUS)
                return NULL;
              x16 = XEXP (x9, 1);
              if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
                return NULL;
              x4 = XEXP (x2, 0);
              operands[0] = x4;
              operands[1] = x10;
              switch (pattern1558 (x3))
                {
                case 0:
                  if (!(
#line 8762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE) && 
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_196 (insn, operands);

                case 1:
                  if (!(
#line 8762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE) && 
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_197 (insn, operands);

                case 2:
                  if (!((
#line 8762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_198 (insn, operands);

                default:
                  return NULL;
                }

            case 1:
              x11 = XEXP (x10, 0);
              x17 = XEXP (x11, 1);
              if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                return NULL;
              switch (pattern1324 (x2))
                {
                case 0:
                  x18 = XEXP (x11, 2);
                  operands[2] = x18;
                  switch (pattern1668 (x3))
                    {
                    case 0:
                      if ((
#line 19221 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (CONST_INT_P (operands[2])
       ? (INTVAL (operands[2]) < GET_MODE_BITSIZE (SImode)
	  && INTVAL (operands[2])
	       >= (optimize_function_for_size_p (cfun) ? 8 : 32))
       : !memory_operand (operands[1], SImode))
   && ix86_pre_reload_split ()) && 
#line 19229 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_826 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 19221 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (CONST_INT_P (operands[2])
       ? (INTVAL (operands[2]) < GET_MODE_BITSIZE (DImode)
	  && INTVAL (operands[2])
	       >= (optimize_function_for_size_p (cfun) ? 8 : 32))
       : !memory_operand (operands[1], DImode))
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19229 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_827 (insn, operands);
                      break;

                    default:
                      break;
                    }
                  if (GET_CODE (x18) != SUBREG)
                    return NULL;
                  switch (pattern1670 (x3))
                    {
                    case 0:
                      if (!(
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_830 (insn, operands);

                    case 1:
                      if (!(
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_832 (insn, operands);

                    case 2:
                      if (!((
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_834 (insn, operands);

                    case 3:
                      if (!((
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_831 (insn, operands);

                    case 4:
                      if (!((
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_833 (insn, operands);

                    case 5:
                      if (!((
#line 19297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19302 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_835 (insn, operands);

                    default:
                      return NULL;
                    }

                case 1:
                  if (!(
#line 19260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 19265 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_828 (insn, operands);

                case 2:
                  if (!((
#line 19260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_USE_BT || optimize_function_for_size_p (cfun))
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19265 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_829 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case COMPARE:
          return split_23 (x1, insn);

        case AND:
          return split_21 (x1, insn);

        case IOR:
          return split_22 (x1, insn);

        case XOR:
          return split_20 (x1, insn);

        case NOT:
          x10 = XEXP (x3, 0);
          if (GET_CODE (x10) != XOR
              || pattern341 (x1) != 0)
            return NULL;
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              if (pattern1317 (x3, 
E_HImode) != 0
                  || !(
#line 13621 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)) && 
#line 13623 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_397 (insn, operands);

            case E_SImode:
              if (pattern1318 (x3, 
E_SImode) != 0
                  || !(
#line 13621 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)) && 
#line 13623 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_398 (insn, operands);

            case E_DImode:
              if (pattern1318 (x3, 
E_DImode) != 0
                  || !((
#line 13621 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13623 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_399 (insn, operands);

            case E_QImode:
              if (pattern1317 (x3, 
E_QImode) != 0
                  || !(
#line 13821 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)) && 
#line 13823 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_405 (insn, operands);

            default:
              return NULL;
            }

        case NEG:
          return split_27 (x1, insn);

        case ABS:
          return split_29 (x1, insn);

        case ASHIFT:
          return split_26 (x1, insn);

        case LSHIFTRT:
          return split_28 (x1, insn);

        case ASHIFTRT:
          return split_31 (x1, insn);

        case ROTATE:
          return split_33 (x1, insn);

        case ROTATERT:
          return split_32 (x1, insn);

        case CTZ:
          switch (pattern408 (x1))
            {
            case 0:
              if (!
#line 21095 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_BMI || TARGET_CPU_P (GENERIC))
   && (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
                return NULL;
              return gen_split_879 (insn, operands);

            case 1:
              if (!(
#line 21095 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_BMI || TARGET_CPU_P (GENERIC))
   && (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_880 (insn, operands);

            default:
              return NULL;
            }

        case SIGN_EXTEND:
          if (GET_MODE (x3) != E_DImode)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (pattern353 (x6) != 0)
            return NULL;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          if (!register_operand (operands[0], E_DImode))
            return NULL;
          x10 = XEXP (x3, 0);
          if (GET_MODE (x10) != E_SImode)
            return NULL;
          switch (GET_CODE (x10))
            {
            case CTZ:
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 21203 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_BMI || TARGET_CPU_P (GENERIC))
   && (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
                return NULL;
              return gen_split_882 (insn, operands);

            case XOR:
              x11 = XEXP (x10, 0);
              if (GET_CODE (x11) != MINUS
                  || GET_MODE (x11) != E_SImode)
                return NULL;
              x19 = XEXP (x11, 0);
              if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 31])
                return NULL;
              x17 = XEXP (x11, 1);
              if (GET_CODE (x17) != CLZ
                  || GET_MODE (x17) != E_SImode)
                return NULL;
              x13 = XEXP (x10, 1);
              if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 31])
                return NULL;
              x20 = XEXP (x17, 0);
              operands[1] = x20;
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !(
#line 21365 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 21367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_885 (insn, operands);

            default:
              return NULL;
            }

        case CLZ:
          switch (pattern408 (x1))
            {
            case 0:
              if (!(
#line 21536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 21538 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                return NULL;
              return gen_split_892 (insn, operands);

            case 1:
              if (!((
#line 21536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21538 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                return NULL;
              return gen_split_893 (insn, operands);

            default:
              return NULL;
            }

        case UNSPEC:
          if (XVECLEN (x3, 0) != 1)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (pattern231 (x6, 
E_CCmode, 
17) != 0)
            return NULL;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          x21 = XVECEXP (x3, 0, 0);
          operands[1] = x21;
          switch (XINT (x3, 1))
            {
            case 97:
              switch (pattern1326 (x3))
                {
                case 0:
                  if (!(
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 21700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_900 (insn, operands);

                case 1:
                  if (!((((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 21700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_902 (insn, operands);

                default:
                  return NULL;
                }

            case 96:
              switch (pattern1326 (x3))
                {
                case 0:
                  if (!(
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 21700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_901 (insn, operands);

                case 1:
                  if (!((((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 21700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_903 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case POPCOUNT:
          x6 = XVECEXP (x1, 0, 1);
          if (pattern353 (x6) != 0)
            return NULL;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          x10 = XEXP (x3, 0);
          switch (GET_CODE (x10))
            {
            case REG:
            case SUBREG:
            case MEM:
              operands[1] = x10;
              switch (pattern407 (x3))
                {
                case 0:
                  if (!(
#line 22343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 22351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_916 (insn, operands);

                case 1:
                  if (!((
#line 22343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 22351 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                    return NULL;
                  return gen_split_917 (insn, operands);

                default:
                  return NULL;
                }

            case ZERO_EXTEND:
              if (pattern1163 (x3, 
E_HImode, 
E_SImode) != 0
                  || !(
#line 22513 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()) && 
#line 22516 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_920 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case SIMPLE_RETURN:
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != USE)
        return NULL;
      x22 = XEXP (x6, 0);
      operands[0] = x22;
      if (!const_int_operand (operands[0], E_SImode)
          || !(
#line 20689 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 20691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( cfun->machine->function_return_type != indirect_branch_keep)))
        return NULL;
      return gen_split_874 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_69 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern529 (x2))
        {
        case 0:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1676 (insn, operands);

        case 1:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1703 (insn, operands);

        case 2:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1730 (insn, operands);

        case 3:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1757 (insn, operands);

        case 4:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1784 (insn, operands);

        case 5:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1811 (insn, operands);

        case 6:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1838 (insn, operands);

        case 7:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1865 (insn, operands);

        case 8:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1892 (insn, operands);

        case 9:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1919 (insn, operands);

        case 10:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1946 (insn, operands);

        case 11:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1973 (insn, operands);

        case 12:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1679 (insn, operands);

        case 13:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1706 (insn, operands);

        case 14:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1733 (insn, operands);

        case 15:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1760 (insn, operands);

        case 16:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1787 (insn, operands);

        case 17:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1814 (insn, operands);

        case 18:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1841 (insn, operands);

        case 19:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1868 (insn, operands);

        case 20:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1895 (insn, operands);

        case 21:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1922 (insn, operands);

        case 22:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1949 (insn, operands);

        case 23:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1976 (insn, operands);

        case 24:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1682 (insn, operands);

        case 25:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1709 (insn, operands);

        case 26:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1736 (insn, operands);

        case 27:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1763 (insn, operands);

        case 28:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1790 (insn, operands);

        case 29:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1817 (insn, operands);

        case 30:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1844 (insn, operands);

        case 31:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1871 (insn, operands);

        case 32:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1898 (insn, operands);

        case 33:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1925 (insn, operands);

        case 34:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1952 (insn, operands);

        case 35:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1979 (insn, operands);

        case 36:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2966 (insn, operands);

        case 37:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2975 (insn, operands);

        case 38:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2984 (insn, operands);

        case 39:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2993 (insn, operands);

        case 40:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3002 (insn, operands);

        case 41:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3011 (insn, operands);

        case 42:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3020 (insn, operands);

        case 43:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3029 (insn, operands);

        case 44:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3038 (insn, operands);

        case 45:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3047 (insn, operands);

        case 46:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3056 (insn, operands);

        case 47:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3065 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      switch (pattern531 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2324 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2351 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2378 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2405 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2432 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2459 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2486 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2513 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2540 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2567 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2594 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2621 (insn, operands);

        default:
          return NULL;
        }

    case IOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2327 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2354 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2381 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2408 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2435 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2462 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2489 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2516 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2543 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2570 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2597 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2624 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2330 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2357 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2384 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2411 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2438 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2465 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2492 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2519 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2546 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2573 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2600 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2627 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_77 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case VEC_SELECT:
      if (GET_MODE (x3) != E_DFmode)
        return NULL;
      x4 = XEXP (x3, 1);
      if (GET_CODE (x4) != PARALLEL
          || XVECLEN (x4, 0) != 1)
        return NULL;
      x5 = XVECEXP (x4, 0, 0);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !memory_operand (operands[0], E_V2DFmode)
          || GET_MODE (x2) != E_V2DFmode
          || !register_operand (operands[1], E_DFmode))
        return NULL;
      x6 = XEXP (x3, 0);
      if (!rtx_equal_p (x6, operands[0])
          || !
#line 14822 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed))
        return NULL;
      return gen_split_3182 (insn, operands);

    case UNSPEC:
      if (XVECLEN (x3, 0) != 1
          || XINT (x3, 1) != 147)
        return NULL;
      x7 = XVECEXP (x3, 0, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SImode:
          if (pattern1023 (x2, 
E_V4SImode, 
E_V8SImode) != 0
              || !(
#line 28815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 28817 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3773 (insn, operands);

        case E_V8SFmode:
          if (pattern1023 (x2, 
E_V4SFmode, 
E_V8SFmode) != 0
              || !(
#line 28815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 28817 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3774 (insn, operands);

        case E_V4DFmode:
          if (pattern1023 (x2, 
E_V2DFmode, 
E_V4DFmode) != 0
              || !(
#line 28815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 28817 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3775 (insn, operands);

        case E_V16SImode:
          if (pattern1023 (x2, 
E_V8SImode, 
E_V16SImode) != 0
              || !((
#line 30158 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 30160 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3821 (insn, operands);

        case E_V16SFmode:
          if (pattern1023 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
              || !((
#line 30158 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 30160 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3822 (insn, operands);

        case E_V8DFmode:
          if (pattern1023 (x2, 
E_V4DFmode, 
E_V8DFmode) != 0
              || !((
#line 30158 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 30160 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3823 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_80 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case AND:
      res = split_66 (x1, insn);
      if (res != NULL_RTX)
        return res;
      break;

    case IOR:
      res = split_73 (x1, insn);
      if (res != NULL_RTX)
        return res;
      break;

    case XOR:
      x3 = XEXP (x2, 0);
      switch (GET_CODE (x3))
        {
        case AND:
          res = split_68 (x1, insn);
          if (res != NULL_RTX)
            return res;
          break;

        case IOR:
          res = split_69 (x1, insn);
          if (res != NULL_RTX)
            return res;
          break;

        case XOR:
          x4 = XEXP (x3, 0);
          switch (GET_CODE (x4))
            {
            case REG:
            case SUBREG:
            case MEM:
            case NOT:
              switch (pattern529 (x2))
                {
                case 0:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1685 (insn, operands);
                  break;

                case 1:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1712 (insn, operands);
                  break;

                case 2:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1739 (insn, operands);
                  break;

                case 3:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1766 (insn, operands);
                  break;

                case 4:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1793 (insn, operands);
                  break;

                case 5:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1820 (insn, operands);
                  break;

                case 6:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1847 (insn, operands);
                  break;

                case 7:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1874 (insn, operands);
                  break;

                case 8:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1901 (insn, operands);
                  break;

                case 9:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1928 (insn, operands);
                  break;

                case 10:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1955 (insn, operands);
                  break;

                case 11:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1982 (insn, operands);
                  break;

                case 12:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1688 (insn, operands);
                  break;

                case 13:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1715 (insn, operands);
                  break;

                case 14:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1742 (insn, operands);
                  break;

                case 15:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1769 (insn, operands);
                  break;

                case 16:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1796 (insn, operands);
                  break;

                case 17:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1823 (insn, operands);
                  break;

                case 18:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1850 (insn, operands);
                  break;

                case 19:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1877 (insn, operands);
                  break;

                case 20:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1904 (insn, operands);
                  break;

                case 21:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1931 (insn, operands);
                  break;

                case 22:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1958 (insn, operands);
                  break;

                case 23:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1985 (insn, operands);
                  break;

                case 24:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1691 (insn, operands);
                  break;

                case 25:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1718 (insn, operands);
                  break;

                case 26:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1745 (insn, operands);
                  break;

                case 27:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1772 (insn, operands);
                  break;

                case 28:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1799 (insn, operands);
                  break;

                case 29:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1826 (insn, operands);
                  break;

                case 30:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1853 (insn, operands);
                  break;

                case 31:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1880 (insn, operands);
                  break;

                case 32:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1907 (insn, operands);
                  break;

                case 33:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1934 (insn, operands);
                  break;

                case 34:
                  if (((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1961 (insn, operands);
                  break;

                case 35:
                  if ((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1988 (insn, operands);
                  break;

                case 36:
                  if (((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2969 (insn, operands);
                  break;

                case 37:
                  if (((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2978 (insn, operands);
                  break;

                case 38:
                  if ((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2987 (insn, operands);
                  break;

                case 39:
                  if (((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2996 (insn, operands);
                  break;

                case 40:
                  if (((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3005 (insn, operands);
                  break;

                case 41:
                  if ((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3014 (insn, operands);
                  break;

                case 42:
                  if (((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3023 (insn, operands);
                  break;

                case 43:
                  if (((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3032 (insn, operands);
                  break;

                case 44:
                  if ((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3041 (insn, operands);
                  break;

                case 45:
                  if (((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3050 (insn, operands);
                  break;

                case 46:
                  if (((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3059 (insn, operands);
                  break;

                case 47:
                  if ((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3068 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case AND:
              switch (pattern531 (x2))
                {
                case 0:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2333 (insn, operands);
                  break;

                case 1:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2360 (insn, operands);
                  break;

                case 2:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2387 (insn, operands);
                  break;

                case 3:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2414 (insn, operands);
                  break;

                case 4:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2441 (insn, operands);
                  break;

                case 5:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2468 (insn, operands);
                  break;

                case 6:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2495 (insn, operands);
                  break;

                case 7:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2522 (insn, operands);
                  break;

                case 8:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2549 (insn, operands);
                  break;

                case 9:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2576 (insn, operands);
                  break;

                case 10:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2603 (insn, operands);
                  break;

                case 11:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2630 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case IOR:
              switch (pattern531 (x2))
                {
                case 0:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2336 (insn, operands);
                  break;

                case 1:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2363 (insn, operands);
                  break;

                case 2:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2390 (insn, operands);
                  break;

                case 3:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2417 (insn, operands);
                  break;

                case 4:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2444 (insn, operands);
                  break;

                case 5:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2471 (insn, operands);
                  break;

                case 6:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2498 (insn, operands);
                  break;

                case 7:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2525 (insn, operands);
                  break;

                case 8:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2552 (insn, operands);
                  break;

                case 9:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2579 (insn, operands);
                  break;

                case 10:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2606 (insn, operands);
                  break;

                case 11:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2633 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case XOR:
              switch (pattern531 (x2))
                {
                case 0:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2339 (insn, operands);
                  break;

                case 1:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2366 (insn, operands);
                  break;

                case 2:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2393 (insn, operands);
                  break;

                case 3:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2420 (insn, operands);
                  break;

                case 4:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2447 (insn, operands);
                  break;

                case 5:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2474 (insn, operands);
                  break;

                case 6:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2501 (insn, operands);
                  break;

                case 7:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2528 (insn, operands);
                  break;

                case 8:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2555 (insn, operands);
                  break;

                case 9:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2582 (insn, operands);
                  break;

                case 10:
                  if (((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2609 (insn, operands);
                  break;

                case 11:
                  if ((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_2636 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            default:
              break;
            }
          break;

        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          operands[1] = x3;
          x5 = XEXP (x2, 1);
          operands[2] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SImode:
              if (pattern923 (x2, 
E_V16SImode) == 0
                  && ((
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || SImode == SImode
       || SImode == DImode)) && 
#line 568 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3334 (insn, operands);
              break;

            case E_V8DImode:
              if (pattern923 (x2, 
E_V8DImode) == 0
                  && ((
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || DImode == SImode
       || DImode == DImode)) && 
#line 569 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3335 (insn, operands);
              break;

            case E_V64QImode:
              if (pattern923 (x2, 
E_V64QImode) == 0
                  && ((
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || QImode == SImode
       || QImode == DImode)) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3336 (insn, operands);
              break;

            case E_V32QImode:
              if (pattern923 (x2, 
E_V32QImode) == 0
                  && ((
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || QImode == SImode
       || QImode == DImode)) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3337 (insn, operands);
              break;

            case E_V16QImode:
              if (pattern923 (x2, 
E_V16QImode) == 0
                  && (
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || QImode == SImode
       || QImode == DImode)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3338 (insn, operands);
              break;

            case E_V32HImode:
              if (pattern923 (x2, 
E_V32HImode) == 0
                  && ((
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || HImode == SImode
       || HImode == DImode)) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3339 (insn, operands);
              break;

            case E_V16HImode:
              if (pattern923 (x2, 
E_V16HImode) == 0
                  && ((
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || HImode == SImode
       || HImode == DImode)) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3340 (insn, operands);
              break;

            case E_V8HImode:
              if (pattern923 (x2, 
E_V8HImode) == 0
                  && (
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || HImode == SImode
       || HImode == DImode)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3341 (insn, operands);
              break;

            case E_V8SImode:
              if (pattern923 (x2, 
E_V8SImode) == 0
                  && ((
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || SImode == SImode
       || SImode == DImode)) && 
#line 572 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3342 (insn, operands);
              break;

            case E_V4SImode:
              if (pattern923 (x2, 
E_V4SImode) == 0
                  && (
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || SImode == SImode
       || SImode == DImode)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3343 (insn, operands);
              break;

            case E_V4DImode:
              if (pattern923 (x2, 
E_V4DImode) == 0
                  && ((
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || DImode == SImode
       || DImode == DImode)) && 
#line 573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3344 (insn, operands);
              break;

            case E_V2DImode:
              if (pattern923 (x2, 
E_V2DImode) == 0
                  && (
#line 18344 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!false
       || DImode == SImode
       || DImode == DImode)) && 
#line 18355 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && !REG_P (operands[1]) && !false
   && optimize_insn_for_speed_p ())))
                return gen_split_3345 (insn, operands);
              break;

            default:
              break;
            }
          if (GET_CODE (x3) == VEC_DUPLICATE)
            {
              switch (pattern592 (x2))
                {
                case 0:
                  if ((
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(64 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 568 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                    return gen_split_3378 (insn, operands);
                  break;

                case 1:
                  if ((
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(64 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 569 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                    return gen_split_3379 (insn, operands);
                  break;

                case 2:
                  if ((
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(64 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return gen_split_3380 (insn, operands);
                  break;

                case 3:
                  if ((
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(32 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return gen_split_3381 (insn, operands);
                  break;

                case 4:
                  if (
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(16 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)))
                    return gen_split_3382 (insn, operands);
                  break;

                case 5:
                  if ((
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(64 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return gen_split_3383 (insn, operands);
                  break;

                case 6:
                  if ((
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(32 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return gen_split_3384 (insn, operands);
                  break;

                case 7:
                  if (
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(16 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)))
                    return gen_split_3385 (insn, operands);
                  break;

                case 8:
                  if ((
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(32 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 572 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return gen_split_3386 (insn, operands);
                  break;

                case 9:
                  if (
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(16 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)))
                    return gen_split_3387 (insn, operands);
                  break;

                case 10:
                  if ((
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(32 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return gen_split_3388 (insn, operands);
                  break;

                case 11:
                  if (
#line 18649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(16 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)))
                    return gen_split_3389 (insn, operands);
                  break;

                default:
                  break;
                }
            }
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  operands[1] = x2;
  switch (pattern195 ())
    {
    case 0:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1653 (insn, operands);
      break;

    case 1:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1654 (insn, operands);
      break;

    case 2:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1655 (insn, operands);
      break;

    case 3:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1656 (insn, operands);
      break;

    case 4:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1657 (insn, operands);
      break;

    case 5:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1658 (insn, operands);
      break;

    case 6:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1659 (insn, operands);
      break;

    case 7:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1660 (insn, operands);
      break;

    case 8:
      if ((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1661 (insn, operands);
      break;

    case 9:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1662 (insn, operands);
      break;

    case 10:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1663 (insn, operands);
      break;

    case 11:
      if (((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return gen_split_1664 (insn, operands);
      break;

    default:
      break;
    }
  switch (GET_CODE (x2))
    {
    case AND:
      return split_76 (x1, insn);

    case IOR:
      return split_75 (x1, insn);

    case XOR:
      return split_74 (x1, insn);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_32 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (REGNO (x2) != 17)
    return NULL;
  x3 = XEXP (x1, 1);
  operands[0] = x3;
  x4 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x4) != SET)
    return NULL;
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x6 = XEXP (x4, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[1]))
    {
    case E_QImode:
      if (!general_reg_operand (operands[1], E_QImode)
          || !
#line 27050 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(peep2_regno_dead_p (0, FLAGS_REG)
   && !reg_overlap_mentioned_p (operands[1], operands[0])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_213 (insn, operands);

    case E_HImode:
      if (!general_reg_operand (operands[1], E_HImode)
          || !
#line 27050 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(peep2_regno_dead_p (0, FLAGS_REG)
   && !reg_overlap_mentioned_p (operands[1], operands[0])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_214 (insn, operands);

    case E_SImode:
      if (!general_reg_operand (operands[1], E_SImode)
          || !
#line 27050 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(peep2_regno_dead_p (0, FLAGS_REG)
   && !reg_overlap_mentioned_p (operands[1], operands[0])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_215 (insn, operands);

    case E_DImode:
      if (!general_reg_operand (operands[1], E_DImode)
          || !(
#line 27050 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(peep2_regno_dead_p (0, FLAGS_REG)
   && !reg_overlap_mentioned_p (operands[1], operands[0])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_216 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_37 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case COMPARE:
      operands[1] = x2;
      if (!compare_operator (operands[1], E_VOIDmode))
        return NULL;
      x3 = XEXP (x2, 1);
      if (GET_CODE (x3) != CONST_INT
          || !flags_reg_operand (operands[0], E_VOIDmode))
        return NULL;
      x4 = XEXP (x2, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
          operands[2] = x4;
          if (memory_operand (operands[2], E_SImode)
              && XWINT (x3, 0) == 0L
              && 
#line 27871 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p () && ix86_match_ccmode (insn, CCNOmode)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_262 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (!register_operand (operands[2], E_VOIDmode))
            return NULL;
          operands[3] = x3;
          if (!const_int_operand (operands[3], E_VOIDmode)
              || !
#line 28774 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((((!TARGET_FUSE_CMP_AND_BRANCH || optimize_insn_for_size_p ())
     && incdec_operand (operands[3], GET_MODE (operands[3])))
    || (!TARGET_FUSE_CMP_AND_BRANCH
	&& INTVAL (operands[3]) == 128))
   && ix86_match_ccmode (insn, CCGCmode)
   && peep2_reg_dead_p (1, operands[2])))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_387 (insn, operands);

        case AND:
          if (XWINT (x3, 0) != 0L)
            return NULL;
          x5 = XEXP (x4, 0);
          operands[2] = x5;
          x6 = XEXP (x4, 1);
          operands[3] = x6;
          switch (GET_MODE (x4))
            {
            case E_SImode:
              if (register_operand (operands[2], E_SImode)
                  && immediate_operand (operands[3], E_SImode)
                  && 
#line 27913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)
   && (REGNO (operands[2]) != AX_REG
       || satisfies_constraint_K (operands[3]))
   && peep2_reg_dead_p (1, operands[2])))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_266 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              break;

            case E_QImode:
              if (register_operand (operands[2], E_QImode)
                  && immediate_operand (operands[3], E_QImode)
                  && 
#line 27933 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL
   && ix86_match_ccmode (insn, CCNOmode)
   && REGNO (operands[2]) != AX_REG
   && peep2_reg_dead_p (1, operands[2])))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_267 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              break;

            default:
              break;
            }
          if (GET_CODE (x5) != SUBREG
              || maybe_ne (SUBREG_BYTE (x5), 0)
              || GET_MODE (x5) != E_QImode)
            return NULL;
          x7 = XEXP (x5, 0);
          switch (GET_CODE (x7))
            {
            case SIGN_EXTRACT:
            case ZERO_EXTRACT:
              operands[4] = x7;
              x8 = XEXP (x7, 1);
              if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
                return NULL;
              x9 = XEXP (x7, 2);
              if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8]
                  || GET_MODE (x4) != E_QImode)
                return NULL;
              x10 = XEXP (x7, 0);
              operands[2] = x10;
              if (!int248_register_operand (operands[2], E_VOIDmode))
                return NULL;
              operands[3] = x6;
              if (!const_int_operand (operands[3], E_VOIDmode))
                return NULL;
              switch (GET_MODE (operands[4]))
                {
                case E_HImode:
                  if (!extract_operator (operands[4], E_HImode)
                      || !
#line 27955 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL
   && ix86_match_ccmode (insn, CCNOmode)
   && REGNO (operands[2]) != AX_REG
   && peep2_reg_dead_p (1, operands[2])))
                    return NULL;
                  *pmatch_len_ = 0;
                  return gen_peephole2_268 (insn, operands);

                case E_SImode:
                  if (!extract_operator (operands[4], E_SImode)
                      || !
#line 27955 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL
   && ix86_match_ccmode (insn, CCNOmode)
   && REGNO (operands[2]) != AX_REG
   && peep2_reg_dead_p (1, operands[2])))
                    return NULL;
                  *pmatch_len_ = 0;
                  return gen_peephole2_269 (insn, operands);

                case E_DImode:
                  if (!extract_operator (operands[4], E_DImode)
                      || !(
#line 27955 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL
   && ix86_match_ccmode (insn, CCNOmode)
   && REGNO (operands[2]) != AX_REG
   && peep2_reg_dead_p (1, operands[2])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return NULL;
                  *pmatch_len_ = 0;
                  return gen_peephole2_270 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case NOT:
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!nonimmediate_gr_operand (operands[0], E_QImode)
              || GET_MODE (x2) != E_QImode
              || !nonimmediate_gr_operand (operands[1], E_QImode)
              || !
#line 27889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((TARGET_NOT_UNPAIRABLE
	&& (!MEM_P (operands[0])
	    || !memory_displacement_operand (operands[0], QImode)))
       || (TARGET_NOT_VECTORMODE
	   && long_memory_operand (operands[0], QImode)))
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_263 (insn, operands);

        case E_HImode:
          if (!nonimmediate_gr_operand (operands[0], E_HImode)
              || GET_MODE (x2) != E_HImode
              || !nonimmediate_gr_operand (operands[1], E_HImode)
              || !
#line 27889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((TARGET_NOT_UNPAIRABLE
	&& (!MEM_P (operands[0])
	    || !memory_displacement_operand (operands[0], HImode)))
       || (TARGET_NOT_VECTORMODE
	   && long_memory_operand (operands[0], HImode)))
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_264 (insn, operands);

        case E_SImode:
          if (!nonimmediate_gr_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !nonimmediate_gr_operand (operands[1], E_SImode)
              || !
#line 27889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((TARGET_NOT_UNPAIRABLE
	&& (!MEM_P (operands[0])
	    || !memory_displacement_operand (operands[0], SImode)))
       || (TARGET_NOT_VECTORMODE
	   && long_memory_operand (operands[0], SImode)))
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_265 (insn, operands);

        default:
          return NULL;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      if (GET_CODE (x2) == CONST_INT)
        {
          res = peephole2_36 (x1, insn, pmatch_len_);
          if (res != NULL_RTX)
            return res;
        }
      if (peep2_current_count < 2
          || peep2_current_count < 3)
        return NULL;
      operands[1] = x2;
      x11 = PATTERN (peep2_next_insn (1));
      if (pattern595 (x11, 
4) != 0)
        return NULL;
      x12 = XVECEXP (x11, 0, 1);
      if (GET_CODE (x12) != SET)
        return NULL;
      x13 = XEXP (x12, 1);
      if (GET_CODE (x13) != UNSPEC_VOLATILE
          || XVECLEN (x13, 0) != 1)
        return NULL;
      x14 = XVECEXP (x13, 0, 0);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x15 = XVECEXP (x11, 0, 2);
      if (GET_CODE (x15) != SET)
        return NULL;
      x16 = XEXP (x15, 0);
      if (GET_CODE (x16) != REG
          || REGNO (x16) != 17)
        return NULL;
      x17 = XVECEXP (x11, 0, 0);
      x18 = XEXP (x17, 1);
      x19 = XVECEXP (x18, 0, 0);
      operands[2] = x19;
      x20 = XVECEXP (x18, 0, 2);
      operands[3] = x20;
      if (pattern1675 (x11) != 0)
        return NULL;
      x21 = PATTERN (peep2_next_insn (2));
      if (GET_CODE (x21) != SET)
        return NULL;
      x22 = XEXP (x21, 1);
      if (GET_CODE (x22) != COMPARE)
        return NULL;
      x23 = XEXP (x21, 0);
      if (GET_CODE (x23) != REG
          || REGNO (x23) != 17)
        return NULL;
      x24 = XEXP (x22, 0);
      operands[5] = x24;
      x25 = XEXP (x22, 1);
      operands[6] = x25;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || !general_operand (operands[1], E_HImode)
              || XINT (x18, 1) != 109
              || GET_MODE (x18) != E_HImode
              || pattern1845 (x11, 
E_HImode) != 0
              || !
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((rtx_equal_p (operands[0], operands[5])
    && rtx_equal_p (operands[1], operands[6]))
   || (rtx_equal_p (operands[0], operands[6])
       && rtx_equal_p (operands[1], operands[5]))))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_404 (insn, operands);

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x18) != E_SImode)
            return NULL;
          if (XINT (x18, 1) == 109
              && general_operand (operands[1], E_SImode)
              && pattern1845 (x11, 
E_SImode) == 0
              && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((rtx_equal_p (operands[0], operands[5])
    && rtx_equal_p (operands[1], operands[6]))
   || (rtx_equal_p (operands[0], operands[6])
       && rtx_equal_p (operands[1], operands[5]))))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_405 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (XINT (x18, 1) != 112
              || pattern1843 (x11, 
E_SImode) != 0)
            return NULL;
          if (
#line 1149 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_CMPCCXADD && TARGET_64BIT
   && rtx_equal_p (operands[0], operands[5])
   && rtx_equal_p (operands[1], operands[6])))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_423 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (peep2_current_count < 4)
            return NULL;
          x26 = PATTERN (peep2_next_insn (3));
          switch (pattern1865 (x26))
            {
            case 0:
              if (!
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_CMPCCXADD && TARGET_64BIT
   && rtx_equal_p (operands[0], operands[6])
   && rtx_equal_p (operands[1], operands[5])
   && peep2_regno_dead_p (4, FLAGS_REG)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_425 (insn, operands);

            case 1:
              if (!
#line 1249 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_CMPCCXADD && TARGET_64BIT
   && rtx_equal_p (operands[0], operands[6])
   && rtx_equal_p (operands[1], operands[5])
   && peep2_regno_dead_p (4, FLAGS_REG)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_427 (insn, operands);

            default:
              return NULL;
            }

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x18) != E_DImode)
            return NULL;
          if (XINT (x18, 1) == 109
              && general_operand (operands[1], E_DImode)
              && pattern1845 (x11, 
E_DImode) == 0
              && (
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
((rtx_equal_p (operands[0], operands[5])
    && rtx_equal_p (operands[1], operands[6]))
   || (rtx_equal_p (operands[0], operands[6])
       && rtx_equal_p (operands[1], operands[5]))) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_406 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (XINT (x18, 1) != 112
              || pattern1843 (x11, 
E_DImode) != 0)
            return NULL;
          if (
#line 1149 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_CMPCCXADD && TARGET_64BIT
   && rtx_equal_p (operands[0], operands[5])
   && rtx_equal_p (operands[1], operands[6])))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_424 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (peep2_current_count < 4)
            return NULL;
          x26 = PATTERN (peep2_next_insn (3));
          switch (pattern1865 (x26))
            {
            case 0:
              if (!
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_CMPCCXADD && TARGET_64BIT
   && rtx_equal_p (operands[0], operands[6])
   && rtx_equal_p (operands[1], operands[5])
   && peep2_regno_dead_p (4, FLAGS_REG)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_426 (insn, operands);

            case 1:
              if (!
#line 1249 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_CMPCCXADD && TARGET_64BIT
   && rtx_equal_p (operands[0], operands[6])
   && rtx_equal_p (operands[1], operands[5])
   && peep2_regno_dead_p (4, FLAGS_REG)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_428 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case PLUS:
      switch (pattern23 (x2))
        {
        case 0:
          x3 = XEXP (x2, 1);
          operands[1] = x3;
          if (x86_64_nonmemory_operand (operands[1], E_SImode))
            {
              x4 = XEXP (x2, 0);
              if (rtx_equal_p (x4, operands[0])
                  && 
#line 28554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_OPT_AGU
   && peep2_regno_dead_p (0, FLAGS_REG)))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_338 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x4 = XEXP (x2, 0);
          operands[1] = x4;
          if (!x86_64_nonmemory_operand (operands[1], E_SImode)
              || !rtx_equal_p (x3, operands[0])
              || !
#line 28563 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_OPT_AGU
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_340 (insn, operands);

        case 1:
          x3 = XEXP (x2, 1);
          operands[1] = x3;
          if (x86_64_nonmemory_operand (operands[1], E_DImode))
            {
              x4 = XEXP (x2, 0);
              if (rtx_equal_p (x4, operands[0])
                  && (
#line 28554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_OPT_AGU
   && peep2_regno_dead_p (0, FLAGS_REG)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_339 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x4 = XEXP (x2, 0);
          operands[1] = x4;
          if (!x86_64_nonmemory_operand (operands[1], E_DImode)
              || !rtx_equal_p (x3, operands[0])
              || !(
#line 28563 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_OPT_AGU
   && peep2_regno_dead_p (0, FLAGS_REG)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_341 (insn, operands);

        default:
          return NULL;
        }

    case ZERO_EXTEND:
      if (GET_MODE (x2) != E_DImode
          || !register_operand (operands[0], E_DImode))
        return NULL;
      x4 = XEXP (x2, 0);
      if (GET_MODE (x4) != E_SImode)
        return NULL;
      switch (GET_CODE (x4))
        {
        case PLUS:
          x5 = XEXP (x4, 0);
          operands[1] = x5;
          x6 = XEXP (x4, 1);
          operands[2] = x6;
          if (nonmemory_operand (operands[2], E_SImode)
              && register_operand (operands[1], E_SImode)
              && 
#line 28573 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && !TARGET_OPT_AGU
   && REGNO (operands[0]) == REGNO (operands[1])
   && peep2_regno_dead_p (0, FLAGS_REG)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_342 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (!register_operand (operands[2], E_SImode)
              || !nonmemory_operand (operands[1], E_SImode)
              || !
#line 28585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && !TARGET_OPT_AGU
   && REGNO (operands[0]) == REGNO (operands[2])
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_343 (insn, operands);

        case MULT:
          x5 = XEXP (x4, 0);
          operands[1] = x5;
          if (!register_operand (operands[1], E_SImode))
            return NULL;
          x6 = XEXP (x4, 1);
          operands[2] = x6;
          if (!const_int_operand (operands[2], E_SImode)
              || !
#line 28607 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && pow2p_hwi (INTVAL (operands[2]))
   && REGNO (operands[0]) == REGNO (operands[1])
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_346 (insn, operands);

        default:
          return NULL;
        }

    case MULT:
      x3 = XEXP (x2, 1);
      operands[1] = x3;
      x4 = XEXP (x2, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !const_int_operand (operands[1], E_SImode)
              || !
#line 28596 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(pow2p_hwi (INTVAL (operands[1]))
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_344 (insn, operands);

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !const_int_operand (operands[1], E_DImode)
              || !(
#line 28596 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(pow2p_hwi (INTVAL (operands[1]))
   && peep2_regno_dead_p (0, FLAGS_REG)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_345 (insn, operands);

        default:
          return NULL;
        }

    case VEC_CONCAT:
      if (peep2_current_count < 2
          || GET_MODE (x2) != E_V2DFmode
          || !sse_reg_operand (operands[0], E_V2DFmode))
        return NULL;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!memory_operand (operands[1], E_DFmode))
        return NULL;
      x3 = XEXP (x2, 1);
      operands[4] = x3;
      if (!const0_operand (operands[4], E_DFmode))
        return NULL;
      x11 = PATTERN (peep2_next_insn (1));
      if (GET_CODE (x11) != SET)
        return NULL;
      x27 = XEXP (x11, 1);
      if (GET_CODE (x27) != VEC_CONCAT
          || GET_MODE (x27) != E_V2DFmode)
        return NULL;
      x28 = XEXP (x27, 0);
      if (GET_CODE (x28) != VEC_SELECT
          || GET_MODE (x28) != E_DFmode)
        return NULL;
      x29 = XEXP (x28, 1);
      if (GET_CODE (x29) != PARALLEL
          || XVECLEN (x29, 0) != 1)
        return NULL;
      x30 = XVECEXP (x29, 0, 0);
      if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x31 = XEXP (x11, 0);
      operands[2] = x31;
      if (!sse_reg_operand (operands[2], E_V2DFmode))
        return NULL;
      x32 = XEXP (x27, 1);
      operands[3] = x32;
      if (!memory_operand (operands[3], E_DFmode))
        return NULL;
      x33 = XEXP (x28, 0);
      if (!rtx_equal_p (x33, operands[2])
          || !
#line 1955 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_SSE_UNALIGNED_LOAD_OPTIMAL
   && ix86_operands_ok_for_move_multiple (operands, true, DFmode)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_400 (insn, operands);

    default:
      return NULL;
    }
}
