/* do not edit automatically generated by mc from M2LangDump.  */
/* M2LangDump.def provides support routines for the -flang-dump.

Copyright (C) 2024-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaiusmod2@gmail.com>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2LangDump_H)
#   define _M2LangDump_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "Ggcctypes.h"
#   include "GDynamicStrings.h"
#   include "GFIO.h"

#   if defined (_M2LangDump_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   IsDumpRequiredTree - return TRUE if the gcc tree should be dumped.
                        If no filter is specified it will always return default.
*/

EXTERN bool M2LangDump_IsDumpRequiredTree (tree gcctree, bool default_);

/*
   IsDumpRequired - return TRUE if symbol sym should be dumped
                    according to the rules of the filter.
                    If no filter is specified it will always return default.
                    The filter is a comma separated list.  Each element
                    of the list can specify a symbol three ways.
                    Firstly by DECL name for example: m2pim_NumberIO_HexToStr
                    Secondly by qualified scope: [pathname.]NumberIO.HexToStr
                    Thirdly by filename and scope: NumberIO.mod:HexToStr
*/

EXTERN bool M2LangDump_IsDumpRequired (unsigned int sym, bool default_);

/*
   MakeQuadTemplate - return a template for the quad dump file.
*/

EXTERN DynamicStrings_String M2LangDump_MakeQuadTemplate (void);

/*
   MakeGimpleTemplate - return a template for the gimple dump file and assign
                        len to the max number of characters required to complete
                        a template.
*/

EXTERN DynamicStrings_String M2LangDump_MakeGimpleTemplate (unsigned int *len);

/*
   GetDumpFile - return the dump output file.
*/

EXTERN FIO_File M2LangDump_GetDumpFile (void);

/*
   CreateDumpQuad - create the dump file for a quad dump.
*/

EXTERN void M2LangDump_CreateDumpQuad (const char *title_, unsigned int _title_high);

/*
   CloseDumpQuad - close the dump output file.
*/

EXTERN void M2LangDump_CloseDumpQuad (void);

/*
   CreateDumpDecl - create the dump file for a decl dump.
*/

EXTERN void M2LangDump_CreateDumpDecl (const char *title_, unsigned int _title_high);

/*
   CloseDumpDecl - close the dump output file.
*/

EXTERN void M2LangDump_CloseDumpDecl (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
