/* do not edit automatically generated by mc from M2Batch.  */
/* M2Batch.def implements a queue for modules pending compilation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Batch_H)
#   define _M2Batch_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"
#   include "GNameKey.h"

#   if defined (_M2Batch_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

typedef struct M2Batch_DoProcedure_p M2Batch_DoProcedure;

typedef void (*M2Batch_DoProcedure_t) (unsigned int);
struct M2Batch_DoProcedure_p { M2Batch_DoProcedure_t proc; };


/*
   MakeDefinitionSource - is given a Name, n, which is used to create a Definition
                          module.
                          The Definition Module will be placed onto the
                          compilation pending queue if it has not yet been
                          compiled.
                          If the module has been compiled then no action is
                          taken. The Module Sym is returned.
*/

EXTERN unsigned int M2Batch_MakeDefinitionSource (unsigned int tok, NameKey_Name n);

/*
   MakeImplementationSource - is given a Name, n, which is used to create an
                              implementation module.
                              The implementation Module will be placed onto
                              the compilation pending
                              queue if it has not yet been compiled.
                              If the module has been compiled then no
                              action is taken. The Module Sym is returned.
*/

EXTERN unsigned int M2Batch_MakeImplementationSource (unsigned int tok, NameKey_Name n);

/*
   MakeProgramSource - is given a Name, n, which is used to create a program module.
                       The program module will be placed onto the compilation
                       pending queue if it has not yet been compiled.
                       If the module has been compiled then no action is taken.
                       The Module Sym is returned.
*/

EXTERN unsigned int M2Batch_MakeProgramSource (unsigned int tok, NameKey_Name n);

/*
   GetSource - returns with the symbol Sym of the next module to be compiled.
               If Sym returns with value NulSym then no module should be
               compiled.
*/

EXTERN unsigned int M2Batch_GetSource (void);

/*
   GetModuleNo - returns with symbol number of the module which was
                 the nth module to be read in Pass 1.
                 The modules are numbered from 1..n
*/

EXTERN unsigned int M2Batch_GetModuleNo (unsigned int nth);

/*
   IsModuleKnown - returns TRUE if the Name, n, matches a module.
*/

EXTERN bool M2Batch_IsModuleKnown (NameKey_Name n);

/*
   AssociateDefinition - associate the source file, filename, with the definition module,
                         Sym.
*/

EXTERN DynamicStrings_String M2Batch_AssociateDefinition (DynamicStrings_String filename, unsigned int Sym);

/*
   GetDefinitionModuleFile - returns the filename associated with the definition module, Sym.
                             It may return a temporary preprocessed file.
*/

EXTERN DynamicStrings_String M2Batch_GetDefinitionModuleFile (unsigned int Sym);

/*
   AssociateModule - associate the source file, filename, with the implementation/program
                     module, Sym.
*/

EXTERN DynamicStrings_String M2Batch_AssociateModule (DynamicStrings_String filename, unsigned int Sym);

/*
   GetModuleFile - returns the filename associated with the implementation/program module, Sym.
                   It may return a temporary preprocessed file.
*/

EXTERN DynamicStrings_String M2Batch_GetModuleFile (unsigned int Sym);

/*
   ForeachSourceModuleDo - call each procedure, p, for which there is a known
                           source file.
*/

EXTERN void M2Batch_ForeachSourceModuleDo (M2Batch_DoProcedure p);

/*
   IsSourceSeen - returns TRUE if the source for module, sym, has been seen.
*/

EXTERN bool M2Batch_IsSourceSeen (unsigned int sym);

/*
   IsModuleSeen - returns TRUE if the source for module, name, has been seen.
*/

EXTERN bool M2Batch_IsModuleSeen (NameKey_Name n);

/*
   LookupModule - looks up a module in the current scope, if a module does not exist
                  then it creates a DefImp module.
*/

EXTERN unsigned int M2Batch_LookupModule (unsigned int tok, NameKey_Name n);

/*
   LookupOuterModule - looks up a module in the order of: current scope, then outer scope, finally if a
                       module does not exist then it creates a DefImp module.
*/

EXTERN unsigned int M2Batch_LookupOuterModule (unsigned int tok, NameKey_Name n);

/*
   Get - returns the module symbol matching name, n.
*/

EXTERN unsigned int M2Batch_Get (NameKey_Name n);

/*
   DisplayModules - a debugging routine to textually emit the names of modules in the DoneQ.
*/

EXTERN void M2Batch_DisplayModules (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
