#ifdef __cplusplus
extern "C" {
#endif

typedef Boolean Flag;

#define N_Head 3

typedef struct Node_Header {
  any_slot Slots[N_Head];
  Field_Offset Offset;
} Node_Header;

extern Node_Header *Node_Offsets_Ptr;
extern any_slot *Slots_Ptr;

INLINE Boolean
Is_In_N_Alternative (Node_Kind kind);

INLINE Boolean
Is_In_N_Entity_Name (Node_Kind kind);

INLINE Boolean
Is_In_N_Has_Bounds (Node_Kind kind);

INLINE Boolean
Is_In_N_Has_Chars (Node_Kind kind);

INLINE Boolean
Is_In_N_Has_Condition (Node_Kind kind);

INLINE Boolean
Is_In_N_Is_Case_Choice (Node_Kind kind);

INLINE Boolean
Is_In_N_Is_Decl (Node_Kind kind);

INLINE Boolean
Is_In_N_Is_Exception_Choice (Node_Kind kind);

INLINE Boolean
Is_In_N_Is_Index (Node_Kind kind);

INLINE Boolean
Is_In_N_Is_Range (Node_Kind kind);

INLINE Boolean
Is_In_N_Lib_Unit_Declaration (Node_Kind kind);

INLINE Boolean
Is_In_N_Lib_Unit_Renaming_Declaration (Node_Kind kind);

enum Node_Kind : unsigned int {
  N_Unused_At_Start = 0,
  N_At_Clause = 1,
  N_Component_Clause = 2,
  N_Enumeration_Representation_Clause = 3,
  N_Mod_Clause = 4,
  N_Record_Representation_Clause = 5,
  N_Attribute_Definition_Clause = 6,
  N_Empty = 7,
  N_Pragma_Argument_Association = 8,
  N_Error = 9,
  N_Defining_Character_Literal = 10,
  N_Defining_Identifier = 11,
  N_Defining_Operator_Symbol = 12,
  N_Expanded_Name = 13,
  N_Identifier = 14,
  N_Operator_Symbol = 15,
  N_Character_Literal = 16,
  N_Op_Add = 17,
  N_Op_Concat = 18,
  N_Op_Expon = 19,
  N_Op_Subtract = 20,
  N_Op_Divide = 21,
  N_Op_Mod = 22,
  N_Op_Multiply = 23,
  N_Op_Rem = 24,
  N_Op_And = 25,
  N_Op_Eq = 26,
  N_Op_Ge = 27,
  N_Op_Gt = 28,
  N_Op_Le = 29,
  N_Op_Lt = 30,
  N_Op_Ne = 31,
  N_Op_Or = 32,
  N_Op_Xor = 33,
  N_Op_Rotate_Left = 34,
  N_Op_Rotate_Right = 35,
  N_Op_Shift_Left = 36,
  N_Op_Shift_Right = 37,
  N_Op_Shift_Right_Arithmetic = 38,
  N_Op_Abs = 39,
  N_Op_Minus = 40,
  N_Op_Not = 41,
  N_Op_Plus = 42,
  N_Attribute_Reference = 43,
  N_In = 44,
  N_Not_In = 45,
  N_And_Then = 46,
  N_Or_Else = 47,
  N_Function_Call = 48,
  N_Procedure_Call_Statement = 49,
  N_Raise_Constraint_Error = 50,
  N_Raise_Program_Error = 51,
  N_Raise_Storage_Error = 52,
  N_Integer_Literal = 53,
  N_Real_Literal = 54,
  N_String_Literal = 55,
  N_Interpolated_String_Literal = 56,
  N_Explicit_Dereference = 57,
  N_Expression_With_Actions = 58,
  N_External_Initializer = 59,
  N_If_Expression = 60,
  N_Indexed_Component = 61,
  N_Null = 62,
  N_Qualified_Expression = 63,
  N_Quantified_Expression = 64,
  N_Aggregate = 65,
  N_Allocator = 66,
  N_Case_Expression = 67,
  N_Delta_Aggregate = 68,
  N_Extension_Aggregate = 69,
  N_Raise_Expression = 70,
  N_Range = 71,
  N_Reference = 72,
  N_Selected_Component = 73,
  N_Slice = 74,
  N_Target_Name = 75,
  N_Type_Conversion = 76,
  N_Unchecked_Type_Conversion = 77,
  N_Subtype_Indication = 78,
  N_Component_Declaration = 79,
  N_Entry_Declaration = 80,
  N_Expression_Function = 81,
  N_Formal_Object_Declaration = 82,
  N_Formal_Type_Declaration = 83,
  N_Full_Type_Declaration = 84,
  N_Incomplete_Type_Declaration = 85,
  N_Iterator_Specification = 86,
  N_Loop_Parameter_Specification = 87,
  N_Object_Declaration = 88,
  N_Protected_Type_Declaration = 89,
  N_Private_Extension_Declaration = 90,
  N_Private_Type_Declaration = 91,
  N_Subtype_Declaration = 92,
  N_Function_Specification = 93,
  N_Procedure_Specification = 94,
  N_Exception_Declaration = 95,
  N_Formal_Package_Declaration = 96,
  N_Access_Function_Definition = 97,
  N_Access_Procedure_Definition = 98,
  N_Task_Type_Declaration = 99,
  N_Package_Body_Stub = 100,
  N_Protected_Body_Stub = 101,
  N_Subprogram_Body_Stub = 102,
  N_Task_Body_Stub = 103,
  N_Function_Instantiation = 104,
  N_Procedure_Instantiation = 105,
  N_Package_Instantiation = 106,
  N_Package_Body = 107,
  N_Subprogram_Body = 108,
  N_Protected_Body = 109,
  N_Task_Body = 110,
  N_Implicit_Label_Declaration = 111,
  N_Package_Declaration = 112,
  N_Single_Task_Declaration = 113,
  N_Subprogram_Declaration = 114,
  N_Use_Package_Clause = 115,
  N_Generic_Package_Declaration = 116,
  N_Generic_Subprogram_Declaration = 117,
  N_Constrained_Array_Definition = 118,
  N_Unconstrained_Array_Definition = 119,
  N_Exception_Renaming_Declaration = 120,
  N_Object_Renaming_Declaration = 121,
  N_Package_Renaming_Declaration = 122,
  N_Subprogram_Renaming_Declaration = 123,
  N_Generic_Function_Renaming_Declaration = 124,
  N_Generic_Package_Renaming_Declaration = 125,
  N_Generic_Procedure_Renaming_Declaration = 126,
  N_Abort_Statement = 127,
  N_Accept_Statement = 128,
  N_Assignment_Statement = 129,
  N_Asynchronous_Select = 130,
  N_Block_Statement = 131,
  N_Case_Statement = 132,
  N_Code_Statement = 133,
  N_Compound_Statement = 134,
  N_Conditional_Entry_Call = 135,
  N_Delay_Relative_Statement = 136,
  N_Delay_Until_Statement = 137,
  N_Entry_Call_Statement = 138,
  N_Free_Statement = 139,
  N_Goto_Statement = 140,
  N_Goto_When_Statement = 141,
  N_Loop_Statement = 142,
  N_Null_Statement = 143,
  N_Raise_Statement = 144,
  N_Raise_When_Statement = 145,
  N_Requeue_Statement = 146,
  N_Simple_Return_Statement = 147,
  N_Extended_Return_Statement = 148,
  N_Return_When_Statement = 149,
  N_Selective_Accept = 150,
  N_Timed_Entry_Call = 151,
  N_Exit_Statement = 152,
  N_If_Statement = 153,
  N_Accept_Alternative = 154,
  N_Delay_Alternative = 155,
  N_Elsif_Part = 156,
  N_Entry_Body_Formal_Part = 157,
  N_Iteration_Scheme = 158,
  N_Terminate_Alternative = 159,
  N_Formal_Abstract_Subprogram_Declaration = 160,
  N_Formal_Concrete_Subprogram_Declaration = 161,
  N_Push_Constraint_Error_Label = 162,
  N_Push_Program_Error_Label = 163,
  N_Push_Storage_Error_Label = 164,
  N_Pop_Constraint_Error_Label = 165,
  N_Pop_Program_Error_Label = 166,
  N_Pop_Storage_Error_Label = 167,
  N_SCIL_Dispatch_Table_Tag_Init = 168,
  N_SCIL_Dispatching_Call = 169,
  N_SCIL_Membership_Test = 170,
  N_Abortable_Part = 171,
  N_Abstract_Subprogram_Declaration = 172,
  N_Access_Definition = 173,
  N_Access_To_Object_Definition = 174,
  N_Aspect_Specification = 175,
  N_Call_Marker = 176,
  N_Case_Expression_Alternative = 177,
  N_Case_Statement_Alternative = 178,
  N_Compilation_Unit = 179,
  N_Compilation_Unit_Aux = 180,
  N_Component_Association = 181,
  N_Component_Definition = 182,
  N_Component_List = 183,
  N_Contract = 184,
  N_Derived_Type_Definition = 185,
  N_Decimal_Fixed_Point_Definition = 186,
  N_Defining_Program_Unit_Name = 187,
  N_Delta_Constraint = 188,
  N_Designator = 189,
  N_Digits_Constraint = 190,
  N_Discriminant_Association = 191,
  N_Discriminant_Specification = 192,
  N_Enumeration_Type_Definition = 193,
  N_Entry_Body = 194,
  N_Entry_Call_Alternative = 195,
  N_Entry_Index_Specification = 196,
  N_Exception_Handler = 197,
  N_Floating_Point_Definition = 198,
  N_Formal_Decimal_Fixed_Point_Definition = 199,
  N_Formal_Derived_Type_Definition = 200,
  N_Formal_Discrete_Type_Definition = 201,
  N_Formal_Floating_Point_Definition = 202,
  N_Formal_Modular_Type_Definition = 203,
  N_Formal_Ordinary_Fixed_Point_Definition = 204,
  N_Formal_Private_Type_Definition = 205,
  N_Formal_Incomplete_Type_Definition = 206,
  N_Formal_Signed_Integer_Type_Definition = 207,
  N_Freeze_Entity = 208,
  N_Freeze_Generic_Entity = 209,
  N_Generic_Association = 210,
  N_Handled_Sequence_Of_Statements = 211,
  N_Index_Or_Discriminant_Constraint = 212,
  N_Iterated_Component_Association = 213,
  N_Iterated_Element_Association = 214,
  N_Itype_Reference = 215,
  N_Label = 216,
  N_Modular_Type_Definition = 217,
  N_Number_Declaration = 218,
  N_Ordinary_Fixed_Point_Definition = 219,
  N_Others_Choice = 220,
  N_Package_Specification = 221,
  N_Parameter_Association = 222,
  N_Parameter_Specification = 223,
  N_Pragma = 224,
  N_Protected_Definition = 225,
  N_Range_Constraint = 226,
  N_Real_Range_Specification = 227,
  N_Record_Definition = 228,
  N_Signed_Integer_Type_Definition = 229,
  N_Single_Protected_Declaration = 230,
  N_Subunit = 231,
  N_Task_Definition = 232,
  N_Triggering_Alternative = 233,
  N_Use_Type_Clause = 234,
  N_Validate_Unchecked_Conversion = 235,
  N_Variable_Reference_Marker = 236,
  N_Variant = 237,
  N_Variant_Part = 238,
  N_With_Clause = 239,
  N_Unused_At_End = 240,
};
#define Number_Node_Kinds 241

SUBTYPE (N_Representation_Clause, Node_Kind,
   N_At_Clause,
   N_Attribute_Definition_Clause)
SUBTYPE (N_Has_Etype, Node_Kind,
   N_Error,
   N_Subtype_Indication)
SUBTYPE (N_Entity, N_Has_Etype,
   N_Defining_Character_Literal,
   N_Defining_Operator_Symbol)
SUBTYPE (N_Subexpr, N_Has_Etype,
   N_Expanded_Name,
   N_Unchecked_Type_Conversion)
SUBTYPE (N_Has_Entity, N_Subexpr,
   N_Expanded_Name,
   N_Attribute_Reference)
SUBTYPE (N_Direct_Name, N_Has_Entity,
   N_Identifier,
   N_Character_Literal)
SUBTYPE (N_Op, N_Has_Entity,
   N_Op_Add,
   N_Op_Plus)
SUBTYPE (N_Binary_Op, N_Op,
   N_Op_Add,
   N_Op_Shift_Right_Arithmetic)
SUBTYPE (N_Multiplying_Operator, N_Binary_Op,
   N_Op_Divide,
   N_Op_Rem)
SUBTYPE (N_Op_Boolean, N_Binary_Op,
   N_Op_And,
   N_Op_Xor)
SUBTYPE (N_Op_Compare, N_Op_Boolean,
   N_Op_Eq,
   N_Op_Ne)
SUBTYPE (N_Op_Shift, N_Binary_Op,
   N_Op_Rotate_Left,
   N_Op_Shift_Right_Arithmetic)
SUBTYPE (N_Unary_Op, N_Op,
   N_Op_Abs,
   N_Op_Plus)
SUBTYPE (N_Membership_Test, N_Subexpr,
   N_In,
   N_Not_In)
SUBTYPE (N_Short_Circuit, N_Subexpr,
   N_And_Then,
   N_Or_Else)
SUBTYPE (N_Subprogram_Call, N_Subexpr,
   N_Function_Call,
   N_Procedure_Call_Statement)
SUBTYPE (N_Raise_xxx_Error, N_Subexpr,
   N_Raise_Constraint_Error,
   N_Raise_Storage_Error)
SUBTYPE (N_Numeric_Or_String_Literal, N_Subexpr,
   N_Integer_Literal,
   N_Interpolated_String_Literal)
SUBTYPE (N_Declaration, Node_Kind,
   N_Component_Declaration,
   N_Formal_Package_Declaration)
SUBTYPE (N_Subprogram_Specification, N_Declaration,
   N_Function_Specification,
   N_Procedure_Specification)
SUBTYPE (N_Access_To_Subprogram_Definition, Node_Kind,
   N_Access_Function_Definition,
   N_Access_Procedure_Definition)
SUBTYPE (N_Later_Decl_Item, Node_Kind,
   N_Task_Type_Declaration,
   N_Generic_Subprogram_Declaration)
SUBTYPE (N_Body_Stub, N_Later_Decl_Item,
   N_Package_Body_Stub,
   N_Task_Body_Stub)
SUBTYPE (N_Generic_Instantiation, N_Later_Decl_Item,
   N_Function_Instantiation,
   N_Package_Instantiation)
SUBTYPE (N_Subprogram_Instantiation, N_Generic_Instantiation,
   N_Function_Instantiation,
   N_Procedure_Instantiation)
SUBTYPE (N_Proper_Body, N_Later_Decl_Item,
   N_Package_Body,
   N_Task_Body)
SUBTYPE (N_Lib_Unit_Body, N_Proper_Body,
   N_Package_Body,
   N_Subprogram_Body)
SUBTYPE (N_Generic_Declaration, N_Later_Decl_Item,
   N_Generic_Package_Declaration,
   N_Generic_Subprogram_Declaration)
SUBTYPE (N_Array_Type_Definition, Node_Kind,
   N_Constrained_Array_Definition,
   N_Unconstrained_Array_Definition)
SUBTYPE (N_Renaming_Declaration, Node_Kind,
   N_Exception_Renaming_Declaration,
   N_Generic_Procedure_Renaming_Declaration)
SUBTYPE (N_Generic_Renaming_Declaration, N_Renaming_Declaration,
   N_Generic_Function_Renaming_Declaration,
   N_Generic_Procedure_Renaming_Declaration)
SUBTYPE (N_Statement_Other_Than_Procedure_Call, Node_Kind,
   N_Abort_Statement,
   N_If_Statement)
SUBTYPE (N_Delay_Statement, N_Statement_Other_Than_Procedure_Call,
   N_Delay_Relative_Statement,
   N_Delay_Until_Statement)
SUBTYPE (N_Formal_Subprogram_Declaration, Node_Kind,
   N_Formal_Abstract_Subprogram_Declaration,
   N_Formal_Concrete_Subprogram_Declaration)
SUBTYPE (N_Push_Pop_xxx_Label, Node_Kind,
   N_Push_Constraint_Error_Label,
   N_Pop_Storage_Error_Label)
SUBTYPE (N_Push_xxx_Label, N_Push_Pop_xxx_Label,
   N_Push_Constraint_Error_Label,
   N_Push_Storage_Error_Label)
SUBTYPE (N_Pop_xxx_Label, N_Push_Pop_xxx_Label,
   N_Pop_Constraint_Error_Label,
   N_Pop_Storage_Error_Label)
SUBTYPE (N_SCIL_Node, Node_Kind,
   N_SCIL_Dispatch_Table_Tag_Init,
   N_SCIL_Membership_Test)

// Membership tests for union types

INLINE Boolean
Is_In_N_Alternative (Node_Kind kind)
{
   return
      kind == N_Case_Statement_Alternative ||
      kind == N_Variant;
}

INLINE Boolean
Is_In_N_Entity_Name (Node_Kind kind)
{
   return
      kind == N_Expanded_Name ||
      kind == N_Identifier ||
      kind == N_Operator_Symbol;
}

INLINE Boolean
Is_In_N_Has_Bounds (Node_Kind kind)
{
   return
      kind == N_Range ||
      kind == N_Real_Range_Specification ||
      kind == N_Signed_Integer_Type_Definition;
}

INLINE Boolean
Is_In_N_Has_Chars (Node_Kind kind)
{
   return
      kind == N_Attribute_Definition_Clause ||
      kind == N_Empty ||
      kind == N_Pragma_Argument_Association ||
      kind == N_Error ||
      IN (kind, N_Entity) ||
      kind == N_Expanded_Name ||
      kind == N_Identifier ||
      kind == N_Operator_Symbol ||
      kind == N_Character_Literal ||
      IN (kind, N_Op);
}

INLINE Boolean
Is_In_N_Has_Condition (Node_Kind kind)
{
   return
      kind == N_Exit_Statement ||
      kind == N_If_Statement ||
      kind == N_Accept_Alternative ||
      kind == N_Delay_Alternative ||
      kind == N_Elsif_Part ||
      kind == N_Entry_Body_Formal_Part ||
      kind == N_Iteration_Scheme ||
      kind == N_Terminate_Alternative;
}

INLINE Boolean
Is_In_N_Is_Case_Choice (Node_Kind kind)
{
   return
      Is_In_N_Is_Range (kind) ||
      kind == N_Others_Choice;
}

INLINE Boolean
Is_In_N_Is_Decl (Node_Kind kind)
{
   return
      kind == N_Aggregate ||
      kind == N_Block_Statement ||
      IN (kind, N_Declaration) ||
      kind == N_Discriminant_Specification ||
      kind == N_Entry_Index_Specification ||
      kind == N_Enumeration_Type_Definition ||
      kind == N_Exception_Handler ||
      kind == N_Explicit_Dereference ||
      kind == N_Expression_With_Actions ||
      kind == N_Extension_Aggregate ||
      kind == N_Identifier ||
      kind == N_Iterated_Component_Association ||
      IN (kind, N_Later_Decl_Item) ||
      kind == N_Loop_Statement ||
      kind == N_Null_Statement ||
      kind == N_Number_Declaration ||
      kind == N_Package_Specification ||
      kind == N_Parameter_Specification ||
      IN (kind, N_Renaming_Declaration) ||
      kind == N_Quantified_Expression;
}

INLINE Boolean
Is_In_N_Is_Exception_Choice (Node_Kind kind)
{
   return
      Is_In_N_Entity_Name (kind) ||
      kind == N_Others_Choice;
}

INLINE Boolean
Is_In_N_Is_Index (Node_Kind kind)
{
   return
      Is_In_N_Has_Bounds (kind) ||
      IN (kind, N_Has_Entity) ||
      kind == N_Subtype_Indication;
}

INLINE Boolean
Is_In_N_Is_Range (Node_Kind kind)
{
   return
      kind == N_Character_Literal ||
      Is_In_N_Entity_Name (kind) ||
      Is_In_N_Has_Bounds (kind) ||
      kind == N_Integer_Literal ||
      kind == N_Subtype_Indication;
}

INLINE Boolean
Is_In_N_Lib_Unit_Declaration (Node_Kind kind)
{
   return
      kind == N_Package_Declaration ||
      kind == N_Subprogram_Declaration ||
      IN (kind, N_Generic_Declaration) ||
      IN (kind, N_Generic_Instantiation);
}

INLINE Boolean
Is_In_N_Lib_Unit_Renaming_Declaration (Node_Kind kind)
{
   return
      kind == N_Package_Renaming_Declaration ||
      kind == N_Subprogram_Renaming_Declaration ||
      IN (kind, N_Generic_Renaming_Declaration);
}

// Getters corresponding to instantiations of Atree.Get_n_Bit_Field

// Getters for fields

INLINE Node_Kind Nkind (Node_Id N)
{
   const Field_Offset Off = 0;
   const Field_Offset F_Size = 8;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Node_Kind val = (Node_Kind) Raw;
   return val;
}

INLINE Source_Ptr Sloc (Node_Id N)
{
   const Field_Offset Off = 3;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Source_Ptr val = (Source_Ptr) Raw;
   return val;
}

INLINE Flag In_List (Node_Id N)
{
   const Field_Offset Off = 20;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Rewrite_Ins (Node_Id N)
{
   const Field_Offset Off = 21;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Comes_From_Source (Node_Id N)
{
   const Field_Offset Off = 22;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Analyzed (Node_Id N)
{
   const Field_Offset Off = 23;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Error_Posted (Node_Id N)
{
   const Field_Offset Off = 24;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Small_Paren_Count_Type Small_Paren_Count (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 2;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Small_Paren_Count_Type val = (Small_Paren_Count_Type) Raw;
   return val;
}

INLINE Flag Check_Actuals (Node_Id N)
{
   const Field_Offset Off = 25;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Ignored_Ghost_Node (Node_Id N)
{
   const Field_Offset Off = 28;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Union_Id Link (Node_Id N)
{
   const Field_Offset Off = 4;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Union_Id val = (Union_Id) Raw;
   return val;
}

INLINE Flag Abort_Present (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Abortable_Part (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Abstract_Present (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Accept_Handler_Records (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Accept_Statement (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Access_Definition (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Access_To_Subprogram_Definition (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Access_Types_To_Process (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE List_Id Actions (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Activation_Chain_Entity (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Acts_As_Spec (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Actual_Designated_Subtype (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Aggregate_Bounds_Or_Ancestor_Type (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Aliased_Present (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag All_Others (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag All_Present (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Alternatives (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Ancestor_Part (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Atomic_Sync_Required (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Array_Aggregate (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Aspect_On_Partial_View (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Aspect_Rep_Item (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Aspect_Specifications (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Elist_Id Aspect_Subprograms (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Flag Assignment_OK (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Name_Id Attribute_Name (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Name_Id val = (Name_Id) Raw;
   return val;
}

INLINE Node_Id At_End_Proc (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Aux_Decls_Node (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Backwards_OK (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Bad_Is_Detected (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Name_Id Binding_Chars (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Name_Id val = (Name_Id) Raw;
   return val;
}

INLINE Flag Body_Required (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Body_To_Inline (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Box_Present (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Cannot_Be_Superflat (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Unat Char_Literal_Value (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Unat val = (Unat) Raw;
   return val;
}

INLINE Name_Id Chars (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Name_Id val = (Name_Id) Raw;
   return val;
}

INLINE Flag Check_Address_Alignment (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Choice_Parameter (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Choices (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Class_Present (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Classifications (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Cleanup_Actions (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Comes_From_Check_Or_Contract (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Comes_From_Extended_Return_Statement (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Comes_From_Iterator (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Compare_Type (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Compile_Time_Known_Aggregate (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Component_Associations (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Component_Clauses (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Component_Definition (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Component_Items (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Component_List (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Component_Name (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Componentwise_Assignment (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Condition (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Condition_Actions (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Config_Pragmas (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Constant_Present (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Constraint (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Constraints (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Context_Installed (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Context_Items (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Context_Pending (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Contract_Test_Cases (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Controlling_Argument (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Conversion_OK (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Corresponding_Aspect (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Body (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Entry_Body (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Formal_Spec (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Generic_Association (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Valid_Uint Corresponding_Integer_Value (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Valid_Uint val = (Valid_Uint) Raw;
   return val;
}

INLINE Node_Id Corresponding_Spec (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Spec_Of_Stub (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Stub (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Dcheck_Function (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Declarations (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Default_Expression (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Default_Storage_Pool (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Default_Name (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Default_Subtype_Mark (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Defining_Identifier (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Defining_Unit_Name (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Delay_Alternative (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Delay_Statement (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Delta_Expression (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Digits_Expression (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Discr_Check_Funcs_Built (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Discrete_Choices (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Discrete_Range (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Discrete_Subtype_Definition (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Discrete_Subtype_Definitions (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Discriminant_Specifications (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Discriminant_Type (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Do_Discriminant_Check (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Do_Division_Check (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Do_Length_Check (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Do_Overflow_Check (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Do_Range_Check (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Do_Storage_Check (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Elaborate_All_Desirable (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Elaborate_All_Present (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Elaborate_Desirable (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Elaborate_Present (Node_Id N)
{
   const Field_Offset Off = 15;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Else_Actions (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Else_Statements (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Elsif_Parts (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Enclosing_Variant (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id End_Label (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Unat End_Span (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Unat val = (Unat) Raw;
   return val;
}

INLINE Node_Id Entity_Or_Associated_Node (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Body_Formal_Part (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Call_Alternative (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Call_Statement (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Direct_Name (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Index (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Index_Specification (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Etype (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Exception_Choices (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Exception_Handlers (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Exception_Junk (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Exception_Label (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Expansion_Delayed (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Explicit_Actual_Parameter (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Explicit_Generic_Actual_Parameter (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Expression (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Expression_Copy (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Expressions (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Source_File_Index File_Index (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Source_File_Index val = (Source_File_Index) Raw;
   return val;
}

INLINE List_Id Finally_Statements (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id First_Bit (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id First_Inlined_Subprogram (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag First_Name (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id First_Named_Actual (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id First_Subtype_Link (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Float_Truncate (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Formal_Type_Definition (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Forwards_OK (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag For_Allocator (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag For_Special_Return_Object (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag From_Aspect_Specification (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag From_At_Mod (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag From_Conditional_Expression (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag From_Default (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Generalized_Indexing (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Generic_Associations (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Generic_Formal_Declarations (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Generic_Parent (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Generic_Parent_Type (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Handled_Statement_Sequence (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Handler_List_Entry (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Has_Created_Identifier (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Dereference_Action (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Dynamic_Length_Check (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Init_Expression (Node_Id N)
{
   const Field_Offset Off = 15;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Local_Raise (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_No_Elaboration_Code (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Suppress_All (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Private_View (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Relative_Deadline_Pragma (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Secondary_Private_View (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Self_Reference (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_SP_Choice (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Storage_Size_Pragma (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Target_Names (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Wide_Character (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Wide_Wide_Character (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Header_Size_Added (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Elist_Id Hidden_By_Use_Clause (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id High_Bound (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Identifier (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Interface_List (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Interface_Present (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Import_Interface_Present (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag In_Present (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Includes_Infinities (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Incomplete_View (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Inherited_Discriminant (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Instance_Spec (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Valid_Uint Intval (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Valid_Uint val = (Valid_Uint) Raw;
   return val;
}

INLINE Flag Is_Abort_Block (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Accessibility_Actual (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Analyzed_Pragma (Node_Id N)
{
   const Field_Offset Off = 15;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Asynchronous_Call_Block (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Boolean_Aspect (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Checked (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Checked_Ghost_Pragma (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Component_Left_Opnd (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Component_Right_Opnd (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Controlling_Actual (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Declaration_Level_Node (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Delayed_Aspect (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Disabled (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Dispatching_Call (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Dynamic_Coextension (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Effective_Use_Clause (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Elaboration_Checks_OK_Node (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Elaboration_Code (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Elaboration_Warnings_OK_Node (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Elsif (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Entry_Barrier_Function (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Expanded_Build_In_Place_Call (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Expanded_Prefixed_Call (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Folded_In_Parser (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Generic_Contract_Pragma (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Homogeneous_Aggregate (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Parenthesis_Aggregate (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Ignored (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Ignored_Ghost_Pragma (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Implicit_With (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_In_Discriminant_Check (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Initialization_Block (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Interpolated_String_Literal (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Known_Guaranteed_ABE (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Machine_Number (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Null_Loop (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Overloaded (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Power_Of_2_For_Shift (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Preelaborable_Call (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Prefixed_Call (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Protected_Subprogram_Body (Node_Id N)
{
   const Field_Offset Off = 15;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Qualified_Universal_Literal (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Read (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Source_Call (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_SPARK_Mode_On_Node (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Static_Coextension (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Static_Expression (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Subprogram_Descriptor (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Task_Allocation_Block (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Task_Body_Procedure (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Task_Master (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Write (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Iterator_Filter (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Iteration_Scheme (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Iterator_Specification (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Itype (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Key_Expression (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Kill_Range_Check (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Last_Bit (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Last_Name (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Library_Unit (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Label_Construct (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Left_Opnd (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Limited_View_Installed (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Limited_Present (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Literals (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Local_Raise_Not_OK (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Elist_Id Local_Raise_Statements (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE List_Id Loop_Actions (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Loop_Parameter_Specification (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Low_Bound (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Mod_Clause (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag More_Ids (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Multidefined_Bindings (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Must_Be_Byte_Aligned (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Must_Not_Freeze (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Must_Not_Override (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Must_Override (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Name (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Names (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Next_Entity (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Next_Exit_Statement (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Next_Implicit_With (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Next_Named_Actual (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Next_Pragma (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Next_Rep_Item (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Next_Use_Clause (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag No_Ctrl_Actions (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Elaboration_Check (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Entities_Ref_In_Spec (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Finalize_Actions (Node_Id N)
{
   const Field_Offset Off = 15;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Initialization (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Minimize_Eliminate (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Truncation (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Null_Excluding_Subtype (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Null_Exclusion_Present (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Null_Exclusion_In_Return_Present (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Null_Present (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Null_Record_Present (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Null_Statement (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Object_Definition (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Of_Present (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Original_Discriminant (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Original_Entity (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Others_Discrete_Choices (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Out_Present (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Parameter_Associations (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Parameter_Specifications (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Parameter_Type (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Parent_Spec (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Parent_With (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Position (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Pragma_Argument_Associations (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Pragma_Identifier (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Pragmas_After (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Pragmas_Before (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Pre_Post_Conditions (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Prefix (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Premature_Use (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Uint Present_Expr (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Flag Prev_Ids (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Prev_Use_Clause (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Print_In_Hex (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Private_Declarations (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Private_Present (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Procedure_To_Call (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Proper_Body (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Protected_Definition (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Protected_Present (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Raises_Constraint_Error (Node_Id N)
{
   const Field_Offset Off = 15;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Range_Constraint (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Range_Expression (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Real_Range_Specification (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Ureal Realval (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Ureal val = (Ureal) Raw;
   return val;
}

INLINE Unat Reason (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Unat val = (Unat) Raw;
   return val;
}

INLINE Node_Id Record_Extension_Part (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Redundant_Use (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Renaming_Exception (Node_Id N)
{
   const Field_Offset Off = 6;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Result_Definition (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Return_Object_Declarations (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Return_Statement_Entity (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Reverse_Present (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Right_Opnd (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Rounded_Result (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Save_Invocation_Graph_Of_Body (Node_Id N)
{
   const Field_Offset Off = 14;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id SCIL_Controlling_Tag (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id SCIL_Entity (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id SCIL_Tag_Value (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id SCIL_Target_Prim (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Scope (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Select_Alternatives (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Selector_Name (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Selector_Names (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Shift_Count_OK (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Source_Type (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Specification (Node_Id N)
{
   const Field_Offset Off = 5;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Statements (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Storage_Pool (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Subpool_Handle_Name (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE String_Id Strval (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   String_Id val = (String_Id) Raw;
   return val;
}

INLINE Node_Id Subtype_Indication (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Subtype_Mark (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Subtype_Marks (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Suppress_Assignment_Checks (Node_Id N)
{
   const Field_Offset Off = 13;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Suppress_Loop_Warnings (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Synchronized_Present (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Tagged_Present (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Target (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Target_Type (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Task_Definition (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Task_Present (Node_Id N)
{
   const Field_Offset Off = 15;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE List_Id Then_Actions (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Then_Statements (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Triggering_Alternative (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Triggering_Statement (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id TSS_Elist (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Type_Definition (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Uneval_Old_Accept (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Uneval_Old_Warn (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Unit (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Unknown_Discriminants_Present (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Unreferenced_In_Spec (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Variant_Part (Node_Id N)
{
   const Field_Offset Off = 2;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Variants (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE List_Id Visible_Declarations (Node_Id N)
{
   const Field_Offset Off = 8;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Node_Id Uninitialized_Variable (Node_Id N)
{
   const Field_Offset Off = 7;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Used_Operations (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Flag Was_Attribute_Reference (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Was_Default_Init_Box_Association (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Was_Expression_Function (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Was_Originally_Stub (Node_Id N)
{
   const Field_Offset Off = 12;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

#ifdef __cplusplus
}
#endif
