// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	stderrors "errors"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// CgroupDumpMetadata cgroup full metadata
//
// swagger:model CgroupDumpMetadata
type CgroupDumpMetadata struct {

	// pod metadatas
	PodMetadatas []*CgroupPodMetadata `json:"pod-metadatas"`
}

// Validate validates this cgroup dump metadata
func (m *CgroupDumpMetadata) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePodMetadatas(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CgroupDumpMetadata) validatePodMetadatas(formats strfmt.Registry) error {
	if swag.IsZero(m.PodMetadatas) { // not required
		return nil
	}

	for i := 0; i < len(m.PodMetadatas); i++ {
		if swag.IsZero(m.PodMetadatas[i]) { // not required
			continue
		}

		if m.PodMetadatas[i] != nil {
			if err := m.PodMetadatas[i].Validate(formats); err != nil {
				ve := new(errors.Validation)
				if stderrors.As(err, &ve) {
					return ve.ValidateName("pod-metadatas" + "." + strconv.Itoa(i))
				}
				ce := new(errors.CompositeError)
				if stderrors.As(err, &ce) {
					return ce.ValidateName("pod-metadatas" + "." + strconv.Itoa(i))
				}

				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cgroup dump metadata based on the context it is used
func (m *CgroupDumpMetadata) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePodMetadatas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CgroupDumpMetadata) contextValidatePodMetadatas(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PodMetadatas); i++ {

		if m.PodMetadatas[i] != nil {

			if swag.IsZero(m.PodMetadatas[i]) { // not required
				return nil
			}

			if err := m.PodMetadatas[i].ContextValidate(ctx, formats); err != nil {
				ve := new(errors.Validation)
				if stderrors.As(err, &ve) {
					return ve.ValidateName("pod-metadatas" + "." + strconv.Itoa(i))
				}
				ce := new(errors.CompositeError)
				if stderrors.As(err, &ce) {
					return ce.ValidateName("pod-metadatas" + "." + strconv.Itoa(i))
				}

				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *CgroupDumpMetadata) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CgroupDumpMetadata) UnmarshalBinary(b []byte) error {
	var res CgroupDumpMetadata
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
