/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __BIOPATTERN_BPF_SKEL_H__
#define __BIOPATTERN_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct biopattern_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *counters;
		struct bpf_map *rodata;
	} maps;
	struct {
		struct bpf_program *handle__block_rq_complete;
	} progs;
	struct {
		struct bpf_link *handle__block_rq_complete;
	} links;
	struct biopattern_bpf__rodata {
		bool filter_dev;
		__u32 targ_dev;
	} *rodata;

#ifdef __cplusplus
	static inline struct biopattern_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct biopattern_bpf *open_and_load();
	static inline int load(struct biopattern_bpf *skel);
	static inline int attach(struct biopattern_bpf *skel);
	static inline void detach(struct biopattern_bpf *skel);
	static inline void destroy(struct biopattern_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
biopattern_bpf__destroy(struct biopattern_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
biopattern_bpf__create_skeleton(struct biopattern_bpf *obj);

static inline struct biopattern_bpf *
biopattern_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct biopattern_bpf *obj;
	int err;

	obj = (struct biopattern_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = biopattern_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	biopattern_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct biopattern_bpf *
biopattern_bpf__open(void)
{
	return biopattern_bpf__open_opts(NULL);
}

static inline int
biopattern_bpf__load(struct biopattern_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct biopattern_bpf *
biopattern_bpf__open_and_load(void)
{
	struct biopattern_bpf *obj;
	int err;

	obj = biopattern_bpf__open();
	if (!obj)
		return NULL;
	err = biopattern_bpf__load(obj);
	if (err) {
		biopattern_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
biopattern_bpf__attach(struct biopattern_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
biopattern_bpf__detach(struct biopattern_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *biopattern_bpf__elf_bytes(size_t *sz);

static inline int
biopattern_bpf__create_skeleton(struct biopattern_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "biopattern_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 2;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "counters";
	map->map = &obj->maps.counters;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "biopatte.rodata";
	map->map = &obj->maps.rodata;
	map->mmaped = (void **)&obj->rodata;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "handle__block_rq_complete";
	s->progs[0].prog = &obj->progs.handle__block_rq_complete;
	s->progs[0].link = &obj->links.handle__block_rq_complete;

	s->data = biopattern_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *biopattern_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x30\x11\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0e\0\
\x01\0\xbf\x16\0\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\
\xf0\xff\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x16\x01\x11\0\0\
\0\0\0\xb7\x01\0\0\x08\0\0\0\xbf\x63\0\0\0\0\0\0\x0f\x13\0\0\0\0\0\0\xbf\xa1\0\
\0\0\0\0\0\x07\x01\0\0\xe0\xff\xff\xff\xb4\x02\0\0\x08\0\0\0\x85\0\0\0\x71\0\0\
\0\xb7\x01\0\0\x10\0\0\0\xbf\x63\0\0\0\0\0\0\x0f\x13\0\0\0\0\0\0\x79\xa7\xe0\
\xff\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xe0\xff\xff\xff\xb4\x02\0\0\x04\0\
\0\0\x85\0\0\0\x71\0\0\0\xb7\x01\0\0\0\0\0\0\x05\0\x10\0\0\0\0\0\xb7\x01\0\0\
\x08\0\0\0\xbf\x63\0\0\0\0\0\0\x0f\x13\0\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\
\0\0\xe0\xff\xff\xff\xb4\x02\0\0\x08\0\0\0\x85\0\0\0\x71\0\0\0\xb7\x01\0\0\x10\
\0\0\0\xbf\x63\0\0\0\0\0\0\x0f\x13\0\0\0\0\0\0\x79\xa7\xe0\xff\0\0\0\0\xbf\xa1\
\0\0\0\0\0\0\x07\x01\0\0\xe0\xff\xff\xff\xb4\x02\0\0\x04\0\0\0\x85\0\0\0\x71\0\
\0\0\xb7\x01\0\0\0\0\0\0\x0f\x16\0\0\0\0\0\0\x61\xa8\xe0\xff\0\0\0\0\xbf\xa1\0\
\0\0\0\0\0\x07\x01\0\0\xe0\xff\xff\xff\xb4\x02\0\0\x04\0\0\0\xbf\x63\0\0\0\0\0\
\0\x85\0\0\0\x71\0\0\0\x61\xa1\xe0\xff\0\0\0\0\x63\x1a\xe0\xff\0\0\0\0\x18\x02\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x22\0\0\0\0\0\0\x56\x02\x04\0\x01\0\0\0\x18\
\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x22\0\0\0\0\0\0\x5e\x12\x24\0\0\0\0\0\xbf\
\xa2\0\0\0\0\0\0\x07\x02\0\0\xe0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x85\0\0\0\x01\0\0\0\x55\0\x10\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe0\
\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xe8\xff\xff\xff\x18\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\x01\0\0\0\x85\0\0\0\x02\0\0\0\x16\0\x01\0\0\0\0\
\0\x56\0\x14\0\xef\xff\xff\xff\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe0\xff\xff\xff\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x0e\0\0\0\0\0\
\x79\x02\0\0\0\0\0\0\x15\x02\x0a\0\0\0\0\0\xb7\x01\0\0\x10\0\0\0\x1d\x72\x01\0\
\0\0\0\0\xb7\x01\0\0\x14\0\0\0\xbf\x02\0\0\0\0\0\0\x0f\x12\0\0\0\0\0\0\xb4\x01\
\0\0\x01\0\0\0\xc3\x12\0\0\x01\0\0\0\xbc\x81\0\0\0\0\0\0\x64\x01\0\0\x09\0\0\0\
\xdb\x10\x08\0\x01\0\0\0\x0f\x87\0\0\0\0\0\0\x7b\x70\0\0\0\0\0\0\xb4\0\0\0\0\0\
\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x47\x50\x4c\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\0\x03\0\
\0\0\x03\0\0\x3c\x04\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\
\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x01\0\0\0\x05\0\
\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\0\0\0\0\0\0\0\
\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\x02\x08\0\0\0\x19\0\0\
\0\0\0\0\x08\x09\0\0\0\x1d\0\0\0\0\0\0\x08\x0a\0\0\0\x23\0\0\0\0\0\0\x01\x04\0\
\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x0c\0\0\0\x30\0\0\0\x04\0\0\x04\x18\0\0\0\x38\
\0\0\0\x0d\0\0\0\0\0\0\0\x44\0\0\0\x0d\0\0\0\x40\0\0\0\x4a\0\0\0\x09\0\0\0\x80\
\0\0\0\x55\0\0\0\x09\0\0\0\xa0\0\0\0\x5c\0\0\0\0\0\0\x08\x0e\0\0\0\x62\0\0\0\0\
\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x75\0\0\0\x01\0\0\0\
\0\0\0\0\x7a\0\0\0\x05\0\0\0\x40\0\0\0\x86\0\0\0\x07\0\0\0\x80\0\0\0\x8a\0\0\0\
\x0b\0\0\0\xc0\0\0\0\x90\0\0\0\0\0\0\x0e\x0f\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\
\0\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x99\0\0\0\x11\0\0\0\x9e\0\0\0\x01\0\0\
\x0c\x12\0\0\0\x5c\x01\0\0\x03\0\0\x04\x18\0\0\0\x84\x01\0\0\x15\0\0\0\0\0\0\0\
\x88\x01\0\0\x17\0\0\0\x40\0\0\0\x8f\x01\0\0\x0a\0\0\0\x80\0\0\0\x99\x01\0\0\0\
\0\0\x08\x16\0\0\0\x9f\x01\0\0\0\0\0\x08\x08\0\0\0\xae\x01\0\0\0\0\0\x08\x18\0\
\0\0\xb7\x01\0\0\0\0\0\x08\x0d\0\0\0\x3f\x02\0\0\x03\0\0\x04\x18\0\0\0\x84\x01\
\0\0\x15\0\0\0\0\0\0\0\x88\x01\0\0\x17\0\0\0\x40\0\0\0\x8f\x01\0\0\x0a\0\0\0\
\x80\0\0\0\0\0\0\0\0\0\0\x0a\x1b\0\0\0\0\0\0\0\0\0\0\x09\x1c\0\0\0\xfa\x03\0\0\
\0\0\0\x08\x1d\0\0\0\xff\x03\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x04\x05\x04\0\0\0\
\0\0\x0e\x1a\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x20\0\0\0\0\0\0\0\0\0\0\x09\x09\
\0\0\0\x10\x04\0\0\0\0\0\x0e\x1f\0\0\0\x01\0\0\0\x19\x04\0\0\0\0\0\x01\x01\0\0\
\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x22\0\0\0\x04\0\0\0\x04\0\0\0\x1e\x04\
\0\0\0\0\0\x0e\x23\0\0\0\x01\0\0\0\x26\x04\0\0\x01\0\0\x0f\0\0\0\0\x10\0\0\0\0\
\0\0\0\x20\0\0\0\x2c\x04\0\0\x02\0\0\x0f\0\0\0\0\x1e\0\0\0\0\0\0\0\x01\0\0\0\
\x21\0\0\0\0\0\0\0\x04\0\0\0\x34\x04\0\0\x01\0\0\x0f\0\0\0\0\x24\0\0\0\0\0\0\0\
\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\
\x54\x59\x50\x45\x5f\x5f\0\x75\x33\x32\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\x69\
\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x63\x6f\x75\x6e\x74\x65\x72\0\x6c\x61\x73\
\x74\x5f\x73\x65\x63\x74\x6f\x72\0\x62\x79\x74\x65\x73\0\x73\x65\x71\x75\x65\
\x6e\x74\x69\x61\x6c\0\x72\x61\x6e\x64\x6f\x6d\0\x5f\x5f\x75\x36\x34\0\x75\x6e\
\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x74\x79\x70\
\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x6b\x65\x79\0\x76\x61\x6c\
\x75\x65\0\x63\x6f\x75\x6e\x74\x65\x72\x73\0\x61\x72\x67\x73\0\x68\x61\x6e\x64\
\x6c\x65\x5f\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\x65\
\x74\x65\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x62\x6c\x6f\x63\x6b\x2f\
\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\x65\x74\x65\0\x2f\x62\
\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\
\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x62\x69\x6f\x70\x61\x74\x74\x65\
\x72\x6e\x2e\x62\x70\x66\x2e\x63\0\x69\x6e\x74\x20\x68\x61\x6e\x64\x6c\x65\x5f\
\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\x65\x74\x65\x28\
\x76\x6f\x69\x64\x20\x2a\x61\x72\x67\x73\x29\0\x09\x73\x74\x72\x75\x63\x74\x20\
\x63\x6f\x75\x6e\x74\x65\x72\x20\x2a\x63\x6f\x75\x6e\x74\x65\x72\x70\x2c\x20\
\x7a\x65\x72\x6f\x20\x3d\x20\x7b\x7d\x3b\0\x74\x72\x61\x63\x65\x5f\x65\x76\x65\
\x6e\x74\x5f\x72\x61\x77\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\
\x70\x6c\x65\x74\x69\x6f\x6e\x5f\x5f\x5f\x78\0\x64\x65\x76\0\x73\x65\x63\x74\
\x6f\x72\0\x6e\x72\x5f\x73\x65\x63\x74\x6f\x72\0\x64\x65\x76\x5f\x74\0\x5f\x5f\
\x6b\x65\x72\x6e\x65\x6c\x5f\x64\x65\x76\x5f\x74\0\x73\x65\x63\x74\x6f\x72\x5f\
\x74\0\x75\x36\x34\0\x30\0\x09\x69\x66\x20\x28\x68\x61\x73\x5f\x62\x6c\x6f\x63\
\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\x65\x74\x69\x6f\x6e\x28\x29\x29\x20\
\x7b\0\x30\x3a\x31\0\x09\x09\x73\x65\x63\x74\x6f\x72\x20\x3d\x20\x42\x50\x46\
\x5f\x43\x4f\x52\x45\x5f\x52\x45\x41\x44\x28\x63\x74\x78\x2c\x20\x73\x65\x63\
\x74\x6f\x72\x29\x3b\0\x30\x3a\x32\0\x09\x09\x6e\x72\x5f\x73\x65\x63\x74\x6f\
\x72\x20\x3d\x20\x42\x50\x46\x5f\x43\x4f\x52\x45\x5f\x52\x45\x41\x44\x28\x63\
\x74\x78\x2c\x20\x6e\x72\x5f\x73\x65\x63\x74\x6f\x72\x29\x3b\0\x30\x3a\x30\0\
\x74\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x5f\x72\x61\x77\x5f\x62\x6c\x6f\
\x63\x6b\x5f\x72\x71\x5f\x63\x6f\x6d\x70\x6c\x65\x74\x65\x5f\x5f\x5f\x78\0\x09\
\x69\x66\x20\x28\x66\x69\x6c\x74\x65\x72\x5f\x64\x65\x76\x20\x26\x26\x20\x74\
\x61\x72\x67\x5f\x64\x65\x76\x20\x21\x3d\x20\x64\x65\x76\x29\0\x2f\x62\x75\x69\
\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\
\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x2e\x2f\x6d\x61\x70\x73\x2e\x62\x70\x66\
\x2e\x68\0\x09\x76\x61\x6c\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\
\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\x29\
\x3b\0\x09\x69\x66\x20\x28\x76\x61\x6c\x29\0\x09\x65\x72\x72\x20\x3d\x20\x62\
\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\
\x6d\x61\x70\x2c\x20\x6b\x65\x79\x2c\x20\x69\x6e\x69\x74\x2c\x20\x42\x50\x46\
\x5f\x4e\x4f\x45\x58\x49\x53\x54\x29\x3b\0\x09\x69\x66\x20\x28\x65\x72\x72\x20\
\x26\x26\x20\x65\x72\x72\x20\x21\x3d\x20\x2d\x45\x45\x58\x49\x53\x54\x29\0\x09\
\x72\x65\x74\x75\x72\x6e\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\
\x75\x70\x5f\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\x29\x3b\0\x09\
\x69\x66\x20\x28\x21\x63\x6f\x75\x6e\x74\x65\x72\x70\x29\0\x09\x69\x66\x20\x28\
\x63\x6f\x75\x6e\x74\x65\x72\x70\x2d\x3e\x6c\x61\x73\x74\x5f\x73\x65\x63\x74\
\x6f\x72\x29\x20\x7b\0\x09\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\
\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\x63\x6f\x75\x6e\x74\x65\x72\x70\x2d\
\x3e\x62\x79\x74\x65\x73\x2c\x20\x6e\x72\x5f\x73\x65\x63\x74\x6f\x72\x20\x2a\
\x20\x35\x31\x32\x29\x3b\0\x09\x63\x6f\x75\x6e\x74\x65\x72\x70\x2d\x3e\x6c\x61\
\x73\x74\x5f\x73\x65\x63\x74\x6f\x72\x20\x3d\x20\x73\x65\x63\x74\x6f\x72\x20\
\x2b\x20\x6e\x72\x5f\x73\x65\x63\x74\x6f\x72\x3b\0\x7d\0\x62\x6f\x6f\x6c\0\x5f\
\x42\x6f\x6f\x6c\0\x66\x69\x6c\x74\x65\x72\x5f\x64\x65\x76\0\x74\x61\x72\x67\
\x5f\x64\x65\x76\0\x63\x68\x61\x72\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x6d\x61\
\x70\x73\0\x2e\x72\x6f\x64\x61\x74\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\x9f\xeb\
\x01\0\x20\0\0\0\0\0\0\0\x14\0\0\0\x14\0\0\0\xac\x01\0\0\xc0\x01\0\0\x7c\0\0\0\
\x08\0\0\0\xb8\0\0\0\x01\0\0\0\0\0\0\0\x13\0\0\0\x10\0\0\0\xb8\0\0\0\x1a\0\0\0\
\0\0\0\0\xdb\0\0\0\x0c\x01\0\0\0\x54\0\0\x10\0\0\0\xdb\0\0\0\x36\x01\0\0\x1c\
\x5c\0\0\x30\0\0\0\xdb\0\0\0\xbd\x01\0\0\x06\x70\0\0\x60\0\0\0\xdb\0\0\0\xe3\
\x01\0\0\x0c\x78\0\0\x88\0\0\0\xdb\0\0\0\xe3\x01\0\0\x0c\x78\0\0\xa0\0\0\0\xdb\
\0\0\0\x0e\x02\0\0\x0f\x7c\0\0\xe8\0\0\0\xdb\0\0\0\xe3\x01\0\0\x0c\x8c\0\0\x10\
\x01\0\0\xdb\0\0\0\xe3\x01\0\0\x0c\x8c\0\0\x28\x01\0\0\xdb\0\0\0\x0e\x02\0\0\
\x0f\x90\0\0\x88\x01\0\0\xdb\0\0\0\x65\x02\0\0\x06\xa0\0\0\xa0\x01\0\0\xdb\0\0\
\0\x65\x02\0\0\x11\xa0\0\0\xa8\x01\0\0\xdb\0\0\0\x65\x02\0\0\x14\xa0\0\0\xc0\
\x01\0\0\xdb\0\0\0\x65\x02\0\0\x11\xa0\0\0\xd8\x01\0\0\x89\x02\0\0\xb6\x02\0\0\
\x08\x7c\0\0\xf0\x01\0\0\x89\x02\0\0\xdc\x02\0\0\x06\x80\0\0\x18\x02\0\0\x89\
\x02\0\0\xe6\x02\0\0\x08\x8c\0\0\x38\x02\0\0\x89\x02\0\0\x1f\x03\0\0\x0a\x90\0\
\0\x58\x02\0\0\x89\x02\0\0\x3b\x03\0\0\x09\x9c\0\0\x70\x02\0\0\xdb\0\0\0\x62\
\x03\0\0\x06\xb0\0\0\x78\x02\0\0\xdb\0\0\0\x72\x03\0\0\x10\xb8\0\0\x80\x02\0\0\
\xdb\0\0\0\x72\x03\0\0\x06\xb8\0\0\xc0\x02\0\0\xdb\0\0\0\x90\x03\0\0\x34\xcc\0\
\0\xd0\x02\0\0\xdb\0\0\0\x90\x03\0\0\x03\xcc\0\0\xd8\x02\0\0\xdb\0\0\0\xcb\x03\
\0\0\x21\xd4\0\0\xe0\x02\0\0\xdb\0\0\0\xcb\x03\0\0\x18\xd4\0\0\xe8\x02\0\0\xdb\
\0\0\0\xf8\x03\0\0\x01\xdc\0\0\x10\0\0\0\xb8\0\0\0\x07\0\0\0\x28\0\0\0\x14\0\0\
\0\xbb\x01\0\0\x08\0\0\0\x38\0\0\0\x14\0\0\0\xdf\x01\0\0\0\0\0\0\x70\0\0\0\x14\
\0\0\0\x0a\x02\0\0\0\0\0\0\xb0\0\0\0\x14\0\0\0\x3b\x02\0\0\0\0\0\0\xc0\0\0\0\
\x19\0\0\0\xdf\x01\0\0\0\0\0\0\xf8\0\0\0\x19\0\0\0\x0a\x02\0\0\0\0\0\0\x38\x01\
\0\0\x19\0\0\0\x3b\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x45\0\0\0\x12\
\0\x03\0\0\0\0\0\0\0\0\0\xf8\x02\0\0\0\0\0\0\x01\0\0\0\x11\0\x05\0\0\0\0\0\0\0\
\0\0\x01\0\0\0\0\0\0\0\x0c\0\0\0\x11\0\x05\0\x04\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\
\0\x28\0\0\0\x11\0\x06\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\xaf\0\0\0\x11\0\x07\
\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x88\x01\0\0\0\0\0\0\x01\0\0\0\x03\0\0\0\
\xa8\x01\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\xd8\x01\0\0\0\0\0\0\x01\0\0\0\x05\0\0\
\0\x18\x02\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\x58\x02\0\0\0\0\0\0\x01\0\0\0\x05\0\
\0\0\xd4\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\xec\x02\0\0\0\0\0\0\x03\0\0\0\x03\
\0\0\0\xf8\x02\0\0\0\0\0\0\x03\0\0\0\x04\0\0\0\x10\x03\0\0\0\0\0\0\x04\0\0\0\
\x06\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x50\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x70\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x90\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xb0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xd0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xf0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x10\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\x30\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x40\x01\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\x50\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x60\x01\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\x70\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x80\x01\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x90\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\x01\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\xb0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\x01\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\xd0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xec\x01\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\xfc\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x0c\x02\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\x1c\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x2c\x02\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x3c\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x4c\x02\
\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x0b\x0c\x0d\x0e\x0f\0\x66\x69\x6c\x74\x65\x72\
\x5f\x64\x65\x76\0\x74\x61\x72\x67\x5f\x64\x65\x76\0\x2e\x74\x65\x78\x74\0\x2e\
\x72\x65\x6c\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x63\x6f\x75\x6e\x74\x65\x72\x73\
\0\x2e\x6d\x61\x70\x73\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\
\x68\x61\x6e\x64\x6c\x65\x5f\x5f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\
\x6d\x70\x6c\x65\x74\x65\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\
\x74\x2f\x62\x6c\x6f\x63\x6b\x2f\x62\x6c\x6f\x63\x6b\x5f\x72\x71\x5f\x63\x6f\
\x6d\x70\x6c\x65\x74\x65\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x73\x74\x72\x74\
\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x6f\x64\x61\x74\x61\0\x2e\x72\
\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x8e\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x75\x10\0\0\0\0\0\0\xb7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x15\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x63\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\xf8\
\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x5f\0\0\0\
\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc0\x0d\0\0\0\0\0\0\x50\0\0\0\0\0\
\0\0\x0d\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x9e\0\0\0\x01\0\0\
\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x38\x03\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x31\0\0\0\x01\0\0\0\x03\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x40\x03\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x86\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x60\x03\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xaa\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x64\
\x03\0\0\0\0\0\0\x54\x07\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\xa6\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x10\x0e\0\0\0\0\
\0\0\x40\0\0\0\0\0\0\0\x0d\0\0\0\x08\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x1f\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb8\x0a\0\0\0\0\0\0\x5c\
\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x1b\0\0\0\
\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x0e\0\0\0\0\0\0\x20\x02\0\0\0\
\0\0\0\x0d\0\0\0\x0a\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x37\0\0\0\x03\
\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\x70\x10\0\0\0\0\0\0\x05\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x96\0\0\0\x02\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x0d\0\0\0\0\0\0\xa8\0\0\0\0\0\0\0\x01\0\0\0\
\x02\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct biopattern_bpf *biopattern_bpf::open(const struct bpf_object_open_opts *opts) { return biopattern_bpf__open_opts(opts); }
struct biopattern_bpf *biopattern_bpf::open_and_load() { return biopattern_bpf__open_and_load(); }
int biopattern_bpf::load(struct biopattern_bpf *skel) { return biopattern_bpf__load(skel); }
int biopattern_bpf::attach(struct biopattern_bpf *skel) { return biopattern_bpf__attach(skel); }
void biopattern_bpf::detach(struct biopattern_bpf *skel) { biopattern_bpf__detach(skel); }
void biopattern_bpf::destroy(struct biopattern_bpf *skel) { biopattern_bpf__destroy(skel); }
const void *biopattern_bpf::elf_bytes(size_t *sz) { return biopattern_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
biopattern_bpf__assert(struct biopattern_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->filter_dev) == 1, "unexpected size of 'filter_dev'");
	_Static_assert(sizeof(s->rodata->targ_dev) == 4, "unexpected size of 'targ_dev'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __BIOPATTERN_BPF_SKEL_H__ */
