/* Autogenerated file, do not edit */
/*
 * Copyright 2024 Collabora Ltd.
 * SPDX-License-Identifier: MIT
 */

#ifndef PAN_PACK_H
#define PAN_PACK_H

#include "genxml/pan_pack_helpers.h"


#define mali_pixel_format_print(fp, format) \
    fprintf(fp, "%*sFormat (v7): %s%s %s%s\n", indent, "", \
        mali_format_as_str((enum mali_format)((format >> 12) & 0xFF)), \
        (format & (1 << 20)) ? " sRGB" : "", \
        mali_rgb_component_order_as_str((enum mali_rgb_component_order)(format & ((1 << 12) - 1))), \
        (format & (1 << 21)) ? " XXX BAD BIT" : "");

enum mali_attribute_type {
        MALI_ATTRIBUTE_TYPE_1D               =      1,
        MALI_ATTRIBUTE_TYPE_1D_POT_DIVISOR   =      2,
        MALI_ATTRIBUTE_TYPE_1D_NPOT_DIVISOR  =      3,
        MALI_ATTRIBUTE_TYPE_1D_PRIMITIVE_INDEX_BUFFER =      5,
        MALI_ATTRIBUTE_TYPE_VERTEX_PACKET    =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_attribute_type_as_str(enum mali_attribute_type imm)
{
    switch (imm) {
    case MALI_ATTRIBUTE_TYPE_1D: return "1D";
    case MALI_ATTRIBUTE_TYPE_1D_POT_DIVISOR: return "1D POT Divisor";
    case MALI_ATTRIBUTE_TYPE_1D_NPOT_DIVISOR: return "1D NPOT Divisor";
    case MALI_ATTRIBUTE_TYPE_1D_PRIMITIVE_INDEX_BUFFER: return "1D Primitive Index Buffer";
    case MALI_ATTRIBUTE_TYPE_VERTEX_PACKET: return "Vertex packet";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_channel {
        MALI_CHANNEL_R                       =      0,
        MALI_CHANNEL_G                       =      1,
        MALI_CHANNEL_B                       =      2,
        MALI_CHANNEL_A                       =      3,
        MALI_CHANNEL_0                       =      4,
        MALI_CHANNEL_1                       =      5,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_channel_as_str(enum mali_channel imm)
{
    switch (imm) {
    case MALI_CHANNEL_R: return "R";
    case MALI_CHANNEL_G: return "G";
    case MALI_CHANNEL_B: return "B";
    case MALI_CHANNEL_A: return "A";
    case MALI_CHANNEL_0: return "0";
    case MALI_CHANNEL_1: return "1";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_depth_source {
        MALI_DEPTH_SOURCE_MINIMUM            =      0,
        MALI_DEPTH_SOURCE_MAXIMUM            =      1,
        MALI_DEPTH_SOURCE_FIXED_FUNCTION     =      2,
        MALI_DEPTH_SOURCE_SHADER             =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_depth_source_as_str(enum mali_depth_source imm)
{
    switch (imm) {
    case MALI_DEPTH_SOURCE_MINIMUM: return "Minimum";
    case MALI_DEPTH_SOURCE_MAXIMUM: return "Maximum";
    case MALI_DEPTH_SOURCE_FIXED_FUNCTION: return "Fixed function";
    case MALI_DEPTH_SOURCE_SHADER: return "Shader";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_depth_clamp_mode {
        MALI_DEPTH_CLAMP_MODE_0_1            =      1,
        MALI_DEPTH_CLAMP_MODE_BOUNDS         =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_depth_clamp_mode_as_str(enum mali_depth_clamp_mode imm)
{
    switch (imm) {
    case MALI_DEPTH_CLAMP_MODE_0_1: return "[0, 1]";
    case MALI_DEPTH_CLAMP_MODE_BOUNDS: return "Bounds";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_job_type {
        MALI_JOB_TYPE_NOT_STARTED            =      0,
        MALI_JOB_TYPE_NULL                   =      1,
        MALI_JOB_TYPE_WRITE_VALUE            =      2,
        MALI_JOB_TYPE_CACHE_FLUSH            =      3,
        MALI_JOB_TYPE_COMPUTE                =      4,
        MALI_JOB_TYPE_TILER                  =      7,
        MALI_JOB_TYPE_FRAGMENT               =      9,
        MALI_JOB_TYPE_INDEXED_VERTEX         =     10,
        MALI_JOB_TYPE_MALLOC_VERTEX          =     11,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_job_type_as_str(enum mali_job_type imm)
{
    switch (imm) {
    case MALI_JOB_TYPE_NOT_STARTED: return "Not started";
    case MALI_JOB_TYPE_NULL: return "Null";
    case MALI_JOB_TYPE_WRITE_VALUE: return "Write value";
    case MALI_JOB_TYPE_CACHE_FLUSH: return "Cache flush";
    case MALI_JOB_TYPE_COMPUTE: return "Compute";
    case MALI_JOB_TYPE_TILER: return "Tiler";
    case MALI_JOB_TYPE_FRAGMENT: return "Fragment";
    case MALI_JOB_TYPE_INDEXED_VERTEX: return "Indexed vertex";
    case MALI_JOB_TYPE_MALLOC_VERTEX: return "Malloc vertex";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_shader_stage {
        MALI_SHADER_STAGE_COMPUTE            =      1,
        MALI_SHADER_STAGE_FRAGMENT           =      2,
        MALI_SHADER_STAGE_VERTEX             =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_shader_stage_as_str(enum mali_shader_stage imm)
{
    switch (imm) {
    case MALI_SHADER_STAGE_COMPUTE: return "Compute";
    case MALI_SHADER_STAGE_FRAGMENT: return "Fragment";
    case MALI_SHADER_STAGE_VERTEX: return "Vertex";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_descriptor_type {
        MALI_DESCRIPTOR_TYPE_NULL            =      0,
        MALI_DESCRIPTOR_TYPE_SAMPLER         =      1,
        MALI_DESCRIPTOR_TYPE_TEXTURE         =      2,
        MALI_DESCRIPTOR_TYPE_ATTRIBUTE       =      5,
        MALI_DESCRIPTOR_TYPE_DEPTH_STENCIL   =      7,
        MALI_DESCRIPTOR_TYPE_SHADER          =      8,
        MALI_DESCRIPTOR_TYPE_BUFFER          =      9,
        MALI_DESCRIPTOR_TYPE_PLANE           =     10,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_descriptor_type_as_str(enum mali_descriptor_type imm)
{
    switch (imm) {
    case MALI_DESCRIPTOR_TYPE_NULL: return "Null";
    case MALI_DESCRIPTOR_TYPE_SAMPLER: return "Sampler";
    case MALI_DESCRIPTOR_TYPE_TEXTURE: return "Texture";
    case MALI_DESCRIPTOR_TYPE_ATTRIBUTE: return "Attribute";
    case MALI_DESCRIPTOR_TYPE_DEPTH_STENCIL: return "Depth/stencil";
    case MALI_DESCRIPTOR_TYPE_SHADER: return "Shader";
    case MALI_DESCRIPTOR_TYPE_BUFFER: return "Buffer";
    case MALI_DESCRIPTOR_TYPE_PLANE: return "Plane";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_buffer_type {
        MALI_BUFFER_TYPE_SIMPLE              =      1,
        MALI_BUFFER_TYPE_TILER_HEAP          =      2,
        MALI_BUFFER_TYPE_STRUCTURE           =      3,
        MALI_BUFFER_TYPE_VERTEX_PACKET       =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_buffer_type_as_str(enum mali_buffer_type imm)
{
    switch (imm) {
    case MALI_BUFFER_TYPE_SIMPLE: return "Simple";
    case MALI_BUFFER_TYPE_TILER_HEAP: return "Tiler heap";
    case MALI_BUFFER_TYPE_STRUCTURE: return "Structure";
    case MALI_BUFFER_TYPE_VERTEX_PACKET: return "Vertex packet";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_draw_mode {
        MALI_DRAW_MODE_NONE                  =      0,
        MALI_DRAW_MODE_POINTS                =      1,
        MALI_DRAW_MODE_LINES                 =      2,
        MALI_DRAW_MODE_LINE_STRIP            =      4,
        MALI_DRAW_MODE_LINE_LOOP             =      6,
        MALI_DRAW_MODE_TRIANGLES             =      8,
        MALI_DRAW_MODE_TRIANGLE_STRIP        =     10,
        MALI_DRAW_MODE_TRIANGLE_FAN          =     12,
        MALI_DRAW_MODE_POLYGON               =     13,
        MALI_DRAW_MODE_QUADS                 =     14,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_draw_mode_as_str(enum mali_draw_mode imm)
{
    switch (imm) {
    case MALI_DRAW_MODE_NONE: return "None";
    case MALI_DRAW_MODE_POINTS: return "Points";
    case MALI_DRAW_MODE_LINES: return "Lines";
    case MALI_DRAW_MODE_LINE_STRIP: return "Line strip";
    case MALI_DRAW_MODE_LINE_LOOP: return "Line loop";
    case MALI_DRAW_MODE_TRIANGLES: return "Triangles";
    case MALI_DRAW_MODE_TRIANGLE_STRIP: return "Triangle strip";
    case MALI_DRAW_MODE_TRIANGLE_FAN: return "Triangle fan";
    case MALI_DRAW_MODE_POLYGON: return "Polygon";
    case MALI_DRAW_MODE_QUADS: return "Quads";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_exception_access {
        MALI_EXCEPTION_ACCESS_NONE           =      0,
        MALI_EXCEPTION_ACCESS_EXECUTE        =      2,
        MALI_EXCEPTION_ACCESS_READ           =      1,
        MALI_EXCEPTION_ACCESS_WRITE          =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_exception_access_as_str(enum mali_exception_access imm)
{
    switch (imm) {
    case MALI_EXCEPTION_ACCESS_NONE: return "None";
    case MALI_EXCEPTION_ACCESS_EXECUTE: return "Execute";
    case MALI_EXCEPTION_ACCESS_READ: return "Read";
    case MALI_EXCEPTION_ACCESS_WRITE: return "Write";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_func {
        MALI_FUNC_NEVER                      =      0,
        MALI_FUNC_LESS                       =      1,
        MALI_FUNC_EQUAL                      =      2,
        MALI_FUNC_LEQUAL                     =      3,
        MALI_FUNC_GREATER                    =      4,
        MALI_FUNC_NOT_EQUAL                  =      5,
        MALI_FUNC_GEQUAL                     =      6,
        MALI_FUNC_ALWAYS                     =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_func_as_str(enum mali_func imm)
{
    switch (imm) {
    case MALI_FUNC_NEVER: return "Never";
    case MALI_FUNC_LESS: return "Less";
    case MALI_FUNC_EQUAL: return "Equal";
    case MALI_FUNC_LEQUAL: return "Lequal";
    case MALI_FUNC_GREATER: return "Greater";
    case MALI_FUNC_NOT_EQUAL: return "Not Equal";
    case MALI_FUNC_GEQUAL: return "Gequal";
    case MALI_FUNC_ALWAYS: return "Always";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_address_mode {
        MALI_ADDRESS_MODE_FLAT               =      0,
        MALI_ADDRESS_MODE_PACKED             =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_address_mode_as_str(enum mali_address_mode imm)
{
    switch (imm) {
    case MALI_ADDRESS_MODE_FLAT: return "Flat";
    case MALI_ADDRESS_MODE_PACKED: return "Packed";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_format {
        MALI_ETC2_RGB8                       =      1,
        MALI_ETC2_R11_UNORM                  =      2,
        MALI_ETC2_RGBA8                      =      3,
        MALI_ETC2_RG11_UNORM                 =      4,
        MALI_BC1_UNORM                       =      7,
        MALI_BC2_UNORM                       =      8,
        MALI_BC3_UNORM                       =      9,
        MALI_BC4_UNORM                       =     10,
        MALI_BC4_SNORM                       =     11,
        MALI_BC5_UNORM                       =     12,
        MALI_BC5_SNORM                       =     13,
        MALI_BC6H_UF16                       =     14,
        MALI_BC6H_SF16                       =     15,
        MALI_BC7_UNORM                       =     16,
        MALI_ETC2_R11_SNORM                  =     17,
        MALI_ETC2_RG11_SNORM                 =     18,
        MALI_ETC2_RGB8A1                     =     19,
        MALI_ASTC_3D_LDR                     =     20,
        MALI_ASTC_3D_HDR                     =     21,
        MALI_ASTC_2D_LDR                     =     22,
        MALI_ASTC_2D_HDR                     =     23,
        MALI_ASTC_2D_NARROW                  =     62,
        MALI_ASTC_3D_NARROW                  =     63,
        MALI_YUV8                            =     32,
        MALI_YUVA8                           =     33,
        MALI_YUYV8                           =     34,
        MALI_VYUY8                           =     35,
        MALI_Y8_UV8_422                      =     36,
        MALI_Y8_U8_V8_422                    =     37,
        MALI_Y8_UV8_420                      =     38,
        MALI_Y8_U8_V8_420                    =     39,
        MALI_YUV10_A2                        =     40,
        MALI_A2_YUV10                        =     41,
        MALI_YUYAAYVYAA                      =     42,
        MALI_YUYV10                          =     44,
        MALI_VYUY10                          =     45,
        MALI_Y10_UV10_422                    =     46,
        MALI_Y10_UV10_420                    =     47,
        MALI_YUV16                           =     48,
        MALI_YUVA16                          =     49,
        MALI_YUYV16                          =     50,
        MALI_VYUY16                          =     51,
        MALI_Y10X6_U10X6V10X6_422            =     52,
        MALI_Y16_UV16_422                    =     53,
        MALI_Y16_UV16_420                    =     55,
        MALI_RGB565                          =     64,
        MALI_RGB5_A1_UNORM                   =     65,
        MALI_A1_BGR5_UNORM                   =     66,
        MALI_RGB10_A2_UNORM                  =     67,
        MALI_A2_BGR10_UNORM                  =     68,
        MALI_RGB10_A2_SNORM                  =     69,
        MALI_A2_BGR10_SNORM                  =     70,
        MALI_RGB10_A2UI                      =     71,
        MALI_A2_BGR10UI                      =     72,
        MALI_RGB10_A2I                       =     73,
        MALI_A2_BGR10I                       =     74,
        MALI_Z16_UNORM                       =     75,
        MALI_Z32                             =     76,
        MALI_Z24X8_UNORM                     =     77,
        MALI_X8Z24                           =     78,
        MALI_R32_FIXED                       =     81,
        MALI_RG32_FIXED                      =     82,
        MALI_RGB32_FIXED                     =     83,
        MALI_RGBA32_FIXED                    =     84,
        MALI_R11F_G11F_B10F                  =     89,
        MALI_B10F_G11F_R11F                  =     90,
        MALI_R9F_G9F_B9F_E5F                 =     91,
        MALI_E5F_B9F_G9F_R9F                 =     92,
        MALI_S8                              =     93,
        MALI_SNAP_4                          =     94,
        MALI_CONSTANT                        =     95,
        MALI_R8_SNORM                        =     99,
        MALI_R16_SNORM                       =    100,
        MALI_R32_SNORM                       =    101,
        MALI_RG4_SNORM                       =    106,
        MALI_RG8_SNORM                       =    107,
        MALI_RG16_SNORM                      =    108,
        MALI_RG32_SNORM                      =    109,
        MALI_RGB8_SNORM                      =    115,
        MALI_RGB16_SNORM                     =    116,
        MALI_RGB32_SNORM                     =    117,
        MALI_RGBA2_SNORM                     =    121,
        MALI_RGBA4_SNORM                     =    122,
        MALI_RGBA8_SNORM                     =    123,
        MALI_RGBA16_SNORM                    =    124,
        MALI_RGBA32_SNORM                    =    125,
        MALI_R8UI                            =    131,
        MALI_R16UI                           =    132,
        MALI_R32UI                           =    133,
        MALI_RG4UI                           =    138,
        MALI_RG8UI                           =    139,
        MALI_RG16UI                          =    140,
        MALI_RG32UI                          =    141,
        MALI_RGB8UI                          =    147,
        MALI_RGB16UI                         =    148,
        MALI_RGB32UI                         =    149,
        MALI_RGBA2UI                         =    153,
        MALI_RGBA4UI                         =    154,
        MALI_RGBA8UI                         =    155,
        MALI_RGBA16UI                        =    156,
        MALI_RGBA32UI                        =    157,
        MALI_R8_UNORM                        =    163,
        MALI_R16_UNORM                       =    164,
        MALI_R32_UNORM                       =    165,
        MALI_R32F                            =    167,
        MALI_RG4_UNORM                       =    170,
        MALI_RG8_UNORM                       =    171,
        MALI_RG16_UNORM                      =    172,
        MALI_RG32_UNORM                      =    173,
        MALI_RG32F                           =    175,
        MALI_RGB8_UNORM                      =    179,
        MALI_RGB16_UNORM                     =    180,
        MALI_RGB32_UNORM                     =    181,
        MALI_RGB32F                          =    183,
        MALI_RGBA2_UNORM                     =    185,
        MALI_RGBA4_UNORM                     =    186,
        MALI_RGBA8_UNORM                     =    187,
        MALI_RGBA16_UNORM                    =    188,
        MALI_RGBA32_UNORM                    =    189,
        MALI_RGBA32F                         =    191,
        MALI_R8I                             =    195,
        MALI_R16I                            =    196,
        MALI_R32I                            =    197,
        MALI_R16F                            =    199,
        MALI_RG4I                            =    202,
        MALI_RG8I                            =    203,
        MALI_RG16I                           =    204,
        MALI_RG32I                           =    205,
        MALI_RG16F                           =    207,
        MALI_RGB8I                           =    211,
        MALI_RGB16I                          =    212,
        MALI_RGB32I                          =    213,
        MALI_RGB16F                          =    215,
        MALI_RGBA2I                          =    217,
        MALI_RGBA4I                          =    218,
        MALI_RGBA8I                          =    219,
        MALI_RGBA16I                         =    220,
        MALI_RGBA32I                         =    221,
        MALI_RGBA16F                         =    223,
        MALI_RGB5_A1_AU                      =    224,
        MALI_RGB5_A1_PU                      =    225,
        MALI_R5G6B5_AU                       =    226,
        MALI_R5G6B5_PU                       =    227,
        MALI_SNAP4_V                         =    230,
        MALI_R32F_RTZ                        =    231,
        MALI_RGBA4_AU                        =    232,
        MALI_RGBA4_PU                        =    233,
        MALI_RGBA8_TB                        =    237,
        MALI_RGB10_A2_TB                     =    238,
        MALI_RG32F_RTZ                       =    239,
        MALI_TESS_VERTEX_PACK                =    240,
        MALI_RGB8_A2_AU                      =    241,
        MALI_RGB8_A2_PU                      =    242,
        MALI_RGB32F_RTZ                      =    247,
        MALI_RGBA32F_RTZ                     =    255,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_format_as_str(enum mali_format imm)
{
    switch (imm) {
    case MALI_ETC2_RGB8: return "ETC2 RGB8";
    case MALI_ETC2_R11_UNORM: return "ETC2 R11 UNORM";
    case MALI_ETC2_RGBA8: return "ETC2 RGBA8";
    case MALI_ETC2_RG11_UNORM: return "ETC2 RG11 UNORM";
    case MALI_BC1_UNORM: return "BC1 UNORM";
    case MALI_BC2_UNORM: return "BC2 UNORM";
    case MALI_BC3_UNORM: return "BC3 UNORM";
    case MALI_BC4_UNORM: return "BC4 UNORM";
    case MALI_BC4_SNORM: return "BC4 SNORM";
    case MALI_BC5_UNORM: return "BC5 UNORM";
    case MALI_BC5_SNORM: return "BC5 SNORM";
    case MALI_BC6H_UF16: return "BC6H UF16";
    case MALI_BC6H_SF16: return "BC6H SF16";
    case MALI_BC7_UNORM: return "BC7 UNORM";
    case MALI_ETC2_R11_SNORM: return "ETC2 R11 SNORM";
    case MALI_ETC2_RG11_SNORM: return "ETC2 RG11 SNORM";
    case MALI_ETC2_RGB8A1: return "ETC2 RGB8A1";
    case MALI_ASTC_3D_LDR: return "ASTC 3D LDR";
    case MALI_ASTC_3D_HDR: return "ASTC 3D HDR";
    case MALI_ASTC_2D_LDR: return "ASTC 2D LDR";
    case MALI_ASTC_2D_HDR: return "ASTC 2D HDR";
    case MALI_ASTC_2D_NARROW: return "ASTC 2D NARROW";
    case MALI_ASTC_3D_NARROW: return "ASTC 3D NARROW";
    case MALI_YUV8: return "YUV8";
    case MALI_YUVA8: return "YUVA8";
    case MALI_YUYV8: return "YUYV8";
    case MALI_VYUY8: return "VYUY8";
    case MALI_Y8_UV8_422: return "Y8 UV8 422";
    case MALI_Y8_U8_V8_422: return "Y8 U8 V8 422";
    case MALI_Y8_UV8_420: return "Y8 UV8 420";
    case MALI_Y8_U8_V8_420: return "Y8 U8 V8 420";
    case MALI_YUV10_A2: return "YUV10 A2";
    case MALI_A2_YUV10: return "A2 YUV10";
    case MALI_YUYAAYVYAA: return "YUYAAYVYAA";
    case MALI_YUYV10: return "YUYV10";
    case MALI_VYUY10: return "VYUY10";
    case MALI_Y10_UV10_422: return "Y10 UV10 422";
    case MALI_Y10_UV10_420: return "Y10 UV10 420";
    case MALI_YUV16: return "YUV16";
    case MALI_YUVA16: return "YUVA16";
    case MALI_YUYV16: return "YUYV16";
    case MALI_VYUY16: return "VYUY16";
    case MALI_Y10X6_U10X6V10X6_422: return "Y10X6 U10X6V10X6 422";
    case MALI_Y16_UV16_422: return "Y16 UV16 422";
    case MALI_Y16_UV16_420: return "Y16 UV16 420";
    case MALI_RGB565: return "RGB565";
    case MALI_RGB5_A1_UNORM: return "RGB5 A1 UNORM";
    case MALI_A1_BGR5_UNORM: return "A1 BGR5 UNORM";
    case MALI_RGB10_A2_UNORM: return "RGB10 A2 UNORM";
    case MALI_A2_BGR10_UNORM: return "A2 BGR10 UNORM";
    case MALI_RGB10_A2_SNORM: return "RGB10 A2 SNORM";
    case MALI_A2_BGR10_SNORM: return "A2 BGR10 SNORM";
    case MALI_RGB10_A2UI: return "RGB10 A2UI";
    case MALI_A2_BGR10UI: return "A2 BGR10UI";
    case MALI_RGB10_A2I: return "RGB10 A2I";
    case MALI_A2_BGR10I: return "A2 BGR10I";
    case MALI_Z16_UNORM: return "Z16 UNORM";
    case MALI_Z32: return "Z32";
    case MALI_Z24X8_UNORM: return "Z24X8 UNORM";
    case MALI_X8Z24: return "X8Z24";
    case MALI_R32_FIXED: return "R32 FIXED";
    case MALI_RG32_FIXED: return "RG32 FIXED";
    case MALI_RGB32_FIXED: return "RGB32 FIXED";
    case MALI_RGBA32_FIXED: return "RGBA32 FIXED";
    case MALI_R11F_G11F_B10F: return "R11F G11F B10F";
    case MALI_B10F_G11F_R11F: return "B10F G11F R11F";
    case MALI_R9F_G9F_B9F_E5F: return "R9F G9F B9F E5F";
    case MALI_E5F_B9F_G9F_R9F: return "E5F B9F G9F R9F";
    case MALI_S8: return "S8";
    case MALI_SNAP_4: return "Snap 4";
    case MALI_CONSTANT: return "Constant";
    case MALI_R8_SNORM: return "R8 SNORM";
    case MALI_R16_SNORM: return "R16 SNORM";
    case MALI_R32_SNORM: return "R32 SNORM";
    case MALI_RG4_SNORM: return "RG4 SNORM";
    case MALI_RG8_SNORM: return "RG8 SNORM";
    case MALI_RG16_SNORM: return "RG16 SNORM";
    case MALI_RG32_SNORM: return "RG32 SNORM";
    case MALI_RGB8_SNORM: return "RGB8 SNORM";
    case MALI_RGB16_SNORM: return "RGB16 SNORM";
    case MALI_RGB32_SNORM: return "RGB32 SNORM";
    case MALI_RGBA2_SNORM: return "RGBA2 SNORM";
    case MALI_RGBA4_SNORM: return "RGBA4 SNORM";
    case MALI_RGBA8_SNORM: return "RGBA8 SNORM";
    case MALI_RGBA16_SNORM: return "RGBA16 SNORM";
    case MALI_RGBA32_SNORM: return "RGBA32 SNORM";
    case MALI_R8UI: return "R8UI";
    case MALI_R16UI: return "R16UI";
    case MALI_R32UI: return "R32UI";
    case MALI_RG4UI: return "RG4UI";
    case MALI_RG8UI: return "RG8UI";
    case MALI_RG16UI: return "RG16UI";
    case MALI_RG32UI: return "RG32UI";
    case MALI_RGB8UI: return "RGB8UI";
    case MALI_RGB16UI: return "RGB16UI";
    case MALI_RGB32UI: return "RGB32UI";
    case MALI_RGBA2UI: return "RGBA2UI";
    case MALI_RGBA4UI: return "RGBA4UI";
    case MALI_RGBA8UI: return "RGBA8UI";
    case MALI_RGBA16UI: return "RGBA16UI";
    case MALI_RGBA32UI: return "RGBA32UI";
    case MALI_R8_UNORM: return "R8 UNORM";
    case MALI_R16_UNORM: return "R16 UNORM";
    case MALI_R32_UNORM: return "R32 UNORM";
    case MALI_R32F: return "R32F";
    case MALI_RG4_UNORM: return "RG4 UNORM";
    case MALI_RG8_UNORM: return "RG8 UNORM";
    case MALI_RG16_UNORM: return "RG16 UNORM";
    case MALI_RG32_UNORM: return "RG32 UNORM";
    case MALI_RG32F: return "RG32F";
    case MALI_RGB8_UNORM: return "RGB8 UNORM";
    case MALI_RGB16_UNORM: return "RGB16 UNORM";
    case MALI_RGB32_UNORM: return "RGB32 UNORM";
    case MALI_RGB32F: return "RGB32F";
    case MALI_RGBA2_UNORM: return "RGBA2 UNORM";
    case MALI_RGBA4_UNORM: return "RGBA4 UNORM";
    case MALI_RGBA8_UNORM: return "RGBA8 UNORM";
    case MALI_RGBA16_UNORM: return "RGBA16 UNORM";
    case MALI_RGBA32_UNORM: return "RGBA32 UNORM";
    case MALI_RGBA32F: return "RGBA32F";
    case MALI_R8I: return "R8I";
    case MALI_R16I: return "R16I";
    case MALI_R32I: return "R32I";
    case MALI_R16F: return "R16F";
    case MALI_RG4I: return "RG4I";
    case MALI_RG8I: return "RG8I";
    case MALI_RG16I: return "RG16I";
    case MALI_RG32I: return "RG32I";
    case MALI_RG16F: return "RG16F";
    case MALI_RGB8I: return "RGB8I";
    case MALI_RGB16I: return "RGB16I";
    case MALI_RGB32I: return "RGB32I";
    case MALI_RGB16F: return "RGB16F";
    case MALI_RGBA2I: return "RGBA2I";
    case MALI_RGBA4I: return "RGBA4I";
    case MALI_RGBA8I: return "RGBA8I";
    case MALI_RGBA16I: return "RGBA16I";
    case MALI_RGBA32I: return "RGBA32I";
    case MALI_RGBA16F: return "RGBA16F";
    case MALI_RGB5_A1_AU: return "RGB5 A1 AU";
    case MALI_RGB5_A1_PU: return "RGB5 A1 PU";
    case MALI_R5G6B5_AU: return "R5G6B5 AU";
    case MALI_R5G6B5_PU: return "R5G6B5 PU";
    case MALI_SNAP4_V: return "Snap4 V";
    case MALI_R32F_RTZ: return "R32F RTZ";
    case MALI_RGBA4_AU: return "RGBA4 AU";
    case MALI_RGBA4_PU: return "RGBA4 PU";
    case MALI_RGBA8_TB: return "RGBA8 TB";
    case MALI_RGB10_A2_TB: return "RGB10 A2 TB";
    case MALI_RG32F_RTZ: return "RG32F RTZ";
    case MALI_TESS_VERTEX_PACK: return "Tess Vertex Pack";
    case MALI_RGB8_A2_AU: return "RGB8 A2 AU";
    case MALI_RGB8_A2_PU: return "RGB8 A2 PU";
    case MALI_RGB32F_RTZ: return "RGB32F RTZ";
    case MALI_RGBA32F_RTZ: return "RGBA32F RTZ";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_rgb_component_order {
        MALI_RGB_COMPONENT_ORDER_RGBA        =      0,
        MALI_RGB_COMPONENT_ORDER_GRBA        =      2,
        MALI_RGB_COMPONENT_ORDER_BGRA        =      4,
        MALI_RGB_COMPONENT_ORDER_ARGB        =      8,
        MALI_RGB_COMPONENT_ORDER_AGRB        =     10,
        MALI_RGB_COMPONENT_ORDER_ABGR        =     12,
        MALI_RGB_COMPONENT_ORDER_RGB1        =     16,
        MALI_RGB_COMPONENT_ORDER_GRB1        =     18,
        MALI_RGB_COMPONENT_ORDER_BGR1        =     20,
        MALI_RGB_COMPONENT_ORDER_1RGB        =     24,
        MALI_RGB_COMPONENT_ORDER_1GRB        =     26,
        MALI_RGB_COMPONENT_ORDER_1BGR        =     28,
        MALI_RGB_COMPONENT_ORDER_RRRR        =    226,
        MALI_RGB_COMPONENT_ORDER_RRR1        =    227,
        MALI_RGB_COMPONENT_ORDER_RRRA        =    228,
        MALI_RGB_COMPONENT_ORDER_000A        =    229,
        MALI_RGB_COMPONENT_ORDER_0001        =    230,
        MALI_RGB_COMPONENT_ORDER_0000        =    231,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V9    =    232,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V10   =    233,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V11   =    234,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V12   =    235,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V13   =    236,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V14   =    237,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V15   =    238,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V16   =    239,
        MALI_RGB_COMPONENT_ORDER_R000        =    240,
        MALI_RGB_COMPONENT_ORDER_RBGA        =    242,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_rgb_component_order_as_str(enum mali_rgb_component_order imm)
{
    switch (imm) {
    case MALI_RGB_COMPONENT_ORDER_RGBA: return "RGBA";
    case MALI_RGB_COMPONENT_ORDER_GRBA: return "GRBA";
    case MALI_RGB_COMPONENT_ORDER_BGRA: return "BGRA";
    case MALI_RGB_COMPONENT_ORDER_ARGB: return "ARGB";
    case MALI_RGB_COMPONENT_ORDER_AGRB: return "AGRB";
    case MALI_RGB_COMPONENT_ORDER_ABGR: return "ABGR";
    case MALI_RGB_COMPONENT_ORDER_RGB1: return "RGB1";
    case MALI_RGB_COMPONENT_ORDER_GRB1: return "GRB1";
    case MALI_RGB_COMPONENT_ORDER_BGR1: return "BGR1";
    case MALI_RGB_COMPONENT_ORDER_1RGB: return "1RGB";
    case MALI_RGB_COMPONENT_ORDER_1GRB: return "1GRB";
    case MALI_RGB_COMPONENT_ORDER_1BGR: return "1BGR";
    case MALI_RGB_COMPONENT_ORDER_RRRR: return "RRRR";
    case MALI_RGB_COMPONENT_ORDER_RRR1: return "RRR1";
    case MALI_RGB_COMPONENT_ORDER_RRRA: return "RRRA";
    case MALI_RGB_COMPONENT_ORDER_000A: return "000A";
    case MALI_RGB_COMPONENT_ORDER_0001: return "0001";
    case MALI_RGB_COMPONENT_ORDER_0000: return "0000";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V9: return "Snap4 v9";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V10: return "Snap4 v10";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V11: return "Snap4 v11";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V12: return "Snap4 v12";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V13: return "Snap4 v13";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V14: return "Snap4 v14";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V15: return "Snap4 v15";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V16: return "Snap4 v16";
    case MALI_RGB_COMPONENT_ORDER_R000: return "R000";
    case MALI_RGB_COMPONENT_ORDER_RBGA: return "RBGA";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_swizzle {
        MALI_YUV_SWIZZLE_YUVA                =      0,
        MALI_YUV_SWIZZLE_YVUA                =      1,
        MALI_YUV_SWIZZLE_UYVA                =      2,
        MALI_YUV_SWIZZLE_UVYA                =      3,
        MALI_YUV_SWIZZLE_VUYA                =      4,
        MALI_YUV_SWIZZLE_VYUA                =      5,
        MALI_YUV_SWIZZLE_Y00A                =      6,
        MALI_YUV_SWIZZLE_YXXA                =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_swizzle_as_str(enum mali_yuv_swizzle imm)
{
    switch (imm) {
    case MALI_YUV_SWIZZLE_YUVA: return "YUVA";
    case MALI_YUV_SWIZZLE_YVUA: return "YVUA";
    case MALI_YUV_SWIZZLE_UYVA: return "UYVA";
    case MALI_YUV_SWIZZLE_UVYA: return "UVYA";
    case MALI_YUV_SWIZZLE_VUYA: return "VUYA";
    case MALI_YUV_SWIZZLE_VYUA: return "VYUA";
    case MALI_YUV_SWIZZLE_Y00A: return "Y00A";
    case MALI_YUV_SWIZZLE_YXXA: return "YXXA";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_conversion_mode {
        MALI_YUV_CONVERSION_MODE_NO_CONVERSION =      0,
        MALI_YUV_CONVERSION_MODE_BT_601      =      3,
        MALI_YUV_CONVERSION_MODE_BT_709      =      4,
        MALI_YUV_CONVERSION_MODE_BT_2020     =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conversion_mode_as_str(enum mali_yuv_conversion_mode imm)
{
    switch (imm) {
    case MALI_YUV_CONVERSION_MODE_NO_CONVERSION: return "No Conversion";
    case MALI_YUV_CONVERSION_MODE_BT_601: return "BT 601";
    case MALI_YUV_CONVERSION_MODE_BT_709: return "BT 709";
    case MALI_YUV_CONVERSION_MODE_BT_2020: return "BT 2020";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_cr_siting {
        MALI_YUV_CR_SITING_CO_SITED          =      0,
        MALI_YUV_CR_SITING_CENTER_Y          =      1,
        MALI_YUV_CR_SITING_CENTER_X          =      2,
        MALI_YUV_CR_SITING_CENTER            =      3,
        MALI_YUV_CR_SITING_ONE_QUARTER       =      4,
        MALI_YUV_CR_SITING_THREE_QUARTERS    =      5,
        MALI_YUV_CR_SITING_REPLICATED        =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_cr_siting_as_str(enum mali_yuv_cr_siting imm)
{
    switch (imm) {
    case MALI_YUV_CR_SITING_CO_SITED: return "Co-Sited";
    case MALI_YUV_CR_SITING_CENTER_Y: return "Center Y";
    case MALI_YUV_CR_SITING_CENTER_X: return "Center X";
    case MALI_YUV_CR_SITING_CENTER: return "Center";
    case MALI_YUV_CR_SITING_ONE_QUARTER: return "One Quarter";
    case MALI_YUV_CR_SITING_THREE_QUARTERS: return "Three Quarters";
    case MALI_YUV_CR_SITING_REPLICATED: return "Replicated";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_astc_2d_dimension {
        MALI_ASTC_2D_DIMENSION_4             =      0,
        MALI_ASTC_2D_DIMENSION_5             =      1,
        MALI_ASTC_2D_DIMENSION_6             =      2,
        MALI_ASTC_2D_DIMENSION_8             =      4,
        MALI_ASTC_2D_DIMENSION_10            =      6,
        MALI_ASTC_2D_DIMENSION_12            =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_astc_2d_dimension_as_str(enum mali_astc_2d_dimension imm)
{
    switch (imm) {
    case MALI_ASTC_2D_DIMENSION_4: return "4";
    case MALI_ASTC_2D_DIMENSION_5: return "5";
    case MALI_ASTC_2D_DIMENSION_6: return "6";
    case MALI_ASTC_2D_DIMENSION_8: return "8";
    case MALI_ASTC_2D_DIMENSION_10: return "10";
    case MALI_ASTC_2D_DIMENSION_12: return "12";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_astc_3d_dimension {
        MALI_ASTC_3D_DIMENSION_4             =      0,
        MALI_ASTC_3D_DIMENSION_5             =      1,
        MALI_ASTC_3D_DIMENSION_6             =      2,
        MALI_ASTC_3D_DIMENSION_3             =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_astc_3d_dimension_as_str(enum mali_astc_3d_dimension imm)
{
    switch (imm) {
    case MALI_ASTC_3D_DIMENSION_4: return "4";
    case MALI_ASTC_3D_DIMENSION_5: return "5";
    case MALI_ASTC_3D_DIMENSION_6: return "6";
    case MALI_ASTC_3D_DIMENSION_3: return "3";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_pixel_kill {
        MALI_PIXEL_KILL_FORCE_EARLY          =      0,
        MALI_PIXEL_KILL_WEAK_EARLY           =      2,
        MALI_PIXEL_KILL_FORCE_LATE           =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_pixel_kill_as_str(enum mali_pixel_kill imm)
{
    switch (imm) {
    case MALI_PIXEL_KILL_FORCE_EARLY: return "Force Early";
    case MALI_PIXEL_KILL_WEAK_EARLY: return "Weak Early";
    case MALI_PIXEL_KILL_FORCE_LATE: return "Force Late";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_block_format {
        MALI_BLOCK_FORMAT_NO_WRITE           =      0,
        MALI_BLOCK_FORMAT_TILED_U_INTERLEAVED =      1,
        MALI_BLOCK_FORMAT_LINEAR             =      2,
        MALI_BLOCK_FORMAT_AFBC               =     12,
        MALI_BLOCK_FORMAT_AFBC_TILED         =     13,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_block_format_as_str(enum mali_block_format imm)
{
    switch (imm) {
    case MALI_BLOCK_FORMAT_NO_WRITE: return "No Write";
    case MALI_BLOCK_FORMAT_TILED_U_INTERLEAVED: return "Tiled U-Interleaved";
    case MALI_BLOCK_FORMAT_LINEAR: return "Linear";
    case MALI_BLOCK_FORMAT_AFBC: return "AFBC";
    case MALI_BLOCK_FORMAT_AFBC_TILED: return "AFBC Tiled";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_mipmap_mode {
        MALI_MIPMAP_MODE_NEAREST             =      0,
        MALI_MIPMAP_MODE_NONE                =      1,
        MALI_MIPMAP_MODE_TRILINEAR           =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_mipmap_mode_as_str(enum mali_mipmap_mode imm)
{
    switch (imm) {
    case MALI_MIPMAP_MODE_NEAREST: return "Nearest";
    case MALI_MIPMAP_MODE_NONE: return "None";
    case MALI_MIPMAP_MODE_TRILINEAR: return "Trilinear";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_lod_algorithm {
        MALI_LOD_ALGORITHM_ISOTROPIC         =      0,
        MALI_LOD_ALGORITHM_ANISOTROPIC       =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_lod_algorithm_as_str(enum mali_lod_algorithm imm)
{
    switch (imm) {
    case MALI_LOD_ALGORITHM_ISOTROPIC: return "Isotropic";
    case MALI_LOD_ALGORITHM_ANISOTROPIC: return "Anisotropic";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_msaa {
        MALI_MSAA_SINGLE                     =      0,
        MALI_MSAA_AVERAGE                    =      1,
        MALI_MSAA_MULTIPLE                   =      2,
        MALI_MSAA_LAYERED                    =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_msaa_as_str(enum mali_msaa imm)
{
    switch (imm) {
    case MALI_MSAA_SINGLE: return "Single";
    case MALI_MSAA_AVERAGE: return "Average";
    case MALI_MSAA_MULTIPLE: return "Multiple";
    case MALI_MSAA_LAYERED: return "Layered";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_index_type {
        MALI_INDEX_TYPE_NONE                 =      0,
        MALI_INDEX_TYPE_UINT8                =      1,
        MALI_INDEX_TYPE_UINT16               =      2,
        MALI_INDEX_TYPE_UINT32               =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_index_type_as_str(enum mali_index_type imm)
{
    switch (imm) {
    case MALI_INDEX_TYPE_NONE: return "None";
    case MALI_INDEX_TYPE_UINT8: return "UINT8";
    case MALI_INDEX_TYPE_UINT16: return "UINT16";
    case MALI_INDEX_TYPE_UINT32: return "UINT32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_occlusion_mode {
        MALI_OCCLUSION_MODE_DISABLED         =      0,
        MALI_OCCLUSION_MODE_PREDICATE        =      1,
        MALI_OCCLUSION_MODE_COUNTER          =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_occlusion_mode_as_str(enum mali_occlusion_mode imm)
{
    switch (imm) {
    case MALI_OCCLUSION_MODE_DISABLED: return "Disabled";
    case MALI_OCCLUSION_MODE_PREDICATE: return "Predicate";
    case MALI_OCCLUSION_MODE_COUNTER: return "Counter";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_stencil_op {
        MALI_STENCIL_OP_KEEP                 =      0,
        MALI_STENCIL_OP_REPLACE              =      1,
        MALI_STENCIL_OP_ZERO                 =      2,
        MALI_STENCIL_OP_INVERT               =      3,
        MALI_STENCIL_OP_INCR_WRAP            =      4,
        MALI_STENCIL_OP_DECR_WRAP            =      5,
        MALI_STENCIL_OP_INCR_SAT             =      6,
        MALI_STENCIL_OP_DECR_SAT             =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_stencil_op_as_str(enum mali_stencil_op imm)
{
    switch (imm) {
    case MALI_STENCIL_OP_KEEP: return "Keep";
    case MALI_STENCIL_OP_REPLACE: return "Replace";
    case MALI_STENCIL_OP_ZERO: return "Zero";
    case MALI_STENCIL_OP_INVERT: return "Invert";
    case MALI_STENCIL_OP_INCR_WRAP: return "Incr Wrap";
    case MALI_STENCIL_OP_DECR_WRAP: return "Decr Wrap";
    case MALI_STENCIL_OP_INCR_SAT: return "Incr Sat";
    case MALI_STENCIL_OP_DECR_SAT: return "Decr Sat";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_texture_dimension {
        MALI_TEXTURE_DIMENSION_CUBE          =      0,
        MALI_TEXTURE_DIMENSION_1D            =      1,
        MALI_TEXTURE_DIMENSION_2D            =      2,
        MALI_TEXTURE_DIMENSION_3D            =      3,
        MALI_TEXTURE_DIMENSION_2D_IMAGE_CROP =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_texture_dimension_as_str(enum mali_texture_dimension imm)
{
    switch (imm) {
    case MALI_TEXTURE_DIMENSION_CUBE: return "Cube";
    case MALI_TEXTURE_DIMENSION_1D: return "1D";
    case MALI_TEXTURE_DIMENSION_2D: return "2D";
    case MALI_TEXTURE_DIMENSION_3D: return "3D";
    case MALI_TEXTURE_DIMENSION_2D_IMAGE_CROP: return "2D Image Crop";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_wrap_mode {
        MALI_WRAP_MODE_REPEAT                =      8,
        MALI_WRAP_MODE_CLAMP_TO_EDGE         =      9,
        MALI_WRAP_MODE_CLAMP_TO_BORDER       =     11,
        MALI_WRAP_MODE_MIRRORED_REPEAT       =     12,
        MALI_WRAP_MODE_MIRRORED_CLAMP_TO_EDGE =     13,
        MALI_WRAP_MODE_MIRRORED_CLAMP_TO_BORDER =     15,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_wrap_mode_as_str(enum mali_wrap_mode imm)
{
    switch (imm) {
    case MALI_WRAP_MODE_REPEAT: return "Repeat";
    case MALI_WRAP_MODE_CLAMP_TO_EDGE: return "Clamp to Edge";
    case MALI_WRAP_MODE_CLAMP_TO_BORDER: return "Clamp to Border";
    case MALI_WRAP_MODE_MIRRORED_REPEAT: return "Mirrored Repeat";
    case MALI_WRAP_MODE_MIRRORED_CLAMP_TO_EDGE: return "Mirrored Clamp to Edge";
    case MALI_WRAP_MODE_MIRRORED_CLAMP_TO_BORDER: return "Mirrored Clamp to Border";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_tile_render_order {
        MALI_TILE_RENDER_ORDER_Z_ORDER       =      0,
        MALI_TILE_RENDER_ORDER_HORIZONTAL    =      1,
        MALI_TILE_RENDER_ORDER_VERTICAL      =      2,
        MALI_TILE_RENDER_ORDER_REVERSE_HORIZONTAL =      5,
        MALI_TILE_RENDER_ORDER_REVERSE_VERTICAL =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_tile_render_order_as_str(enum mali_tile_render_order imm)
{
    switch (imm) {
    case MALI_TILE_RENDER_ORDER_Z_ORDER: return "Z Order";
    case MALI_TILE_RENDER_ORDER_HORIZONTAL: return "Horizontal";
    case MALI_TILE_RENDER_ORDER_VERTICAL: return "Vertical";
    case MALI_TILE_RENDER_ORDER_REVERSE_HORIZONTAL: return "Reverse horizontal";
    case MALI_TILE_RENDER_ORDER_REVERSE_VERTICAL: return "Reverse vertical";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_task_axis {
        MALI_TASK_AXIS_X                     =      0,
        MALI_TASK_AXIS_Y                     =      1,
        MALI_TASK_AXIS_Z                     =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_task_axis_as_str(enum mali_task_axis imm)
{
    switch (imm) {
    case MALI_TASK_AXIS_X: return "X";
    case MALI_TASK_AXIS_Y: return "Y";
    case MALI_TASK_AXIS_Z: return "Z";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_attribute_frequency {
        MALI_ATTRIBUTE_FREQUENCY_VERTEX      =      0,
        MALI_ATTRIBUTE_FREQUENCY_INSTANCE    =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_attribute_frequency_as_str(enum mali_attribute_frequency imm)
{
    switch (imm) {
    case MALI_ATTRIBUTE_FREQUENCY_VERTEX: return "Vertex";
    case MALI_ATTRIBUTE_FREQUENCY_INSTANCE: return "Instance";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_DESCRIPTOR_HEADER {
   enum mali_descriptor_type            type;
   uint32_t                             ignore;
};

#define MALI_DESCRIPTOR_HEADER_header           \
   .type = MALI_DESCRIPTOR_TYPE_NULL

#define MALI_DESCRIPTOR_HEADER_LENGTH 4
#define MALI_DESCRIPTOR_HEADER_ALIGN 32
struct mali_descriptor_header_packed { uint32_t opaque[1]; };
#define MALI_DESCRIPTOR_HEADER_PACKED_T struct mali_descriptor_header_packed
#define MALI_DESCRIPTOR_HEADER_pack(__packed, __unpacked) \
do { \
   MALI_DESCRIPTOR_HEADER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->ignore, 4, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DESCRIPTOR_HEADER_unpack(__packed, __unpacked) \
do { \
   MALI_DESCRIPTOR_HEADER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->ignore, &__tmp_packed.opaque[0], 4, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DESCRIPTOR_HEADER_print(FILE *fp, const struct MALI_DESCRIPTOR_HEADER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sIgnore: %u\n", indent, "", values->ignore);
}

#endif
struct MALI_NULL_DESCRIPTOR {
   enum mali_descriptor_type            type;
};

#define MALI_NULL_DESCRIPTOR_header             \
   .type = MALI_DESCRIPTOR_TYPE_NULL

#define MALI_NULL_DESCRIPTOR_LENGTH 32
#define MALI_NULL_DESCRIPTOR_ALIGN 32
struct mali_null_descriptor_packed { uint32_t opaque[8]; };
#define MALI_NULL_DESCRIPTOR_PACKED_T struct mali_null_descriptor_packed
#define MALI_NULL_DESCRIPTOR_pack(__packed, __unpacked) \
do { \
   MALI_NULL_DESCRIPTOR_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_NULL_DESCRIPTOR_unpack(__packed, __unpacked) \
do { \
   MALI_NULL_DESCRIPTOR_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfffffff0) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_NULL_DESCRIPTOR_print(FILE *fp, const struct MALI_NULL_DESCRIPTOR * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
}

#endif
struct MALI_ATTRIBUTE {
   enum mali_descriptor_type            type;
   enum mali_attribute_type             attribute_type;
   bool                                 offset_enable;
   uint32_t                             format;
   uint32_t                             table;
   enum mali_attribute_frequency        frequency;
   uint32_t                             divisor_r;
   uint32_t                             divisor_e;
   int64_t                              offset;
   uint64_t                             buffer_index;
   uint64_t                             stride;
   uint32_t                             attribute_stride;
   uint32_t                             packet_stride;
   uint64_t                             divisor_d;
};

#define MALI_ATTRIBUTE_header                   \
   .type = MALI_DESCRIPTOR_TYPE_ATTRIBUTE

#define MALI_ATTRIBUTE_LENGTH 32
#define MALI_ATTRIBUTE_ALIGN 32
struct mali_attribute_packed { uint32_t opaque[8]; };
#define MALI_ATTRIBUTE_PACKED_T struct mali_attribute_packed
#define MALI_ATTRIBUTE_pack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->attribute_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->offset_enable, 8, 8) | \
            util_bitpack_uint((__unpacked)->format, 10, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->table, 0, 5) | \
            util_bitpack_uint((__unpacked)->frequency, 6, 7) | \
            util_bitpack_uint((__unpacked)->divisor_r, 24, 28) | \
            util_bitpack_uint((__unpacked)->divisor_e, 29, 29); \
   __tmp_packed.opaque[ 2] = util_bitpack_sint((__unpacked)->offset, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->buffer_index, 0, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->attribute_stride, 0, 15) | \
            util_bitpack_uint((__unpacked)->packet_stride, 16, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->divisor_d, 0, 31); \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ATTRIBUTE_unpack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x200) fprintf(stderr, "XXX: Invalid field of Attribute unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xc0ffff00) fprintf(stderr, "XXX: Invalid field of Attribute unpacked at word 1\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Attribute unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Attribute unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->attribute_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->offset_enable, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 10, 31); \
   __gen_unpack_uint((__unpacked)->table, &__tmp_packed.opaque[0], 32, 37); \
   __gen_unpack_uint((__unpacked)->frequency, &__tmp_packed.opaque[0], 38, 39); \
   __gen_unpack_uint((__unpacked)->divisor_r, &__tmp_packed.opaque[0], 56, 60); \
   __gen_unpack_uint((__unpacked)->divisor_e, &__tmp_packed.opaque[0], 61, 61); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->buffer_index, &__tmp_packed.opaque[0], 96, 127); \
   __gen_unpack_uint((__unpacked)->stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->attribute_stride, &__tmp_packed.opaque[0], 128, 143); \
   __gen_unpack_uint((__unpacked)->packet_stride, &__tmp_packed.opaque[0], 144, 159); \
   __gen_unpack_uint((__unpacked)->divisor_d, &__tmp_packed.opaque[0], 160, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ATTRIBUTE_print(FILE *fp, const struct MALI_ATTRIBUTE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sAttribute type: %s\n", indent, "", mali_attribute_type_as_str(values->attribute_type));
   fprintf(fp, "%*sOffset enable: %s\n", indent, "", values->offset_enable ? "true" : "false");
   mali_pixel_format_print(fp, values->format);
   fprintf(fp, "%*sTable: %u\n", indent, "", values->table);
   fprintf(fp, "%*sFrequency: %s\n", indent, "", mali_attribute_frequency_as_str(values->frequency));
   fprintf(fp, "%*sDivisor R: %u\n", indent, "", values->divisor_r);
   fprintf(fp, "%*sDivisor E: %u\n", indent, "", values->divisor_e);
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
   fprintf(fp, "%*sBuffer index: 0x%" PRIx64 "\n", indent, "", values->buffer_index);
   fprintf(fp, "%*sStride: 0x%" PRIx64 "\n", indent, "", values->stride);
   fprintf(fp, "%*sAttribute stride: %u\n", indent, "", values->attribute_stride);
   fprintf(fp, "%*sPacket stride: %u\n", indent, "", values->packet_stride);
   fprintf(fp, "%*sDivisor D: 0x%" PRIx64 "\n", indent, "", values->divisor_d);
}

#endif
enum mali_blend_operand_a {
        MALI_BLEND_OPERAND_A_ZERO            =      1,
        MALI_BLEND_OPERAND_A_SRC             =      2,
        MALI_BLEND_OPERAND_A_DEST            =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_a_as_str(enum mali_blend_operand_a imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_A_ZERO: return "Zero";
    case MALI_BLEND_OPERAND_A_SRC: return "Src";
    case MALI_BLEND_OPERAND_A_DEST: return "Dest";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_blend_operand_b {
        MALI_BLEND_OPERAND_B_SRC_MINUS_DEST  =      0,
        MALI_BLEND_OPERAND_B_SRC_PLUS_DEST   =      1,
        MALI_BLEND_OPERAND_B_SRC             =      2,
        MALI_BLEND_OPERAND_B_DEST            =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_b_as_str(enum mali_blend_operand_b imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_B_SRC_MINUS_DEST: return "Src Minus Dest";
    case MALI_BLEND_OPERAND_B_SRC_PLUS_DEST: return "Src Plus Dest";
    case MALI_BLEND_OPERAND_B_SRC: return "Src";
    case MALI_BLEND_OPERAND_B_DEST: return "Dest";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_blend_operand_c {
        MALI_BLEND_OPERAND_C_ZERO            =      1,
        MALI_BLEND_OPERAND_C_SRC             =      2,
        MALI_BLEND_OPERAND_C_DEST            =      3,
        MALI_BLEND_OPERAND_C_SRC_X_2         =      4,
        MALI_BLEND_OPERAND_C_SRC_ALPHA       =      5,
        MALI_BLEND_OPERAND_C_DEST_ALPHA      =      6,
        MALI_BLEND_OPERAND_C_CONSTANT        =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_c_as_str(enum mali_blend_operand_c imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_C_ZERO: return "Zero";
    case MALI_BLEND_OPERAND_C_SRC: return "Src";
    case MALI_BLEND_OPERAND_C_DEST: return "Dest";
    case MALI_BLEND_OPERAND_C_SRC_X_2: return "Src x 2";
    case MALI_BLEND_OPERAND_C_SRC_ALPHA: return "Src Alpha";
    case MALI_BLEND_OPERAND_C_DEST_ALPHA: return "Dest Alpha";
    case MALI_BLEND_OPERAND_C_CONSTANT: return "Constant";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_BLEND_FUNCTION {
   enum mali_blend_operand_a            a;
   bool                                 negate_a;
   enum mali_blend_operand_b            b;
   bool                                 negate_b;
   enum mali_blend_operand_c            c;
   bool                                 invert_c;
};

#define MALI_BLEND_FUNCTION_header              \
   0

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_FUNCTION_print(FILE *fp, const struct MALI_BLEND_FUNCTION * values, unsigned indent)
{
   fprintf(fp, "%*sA: %s\n", indent, "", mali_blend_operand_a_as_str(values->a));
   fprintf(fp, "%*sNegate A: %s\n", indent, "", values->negate_a ? "true" : "false");
   fprintf(fp, "%*sB: %s\n", indent, "", mali_blend_operand_b_as_str(values->b));
   fprintf(fp, "%*sNegate B: %s\n", indent, "", values->negate_b ? "true" : "false");
   fprintf(fp, "%*sC: %s\n", indent, "", mali_blend_operand_c_as_str(values->c));
   fprintf(fp, "%*sInvert C: %s\n", indent, "", values->invert_c ? "true" : "false");
}

#endif
struct MALI_BLEND_EQUATION {
   struct MALI_BLEND_FUNCTION           rgb;
   struct MALI_BLEND_FUNCTION           alpha;
   uint32_t                             color_mask;
};

#define MALI_BLEND_EQUATION_header              \
   .rgb = { MALI_BLEND_FUNCTION_header },  \
   .alpha = { MALI_BLEND_FUNCTION_header }

#define MALI_BLEND_EQUATION_LENGTH 4
struct mali_blend_equation_packed { uint32_t opaque[1]; };
#define MALI_BLEND_EQUATION_PACKED_T struct mali_blend_equation_packed
#define MALI_BLEND_EQUATION_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_EQUATION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->rgb.a, 0, 1) | \
            util_bitpack_uint((__unpacked)->rgb.negate_a, 3, 3) | \
            util_bitpack_uint((__unpacked)->rgb.b, 4, 5) | \
            util_bitpack_uint((__unpacked)->rgb.negate_b, 7, 7) | \
            util_bitpack_uint((__unpacked)->rgb.c, 8, 10) | \
            util_bitpack_uint((__unpacked)->rgb.invert_c, 11, 11) | \
            util_bitpack_uint((__unpacked)->alpha.a, 12, 13) | \
            util_bitpack_uint((__unpacked)->alpha.negate_a, 15, 15) | \
            util_bitpack_uint((__unpacked)->alpha.b, 16, 17) | \
            util_bitpack_uint((__unpacked)->alpha.negate_b, 19, 19) | \
            util_bitpack_uint((__unpacked)->alpha.c, 20, 22) | \
            util_bitpack_uint((__unpacked)->alpha.invert_c, 23, 23) | \
            util_bitpack_uint((__unpacked)->color_mask, 28, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_EQUATION_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_EQUATION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf044044) fprintf(stderr, "XXX: Invalid field of Blend Equation unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->rgb.a, &__tmp_packed.opaque[0], 0, 1); \
   __gen_unpack_uint((__unpacked)->rgb.negate_a, &__tmp_packed.opaque[0], 3, 3); \
   __gen_unpack_uint((__unpacked)->rgb.b, &__tmp_packed.opaque[0], 4, 5); \
   __gen_unpack_uint((__unpacked)->rgb.negate_b, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->rgb.c, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->rgb.invert_c, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->alpha.a, &__tmp_packed.opaque[0], 12, 13); \
   __gen_unpack_uint((__unpacked)->alpha.negate_a, &__tmp_packed.opaque[0], 15, 15); \
   __gen_unpack_uint((__unpacked)->alpha.b, &__tmp_packed.opaque[0], 16, 17); \
   __gen_unpack_uint((__unpacked)->alpha.negate_b, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->alpha.c, &__tmp_packed.opaque[0], 20, 22); \
   __gen_unpack_uint((__unpacked)->alpha.invert_c, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->color_mask, &__tmp_packed.opaque[0], 28, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_EQUATION_print(FILE *fp, const struct MALI_BLEND_EQUATION * values, unsigned indent)
{
   fprintf(fp, "%*sRGB:\n", indent, "");
   MALI_BLEND_FUNCTION_print(fp, &values->rgb, indent + 2);
   fprintf(fp, "%*sAlpha:\n", indent, "");
   MALI_BLEND_FUNCTION_print(fp, &values->alpha, indent + 2);
   fprintf(fp, "%*sColor Mask: %u\n", indent, "", values->color_mask);
}

#endif
enum mali_register_file_format {
        MALI_REGISTER_FILE_FORMAT_F16        =      0,
        MALI_REGISTER_FILE_FORMAT_F32        =      1,
        MALI_REGISTER_FILE_FORMAT_I32        =      2,
        MALI_REGISTER_FILE_FORMAT_U32        =      3,
        MALI_REGISTER_FILE_FORMAT_I16        =      4,
        MALI_REGISTER_FILE_FORMAT_U16        =      5,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_register_file_format_as_str(enum mali_register_file_format imm)
{
    switch (imm) {
    case MALI_REGISTER_FILE_FORMAT_F16: return "F16";
    case MALI_REGISTER_FILE_FORMAT_F32: return "F32";
    case MALI_REGISTER_FILE_FORMAT_I32: return "I32";
    case MALI_REGISTER_FILE_FORMAT_U32: return "U32";
    case MALI_REGISTER_FILE_FORMAT_I16: return "I16";
    case MALI_REGISTER_FILE_FORMAT_U16: return "U16";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_blend_mode {
        MALI_BLEND_MODE_SHADER               =      0,
        MALI_BLEND_MODE_OPAQUE               =      1,
        MALI_BLEND_MODE_FIXED_FUNCTION       =      2,
        MALI_BLEND_MODE_OFF                  =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_mode_as_str(enum mali_blend_mode imm)
{
    switch (imm) {
    case MALI_BLEND_MODE_SHADER: return "Shader";
    case MALI_BLEND_MODE_OPAQUE: return "Opaque";
    case MALI_BLEND_MODE_FIXED_FUNCTION: return "Fixed-Function";
    case MALI_BLEND_MODE_OFF: return "Off";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_BLEND_SHADER {
   uint32_t                             pc;
};

#define MALI_BLEND_SHADER_header                \
   0

#define MALI_BLEND_SHADER_LENGTH 8
struct mali_blend_shader_packed { uint32_t opaque[2]; };
#define MALI_BLEND_SHADER_PACKED_T struct mali_blend_shader_packed
#define MALI_BLEND_SHADER_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_SHADER_PACKED_T __tmp_packed; \
   assert(((__unpacked)->pc & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pc >> 4, 4, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_SHADER_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_SHADER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Blend Shader unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf) fprintf(stderr, "XXX: Invalid field of Blend Shader unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->pc, &__tmp_packed.opaque[0], 36, 63); \
   (__unpacked)->pc = (__unpacked)->pc << 4; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_SHADER_print(FILE *fp, const struct MALI_BLEND_SHADER * values, unsigned indent)
{
   fprintf(fp, "%*sPC: %u\n", indent, "", values->pc);
}

#endif
struct MALI_INTERNAL_CONVERSION {
   uint32_t                             memory_format;
   bool                                 raw;
};

#define MALI_INTERNAL_CONVERSION_header         \
   0

#define MALI_INTERNAL_CONVERSION_LENGTH 4
#define MALI_INTERNAL_CONVERSION_ALIGN 4
struct mali_internal_conversion_packed { uint32_t opaque[1]; };
#define MALI_INTERNAL_CONVERSION_PACKED_T struct mali_internal_conversion_packed
#define MALI_INTERNAL_CONVERSION_pack(__packed, __unpacked) \
do { \
   MALI_INTERNAL_CONVERSION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->raw, 22, 22); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_INTERNAL_CONVERSION_unpack(__packed, __unpacked) \
do { \
   MALI_INTERNAL_CONVERSION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff800000) fprintf(stderr, "XXX: Invalid field of Internal Conversion unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->memory_format, &__tmp_packed.opaque[0], 0, 21); \
   __gen_unpack_uint((__unpacked)->raw, &__tmp_packed.opaque[0], 22, 22); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_INTERNAL_CONVERSION_print(FILE *fp, const struct MALI_INTERNAL_CONVERSION * values, unsigned indent)
{
   mali_pixel_format_print(fp, values->memory_format);
   fprintf(fp, "%*sRaw: %s\n", indent, "", values->raw ? "true" : "false");
}

#endif
struct MALI_BLEND_FIXED_FUNCTION {
   uint32_t                             num_comps;
   uint32_t                             rt;
#define MALI_BIFROST_BLEND_MAX_RT                8
   struct MALI_INTERNAL_CONVERSION      conversion;
};

#define MALI_BLEND_FIXED_FUNCTION_header        \
   .num_comps = 1,  \
   .conversion = { MALI_INTERNAL_CONVERSION_header }

#define MALI_BLEND_FIXED_FUNCTION_LENGTH 8
struct mali_blend_fixed_function_packed { uint32_t opaque[2]; };
#define MALI_BLEND_FIXED_FUNCTION_PACKED_T struct mali_blend_fixed_function_packed
#define MALI_BLEND_FIXED_FUNCTION_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_FIXED_FUNCTION_PACKED_T __tmp_packed; \
   assert((__unpacked)->num_comps >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->num_comps - 1, 3, 4) | \
            util_bitpack_uint((__unpacked)->rt, 16, 19); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->conversion.memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->conversion.raw, 22, 22); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_FIXED_FUNCTION_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_FIXED_FUNCTION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff0ffe7) fprintf(stderr, "XXX: Invalid field of Blend Fixed-Function unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff800000) fprintf(stderr, "XXX: Invalid field of Blend Fixed-Function unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->num_comps, &__tmp_packed.opaque[0], 3, 4); \
   (__unpacked)->num_comps = (__unpacked)->num_comps + 1; \
   __gen_unpack_uint((__unpacked)->rt, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->conversion.memory_format, &__tmp_packed.opaque[0], 32, 53); \
   __gen_unpack_uint((__unpacked)->conversion.raw, &__tmp_packed.opaque[0], 54, 54); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_FIXED_FUNCTION_print(FILE *fp, const struct MALI_BLEND_FIXED_FUNCTION * values, unsigned indent)
{
   fprintf(fp, "%*sNum Comps: %u\n", indent, "", values->num_comps);
   fprintf(fp, "%*sRT: %u\n", indent, "", values->rt);
   fprintf(fp, "%*sConversion:\n", indent, "");
   MALI_INTERNAL_CONVERSION_print(fp, &values->conversion, indent + 2);
}

#endif
struct MALI_INTERNAL_BLEND {
   enum mali_blend_mode                 mode;
   struct MALI_BLEND_SHADER             shader;
   struct MALI_BLEND_FIXED_FUNCTION     fixed_function;
};

#define MALI_INTERNAL_BLEND_header              \
   .shader = { MALI_BLEND_SHADER_header },  \
   .fixed_function = { MALI_BLEND_FIXED_FUNCTION_header }

#define MALI_INTERNAL_BLEND_LENGTH 8
#define MALI_INTERNAL_BLEND_ALIGN 8
struct mali_internal_blend_packed { uint32_t opaque[2]; };
#define MALI_INTERNAL_BLEND_PACKED_T struct mali_internal_blend_packed
#define MALI_INTERNAL_BLEND_pack(__packed, __unpacked) \
do { \
   MALI_INTERNAL_BLEND_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 1) | \
            util_bitpack_uint((__unpacked)->fixed_function.num_comps - 1, 3, 4) | \
            util_bitpack_uint((__unpacked)->fixed_function.rt, 16, 19); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->shader.pc >> 4, 4, 31) | \
            util_bitpack_uint((__unpacked)->fixed_function.conversion.memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->fixed_function.conversion.raw, 22, 22); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_INTERNAL_BLEND_unpack(__packed, __unpacked) \
do { \
   MALI_INTERNAL_BLEND_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff0ffe4) fprintf(stderr, "XXX: Invalid field of Internal Blend unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 1); \
   __gen_unpack_uint((__unpacked)->shader.pc, &__tmp_packed.opaque[0], 36, 63); \
   (__unpacked)->shader.pc = (__unpacked)->shader.pc << 4; \
   __gen_unpack_uint((__unpacked)->fixed_function.num_comps, &__tmp_packed.opaque[0], 3, 4); \
   (__unpacked)->fixed_function.num_comps = (__unpacked)->fixed_function.num_comps + 1; \
   __gen_unpack_uint((__unpacked)->fixed_function.rt, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->fixed_function.conversion.memory_format, &__tmp_packed.opaque[0], 32, 53); \
   __gen_unpack_uint((__unpacked)->fixed_function.conversion.raw, &__tmp_packed.opaque[0], 54, 54); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_INTERNAL_BLEND_print(FILE *fp, const struct MALI_INTERNAL_BLEND * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_blend_mode_as_str(values->mode));
   fprintf(fp, "%*sShader:\n", indent, "");
   MALI_BLEND_SHADER_print(fp, &values->shader, indent + 2);
   fprintf(fp, "%*sFixed-Function:\n", indent, "");
   MALI_BLEND_FIXED_FUNCTION_print(fp, &values->fixed_function, indent + 2);
}

#endif
struct MALI_BLEND {
   bool                                 load_destination;
   bool                                 alpha_to_one;
   bool                                 enable;
   bool                                 srgb;
   bool                                 round_to_fb_precision;
   uint32_t                             blend_constant;
   struct MALI_BLEND_EQUATION           equation;
   struct MALI_INTERNAL_BLEND           internal;
};

#define MALI_BLEND_header                       \
   .load_destination = false,  \
   .enable = true,  \
   .srgb = false,  \
   .round_to_fb_precision = false,  \
   .equation = { MALI_BLEND_EQUATION_header },  \
   .internal = { MALI_INTERNAL_BLEND_header }

#define MALI_BLEND_LENGTH 16
#define MALI_BLEND_ALIGN 16
struct mali_blend_packed { uint32_t opaque[4]; };
#define MALI_BLEND_PACKED_T struct mali_blend_packed
#define MALI_BLEND_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->load_destination, 0, 0) | \
            util_bitpack_uint((__unpacked)->alpha_to_one, 8, 8) | \
            util_bitpack_uint((__unpacked)->enable, 9, 9) | \
            util_bitpack_uint((__unpacked)->srgb, 10, 10) | \
            util_bitpack_uint((__unpacked)->round_to_fb_precision, 11, 11) | \
            util_bitpack_uint((__unpacked)->blend_constant, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->equation.rgb.a, 0, 1) | \
            util_bitpack_uint((__unpacked)->equation.rgb.negate_a, 3, 3) | \
            util_bitpack_uint((__unpacked)->equation.rgb.b, 4, 5) | \
            util_bitpack_uint((__unpacked)->equation.rgb.negate_b, 7, 7) | \
            util_bitpack_uint((__unpacked)->equation.rgb.c, 8, 10) | \
            util_bitpack_uint((__unpacked)->equation.rgb.invert_c, 11, 11) | \
            util_bitpack_uint((__unpacked)->equation.alpha.a, 12, 13) | \
            util_bitpack_uint((__unpacked)->equation.alpha.negate_a, 15, 15) | \
            util_bitpack_uint((__unpacked)->equation.alpha.b, 16, 17) | \
            util_bitpack_uint((__unpacked)->equation.alpha.negate_b, 19, 19) | \
            util_bitpack_uint((__unpacked)->equation.alpha.c, 20, 22) | \
            util_bitpack_uint((__unpacked)->equation.alpha.invert_c, 23, 23) | \
            util_bitpack_uint((__unpacked)->equation.color_mask, 28, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->internal.mode, 0, 1) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.num_comps - 1, 3, 4) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.rt, 16, 19); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->internal.shader.pc >> 4, 4, 31) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.conversion.memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.conversion.raw, 22, 22); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0fe) fprintf(stderr, "XXX: Invalid field of Blend unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf044044) fprintf(stderr, "XXX: Invalid field of Blend unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xfff0ffe4) fprintf(stderr, "XXX: Invalid field of Blend unpacked at word 2\n"); \
   __gen_unpack_uint((__unpacked)->load_destination, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->alpha_to_one, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->enable, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->round_to_fb_precision, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->blend_constant, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->equation.rgb.a, &__tmp_packed.opaque[0], 32, 33); \
   __gen_unpack_uint((__unpacked)->equation.rgb.negate_a, &__tmp_packed.opaque[0], 35, 35); \
   __gen_unpack_uint((__unpacked)->equation.rgb.b, &__tmp_packed.opaque[0], 36, 37); \
   __gen_unpack_uint((__unpacked)->equation.rgb.negate_b, &__tmp_packed.opaque[0], 39, 39); \
   __gen_unpack_uint((__unpacked)->equation.rgb.c, &__tmp_packed.opaque[0], 40, 42); \
   __gen_unpack_uint((__unpacked)->equation.rgb.invert_c, &__tmp_packed.opaque[0], 43, 43); \
   __gen_unpack_uint((__unpacked)->equation.alpha.a, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->equation.alpha.negate_a, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->equation.alpha.b, &__tmp_packed.opaque[0], 48, 49); \
   __gen_unpack_uint((__unpacked)->equation.alpha.negate_b, &__tmp_packed.opaque[0], 51, 51); \
   __gen_unpack_uint((__unpacked)->equation.alpha.c, &__tmp_packed.opaque[0], 52, 54); \
   __gen_unpack_uint((__unpacked)->equation.alpha.invert_c, &__tmp_packed.opaque[0], 55, 55); \
   __gen_unpack_uint((__unpacked)->equation.color_mask, &__tmp_packed.opaque[0], 60, 63); \
   __gen_unpack_uint((__unpacked)->internal.mode, &__tmp_packed.opaque[0], 64, 65); \
   __gen_unpack_uint((__unpacked)->internal.shader.pc, &__tmp_packed.opaque[0], 100, 127); \
   (__unpacked)->internal.shader.pc = (__unpacked)->internal.shader.pc << 4; \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.num_comps, &__tmp_packed.opaque[0], 67, 68); \
   (__unpacked)->internal.fixed_function.num_comps = (__unpacked)->internal.fixed_function.num_comps + 1; \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.rt, &__tmp_packed.opaque[0], 80, 83); \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.conversion.memory_format, &__tmp_packed.opaque[0], 96, 117); \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.conversion.raw, &__tmp_packed.opaque[0], 118, 118); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_print(FILE *fp, const struct MALI_BLEND * values, unsigned indent)
{
   fprintf(fp, "%*sLoad Destination: %s\n", indent, "", values->load_destination ? "true" : "false");
   fprintf(fp, "%*sAlpha To One: %s\n", indent, "", values->alpha_to_one ? "true" : "false");
   fprintf(fp, "%*sEnable: %s\n", indent, "", values->enable ? "true" : "false");
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sRound to FB precision: %s\n", indent, "", values->round_to_fb_precision ? "true" : "false");
   fprintf(fp, "%*sBlend Constant: %u\n", indent, "", values->blend_constant);
   fprintf(fp, "%*sEquation:\n", indent, "");
   MALI_BLEND_EQUATION_print(fp, &values->equation, indent + 2);
   fprintf(fp, "%*sInternal:\n", indent, "");
   MALI_INTERNAL_BLEND_print(fp, &values->internal, indent + 2);
}

#endif
struct MALI_BUFFER {
   enum mali_descriptor_type            type;
   enum mali_buffer_type                buffer_type;
   uint64_t                             size;
   uint64_t                             address;
   uint64_t                             stride;
   uint32_t                             packet_stride;
   uint32_t                             attribute_stride;
   struct MALI_INTERNAL_CONVERSION      conversion;
};

#define MALI_BUFFER_header                      \
   .type = MALI_DESCRIPTOR_TYPE_BUFFER,  \
   .buffer_type = MALI_BUFFER_TYPE_SIMPLE,  \
   .conversion = { MALI_INTERNAL_CONVERSION_header }

#define MALI_BUFFER_LENGTH 32
#define MALI_BUFFER_ALIGN 32
struct mali_buffer_packed { uint32_t opaque[8]; };
#define MALI_BUFFER_PACKED_T struct mali_buffer_packed
#define MALI_BUFFER_pack(__packed, __unpacked) \
do { \
   MALI_BUFFER_PACKED_T __tmp_packed; \
   assert(((__unpacked)->packet_stride & 0x3f) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->buffer_type, 4, 7); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->address, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->address, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->packet_stride >> 6, 0, 15) | \
            util_bitpack_uint((__unpacked)->attribute_stride, 16, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->conversion.memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->conversion.raw, 22, 22); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BUFFER_unpack(__packed, __unpacked) \
do { \
   MALI_BUFFER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Buffer unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Buffer unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Buffer unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xff800000) fprintf(stderr, "XXX: Invalid field of Buffer unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->buffer_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->packet_stride, &__tmp_packed.opaque[0], 128, 143); \
   (__unpacked)->packet_stride = (__unpacked)->packet_stride << 6; \
   __gen_unpack_uint((__unpacked)->attribute_stride, &__tmp_packed.opaque[0], 144, 159); \
   __gen_unpack_uint((__unpacked)->conversion.memory_format, &__tmp_packed.opaque[0], 224, 245); \
   __gen_unpack_uint((__unpacked)->conversion.raw, &__tmp_packed.opaque[0], 246, 246); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BUFFER_print(FILE *fp, const struct MALI_BUFFER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sBuffer type: %s\n", indent, "", mali_buffer_type_as_str(values->buffer_type));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sAddress: 0x%" PRIx64 "\n", indent, "", values->address);
   fprintf(fp, "%*sStride: 0x%" PRIx64 "\n", indent, "", values->stride);
   fprintf(fp, "%*sPacket stride: %u\n", indent, "", values->packet_stride);
   fprintf(fp, "%*sAttribute stride: %u\n", indent, "", values->attribute_stride);
   fprintf(fp, "%*sConversion:\n", indent, "");
   MALI_INTERNAL_CONVERSION_print(fp, &values->conversion, indent + 2);
}

#endif
enum mali_point_size_array_format {
        MALI_POINT_SIZE_ARRAY_FORMAT_NONE    =      0,
        MALI_POINT_SIZE_ARRAY_FORMAT_FP16    =      2,
        MALI_POINT_SIZE_ARRAY_FORMAT_FP32    =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_point_size_array_format_as_str(enum mali_point_size_array_format imm)
{
    switch (imm) {
    case MALI_POINT_SIZE_ARRAY_FORMAT_NONE: return "None";
    case MALI_POINT_SIZE_ARRAY_FORMAT_FP16: return "FP16";
    case MALI_POINT_SIZE_ARRAY_FORMAT_FP32: return "FP32";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_PRIMITIVE {
   enum mali_draw_mode                  draw_mode;
   enum mali_index_type                 index_type;
   enum mali_point_size_array_format    point_size_array_format;
   bool                                 primitive_index_enable;
   bool                                 primitive_index_override;
   bool                                 allow_rotating_primitives;
   bool                                 low_depth_cull;
   bool                                 high_depth_cull;
   bool                                 secondary_shader;
   bool                                 primitive_restart;
   bool                                 layer_index_enable;
   bool                                 scissor_array_enable;
   int64_t                              base_vertex_offset;
   uint64_t                             instance_offset;
   uint64_t                             index_count;
};

#define MALI_PRIMITIVE_header                   \
   .draw_mode = MALI_DRAW_MODE_NONE,  \
   .index_type = MALI_INDEX_TYPE_NONE,  \
   .allow_rotating_primitives = true,  \
   .low_depth_cull = true,  \
   .high_depth_cull = true

#define MALI_PRIMITIVE_LENGTH 16
struct mali_primitive_packed { uint32_t opaque[4]; };
#define MALI_PRIMITIVE_PACKED_T struct mali_primitive_packed
#define MALI_PRIMITIVE_pack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->draw_mode, 0, 7) | \
            util_bitpack_uint((__unpacked)->index_type, 8, 10) | \
            util_bitpack_uint((__unpacked)->point_size_array_format, 11, 12) | \
            util_bitpack_uint((__unpacked)->primitive_index_enable, 13, 13) | \
            util_bitpack_uint((__unpacked)->primitive_index_override, 14, 14) | \
            util_bitpack_uint((__unpacked)->allow_rotating_primitives, 15, 15) | \
            util_bitpack_uint((__unpacked)->low_depth_cull, 16, 16) | \
            util_bitpack_uint((__unpacked)->high_depth_cull, 17, 17) | \
            util_bitpack_uint((__unpacked)->secondary_shader, 18, 18) | \
            util_bitpack_uint((__unpacked)->primitive_restart, 19, 19) | \
            util_bitpack_uint((__unpacked)->layer_index_enable, 20, 20) | \
            util_bitpack_uint((__unpacked)->scissor_array_enable, 21, 21); \
   __tmp_packed.opaque[ 1] = util_bitpack_sint((__unpacked)->base_vertex_offset, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->instance_offset, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->index_count, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRIMITIVE_unpack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffc00000) fprintf(stderr, "XXX: Invalid field of Primitive unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->draw_mode, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->index_type, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->point_size_array_format, &__tmp_packed.opaque[0], 11, 12); \
   __gen_unpack_uint((__unpacked)->primitive_index_enable, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->primitive_index_override, &__tmp_packed.opaque[0], 14, 14); \
   __gen_unpack_uint((__unpacked)->allow_rotating_primitives, &__tmp_packed.opaque[0], 15, 15); \
   __gen_unpack_uint((__unpacked)->low_depth_cull, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->high_depth_cull, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->secondary_shader, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->primitive_restart, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->layer_index_enable, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->scissor_array_enable, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_sint((__unpacked)->base_vertex_offset, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->instance_offset, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->index_count, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRIMITIVE_print(FILE *fp, const struct MALI_PRIMITIVE * values, unsigned indent)
{
   fprintf(fp, "%*sDraw mode: %s\n", indent, "", mali_draw_mode_as_str(values->draw_mode));
   fprintf(fp, "%*sIndex type: %s\n", indent, "", mali_index_type_as_str(values->index_type));
   fprintf(fp, "%*sPoint size array format: %s\n", indent, "", mali_point_size_array_format_as_str(values->point_size_array_format));
   fprintf(fp, "%*sPrimitive Index Enable: %s\n", indent, "", values->primitive_index_enable ? "true" : "false");
   fprintf(fp, "%*sPrimitive Index Override: %s\n", indent, "", values->primitive_index_override ? "true" : "false");
   fprintf(fp, "%*sAllow rotating primitives: %s\n", indent, "", values->allow_rotating_primitives ? "true" : "false");
   fprintf(fp, "%*sLow Depth Cull: %s\n", indent, "", values->low_depth_cull ? "true" : "false");
   fprintf(fp, "%*sHigh Depth Cull: %s\n", indent, "", values->high_depth_cull ? "true" : "false");
   fprintf(fp, "%*sSecondary Shader: %s\n", indent, "", values->secondary_shader ? "true" : "false");
   fprintf(fp, "%*sPrimitive restart: %s\n", indent, "", values->primitive_restart ? "true" : "false");
   fprintf(fp, "%*sLayer index enable: %s\n", indent, "", values->layer_index_enable ? "true" : "false");
   fprintf(fp, "%*sScissor array enable: %s\n", indent, "", values->scissor_array_enable ? "true" : "false");
   fprintf(fp, "%*sBase vertex offset: %" PRId64 "\n", indent, "", (int64_t)values->base_vertex_offset);
   fprintf(fp, "%*sInstance offset: 0x%" PRIx64 "\n", indent, "", values->instance_offset);
   fprintf(fp, "%*sIndex count: 0x%" PRIx64 "\n", indent, "", values->index_count);
}

#endif
struct MALI_SAMPLER {
   enum mali_descriptor_type            type;
   enum mali_wrap_mode                  wrap_mode_r;
   enum mali_wrap_mode                  wrap_mode_t;
   enum mali_wrap_mode                  wrap_mode_s;
   bool                                 round_to_nearest_even;
   bool                                 srgb_override;
   bool                                 seamless_cube_map;
   bool                                 clamp_integer_coordinates;
   bool                                 normalized_coordinates;
   bool                                 clamp_integer_array_indices;
   bool                                 minify_nearest;
   bool                                 magnify_nearest;
   bool                                 magnify_cutoff;
   enum mali_mipmap_mode                mipmap_mode;
   float                                minimum_lod;
   enum mali_func                       compare_function;
   float                                maximum_lod;
   float                                lod_bias;
   uint32_t                             maximum_anisotropy;
   enum mali_lod_algorithm              lod_algorithm;
   uint32_t                             border_color_r;
   uint32_t                             border_color_g;
   uint32_t                             border_color_b;
   uint32_t                             border_color_a;
};

#define MALI_SAMPLER_header                     \
   .type = MALI_DESCRIPTOR_TYPE_SAMPLER,  \
   .wrap_mode_r = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .wrap_mode_t = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .wrap_mode_s = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .round_to_nearest_even = true,  \
   .srgb_override = false,  \
   .seamless_cube_map = true,  \
   .normalized_coordinates = true,  \
   .clamp_integer_array_indices = true,  \
   .minify_nearest = false,  \
   .magnify_nearest = false,  \
   .magnify_cutoff = false,  \
   .mipmap_mode = MALI_MIPMAP_MODE_NEAREST,  \
   .minimum_lod = 0,  \
   .compare_function = MALI_FUNC_NEVER,  \
   .maximum_lod = 0,  \
   .lod_bias = 0,  \
   .maximum_anisotropy = 1,  \
   .lod_algorithm = MALI_LOD_ALGORITHM_ISOTROPIC,  \
   .border_color_r = 0.0,  \
   .border_color_g = 0.0,  \
   .border_color_b = 0.0,  \
   .border_color_a = 0.0

#define MALI_SAMPLER_LENGTH 32
#define MALI_SAMPLER_ALIGN 32
struct mali_sampler_packed { uint32_t opaque[8]; };
#define MALI_SAMPLER_PACKED_T struct mali_sampler_packed
#define MALI_SAMPLER_pack(__packed, __unpacked) \
do { \
   MALI_SAMPLER_PACKED_T __tmp_packed; \
   assert((__unpacked)->maximum_anisotropy >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->wrap_mode_r, 8, 11) | \
            util_bitpack_uint((__unpacked)->wrap_mode_t, 12, 15) | \
            util_bitpack_uint((__unpacked)->wrap_mode_s, 16, 19) | \
            util_bitpack_uint((__unpacked)->round_to_nearest_even, 21, 21) | \
            util_bitpack_uint((__unpacked)->srgb_override, 22, 22) | \
            util_bitpack_uint((__unpacked)->seamless_cube_map, 23, 23) | \
            util_bitpack_uint((__unpacked)->clamp_integer_coordinates, 24, 24) | \
            util_bitpack_uint((__unpacked)->normalized_coordinates, 25, 25) | \
            util_bitpack_uint((__unpacked)->clamp_integer_array_indices, 26, 26) | \
            util_bitpack_uint((__unpacked)->minify_nearest, 27, 27) | \
            util_bitpack_uint((__unpacked)->magnify_nearest, 28, 28) | \
            util_bitpack_uint((__unpacked)->magnify_cutoff, 29, 29) | \
            util_bitpack_uint((__unpacked)->mipmap_mode, 30, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_ufixed_clamp((__unpacked)->minimum_lod, 0, 12, 8) | \
            util_bitpack_uint((__unpacked)->compare_function, 13, 15) | \
            util_bitpack_ufixed_clamp((__unpacked)->maximum_lod, 16, 28, 8); \
   __tmp_packed.opaque[ 2] = util_bitpack_sfixed_clamp((__unpacked)->lod_bias, 0, 15, 8) | \
            util_bitpack_uint((__unpacked)->maximum_anisotropy - 1, 16, 20) | \
            util_bitpack_uint((__unpacked)->lod_algorithm, 24, 25); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->border_color_r, 0, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->border_color_g, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->border_color_b, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->border_color_a, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SAMPLER_unpack(__packed, __unpacked) \
do { \
   MALI_SAMPLER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x1000f0) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe0000000) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xfce00000) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 3\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->wrap_mode_r, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->wrap_mode_t, &__tmp_packed.opaque[0], 12, 15); \
   __gen_unpack_uint((__unpacked)->wrap_mode_s, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->round_to_nearest_even, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_uint((__unpacked)->srgb_override, &__tmp_packed.opaque[0], 22, 22); \
   __gen_unpack_uint((__unpacked)->seamless_cube_map, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->clamp_integer_coordinates, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->normalized_coordinates, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->clamp_integer_array_indices, &__tmp_packed.opaque[0], 26, 26); \
   __gen_unpack_uint((__unpacked)->minify_nearest, &__tmp_packed.opaque[0], 27, 27); \
   __gen_unpack_uint((__unpacked)->magnify_nearest, &__tmp_packed.opaque[0], 28, 28); \
   __gen_unpack_uint((__unpacked)->magnify_cutoff, &__tmp_packed.opaque[0], 29, 29); \
   __gen_unpack_uint((__unpacked)->mipmap_mode, &__tmp_packed.opaque[0], 30, 31); \
   __gen_unpack_ulod((__unpacked)->minimum_lod, &__tmp_packed.opaque[0], 32, 44); \
   __gen_unpack_uint((__unpacked)->compare_function, &__tmp_packed.opaque[0], 45, 47); \
   __gen_unpack_ulod((__unpacked)->maximum_lod, &__tmp_packed.opaque[0], 48, 60); \
   __gen_unpack_slod((__unpacked)->lod_bias, &__tmp_packed.opaque[0], 64, 79); \
   __gen_unpack_uint((__unpacked)->maximum_anisotropy, &__tmp_packed.opaque[0], 80, 84); \
   (__unpacked)->maximum_anisotropy = (__unpacked)->maximum_anisotropy + 1; \
   __gen_unpack_uint((__unpacked)->lod_algorithm, &__tmp_packed.opaque[0], 88, 89); \
   __gen_unpack_uint((__unpacked)->border_color_r, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->border_color_g, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->border_color_b, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->border_color_a, &__tmp_packed.opaque[0], 224, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SAMPLER_print(FILE *fp, const struct MALI_SAMPLER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sWrap Mode R: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_r));
   fprintf(fp, "%*sWrap Mode T: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_t));
   fprintf(fp, "%*sWrap Mode S: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_s));
   fprintf(fp, "%*sRound to nearest even: %s\n", indent, "", values->round_to_nearest_even ? "true" : "false");
   fprintf(fp, "%*ssRGB override: %s\n", indent, "", values->srgb_override ? "true" : "false");
   fprintf(fp, "%*sSeamless Cube Map: %s\n", indent, "", values->seamless_cube_map ? "true" : "false");
   fprintf(fp, "%*sClamp integer coordinates: %s\n", indent, "", values->clamp_integer_coordinates ? "true" : "false");
   fprintf(fp, "%*sNormalized Coordinates: %s\n", indent, "", values->normalized_coordinates ? "true" : "false");
   fprintf(fp, "%*sClamp integer array indices: %s\n", indent, "", values->clamp_integer_array_indices ? "true" : "false");
   fprintf(fp, "%*sMinify nearest: %s\n", indent, "", values->minify_nearest ? "true" : "false");
   fprintf(fp, "%*sMagnify nearest: %s\n", indent, "", values->magnify_nearest ? "true" : "false");
   fprintf(fp, "%*sMagnify cutoff: %s\n", indent, "", values->magnify_cutoff ? "true" : "false");
   fprintf(fp, "%*sMipmap Mode: %s\n", indent, "", mali_mipmap_mode_as_str(values->mipmap_mode));
   fprintf(fp, "%*sMinimum LOD: %f\n", indent, "", values->minimum_lod);
   fprintf(fp, "%*sCompare Function: %s\n", indent, "", mali_func_as_str(values->compare_function));
   fprintf(fp, "%*sMaximum LOD: %f\n", indent, "", values->maximum_lod);
   fprintf(fp, "%*sLOD bias: %f\n", indent, "", values->lod_bias);
   fprintf(fp, "%*sMaximum anisotropy: %u\n", indent, "", values->maximum_anisotropy);
   fprintf(fp, "%*sLOD algorithm: %s\n", indent, "", mali_lod_algorithm_as_str(values->lod_algorithm));
   fprintf(fp, "%*sBorder Color R: 0x%X (%f)\n", indent, "", values->border_color_r, uif(values->border_color_r));
   fprintf(fp, "%*sBorder Color G: 0x%X (%f)\n", indent, "", values->border_color_g, uif(values->border_color_g));
   fprintf(fp, "%*sBorder Color B: 0x%X (%f)\n", indent, "", values->border_color_b, uif(values->border_color_b));
   fprintf(fp, "%*sBorder Color A: 0x%X (%f)\n", indent, "", values->border_color_a, uif(values->border_color_a));
}

#endif
enum mali_plane_type {
        MALI_PLANE_TYPE_NULL                 =      0,
        MALI_PLANE_TYPE_GENERIC              =      1,
        MALI_PLANE_TYPE_ASTC_2D              =      4,
        MALI_PLANE_TYPE_ASTC_3D              =      5,
        MALI_PLANE_TYPE_AFBC                 =      6,
        MALI_PLANE_TYPE_CHROMA_2P            =      8,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_plane_type_as_str(enum mali_plane_type imm)
{
    switch (imm) {
    case MALI_PLANE_TYPE_NULL: return "Null";
    case MALI_PLANE_TYPE_GENERIC: return "Generic";
    case MALI_PLANE_TYPE_ASTC_2D: return "ASTC 2D";
    case MALI_PLANE_TYPE_ASTC_3D: return "ASTC 3D";
    case MALI_PLANE_TYPE_AFBC: return "AFBC";
    case MALI_PLANE_TYPE_CHROMA_2P: return "Chroma 2p";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_clump_ordering {
        MALI_CLUMP_ORDERING_TILED_U_INTERLEAVED =      1,
        MALI_CLUMP_ORDERING_LINEAR           =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_clump_ordering_as_str(enum mali_clump_ordering imm)
{
    switch (imm) {
    case MALI_CLUMP_ORDERING_TILED_U_INTERLEAVED: return "Tiled U-Interleaved";
    case MALI_CLUMP_ORDERING_LINEAR: return "Linear";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_clump_format {
        MALI_CLUMP_FORMAT_RAW8               =      0,
        MALI_CLUMP_FORMAT_RAW16              =      1,
        MALI_CLUMP_FORMAT_RAW32              =      2,
        MALI_CLUMP_FORMAT_RAW64              =      3,
        MALI_CLUMP_FORMAT_RAW128             =      4,
        MALI_CLUMP_FORMAT_RAW24              =      8,
        MALI_CLUMP_FORMAT_RAW48              =      9,
        MALI_CLUMP_FORMAT_RAW96              =     10,
        MALI_CLUMP_FORMAT_D32X32             =     16,
        MALI_CLUMP_FORMAT_X32D32             =     17,
        MALI_CLUMP_FORMAT_X32S8X24           =     18,
        MALI_CLUMP_FORMAT_X24S8X32           =     19,
        MALI_CLUMP_FORMAT_X24S8              =     20,
        MALI_CLUMP_FORMAT_S8X24              =     21,
        MALI_CLUMP_FORMAT_S8                 =     22,
        MALI_CLUMP_FORMAT_L4A4               =     24,
        MALI_CLUMP_FORMAT_L8A8               =     25,
        MALI_CLUMP_FORMAT_A8                 =     26,
        MALI_CLUMP_FORMAT_ETC2_RGB8          =     32,
        MALI_CLUMP_FORMAT_ETC2_R11_UNORM     =     33,
        MALI_CLUMP_FORMAT_ETC2_R11_SNORM     =     34,
        MALI_CLUMP_FORMAT_ETC2_RG11_UNORM    =     35,
        MALI_CLUMP_FORMAT_ETC2_RG11_SNORM    =     36,
        MALI_CLUMP_FORMAT_ETC2_RGBA8         =     37,
        MALI_CLUMP_FORMAT_ETC2_RGB8A1        =     38,
        MALI_CLUMP_FORMAT_BC1_UNORM          =     48,
        MALI_CLUMP_FORMAT_BC2_UNORM          =     49,
        MALI_CLUMP_FORMAT_BC3_UNORM          =     50,
        MALI_CLUMP_FORMAT_BC4_UNORM          =     51,
        MALI_CLUMP_FORMAT_BC4_SNORM          =     52,
        MALI_CLUMP_FORMAT_BC5_UNORM          =     53,
        MALI_CLUMP_FORMAT_BC5_SNORM          =     54,
        MALI_CLUMP_FORMAT_BC6H_UF16          =     55,
        MALI_CLUMP_FORMAT_BC6H_SF16          =     56,
        MALI_CLUMP_FORMAT_BC7_UNORM          =     57,
        MALI_CLUMP_FORMAT_Y8_UV8_422         =     64,
        MALI_CLUMP_FORMAT_Y10_UV10_422       =     65,
        MALI_CLUMP_FORMAT_Y16_UV16_422       =     67,
        MALI_CLUMP_FORMAT_Y8_UV8_420         =     72,
        MALI_CLUMP_FORMAT_Y10_UV10_420       =     73,
        MALI_CLUMP_FORMAT_Y16_UV16_420       =     75,
        MALI_CLUMP_FORMAT_YUV420_10X6        =     76,
        MALI_CLUMP_FORMAT_RAW10              =    120,
        MALI_CLUMP_FORMAT_RAW12              =    121,
        MALI_CLUMP_FORMAT_R8G8B8G8           =    124,
        MALI_CLUMP_FORMAT_G8R8G8B8           =    125,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_clump_format_as_str(enum mali_clump_format imm)
{
    switch (imm) {
    case MALI_CLUMP_FORMAT_RAW8: return "RAW8";
    case MALI_CLUMP_FORMAT_RAW16: return "RAW16";
    case MALI_CLUMP_FORMAT_RAW32: return "RAW32";
    case MALI_CLUMP_FORMAT_RAW64: return "RAW64";
    case MALI_CLUMP_FORMAT_RAW128: return "RAW128";
    case MALI_CLUMP_FORMAT_RAW24: return "RAW24";
    case MALI_CLUMP_FORMAT_RAW48: return "RAW48";
    case MALI_CLUMP_FORMAT_RAW96: return "RAW96";
    case MALI_CLUMP_FORMAT_D32X32: return "D32X32";
    case MALI_CLUMP_FORMAT_X32D32: return "X32D32";
    case MALI_CLUMP_FORMAT_X32S8X24: return "X32S8X24";
    case MALI_CLUMP_FORMAT_X24S8X32: return "X24S8X32";
    case MALI_CLUMP_FORMAT_X24S8: return "X24S8";
    case MALI_CLUMP_FORMAT_S8X24: return "S8X24";
    case MALI_CLUMP_FORMAT_S8: return "S8";
    case MALI_CLUMP_FORMAT_L4A4: return "L4A4";
    case MALI_CLUMP_FORMAT_L8A8: return "L8A8";
    case MALI_CLUMP_FORMAT_A8: return "A8";
    case MALI_CLUMP_FORMAT_ETC2_RGB8: return "ETC2 RGB8";
    case MALI_CLUMP_FORMAT_ETC2_R11_UNORM: return "ETC2 R11 UNORM";
    case MALI_CLUMP_FORMAT_ETC2_R11_SNORM: return "ETC2 R11 SNORM";
    case MALI_CLUMP_FORMAT_ETC2_RG11_UNORM: return "ETC2 RG11 UNORM";
    case MALI_CLUMP_FORMAT_ETC2_RG11_SNORM: return "ETC2 RG11 SNORM";
    case MALI_CLUMP_FORMAT_ETC2_RGBA8: return "ETC2 RGBA8";
    case MALI_CLUMP_FORMAT_ETC2_RGB8A1: return "ETC2 RGB8A1";
    case MALI_CLUMP_FORMAT_BC1_UNORM: return "BC1 UNORM";
    case MALI_CLUMP_FORMAT_BC2_UNORM: return "BC2 UNORM";
    case MALI_CLUMP_FORMAT_BC3_UNORM: return "BC3 UNORM";
    case MALI_CLUMP_FORMAT_BC4_UNORM: return "BC4 UNORM";
    case MALI_CLUMP_FORMAT_BC4_SNORM: return "BC4 SNORM";
    case MALI_CLUMP_FORMAT_BC5_UNORM: return "BC5 UNORM";
    case MALI_CLUMP_FORMAT_BC5_SNORM: return "BC5 SNORM";
    case MALI_CLUMP_FORMAT_BC6H_UF16: return "BC6H UF16";
    case MALI_CLUMP_FORMAT_BC6H_SF16: return "BC6H SF16";
    case MALI_CLUMP_FORMAT_BC7_UNORM: return "BC7 UNORM";
    case MALI_CLUMP_FORMAT_Y8_UV8_422: return "Y8 UV8 422";
    case MALI_CLUMP_FORMAT_Y10_UV10_422: return "Y10 UV10 422";
    case MALI_CLUMP_FORMAT_Y16_UV16_422: return "Y16 UV16 422";
    case MALI_CLUMP_FORMAT_Y8_UV8_420: return "Y8 UV8 420";
    case MALI_CLUMP_FORMAT_Y10_UV10_420: return "Y10 UV10 420";
    case MALI_CLUMP_FORMAT_Y16_UV16_420: return "Y16 UV16 420";
    case MALI_CLUMP_FORMAT_YUV420_10X6: return "YUV420 10x6";
    case MALI_CLUMP_FORMAT_RAW10: return "RAW10";
    case MALI_CLUMP_FORMAT_RAW12: return "RAW12";
    case MALI_CLUMP_FORMAT_R8G8B8G8: return "R8G8B8G8";
    case MALI_CLUMP_FORMAT_G8R8G8B8: return "G8R8G8B8";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_afbc_superblock_size {
        MALI_AFBC_SUPERBLOCK_SIZE_16X16      =      0,
        MALI_AFBC_SUPERBLOCK_SIZE_32X8       =      1,
        MALI_AFBC_SUPERBLOCK_SIZE_64X4       =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_afbc_superblock_size_as_str(enum mali_afbc_superblock_size imm)
{
    switch (imm) {
    case MALI_AFBC_SUPERBLOCK_SIZE_16X16: return "16x16";
    case MALI_AFBC_SUPERBLOCK_SIZE_32X8: return "32x8";
    case MALI_AFBC_SUPERBLOCK_SIZE_64X4: return "64x4";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_afbc_compression_mode {
        MALI_AFBC_COMPRESSION_MODE_R8        =      0,
        MALI_AFBC_COMPRESSION_MODE_R8G8      =      3,
        MALI_AFBC_COMPRESSION_MODE_R5G6B5    =      4,
        MALI_AFBC_COMPRESSION_MODE_R4G4B4A4  =      5,
        MALI_AFBC_COMPRESSION_MODE_R5G5B5A1  =      6,
        MALI_AFBC_COMPRESSION_MODE_R8G8B8    =      9,
        MALI_AFBC_COMPRESSION_MODE_R8G8B8A8  =     10,
        MALI_AFBC_COMPRESSION_MODE_R10G10B10A2 =     11,
        MALI_AFBC_COMPRESSION_MODE_R11G11B10 =     12,
        MALI_AFBC_COMPRESSION_MODE_S8        =     14,
        MALI_AFBC_COMPRESSION_MODE_X24S8     =     15,
        MALI_AFBC_COMPRESSION_MODE_YUV420_6C8 =     32,
        MALI_AFBC_COMPRESSION_MODE_YUV420_2C8 =     34,
        MALI_AFBC_COMPRESSION_MODE_YUV420_1C8 =     35,
        MALI_AFBC_COMPRESSION_MODE_YUV422_4C8 =     37,
        MALI_AFBC_COMPRESSION_MODE_YUV422_2C8 =     38,
        MALI_AFBC_COMPRESSION_MODE_YUV422_1C8 =     39,
        MALI_AFBC_COMPRESSION_MODE_YUV420_6C10 =     40,
        MALI_AFBC_COMPRESSION_MODE_YUV420_2C10 =     42,
        MALI_AFBC_COMPRESSION_MODE_YUV420_1C10 =     43,
        MALI_AFBC_COMPRESSION_MODE_YUV422_4C10 =     45,
        MALI_AFBC_COMPRESSION_MODE_YUV422_2C10 =     46,
        MALI_AFBC_COMPRESSION_MODE_YUV422_1C10 =     47,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_afbc_compression_mode_as_str(enum mali_afbc_compression_mode imm)
{
    switch (imm) {
    case MALI_AFBC_COMPRESSION_MODE_R8: return "R8";
    case MALI_AFBC_COMPRESSION_MODE_R8G8: return "R8G8";
    case MALI_AFBC_COMPRESSION_MODE_R5G6B5: return "R5G6B5";
    case MALI_AFBC_COMPRESSION_MODE_R4G4B4A4: return "R4G4B4A4";
    case MALI_AFBC_COMPRESSION_MODE_R5G5B5A1: return "R5G5B5A1";
    case MALI_AFBC_COMPRESSION_MODE_R8G8B8: return "R8G8B8";
    case MALI_AFBC_COMPRESSION_MODE_R8G8B8A8: return "R8G8B8A8";
    case MALI_AFBC_COMPRESSION_MODE_R10G10B10A2: return "R10G10B10A2";
    case MALI_AFBC_COMPRESSION_MODE_R11G11B10: return "R11G11B10";
    case MALI_AFBC_COMPRESSION_MODE_S8: return "S8";
    case MALI_AFBC_COMPRESSION_MODE_X24S8: return "X24S8";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_6C8: return "YUV420 6c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_2C8: return "YUV420 2c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_1C8: return "YUV420 1c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_4C8: return "YUV422 4c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_2C8: return "YUV422 2c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_1C8: return "YUV422 1c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_6C10: return "YUV420 6c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_2C10: return "YUV420 2c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_1C10: return "YUV420 1c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_4C10: return "YUV422 4c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_2C10: return "YUV422 2c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_1C10: return "YUV422 1c10";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_TEXTURE {
   enum mali_descriptor_type            type;
   enum mali_texture_dimension          dimension;
   bool                                 sample_corner_position;
   bool                                 normalize_coordinates;
   uint32_t                             format;
   uint32_t                             width;
   uint32_t                             height;
   uint32_t                             swizzle;
   bool                                 texel_interleave;
   uint32_t                             levels;
   uint32_t                             minimum_level;
   float                                minimum_lod;
   uint32_t                             sample_count;
   float                                maximum_lod;
   uint64_t                             surfaces;
   uint32_t                             array_size;
   uint32_t                             depth;
};

#define MALI_TEXTURE_header                     \
   .type = MALI_DESCRIPTOR_TYPE_TEXTURE,  \
   .sample_corner_position = false,  \
   .normalize_coordinates = false,  \
   .levels = 1,  \
   .minimum_lod = 0,  \
   .sample_count = 1,  \
   .maximum_lod = 0,  \
   .array_size = 1,  \
   .depth = 1

#define MALI_TEXTURE_LENGTH 32
#define MALI_TEXTURE_ALIGN 32
struct mali_texture_packed { uint32_t opaque[8]; };
#define MALI_TEXTURE_PACKED_T struct mali_texture_packed
#define MALI_TEXTURE_pack(__packed, __unpacked) \
do { \
   MALI_TEXTURE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   assert((__unpacked)->levels >= 1); \
   assert(IS_POT_NONZERO((__unpacked)->sample_count)); \
   assert((__unpacked)->array_size >= 1); \
   assert((__unpacked)->depth >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->dimension, 4, 6) | \
            util_bitpack_uint((__unpacked)->sample_corner_position, 8, 8) | \
            util_bitpack_uint((__unpacked)->normalize_coordinates, 9, 9) | \
            util_bitpack_uint((__unpacked)->format, 10, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->swizzle, 0, 11) | \
            util_bitpack_uint((__unpacked)->texel_interleave, 12, 12) | \
            util_bitpack_uint((__unpacked)->levels - 1, 16, 20) | \
            util_bitpack_uint((__unpacked)->minimum_level, 24, 28); \
   __tmp_packed.opaque[ 3] = util_bitpack_ufixed_clamp((__unpacked)->minimum_lod, 0, 12, 8) | \
            util_bitpack_uint(util_logbase2((__unpacked)->sample_count), 13, 15) | \
            util_bitpack_ufixed_clamp((__unpacked)->maximum_lod, 16, 28, 8); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->surfaces, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->surfaces, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->array_size - 1, 0, 15); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->depth - 1, 0, 15); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TEXTURE_unpack(__packed, __unpacked) \
do { \
   MALI_TEXTURE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x80) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 0\n"); \
   if (__tmp_packed.opaque[2] & 0xe0e0e000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xe0000000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 3\n"); \
   if (__tmp_packed.opaque[6] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->dimension, &__tmp_packed.opaque[0], 4, 6); \
   __gen_unpack_uint((__unpacked)->sample_corner_position, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->normalize_coordinates, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 10, 31); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 32, 47); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 48, 63); \
   (__unpacked)->height = (__unpacked)->height + 1; \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 64, 75); \
   __gen_unpack_uint((__unpacked)->texel_interleave, &__tmp_packed.opaque[0], 76, 76); \
   __gen_unpack_uint((__unpacked)->levels, &__tmp_packed.opaque[0], 80, 84); \
   (__unpacked)->levels = (__unpacked)->levels + 1; \
   __gen_unpack_uint((__unpacked)->minimum_level, &__tmp_packed.opaque[0], 88, 92); \
   __gen_unpack_ulod((__unpacked)->minimum_lod, &__tmp_packed.opaque[0], 96, 108); \
   __gen_unpack_uint((__unpacked)->sample_count, &__tmp_packed.opaque[0], 109, 111); \
   (__unpacked)->sample_count = 1U << (__unpacked)->sample_count; \
   __gen_unpack_ulod((__unpacked)->maximum_lod, &__tmp_packed.opaque[0], 112, 124); \
   __gen_unpack_uint((__unpacked)->surfaces, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->array_size, &__tmp_packed.opaque[0], 192, 207); \
   (__unpacked)->array_size = (__unpacked)->array_size + 1; \
   __gen_unpack_uint((__unpacked)->depth, &__tmp_packed.opaque[0], 224, 239); \
   (__unpacked)->depth = (__unpacked)->depth + 1; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TEXTURE_print(FILE *fp, const struct MALI_TEXTURE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sDimension: %s\n", indent, "", mali_texture_dimension_as_str(values->dimension));
   fprintf(fp, "%*sSample corner position: %s\n", indent, "", values->sample_corner_position ? "true" : "false");
   fprintf(fp, "%*sNormalize coordinates: %s\n", indent, "", values->normalize_coordinates ? "true" : "false");
   mali_pixel_format_print(fp, values->format);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sTexel interleave: %s\n", indent, "", values->texel_interleave ? "true" : "false");
   fprintf(fp, "%*sLevels: %u\n", indent, "", values->levels);
   fprintf(fp, "%*sMinimum level: %u\n", indent, "", values->minimum_level);
   fprintf(fp, "%*sMinimum LOD: %f\n", indent, "", values->minimum_lod);
   fprintf(fp, "%*sSample count: %u\n", indent, "", values->sample_count);
   fprintf(fp, "%*sMaximum LOD: %f\n", indent, "", values->maximum_lod);
   fprintf(fp, "%*sSurfaces: 0x%" PRIx64 "\n", indent, "", values->surfaces);
   fprintf(fp, "%*sArray size: %u\n", indent, "", values->array_size);
   fprintf(fp, "%*sDepth: %u\n", indent, "", values->depth);
}

#endif
struct MALI_PLANE_HEADER {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   uint32_t                             ignore;
};

#define MALI_PLANE_HEADER_header                \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_NULL

#define MALI_PLANE_HEADER_LENGTH 4
#define MALI_PLANE_HEADER_ALIGN 32
struct mali_plane_header_packed { uint32_t opaque[1]; };
#define MALI_PLANE_HEADER_PACKED_T struct mali_plane_header_packed
#define MALI_PLANE_HEADER_pack(__packed, __unpacked) \
do { \
   MALI_PLANE_HEADER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->ignore, 8, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PLANE_HEADER_unpack(__packed, __unpacked) \
do { \
   MALI_PLANE_HEADER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->ignore, &__tmp_packed.opaque[0], 8, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PLANE_HEADER_print(FILE *fp, const struct MALI_PLANE_HEADER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sIgnore: %u\n", indent, "", values->ignore);
}

#endif
struct MALI_NULL_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
};

#define MALI_NULL_PLANE_header                  \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_NULL

#define MALI_NULL_PLANE_LENGTH 32
#define MALI_NULL_PLANE_ALIGN 32
struct mali_null_plane_packed { uint32_t opaque[8]; };
#define MALI_NULL_PLANE_PACKED_T struct mali_null_plane_packed
#define MALI_NULL_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_NULL_PLANE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_NULL_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_NULL_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_NULL_PLANE_print(FILE *fp, const struct MALI_NULL_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
}

#endif
struct MALI_GENERIC_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_clump_ordering             clump_ordering;
   enum mali_clump_format               clump_format;
   uint64_t                             size;
   uint64_t                             pointer;
   uint64_t                             row_stride;
   uint64_t                             slice_stride;
};

#define MALI_GENERIC_PLANE_header               \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_GENERIC

#define MALI_GENERIC_PLANE_LENGTH 32
#define MALI_GENERIC_PLANE_ALIGN 32
struct mali_generic_plane_packed { uint32_t opaque[8]; };
#define MALI_GENERIC_PLANE_PACKED_T struct mali_generic_plane_packed
#define MALI_GENERIC_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_GENERIC_PLANE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->clump_ordering, 8, 11) | \
            util_bitpack_uint((__unpacked)->clump_format, 24, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_GENERIC_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_GENERIC_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff000) fprintf(stderr, "XXX: Invalid field of Generic Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Generic Plane unpacked at word 5\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Generic Plane unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->clump_ordering, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->clump_format, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->slice_stride, &__tmp_packed.opaque[0], 192, 223); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_GENERIC_PLANE_print(FILE *fp, const struct MALI_GENERIC_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sClump ordering: %s\n", indent, "", mali_clump_ordering_as_str(values->clump_ordering));
   fprintf(fp, "%*sClump format: %s\n", indent, "", mali_clump_format_as_str(values->clump_format));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sRow stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSlice stride: 0x%" PRIx64 "\n", indent, "", values->slice_stride);
}

#endif
struct MALI_ASTC_2D_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_clump_ordering             clump_ordering;
   bool                                 decode_hdr;
   bool                                 decode_wide;
   enum mali_astc_2d_dimension          block_width;
   enum mali_astc_2d_dimension          block_height;
   uint64_t                             size;
   uint64_t                             pointer;
   uint64_t                             row_stride;
   uint64_t                             slice_stride;
};

#define MALI_ASTC_2D_PLANE_header               \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_ASTC_2D

#define MALI_ASTC_2D_PLANE_LENGTH 32
#define MALI_ASTC_2D_PLANE_ALIGN 32
struct mali_astc_2d_plane_packed { uint32_t opaque[8]; };
#define MALI_ASTC_2D_PLANE_PACKED_T struct mali_astc_2d_plane_packed
#define MALI_ASTC_2D_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_ASTC_2D_PLANE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->clump_ordering, 8, 11) | \
            util_bitpack_uint((__unpacked)->decode_hdr, 24, 24) | \
            util_bitpack_uint((__unpacked)->decode_wide, 25, 25) | \
            util_bitpack_uint((__unpacked)->block_width, 26, 28) | \
            util_bitpack_uint((__unpacked)->block_height, 29, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ASTC_2D_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_ASTC_2D_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff000) fprintf(stderr, "XXX: Invalid field of ASTC 2D Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ASTC 2D Plane unpacked at word 5\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ASTC 2D Plane unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->clump_ordering, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->decode_hdr, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->decode_wide, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->block_width, &__tmp_packed.opaque[0], 26, 28); \
   __gen_unpack_uint((__unpacked)->block_height, &__tmp_packed.opaque[0], 29, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->slice_stride, &__tmp_packed.opaque[0], 192, 223); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ASTC_2D_PLANE_print(FILE *fp, const struct MALI_ASTC_2D_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sClump ordering: %s\n", indent, "", mali_clump_ordering_as_str(values->clump_ordering));
   fprintf(fp, "%*sDecode HDR: %s\n", indent, "", values->decode_hdr ? "true" : "false");
   fprintf(fp, "%*sDecode Wide: %s\n", indent, "", values->decode_wide ? "true" : "false");
   fprintf(fp, "%*sBlock width: %s\n", indent, "", mali_astc_2d_dimension_as_str(values->block_width));
   fprintf(fp, "%*sBlock height: %s\n", indent, "", mali_astc_2d_dimension_as_str(values->block_height));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sRow stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSlice stride: 0x%" PRIx64 "\n", indent, "", values->slice_stride);
}

#endif
struct MALI_ASTC_3D_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_clump_ordering             clump_ordering;
   bool                                 decode_hdr;
   bool                                 decode_wide;
   enum mali_astc_3d_dimension          block_width;
   enum mali_astc_3d_dimension          block_height;
   enum mali_astc_3d_dimension          block_depth;
   uint64_t                             size;
   uint64_t                             pointer;
   uint64_t                             row_stride;
   uint64_t                             slice_stride;
};

#define MALI_ASTC_3D_PLANE_header               \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_ASTC_3D

#define MALI_ASTC_3D_PLANE_LENGTH 32
#define MALI_ASTC_3D_PLANE_ALIGN 32
struct mali_astc_3d_plane_packed { uint32_t opaque[8]; };
#define MALI_ASTC_3D_PLANE_PACKED_T struct mali_astc_3d_plane_packed
#define MALI_ASTC_3D_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_ASTC_3D_PLANE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->clump_ordering, 8, 11) | \
            util_bitpack_uint((__unpacked)->decode_hdr, 24, 24) | \
            util_bitpack_uint((__unpacked)->decode_wide, 25, 25) | \
            util_bitpack_uint((__unpacked)->block_width, 26, 27) | \
            util_bitpack_uint((__unpacked)->block_height, 28, 29) | \
            util_bitpack_uint((__unpacked)->block_depth, 30, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ASTC_3D_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_ASTC_3D_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff000) fprintf(stderr, "XXX: Invalid field of ASTC 3D Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ASTC 3D Plane unpacked at word 5\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ASTC 3D Plane unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->clump_ordering, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->decode_hdr, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->decode_wide, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->block_width, &__tmp_packed.opaque[0], 26, 27); \
   __gen_unpack_uint((__unpacked)->block_height, &__tmp_packed.opaque[0], 28, 29); \
   __gen_unpack_uint((__unpacked)->block_depth, &__tmp_packed.opaque[0], 30, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->slice_stride, &__tmp_packed.opaque[0], 192, 223); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ASTC_3D_PLANE_print(FILE *fp, const struct MALI_ASTC_3D_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sClump ordering: %s\n", indent, "", mali_clump_ordering_as_str(values->clump_ordering));
   fprintf(fp, "%*sDecode HDR: %s\n", indent, "", values->decode_hdr ? "true" : "false");
   fprintf(fp, "%*sDecode Wide: %s\n", indent, "", values->decode_wide ? "true" : "false");
   fprintf(fp, "%*sBlock width: %s\n", indent, "", mali_astc_3d_dimension_as_str(values->block_width));
   fprintf(fp, "%*sBlock height: %s\n", indent, "", mali_astc_3d_dimension_as_str(values->block_height));
   fprintf(fp, "%*sBlock depth: %s\n", indent, "", mali_astc_3d_dimension_as_str(values->block_depth));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sRow stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSlice stride: 0x%" PRIx64 "\n", indent, "", values->slice_stride);
}

#endif
struct MALI_AFBC_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_afbc_superblock_size       superblock_size;
   bool                                 ytr;
   bool                                 split_block;
   bool                                 alpha_hint;
   bool                                 tiled_header;
   bool                                 prefetch;
   enum mali_afbc_compression_mode      compression_mode;
   uint64_t                             size;
   uint64_t                             pointer;
   uint64_t                             header_row_stride;
   uint64_t                             header_slice_size;
   uint64_t                             header_slice_stride;
};

#define MALI_AFBC_PLANE_header                  \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_AFBC

#define MALI_AFBC_PLANE_LENGTH 32
#define MALI_AFBC_PLANE_ALIGN 32
struct mali_afbc_plane_packed { uint32_t opaque[8]; };
#define MALI_AFBC_PLANE_PACKED_T struct mali_afbc_plane_packed
#define MALI_AFBC_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_PLANE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->superblock_size, 8, 10) | \
            util_bitpack_uint((__unpacked)->ytr, 16, 16) | \
            util_bitpack_uint((__unpacked)->split_block, 17, 17) | \
            util_bitpack_uint((__unpacked)->alpha_hint, 18, 18) | \
            util_bitpack_uint((__unpacked)->tiled_header, 19, 19) | \
            util_bitpack_uint((__unpacked)->prefetch, 20, 20) | \
            util_bitpack_uint((__unpacked)->compression_mode, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->header_row_stride, 0, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->header_slice_size, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->header_slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3e0f800) fprintf(stderr, "XXX: Invalid field of AFBC Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC Plane unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->superblock_size, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->ytr, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->split_block, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->alpha_hint, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->tiled_header, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->prefetch, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->compression_mode, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->header_row_stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->header_slice_size, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->header_slice_stride, &__tmp_packed.opaque[0], 192, 223); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_PLANE_print(FILE *fp, const struct MALI_AFBC_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sSuperblock size: %s\n", indent, "", mali_afbc_superblock_size_as_str(values->superblock_size));
   fprintf(fp, "%*sYTR: %s\n", indent, "", values->ytr ? "true" : "false");
   fprintf(fp, "%*sSplit block: %s\n", indent, "", values->split_block ? "true" : "false");
   fprintf(fp, "%*sAlpha hint: %s\n", indent, "", values->alpha_hint ? "true" : "false");
   fprintf(fp, "%*sTiled header: %s\n", indent, "", values->tiled_header ? "true" : "false");
   fprintf(fp, "%*sPrefetch: %s\n", indent, "", values->prefetch ? "true" : "false");
   fprintf(fp, "%*sCompression mode: %s\n", indent, "", mali_afbc_compression_mode_as_str(values->compression_mode));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sHeader row stride: 0x%" PRIx64 "\n", indent, "", values->header_row_stride);
   fprintf(fp, "%*sHeader slice size: 0x%" PRIx64 "\n", indent, "", values->header_slice_size);
   fprintf(fp, "%*sHeader slice stride: 0x%" PRIx64 "\n", indent, "", values->header_slice_stride);
}

#endif
struct MALI_CHROMA_2P_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_clump_ordering             clump_ordering;
   enum mali_clump_format               clump_format;
   uint64_t                             size;
   uint64_t                             pointer;
   uint64_t                             row_stride;
   uint64_t                             secondary_pointer;
};

#define MALI_CHROMA_2P_PLANE_header             \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_CHROMA_2P

#define MALI_CHROMA_2P_PLANE_LENGTH 32
#define MALI_CHROMA_2P_PLANE_ALIGN 32
struct mali_chroma_2p_plane_packed { uint32_t opaque[8]; };
#define MALI_CHROMA_2P_PLANE_PACKED_T struct mali_chroma_2p_plane_packed
#define MALI_CHROMA_2P_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_CHROMA_2P_PLANE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->clump_ordering, 8, 11) | \
            util_bitpack_uint((__unpacked)->clump_format, 24, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->secondary_pointer, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->secondary_pointer, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CHROMA_2P_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_CHROMA_2P_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff000) fprintf(stderr, "XXX: Invalid field of Chroma 2p Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Chroma 2p Plane unpacked at word 5\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->clump_ordering, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->clump_format, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->secondary_pointer, &__tmp_packed.opaque[0], 192, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CHROMA_2P_PLANE_print(FILE *fp, const struct MALI_CHROMA_2P_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sClump ordering: %s\n", indent, "", mali_clump_ordering_as_str(values->clump_ordering));
   fprintf(fp, "%*sClump format: %s\n", indent, "", mali_clump_format_as_str(values->clump_format));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sRow stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSecondary Pointer: 0x%" PRIx64 "\n", indent, "", values->secondary_pointer);
}

#endif
enum mali_shader_register_allocation {
        MALI_SHADER_REGISTER_ALLOCATION_64_PER_THREAD =      0,
        MALI_SHADER_REGISTER_ALLOCATION_32_PER_THREAD =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_shader_register_allocation_as_str(enum mali_shader_register_allocation imm)
{
    switch (imm) {
    case MALI_SHADER_REGISTER_ALLOCATION_64_PER_THREAD: return "64 Per Thread";
    case MALI_SHADER_REGISTER_ALLOCATION_32_PER_THREAD: return "32 Per Thread";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_flush_to_zero_mode {
        MALI_FLUSH_TO_ZERO_MODE_PRESERVE_SUBNORMALS =      0,
        MALI_FLUSH_TO_ZERO_MODE_DX11         =      1,
        MALI_FLUSH_TO_ZERO_MODE_ALWAYS       =      2,
        MALI_FLUSH_TO_ZERO_MODE_ABRUPT       =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_flush_to_zero_mode_as_str(enum mali_flush_to_zero_mode imm)
{
    switch (imm) {
    case MALI_FLUSH_TO_ZERO_MODE_PRESERVE_SUBNORMALS: return "Preserve subnormals";
    case MALI_FLUSH_TO_ZERO_MODE_DX11: return "DX11";
    case MALI_FLUSH_TO_ZERO_MODE_ALWAYS: return "Always";
    case MALI_FLUSH_TO_ZERO_MODE_ABRUPT: return "Abrupt";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_PRELOAD {
   uint32_t                             r48_r63;
   bool                                 r55;
   bool                                 r56;
   bool                                 r57;
   bool                                 r58;
   bool                                 r59;
   bool                                 r60;
   bool                                 r61;
   bool                                 r62;
   bool                                 r63;
};

#define MALI_PRELOAD_header                     \
   0

#define MALI_PRELOAD_LENGTH 4
struct mali_preload_packed { uint32_t opaque[1]; };
#define MALI_PRELOAD_PACKED_T struct mali_preload_packed
#define MALI_PRELOAD_pack(__packed, __unpacked) \
do { \
   MALI_PRELOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->r48_r63, 0, 15) | \
            util_bitpack_uint((__unpacked)->r55, 7, 7) | \
            util_bitpack_uint((__unpacked)->r56, 8, 8) | \
            util_bitpack_uint((__unpacked)->r57, 9, 9) | \
            util_bitpack_uint((__unpacked)->r58, 10, 10) | \
            util_bitpack_uint((__unpacked)->r59, 11, 11) | \
            util_bitpack_uint((__unpacked)->r60, 12, 12) | \
            util_bitpack_uint((__unpacked)->r61, 13, 13) | \
            util_bitpack_uint((__unpacked)->r62, 14, 14) | \
            util_bitpack_uint((__unpacked)->r63, 15, 15); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRELOAD_unpack(__packed, __unpacked) \
do { \
   MALI_PRELOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Preload unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->r48_r63, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->r55, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->r56, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->r57, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->r58, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->r59, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->r60, &__tmp_packed.opaque[0], 12, 12); \
   __gen_unpack_uint((__unpacked)->r61, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->r62, &__tmp_packed.opaque[0], 14, 14); \
   __gen_unpack_uint((__unpacked)->r63, &__tmp_packed.opaque[0], 15, 15); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRELOAD_print(FILE *fp, const struct MALI_PRELOAD * values, unsigned indent)
{
   fprintf(fp, "%*sR48-R63: 0x%x\n", indent, "", values->r48_r63);
   fprintf(fp, "%*sR55: %s\n", indent, "", values->r55 ? "true" : "false");
   fprintf(fp, "%*sR56: %s\n", indent, "", values->r56 ? "true" : "false");
   fprintf(fp, "%*sR57: %s\n", indent, "", values->r57 ? "true" : "false");
   fprintf(fp, "%*sR58: %s\n", indent, "", values->r58 ? "true" : "false");
   fprintf(fp, "%*sR59: %s\n", indent, "", values->r59 ? "true" : "false");
   fprintf(fp, "%*sR60: %s\n", indent, "", values->r60 ? "true" : "false");
   fprintf(fp, "%*sR61: %s\n", indent, "", values->r61 ? "true" : "false");
   fprintf(fp, "%*sR62: %s\n", indent, "", values->r62 ? "true" : "false");
   fprintf(fp, "%*sR63: %s\n", indent, "", values->r63 ? "true" : "false");
}

#endif
enum mali_coverage_bitmask_type {
        MALI_COVERAGE_BITMASK_TYPE_DX        =      0,
        MALI_COVERAGE_BITMASK_TYPE_GL        =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_coverage_bitmask_type_as_str(enum mali_coverage_bitmask_type imm)
{
    switch (imm) {
    case MALI_COVERAGE_BITMASK_TYPE_DX: return "DX";
    case MALI_COVERAGE_BITMASK_TYPE_GL: return "GL";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_warp_limit {
        MALI_WARP_LIMIT_FULL                 =      0,
        MALI_WARP_LIMIT_HALF                 =      1,
        MALI_WARP_LIMIT_ONE_QUARTER          =      2,
        MALI_WARP_LIMIT_ONE_HEIGHT           =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_warp_limit_as_str(enum mali_warp_limit imm)
{
    switch (imm) {
    case MALI_WARP_LIMIT_FULL: return "Full";
    case MALI_WARP_LIMIT_HALF: return "Half";
    case MALI_WARP_LIMIT_ONE_QUARTER: return "One-quarter";
    case MALI_WARP_LIMIT_ONE_HEIGHT: return "One-height";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_SHADER_PROGRAM {
   enum mali_descriptor_type            type;
   enum mali_shader_stage               stage;
   enum mali_coverage_bitmask_type      fragment_coverage_bitmask_type;
   enum mali_warp_limit                 vertex_warp_limit;
   bool                                 suppress_nan;
   enum mali_flush_to_zero_mode         flush_to_zero_mode;
   bool                                 suppress_inf;
   bool                                 requires_helper_threads;
   bool                                 shader_contains_jump_ex;
   enum mali_shader_register_allocation register_allocation;
   struct MALI_PRELOAD                  preload;
   uint64_t                             binary;
};

#define MALI_SHADER_PROGRAM_header              \
   .type = MALI_DESCRIPTOR_TYPE_SHADER,  \
   .preload = { MALI_PRELOAD_header }

#define MALI_SHADER_PROGRAM_LENGTH 32
#define MALI_SHADER_PROGRAM_ALIGN 32
struct mali_shader_program_packed { uint32_t opaque[8]; };
#define MALI_SHADER_PROGRAM_PACKED_T struct mali_shader_program_packed
#define MALI_SHADER_PROGRAM_pack(__packed, __unpacked) \
do { \
   MALI_SHADER_PROGRAM_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->stage, 4, 7) | \
            util_bitpack_uint((__unpacked)->fragment_coverage_bitmask_type, 8, 8) | \
            util_bitpack_uint((__unpacked)->vertex_warp_limit, 8, 9) | \
            util_bitpack_uint((__unpacked)->suppress_nan, 16, 16) | \
            util_bitpack_uint((__unpacked)->flush_to_zero_mode, 17, 18) | \
            util_bitpack_uint((__unpacked)->suppress_inf, 19, 19) | \
            util_bitpack_uint((__unpacked)->requires_helper_threads, 28, 28) | \
            util_bitpack_uint((__unpacked)->shader_contains_jump_ex, 29, 29) | \
            util_bitpack_uint((__unpacked)->register_allocation, 30, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->preload.r48_r63, 0, 15) | \
            util_bitpack_uint((__unpacked)->preload.r55, 7, 7) | \
            util_bitpack_uint((__unpacked)->preload.r56, 8, 8) | \
            util_bitpack_uint((__unpacked)->preload.r57, 9, 9) | \
            util_bitpack_uint((__unpacked)->preload.r58, 10, 10) | \
            util_bitpack_uint((__unpacked)->preload.r59, 11, 11) | \
            util_bitpack_uint((__unpacked)->preload.r60, 12, 12) | \
            util_bitpack_uint((__unpacked)->preload.r61, 13, 13) | \
            util_bitpack_uint((__unpacked)->preload.r62, 14, 14) | \
            util_bitpack_uint((__unpacked)->preload.r63, 15, 15); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->binary, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->binary, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SHADER_PROGRAM_unpack(__packed, __unpacked) \
do { \
   MALI_SHADER_PROGRAM_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0fc00) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 1\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->stage, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->fragment_coverage_bitmask_type, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->vertex_warp_limit, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->suppress_nan, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->flush_to_zero_mode, &__tmp_packed.opaque[0], 17, 18); \
   __gen_unpack_uint((__unpacked)->suppress_inf, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->requires_helper_threads, &__tmp_packed.opaque[0], 28, 28); \
   __gen_unpack_uint((__unpacked)->shader_contains_jump_ex, &__tmp_packed.opaque[0], 29, 29); \
   __gen_unpack_uint((__unpacked)->register_allocation, &__tmp_packed.opaque[0], 30, 31); \
   __gen_unpack_uint((__unpacked)->preload.r48_r63, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_uint((__unpacked)->preload.r55, &__tmp_packed.opaque[0], 39, 39); \
   __gen_unpack_uint((__unpacked)->preload.r56, &__tmp_packed.opaque[0], 40, 40); \
   __gen_unpack_uint((__unpacked)->preload.r57, &__tmp_packed.opaque[0], 41, 41); \
   __gen_unpack_uint((__unpacked)->preload.r58, &__tmp_packed.opaque[0], 42, 42); \
   __gen_unpack_uint((__unpacked)->preload.r59, &__tmp_packed.opaque[0], 43, 43); \
   __gen_unpack_uint((__unpacked)->preload.r60, &__tmp_packed.opaque[0], 44, 44); \
   __gen_unpack_uint((__unpacked)->preload.r61, &__tmp_packed.opaque[0], 45, 45); \
   __gen_unpack_uint((__unpacked)->preload.r62, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->preload.r63, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->binary, &__tmp_packed.opaque[0], 64, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SHADER_PROGRAM_print(FILE *fp, const struct MALI_SHADER_PROGRAM * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sStage: %s\n", indent, "", mali_shader_stage_as_str(values->stage));
   fprintf(fp, "%*sFragment coverage bitmask type: %s\n", indent, "", mali_coverage_bitmask_type_as_str(values->fragment_coverage_bitmask_type));
   fprintf(fp, "%*sVertex warp limit: %s\n", indent, "", mali_warp_limit_as_str(values->vertex_warp_limit));
   fprintf(fp, "%*sSuppress NaN: %s\n", indent, "", values->suppress_nan ? "true" : "false");
   fprintf(fp, "%*sFlush to zero mode: %s\n", indent, "", mali_flush_to_zero_mode_as_str(values->flush_to_zero_mode));
   fprintf(fp, "%*sSuppress Inf: %s\n", indent, "", values->suppress_inf ? "true" : "false");
   fprintf(fp, "%*sRequires helper threads: %s\n", indent, "", values->requires_helper_threads ? "true" : "false");
   fprintf(fp, "%*sShader contains JUMP_EX: %s\n", indent, "", values->shader_contains_jump_ex ? "true" : "false");
   fprintf(fp, "%*sRegister allocation: %s\n", indent, "", mali_shader_register_allocation_as_str(values->register_allocation));
   fprintf(fp, "%*sPreload:\n", indent, "");
   MALI_PRELOAD_print(fp, &values->preload, indent + 2);
   fprintf(fp, "%*sBinary: 0x%" PRIx64 "\n", indent, "", values->binary);
}

#endif
struct MALI_SCISSOR {
   uint32_t                             scissor_minimum_x;
   uint32_t                             scissor_minimum_y;
   uint32_t                             scissor_maximum_x;
   uint32_t                             scissor_maximum_y;
};

#define MALI_SCISSOR_header                     \
   0

#define MALI_SCISSOR_LENGTH 8
struct mali_scissor_packed { uint32_t opaque[2]; };
#define MALI_SCISSOR_PACKED_T struct mali_scissor_packed
#define MALI_SCISSOR_pack(__packed, __unpacked) \
do { \
   MALI_SCISSOR_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->scissor_minimum_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->scissor_minimum_y, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->scissor_maximum_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->scissor_maximum_y, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SCISSOR_unpack(__packed, __unpacked) \
do { \
   MALI_SCISSOR_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->scissor_minimum_x, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->scissor_minimum_y, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->scissor_maximum_x, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_uint((__unpacked)->scissor_maximum_y, &__tmp_packed.opaque[0], 48, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SCISSOR_print(FILE *fp, const struct MALI_SCISSOR * values, unsigned indent)
{
   fprintf(fp, "%*sScissor Minimum X: %u\n", indent, "", values->scissor_minimum_x);
   fprintf(fp, "%*sScissor Minimum Y: %u\n", indent, "", values->scissor_minimum_y);
   fprintf(fp, "%*sScissor Maximum X: %u\n", indent, "", values->scissor_maximum_x);
   fprintf(fp, "%*sScissor Maximum Y: %u\n", indent, "", values->scissor_maximum_y);
}

#endif
struct MALI_LOCAL_STORAGE {
   uint32_t                             tls_size;
   uint32_t                             wls_instances;
#define MALI_LOCAL_STORAGE_NO_WORKGROUP_MEM      2147483648
   uint32_t                             wls_size_base;
   uint32_t                             wls_size_scale;
   uint64_t                             tls_base_pointer;
   enum mali_address_mode               tls_address_mode;
   uint64_t                             wls_base_pointer;
};

#define MALI_LOCAL_STORAGE_header               \
   .wls_instances = MALI_LOCAL_STORAGE_NO_WORKGROUP_MEM

#define MALI_LOCAL_STORAGE_LENGTH 32
#define MALI_LOCAL_STORAGE_ALIGN 64
struct mali_local_storage_packed { uint32_t opaque[8]; };
#define MALI_LOCAL_STORAGE_PACKED_T struct mali_local_storage_packed
#define MALI_LOCAL_STORAGE_pack(__packed, __unpacked) \
do { \
   MALI_LOCAL_STORAGE_PACKED_T __tmp_packed; \
   assert(IS_POT_NONZERO((__unpacked)->wls_instances)); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->tls_size, 0, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint(util_logbase2((__unpacked)->wls_instances), 0, 4) | \
            util_bitpack_uint((__unpacked)->wls_size_base, 5, 6) | \
            util_bitpack_uint((__unpacked)->wls_size_scale, 8, 12); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->tls_base_pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->tls_base_pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->tls_address_mode, 28, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->wls_base_pointer, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->wls_base_pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_LOCAL_STORAGE_unpack(__packed, __unpacked) \
do { \
   MALI_LOCAL_STORAGE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffe080) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 1\n"); \
   if (__tmp_packed.opaque[3] & 0xfff0000) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 3\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->tls_size, &__tmp_packed.opaque[0], 0, 4); \
   __gen_unpack_uint((__unpacked)->wls_instances, &__tmp_packed.opaque[0], 32, 36); \
   (__unpacked)->wls_instances = 1U << (__unpacked)->wls_instances; \
   __gen_unpack_uint((__unpacked)->wls_size_base, &__tmp_packed.opaque[0], 37, 38); \
   __gen_unpack_uint((__unpacked)->wls_size_scale, &__tmp_packed.opaque[0], 40, 44); \
   __gen_unpack_uint((__unpacked)->tls_base_pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->tls_address_mode, &__tmp_packed.opaque[0], 124, 127); \
   __gen_unpack_uint((__unpacked)->wls_base_pointer, &__tmp_packed.opaque[0], 128, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_LOCAL_STORAGE_print(FILE *fp, const struct MALI_LOCAL_STORAGE * values, unsigned indent)
{
   fprintf(fp, "%*sTLS Size: %u\n", indent, "", values->tls_size);
   fprintf(fp, "%*sWLS Instances: %u\n", indent, "", values->wls_instances);
   fprintf(fp, "%*sWLS Size Base: %u\n", indent, "", values->wls_size_base);
   fprintf(fp, "%*sWLS Size Scale: %u\n", indent, "", values->wls_size_scale);
   fprintf(fp, "%*sTLS Base Pointer: 0x%" PRIx64 "\n", indent, "", values->tls_base_pointer);
   fprintf(fp, "%*sTLS Address Mode: %s\n", indent, "", mali_address_mode_as_str(values->tls_address_mode));
   fprintf(fp, "%*sWLS Base Pointer: 0x%" PRIx64 "\n", indent, "", values->wls_base_pointer);
}

#endif
enum mali_color_buffer_internal_format {
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW_VALUE =      0,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A8 =      1,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R10G10B10A2 =      2,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A2 =      3,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R4G4B4A4 =      4,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G6B5A0 =      5,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G5B5A1 =      6,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R16F =     16,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RG16F =     17,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RGBA16F =     18,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RG11F_B10F =     20,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW8 =     32,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW16 =     33,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW32 =     34,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW64 =     35,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW128 =     36,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_color_buffer_internal_format_as_str(enum mali_color_buffer_internal_format imm)
{
    switch (imm) {
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW_VALUE: return "Raw Value";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A8: return "R8G8B8A8";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R10G10B10A2: return "R10G10B10A2";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A2: return "R8G8B8A2";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R4G4B4A4: return "R4G4B4A4";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G6B5A0: return "R5G6B5A0";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G5B5A1: return "R5G5B5A1";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R16F: return "R16F";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RG16F: return "RG16F";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RGBA16F: return "RGBA16F";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RG11F_B10F: return "RG11F_B10F";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW8: return "RAW8";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW16: return "RAW16";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW32: return "RAW32";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW64: return "RAW64";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW128: return "RAW128";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_color_format {
        MALI_COLOR_FORMAT_RAW8               =      0,
        MALI_COLOR_FORMAT_RAW16              =      1,
        MALI_COLOR_FORMAT_RAW24              =      2,
        MALI_COLOR_FORMAT_RAW32              =      3,
        MALI_COLOR_FORMAT_RAW48              =      4,
        MALI_COLOR_FORMAT_RAW64              =      5,
        MALI_COLOR_FORMAT_RAW96              =      6,
        MALI_COLOR_FORMAT_RAW128             =      7,
        MALI_COLOR_FORMAT_RAW192             =      8,
        MALI_COLOR_FORMAT_RAW256             =      9,
        MALI_COLOR_FORMAT_RAW384             =     10,
        MALI_COLOR_FORMAT_RAW512             =     11,
        MALI_COLOR_FORMAT_RAW768             =     12,
        MALI_COLOR_FORMAT_RAW1024            =     13,
        MALI_COLOR_FORMAT_RAW1536            =     14,
        MALI_COLOR_FORMAT_RAW2048            =     15,
        MALI_COLOR_FORMAT_R8                 =     16,
        MALI_COLOR_FORMAT_R8G8               =     17,
        MALI_COLOR_FORMAT_R8G8B8             =     18,
        MALI_COLOR_FORMAT_R8G8B8A8           =     19,
        MALI_COLOR_FORMAT_R4G4B4A4           =     20,
        MALI_COLOR_FORMAT_R5G6B5             =     21,
        MALI_COLOR_FORMAT_R8G8B8_FROM_R8G8B8A2 =     22,
        MALI_COLOR_FORMAT_R10G10B10A2        =     24,
        MALI_COLOR_FORMAT_A2B10G10R10        =     25,
        MALI_COLOR_FORMAT_R5G5B5A1           =     28,
        MALI_COLOR_FORMAT_A1B5G5R5           =     29,
        MALI_COLOR_FORMAT_NATIVE             =     31,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_color_format_as_str(enum mali_color_format imm)
{
    switch (imm) {
    case MALI_COLOR_FORMAT_RAW8: return "RAW8";
    case MALI_COLOR_FORMAT_RAW16: return "RAW16";
    case MALI_COLOR_FORMAT_RAW24: return "RAW24";
    case MALI_COLOR_FORMAT_RAW32: return "RAW32";
    case MALI_COLOR_FORMAT_RAW48: return "RAW48";
    case MALI_COLOR_FORMAT_RAW64: return "RAW64";
    case MALI_COLOR_FORMAT_RAW96: return "RAW96";
    case MALI_COLOR_FORMAT_RAW128: return "RAW128";
    case MALI_COLOR_FORMAT_RAW192: return "RAW192";
    case MALI_COLOR_FORMAT_RAW256: return "RAW256";
    case MALI_COLOR_FORMAT_RAW384: return "RAW384";
    case MALI_COLOR_FORMAT_RAW512: return "RAW512";
    case MALI_COLOR_FORMAT_RAW768: return "RAW768";
    case MALI_COLOR_FORMAT_RAW1024: return "RAW1024";
    case MALI_COLOR_FORMAT_RAW1536: return "RAW1536";
    case MALI_COLOR_FORMAT_RAW2048: return "RAW2048";
    case MALI_COLOR_FORMAT_R8: return "R8";
    case MALI_COLOR_FORMAT_R8G8: return "R8G8";
    case MALI_COLOR_FORMAT_R8G8B8: return "R8G8B8";
    case MALI_COLOR_FORMAT_R8G8B8A8: return "R8G8B8A8";
    case MALI_COLOR_FORMAT_R4G4B4A4: return "R4G4B4A4";
    case MALI_COLOR_FORMAT_R5G6B5: return "R5G6B5";
    case MALI_COLOR_FORMAT_R8G8B8_FROM_R8G8B8A2: return "R8G8B8_FROM_R8G8B8A2";
    case MALI_COLOR_FORMAT_R10G10B10A2: return "R10G10B10A2";
    case MALI_COLOR_FORMAT_A2B10G10R10: return "A2B10G10R10";
    case MALI_COLOR_FORMAT_R5G5B5A1: return "R5G5B5A1";
    case MALI_COLOR_FORMAT_A1B5G5R5: return "A1B5G5R5";
    case MALI_COLOR_FORMAT_NATIVE: return "NATIVE";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_float_color_format {
        MALI_FLOAT_COLOR_FORMAT_RAW8         =      0,
        MALI_FLOAT_COLOR_FORMAT_RAW16        =      1,
        MALI_FLOAT_COLOR_FORMAT_RAW24        =      2,
        MALI_FLOAT_COLOR_FORMAT_RAW32        =      3,
        MALI_FLOAT_COLOR_FORMAT_RAW48        =      4,
        MALI_FLOAT_COLOR_FORMAT_RAW64        =      5,
        MALI_FLOAT_COLOR_FORMAT_RAW96        =      6,
        MALI_FLOAT_COLOR_FORMAT_RAW128       =      7,
        MALI_FLOAT_COLOR_FORMAT_R16F         =     16,
        MALI_FLOAT_COLOR_FORMAT_RG16F        =     17,
        MALI_FLOAT_COLOR_FORMAT_RGB16F       =     18,
        MALI_FLOAT_COLOR_FORMAT_RGBA16F      =     19,
        MALI_FLOAT_COLOR_FORMAT_RG11F_B10F   =     20,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_float_color_format_as_str(enum mali_float_color_format imm)
{
    switch (imm) {
    case MALI_FLOAT_COLOR_FORMAT_RAW8: return "RAW8";
    case MALI_FLOAT_COLOR_FORMAT_RAW16: return "RAW16";
    case MALI_FLOAT_COLOR_FORMAT_RAW24: return "RAW24";
    case MALI_FLOAT_COLOR_FORMAT_RAW32: return "RAW32";
    case MALI_FLOAT_COLOR_FORMAT_RAW48: return "RAW48";
    case MALI_FLOAT_COLOR_FORMAT_RAW64: return "RAW64";
    case MALI_FLOAT_COLOR_FORMAT_RAW96: return "RAW96";
    case MALI_FLOAT_COLOR_FORMAT_RAW128: return "RAW128";
    case MALI_FLOAT_COLOR_FORMAT_R16F: return "R16F";
    case MALI_FLOAT_COLOR_FORMAT_RG16F: return "RG16F";
    case MALI_FLOAT_COLOR_FORMAT_RGB16F: return "RGB16F";
    case MALI_FLOAT_COLOR_FORMAT_RGBA16F: return "RGBA16F";
    case MALI_FLOAT_COLOR_FORMAT_RG11F_B10F: return "RG11F_B10F";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_downsampling_accumulation_mode {
        MALI_DOWNSAMPLING_ACCUMULATION_MODE_UNSIGNED_NORMALIZED_INTEGER =      0,
        MALI_DOWNSAMPLING_ACCUMULATION_MODE_SIGNED_NORMALIZED_INTEGER =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_downsampling_accumulation_mode_as_str(enum mali_downsampling_accumulation_mode imm)
{
    switch (imm) {
    case MALI_DOWNSAMPLING_ACCUMULATION_MODE_UNSIGNED_NORMALIZED_INTEGER: return "Unsigned normalized integer";
    case MALI_DOWNSAMPLING_ACCUMULATION_MODE_SIGNED_NORMALIZED_INTEGER: return "Signed normalized integer";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_sample_layout {
        MALI_SAMPLE_LAYOUT_ORDERED_4X_GRID   =      0,
        MALI_SAMPLE_LAYOUT_ROTATED_4X_GRID   =      1,
        MALI_SAMPLE_LAYOUT_D3D_8X_GRID       =      2,
        MALI_SAMPLE_LAYOUT_D3D_16X_GRID      =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_sample_layout_as_str(enum mali_sample_layout imm)
{
    switch (imm) {
    case MALI_SAMPLE_LAYOUT_ORDERED_4X_GRID: return "Ordered 4x Grid";
    case MALI_SAMPLE_LAYOUT_ROTATED_4X_GRID: return "Rotated 4x Grid";
    case MALI_SAMPLE_LAYOUT_D3D_8X_GRID: return "D3D 8x Grid";
    case MALI_SAMPLE_LAYOUT_D3D_16X_GRID: return "D3D 16x Grid";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_zs_format {
        MALI_ZS_FORMAT_D16                   =      1,
        MALI_ZS_FORMAT_D24                   =      2,
        MALI_ZS_FORMAT_D24X8                 =      4,
        MALI_ZS_FORMAT_D24S8                 =      5,
        MALI_ZS_FORMAT_D32                   =     14,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_zs_format_as_str(enum mali_zs_format imm)
{
    switch (imm) {
    case MALI_ZS_FORMAT_D16: return "D16";
    case MALI_ZS_FORMAT_D24: return "D24";
    case MALI_ZS_FORMAT_D24X8: return "D24X8";
    case MALI_ZS_FORMAT_D24S8: return "D24S8";
    case MALI_ZS_FORMAT_D32: return "D32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_zs_preload_format {
        MALI_ZS_PRELOAD_FORMAT_D32_S8X24     =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_zs_preload_format_as_str(enum mali_zs_preload_format imm)
{
    switch (imm) {
    case MALI_ZS_PRELOAD_FORMAT_D32_S8X24: return "D32_S8X24";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_s_format {
        MALI_S_FORMAT_S8                     =      1,
        MALI_S_FORMAT_X24S8                  =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_s_format_as_str(enum mali_s_format imm)
{
    switch (imm) {
    case MALI_S_FORMAT_S8: return "S8";
    case MALI_S_FORMAT_X24S8: return "X24S8";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_tie_break_rule {
        MALI_TIE_BREAK_RULE_0_IN_180_OUT     =      0,
        MALI_TIE_BREAK_RULE_0_OUT_180_IN     =      1,
        MALI_TIE_BREAK_RULE_MINUS_180_IN_0_OUT =      2,
        MALI_TIE_BREAK_RULE_MINUS_180_OUT_0_IN =      3,
        MALI_TIE_BREAK_RULE_90_IN_270_OUT    =      4,
        MALI_TIE_BREAK_RULE_90_OUT_270_IN    =      5,
        MALI_TIE_BREAK_RULE_MINUS_90_IN_90_OUT =      6,
        MALI_TIE_BREAK_RULE_MINUS_90_OUT_90_IN =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_tie_break_rule_as_str(enum mali_tie_break_rule imm)
{
    switch (imm) {
    case MALI_TIE_BREAK_RULE_0_IN_180_OUT: return "0_IN_180_OUT";
    case MALI_TIE_BREAK_RULE_0_OUT_180_IN: return "0_OUT_180_IN";
    case MALI_TIE_BREAK_RULE_MINUS_180_IN_0_OUT: return "MINUS_180_IN_0_OUT";
    case MALI_TIE_BREAK_RULE_MINUS_180_OUT_0_IN: return "MINUS_180_OUT_0_IN";
    case MALI_TIE_BREAK_RULE_90_IN_270_OUT: return "90_IN_270_OUT";
    case MALI_TIE_BREAK_RULE_90_OUT_270_IN: return "90_OUT_270_IN";
    case MALI_TIE_BREAK_RULE_MINUS_90_IN_90_OUT: return "MINUS_90_IN_90_OUT";
    case MALI_TIE_BREAK_RULE_MINUS_90_OUT_90_IN: return "MINUS_90_OUT_90_IN";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_RT_BUFFER {
   uint64_t                             base;
   uint64_t                             row_stride;
   uint64_t                             surface_stride;
};

#define MALI_RT_BUFFER_header                   \
   0

#define MALI_RT_BUFFER_LENGTH 16
struct mali_rt_buffer_packed { uint32_t opaque[4]; };
#define MALI_RT_BUFFER_PACKED_T struct mali_rt_buffer_packed
#define MALI_RT_BUFFER_pack(__packed, __unpacked) \
do { \
   MALI_RT_BUFFER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->surface_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RT_BUFFER_unpack(__packed, __unpacked) \
do { \
   MALI_RT_BUFFER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->surface_stride, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RT_BUFFER_print(FILE *fp, const struct MALI_RT_BUFFER * values, unsigned indent)
{
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sRow Stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSurface Stride: 0x%" PRIx64 "\n", indent, "", values->surface_stride);
}

#endif
enum mali_sample_pattern {
        MALI_SAMPLE_PATTERN_SINGLE_SAMPLED   =      0,
        MALI_SAMPLE_PATTERN_ORDERED_4X_GRID  =      1,
        MALI_SAMPLE_PATTERN_ROTATED_4X_GRID  =      2,
        MALI_SAMPLE_PATTERN_D3D_8X_GRID      =      3,
        MALI_SAMPLE_PATTERN_D3D_16X_GRID     =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_sample_pattern_as_str(enum mali_sample_pattern imm)
{
    switch (imm) {
    case MALI_SAMPLE_PATTERN_SINGLE_SAMPLED: return "Single-sampled";
    case MALI_SAMPLE_PATTERN_ORDERED_4X_GRID: return "Ordered 4x Grid";
    case MALI_SAMPLE_PATTERN_ROTATED_4X_GRID: return "Rotated 4x Grid";
    case MALI_SAMPLE_PATTERN_D3D_8X_GRID: return "D3D 8x Grid";
    case MALI_SAMPLE_PATTERN_D3D_16X_GRID: return "D3D 16x Grid";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_z_internal_format {
        MALI_Z_INTERNAL_FORMAT_D16           =      0,
        MALI_Z_INTERNAL_FORMAT_D24           =      1,
        MALI_Z_INTERNAL_FORMAT_D32           =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_z_internal_format_as_str(enum mali_z_internal_format imm)
{
    switch (imm) {
    case MALI_Z_INTERNAL_FORMAT_D16: return "D16";
    case MALI_Z_INTERNAL_FORMAT_D24: return "D24";
    case MALI_Z_INTERNAL_FORMAT_D32: return "D32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_pre_post_frame_shader_mode {
        MALI_PRE_POST_FRAME_SHADER_MODE_NEVER =      0,
        MALI_PRE_POST_FRAME_SHADER_MODE_ALWAYS =      1,
        MALI_PRE_POST_FRAME_SHADER_MODE_INTERSECT =      2,
        MALI_PRE_POST_FRAME_SHADER_MODE_EARLY_ZS_ALWAYS =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_pre_post_frame_shader_mode_as_str(enum mali_pre_post_frame_shader_mode imm)
{
    switch (imm) {
    case MALI_PRE_POST_FRAME_SHADER_MODE_NEVER: return "Never";
    case MALI_PRE_POST_FRAME_SHADER_MODE_ALWAYS: return "Always";
    case MALI_PRE_POST_FRAME_SHADER_MODE_INTERSECT: return "Intersect";
    case MALI_PRE_POST_FRAME_SHADER_MODE_EARLY_ZS_ALWAYS: return "Early ZS always";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_downscale {
        MALI_DOWNSCALE_NONE                  =      0,
        MALI_DOWNSCALE_2X                    =      1,
        MALI_DOWNSCALE_4X                    =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_downscale_as_str(enum mali_downscale imm)
{
    switch (imm) {
    case MALI_DOWNSCALE_NONE: return "None";
    case MALI_DOWNSCALE_2X: return "2x";
    case MALI_DOWNSCALE_4X: return "4x";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_FRAMEBUFFER_PARAMETERS {
   enum mali_pre_post_frame_shader_mode pre_frame_0;
   enum mali_pre_post_frame_shader_mode pre_frame_1;
   enum mali_pre_post_frame_shader_mode post_frame;
   enum mali_downscale                  downscale_geometry;
   uint32_t                             internal_layer_index;
   uint64_t                             frame_argument;
   uint64_t                             sample_locations;
   uint64_t                             frame_shader_dcds;
   uint32_t                             width;
   uint32_t                             height;
   uint32_t                             bound_min_x;
   uint32_t                             bound_min_y;
   uint32_t                             bound_max_x;
   uint32_t                             bound_max_y;
   uint32_t                             sample_count;
   enum mali_sample_pattern             sample_pattern;
   enum mali_tie_break_rule             tie_break_rule;
   uint32_t                             effective_tile_size;
   bool                                 first_provoking_vertex;
   bool                                 point_sprite_coord_origin_max_y;
   bool                                 blend_suppress_inf;
   bool                                 blend_suppress_nan;
   bool                                 blend_suppress_denorm;
   uint32_t                             render_target_count;
   uint32_t                             color_buffer_allocation;
   uint32_t                             s_clear;
   bool                                 s_write_enable;
   bool                                 s_preload_enable;
   bool                                 s_unload_enable;
   enum mali_z_internal_format          z_internal_format;
   bool                                 z_write_enable;
   bool                                 z_preload_enable;
   bool                                 z_unload_enable;
   bool                                 has_zs_crc_extension;
   bool                                 empty_tile_read_enable;
   bool                                 empty_tile_write_enable;
   bool                                 crc_read_enable;
   bool                                 crc_write_enable;
   float                                z_clear;
   uint64_t                             tiler;
};

#define MALI_FRAMEBUFFER_PARAMETERS_header      \
   .sample_count = 1,  \
   .point_sprite_coord_origin_max_y = true

#define MALI_FRAMEBUFFER_PARAMETERS_LENGTH 64
#define MALI_FRAMEBUFFER_PARAMETERS_ALIGN 64
struct mali_framebuffer_parameters_packed { uint32_t opaque[16]; };
#define MALI_FRAMEBUFFER_PARAMETERS_PACKED_T struct mali_framebuffer_parameters_packed
#define MALI_FRAMEBUFFER_PARAMETERS_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PARAMETERS_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   assert(IS_POT_NONZERO((__unpacked)->sample_count)); \
   assert(IS_POT_NONZERO((__unpacked)->effective_tile_size)); \
   assert((__unpacked)->render_target_count >= 1); \
   assert(((__unpacked)->color_buffer_allocation & 0x3ff) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->pre_frame_0, 0, 2) | \
            util_bitpack_uint((__unpacked)->pre_frame_1, 3, 5) | \
            util_bitpack_uint((__unpacked)->post_frame, 6, 8) | \
            util_bitpack_uint((__unpacked)->downscale_geometry, 9, 10) | \
            util_bitpack_uint((__unpacked)->internal_layer_index, 24, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->frame_argument, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->frame_argument, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->sample_locations, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->sample_locations, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->frame_shader_dcds, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->frame_shader_dcds, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->bound_min_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->bound_min_y, 16, 31); \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->bound_max_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->bound_max_y, 16, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint(util_logbase2((__unpacked)->sample_count), 0, 2) | \
            util_bitpack_uint((__unpacked)->sample_pattern, 3, 5) | \
            util_bitpack_uint((__unpacked)->tie_break_rule, 6, 8) | \
            util_bitpack_uint(util_logbase2((__unpacked)->effective_tile_size), 9, 12) | \
            util_bitpack_uint((__unpacked)->first_provoking_vertex, 14, 14) | \
            util_bitpack_uint((__unpacked)->point_sprite_coord_origin_max_y, 15, 15) | \
            util_bitpack_uint((__unpacked)->blend_suppress_inf, 16, 16) | \
            util_bitpack_uint((__unpacked)->blend_suppress_nan, 17, 17) | \
            util_bitpack_uint((__unpacked)->blend_suppress_denorm, 18, 18) | \
            util_bitpack_uint((__unpacked)->render_target_count - 1, 19, 22) | \
            util_bitpack_uint((__unpacked)->color_buffer_allocation >> 10, 24, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->s_clear, 0, 7) | \
            util_bitpack_uint((__unpacked)->s_write_enable, 8, 8) | \
            util_bitpack_uint((__unpacked)->s_preload_enable, 9, 9) | \
            util_bitpack_uint((__unpacked)->s_unload_enable, 10, 10) | \
            util_bitpack_uint((__unpacked)->z_internal_format, 16, 17) | \
            util_bitpack_uint((__unpacked)->z_write_enable, 18, 18) | \
            util_bitpack_uint((__unpacked)->z_preload_enable, 19, 19) | \
            util_bitpack_uint((__unpacked)->z_unload_enable, 20, 20) | \
            util_bitpack_uint((__unpacked)->has_zs_crc_extension, 21, 21) | \
            util_bitpack_uint((__unpacked)->empty_tile_read_enable, 28, 28) | \
            util_bitpack_uint((__unpacked)->empty_tile_write_enable, 29, 29) | \
            util_bitpack_uint((__unpacked)->crc_read_enable, 30, 30) | \
            util_bitpack_uint((__unpacked)->crc_write_enable, 31, 31); \
   __tmp_packed.opaque[13] = util_bitpack_float((__unpacked)->z_clear); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->tiler, 0, 63); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->tiler, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_PARAMETERS_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PARAMETERS_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff800) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 1\n"); \
   if (__tmp_packed.opaque[11] & 0x802000) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xfc0f800) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 12\n"); \
   __gen_unpack_uint((__unpacked)->pre_frame_0, &__tmp_packed.opaque[0], 0, 2); \
   __gen_unpack_uint((__unpacked)->pre_frame_1, &__tmp_packed.opaque[0], 3, 5); \
   __gen_unpack_uint((__unpacked)->post_frame, &__tmp_packed.opaque[0], 6, 8); \
   __gen_unpack_uint((__unpacked)->downscale_geometry, &__tmp_packed.opaque[0], 9, 10); \
   __gen_unpack_uint((__unpacked)->internal_layer_index, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_uint((__unpacked)->frame_argument, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->sample_locations, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->frame_shader_dcds, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 256, 271); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 272, 287); \
   (__unpacked)->height = (__unpacked)->height + 1; \
   __gen_unpack_uint((__unpacked)->bound_min_x, &__tmp_packed.opaque[0], 288, 303); \
   __gen_unpack_uint((__unpacked)->bound_min_y, &__tmp_packed.opaque[0], 304, 319); \
   __gen_unpack_uint((__unpacked)->bound_max_x, &__tmp_packed.opaque[0], 320, 335); \
   __gen_unpack_uint((__unpacked)->bound_max_y, &__tmp_packed.opaque[0], 336, 351); \
   __gen_unpack_uint((__unpacked)->sample_count, &__tmp_packed.opaque[0], 352, 354); \
   (__unpacked)->sample_count = 1U << (__unpacked)->sample_count; \
   __gen_unpack_uint((__unpacked)->sample_pattern, &__tmp_packed.opaque[0], 355, 357); \
   __gen_unpack_uint((__unpacked)->tie_break_rule, &__tmp_packed.opaque[0], 358, 360); \
   __gen_unpack_uint((__unpacked)->effective_tile_size, &__tmp_packed.opaque[0], 361, 364); \
   (__unpacked)->effective_tile_size = 1U << (__unpacked)->effective_tile_size; \
   __gen_unpack_uint((__unpacked)->first_provoking_vertex, &__tmp_packed.opaque[0], 366, 366); \
   __gen_unpack_uint((__unpacked)->point_sprite_coord_origin_max_y, &__tmp_packed.opaque[0], 367, 367); \
   __gen_unpack_uint((__unpacked)->blend_suppress_inf, &__tmp_packed.opaque[0], 368, 368); \
   __gen_unpack_uint((__unpacked)->blend_suppress_nan, &__tmp_packed.opaque[0], 369, 369); \
   __gen_unpack_uint((__unpacked)->blend_suppress_denorm, &__tmp_packed.opaque[0], 370, 370); \
   __gen_unpack_uint((__unpacked)->render_target_count, &__tmp_packed.opaque[0], 371, 374); \
   (__unpacked)->render_target_count = (__unpacked)->render_target_count + 1; \
   __gen_unpack_uint((__unpacked)->color_buffer_allocation, &__tmp_packed.opaque[0], 376, 383); \
   (__unpacked)->color_buffer_allocation = (__unpacked)->color_buffer_allocation << 10; \
   __gen_unpack_uint((__unpacked)->s_clear, &__tmp_packed.opaque[0], 384, 391); \
   __gen_unpack_uint((__unpacked)->s_write_enable, &__tmp_packed.opaque[0], 392, 392); \
   __gen_unpack_uint((__unpacked)->s_preload_enable, &__tmp_packed.opaque[0], 393, 393); \
   __gen_unpack_uint((__unpacked)->s_unload_enable, &__tmp_packed.opaque[0], 394, 394); \
   __gen_unpack_uint((__unpacked)->z_internal_format, &__tmp_packed.opaque[0], 400, 401); \
   __gen_unpack_uint((__unpacked)->z_write_enable, &__tmp_packed.opaque[0], 402, 402); \
   __gen_unpack_uint((__unpacked)->z_preload_enable, &__tmp_packed.opaque[0], 403, 403); \
   __gen_unpack_uint((__unpacked)->z_unload_enable, &__tmp_packed.opaque[0], 404, 404); \
   __gen_unpack_uint((__unpacked)->has_zs_crc_extension, &__tmp_packed.opaque[0], 405, 405); \
   __gen_unpack_uint((__unpacked)->empty_tile_read_enable, &__tmp_packed.opaque[0], 412, 412); \
   __gen_unpack_uint((__unpacked)->empty_tile_write_enable, &__tmp_packed.opaque[0], 413, 413); \
   __gen_unpack_uint((__unpacked)->crc_read_enable, &__tmp_packed.opaque[0], 414, 414); \
   __gen_unpack_uint((__unpacked)->crc_write_enable, &__tmp_packed.opaque[0], 415, 415); \
   __gen_unpack_float((__unpacked)->z_clear, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->tiler, &__tmp_packed.opaque[0], 448, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_PARAMETERS_print(FILE *fp, const struct MALI_FRAMEBUFFER_PARAMETERS * values, unsigned indent)
{
   fprintf(fp, "%*sPre Frame 0: %s\n", indent, "", mali_pre_post_frame_shader_mode_as_str(values->pre_frame_0));
   fprintf(fp, "%*sPre Frame 1: %s\n", indent, "", mali_pre_post_frame_shader_mode_as_str(values->pre_frame_1));
   fprintf(fp, "%*sPost Frame: %s\n", indent, "", mali_pre_post_frame_shader_mode_as_str(values->post_frame));
   fprintf(fp, "%*sDownscale geometry: %s\n", indent, "", mali_downscale_as_str(values->downscale_geometry));
   fprintf(fp, "%*sInternal layer index: %u\n", indent, "", values->internal_layer_index);
   fprintf(fp, "%*sFrame argument: 0x%" PRIx64 "\n", indent, "", values->frame_argument);
   fprintf(fp, "%*sSample Locations: 0x%" PRIx64 "\n", indent, "", values->sample_locations);
   fprintf(fp, "%*sFrame Shader DCDs: 0x%" PRIx64 "\n", indent, "", values->frame_shader_dcds);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
   fprintf(fp, "%*sBound Min X: %u\n", indent, "", values->bound_min_x);
   fprintf(fp, "%*sBound Min Y: %u\n", indent, "", values->bound_min_y);
   fprintf(fp, "%*sBound Max X: %u\n", indent, "", values->bound_max_x);
   fprintf(fp, "%*sBound Max Y: %u\n", indent, "", values->bound_max_y);
   fprintf(fp, "%*sSample Count: %u\n", indent, "", values->sample_count);
   fprintf(fp, "%*sSample Pattern: %s\n", indent, "", mali_sample_pattern_as_str(values->sample_pattern));
   fprintf(fp, "%*sTie-Break Rule: %s\n", indent, "", mali_tie_break_rule_as_str(values->tie_break_rule));
   fprintf(fp, "%*sEffective Tile Size: %u\n", indent, "", values->effective_tile_size);
   fprintf(fp, "%*sFirst provoking vertex: %s\n", indent, "", values->first_provoking_vertex ? "true" : "false");
   fprintf(fp, "%*sPoint sprite coord origin max Y: %s\n", indent, "", values->point_sprite_coord_origin_max_y ? "true" : "false");
   fprintf(fp, "%*sBlend suppress Inf: %s\n", indent, "", values->blend_suppress_inf ? "true" : "false");
   fprintf(fp, "%*sBlend suppress NaN: %s\n", indent, "", values->blend_suppress_nan ? "true" : "false");
   fprintf(fp, "%*sBlend suppress denorm: %s\n", indent, "", values->blend_suppress_denorm ? "true" : "false");
   fprintf(fp, "%*sRender Target Count: %u\n", indent, "", values->render_target_count);
   fprintf(fp, "%*sColor Buffer Allocation: %u\n", indent, "", values->color_buffer_allocation);
   fprintf(fp, "%*sS Clear: %u\n", indent, "", values->s_clear);
   fprintf(fp, "%*sS Write Enable: %s\n", indent, "", values->s_write_enable ? "true" : "false");
   fprintf(fp, "%*sS Preload Enable: %s\n", indent, "", values->s_preload_enable ? "true" : "false");
   fprintf(fp, "%*sS Unload Enable: %s\n", indent, "", values->s_unload_enable ? "true" : "false");
   fprintf(fp, "%*sZ Internal Format: %s\n", indent, "", mali_z_internal_format_as_str(values->z_internal_format));
   fprintf(fp, "%*sZ Write Enable: %s\n", indent, "", values->z_write_enable ? "true" : "false");
   fprintf(fp, "%*sZ Preload Enable: %s\n", indent, "", values->z_preload_enable ? "true" : "false");
   fprintf(fp, "%*sZ Unload Enable: %s\n", indent, "", values->z_unload_enable ? "true" : "false");
   fprintf(fp, "%*sHas ZS CRC Extension: %s\n", indent, "", values->has_zs_crc_extension ? "true" : "false");
   fprintf(fp, "%*sEmpty Tile Read Enable: %s\n", indent, "", values->empty_tile_read_enable ? "true" : "false");
   fprintf(fp, "%*sEmpty Tile Write Enable: %s\n", indent, "", values->empty_tile_write_enable ? "true" : "false");
   fprintf(fp, "%*sCRC Read Enable: %s\n", indent, "", values->crc_read_enable ? "true" : "false");
   fprintf(fp, "%*sCRC Write Enable: %s\n", indent, "", values->crc_write_enable ? "true" : "false");
   fprintf(fp, "%*sZ Clear: %f\n", indent, "", values->z_clear);
   fprintf(fp, "%*sTiler: 0x%" PRIx64 "\n", indent, "", values->tiler);
}

#endif
struct MALI_CRC {
   uint32_t                             render_target;
   uint64_t                             row_stride;
   uint64_t                             clear_color;
   uint64_t                             base;
};

#define MALI_CRC_header                         \
   0

#define MALI_CRC_LENGTH 64
#define MALI_CRC_ALIGN 64
struct mali_crc_packed { uint32_t opaque[16]; };
#define MALI_CRC_PACKED_T struct mali_crc_packed
#define MALI_CRC_pack(__packed, __unpacked) \
do { \
   MALI_CRC_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->render_target, 13, 15); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->clear_color, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->clear_color, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CRC_unpack(__packed, __unpacked) \
do { \
   MALI_CRC_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff1fff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 0\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 15\n"); \
   __gen_unpack_uint((__unpacked)->render_target, &__tmp_packed.opaque[0], 13, 15); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->clear_color, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 128, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CRC_print(FILE *fp, const struct MALI_CRC * values, unsigned indent)
{
   fprintf(fp, "%*sRender Target: %u\n", indent, "", values->render_target);
   fprintf(fp, "%*sRow Stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sClear Color: 0x%" PRIx64 "\n", indent, "", values->clear_color);
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
}

#endif
struct MALI_ZS_TARGET {
   enum mali_zs_format                  write_format;
   enum mali_block_format               block_format;
   enum mali_msaa                       msaa;
   bool                                 clean_pixel_write_enable;
   uint64_t                             base;
   uint64_t                             row_stride;
   uint64_t                             surface_stride;
};

#define MALI_ZS_TARGET_header                   \
   .msaa = MALI_MSAA_SINGLE

#define MALI_ZS_TARGET_LENGTH 64
#define MALI_ZS_TARGET_ALIGN 64
struct mali_zs_target_packed { uint32_t opaque[16]; };
#define MALI_ZS_TARGET_PACKED_T struct mali_zs_target_packed
#define MALI_ZS_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_ZS_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->write_format, 0, 3) | \
            util_bitpack_uint((__unpacked)->block_format, 4, 7) | \
            util_bitpack_uint((__unpacked)->msaa, 8, 9) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->surface_stride, 0, 31); \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ZS_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_ZS_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x7ffffc00) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 15\n"); \
   __gen_unpack_uint((__unpacked)->write_format, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->block_format, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->surface_stride, &__tmp_packed.opaque[0], 352, 383); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ZS_TARGET_print(FILE *fp, const struct MALI_ZS_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWrite Format: %s\n", indent, "", mali_zs_format_as_str(values->write_format));
   fprintf(fp, "%*sBlock Format: %s\n", indent, "", mali_block_format_as_str(values->block_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sRow Stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSurface Stride: 0x%" PRIx64 "\n", indent, "", values->surface_stride);
}

#endif
struct MALI_AFBC_ZS_TARGET {
   enum mali_zs_format                  write_format;
   enum mali_block_format               block_format;
   enum mali_msaa                       msaa;
   bool                                 reverse_issue_order;
   bool                                 clean_pixel_write_enable;
   uint64_t                             header;
   uint64_t                             header_row_stride;
   uint64_t                             body_offset;
};

#define MALI_AFBC_ZS_TARGET_header              \
   .msaa = MALI_MSAA_SINGLE

#define MALI_AFBC_ZS_TARGET_LENGTH 64
#define MALI_AFBC_ZS_TARGET_ALIGN 64
struct mali_afbc_zs_target_packed { uint32_t opaque[16]; };
#define MALI_AFBC_ZS_TARGET_PACKED_T struct mali_afbc_zs_target_packed
#define MALI_AFBC_ZS_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_ZS_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->write_format, 0, 3) | \
            util_bitpack_uint((__unpacked)->block_format, 4, 7) | \
            util_bitpack_uint((__unpacked)->msaa, 8, 9) | \
            util_bitpack_uint((__unpacked)->reverse_issue_order, 30, 30) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->header, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->header, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->header_row_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->body_offset, 0, 31); \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_ZS_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_ZS_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3ffffc00) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 15\n"); \
   __gen_unpack_uint((__unpacked)->write_format, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->block_format, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->reverse_issue_order, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->header_row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->body_offset, &__tmp_packed.opaque[0], 352, 383); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_ZS_TARGET_print(FILE *fp, const struct MALI_AFBC_ZS_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWrite Format: %s\n", indent, "", mali_zs_format_as_str(values->write_format));
   fprintf(fp, "%*sBlock Format: %s\n", indent, "", mali_block_format_as_str(values->block_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*sReverse Issue Order: %s\n", indent, "", values->reverse_issue_order ? "true" : "false");
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sHeader: 0x%" PRIx64 "\n", indent, "", values->header);
   fprintf(fp, "%*sHeader Row Stride: 0x%" PRIx64 "\n", indent, "", values->header_row_stride);
   fprintf(fp, "%*sBody Offset: 0x%" PRIx64 "\n", indent, "", values->body_offset);
}

#endif
struct MALI_S_TARGET {
   enum mali_s_format                   write_format;
   enum mali_block_format               block_format;
   enum mali_msaa                       msaa;
   bool                                 clean_pixel_write_enable;
   uint64_t                             base;
   uint64_t                             row_stride;
   uint64_t                             surface_stride;
};

#define MALI_S_TARGET_header                    \
   .msaa = MALI_MSAA_SINGLE

#define MALI_S_TARGET_LENGTH 64
#define MALI_S_TARGET_ALIGN 64
struct mali_s_target_packed { uint32_t opaque[16]; };
#define MALI_S_TARGET_PACKED_T struct mali_s_target_packed
#define MALI_S_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_S_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->write_format, 16, 19) | \
            util_bitpack_uint((__unpacked)->block_format, 20, 23) | \
            util_bitpack_uint((__unpacked)->msaa, 24, 25) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->surface_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_S_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_S_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x7c00ffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 11\n"); \
   __gen_unpack_uint((__unpacked)->write_format, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->block_format, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->surface_stride, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_S_TARGET_print(FILE *fp, const struct MALI_S_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWrite Format: %s\n", indent, "", mali_s_format_as_str(values->write_format));
   fprintf(fp, "%*sBlock Format: %s\n", indent, "", mali_block_format_as_str(values->block_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sRow Stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSurface Stride: 0x%" PRIx64 "\n", indent, "", values->surface_stride);
}

#endif
struct MALI_AFBC_S_TARGET {
   enum mali_s_format                   write_format;
   enum mali_block_format               block_format;
   enum mali_msaa                       msaa;
   bool                                 reverse_issue_order;
   bool                                 clean_pixel_write_enable;
   uint64_t                             header;
   uint64_t                             header_row_stride;
   uint64_t                             body_offset;
};

#define MALI_AFBC_S_TARGET_header               \
   .msaa = MALI_MSAA_SINGLE

#define MALI_AFBC_S_TARGET_LENGTH 64
#define MALI_AFBC_S_TARGET_ALIGN 64
struct mali_afbc_s_target_packed { uint32_t opaque[16]; };
#define MALI_AFBC_S_TARGET_PACKED_T struct mali_afbc_s_target_packed
#define MALI_AFBC_S_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_S_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->write_format, 16, 19) | \
            util_bitpack_uint((__unpacked)->block_format, 20, 23) | \
            util_bitpack_uint((__unpacked)->msaa, 24, 25) | \
            util_bitpack_uint((__unpacked)->reverse_issue_order, 30, 30) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->header, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->header, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->header_row_stride, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->body_offset, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_S_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_S_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3c00ffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 11\n"); \
   __gen_unpack_uint((__unpacked)->write_format, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->block_format, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->reverse_issue_order, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->header, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->header_row_stride, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->body_offset, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_S_TARGET_print(FILE *fp, const struct MALI_AFBC_S_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWrite Format: %s\n", indent, "", mali_s_format_as_str(values->write_format));
   fprintf(fp, "%*sBlock Format: %s\n", indent, "", mali_block_format_as_str(values->block_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*sReverse Issue Order: %s\n", indent, "", values->reverse_issue_order ? "true" : "false");
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sHeader: 0x%" PRIx64 "\n", indent, "", values->header);
   fprintf(fp, "%*sHeader Row Stride: 0x%" PRIx64 "\n", indent, "", values->header_row_stride);
   fprintf(fp, "%*sBody Offset: 0x%" PRIx64 "\n", indent, "", values->body_offset);
}

#endif
struct MALI_ZS_CRC_EXTENSION {
   struct MALI_CRC                      crc;
   struct MALI_AFBC_ZS_TARGET           afbc_zs;
   struct MALI_ZS_TARGET                zs;
   struct MALI_AFBC_S_TARGET            afbc_s;
   struct MALI_S_TARGET                 s;
};

#define MALI_ZS_CRC_EXTENSION_header            \
   .crc = { MALI_CRC_header },  \
   .afbc_zs = { MALI_AFBC_ZS_TARGET_header },  \
   .zs = { MALI_ZS_TARGET_header },  \
   .afbc_s = { MALI_AFBC_S_TARGET_header },  \
   .s = { MALI_S_TARGET_header }

#define MALI_ZS_CRC_EXTENSION_LENGTH 64
#define MALI_ZS_CRC_EXTENSION_ALIGN 64
struct mali_zs_crc_extension_packed { uint32_t opaque[16]; };
#define MALI_ZS_CRC_EXTENSION_PACKED_T struct mali_zs_crc_extension_packed
#define MALI_ZS_CRC_EXTENSION_pack(__packed, __unpacked) \
do { \
   MALI_ZS_CRC_EXTENSION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->crc.render_target, 13, 15) | \
            util_bitpack_uint((__unpacked)->afbc_zs.write_format, 0, 3) | \
            util_bitpack_uint((__unpacked)->afbc_zs.block_format, 4, 7) | \
            util_bitpack_uint((__unpacked)->afbc_zs.msaa, 8, 9) | \
            util_bitpack_uint((__unpacked)->afbc_zs.reverse_issue_order, 30, 30) | \
            util_bitpack_uint((__unpacked)->afbc_zs.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->zs.write_format, 0, 3) | \
            util_bitpack_uint((__unpacked)->zs.block_format, 4, 7) | \
            util_bitpack_uint((__unpacked)->zs.msaa, 8, 9) | \
            util_bitpack_uint((__unpacked)->zs.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->afbc_s.write_format, 16, 19) | \
            util_bitpack_uint((__unpacked)->afbc_s.block_format, 20, 23) | \
            util_bitpack_uint((__unpacked)->afbc_s.msaa, 24, 25) | \
            util_bitpack_uint((__unpacked)->afbc_s.reverse_issue_order, 30, 30) | \
            util_bitpack_uint((__unpacked)->afbc_s.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->s.write_format, 16, 19) | \
            util_bitpack_uint((__unpacked)->s.block_format, 20, 23) | \
            util_bitpack_uint((__unpacked)->s.msaa, 24, 25) | \
            util_bitpack_uint((__unpacked)->s.clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->crc.row_stride, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->crc.clear_color, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->crc.clear_color, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->crc.base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->crc.base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->afbc_zs.header, 0, 63) | \
            util_bitpack_uint((__unpacked)->zs.base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->afbc_zs.header, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->zs.base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->afbc_zs.header_row_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->zs.row_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->afbc_zs.body_offset, 0, 31) | \
            util_bitpack_uint((__unpacked)->zs.surface_stride, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->afbc_s.header, 0, 63) | \
            util_bitpack_uint((__unpacked)->s.base, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->afbc_s.header, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->s.base, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->afbc_s.header_row_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->s.row_stride, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->afbc_s.body_offset, 0, 31) | \
            util_bitpack_uint((__unpacked)->s.surface_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ZS_CRC_EXTENSION_unpack(__packed, __unpacked) \
do { \
   MALI_ZS_CRC_EXTENSION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3c001c00) fprintf(stderr, "XXX: Invalid field of ZS CRC Extension unpacked at word 0\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS CRC Extension unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS CRC Extension unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->crc.render_target, &__tmp_packed.opaque[0], 13, 15); \
   __gen_unpack_uint((__unpacked)->crc.row_stride, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->crc.clear_color, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->crc.base, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->afbc_zs.write_format, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->afbc_zs.block_format, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->afbc_zs.msaa, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->afbc_zs.reverse_issue_order, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->afbc_zs.clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->afbc_zs.header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->afbc_zs.header_row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->afbc_zs.body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->zs.write_format, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->zs.block_format, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->zs.msaa, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->zs.clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->zs.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->zs.row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->zs.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->afbc_s.write_format, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->afbc_s.block_format, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->afbc_s.msaa, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->afbc_s.reverse_issue_order, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->afbc_s.clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->afbc_s.header, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->afbc_s.header_row_stride, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->afbc_s.body_offset, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->s.write_format, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->s.block_format, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->s.msaa, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->s.clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->s.base, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->s.row_stride, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->s.surface_stride, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ZS_CRC_EXTENSION_print(FILE *fp, const struct MALI_ZS_CRC_EXTENSION * values, unsigned indent)
{
   fprintf(fp, "%*sCRC:\n", indent, "");
   MALI_CRC_print(fp, &values->crc, indent + 2);
   fprintf(fp, "%*sAFBC ZS:\n", indent, "");
   MALI_AFBC_ZS_TARGET_print(fp, &values->afbc_zs, indent + 2);
   fprintf(fp, "%*sZS:\n", indent, "");
   MALI_ZS_TARGET_print(fp, &values->zs, indent + 2);
   fprintf(fp, "%*sAFBC S:\n", indent, "");
   MALI_AFBC_S_TARGET_print(fp, &values->afbc_s, indent + 2);
   fprintf(fp, "%*sS:\n", indent, "");
   MALI_S_TARGET_print(fp, &values->s, indent + 2);
}

#endif
enum mali_yuv_conv_k6 {
        MALI_YUV_CONV_K6_0                   =      0,
        MALI_YUV_CONV_K6_16                  =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conv_k6_as_str(enum mali_yuv_conv_k6 imm)
{
    switch (imm) {
    case MALI_YUV_CONV_K6_0: return "0";
    case MALI_YUV_CONV_K6_16: return "16";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_conv_k7_clamp {
        MALI_YUV_CONV_K7_CLAMP_MINUS_128_TO_127 =      0,
        MALI_YUV_CONV_K7_CLAMP_MINUS_112_TO_111 =      1,
        MALI_YUV_CONV_K7_CLAMP_0_TO_255      =      2,
        MALI_YUV_CONV_K7_CLAMP_16_TO_239     =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conv_k7_clamp_as_str(enum mali_yuv_conv_k7_clamp imm)
{
    switch (imm) {
    case MALI_YUV_CONV_K7_CLAMP_MINUS_128_TO_127: return "MINUS_128_TO_127";
    case MALI_YUV_CONV_K7_CLAMP_MINUS_112_TO_111: return "MINUS_112_TO_111";
    case MALI_YUV_CONV_K7_CLAMP_0_TO_255: return "0_TO_255";
    case MALI_YUV_CONV_K7_CLAMP_16_TO_239: return "16_TO_239";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_conv_k8 {
        MALI_YUV_CONV_K8_220                 =      0,
        MALI_YUV_CONV_K8_256                 =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conv_k8_as_str(enum mali_yuv_conv_k8 imm)
{
    switch (imm) {
    case MALI_YUV_CONV_K8_220: return "220";
    case MALI_YUV_CONV_K8_256: return "256";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_RT_CLEAR {
   uint64_t                             color_0;
   uint64_t                             color_1;
   uint64_t                             color_2;
   uint64_t                             color_3;
};

#define MALI_RT_CLEAR_header                    \
   0

#define MALI_RT_CLEAR_LENGTH 16
struct mali_rt_clear_packed { uint32_t opaque[4]; };
#define MALI_RT_CLEAR_PACKED_T struct mali_rt_clear_packed
#define MALI_RT_CLEAR_pack(__packed, __unpacked) \
do { \
   MALI_RT_CLEAR_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->color_0, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->color_1, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->color_2, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RT_CLEAR_unpack(__packed, __unpacked) \
do { \
   MALI_RT_CLEAR_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->color_0, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->color_1, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->color_2, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->color_3, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RT_CLEAR_print(FILE *fp, const struct MALI_RT_CLEAR * values, unsigned indent)
{
   fprintf(fp, "%*sColor 0: 0x%" PRIx64 "\n", indent, "", values->color_0);
   fprintf(fp, "%*sColor 1: 0x%" PRIx64 "\n", indent, "", values->color_1);
   fprintf(fp, "%*sColor 2: 0x%" PRIx64 "\n", indent, "", values->color_2);
   fprintf(fp, "%*sColor 3: 0x%" PRIx64 "\n", indent, "", values->color_3);
}

#endif
struct MALI_RGB_RENDER_TARGET {
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   bool                                 write_enable;
   enum mali_color_format               writeback_format;
   enum mali_float_color_format         writeback_float_format;
   enum mali_block_format               writeback_block_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   struct MALI_RT_BUFFER                writeback_buffer;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_RGB_RENDER_TARGET_header           \
   .yuv_enable = false,  \
   .writeback_buffer = { MALI_RT_BUFFER_header },  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_RGB_RENDER_TARGET_LENGTH 64
#define MALI_RGB_RENDER_TARGET_ALIGN 64
struct mali_rgb_render_target_packed { uint32_t opaque[16]; };
#define MALI_RGB_RENDER_TARGET_PACKED_T struct mali_rgb_render_target_packed
#define MALI_RGB_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_RGB_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_float_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->writeback_buffer.base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->writeback_buffer.base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->writeback_buffer.row_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->writeback_buffer.surface_stride, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RGB_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_RGB_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff000f) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_float_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RGB_RENDER_TARGET_print(FILE *fp, const struct MALI_RGB_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWrite Enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback Float Format: %s\n", indent, "", mali_float_color_format_as_str(values->writeback_float_format));
   fprintf(fp, "%*sWriteback Block Format: %s\n", indent, "", mali_block_format_as_str(values->writeback_block_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback buffer:\n", indent, "");
   MALI_RT_BUFFER_print(fp, &values->writeback_buffer, indent + 2);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_YUV_RENDER_TARGET {
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   bool                                 write_enable;
   enum mali_color_format               writeback_format;
   enum mali_block_format               writeback_block_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   enum mali_yuv_swizzle                yuv_swizzle;
   bool                                 full_range;
   enum mali_yuv_conversion_mode        conversion_mode;
   enum mali_yuv_cr_siting              cr_siting;
   bool                                 unsigned_cr_range;
   uint64_t                             plane_0_base;
   uint64_t                             plane_1_base;
   uint64_t                             plane_2_base;
   uint64_t                             plane_0_stride;
   uint64_t                             plane_1_2_stride;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_YUV_RENDER_TARGET_header           \
   .yuv_enable = false,  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_YUV_RENDER_TARGET_LENGTH 64
#define MALI_YUV_RENDER_TARGET_ALIGN 64
struct mali_yuv_render_target_packed { uint32_t opaque[16]; };
#define MALI_YUV_RENDER_TARGET_PACKED_T struct mali_yuv_render_target_packed
#define MALI_YUV_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_YUV_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->unsigned_cr_range, 28, 28); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->plane_0_base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->plane_0_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->plane_1_base, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->plane_1_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->plane_2_base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->plane_2_base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->plane_0_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->plane_1_2_stride, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_YUV_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_YUV_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff000f) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xe008ffff) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 3\n"); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->plane_0_base, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->plane_1_base, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->plane_2_base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->plane_0_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->plane_1_2_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_YUV_RENDER_TARGET_print(FILE *fp, const struct MALI_YUV_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWrite Enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback Block Format: %s\n", indent, "", mali_block_format_as_str(values->writeback_block_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sYUV Swizzle: %s\n", indent, "", mali_yuv_swizzle_as_str(values->yuv_swizzle));
   fprintf(fp, "%*sFull Range: %s\n", indent, "", values->full_range ? "true" : "false");
   fprintf(fp, "%*sConversion Mode: %s\n", indent, "", mali_yuv_conversion_mode_as_str(values->conversion_mode));
   fprintf(fp, "%*sCr Siting: %s\n", indent, "", mali_yuv_cr_siting_as_str(values->cr_siting));
   fprintf(fp, "%*sUnsigned Cr Range: %s\n", indent, "", values->unsigned_cr_range ? "true" : "false");
   fprintf(fp, "%*sPlane 0 Base: 0x%" PRIx64 "\n", indent, "", values->plane_0_base);
   fprintf(fp, "%*sPlane 1 Base: 0x%" PRIx64 "\n", indent, "", values->plane_1_base);
   fprintf(fp, "%*sPlane 2 Base: 0x%" PRIx64 "\n", indent, "", values->plane_2_base);
   fprintf(fp, "%*sPlane 0 Stride: 0x%" PRIx64 "\n", indent, "", values->plane_0_stride);
   fprintf(fp, "%*sPlane 1 2 Stride: 0x%" PRIx64 "\n", indent, "", values->plane_1_2_stride);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_AFBC_RGB_RENDER_TARGET {
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   bool                                 write_enable;
   enum mali_color_format               writeback_format;
   enum mali_float_color_format         writeback_float_format;
   enum mali_block_format               writeback_block_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   bool                                 yuv_transform;
   bool                                 split_block;
   bool                                 wide_block;
   bool                                 reverse_issue_order;
   bool                                 front_buffer;
   bool                                 alpha_hint;
   enum mali_afbc_compression_mode      compression_mode;
   uint64_t                             header;
   uint64_t                             row_stride;
   uint64_t                             body_offset;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_AFBC_RGB_RENDER_TARGET_header      \
   .yuv_enable = false,  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_AFBC_RGB_RENDER_TARGET_LENGTH 64
#define MALI_AFBC_RGB_RENDER_TARGET_ALIGN 64
struct mali_afbc_rgb_render_target_packed { uint32_t opaque[16]; };
#define MALI_AFBC_RGB_RENDER_TARGET_PACKED_T struct mali_afbc_rgb_render_target_packed
#define MALI_AFBC_RGB_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_RGB_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_float_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->yuv_transform, 0, 0) | \
            util_bitpack_uint((__unpacked)->split_block, 1, 1) | \
            util_bitpack_uint((__unpacked)->wide_block, 2, 2) | \
            util_bitpack_uint((__unpacked)->reverse_issue_order, 3, 3) | \
            util_bitpack_uint((__unpacked)->front_buffer, 4, 4) | \
            util_bitpack_uint((__unpacked)->alpha_hint, 5, 5) | \
            util_bitpack_uint((__unpacked)->compression_mode, 10, 15); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->header, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->header, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->body_offset, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_RGB_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_RGB_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff000f) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffff03c0) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_float_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->yuv_transform, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->split_block, &__tmp_packed.opaque[0], 65, 65); \
   __gen_unpack_uint((__unpacked)->wide_block, &__tmp_packed.opaque[0], 66, 66); \
   __gen_unpack_uint((__unpacked)->reverse_issue_order, &__tmp_packed.opaque[0], 67, 67); \
   __gen_unpack_uint((__unpacked)->front_buffer, &__tmp_packed.opaque[0], 68, 68); \
   __gen_unpack_uint((__unpacked)->alpha_hint, &__tmp_packed.opaque[0], 69, 69); \
   __gen_unpack_uint((__unpacked)->compression_mode, &__tmp_packed.opaque[0], 74, 79); \
   __gen_unpack_uint((__unpacked)->header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_RGB_RENDER_TARGET_print(FILE *fp, const struct MALI_AFBC_RGB_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWrite Enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback Float Format: %s\n", indent, "", mali_float_color_format_as_str(values->writeback_float_format));
   fprintf(fp, "%*sWriteback Block Format: %s\n", indent, "", mali_block_format_as_str(values->writeback_block_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sYUV Transform: %s\n", indent, "", values->yuv_transform ? "true" : "false");
   fprintf(fp, "%*sSplit block: %s\n", indent, "", values->split_block ? "true" : "false");
   fprintf(fp, "%*sWide block: %s\n", indent, "", values->wide_block ? "true" : "false");
   fprintf(fp, "%*sReverse issue order: %s\n", indent, "", values->reverse_issue_order ? "true" : "false");
   fprintf(fp, "%*sFront buffer: %s\n", indent, "", values->front_buffer ? "true" : "false");
   fprintf(fp, "%*sAlpha hint: %s\n", indent, "", values->alpha_hint ? "true" : "false");
   fprintf(fp, "%*sCompression mode: %s\n", indent, "", mali_afbc_compression_mode_as_str(values->compression_mode));
   fprintf(fp, "%*sHeader: 0x%" PRIx64 "\n", indent, "", values->header);
   fprintf(fp, "%*sRow stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sBody offset: 0x%" PRIx64 "\n", indent, "", values->body_offset);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_AFBC_YUV_RENDER_TARGET {
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   bool                                 write_enable;
   enum mali_color_format               writeback_format;
   enum mali_block_format               writeback_block_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   bool                                 yuv_transform;
   bool                                 split_block;
   bool                                 wide_block;
   bool                                 reverse_issue_order;
   bool                                 front_buffer;
   bool                                 alpha_hint;
   enum mali_afbc_compression_mode      compression_mode;
   enum mali_yuv_swizzle                yuv_swizzle;
   bool                                 full_range;
   enum mali_yuv_conversion_mode        conversion_mode;
   enum mali_yuv_cr_siting              cr_siting;
   bool                                 unsigned_cr_range;
   uint64_t                             header;
   uint64_t                             row_stride;
   uint64_t                             body_offset;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_AFBC_YUV_RENDER_TARGET_header      \
   .yuv_enable = true,  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_AFBC_YUV_RENDER_TARGET_LENGTH 64
#define MALI_AFBC_YUV_RENDER_TARGET_ALIGN 64
struct mali_afbc_yuv_render_target_packed { uint32_t opaque[16]; };
#define MALI_AFBC_YUV_RENDER_TARGET_PACKED_T struct mali_afbc_yuv_render_target_packed
#define MALI_AFBC_YUV_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_YUV_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->yuv_transform, 0, 0) | \
            util_bitpack_uint((__unpacked)->split_block, 1, 1) | \
            util_bitpack_uint((__unpacked)->wide_block, 2, 2) | \
            util_bitpack_uint((__unpacked)->reverse_issue_order, 3, 3) | \
            util_bitpack_uint((__unpacked)->front_buffer, 4, 4) | \
            util_bitpack_uint((__unpacked)->alpha_hint, 5, 5) | \
            util_bitpack_uint((__unpacked)->compression_mode, 10, 15) | \
            util_bitpack_uint((__unpacked)->yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->unsigned_cr_range, 28, 28); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->header, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->header, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->body_offset, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_YUV_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_YUV_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff000f) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xe00803c0) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->yuv_transform, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->split_block, &__tmp_packed.opaque[0], 65, 65); \
   __gen_unpack_uint((__unpacked)->wide_block, &__tmp_packed.opaque[0], 66, 66); \
   __gen_unpack_uint((__unpacked)->reverse_issue_order, &__tmp_packed.opaque[0], 67, 67); \
   __gen_unpack_uint((__unpacked)->front_buffer, &__tmp_packed.opaque[0], 68, 68); \
   __gen_unpack_uint((__unpacked)->alpha_hint, &__tmp_packed.opaque[0], 69, 69); \
   __gen_unpack_uint((__unpacked)->compression_mode, &__tmp_packed.opaque[0], 74, 79); \
   __gen_unpack_uint((__unpacked)->yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_YUV_RENDER_TARGET_print(FILE *fp, const struct MALI_AFBC_YUV_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWrite Enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback Block Format: %s\n", indent, "", mali_block_format_as_str(values->writeback_block_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sYUV Transform: %s\n", indent, "", values->yuv_transform ? "true" : "false");
   fprintf(fp, "%*sSplit block: %s\n", indent, "", values->split_block ? "true" : "false");
   fprintf(fp, "%*sWide block: %s\n", indent, "", values->wide_block ? "true" : "false");
   fprintf(fp, "%*sReverse issue order: %s\n", indent, "", values->reverse_issue_order ? "true" : "false");
   fprintf(fp, "%*sFront buffer: %s\n", indent, "", values->front_buffer ? "true" : "false");
   fprintf(fp, "%*sAlpha hint: %s\n", indent, "", values->alpha_hint ? "true" : "false");
   fprintf(fp, "%*sCompression mode: %s\n", indent, "", mali_afbc_compression_mode_as_str(values->compression_mode));
   fprintf(fp, "%*sYUV Swizzle: %s\n", indent, "", mali_yuv_swizzle_as_str(values->yuv_swizzle));
   fprintf(fp, "%*sFull Range: %s\n", indent, "", values->full_range ? "true" : "false");
   fprintf(fp, "%*sConversion Mode: %s\n", indent, "", mali_yuv_conversion_mode_as_str(values->conversion_mode));
   fprintf(fp, "%*sCr Siting: %s\n", indent, "", mali_yuv_cr_siting_as_str(values->cr_siting));
   fprintf(fp, "%*sUnsigned Cr Range: %s\n", indent, "", values->unsigned_cr_range ? "true" : "false");
   fprintf(fp, "%*sHeader: 0x%" PRIx64 "\n", indent, "", values->header);
   fprintf(fp, "%*sRow stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sBody offset: 0x%" PRIx64 "\n", indent, "", values->body_offset);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_RENDER_TARGET {
   struct MALI_RGB_RENDER_TARGET        rgb;
   struct MALI_YUV_RENDER_TARGET        yuv;
   struct MALI_AFBC_RGB_RENDER_TARGET   afbc_rgb;
   struct MALI_AFBC_YUV_RENDER_TARGET   afbc_yuv;
};

#define MALI_RENDER_TARGET_header               \
   .rgb = { MALI_RGB_RENDER_TARGET_header },  \
   .yuv = { MALI_YUV_RENDER_TARGET_header },  \
   .afbc_rgb = { MALI_AFBC_RGB_RENDER_TARGET_header },  \
   .afbc_yuv = { MALI_AFBC_YUV_RENDER_TARGET_header }

#define MALI_RENDER_TARGET_LENGTH 64
#define MALI_RENDER_TARGET_ALIGN 64
struct mali_render_target_packed { uint32_t opaque[16]; };
#define MALI_RENDER_TARGET_PACKED_T struct mali_render_target_packed
#define MALI_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_RENDER_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->rgb.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->rgb.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->rgb.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->rgb.internal_format, 26, 31) | \
            util_bitpack_uint((__unpacked)->yuv.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->yuv.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->yuv.internal_format, 26, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.internal_format, 26, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->rgb.write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->rgb.writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->rgb.writeback_float_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->rgb.writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->rgb.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->rgb.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->rgb.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->rgb.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->rgb.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->yuv.write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->yuv.writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->yuv.writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->yuv.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->yuv.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->yuv.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->yuv.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->yuv.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.writeback_float_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->yuv.yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->yuv.full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->yuv.conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->yuv.cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->yuv.unsigned_cr_range, 28, 28) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.yuv_transform, 0, 0) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.split_block, 1, 1) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.wide_block, 2, 2) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.reverse_issue_order, 3, 3) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.front_buffer, 4, 4) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.alpha_hint, 5, 5) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.compression_mode, 10, 15) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.yuv_transform, 0, 0) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.split_block, 1, 1) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.wide_block, 2, 2) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.reverse_issue_order, 3, 3) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.front_buffer, 4, 4) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.alpha_hint, 5, 5) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.compression_mode, 10, 15) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.unsigned_cr_range, 28, 28); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->yuv.plane_0_base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->yuv.plane_0_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->yuv.plane_1_base, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->yuv.plane_1_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->rgb.writeback_buffer.base, 0, 63) | \
            util_bitpack_uint((__unpacked)->yuv.plane_2_base, 0, 63) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.header, 0, 63) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.header, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->rgb.writeback_buffer.base, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->yuv.plane_2_base, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->afbc_rgb.header, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->afbc_yuv.header, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->rgb.writeback_buffer.row_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.plane_0_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.row_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.row_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->rgb.writeback_buffer.surface_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.plane_1_2_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.body_offset, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.body_offset, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->rgb.clear.color_0, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.clear.color_0, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clear.color_0, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->rgb.clear.color_1, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.clear.color_1, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clear.color_1, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->rgb.clear.color_2, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.clear.color_2, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clear.color_2, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->rgb.clear.color_3, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.clear.color_3, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clear.color_3, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff000f) fprintf(stderr, "XXX: Invalid field of Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xe00803c0) fprintf(stderr, "XXX: Invalid field of Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Render Target unpacked at word 3\n"); \
   __gen_unpack_uint((__unpacked)->rgb.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->rgb.internal_buffer_offset = (__unpacked)->rgb.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->rgb.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->rgb.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->rgb.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->rgb.write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_float_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->rgb.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->rgb.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->rgb.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->rgb.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_buffer.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_buffer.row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_buffer.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->rgb.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->rgb.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->rgb.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->rgb.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->yuv.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->yuv.internal_buffer_offset = (__unpacked)->yuv.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->yuv.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->yuv.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->yuv.write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->yuv.writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->yuv.writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->yuv.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->yuv.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->yuv.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->yuv.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->yuv.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->yuv.yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->yuv.full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->yuv.conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->yuv.cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->yuv.unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->yuv.plane_0_base, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->yuv.plane_1_base, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->yuv.plane_2_base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->yuv.plane_0_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->yuv.plane_1_2_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->yuv.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->yuv.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->yuv.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->yuv.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->afbc_rgb.internal_buffer_offset = (__unpacked)->afbc_rgb.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->afbc_rgb.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.writeback_float_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.yuv_transform, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.split_block, &__tmp_packed.opaque[0], 65, 65); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.wide_block, &__tmp_packed.opaque[0], 66, 66); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.reverse_issue_order, &__tmp_packed.opaque[0], 67, 67); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.front_buffer, &__tmp_packed.opaque[0], 68, 68); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.alpha_hint, &__tmp_packed.opaque[0], 69, 69); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.compression_mode, &__tmp_packed.opaque[0], 74, 79); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->afbc_yuv.internal_buffer_offset = (__unpacked)->afbc_yuv.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->afbc_yuv.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.yuv_transform, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.split_block, &__tmp_packed.opaque[0], 65, 65); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.wide_block, &__tmp_packed.opaque[0], 66, 66); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.reverse_issue_order, &__tmp_packed.opaque[0], 67, 67); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.front_buffer, &__tmp_packed.opaque[0], 68, 68); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.alpha_hint, &__tmp_packed.opaque[0], 69, 69); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.compression_mode, &__tmp_packed.opaque[0], 74, 79); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RENDER_TARGET_print(FILE *fp, const struct MALI_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sRGB:\n", indent, "");
   MALI_RGB_RENDER_TARGET_print(fp, &values->rgb, indent + 2);
   fprintf(fp, "%*sYUV:\n", indent, "");
   MALI_YUV_RENDER_TARGET_print(fp, &values->yuv, indent + 2);
   fprintf(fp, "%*sAFBC RGB:\n", indent, "");
   MALI_AFBC_RGB_RENDER_TARGET_print(fp, &values->afbc_rgb, indent + 2);
   fprintf(fp, "%*sAFBC YUV:\n", indent, "");
   MALI_AFBC_YUV_RENDER_TARGET_print(fp, &values->afbc_yuv, indent + 2);
}

#endif
enum mali_chunk_size {
        MALI_CHUNK_SIZE_256_KIB              =      0,
        MALI_CHUNK_SIZE_512_KIB              =      1,
        MALI_CHUNK_SIZE_1_MIB                =      2,
        MALI_CHUNK_SIZE_2_MIB                =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_chunk_size_as_str(enum mali_chunk_size imm)
{
    switch (imm) {
    case MALI_CHUNK_SIZE_256_KIB: return "256 KiB";
    case MALI_CHUNK_SIZE_512_KIB: return "512 KiB";
    case MALI_CHUNK_SIZE_1_MIB: return "1 MiB";
    case MALI_CHUNK_SIZE_2_MIB: return "2 MiB";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_chunk_partition {
        MALI_CHUNK_PARTITION_DYNAMIC         =      0,
        MALI_CHUNK_PARTITION_STATIC_25       =      1,
        MALI_CHUNK_PARTITION_STATIC_50       =      2,
        MALI_CHUNK_PARTITION_STATIC_75       =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_chunk_partition_as_str(enum mali_chunk_partition imm)
{
    switch (imm) {
    case MALI_CHUNK_PARTITION_DYNAMIC: return "Dynamic";
    case MALI_CHUNK_PARTITION_STATIC_25: return "Static 25%";
    case MALI_CHUNK_PARTITION_STATIC_50: return "Static 50%";
    case MALI_CHUNK_PARTITION_STATIC_75: return "Static 75%";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_TILER_HEAP {
   enum mali_descriptor_type            type;
   enum mali_buffer_type                buffer_type;
   enum mali_chunk_size                 chunk_size;
   enum mali_chunk_partition            partitioning;
   uint64_t                             size;
   uint64_t                             base;
   uint64_t                             bottom;
   uint64_t                             top;
};

#define MALI_TILER_HEAP_header                  \
   .type = MALI_DESCRIPTOR_TYPE_BUFFER,  \
   .buffer_type = MALI_BUFFER_TYPE_TILER_HEAP,  \
   .chunk_size = MALI_CHUNK_SIZE_2_MIB,  \
   .partitioning = MALI_CHUNK_PARTITION_DYNAMIC

#define MALI_TILER_HEAP_LENGTH 32
#define MALI_TILER_HEAP_ALIGN 32
struct mali_tiler_heap_packed { uint32_t opaque[8]; };
#define MALI_TILER_HEAP_PACKED_T struct mali_tiler_heap_packed
#define MALI_TILER_HEAP_pack(__packed, __unpacked) \
do { \
   MALI_TILER_HEAP_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->buffer_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->chunk_size, 8, 9) | \
            util_bitpack_uint((__unpacked)->partitioning, 10, 11); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint(ALIGN_POT((__unpacked)->size, 4096), 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->bottom, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->bottom, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->top, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->top, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_HEAP_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_HEAP_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfffff000) fprintf(stderr, "XXX: Invalid field of Tiler Heap unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->buffer_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->chunk_size, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->partitioning, &__tmp_packed.opaque[0], 10, 11); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   assert(!((__unpacked)->size & 0xfff)); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->bottom, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->top, &__tmp_packed.opaque[0], 192, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_HEAP_print(FILE *fp, const struct MALI_TILER_HEAP * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sBuffer type: %s\n", indent, "", mali_buffer_type_as_str(values->buffer_type));
   fprintf(fp, "%*sChunk size: %s\n", indent, "", mali_chunk_size_as_str(values->chunk_size));
   fprintf(fp, "%*sPartitioning: %s\n", indent, "", mali_chunk_partition_as_str(values->partitioning));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sBottom: 0x%" PRIx64 "\n", indent, "", values->bottom);
   fprintf(fp, "%*sTop: 0x%" PRIx64 "\n", indent, "", values->top);
}

#endif
struct MALI_TILER_WEIGHTS {
   uint32_t                             weight0;
   uint32_t                             weight1;
   uint32_t                             weight2;
   uint32_t                             weight3;
   uint32_t                             weight4;
   uint32_t                             weight5;
   uint32_t                             weight6;
   uint32_t                             weight7;
};

#define MALI_TILER_WEIGHTS_header               \
   0

#define MALI_TILER_WEIGHTS_LENGTH 32
struct mali_tiler_weights_packed { uint32_t opaque[8]; };
#define MALI_TILER_WEIGHTS_PACKED_T struct mali_tiler_weights_packed
#define MALI_TILER_WEIGHTS_pack(__packed, __unpacked) \
do { \
   MALI_TILER_WEIGHTS_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->weight0, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->weight1, 16, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->weight2, 16, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->weight3, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->weight4, 16, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->weight5, 16, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->weight6, 16, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->weight7, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_WEIGHTS_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_WEIGHTS_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->weight0, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->weight1, &__tmp_packed.opaque[0], 48, 63); \
   __gen_unpack_uint((__unpacked)->weight2, &__tmp_packed.opaque[0], 80, 95); \
   __gen_unpack_uint((__unpacked)->weight3, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->weight4, &__tmp_packed.opaque[0], 144, 159); \
   __gen_unpack_uint((__unpacked)->weight5, &__tmp_packed.opaque[0], 176, 191); \
   __gen_unpack_uint((__unpacked)->weight6, &__tmp_packed.opaque[0], 208, 223); \
   __gen_unpack_uint((__unpacked)->weight7, &__tmp_packed.opaque[0], 240, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_WEIGHTS_print(FILE *fp, const struct MALI_TILER_WEIGHTS * values, unsigned indent)
{
   fprintf(fp, "%*sWeight0: %u\n", indent, "", values->weight0);
   fprintf(fp, "%*sWeight1: %u\n", indent, "", values->weight1);
   fprintf(fp, "%*sWeight2: %u\n", indent, "", values->weight2);
   fprintf(fp, "%*sWeight3: %u\n", indent, "", values->weight3);
   fprintf(fp, "%*sWeight4: %u\n", indent, "", values->weight4);
   fprintf(fp, "%*sWeight5: %u\n", indent, "", values->weight5);
   fprintf(fp, "%*sWeight6: %u\n", indent, "", values->weight6);
   fprintf(fp, "%*sWeight7: %u\n", indent, "", values->weight7);
}

#endif
struct MALI_TILER_STATE {
   uint64_t                             word0;
   uint64_t                             word1;
   uint64_t                             word2;
   uint64_t                             word3;
   uint64_t                             word4;
   uint64_t                             word5;
   uint64_t                             word6;
   uint64_t                             word7;
   uint64_t                             word8;
   uint64_t                             word9;
   uint64_t                             word10;
   uint64_t                             word11;
   uint64_t                             word12;
   uint64_t                             word13;
   uint64_t                             word14;
   uint64_t                             word15;
};

#define MALI_TILER_STATE_header                 \
   0

#define MALI_TILER_STATE_LENGTH 64
struct mali_tiler_state_packed { uint32_t opaque[16]; };
#define MALI_TILER_STATE_PACKED_T struct mali_tiler_state_packed
#define MALI_TILER_STATE_pack(__packed, __unpacked) \
do { \
   MALI_TILER_STATE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->word0, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->word1, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->word2, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->word3, 0, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->word4, 0, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->word5, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->word6, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->word7, 0, 31); \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->word8, 0, 31); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->word9, 0, 31); \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->word10, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->word11, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->word12, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->word13, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->word14, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->word15, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_STATE_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_STATE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->word0, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->word1, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->word2, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->word3, &__tmp_packed.opaque[0], 96, 127); \
   __gen_unpack_uint((__unpacked)->word4, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->word5, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->word6, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->word7, &__tmp_packed.opaque[0], 224, 255); \
   __gen_unpack_uint((__unpacked)->word8, &__tmp_packed.opaque[0], 256, 287); \
   __gen_unpack_uint((__unpacked)->word9, &__tmp_packed.opaque[0], 288, 319); \
   __gen_unpack_uint((__unpacked)->word10, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->word11, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->word12, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->word13, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->word14, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->word15, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_STATE_print(FILE *fp, const struct MALI_TILER_STATE * values, unsigned indent)
{
   fprintf(fp, "%*sWord0: 0x%" PRIx64 "\n", indent, "", values->word0);
   fprintf(fp, "%*sWord1: 0x%" PRIx64 "\n", indent, "", values->word1);
   fprintf(fp, "%*sWord2: 0x%" PRIx64 "\n", indent, "", values->word2);
   fprintf(fp, "%*sWord3: 0x%" PRIx64 "\n", indent, "", values->word3);
   fprintf(fp, "%*sWord4: 0x%" PRIx64 "\n", indent, "", values->word4);
   fprintf(fp, "%*sWord5: 0x%" PRIx64 "\n", indent, "", values->word5);
   fprintf(fp, "%*sWord6: 0x%" PRIx64 "\n", indent, "", values->word6);
   fprintf(fp, "%*sWord7: 0x%" PRIx64 "\n", indent, "", values->word7);
   fprintf(fp, "%*sWord8: 0x%" PRIx64 "\n", indent, "", values->word8);
   fprintf(fp, "%*sWord9: 0x%" PRIx64 "\n", indent, "", values->word9);
   fprintf(fp, "%*sWord10: 0x%" PRIx64 "\n", indent, "", values->word10);
   fprintf(fp, "%*sWord11: 0x%" PRIx64 "\n", indent, "", values->word11);
   fprintf(fp, "%*sWord12: 0x%" PRIx64 "\n", indent, "", values->word12);
   fprintf(fp, "%*sWord13: 0x%" PRIx64 "\n", indent, "", values->word13);
   fprintf(fp, "%*sWord14: 0x%" PRIx64 "\n", indent, "", values->word14);
   fprintf(fp, "%*sWord15: 0x%" PRIx64 "\n", indent, "", values->word15);
}

#endif
struct MALI_TILER_CONTEXT {
   uint64_t                             polygon_list;
   uint32_t                             hierarchy_mask;
   enum mali_sample_pattern             sample_pattern;
   bool                                 update_cost_table;
   bool                                 sample_test_disable;
   bool                                 first_provoking_vertex;
   uint32_t                             fb_width;
   uint32_t                             fb_height;
   uint32_t                             layer_count;
   int32_t                              layer_offset;
   uint64_t                             heap;
   struct MALI_TILER_WEIGHTS            weights;
   struct MALI_TILER_STATE              state;
};

#define MALI_TILER_CONTEXT_header               \
   .layer_count = 1,  \
   .weights = { MALI_TILER_WEIGHTS_header },  \
   .state = { MALI_TILER_STATE_header }

#define MALI_TILER_CONTEXT_LENGTH 192
#define MALI_TILER_CONTEXT_ALIGN 64
struct mali_tiler_context_packed { uint32_t opaque[48]; };
#define MALI_TILER_CONTEXT_PACKED_T struct mali_tiler_context_packed
#define MALI_TILER_CONTEXT_pack(__packed, __unpacked) \
do { \
   MALI_TILER_CONTEXT_PACKED_T __tmp_packed; \
   assert((__unpacked)->fb_width >= 1); \
   assert((__unpacked)->fb_height >= 1); \
   assert((__unpacked)->layer_count >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->polygon_list, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->polygon_list, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->hierarchy_mask, 0, 12) | \
            util_bitpack_uint((__unpacked)->sample_pattern, 13, 15) | \
            util_bitpack_uint((__unpacked)->update_cost_table, 16, 16) | \
            util_bitpack_uint((__unpacked)->sample_test_disable, 17, 17) | \
            util_bitpack_uint((__unpacked)->first_provoking_vertex, 18, 18); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->fb_width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->fb_height - 1, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->layer_count - 1, 0, 7) | \
            util_bitpack_sint((__unpacked)->layer_offset, 8, 16); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->heap, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->heap, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->weights.weight0, 16, 31); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->weights.weight1, 16, 31); \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->weights.weight2, 16, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->weights.weight3, 16, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->weights.weight4, 16, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->weights.weight5, 16, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->weights.weight6, 16, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->weights.weight7, 16, 31); \
   __tmp_packed.opaque[16] = 0; \
   __tmp_packed.opaque[17] = 0; \
   __tmp_packed.opaque[18] = 0; \
   __tmp_packed.opaque[19] = 0; \
   __tmp_packed.opaque[20] = 0; \
   __tmp_packed.opaque[21] = 0; \
   __tmp_packed.opaque[22] = 0; \
   __tmp_packed.opaque[23] = 0; \
   __tmp_packed.opaque[24] = 0; \
   __tmp_packed.opaque[25] = 0; \
   __tmp_packed.opaque[26] = 0; \
   __tmp_packed.opaque[27] = 0; \
   __tmp_packed.opaque[28] = 0; \
   __tmp_packed.opaque[29] = 0; \
   __tmp_packed.opaque[30] = 0; \
   __tmp_packed.opaque[31] = 0; \
   __tmp_packed.opaque[32] = util_bitpack_uint((__unpacked)->state.word0, 0, 31); \
   __tmp_packed.opaque[33] = util_bitpack_uint((__unpacked)->state.word1, 0, 31); \
   __tmp_packed.opaque[34] = util_bitpack_uint((__unpacked)->state.word2, 0, 31); \
   __tmp_packed.opaque[35] = util_bitpack_uint((__unpacked)->state.word3, 0, 31); \
   __tmp_packed.opaque[36] = util_bitpack_uint((__unpacked)->state.word4, 0, 31); \
   __tmp_packed.opaque[37] = util_bitpack_uint((__unpacked)->state.word5, 0, 31); \
   __tmp_packed.opaque[38] = util_bitpack_uint((__unpacked)->state.word6, 0, 31); \
   __tmp_packed.opaque[39] = util_bitpack_uint((__unpacked)->state.word7, 0, 31); \
   __tmp_packed.opaque[40] = util_bitpack_uint((__unpacked)->state.word8, 0, 31); \
   __tmp_packed.opaque[41] = util_bitpack_uint((__unpacked)->state.word9, 0, 31); \
   __tmp_packed.opaque[42] = util_bitpack_uint((__unpacked)->state.word10, 0, 31); \
   __tmp_packed.opaque[43] = util_bitpack_uint((__unpacked)->state.word11, 0, 31); \
   __tmp_packed.opaque[44] = util_bitpack_uint((__unpacked)->state.word12, 0, 31); \
   __tmp_packed.opaque[45] = util_bitpack_uint((__unpacked)->state.word13, 0, 31); \
   __tmp_packed.opaque[46] = util_bitpack_uint((__unpacked)->state.word14, 0, 31); \
   __tmp_packed.opaque[47] = util_bitpack_uint((__unpacked)->state.word15, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_CONTEXT_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_CONTEXT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[2] & 0xfff80000) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 2\n"); \
   if (__tmp_packed.opaque[4] & 0xfffe0000) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 5\n"); \
   if (__tmp_packed.opaque[8] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 15\n"); \
   if (__tmp_packed.opaque[16] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 16\n"); \
   if (__tmp_packed.opaque[17] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 17\n"); \
   if (__tmp_packed.opaque[18] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 18\n"); \
   if (__tmp_packed.opaque[19] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 19\n"); \
   if (__tmp_packed.opaque[20] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 20\n"); \
   if (__tmp_packed.opaque[21] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 21\n"); \
   if (__tmp_packed.opaque[22] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 22\n"); \
   if (__tmp_packed.opaque[23] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 23\n"); \
   if (__tmp_packed.opaque[24] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 24\n"); \
   if (__tmp_packed.opaque[25] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 25\n"); \
   if (__tmp_packed.opaque[26] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 26\n"); \
   if (__tmp_packed.opaque[27] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 27\n"); \
   if (__tmp_packed.opaque[28] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 28\n"); \
   if (__tmp_packed.opaque[29] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 29\n"); \
   if (__tmp_packed.opaque[30] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 30\n"); \
   if (__tmp_packed.opaque[31] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 31\n"); \
   __gen_unpack_uint((__unpacked)->polygon_list, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->hierarchy_mask, &__tmp_packed.opaque[0], 64, 76); \
   __gen_unpack_uint((__unpacked)->sample_pattern, &__tmp_packed.opaque[0], 77, 79); \
   __gen_unpack_uint((__unpacked)->update_cost_table, &__tmp_packed.opaque[0], 80, 80); \
   __gen_unpack_uint((__unpacked)->sample_test_disable, &__tmp_packed.opaque[0], 81, 81); \
   __gen_unpack_uint((__unpacked)->first_provoking_vertex, &__tmp_packed.opaque[0], 82, 82); \
   __gen_unpack_uint((__unpacked)->fb_width, &__tmp_packed.opaque[0], 96, 111); \
   (__unpacked)->fb_width = (__unpacked)->fb_width + 1; \
   __gen_unpack_uint((__unpacked)->fb_height, &__tmp_packed.opaque[0], 112, 127); \
   (__unpacked)->fb_height = (__unpacked)->fb_height + 1; \
   __gen_unpack_uint((__unpacked)->layer_count, &__tmp_packed.opaque[0], 128, 135); \
   (__unpacked)->layer_count = (__unpacked)->layer_count + 1; \
   __gen_unpack_sint((__unpacked)->layer_offset, &__tmp_packed.opaque[0], 136, 144); \
   __gen_unpack_uint((__unpacked)->heap, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->weights.weight0, &__tmp_packed.opaque[0], 272, 287); \
   __gen_unpack_uint((__unpacked)->weights.weight1, &__tmp_packed.opaque[0], 304, 319); \
   __gen_unpack_uint((__unpacked)->weights.weight2, &__tmp_packed.opaque[0], 336, 351); \
   __gen_unpack_uint((__unpacked)->weights.weight3, &__tmp_packed.opaque[0], 368, 383); \
   __gen_unpack_uint((__unpacked)->weights.weight4, &__tmp_packed.opaque[0], 400, 415); \
   __gen_unpack_uint((__unpacked)->weights.weight5, &__tmp_packed.opaque[0], 432, 447); \
   __gen_unpack_uint((__unpacked)->weights.weight6, &__tmp_packed.opaque[0], 464, 479); \
   __gen_unpack_uint((__unpacked)->weights.weight7, &__tmp_packed.opaque[0], 496, 511); \
   __gen_unpack_uint((__unpacked)->state.word0, &__tmp_packed.opaque[0], 1024, 1055); \
   __gen_unpack_uint((__unpacked)->state.word1, &__tmp_packed.opaque[0], 1056, 1087); \
   __gen_unpack_uint((__unpacked)->state.word2, &__tmp_packed.opaque[0], 1088, 1119); \
   __gen_unpack_uint((__unpacked)->state.word3, &__tmp_packed.opaque[0], 1120, 1151); \
   __gen_unpack_uint((__unpacked)->state.word4, &__tmp_packed.opaque[0], 1152, 1183); \
   __gen_unpack_uint((__unpacked)->state.word5, &__tmp_packed.opaque[0], 1184, 1215); \
   __gen_unpack_uint((__unpacked)->state.word6, &__tmp_packed.opaque[0], 1216, 1247); \
   __gen_unpack_uint((__unpacked)->state.word7, &__tmp_packed.opaque[0], 1248, 1279); \
   __gen_unpack_uint((__unpacked)->state.word8, &__tmp_packed.opaque[0], 1280, 1311); \
   __gen_unpack_uint((__unpacked)->state.word9, &__tmp_packed.opaque[0], 1312, 1343); \
   __gen_unpack_uint((__unpacked)->state.word10, &__tmp_packed.opaque[0], 1344, 1375); \
   __gen_unpack_uint((__unpacked)->state.word11, &__tmp_packed.opaque[0], 1376, 1407); \
   __gen_unpack_uint((__unpacked)->state.word12, &__tmp_packed.opaque[0], 1408, 1439); \
   __gen_unpack_uint((__unpacked)->state.word13, &__tmp_packed.opaque[0], 1440, 1471); \
   __gen_unpack_uint((__unpacked)->state.word14, &__tmp_packed.opaque[0], 1472, 1503); \
   __gen_unpack_uint((__unpacked)->state.word15, &__tmp_packed.opaque[0], 1504, 1535); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_CONTEXT_print(FILE *fp, const struct MALI_TILER_CONTEXT * values, unsigned indent)
{
   fprintf(fp, "%*sPolygon List: 0x%" PRIx64 "\n", indent, "", values->polygon_list);
   fprintf(fp, "%*sHierarchy Mask: %u\n", indent, "", values->hierarchy_mask);
   fprintf(fp, "%*sSample Pattern: %s\n", indent, "", mali_sample_pattern_as_str(values->sample_pattern));
   fprintf(fp, "%*sUpdate Cost Table: %s\n", indent, "", values->update_cost_table ? "true" : "false");
   fprintf(fp, "%*sSample test disable: %s\n", indent, "", values->sample_test_disable ? "true" : "false");
   fprintf(fp, "%*sFirst provoking vertex: %s\n", indent, "", values->first_provoking_vertex ? "true" : "false");
   fprintf(fp, "%*sFB Width: %u\n", indent, "", values->fb_width);
   fprintf(fp, "%*sFB Height: %u\n", indent, "", values->fb_height);
   fprintf(fp, "%*sLayer count: %u\n", indent, "", values->layer_count);
   fprintf(fp, "%*sLayer offset: %" PRId64 "\n", indent, "", (int64_t)values->layer_offset);
   fprintf(fp, "%*sHeap: 0x%" PRIx64 "\n", indent, "", values->heap);
   fprintf(fp, "%*sWeights:\n", indent, "");
   MALI_TILER_WEIGHTS_print(fp, &values->weights, indent + 2);
   fprintf(fp, "%*sState:\n", indent, "");
   MALI_TILER_STATE_print(fp, &values->state, indent + 2);
}

#endif
struct MALI_FRAMEBUFFER_PADDING {
   int dummy;
};

#define MALI_FRAMEBUFFER_PADDING_header         \
   0

#define MALI_FRAMEBUFFER_PADDING_LENGTH 64
struct mali_framebuffer_padding_packed { uint32_t opaque[16]; };
#define MALI_FRAMEBUFFER_PADDING_PACKED_T struct mali_framebuffer_padding_packed
#define MALI_FRAMEBUFFER_PADDING_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PADDING_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_PADDING_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PADDING_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 15\n"); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_PADDING_print(FILE *fp, const struct MALI_FRAMEBUFFER_PADDING * values, unsigned indent)
{
}

#endif
struct mali_framebuffer_packed {
   uint32_t opaque[32];
};

#define MALI_FRAMEBUFFER_PACKED_T struct mali_framebuffer_packed
#define MALI_FRAMEBUFFER_LENGTH 128
#define MALI_FRAMEBUFFER_ALIGN 64
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_TYPE struct MALI_FRAMEBUFFER_PARAMETERS
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_PACKED_TYPE MALI_FRAMEBUFFER_PARAMETERS_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_header MALI_FRAMEBUFFER_PARAMETERS_header
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_pack MALI_FRAMEBUFFER_PARAMETERS_pack
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_unpack MALI_FRAMEBUFFER_PARAMETERS_unpack
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_print MALI_FRAMEBUFFER_PARAMETERS_print
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_OFFSET 0
#define MALI_FRAMEBUFFER_SECTION_PADDING_TYPE struct MALI_FRAMEBUFFER_PADDING
#define MALI_FRAMEBUFFER_SECTION_PADDING_PACKED_TYPE MALI_FRAMEBUFFER_PADDING_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_PADDING_header MALI_FRAMEBUFFER_PADDING_header
#define MALI_FRAMEBUFFER_SECTION_PADDING_pack MALI_FRAMEBUFFER_PADDING_pack
#define MALI_FRAMEBUFFER_SECTION_PADDING_unpack MALI_FRAMEBUFFER_PADDING_unpack
#define MALI_FRAMEBUFFER_SECTION_PADDING_print MALI_FRAMEBUFFER_PADDING_print
#define MALI_FRAMEBUFFER_SECTION_PADDING_OFFSET 64

struct MALI_FRAMEBUFFER_POINTER {
   bool                                 type;
   bool                                 zs_crc_extension_present;
   uint32_t                             render_target_count;
   uint64_t                             pointer;
};

#define MALI_FRAMEBUFFER_POINTER_header         \
   .type = true

#define MALI_FRAMEBUFFER_POINTER_LENGTH 8
struct mali_framebuffer_pointer_packed { uint32_t opaque[2]; };
#define MALI_FRAMEBUFFER_POINTER_PACKED_T struct mali_framebuffer_pointer_packed
#define MALI_FRAMEBUFFER_POINTER_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_POINTER_PACKED_T __tmp_packed; \
   assert((__unpacked)->render_target_count >= 1); \
   assert(((__unpacked)->pointer & 0x3f) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 0) | \
            util_bitpack_uint((__unpacked)->zs_crc_extension_present, 1, 1) | \
            util_bitpack_uint((__unpacked)->render_target_count - 1, 2, 5) | \
            util_bitpack_uint((__unpacked)->pointer >> 6, 6, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pointer >> 6, 6, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_POINTER_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_POINTER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->zs_crc_extension_present, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->render_target_count, &__tmp_packed.opaque[0], 2, 5); \
   (__unpacked)->render_target_count = (__unpacked)->render_target_count + 1; \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 6, 63); \
   (__unpacked)->pointer = (__unpacked)->pointer << 6; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_POINTER_print(FILE *fp, const struct MALI_FRAMEBUFFER_POINTER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", values->type ? "true" : "false");
   fprintf(fp, "%*sZS CRC Extension present: %s\n", indent, "", values->zs_crc_extension_present ? "true" : "false");
   fprintf(fp, "%*sRender target count: %u\n", indent, "", values->render_target_count);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
}

#endif
struct MALI_JOB_HEADER {
   uint64_t                             exception_status;
   uint64_t                             first_incomplete_task;
   uint64_t                             fault_pointer;
   enum mali_job_type                   type;
   bool                                 barrier;
   bool                                 suppress_prefetch;
   bool                                 relax_dependency_1;
   bool                                 relax_dependency_2;
   uint32_t                             index;
   uint32_t                             dependency_1;
   uint32_t                             dependency_2;
   uint64_t                             next;
};

#define MALI_JOB_HEADER_header                  \
   0

#define MALI_JOB_HEADER_LENGTH 32
#define MALI_JOB_HEADER_ALIGN 128
struct mali_job_header_packed { uint32_t opaque[8]; };
#define MALI_JOB_HEADER_PACKED_T struct mali_job_header_packed
#define MALI_JOB_HEADER_pack(__packed, __unpacked) \
do { \
   MALI_JOB_HEADER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->exception_status, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->first_incomplete_task, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->fault_pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->fault_pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->type, 1, 7) | \
            util_bitpack_uint((__unpacked)->barrier, 8, 8) | \
            util_bitpack_uint((__unpacked)->suppress_prefetch, 11, 11) | \
            util_bitpack_uint((__unpacked)->relax_dependency_1, 14, 14) | \
            util_bitpack_uint((__unpacked)->relax_dependency_2, 15, 15) | \
            util_bitpack_uint((__unpacked)->index, 16, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->dependency_1, 0, 15) | \
            util_bitpack_uint((__unpacked)->dependency_2, 16, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->next, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->next, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_JOB_HEADER_unpack(__packed, __unpacked) \
do { \
   MALI_JOB_HEADER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[4] & 0x3601) fprintf(stderr, "XXX: Invalid field of Job Header unpacked at word 4\n"); \
   __gen_unpack_uint((__unpacked)->exception_status, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->first_incomplete_task, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->fault_pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 129, 135); \
   __gen_unpack_uint((__unpacked)->barrier, &__tmp_packed.opaque[0], 136, 136); \
   __gen_unpack_uint((__unpacked)->suppress_prefetch, &__tmp_packed.opaque[0], 139, 139); \
   __gen_unpack_uint((__unpacked)->relax_dependency_1, &__tmp_packed.opaque[0], 142, 142); \
   __gen_unpack_uint((__unpacked)->relax_dependency_2, &__tmp_packed.opaque[0], 143, 143); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 144, 159); \
   __gen_unpack_uint((__unpacked)->dependency_1, &__tmp_packed.opaque[0], 160, 175); \
   __gen_unpack_uint((__unpacked)->dependency_2, &__tmp_packed.opaque[0], 176, 191); \
   __gen_unpack_uint((__unpacked)->next, &__tmp_packed.opaque[0], 192, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_JOB_HEADER_print(FILE *fp, const struct MALI_JOB_HEADER * values, unsigned indent)
{
   fprintf(fp, "%*sException Status: 0x%" PRIx64 "\n", indent, "", values->exception_status);
   fprintf(fp, "%*sFirst Incomplete Task: 0x%" PRIx64 "\n", indent, "", values->first_incomplete_task);
   fprintf(fp, "%*sFault Pointer: 0x%" PRIx64 "\n", indent, "", values->fault_pointer);
   fprintf(fp, "%*sType: %s\n", indent, "", mali_job_type_as_str(values->type));
   fprintf(fp, "%*sBarrier: %s\n", indent, "", values->barrier ? "true" : "false");
   fprintf(fp, "%*sSuppress Prefetch: %s\n", indent, "", values->suppress_prefetch ? "true" : "false");
   fprintf(fp, "%*sRelax Dependency 1: %s\n", indent, "", values->relax_dependency_1 ? "true" : "false");
   fprintf(fp, "%*sRelax Dependency 2: %s\n", indent, "", values->relax_dependency_2 ? "true" : "false");
   fprintf(fp, "%*sIndex: %u\n", indent, "", values->index);
   fprintf(fp, "%*sDependency 1: %u\n", indent, "", values->dependency_1);
   fprintf(fp, "%*sDependency 2: %u\n", indent, "", values->dependency_2);
   fprintf(fp, "%*sNext: 0x%" PRIx64 "\n", indent, "", values->next);
}

#endif
struct MALI_FRAGMENT_JOB_PAYLOAD {
   uint32_t                             bound_min_x;
   uint32_t                             bound_min_y;
   uint32_t                             bound_max_x;
   uint32_t                             bound_max_y;
   enum mali_tile_render_order          tile_render_order;
   bool                                 has_tile_enable_map;
   uint64_t                             framebuffer;
   uint64_t                             tile_enable_map;
   uint32_t                             tile_enable_map_row_stride;
};

#define MALI_FRAGMENT_JOB_PAYLOAD_header        \
   .tile_render_order = MALI_TILE_RENDER_ORDER_Z_ORDER

#define MALI_FRAGMENT_JOB_PAYLOAD_LENGTH 32
struct mali_fragment_job_payload_packed { uint32_t opaque[8]; };
#define MALI_FRAGMENT_JOB_PAYLOAD_PACKED_T struct mali_fragment_job_payload_packed
#define MALI_FRAGMENT_JOB_PAYLOAD_pack(__packed, __unpacked) \
do { \
   MALI_FRAGMENT_JOB_PAYLOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->bound_min_x, 0, 11) | \
            util_bitpack_uint((__unpacked)->bound_min_y, 16, 27); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->bound_max_x, 0, 11) | \
            util_bitpack_uint((__unpacked)->bound_max_y, 16, 27) | \
            util_bitpack_uint((__unpacked)->tile_render_order, 28, 30) | \
            util_bitpack_uint((__unpacked)->has_tile_enable_map, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->framebuffer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->framebuffer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->tile_enable_map, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->tile_enable_map, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->tile_enable_map_row_stride, 0, 7); \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAGMENT_JOB_PAYLOAD_unpack(__packed, __unpacked) \
do { \
   MALI_FRAGMENT_JOB_PAYLOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf000f000) fprintf(stderr, "XXX: Invalid field of Fragment Job Payload unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf000) fprintf(stderr, "XXX: Invalid field of Fragment Job Payload unpacked at word 1\n"); \
   if (__tmp_packed.opaque[6] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Fragment Job Payload unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Fragment Job Payload unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->bound_min_x, &__tmp_packed.opaque[0], 0, 11); \
   __gen_unpack_uint((__unpacked)->bound_min_y, &__tmp_packed.opaque[0], 16, 27); \
   __gen_unpack_uint((__unpacked)->bound_max_x, &__tmp_packed.opaque[0], 32, 43); \
   __gen_unpack_uint((__unpacked)->bound_max_y, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->tile_render_order, &__tmp_packed.opaque[0], 60, 62); \
   __gen_unpack_uint((__unpacked)->has_tile_enable_map, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->framebuffer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->tile_enable_map, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->tile_enable_map_row_stride, &__tmp_packed.opaque[0], 192, 199); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAGMENT_JOB_PAYLOAD_print(FILE *fp, const struct MALI_FRAGMENT_JOB_PAYLOAD * values, unsigned indent)
{
   fprintf(fp, "%*sBound Min X: %u\n", indent, "", values->bound_min_x);
   fprintf(fp, "%*sBound Min Y: %u\n", indent, "", values->bound_min_y);
   fprintf(fp, "%*sBound Max X: %u\n", indent, "", values->bound_max_x);
   fprintf(fp, "%*sBound Max Y: %u\n", indent, "", values->bound_max_y);
   fprintf(fp, "%*sTile render order: %s\n", indent, "", mali_tile_render_order_as_str(values->tile_render_order));
   fprintf(fp, "%*sHas Tile Enable Map: %s\n", indent, "", values->has_tile_enable_map ? "true" : "false");
   fprintf(fp, "%*sFramebuffer: 0x%" PRIx64 "\n", indent, "", values->framebuffer);
   fprintf(fp, "%*sTile Enable Map: 0x%" PRIx64 "\n", indent, "", values->tile_enable_map);
   fprintf(fp, "%*sTile Enable Map Row Stride: %u\n", indent, "", values->tile_enable_map_row_stride);
}

#endif
struct mali_fragment_job_packed {
   uint32_t opaque[16];
};

#define MALI_FRAGMENT_JOB_PACKED_T struct mali_fragment_job_packed
#define MALI_FRAGMENT_JOB_LENGTH 64
#define MALI_FRAGMENT_JOB_ALIGN 128
#define MALI_FRAGMENT_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_FRAGMENT_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_FRAGMENT_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_FRAGMENT_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_FRAGMENT_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_FRAGMENT_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_FRAGMENT_JOB_SECTION_HEADER_OFFSET 0
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_TYPE struct MALI_FRAGMENT_JOB_PAYLOAD
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_PACKED_TYPE MALI_FRAGMENT_JOB_PAYLOAD_PACKED_T
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_header MALI_FRAGMENT_JOB_PAYLOAD_header
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_pack MALI_FRAGMENT_JOB_PAYLOAD_pack
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_unpack MALI_FRAGMENT_JOB_PAYLOAD_unpack
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_print MALI_FRAGMENT_JOB_PAYLOAD_print
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_OFFSET 32

enum mali_write_value_type {
        MALI_WRITE_VALUE_TYPE_CYCLE_COUNTER  =      1,
        MALI_WRITE_VALUE_TYPE_SYSTEM_TIMESTAMP =      2,
        MALI_WRITE_VALUE_TYPE_ZERO           =      3,
        MALI_WRITE_VALUE_TYPE_IMMEDIATE_8    =      4,
        MALI_WRITE_VALUE_TYPE_IMMEDIATE_16   =      5,
        MALI_WRITE_VALUE_TYPE_IMMEDIATE_32   =      6,
        MALI_WRITE_VALUE_TYPE_IMMEDIATE_64   =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_write_value_type_as_str(enum mali_write_value_type imm)
{
    switch (imm) {
    case MALI_WRITE_VALUE_TYPE_CYCLE_COUNTER: return "Cycle Counter";
    case MALI_WRITE_VALUE_TYPE_SYSTEM_TIMESTAMP: return "System Timestamp";
    case MALI_WRITE_VALUE_TYPE_ZERO: return "Zero";
    case MALI_WRITE_VALUE_TYPE_IMMEDIATE_8: return "Immediate 8";
    case MALI_WRITE_VALUE_TYPE_IMMEDIATE_16: return "Immediate 16";
    case MALI_WRITE_VALUE_TYPE_IMMEDIATE_32: return "Immediate 32";
    case MALI_WRITE_VALUE_TYPE_IMMEDIATE_64: return "Immediate 64";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_WRITE_VALUE_JOB_PAYLOAD {
   uint64_t                             address;
   enum mali_write_value_type           type;
   uint64_t                             immediate_value;
};

#define MALI_WRITE_VALUE_JOB_PAYLOAD_header     \
   0

#define MALI_WRITE_VALUE_JOB_PAYLOAD_LENGTH 24
struct mali_write_value_job_payload_packed { uint32_t opaque[6]; };
#define MALI_WRITE_VALUE_JOB_PAYLOAD_PACKED_T struct mali_write_value_job_payload_packed
#define MALI_WRITE_VALUE_JOB_PAYLOAD_pack(__packed, __unpacked) \
do { \
   MALI_WRITE_VALUE_JOB_PAYLOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->address, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->type, 0, 31); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->immediate_value, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->immediate_value, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_WRITE_VALUE_JOB_PAYLOAD_unpack(__packed, __unpacked) \
do { \
   MALI_WRITE_VALUE_JOB_PAYLOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Write Value Job Payload unpacked at word 3\n"); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->immediate_value, &__tmp_packed.opaque[0], 128, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_WRITE_VALUE_JOB_PAYLOAD_print(FILE *fp, const struct MALI_WRITE_VALUE_JOB_PAYLOAD * values, unsigned indent)
{
   fprintf(fp, "%*sAddress: 0x%" PRIx64 "\n", indent, "", values->address);
   fprintf(fp, "%*sType: %s\n", indent, "", mali_write_value_type_as_str(values->type));
   fprintf(fp, "%*sImmediate Value: 0x%" PRIx64 "\n", indent, "", values->immediate_value);
}

#endif
struct MALI_CACHE_FLUSH_JOB_PAYLOAD {
   bool                                 clean_shader_core_ls;
   bool                                 invalidate_shader_core_ls;
   bool                                 invalidate_shader_core_other;
   bool                                 job_manager_clean;
   bool                                 job_manager_invalidate;
   bool                                 tiler_clean;
   bool                                 tiler_invalidate;
   bool                                 l2_clean;
   bool                                 l2_invalidate;
};

#define MALI_CACHE_FLUSH_JOB_PAYLOAD_header     \
   0

#define MALI_CACHE_FLUSH_JOB_PAYLOAD_LENGTH 8
struct mali_cache_flush_job_payload_packed { uint32_t opaque[2]; };
#define MALI_CACHE_FLUSH_JOB_PAYLOAD_PACKED_T struct mali_cache_flush_job_payload_packed
#define MALI_CACHE_FLUSH_JOB_PAYLOAD_pack(__packed, __unpacked) \
do { \
   MALI_CACHE_FLUSH_JOB_PAYLOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->clean_shader_core_ls, 0, 0) | \
            util_bitpack_uint((__unpacked)->invalidate_shader_core_ls, 1, 1) | \
            util_bitpack_uint((__unpacked)->invalidate_shader_core_other, 2, 2) | \
            util_bitpack_uint((__unpacked)->job_manager_clean, 16, 16) | \
            util_bitpack_uint((__unpacked)->job_manager_invalidate, 17, 17) | \
            util_bitpack_uint((__unpacked)->tiler_clean, 24, 24) | \
            util_bitpack_uint((__unpacked)->tiler_invalidate, 25, 25); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->l2_clean, 0, 0) | \
            util_bitpack_uint((__unpacked)->l2_invalidate, 1, 1); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CACHE_FLUSH_JOB_PAYLOAD_unpack(__packed, __unpacked) \
do { \
   MALI_CACHE_FLUSH_JOB_PAYLOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfcfcfff8) fprintf(stderr, "XXX: Invalid field of Cache Flush Job Payload unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xfffffffc) fprintf(stderr, "XXX: Invalid field of Cache Flush Job Payload unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->clean_shader_core_ls, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->invalidate_shader_core_ls, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->invalidate_shader_core_other, &__tmp_packed.opaque[0], 2, 2); \
   __gen_unpack_uint((__unpacked)->job_manager_clean, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->job_manager_invalidate, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->tiler_clean, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->tiler_invalidate, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->l2_clean, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->l2_invalidate, &__tmp_packed.opaque[0], 33, 33); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CACHE_FLUSH_JOB_PAYLOAD_print(FILE *fp, const struct MALI_CACHE_FLUSH_JOB_PAYLOAD * values, unsigned indent)
{
   fprintf(fp, "%*sClean Shader Core LS: %s\n", indent, "", values->clean_shader_core_ls ? "true" : "false");
   fprintf(fp, "%*sInvalidate Shader Core LS: %s\n", indent, "", values->invalidate_shader_core_ls ? "true" : "false");
   fprintf(fp, "%*sInvalidate Shader Core Other: %s\n", indent, "", values->invalidate_shader_core_other ? "true" : "false");
   fprintf(fp, "%*sJob Manager Clean: %s\n", indent, "", values->job_manager_clean ? "true" : "false");
   fprintf(fp, "%*sJob Manager Invalidate: %s\n", indent, "", values->job_manager_invalidate ? "true" : "false");
   fprintf(fp, "%*sTiler Clean: %s\n", indent, "", values->tiler_clean ? "true" : "false");
   fprintf(fp, "%*sTiler Invalidate: %s\n", indent, "", values->tiler_invalidate ? "true" : "false");
   fprintf(fp, "%*sL2 Clean: %s\n", indent, "", values->l2_clean ? "true" : "false");
   fprintf(fp, "%*sL2 Invalidate: %s\n", indent, "", values->l2_invalidate ? "true" : "false");
}

#endif
struct mali_write_value_job_packed {
   uint32_t opaque[14];
};

#define MALI_WRITE_VALUE_JOB_PACKED_T struct mali_write_value_job_packed
#define MALI_WRITE_VALUE_JOB_LENGTH 56
#define MALI_WRITE_VALUE_JOB_ALIGN 128
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_OFFSET 0
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_TYPE struct MALI_WRITE_VALUE_JOB_PAYLOAD
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_PACKED_TYPE MALI_WRITE_VALUE_JOB_PAYLOAD_PACKED_T
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_header MALI_WRITE_VALUE_JOB_PAYLOAD_header
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_pack MALI_WRITE_VALUE_JOB_PAYLOAD_pack
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_unpack MALI_WRITE_VALUE_JOB_PAYLOAD_unpack
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_print MALI_WRITE_VALUE_JOB_PAYLOAD_print
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_OFFSET 32

struct mali_cache_flush_job_packed {
   uint32_t opaque[10];
};

#define MALI_CACHE_FLUSH_JOB_PACKED_T struct mali_cache_flush_job_packed
#define MALI_CACHE_FLUSH_JOB_LENGTH 40
#define MALI_CACHE_FLUSH_JOB_ALIGN 128
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_OFFSET 0
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_TYPE struct MALI_CACHE_FLUSH_JOB_PAYLOAD
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_PACKED_TYPE MALI_CACHE_FLUSH_JOB_PAYLOAD_PACKED_T
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_header MALI_CACHE_FLUSH_JOB_PAYLOAD_header
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_pack MALI_CACHE_FLUSH_JOB_PAYLOAD_pack
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_unpack MALI_CACHE_FLUSH_JOB_PAYLOAD_unpack
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_print MALI_CACHE_FLUSH_JOB_PAYLOAD_print
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_OFFSET 32

struct MALI_SHADER_ENVIRONMENT {
   uint64_t                             attribute_offset;
   uint32_t                             fau_count;
   uint64_t                             resources;
   uint64_t                             shader;
   uint64_t                             thread_storage;
   uint64_t                             fau;
#define MALI_RESOURCE_TABLE_SIZE_ALIGNMENT       4
};

#define MALI_SHADER_ENVIRONMENT_header          \
   0

#define MALI_SHADER_ENVIRONMENT_LENGTH 64
#define MALI_SHADER_ENVIRONMENT_ALIGN 64
struct mali_shader_environment_packed { uint32_t opaque[16]; };
#define MALI_SHADER_ENVIRONMENT_PACKED_T struct mali_shader_environment_packed
#define MALI_SHADER_ENVIRONMENT_pack(__packed, __unpacked) \
do { \
   MALI_SHADER_ENVIRONMENT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->attribute_offset, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->fau_count, 0, 7); \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->resources, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->resources, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->shader, 0, 63); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->shader, 0, 63) >> 32; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->thread_storage, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->thread_storage, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->fau, 0, 63); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->fau, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SHADER_ENVIRONMENT_unpack(__packed, __unpacked) \
do { \
   MALI_SHADER_ENVIRONMENT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Shader Environment unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Environment unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Environment unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Environment unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Environment unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Environment unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Environment unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->attribute_offset, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->fau_count, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->resources, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->shader, &__tmp_packed.opaque[0], 320, 383); \
   __gen_unpack_uint((__unpacked)->thread_storage, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->fau, &__tmp_packed.opaque[0], 448, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SHADER_ENVIRONMENT_print(FILE *fp, const struct MALI_SHADER_ENVIRONMENT * values, unsigned indent)
{
   fprintf(fp, "%*sAttribute offset: 0x%" PRIx64 "\n", indent, "", values->attribute_offset);
   fprintf(fp, "%*sFAU count: %u\n", indent, "", values->fau_count);
   fprintf(fp, "%*sResources: 0x%" PRIx64 "\n", indent, "", values->resources);
   fprintf(fp, "%*sShader: 0x%" PRIx64 "\n", indent, "", values->shader);
   fprintf(fp, "%*sThread storage: 0x%" PRIx64 "\n", indent, "", values->thread_storage);
   fprintf(fp, "%*sFAU: 0x%" PRIx64 "\n", indent, "", values->fau);
}

#endif
struct MALI_COMPUTE_PAYLOAD {
   uint32_t                             workgroup_size_x;
   uint32_t                             workgroup_size_y;
   uint32_t                             workgroup_size_z;
   bool                                 allow_merging_workgroups;
   uint32_t                             task_increment;
   enum mali_task_axis                  task_axis;
   uint64_t                             workgroup_count_x;
   uint64_t                             workgroup_count_y;
   uint64_t                             workgroup_count_z;
   uint64_t                             offset_x;
   uint64_t                             offset_y;
   uint64_t                             offset_z;
   struct MALI_SHADER_ENVIRONMENT       compute;
};

#define MALI_COMPUTE_PAYLOAD_header             \
   .task_increment = 1,  \
   .compute = { MALI_SHADER_ENVIRONMENT_header }

#define MALI_COMPUTE_PAYLOAD_LENGTH 96
struct mali_compute_payload_packed { uint32_t opaque[24]; };
#define MALI_COMPUTE_PAYLOAD_PACKED_T struct mali_compute_payload_packed
#define MALI_COMPUTE_PAYLOAD_pack(__packed, __unpacked) \
do { \
   MALI_COMPUTE_PAYLOAD_PACKED_T __tmp_packed; \
   assert((__unpacked)->workgroup_size_x >= 1); \
   assert((__unpacked)->workgroup_size_y >= 1); \
   assert((__unpacked)->workgroup_size_z >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->workgroup_size_x - 1, 0, 9) | \
            util_bitpack_uint((__unpacked)->workgroup_size_y - 1, 10, 19) | \
            util_bitpack_uint((__unpacked)->workgroup_size_z - 1, 20, 29) | \
            util_bitpack_uint((__unpacked)->allow_merging_workgroups, 31, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->task_increment, 0, 13) | \
            util_bitpack_uint((__unpacked)->task_axis, 14, 15); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->workgroup_count_x, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->workgroup_count_y, 0, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->workgroup_count_z, 0, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->offset_x, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->offset_y, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->offset_z, 0, 31); \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->compute.attribute_offset, 0, 31); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->compute.fau_count, 0, 7); \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   __tmp_packed.opaque[16] = util_bitpack_uint((__unpacked)->compute.resources, 0, 63); \
   __tmp_packed.opaque[17] = util_bitpack_uint((__unpacked)->compute.resources, 0, 63) >> 32; \
   __tmp_packed.opaque[18] = util_bitpack_uint((__unpacked)->compute.shader, 0, 63); \
   __tmp_packed.opaque[19] = util_bitpack_uint((__unpacked)->compute.shader, 0, 63) >> 32; \
   __tmp_packed.opaque[20] = util_bitpack_uint((__unpacked)->compute.thread_storage, 0, 63); \
   __tmp_packed.opaque[21] = util_bitpack_uint((__unpacked)->compute.thread_storage, 0, 63) >> 32; \
   __tmp_packed.opaque[22] = util_bitpack_uint((__unpacked)->compute.fau, 0, 63); \
   __tmp_packed.opaque[23] = util_bitpack_uint((__unpacked)->compute.fau, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_COMPUTE_PAYLOAD_unpack(__packed, __unpacked) \
do { \
   MALI_COMPUTE_PAYLOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x40000000) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 1\n"); \
   if (__tmp_packed.opaque[9] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Payload unpacked at word 15\n"); \
   __gen_unpack_uint((__unpacked)->workgroup_size_x, &__tmp_packed.opaque[0], 0, 9); \
   (__unpacked)->workgroup_size_x = (__unpacked)->workgroup_size_x + 1; \
   __gen_unpack_uint((__unpacked)->workgroup_size_y, &__tmp_packed.opaque[0], 10, 19); \
   (__unpacked)->workgroup_size_y = (__unpacked)->workgroup_size_y + 1; \
   __gen_unpack_uint((__unpacked)->workgroup_size_z, &__tmp_packed.opaque[0], 20, 29); \
   (__unpacked)->workgroup_size_z = (__unpacked)->workgroup_size_z + 1; \
   __gen_unpack_uint((__unpacked)->allow_merging_workgroups, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->task_increment, &__tmp_packed.opaque[0], 32, 45); \
   __gen_unpack_uint((__unpacked)->task_axis, &__tmp_packed.opaque[0], 46, 47); \
   __gen_unpack_uint((__unpacked)->workgroup_count_x, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->workgroup_count_y, &__tmp_packed.opaque[0], 96, 127); \
   __gen_unpack_uint((__unpacked)->workgroup_count_z, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->offset_x, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->offset_y, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->offset_z, &__tmp_packed.opaque[0], 224, 255); \
   __gen_unpack_uint((__unpacked)->compute.attribute_offset, &__tmp_packed.opaque[0], 256, 287); \
   __gen_unpack_uint((__unpacked)->compute.fau_count, &__tmp_packed.opaque[0], 288, 295); \
   __gen_unpack_uint((__unpacked)->compute.resources, &__tmp_packed.opaque[0], 512, 575); \
   __gen_unpack_uint((__unpacked)->compute.shader, &__tmp_packed.opaque[0], 576, 639); \
   __gen_unpack_uint((__unpacked)->compute.thread_storage, &__tmp_packed.opaque[0], 640, 703); \
   __gen_unpack_uint((__unpacked)->compute.fau, &__tmp_packed.opaque[0], 704, 767); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_COMPUTE_PAYLOAD_print(FILE *fp, const struct MALI_COMPUTE_PAYLOAD * values, unsigned indent)
{
   fprintf(fp, "%*sWorkgroup size X: %u\n", indent, "", values->workgroup_size_x);
   fprintf(fp, "%*sWorkgroup size Y: %u\n", indent, "", values->workgroup_size_y);
   fprintf(fp, "%*sWorkgroup size Z: %u\n", indent, "", values->workgroup_size_z);
   fprintf(fp, "%*sAllow merging workgroups: %s\n", indent, "", values->allow_merging_workgroups ? "true" : "false");
   fprintf(fp, "%*sTask increment: %u\n", indent, "", values->task_increment);
   fprintf(fp, "%*sTask axis: %s\n", indent, "", mali_task_axis_as_str(values->task_axis));
   fprintf(fp, "%*sWorkgroup count X: 0x%" PRIx64 "\n", indent, "", values->workgroup_count_x);
   fprintf(fp, "%*sWorkgroup count Y: 0x%" PRIx64 "\n", indent, "", values->workgroup_count_y);
   fprintf(fp, "%*sWorkgroup count Z: 0x%" PRIx64 "\n", indent, "", values->workgroup_count_z);
   fprintf(fp, "%*sOffset X: 0x%" PRIx64 "\n", indent, "", values->offset_x);
   fprintf(fp, "%*sOffset Y: 0x%" PRIx64 "\n", indent, "", values->offset_y);
   fprintf(fp, "%*sOffset Z: 0x%" PRIx64 "\n", indent, "", values->offset_z);
   fprintf(fp, "%*sCompute:\n", indent, "");
   MALI_SHADER_ENVIRONMENT_print(fp, &values->compute, indent + 2);
}

#endif
struct mali_compute_job_packed {
   uint32_t opaque[32];
};

#define MALI_COMPUTE_JOB_PACKED_T struct mali_compute_job_packed
#define MALI_COMPUTE_JOB_LENGTH 128
#define MALI_COMPUTE_JOB_ALIGN 128
#define MALI_COMPUTE_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_COMPUTE_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_COMPUTE_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_COMPUTE_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_COMPUTE_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_COMPUTE_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_COMPUTE_JOB_SECTION_HEADER_OFFSET 0
#define MALI_COMPUTE_JOB_SECTION_PAYLOAD_TYPE struct MALI_COMPUTE_PAYLOAD
#define MALI_COMPUTE_JOB_SECTION_PAYLOAD_PACKED_TYPE MALI_COMPUTE_PAYLOAD_PACKED_T
#define MALI_COMPUTE_JOB_SECTION_PAYLOAD_header MALI_COMPUTE_PAYLOAD_header
#define MALI_COMPUTE_JOB_SECTION_PAYLOAD_pack MALI_COMPUTE_PAYLOAD_pack
#define MALI_COMPUTE_JOB_SECTION_PAYLOAD_unpack MALI_COMPUTE_PAYLOAD_unpack
#define MALI_COMPUTE_JOB_SECTION_PAYLOAD_print MALI_COMPUTE_PAYLOAD_print
#define MALI_COMPUTE_JOB_SECTION_PAYLOAD_OFFSET 32

struct MALI_RESOURCE {
   uint64_t                             address;
   bool                                 contains_descriptors;
   uint64_t                             size;
};

#define MALI_RESOURCE_header                    \
   .contains_descriptors = true

#define MALI_RESOURCE_LENGTH 16
#define MALI_RESOURCE_ALIGN 64
struct mali_resource_packed { uint32_t opaque[4]; };
#define MALI_RESOURCE_PACKED_T struct mali_resource_packed
#define MALI_RESOURCE_pack(__packed, __unpacked) \
do { \
   MALI_RESOURCE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->address, 0, 55); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 0, 55) >> 32 | \
            util_bitpack_uint((__unpacked)->contains_descriptors, 24, 24); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->size, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->size, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RESOURCE_unpack(__packed, __unpacked) \
do { \
   MALI_RESOURCE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xfe000000) fprintf(stderr, "XXX: Invalid field of Resource unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 0, 55); \
   __gen_unpack_uint((__unpacked)->contains_descriptors, &__tmp_packed.opaque[0], 56, 56); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 64, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RESOURCE_print(FILE *fp, const struct MALI_RESOURCE * values, unsigned indent)
{
   fprintf(fp, "%*sAddress: 0x%" PRIx64 "\n", indent, "", values->address);
   fprintf(fp, "%*sContains descriptors: %s\n", indent, "", values->contains_descriptors ? "true" : "false");
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
}

#endif
struct MALI_DEPTH_STENCIL {
   enum mali_descriptor_type            type;
   enum mali_func                       front_compare_function;
   enum mali_stencil_op                 front_stencil_fail;
   enum mali_stencil_op                 front_depth_fail;
   enum mali_stencil_op                 front_depth_pass;
   enum mali_func                       back_compare_function;
   enum mali_stencil_op                 back_stencil_fail;
   enum mali_stencil_op                 back_depth_fail;
   enum mali_stencil_op                 back_depth_pass;
   bool                                 stencil_from_shader;
   bool                                 stencil_test_enable;
   uint32_t                             front_write_mask;
   uint32_t                             back_write_mask;
   uint32_t                             front_value_mask;
   uint32_t                             back_value_mask;
   uint32_t                             front_reference_value;
   uint32_t                             back_reference_value;
   bool                                 depth_cull_enable;
   enum mali_depth_clamp_mode           depth_clamp_mode;
   enum mali_depth_source               depth_source;
   bool                                 depth_write_enable;
   bool                                 depth_bias_enable;
   enum mali_func                       depth_function;
   float                                depth_units;
   float                                depth_factor;
   float                                depth_bias_clamp;
};

#define MALI_DEPTH_STENCIL_header               \
   .type = MALI_DESCRIPTOR_TYPE_DEPTH_STENCIL,  \
   .depth_cull_enable = true,  \
   .depth_clamp_mode = MALI_DEPTH_CLAMP_MODE_0_1,  \
   .depth_source = MALI_DEPTH_SOURCE_FIXED_FUNCTION

#define MALI_DEPTH_STENCIL_LENGTH 32
#define MALI_DEPTH_STENCIL_ALIGN 32
struct mali_depth_stencil_packed { uint32_t opaque[8]; };
#define MALI_DEPTH_STENCIL_PACKED_T struct mali_depth_stencil_packed
#define MALI_DEPTH_STENCIL_pack(__packed, __unpacked) \
do { \
   MALI_DEPTH_STENCIL_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->front_compare_function, 4, 6) | \
            util_bitpack_uint((__unpacked)->front_stencil_fail, 7, 9) | \
            util_bitpack_uint((__unpacked)->front_depth_fail, 10, 12) | \
            util_bitpack_uint((__unpacked)->front_depth_pass, 13, 15) | \
            util_bitpack_uint((__unpacked)->back_compare_function, 16, 18) | \
            util_bitpack_uint((__unpacked)->back_stencil_fail, 19, 21) | \
            util_bitpack_uint((__unpacked)->back_depth_fail, 22, 24) | \
            util_bitpack_uint((__unpacked)->back_depth_pass, 25, 27) | \
            util_bitpack_uint((__unpacked)->stencil_from_shader, 30, 30) | \
            util_bitpack_uint((__unpacked)->stencil_test_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->front_write_mask, 0, 7) | \
            util_bitpack_uint((__unpacked)->back_write_mask, 8, 15) | \
            util_bitpack_uint((__unpacked)->front_value_mask, 16, 23) | \
            util_bitpack_uint((__unpacked)->back_value_mask, 24, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->front_reference_value, 0, 7) | \
            util_bitpack_uint((__unpacked)->back_reference_value, 8, 15); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->depth_cull_enable, 22, 22) | \
            util_bitpack_uint((__unpacked)->depth_clamp_mode, 23, 24) | \
            util_bitpack_uint((__unpacked)->depth_source, 25, 26) | \
            util_bitpack_uint((__unpacked)->depth_write_enable, 27, 27) | \
            util_bitpack_uint((__unpacked)->depth_bias_enable, 28, 28) | \
            util_bitpack_uint((__unpacked)->depth_function, 29, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_float((__unpacked)->depth_units); \
   __tmp_packed.opaque[ 6] = util_bitpack_float((__unpacked)->depth_factor); \
   __tmp_packed.opaque[ 7] = util_bitpack_float((__unpacked)->depth_bias_clamp); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DEPTH_STENCIL_unpack(__packed, __unpacked) \
do { \
   MALI_DEPTH_STENCIL_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x30000000) fprintf(stderr, "XXX: Invalid field of Depth/stencil unpacked at word 0\n"); \
   if (__tmp_packed.opaque[2] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Depth/stencil unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Depth/stencil unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0x3fffff) fprintf(stderr, "XXX: Invalid field of Depth/stencil unpacked at word 4\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->front_compare_function, &__tmp_packed.opaque[0], 4, 6); \
   __gen_unpack_uint((__unpacked)->front_stencil_fail, &__tmp_packed.opaque[0], 7, 9); \
   __gen_unpack_uint((__unpacked)->front_depth_fail, &__tmp_packed.opaque[0], 10, 12); \
   __gen_unpack_uint((__unpacked)->front_depth_pass, &__tmp_packed.opaque[0], 13, 15); \
   __gen_unpack_uint((__unpacked)->back_compare_function, &__tmp_packed.opaque[0], 16, 18); \
   __gen_unpack_uint((__unpacked)->back_stencil_fail, &__tmp_packed.opaque[0], 19, 21); \
   __gen_unpack_uint((__unpacked)->back_depth_fail, &__tmp_packed.opaque[0], 22, 24); \
   __gen_unpack_uint((__unpacked)->back_depth_pass, &__tmp_packed.opaque[0], 25, 27); \
   __gen_unpack_uint((__unpacked)->stencil_from_shader, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->stencil_test_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->front_write_mask, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->back_write_mask, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->front_value_mask, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->back_value_mask, &__tmp_packed.opaque[0], 56, 63); \
   __gen_unpack_uint((__unpacked)->front_reference_value, &__tmp_packed.opaque[0], 64, 71); \
   __gen_unpack_uint((__unpacked)->back_reference_value, &__tmp_packed.opaque[0], 72, 79); \
   __gen_unpack_uint((__unpacked)->depth_cull_enable, &__tmp_packed.opaque[0], 150, 150); \
   __gen_unpack_uint((__unpacked)->depth_clamp_mode, &__tmp_packed.opaque[0], 151, 152); \
   __gen_unpack_uint((__unpacked)->depth_source, &__tmp_packed.opaque[0], 153, 154); \
   __gen_unpack_uint((__unpacked)->depth_write_enable, &__tmp_packed.opaque[0], 155, 155); \
   __gen_unpack_uint((__unpacked)->depth_bias_enable, &__tmp_packed.opaque[0], 156, 156); \
   __gen_unpack_uint((__unpacked)->depth_function, &__tmp_packed.opaque[0], 157, 159); \
   __gen_unpack_float((__unpacked)->depth_units, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_float((__unpacked)->depth_factor, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_float((__unpacked)->depth_bias_clamp, &__tmp_packed.opaque[0], 224, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DEPTH_STENCIL_print(FILE *fp, const struct MALI_DEPTH_STENCIL * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sFront compare function: %s\n", indent, "", mali_func_as_str(values->front_compare_function));
   fprintf(fp, "%*sFront stencil fail: %s\n", indent, "", mali_stencil_op_as_str(values->front_stencil_fail));
   fprintf(fp, "%*sFront depth fail: %s\n", indent, "", mali_stencil_op_as_str(values->front_depth_fail));
   fprintf(fp, "%*sFront depth pass: %s\n", indent, "", mali_stencil_op_as_str(values->front_depth_pass));
   fprintf(fp, "%*sBack compare function: %s\n", indent, "", mali_func_as_str(values->back_compare_function));
   fprintf(fp, "%*sBack stencil fail: %s\n", indent, "", mali_stencil_op_as_str(values->back_stencil_fail));
   fprintf(fp, "%*sBack depth fail: %s\n", indent, "", mali_stencil_op_as_str(values->back_depth_fail));
   fprintf(fp, "%*sBack depth pass: %s\n", indent, "", mali_stencil_op_as_str(values->back_depth_pass));
   fprintf(fp, "%*sStencil from shader: %s\n", indent, "", values->stencil_from_shader ? "true" : "false");
   fprintf(fp, "%*sStencil test enable: %s\n", indent, "", values->stencil_test_enable ? "true" : "false");
   fprintf(fp, "%*sFront write mask: 0x%x\n", indent, "", values->front_write_mask);
   fprintf(fp, "%*sBack write mask: 0x%x\n", indent, "", values->back_write_mask);
   fprintf(fp, "%*sFront value mask: 0x%x\n", indent, "", values->front_value_mask);
   fprintf(fp, "%*sBack value mask: 0x%x\n", indent, "", values->back_value_mask);
   fprintf(fp, "%*sFront reference value: 0x%x\n", indent, "", values->front_reference_value);
   fprintf(fp, "%*sBack reference value: 0x%x\n", indent, "", values->back_reference_value);
   fprintf(fp, "%*sDepth cull enable: %s\n", indent, "", values->depth_cull_enable ? "true" : "false");
   fprintf(fp, "%*sDepth clamp mode: %s\n", indent, "", mali_depth_clamp_mode_as_str(values->depth_clamp_mode));
   fprintf(fp, "%*sDepth source: %s\n", indent, "", mali_depth_source_as_str(values->depth_source));
   fprintf(fp, "%*sDepth write enable: %s\n", indent, "", values->depth_write_enable ? "true" : "false");
   fprintf(fp, "%*sDepth bias enable: %s\n", indent, "", values->depth_bias_enable ? "true" : "false");
   fprintf(fp, "%*sDepth function: %s\n", indent, "", mali_func_as_str(values->depth_function));
   fprintf(fp, "%*sDepth units: %f\n", indent, "", values->depth_units);
   fprintf(fp, "%*sDepth factor: %f\n", indent, "", values->depth_factor);
   fprintf(fp, "%*sDepth bias clamp: %f\n", indent, "", values->depth_bias_clamp);
}

#endif
struct MALI_VERTEX_ARRAY {
   bool                                 packet;
   uint64_t                             pointer;
   uint32_t                             vertex_packet_stride;
   uint32_t                             vertex_attribute_stride;
};

#define MALI_VERTEX_ARRAY_header                \
   0

#define MALI_VERTEX_ARRAY_LENGTH 12
struct mali_vertex_array_packed { uint32_t opaque[3]; };
#define MALI_VERTEX_ARRAY_PACKED_T struct mali_vertex_array_packed
#define MALI_VERTEX_ARRAY_pack(__packed, __unpacked) \
do { \
   MALI_VERTEX_ARRAY_PACKED_T __tmp_packed; \
   assert(((__unpacked)->pointer & 0x3f) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->packet, 0, 0) | \
            util_bitpack_uint((__unpacked)->pointer >> 6, 6, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pointer >> 6, 6, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->vertex_packet_stride, 0, 15) | \
            util_bitpack_uint((__unpacked)->vertex_attribute_stride, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_VERTEX_ARRAY_unpack(__packed, __unpacked) \
do { \
   MALI_VERTEX_ARRAY_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3e) fprintf(stderr, "XXX: Invalid field of Vertex Array unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->packet, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 6, 63); \
   (__unpacked)->pointer = (__unpacked)->pointer << 6; \
   __gen_unpack_uint((__unpacked)->vertex_packet_stride, &__tmp_packed.opaque[0], 64, 79); \
   __gen_unpack_uint((__unpacked)->vertex_attribute_stride, &__tmp_packed.opaque[0], 80, 95); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_VERTEX_ARRAY_print(FILE *fp, const struct MALI_VERTEX_ARRAY * values, unsigned indent)
{
   fprintf(fp, "%*sPacket: %s\n", indent, "", values->packet ? "true" : "false");
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sVertex packet stride: %u\n", indent, "", values->vertex_packet_stride);
   fprintf(fp, "%*sVertex attribute stride: %u\n", indent, "", values->vertex_attribute_stride);
}

#endif
struct MALI_DCD_FLAGS_0 {
   bool                                 allow_forward_pixel_to_kill;
   bool                                 allow_forward_pixel_to_be_killed;
   enum mali_pixel_kill                 pixel_kill_operation;
   enum mali_pixel_kill                 zs_update_operation;
   bool                                 allow_primitive_reorder;
   bool                                 overdraw_alpha0;
   bool                                 overdraw_alpha1;
   bool                                 clean_fragment_write;
   bool                                 primitive_barrier;
   bool                                 evaluate_per_sample;
   bool                                 aligned_line_ends;
   enum mali_occlusion_mode             occlusion_query;
   bool                                 front_face_ccw;
   bool                                 cull_front_face;
   bool                                 cull_back_face;
   bool                                 multisample_enable;
   bool                                 shader_modifies_coverage;
   bool                                 alpha_to_coverage_invert;
   bool                                 alpha_to_coverage;
   bool                                 scissor_to_bounding_box;
};

#define MALI_DCD_FLAGS_0_header                 \
   .occlusion_query = MALI_OCCLUSION_MODE_DISABLED

#define MALI_DCD_FLAGS_0_LENGTH 4
struct mali_dcd_flags_0_packed { uint32_t opaque[1]; };
#define MALI_DCD_FLAGS_0_PACKED_T struct mali_dcd_flags_0_packed
#define MALI_DCD_FLAGS_0_pack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_0_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->allow_forward_pixel_to_kill, 0, 0) | \
            util_bitpack_uint((__unpacked)->allow_forward_pixel_to_be_killed, 1, 1) | \
            util_bitpack_uint((__unpacked)->pixel_kill_operation, 2, 3) | \
            util_bitpack_uint((__unpacked)->zs_update_operation, 4, 5) | \
            util_bitpack_uint((__unpacked)->allow_primitive_reorder, 6, 6) | \
            util_bitpack_uint((__unpacked)->overdraw_alpha0, 7, 7) | \
            util_bitpack_uint((__unpacked)->overdraw_alpha1, 8, 8) | \
            util_bitpack_uint((__unpacked)->clean_fragment_write, 9, 9) | \
            util_bitpack_uint((__unpacked)->primitive_barrier, 10, 10) | \
            util_bitpack_uint((__unpacked)->evaluate_per_sample, 11, 11) | \
            util_bitpack_uint((__unpacked)->aligned_line_ends, 13, 13) | \
            util_bitpack_uint((__unpacked)->occlusion_query, 14, 15) | \
            util_bitpack_uint((__unpacked)->front_face_ccw, 16, 16) | \
            util_bitpack_uint((__unpacked)->cull_front_face, 17, 17) | \
            util_bitpack_uint((__unpacked)->cull_back_face, 18, 18) | \
            util_bitpack_uint((__unpacked)->multisample_enable, 19, 19) | \
            util_bitpack_uint((__unpacked)->shader_modifies_coverage, 20, 20) | \
            util_bitpack_uint((__unpacked)->alpha_to_coverage_invert, 21, 21) | \
            util_bitpack_uint((__unpacked)->alpha_to_coverage, 22, 22) | \
            util_bitpack_uint((__unpacked)->scissor_to_bounding_box, 23, 23); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DCD_FLAGS_0_unpack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_0_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff001000) fprintf(stderr, "XXX: Invalid field of DCD Flags 0 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->allow_forward_pixel_to_kill, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->allow_forward_pixel_to_be_killed, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->pixel_kill_operation, &__tmp_packed.opaque[0], 2, 3); \
   __gen_unpack_uint((__unpacked)->zs_update_operation, &__tmp_packed.opaque[0], 4, 5); \
   __gen_unpack_uint((__unpacked)->allow_primitive_reorder, &__tmp_packed.opaque[0], 6, 6); \
   __gen_unpack_uint((__unpacked)->overdraw_alpha0, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->overdraw_alpha1, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->clean_fragment_write, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->primitive_barrier, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->evaluate_per_sample, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->aligned_line_ends, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->occlusion_query, &__tmp_packed.opaque[0], 14, 15); \
   __gen_unpack_uint((__unpacked)->front_face_ccw, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->cull_front_face, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->cull_back_face, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->multisample_enable, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->shader_modifies_coverage, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->alpha_to_coverage_invert, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_uint((__unpacked)->alpha_to_coverage, &__tmp_packed.opaque[0], 22, 22); \
   __gen_unpack_uint((__unpacked)->scissor_to_bounding_box, &__tmp_packed.opaque[0], 23, 23); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DCD_FLAGS_0_print(FILE *fp, const struct MALI_DCD_FLAGS_0 * values, unsigned indent)
{
   fprintf(fp, "%*sAllow forward pixel to kill: %s\n", indent, "", values->allow_forward_pixel_to_kill ? "true" : "false");
   fprintf(fp, "%*sAllow forward pixel to be killed: %s\n", indent, "", values->allow_forward_pixel_to_be_killed ? "true" : "false");
   fprintf(fp, "%*sPixel kill operation: %s\n", indent, "", mali_pixel_kill_as_str(values->pixel_kill_operation));
   fprintf(fp, "%*sZS update operation: %s\n", indent, "", mali_pixel_kill_as_str(values->zs_update_operation));
   fprintf(fp, "%*sAllow primitive reorder: %s\n", indent, "", values->allow_primitive_reorder ? "true" : "false");
   fprintf(fp, "%*sOverdraw alpha0: %s\n", indent, "", values->overdraw_alpha0 ? "true" : "false");
   fprintf(fp, "%*sOverdraw alpha1: %s\n", indent, "", values->overdraw_alpha1 ? "true" : "false");
   fprintf(fp, "%*sClean Fragment Write: %s\n", indent, "", values->clean_fragment_write ? "true" : "false");
   fprintf(fp, "%*sPrimitive Barrier: %s\n", indent, "", values->primitive_barrier ? "true" : "false");
   fprintf(fp, "%*sEvaluate per-sample: %s\n", indent, "", values->evaluate_per_sample ? "true" : "false");
   fprintf(fp, "%*sAligned line-ends: %s\n", indent, "", values->aligned_line_ends ? "true" : "false");
   fprintf(fp, "%*sOcclusion query: %s\n", indent, "", mali_occlusion_mode_as_str(values->occlusion_query));
   fprintf(fp, "%*sFront face CCW: %s\n", indent, "", values->front_face_ccw ? "true" : "false");
   fprintf(fp, "%*sCull front face: %s\n", indent, "", values->cull_front_face ? "true" : "false");
   fprintf(fp, "%*sCull back face: %s\n", indent, "", values->cull_back_face ? "true" : "false");
   fprintf(fp, "%*sMultisample enable: %s\n", indent, "", values->multisample_enable ? "true" : "false");
   fprintf(fp, "%*sShader modifies coverage: %s\n", indent, "", values->shader_modifies_coverage ? "true" : "false");
   fprintf(fp, "%*sAlpha-to-coverage Invert: %s\n", indent, "", values->alpha_to_coverage_invert ? "true" : "false");
   fprintf(fp, "%*sAlpha-to-coverage: %s\n", indent, "", values->alpha_to_coverage ? "true" : "false");
   fprintf(fp, "%*sScissor to bounding box: %s\n", indent, "", values->scissor_to_bounding_box ? "true" : "false");
}

#endif
struct MALI_DCD_FLAGS_1 {
   uint32_t                             sample_mask;
   uint32_t                             render_target_mask;
};

#define MALI_DCD_FLAGS_1_header                 \
   0

#define MALI_DCD_FLAGS_1_LENGTH 4
struct mali_dcd_flags_1_packed { uint32_t opaque[1]; };
#define MALI_DCD_FLAGS_1_PACKED_T struct mali_dcd_flags_1_packed
#define MALI_DCD_FLAGS_1_pack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_1_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->sample_mask, 0, 15) | \
            util_bitpack_uint((__unpacked)->render_target_mask, 16, 23); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DCD_FLAGS_1_unpack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_1_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff000000) fprintf(stderr, "XXX: Invalid field of DCD Flags 1 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->sample_mask, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->render_target_mask, &__tmp_packed.opaque[0], 16, 23); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DCD_FLAGS_1_print(FILE *fp, const struct MALI_DCD_FLAGS_1 * values, unsigned indent)
{
   fprintf(fp, "%*sSample mask: %u\n", indent, "", values->sample_mask);
   fprintf(fp, "%*sRender target mask: 0x%x\n", indent, "", values->render_target_mask);
}

#endif
struct MALI_DRAW {
   struct MALI_DCD_FLAGS_0              flags_0;
   struct MALI_DCD_FLAGS_1              flags_1;
   struct MALI_VERTEX_ARRAY             vertex_array;
   float                                minimum_z;
   float                                maximum_z;
   uint64_t                             depth_stencil;
   uint32_t                             blend_count;
   uint64_t                             blend;
   uint64_t                             occlusion;
   struct MALI_SHADER_ENVIRONMENT       shader;
};

#define MALI_DRAW_header                        \
   .flags_0 = { MALI_DCD_FLAGS_0_header },  \
   .flags_1 = { MALI_DCD_FLAGS_1_header },  \
   .vertex_array = { MALI_VERTEX_ARRAY_header },  \
   .shader = { MALI_SHADER_ENVIRONMENT_header }

#define MALI_DRAW_LENGTH 128
#define MALI_DRAW_ALIGN 64
struct mali_draw_packed { uint32_t opaque[32]; };
#define MALI_DRAW_PACKED_T struct mali_draw_packed
#define MALI_DRAW_pack(__packed, __unpacked) \
do { \
   MALI_DRAW_PACKED_T __tmp_packed; \
   assert(((__unpacked)->blend & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->flags_0.allow_forward_pixel_to_kill, 0, 0) | \
            util_bitpack_uint((__unpacked)->flags_0.allow_forward_pixel_to_be_killed, 1, 1) | \
            util_bitpack_uint((__unpacked)->flags_0.pixel_kill_operation, 2, 3) | \
            util_bitpack_uint((__unpacked)->flags_0.zs_update_operation, 4, 5) | \
            util_bitpack_uint((__unpacked)->flags_0.allow_primitive_reorder, 6, 6) | \
            util_bitpack_uint((__unpacked)->flags_0.overdraw_alpha0, 7, 7) | \
            util_bitpack_uint((__unpacked)->flags_0.overdraw_alpha1, 8, 8) | \
            util_bitpack_uint((__unpacked)->flags_0.clean_fragment_write, 9, 9) | \
            util_bitpack_uint((__unpacked)->flags_0.primitive_barrier, 10, 10) | \
            util_bitpack_uint((__unpacked)->flags_0.evaluate_per_sample, 11, 11) | \
            util_bitpack_uint((__unpacked)->flags_0.aligned_line_ends, 13, 13) | \
            util_bitpack_uint((__unpacked)->flags_0.occlusion_query, 14, 15) | \
            util_bitpack_uint((__unpacked)->flags_0.front_face_ccw, 16, 16) | \
            util_bitpack_uint((__unpacked)->flags_0.cull_front_face, 17, 17) | \
            util_bitpack_uint((__unpacked)->flags_0.cull_back_face, 18, 18) | \
            util_bitpack_uint((__unpacked)->flags_0.multisample_enable, 19, 19) | \
            util_bitpack_uint((__unpacked)->flags_0.shader_modifies_coverage, 20, 20) | \
            util_bitpack_uint((__unpacked)->flags_0.alpha_to_coverage_invert, 21, 21) | \
            util_bitpack_uint((__unpacked)->flags_0.alpha_to_coverage, 22, 22) | \
            util_bitpack_uint((__unpacked)->flags_0.scissor_to_bounding_box, 23, 23); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->flags_1.sample_mask, 0, 15) | \
            util_bitpack_uint((__unpacked)->flags_1.render_target_mask, 16, 23); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->vertex_array.packet, 0, 0) | \
            util_bitpack_uint((__unpacked)->vertex_array.pointer >> 6, 6, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->vertex_array.pointer >> 6, 6, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->vertex_array.vertex_packet_stride, 0, 15) | \
            util_bitpack_uint((__unpacked)->vertex_array.vertex_attribute_stride, 16, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_float((__unpacked)->minimum_z); \
   __tmp_packed.opaque[ 7] = util_bitpack_float((__unpacked)->maximum_z); \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->depth_stencil, 0, 63); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->depth_stencil, 0, 63) >> 32; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->blend_count, 0, 3) | \
            util_bitpack_uint((__unpacked)->blend >> 4, 4, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->blend >> 4, 4, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->occlusion, 0, 63); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->occlusion, 0, 63) >> 32; \
   __tmp_packed.opaque[16] = util_bitpack_uint((__unpacked)->shader.attribute_offset, 0, 31); \
   __tmp_packed.opaque[17] = util_bitpack_uint((__unpacked)->shader.fau_count, 0, 7); \
   __tmp_packed.opaque[18] = 0; \
   __tmp_packed.opaque[19] = 0; \
   __tmp_packed.opaque[20] = 0; \
   __tmp_packed.opaque[21] = 0; \
   __tmp_packed.opaque[22] = 0; \
   __tmp_packed.opaque[23] = 0; \
   __tmp_packed.opaque[24] = util_bitpack_uint((__unpacked)->shader.resources, 0, 63); \
   __tmp_packed.opaque[25] = util_bitpack_uint((__unpacked)->shader.resources, 0, 63) >> 32; \
   __tmp_packed.opaque[26] = util_bitpack_uint((__unpacked)->shader.shader, 0, 63); \
   __tmp_packed.opaque[27] = util_bitpack_uint((__unpacked)->shader.shader, 0, 63) >> 32; \
   __tmp_packed.opaque[28] = util_bitpack_uint((__unpacked)->shader.thread_storage, 0, 63); \
   __tmp_packed.opaque[29] = util_bitpack_uint((__unpacked)->shader.thread_storage, 0, 63) >> 32; \
   __tmp_packed.opaque[30] = util_bitpack_uint((__unpacked)->shader.fau, 0, 63); \
   __tmp_packed.opaque[31] = util_bitpack_uint((__unpacked)->shader.fau, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DRAW_unpack(__packed, __unpacked) \
do { \
   MALI_DRAW_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff001000) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff000000) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0x3e) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 2\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 5\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 9\n"); \
   if (__tmp_packed.opaque[17] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 17\n"); \
   if (__tmp_packed.opaque[18] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 18\n"); \
   if (__tmp_packed.opaque[19] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 19\n"); \
   if (__tmp_packed.opaque[20] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 20\n"); \
   if (__tmp_packed.opaque[21] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 21\n"); \
   if (__tmp_packed.opaque[22] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 22\n"); \
   if (__tmp_packed.opaque[23] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 23\n"); \
   __gen_unpack_uint((__unpacked)->flags_0.allow_forward_pixel_to_kill, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->flags_0.allow_forward_pixel_to_be_killed, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->flags_0.pixel_kill_operation, &__tmp_packed.opaque[0], 2, 3); \
   __gen_unpack_uint((__unpacked)->flags_0.zs_update_operation, &__tmp_packed.opaque[0], 4, 5); \
   __gen_unpack_uint((__unpacked)->flags_0.allow_primitive_reorder, &__tmp_packed.opaque[0], 6, 6); \
   __gen_unpack_uint((__unpacked)->flags_0.overdraw_alpha0, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->flags_0.overdraw_alpha1, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->flags_0.clean_fragment_write, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->flags_0.primitive_barrier, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->flags_0.evaluate_per_sample, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->flags_0.aligned_line_ends, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->flags_0.occlusion_query, &__tmp_packed.opaque[0], 14, 15); \
   __gen_unpack_uint((__unpacked)->flags_0.front_face_ccw, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->flags_0.cull_front_face, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->flags_0.cull_back_face, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->flags_0.multisample_enable, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->flags_0.shader_modifies_coverage, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->flags_0.alpha_to_coverage_invert, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_uint((__unpacked)->flags_0.alpha_to_coverage, &__tmp_packed.opaque[0], 22, 22); \
   __gen_unpack_uint((__unpacked)->flags_0.scissor_to_bounding_box, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->flags_1.sample_mask, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_uint((__unpacked)->flags_1.render_target_mask, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->vertex_array.packet, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->vertex_array.pointer, &__tmp_packed.opaque[0], 70, 127); \
   (__unpacked)->vertex_array.pointer = (__unpacked)->vertex_array.pointer << 6; \
   __gen_unpack_uint((__unpacked)->vertex_array.vertex_packet_stride, &__tmp_packed.opaque[0], 128, 143); \
   __gen_unpack_uint((__unpacked)->vertex_array.vertex_attribute_stride, &__tmp_packed.opaque[0], 144, 159); \
   __gen_unpack_float((__unpacked)->minimum_z, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_float((__unpacked)->maximum_z, &__tmp_packed.opaque[0], 224, 255); \
   __gen_unpack_uint((__unpacked)->depth_stencil, &__tmp_packed.opaque[0], 320, 383); \
   __gen_unpack_uint((__unpacked)->blend_count, &__tmp_packed.opaque[0], 384, 387); \
   __gen_unpack_uint((__unpacked)->blend, &__tmp_packed.opaque[0], 388, 447); \
   (__unpacked)->blend = (__unpacked)->blend << 4; \
   __gen_unpack_uint((__unpacked)->occlusion, &__tmp_packed.opaque[0], 448, 511); \
   __gen_unpack_uint((__unpacked)->shader.attribute_offset, &__tmp_packed.opaque[0], 512, 543); \
   __gen_unpack_uint((__unpacked)->shader.fau_count, &__tmp_packed.opaque[0], 544, 551); \
   __gen_unpack_uint((__unpacked)->shader.resources, &__tmp_packed.opaque[0], 768, 831); \
   __gen_unpack_uint((__unpacked)->shader.shader, &__tmp_packed.opaque[0], 832, 895); \
   __gen_unpack_uint((__unpacked)->shader.thread_storage, &__tmp_packed.opaque[0], 896, 959); \
   __gen_unpack_uint((__unpacked)->shader.fau, &__tmp_packed.opaque[0], 960, 1023); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DRAW_print(FILE *fp, const struct MALI_DRAW * values, unsigned indent)
{
   fprintf(fp, "%*sFlags 0:\n", indent, "");
   MALI_DCD_FLAGS_0_print(fp, &values->flags_0, indent + 2);
   fprintf(fp, "%*sFlags 1:\n", indent, "");
   MALI_DCD_FLAGS_1_print(fp, &values->flags_1, indent + 2);
   fprintf(fp, "%*sVertex array:\n", indent, "");
   MALI_VERTEX_ARRAY_print(fp, &values->vertex_array, indent + 2);
   fprintf(fp, "%*sMinimum Z: %f\n", indent, "", values->minimum_z);
   fprintf(fp, "%*sMaximum Z: %f\n", indent, "", values->maximum_z);
   fprintf(fp, "%*sDepth/stencil: 0x%" PRIx64 "\n", indent, "", values->depth_stencil);
   fprintf(fp, "%*sBlend count: %u\n", indent, "", values->blend_count);
   fprintf(fp, "%*sBlend: 0x%" PRIx64 "\n", indent, "", values->blend);
   fprintf(fp, "%*sOcclusion: 0x%" PRIx64 "\n", indent, "", values->occlusion);
   fprintf(fp, "%*sShader:\n", indent, "");
   MALI_SHADER_ENVIRONMENT_print(fp, &values->shader, indent + 2);
}

#endif
struct MALI_COUNT {
   uint64_t                             count;
};

#define MALI_COUNT_header                       \
   0

#define MALI_COUNT_LENGTH 4
struct mali_count_packed { uint32_t opaque[1]; };
#define MALI_COUNT_PACKED_T struct mali_count_packed
#define MALI_COUNT_pack(__packed, __unpacked) \
do { \
   MALI_COUNT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->count, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_COUNT_unpack(__packed, __unpacked) \
do { \
   MALI_COUNT_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->count, &__tmp_packed.opaque[0], 0, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_COUNT_print(FILE *fp, const struct MALI_COUNT * values, unsigned indent)
{
   fprintf(fp, "%*sCount: 0x%" PRIx64 "\n", indent, "", values->count);
}

#endif
struct MALI_ALLOCATION {
   uint32_t                             vertex_packet_stride;
   uint32_t                             vertex_attribute_stride;
};

#define MALI_ALLOCATION_header                  \
   0

#define MALI_ALLOCATION_LENGTH 4
struct mali_allocation_packed { uint32_t opaque[1]; };
#define MALI_ALLOCATION_PACKED_T struct mali_allocation_packed
#define MALI_ALLOCATION_pack(__packed, __unpacked) \
do { \
   MALI_ALLOCATION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->vertex_packet_stride, 0, 15) | \
            util_bitpack_uint((__unpacked)->vertex_attribute_stride, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ALLOCATION_unpack(__packed, __unpacked) \
do { \
   MALI_ALLOCATION_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->vertex_packet_stride, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->vertex_attribute_stride, &__tmp_packed.opaque[0], 16, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ALLOCATION_print(FILE *fp, const struct MALI_ALLOCATION * values, unsigned indent)
{
   fprintf(fp, "%*sVertex packet stride: %u\n", indent, "", values->vertex_packet_stride);
   fprintf(fp, "%*sVertex attribute stride: %u\n", indent, "", values->vertex_attribute_stride);
}

#endif
struct MALI_TILER_POINTER {
   uint64_t                             address;
};

#define MALI_TILER_POINTER_header               \
   0

#define MALI_TILER_POINTER_LENGTH 8
struct mali_tiler_pointer_packed { uint32_t opaque[2]; };
#define MALI_TILER_POINTER_PACKED_T struct mali_tiler_pointer_packed
#define MALI_TILER_POINTER_pack(__packed, __unpacked) \
do { \
   MALI_TILER_POINTER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->address, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_POINTER_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_POINTER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 0, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_POINTER_print(FILE *fp, const struct MALI_TILER_POINTER * values, unsigned indent)
{
   fprintf(fp, "%*sAddress: 0x%" PRIx64 "\n", indent, "", values->address);
}

#endif
struct MALI_PRIMITIVE_SIZE {
   float                                fixed_sized;
   uint64_t                             size_array;
};

#define MALI_PRIMITIVE_SIZE_header              \
   0

#define MALI_PRIMITIVE_SIZE_LENGTH 8
struct mali_primitive_size_packed { uint32_t opaque[2]; };
#define MALI_PRIMITIVE_SIZE_PACKED_T struct mali_primitive_size_packed
#define MALI_PRIMITIVE_SIZE_pack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_SIZE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_float((__unpacked)->fixed_sized) | \
            util_bitpack_uint((__unpacked)->size_array, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size_array, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRIMITIVE_SIZE_unpack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_SIZE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_float((__unpacked)->fixed_sized, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->size_array, &__tmp_packed.opaque[0], 0, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRIMITIVE_SIZE_print(FILE *fp, const struct MALI_PRIMITIVE_SIZE * values, unsigned indent)
{
   fprintf(fp, "%*sFixed Sized: %f\n", indent, "", values->fixed_sized);
   fprintf(fp, "%*sSize Array: 0x%" PRIx64 "\n", indent, "", values->size_array);
}

#endif
struct MALI_INDICES {
   uint64_t                             address;
};

#define MALI_INDICES_header                     \
   0

#define MALI_INDICES_LENGTH 8
struct mali_indices_packed { uint32_t opaque[2]; };
#define MALI_INDICES_PACKED_T struct mali_indices_packed
#define MALI_INDICES_pack(__packed, __unpacked) \
do { \
   MALI_INDICES_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->address, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_INDICES_unpack(__packed, __unpacked) \
do { \
   MALI_INDICES_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 0, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_INDICES_print(FILE *fp, const struct MALI_INDICES * values, unsigned indent)
{
   fprintf(fp, "%*sAddress: 0x%" PRIx64 "\n", indent, "", values->address);
}

#endif
struct mali_malloc_vertex_job_packed {
   uint32_t opaque[96];
};

#define MALI_MALLOC_VERTEX_JOB_PACKED_T struct mali_malloc_vertex_job_packed
#define MALI_MALLOC_VERTEX_JOB_LENGTH 384
#define MALI_MALLOC_VERTEX_JOB_ALIGN 128
#define MALI_MALLOC_VERTEX_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_MALLOC_VERTEX_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_HEADER_OFFSET 0
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_TYPE struct MALI_PRIMITIVE
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_PACKED_TYPE MALI_PRIMITIVE_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_header MALI_PRIMITIVE_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_pack MALI_PRIMITIVE_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_unpack MALI_PRIMITIVE_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_print MALI_PRIMITIVE_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_OFFSET 32
#define MALI_MALLOC_VERTEX_JOB_SECTION_INSTANCE_COUNT_TYPE struct MALI_COUNT
#define MALI_MALLOC_VERTEX_JOB_SECTION_INSTANCE_COUNT_PACKED_TYPE MALI_COUNT_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_INSTANCE_COUNT_header MALI_COUNT_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_INSTANCE_COUNT_pack MALI_COUNT_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_INSTANCE_COUNT_unpack MALI_COUNT_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_INSTANCE_COUNT_print MALI_COUNT_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_INSTANCE_COUNT_OFFSET 48
#define MALI_MALLOC_VERTEX_JOB_SECTION_ALLOCATION_TYPE struct MALI_ALLOCATION
#define MALI_MALLOC_VERTEX_JOB_SECTION_ALLOCATION_PACKED_TYPE MALI_ALLOCATION_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_ALLOCATION_header MALI_ALLOCATION_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_ALLOCATION_pack MALI_ALLOCATION_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_ALLOCATION_unpack MALI_ALLOCATION_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_ALLOCATION_print MALI_ALLOCATION_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_ALLOCATION_OFFSET 52
#define MALI_MALLOC_VERTEX_JOB_SECTION_TILER_TYPE struct MALI_TILER_POINTER
#define MALI_MALLOC_VERTEX_JOB_SECTION_TILER_PACKED_TYPE MALI_TILER_POINTER_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_TILER_header MALI_TILER_POINTER_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_TILER_pack MALI_TILER_POINTER_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_TILER_unpack MALI_TILER_POINTER_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_TILER_print MALI_TILER_POINTER_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_TILER_OFFSET 56
#define MALI_MALLOC_VERTEX_JOB_SECTION_SCISSOR_TYPE struct MALI_SCISSOR
#define MALI_MALLOC_VERTEX_JOB_SECTION_SCISSOR_PACKED_TYPE MALI_SCISSOR_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_SCISSOR_header MALI_SCISSOR_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_SCISSOR_pack MALI_SCISSOR_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_SCISSOR_unpack MALI_SCISSOR_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_SCISSOR_print MALI_SCISSOR_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_SCISSOR_OFFSET 104
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_SIZE_TYPE struct MALI_PRIMITIVE_SIZE
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_SIZE_PACKED_TYPE MALI_PRIMITIVE_SIZE_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_SIZE_header MALI_PRIMITIVE_SIZE_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_SIZE_pack MALI_PRIMITIVE_SIZE_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_SIZE_unpack MALI_PRIMITIVE_SIZE_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_SIZE_print MALI_PRIMITIVE_SIZE_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_PRIMITIVE_SIZE_OFFSET 112
#define MALI_MALLOC_VERTEX_JOB_SECTION_INDICES_TYPE struct MALI_INDICES
#define MALI_MALLOC_VERTEX_JOB_SECTION_INDICES_PACKED_TYPE MALI_INDICES_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_INDICES_header MALI_INDICES_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_INDICES_pack MALI_INDICES_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_INDICES_unpack MALI_INDICES_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_INDICES_print MALI_INDICES_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_INDICES_OFFSET 120
#define MALI_MALLOC_VERTEX_JOB_SECTION_DRAW_TYPE struct MALI_DRAW
#define MALI_MALLOC_VERTEX_JOB_SECTION_DRAW_PACKED_TYPE MALI_DRAW_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_DRAW_header MALI_DRAW_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_DRAW_pack MALI_DRAW_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_DRAW_unpack MALI_DRAW_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_DRAW_print MALI_DRAW_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_DRAW_OFFSET 128
#define MALI_MALLOC_VERTEX_JOB_SECTION_POSITION_TYPE struct MALI_SHADER_ENVIRONMENT
#define MALI_MALLOC_VERTEX_JOB_SECTION_POSITION_PACKED_TYPE MALI_SHADER_ENVIRONMENT_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_POSITION_header MALI_SHADER_ENVIRONMENT_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_POSITION_pack MALI_SHADER_ENVIRONMENT_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_POSITION_unpack MALI_SHADER_ENVIRONMENT_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_POSITION_print MALI_SHADER_ENVIRONMENT_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_POSITION_OFFSET 256
#define MALI_MALLOC_VERTEX_JOB_SECTION_VARYING_TYPE struct MALI_SHADER_ENVIRONMENT
#define MALI_MALLOC_VERTEX_JOB_SECTION_VARYING_PACKED_TYPE MALI_SHADER_ENVIRONMENT_PACKED_T
#define MALI_MALLOC_VERTEX_JOB_SECTION_VARYING_header MALI_SHADER_ENVIRONMENT_header
#define MALI_MALLOC_VERTEX_JOB_SECTION_VARYING_pack MALI_SHADER_ENVIRONMENT_pack
#define MALI_MALLOC_VERTEX_JOB_SECTION_VARYING_unpack MALI_SHADER_ENVIRONMENT_unpack
#define MALI_MALLOC_VERTEX_JOB_SECTION_VARYING_print MALI_SHADER_ENVIRONMENT_print
#define MALI_MALLOC_VERTEX_JOB_SECTION_VARYING_OFFSET 320

struct mali_tiler_job_packed {
   uint32_t opaque[64];
};

#define MALI_TILER_JOB_PACKED_T struct mali_tiler_job_packed
#define MALI_TILER_JOB_LENGTH 256
#define MALI_TILER_JOB_ALIGN 128
#define MALI_TILER_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_TILER_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_TILER_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_TILER_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_TILER_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_TILER_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_TILER_JOB_SECTION_HEADER_OFFSET 0
#define MALI_TILER_JOB_SECTION_PRIMITIVE_TYPE struct MALI_PRIMITIVE
#define MALI_TILER_JOB_SECTION_PRIMITIVE_PACKED_TYPE MALI_PRIMITIVE_PACKED_T
#define MALI_TILER_JOB_SECTION_PRIMITIVE_header MALI_PRIMITIVE_header
#define MALI_TILER_JOB_SECTION_PRIMITIVE_pack MALI_PRIMITIVE_pack
#define MALI_TILER_JOB_SECTION_PRIMITIVE_unpack MALI_PRIMITIVE_unpack
#define MALI_TILER_JOB_SECTION_PRIMITIVE_print MALI_PRIMITIVE_print
#define MALI_TILER_JOB_SECTION_PRIMITIVE_OFFSET 32
#define MALI_TILER_JOB_SECTION_INSTANCE_COUNT_TYPE struct MALI_COUNT
#define MALI_TILER_JOB_SECTION_INSTANCE_COUNT_PACKED_TYPE MALI_COUNT_PACKED_T
#define MALI_TILER_JOB_SECTION_INSTANCE_COUNT_header MALI_COUNT_header
#define MALI_TILER_JOB_SECTION_INSTANCE_COUNT_pack MALI_COUNT_pack
#define MALI_TILER_JOB_SECTION_INSTANCE_COUNT_unpack MALI_COUNT_unpack
#define MALI_TILER_JOB_SECTION_INSTANCE_COUNT_print MALI_COUNT_print
#define MALI_TILER_JOB_SECTION_INSTANCE_COUNT_OFFSET 48
#define MALI_TILER_JOB_SECTION_VERTEX_COUNT_TYPE struct MALI_COUNT
#define MALI_TILER_JOB_SECTION_VERTEX_COUNT_PACKED_TYPE MALI_COUNT_PACKED_T
#define MALI_TILER_JOB_SECTION_VERTEX_COUNT_header MALI_COUNT_header
#define MALI_TILER_JOB_SECTION_VERTEX_COUNT_pack MALI_COUNT_pack
#define MALI_TILER_JOB_SECTION_VERTEX_COUNT_unpack MALI_COUNT_unpack
#define MALI_TILER_JOB_SECTION_VERTEX_COUNT_print MALI_COUNT_print
#define MALI_TILER_JOB_SECTION_VERTEX_COUNT_OFFSET 52
#define MALI_TILER_JOB_SECTION_TILER_TYPE struct MALI_TILER_POINTER
#define MALI_TILER_JOB_SECTION_TILER_PACKED_TYPE MALI_TILER_POINTER_PACKED_T
#define MALI_TILER_JOB_SECTION_TILER_header MALI_TILER_POINTER_header
#define MALI_TILER_JOB_SECTION_TILER_pack MALI_TILER_POINTER_pack
#define MALI_TILER_JOB_SECTION_TILER_unpack MALI_TILER_POINTER_unpack
#define MALI_TILER_JOB_SECTION_TILER_print MALI_TILER_POINTER_print
#define MALI_TILER_JOB_SECTION_TILER_OFFSET 56
#define MALI_TILER_JOB_SECTION_SCISSOR_TYPE struct MALI_SCISSOR
#define MALI_TILER_JOB_SECTION_SCISSOR_PACKED_TYPE MALI_SCISSOR_PACKED_T
#define MALI_TILER_JOB_SECTION_SCISSOR_header MALI_SCISSOR_header
#define MALI_TILER_JOB_SECTION_SCISSOR_pack MALI_SCISSOR_pack
#define MALI_TILER_JOB_SECTION_SCISSOR_unpack MALI_SCISSOR_unpack
#define MALI_TILER_JOB_SECTION_SCISSOR_print MALI_SCISSOR_print
#define MALI_TILER_JOB_SECTION_SCISSOR_OFFSET 104
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_TYPE struct MALI_PRIMITIVE_SIZE
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_PACKED_TYPE MALI_PRIMITIVE_SIZE_PACKED_T
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_header MALI_PRIMITIVE_SIZE_header
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_pack MALI_PRIMITIVE_SIZE_pack
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_unpack MALI_PRIMITIVE_SIZE_unpack
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_print MALI_PRIMITIVE_SIZE_print
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_OFFSET 112
#define MALI_TILER_JOB_SECTION_INDICES_TYPE struct MALI_INDICES
#define MALI_TILER_JOB_SECTION_INDICES_PACKED_TYPE MALI_INDICES_PACKED_T
#define MALI_TILER_JOB_SECTION_INDICES_header MALI_INDICES_header
#define MALI_TILER_JOB_SECTION_INDICES_pack MALI_INDICES_pack
#define MALI_TILER_JOB_SECTION_INDICES_unpack MALI_INDICES_unpack
#define MALI_TILER_JOB_SECTION_INDICES_print MALI_INDICES_print
#define MALI_TILER_JOB_SECTION_INDICES_OFFSET 120
#define MALI_TILER_JOB_SECTION_DRAW_TYPE struct MALI_DRAW
#define MALI_TILER_JOB_SECTION_DRAW_PACKED_TYPE MALI_DRAW_PACKED_T
#define MALI_TILER_JOB_SECTION_DRAW_header MALI_DRAW_header
#define MALI_TILER_JOB_SECTION_DRAW_pack MALI_DRAW_pack
#define MALI_TILER_JOB_SECTION_DRAW_unpack MALI_DRAW_unpack
#define MALI_TILER_JOB_SECTION_DRAW_print MALI_DRAW_print
#define MALI_TILER_JOB_SECTION_DRAW_OFFSET 128

#endif
