/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/**
 * Representing a Server configuration.
 */
#ifndef QOAI_SERVERVCONFIGURATION_H
#define QOAI_SERVERVCONFIGURATION_H

#include "openapicommoncommonexports.h"
#include "qoaiservervariable.h"

#include <QtCore/qcontainerfwd.h>
#include <QtCore/qshareddata.h>

QT_BEGIN_NAMESPACE
class QUrl;
QT_END_NAMESPACE

QT_BEGIN_NAMESPACE

namespace QtOpenApiCommon {

class QOAIServerConfigurationPrivate;

class QOAIServerConfiguration {
public:
    /**
     * @param urlTemplate A URL template to the target host.
     * @param description A description of the host designated by the URL.
     * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
     */
    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerConfiguration(const QString &urlTemplate, const QString &description,
                                  const QMap<QString, QOAIServerVariable> &variables);
    OPENAPICOMMON_COMMON_EXPORT QOAIServerConfiguration();
    OPENAPICOMMON_COMMON_EXPORT ~QOAIServerConfiguration();

    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerConfiguration(const QOAIServerConfiguration &other);
    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerConfiguration &operator=(const QOAIServerConfiguration &other);

    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerConfiguration(QOAIServerConfiguration &&other) noexcept;
    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerConfiguration &operator=(QOAIServerConfiguration &&other) noexcept;

    OPENAPICOMMON_COMMON_EXPORT void swap(QOAIServerConfiguration &other) noexcept;

    /**
    * Original URL template
    *
    * @return Original URL template.
    */
    OPENAPICOMMON_COMMON_EXPORT QString urlTemplate() const;

    /**
     * Format URL template using server's variables.
     *
     * @return URL, where the server variables are substituted with actual values.
     */
    OPENAPICOMMON_COMMON_EXPORT QUrl url() const;

    OPENAPICOMMON_COMMON_EXPORT QOAIServerVariable::ServerError
    setVariableValue(const QString &variable, const QString &value);

private:
    OPENAPICOMMON_COMMON_EXPORT friend bool
    comparesEqual(const QOAIServerConfiguration &lhs, const QOAIServerConfiguration &rhs) noexcept;

    friend bool
    operator==(const QOAIServerConfiguration &lhs, const QOAIServerConfiguration &rhs) noexcept
    { return comparesEqual(lhs, rhs); }
    friend bool
    operator!=(const QOAIServerConfiguration &lhs, const QOAIServerConfiguration &rhs) noexcept
    { return !comparesEqual(lhs, rhs); }

    friend size_t qHash(const QOAIServerConfiguration &value) = delete;
    friend size_t qHash(const QOAIServerConfiguration &value, size_t seed) = delete;

    QExplicitlySharedDataPointer<QOAIServerConfigurationPrivate> d_ptr;
};

} // namespace QtOpenApiCommon

QT_END_NAMESPACE

#endif // QOAI_SERVERVCONFIGURATION_H
