// services/video_effects/public/mojom/video_effects_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_effects/public/mojom/video_effects_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_effects/public/mojom/video_effects_service.mojom-params-data.h"
#include "services/video_effects/public/mojom/video_effects_service.mojom-shared-message-ids.h"

#include "services/video_effects/public/mojom/video_effects_service.mojom-import-headers.h"
#include "services/video_effects/public/mojom/video_effects_service.mojom-test-utils.h"


namespace video_effects::mojom {
const char VideoEffectsService::Name_[] = "video_effects.mojom.VideoEffectsService";

VideoEffectsService::IPCStableHashFunction VideoEffectsService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoEffectsService>(message.name())) {
    case messages::VideoEffectsService::kCreateEffectsProcessor: {
      return &VideoEffectsService::CreateEffectsProcessor_Sym::IPCStableHash;
    }
    case messages::VideoEffectsService::kSetBackgroundSegmentationModel: {
      return &VideoEffectsService::SetBackgroundSegmentationModel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoEffectsService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoEffectsService>(message.name())) {
      case messages::VideoEffectsService::kCreateEffectsProcessor:
            return "Receive video_effects::mojom::VideoEffectsService::CreateEffectsProcessor";
      case messages::VideoEffectsService::kSetBackgroundSegmentationModel:
            return "Receive video_effects::mojom::VideoEffectsService::SetBackgroundSegmentationModel";
    }
  } else {
    switch (static_cast<messages::VideoEffectsService>(message.name())) {
      case messages::VideoEffectsService::kCreateEffectsProcessor:
            return "Receive reply video_effects::mojom::VideoEffectsService::CreateEffectsProcessor";
      case messages::VideoEffectsService::kSetBackgroundSegmentationModel:
            return "Receive reply video_effects::mojom::VideoEffectsService::SetBackgroundSegmentationModel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoEffectsService::CreateEffectsProcessor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_effects::mojom::VideoEffectsService::CreateEffectsProcessor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEffectsService::SetBackgroundSegmentationModel_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_effects::mojom::VideoEffectsService::SetBackgroundSegmentationModel");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoEffectsServiceProxy::VideoEffectsServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoEffectsServiceProxy::CreateEffectsProcessor(
    const std::string& in_device_id, ::mojo::PendingRemote<::viz::mojom::Gpu> in_gpu, ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager> in_manager, ::mojo::PendingReceiver<::video_effects::mojom::VideoEffectsProcessor> in_processor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_effects::mojom::VideoEffectsService::CreateEffectsProcessor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu"), in_gpu,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::Gpu>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manager"), in_manager,
                        "<value of type ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("processor"), in_processor,
                        "<value of type ::mojo::PendingReceiver<::video_effects::mojom::VideoEffectsProcessor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEffectsService::kCreateEffectsProcessor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_effects::mojom::internal::VideoEffectsService_CreateEffectsProcessor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoEffectsService.CreateEffectsProcessor request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::GpuInterfaceBase>>(
      in_gpu, &params->gpu, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->gpu),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid gpu in VideoEffectsService.CreateEffectsProcessor request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::ReadonlyVideoEffectsManagerInterfaceBase>>(
      in_manager, &params->manager, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid manager in VideoEffectsService.CreateEffectsProcessor request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_effects::mojom::VideoEffectsProcessorInterfaceBase>>(
      in_processor, &params->processor, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->processor),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid processor in VideoEffectsService.CreateEffectsProcessor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEffectsService::Name_);
  message.set_method_name("CreateEffectsProcessor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEffectsServiceProxy::SetBackgroundSegmentationModel(
    ::base::File in_model_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_effects::mojom::VideoEffectsService::SetBackgroundSegmentationModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_file"), in_model_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEffectsService::kSetBackgroundSegmentationModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_effects::mojom::internal::VideoEffectsService_SetBackgroundSegmentationModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->model_file)::BaseType> model_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_model_file, model_file_fragment);
  params->model_file.Set(
      model_file_fragment.is_null() ? nullptr : model_file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEffectsService::Name_);
  message.set_method_name("SetBackgroundSegmentationModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoEffectsServiceStubDispatch::Accept(
    VideoEffectsService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoEffectsService>(message->header()->name)) {
    case messages::VideoEffectsService::kCreateEffectsProcessor: {
      DCHECK(message->is_serialized());
      internal::VideoEffectsService_CreateEffectsProcessor_Params_Data* params =
          reinterpret_cast<internal::VideoEffectsService_CreateEffectsProcessor_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VideoEffectsService.0
      bool success = true;
      std::string p_device_id{};
      ::mojo::PendingRemote<::viz::mojom::Gpu> p_gpu{};
      ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager> p_manager{};
      ::mojo::PendingReceiver<::video_effects::mojom::VideoEffectsProcessor> p_processor{};
      VideoEffectsService_CreateEffectsProcessor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success) {
        p_gpu =
            input_data_view.TakeGpu<decltype(p_gpu)>();
      }
      if (success) {
        p_manager =
            input_data_view.TakeManager<decltype(p_manager)>();
      }
      if (success) {
        p_processor =
            input_data_view.TakeProcessor<decltype(p_processor)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEffectsService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateEffectsProcessor(        
        std::move(p_device_id), 
        std::move(p_gpu), 
        std::move(p_manager), 
        std::move(p_processor));
      return true;
    }
    case messages::VideoEffectsService::kSetBackgroundSegmentationModel: {
      DCHECK(message->is_serialized());
      internal::VideoEffectsService_SetBackgroundSegmentationModel_Params_Data* params =
          reinterpret_cast<internal::VideoEffectsService_SetBackgroundSegmentationModel_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VideoEffectsService.1
      bool success = true;
      ::base::File p_model_file{};
      VideoEffectsService_SetBackgroundSegmentationModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModelFile(&p_model_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEffectsService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundSegmentationModel(        
        std::move(p_model_file));
      return true;
    }
  }
  return false;
}

// static
bool VideoEffectsServiceStubDispatch::AcceptWithResponder(
    VideoEffectsService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoEffectsService>(message->header()->name)) {
    case messages::VideoEffectsService::kCreateEffectsProcessor: {
      break;
    }
    case messages::VideoEffectsService::kSetBackgroundSegmentationModel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoEffectsServiceValidationInfo[] = {
    {base::to_underlying(messages::VideoEffectsService::kCreateEffectsProcessor),
     { &internal::VideoEffectsService_CreateEffectsProcessor_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoEffectsService::kSetBackgroundSegmentationModel),
     { &internal::VideoEffectsService_SetBackgroundSegmentationModel_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoEffectsServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_effects::mojom::VideoEffectsService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoEffectsServiceValidationInfo);
}



}  // video_effects::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace video_effects::mojom {


void VideoEffectsServiceInterceptorForTesting::CreateEffectsProcessor(const std::string& device_id, ::mojo::PendingRemote<::viz::mojom::Gpu> gpu, ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager> manager, ::mojo::PendingReceiver<::video_effects::mojom::VideoEffectsProcessor> processor) {
  GetForwardingInterface()->CreateEffectsProcessor(
    std::move(device_id)
    , 
    std::move(gpu)
    , 
    std::move(manager)
    , 
    std::move(processor)
    );
}
void VideoEffectsServiceInterceptorForTesting::SetBackgroundSegmentationModel(::base::File model_file) {
  GetForwardingInterface()->SetBackgroundSegmentationModel(
    std::move(model_file)
    );
}
VideoEffectsServiceAsyncWaiter::VideoEffectsServiceAsyncWaiter(
    VideoEffectsService* proxy) : proxy_(proxy) {}

VideoEffectsServiceAsyncWaiter::~VideoEffectsServiceAsyncWaiter() = default;






}  // video_effects::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif