// services/network/public/mojom/url_response_head.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_response_head.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_response_head.mojom-params-data.h"
#include "services/network/public/mojom/url_response_head.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_response_head.mojom-blink-import-headers.h"
#include "services/network/public/mojom/url_response_head.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
URLResponseHead::URLResponseHead()
    : request_time(),
      response_time(),
      original_response_time(),
      headers(),
      mime_type(),
      charset(),
      content_length(-1),
      encoded_data_length(-1),
      encoded_body_length(),
      network_accessed(false),
      load_timing(),
      emitted_extra_info(false),
      was_fetched_via_spdy(false),
      was_alpn_negotiated(false),
      was_alternate_protocol_available(false),
      connection_info(),
      alpn_negotiated_protocol(),
      alternate_protocol_usage(),
      remote_endpoint(),
      client_address_space(::network::mojom::blink::IPAddressSpace::kUnknown),
      response_address_space(::network::mojom::blink::IPAddressSpace::kUnknown),
      is_validated(false),
      was_fetched_via_cache(false),
      navigation_delivery_type(NavigationDeliveryType::kDefault),
      proxy_chain(),
      was_fetched_via_service_worker(false),
      service_worker_response_source(::network::mojom::blink::FetchResponseSource::kUnspecified),
      url_list_via_service_worker(),
      initial_service_worker_status(),
      service_worker_router_info(),
      response_type(::network::mojom::blink::FetchResponseType::kDefault),
      padding(0),
      cache_storage_cache_name(),
      cert_status(0U),
      ssl_info(),
      request_cookies(),
      cors_exposed_header_names(),
      did_service_worker_navigation_preload(false),
      async_revalidation_requested(false),
      did_mime_sniff(false),
      is_signed_exchange_inner_response(false),
      is_web_bundle_inner_response(false),
      was_in_prefetch_cache(false),
      is_prefetch_with_cross_site_contamination(false),
      was_cookie_in_request(false),
      intercepted_by_plugin(false),
      has_range_requested(false),
      timing_allow_passed(false),
      auth_challenge_info(),
      request_start(),
      response_start(),
      parsed_headers(),
      recursive_prefetch_token(),
      dns_aliases(),
      has_authorization_covered_by_wildcard_on_preflight(false),
      request_include_credentials(true),
      should_use_source_hash_for_js_code_cache(false),
      private_network_access_preflight_result(::network::mojom::blink::PrivateNetworkAccessPreflightResult::kNone),
      did_use_shared_dictionary(false),
      load_with_storage_access(false),
      bypass_redirect_checks(false) {}

URLResponseHead::URLResponseHead(
    ::base::Time request_time_in,
    ::base::Time response_time_in,
    ::base::Time original_response_time_in,
    ::network::mojom::blink::HttpResponseHeadersPtr headers_in,
    const WTF::String& mime_type_in,
    const WTF::String& charset_in,
    int64_t content_length_in,
    int64_t encoded_data_length_in,
    ::network::mojom::blink::EncodedBodyLengthPtr encoded_body_length_in,
    bool network_accessed_in,
    ::network::mojom::blink::LoadTimingInfoPtr load_timing_in,
    bool emitted_extra_info_in,
    bool was_fetched_via_spdy_in,
    bool was_alpn_negotiated_in,
    bool was_alternate_protocol_available_in,
    ::net::HttpConnectionInfo connection_info_in,
    const WTF::String& alpn_negotiated_protocol_in,
    ::net::AlternateProtocolUsage alternate_protocol_usage_in,
    const ::net::IPEndPoint& remote_endpoint_in,
    ::network::mojom::blink::IPAddressSpace client_address_space_in,
    ::network::mojom::blink::IPAddressSpace response_address_space_in,
    bool is_validated_in,
    bool was_fetched_via_cache_in,
    NavigationDeliveryType navigation_delivery_type_in,
    const ::net::ProxyChain& proxy_chain_in,
    bool was_fetched_via_service_worker_in,
    ::network::mojom::blink::FetchResponseSource service_worker_response_source_in,
    WTF::Vector<::blink::KURL> url_list_via_service_worker_in,
    std::optional<::network::mojom::blink::ServiceWorkerStatus> initial_service_worker_status_in,
    ::network::mojom::blink::ServiceWorkerRouterInfoPtr service_worker_router_info_in,
    ::network::mojom::blink::FetchResponseType response_type_in,
    int64_t padding_in,
    const WTF::String& cache_storage_cache_name_in,
    uint32_t cert_status_in,
    ::network::mojom::blink::SSLInfoPtr ssl_info_in,
    WTF::Vector<::net::cookie_util::ParsedRequestCookie> request_cookies_in,
    WTF::Vector<WTF::String> cors_exposed_header_names_in,
    bool did_service_worker_navigation_preload_in,
    bool async_revalidation_requested_in,
    bool did_mime_sniff_in,
    bool is_signed_exchange_inner_response_in,
    bool is_web_bundle_inner_response_in,
    bool was_in_prefetch_cache_in,
    bool is_prefetch_with_cross_site_contamination_in,
    bool was_cookie_in_request_in,
    bool intercepted_by_plugin_in,
    bool has_range_requested_in,
    bool timing_allow_passed_in,
    const std::optional<::net::AuthChallengeInfo>& auth_challenge_info_in,
    ::base::TimeTicks request_start_in,
    ::base::TimeTicks response_start_in,
    ::network::mojom::blink::ParsedHeadersPtr parsed_headers_in,
    const std::optional<::base::UnguessableToken>& recursive_prefetch_token_in,
    WTF::Vector<WTF::String> dns_aliases_in,
    bool has_authorization_covered_by_wildcard_on_preflight_in,
    bool request_include_credentials_in,
    bool should_use_source_hash_for_js_code_cache_in,
    ::network::mojom::blink::PrivateNetworkAccessPreflightResult private_network_access_preflight_result_in,
    bool did_use_shared_dictionary_in,
    bool load_with_storage_access_in,
    bool bypass_redirect_checks_in)
    : request_time(std::move(request_time_in)),
      response_time(std::move(response_time_in)),
      original_response_time(std::move(original_response_time_in)),
      headers(std::move(headers_in)),
      mime_type(std::move(mime_type_in)),
      charset(std::move(charset_in)),
      content_length(std::move(content_length_in)),
      encoded_data_length(std::move(encoded_data_length_in)),
      encoded_body_length(std::move(encoded_body_length_in)),
      network_accessed(std::move(network_accessed_in)),
      load_timing(std::move(load_timing_in)),
      emitted_extra_info(std::move(emitted_extra_info_in)),
      was_fetched_via_spdy(std::move(was_fetched_via_spdy_in)),
      was_alpn_negotiated(std::move(was_alpn_negotiated_in)),
      was_alternate_protocol_available(std::move(was_alternate_protocol_available_in)),
      connection_info(std::move(connection_info_in)),
      alpn_negotiated_protocol(std::move(alpn_negotiated_protocol_in)),
      alternate_protocol_usage(std::move(alternate_protocol_usage_in)),
      remote_endpoint(std::move(remote_endpoint_in)),
      client_address_space(std::move(client_address_space_in)),
      response_address_space(std::move(response_address_space_in)),
      is_validated(std::move(is_validated_in)),
      was_fetched_via_cache(std::move(was_fetched_via_cache_in)),
      navigation_delivery_type(std::move(navigation_delivery_type_in)),
      proxy_chain(std::move(proxy_chain_in)),
      was_fetched_via_service_worker(std::move(was_fetched_via_service_worker_in)),
      service_worker_response_source(std::move(service_worker_response_source_in)),
      url_list_via_service_worker(std::move(url_list_via_service_worker_in)),
      initial_service_worker_status(std::move(initial_service_worker_status_in)),
      service_worker_router_info(std::move(service_worker_router_info_in)),
      response_type(std::move(response_type_in)),
      padding(std::move(padding_in)),
      cache_storage_cache_name(std::move(cache_storage_cache_name_in)),
      cert_status(std::move(cert_status_in)),
      ssl_info(std::move(ssl_info_in)),
      request_cookies(std::move(request_cookies_in)),
      cors_exposed_header_names(std::move(cors_exposed_header_names_in)),
      did_service_worker_navigation_preload(std::move(did_service_worker_navigation_preload_in)),
      async_revalidation_requested(std::move(async_revalidation_requested_in)),
      did_mime_sniff(std::move(did_mime_sniff_in)),
      is_signed_exchange_inner_response(std::move(is_signed_exchange_inner_response_in)),
      is_web_bundle_inner_response(std::move(is_web_bundle_inner_response_in)),
      was_in_prefetch_cache(std::move(was_in_prefetch_cache_in)),
      is_prefetch_with_cross_site_contamination(std::move(is_prefetch_with_cross_site_contamination_in)),
      was_cookie_in_request(std::move(was_cookie_in_request_in)),
      intercepted_by_plugin(std::move(intercepted_by_plugin_in)),
      has_range_requested(std::move(has_range_requested_in)),
      timing_allow_passed(std::move(timing_allow_passed_in)),
      auth_challenge_info(std::move(auth_challenge_info_in)),
      request_start(std::move(request_start_in)),
      response_start(std::move(response_start_in)),
      parsed_headers(std::move(parsed_headers_in)),
      recursive_prefetch_token(std::move(recursive_prefetch_token_in)),
      dns_aliases(std::move(dns_aliases_in)),
      has_authorization_covered_by_wildcard_on_preflight(std::move(has_authorization_covered_by_wildcard_on_preflight_in)),
      request_include_credentials(std::move(request_include_credentials_in)),
      should_use_source_hash_for_js_code_cache(std::move(should_use_source_hash_for_js_code_cache_in)),
      private_network_access_preflight_result(std::move(private_network_access_preflight_result_in)),
      did_use_shared_dictionary(std::move(did_use_shared_dictionary_in)),
      load_with_storage_access(std::move(load_with_storage_access_in)),
      bypass_redirect_checks(std::move(bypass_redirect_checks_in)) {}

URLResponseHead::~URLResponseHead() = default;

void URLResponseHead::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_time"), this->request_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_time"), this->response_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_response_time"), this->original_response_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::HttpResponseHeadersPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "charset"), this->charset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_length"), this->content_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_data_length"), this->encoded_data_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_body_length"), this->encoded_body_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::EncodedBodyLengthPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_accessed"), this->network_accessed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_timing"), this->load_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::LoadTimingInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emitted_extra_info"), this->emitted_extra_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_fetched_via_spdy"), this->was_fetched_via_spdy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_alpn_negotiated"), this->was_alpn_negotiated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_alternate_protocol_available"), this->was_alternate_protocol_available,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_info"), this->connection_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::HttpConnectionInfo>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpn_negotiated_protocol"), this->alpn_negotiated_protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alternate_protocol_usage"), this->alternate_protocol_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::AlternateProtocolUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_endpoint"), this->remote_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPEndPoint&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_address_space"), this->client_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_address_space"), this->response_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_validated"), this->is_validated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_fetched_via_cache"), this->was_fetched_via_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_delivery_type"), this->navigation_delivery_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NavigationDeliveryType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_chain"), this->proxy_chain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyChain&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_fetched_via_service_worker"), this->was_fetched_via_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_response_source"), this->service_worker_response_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::FetchResponseSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_list_via_service_worker"), this->url_list_via_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_service_worker_status"), this->initial_service_worker_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::network::mojom::blink::ServiceWorkerStatus>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_router_info"), this->service_worker_router_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::ServiceWorkerRouterInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_type"), this->response_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::FetchResponseType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "padding"), this->padding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_storage_cache_name"), this->cache_storage_cache_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert_status"), this->cert_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ssl_info"), this->ssl_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::SSLInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_cookies"), this->request_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::net::cookie_util::ParsedRequestCookie>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_exposed_header_names"), this->cors_exposed_header_names,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "did_service_worker_navigation_preload"), this->did_service_worker_navigation_preload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "async_revalidation_requested"), this->async_revalidation_requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "did_mime_sniff"), this->did_mime_sniff,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_signed_exchange_inner_response"), this->is_signed_exchange_inner_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_web_bundle_inner_response"), this->is_web_bundle_inner_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_in_prefetch_cache"), this->was_in_prefetch_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_prefetch_with_cross_site_contamination"), this->is_prefetch_with_cross_site_contamination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_cookie_in_request"), this->was_cookie_in_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "intercepted_by_plugin"), this->intercepted_by_plugin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_range_requested"), this->has_range_requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_allow_passed"), this->timing_allow_passed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auth_challenge_info"), this->auth_challenge_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::AuthChallengeInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_start"), this->request_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_start"), this->response_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parsed_headers"), this->parsed_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::ParsedHeadersPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recursive_prefetch_token"), this->recursive_prefetch_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_aliases"), this->dns_aliases,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_authorization_covered_by_wildcard_on_preflight"), this->has_authorization_covered_by_wildcard_on_preflight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_include_credentials"), this->request_include_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_use_source_hash_for_js_code_cache"), this->should_use_source_hash_for_js_code_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_network_access_preflight_result"), this->private_network_access_preflight_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::PrivateNetworkAccessPreflightResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "did_use_shared_dictionary"), this->did_use_shared_dictionary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_with_storage_access"), this->load_with_storage_access,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bypass_redirect_checks"), this->bypass_redirect_checks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLResponseHead::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::URLResponseHead::DataView, ::network::mojom::blink::URLResponseHeadPtr>::Read(
    ::network::mojom::blink::URLResponseHead::DataView input,
    ::network::mojom::blink::URLResponseHeadPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLResponseHeadPtr result(::network::mojom::blink::URLResponseHead::New());
  
      if (success && !input.ReadRequestTime(&result->request_time))
        success = false;
      if (success && !input.ReadResponseTime(&result->response_time))
        success = false;
      if (success && !input.ReadOriginalResponseTime(&result->original_response_time))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadCharset(&result->charset))
        success = false;
      if (success)
        result->content_length = input.content_length();
      if (success)
        result->encoded_data_length = input.encoded_data_length();
      if (success && !input.ReadEncodedBodyLength(&result->encoded_body_length))
        success = false;
      if (success)
        result->network_accessed = input.network_accessed();
      if (success && !input.ReadLoadTiming(&result->load_timing))
        success = false;
      if (success)
        result->emitted_extra_info = input.emitted_extra_info();
      if (success)
        result->was_fetched_via_spdy = input.was_fetched_via_spdy();
      if (success)
        result->was_alpn_negotiated = input.was_alpn_negotiated();
      if (success)
        result->was_alternate_protocol_available = input.was_alternate_protocol_available();
      if (success && !input.ReadConnectionInfo(&result->connection_info))
        success = false;
      if (success && !input.ReadAlpnNegotiatedProtocol(&result->alpn_negotiated_protocol))
        success = false;
      if (success && !input.ReadAlternateProtocolUsage(&result->alternate_protocol_usage))
        success = false;
      if (success && !input.ReadRemoteEndpoint(&result->remote_endpoint))
        success = false;
      if (success && !input.ReadClientAddressSpace(&result->client_address_space))
        success = false;
      if (success && !input.ReadResponseAddressSpace(&result->response_address_space))
        success = false;
      if (success)
        result->is_validated = input.is_validated();
      if (success)
        result->was_fetched_via_cache = input.was_fetched_via_cache();
      if (success && !input.ReadNavigationDeliveryType(&result->navigation_delivery_type))
        success = false;
      if (success && !input.ReadProxyChain(&result->proxy_chain))
        success = false;
      if (success)
        result->was_fetched_via_service_worker = input.was_fetched_via_service_worker();
      if (success && !input.ReadServiceWorkerResponseSource(&result->service_worker_response_source))
        success = false;
      if (success && !input.ReadUrlListViaServiceWorker(&result->url_list_via_service_worker))
        success = false;
      if (success && !input.ReadInitialServiceWorkerStatus(&result->initial_service_worker_status)) {
        success = false;
      }
      if (success && !input.ReadServiceWorkerRouterInfo(&result->service_worker_router_info))
        success = false;
      if (success && !input.ReadResponseType(&result->response_type))
        success = false;
      if (success)
        result->padding = input.padding();
      if (success && !input.ReadCacheStorageCacheName(&result->cache_storage_cache_name))
        success = false;
      if (success)
        result->cert_status = input.cert_status();
      if (success && !input.ReadSslInfo(&result->ssl_info))
        success = false;
      if (success && !input.ReadRequestCookies(&result->request_cookies))
        success = false;
      if (success && !input.ReadCorsExposedHeaderNames(&result->cors_exposed_header_names))
        success = false;
      if (success)
        result->did_service_worker_navigation_preload = input.did_service_worker_navigation_preload();
      if (success)
        result->async_revalidation_requested = input.async_revalidation_requested();
      if (success)
        result->did_mime_sniff = input.did_mime_sniff();
      if (success)
        result->is_signed_exchange_inner_response = input.is_signed_exchange_inner_response();
      if (success)
        result->is_web_bundle_inner_response = input.is_web_bundle_inner_response();
      if (success)
        result->was_in_prefetch_cache = input.was_in_prefetch_cache();
      if (success)
        result->is_prefetch_with_cross_site_contamination = input.is_prefetch_with_cross_site_contamination();
      if (success)
        result->was_cookie_in_request = input.was_cookie_in_request();
      if (success)
        result->intercepted_by_plugin = input.intercepted_by_plugin();
      if (success)
        result->has_range_requested = input.has_range_requested();
      if (success)
        result->timing_allow_passed = input.timing_allow_passed();
      if (success && !input.ReadAuthChallengeInfo(&result->auth_challenge_info))
        success = false;
      if (success && !input.ReadRequestStart(&result->request_start))
        success = false;
      if (success && !input.ReadResponseStart(&result->response_start))
        success = false;
      if (success && !input.ReadParsedHeaders(&result->parsed_headers))
        success = false;
      if (success && !input.ReadRecursivePrefetchToken(&result->recursive_prefetch_token))
        success = false;
      if (success && !input.ReadDnsAliases(&result->dns_aliases))
        success = false;
      if (success)
        result->has_authorization_covered_by_wildcard_on_preflight = input.has_authorization_covered_by_wildcard_on_preflight();
      if (success)
        result->request_include_credentials = input.request_include_credentials();
      if (success)
        result->should_use_source_hash_for_js_code_cache = input.should_use_source_hash_for_js_code_cache();
      if (success && !input.ReadPrivateNetworkAccessPreflightResult(&result->private_network_access_preflight_result))
        success = false;
      if (success)
        result->did_use_shared_dictionary = input.did_use_shared_dictionary();
      if (success)
        result->load_with_storage_access = input.load_with_storage_access();
      if (success)
        result->bypass_redirect_checks = input.bypass_redirect_checks();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif