// qtwebengine/common/plugin.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "qtwebengine/common/plugin.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/common/plugin.mojom-params-data.h"
namespace qtwebengine {
namespace mojom {

NOINLINE static const char* PluginStatusToStringHelper(PluginStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PluginStatus::kAllowed:
      return "kAllowed";
    case PluginStatus::kBlocked:
      return "kBlocked";
    case PluginStatus::kBlockedByPolicy:
      return "kBlockedByPolicy";
    case PluginStatus::kDisabled:
      return "kDisabled";
    case PluginStatus::kNotFound:
      return "kNotFound";
    case PluginStatus::kPlayImportantContent:
      return "kPlayImportantContent";
    case PluginStatus::kUnauthorized:
      return "kUnauthorized";
    default:
      return nullptr;
  }
}

std::string PluginStatusToString(PluginStatus value) {
  const char *str = PluginStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PluginStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PluginStatus value) {
  return os << PluginStatusToString(value);
}

namespace internal {


// static
bool PluginInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PluginInfo_Data* object =
      static_cast<const PluginInfo_Data*>(data);


  if (!::qtwebengine::mojom::internal::PluginStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actual_mime_type, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& actual_mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->actual_mime_type, validation_context,
                                         &actual_mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_identifier, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_identifier_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_identifier, validation_context,
                                         &group_identifier_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_name, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_name, validation_context))
    return false;

  return true;
}

PluginInfo_Data::PluginInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PluginParam_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PluginParam_Data* object =
      static_cast<const PluginParam_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

PluginParam_Data::PluginParam_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PluginHost_OpenPDF_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PluginHost_OpenPDF_Params_Data* object =
      static_cast<const PluginHost_OpenPDF_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PluginHost_OpenPDF_Params_Data::PluginHost_OpenPDF_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data* object =
      static_cast<const PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data::PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PluginInfoHost_GetPluginInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PluginInfoHost_GetPluginInfo_Params_Data* object =
      static_cast<const PluginInfoHost_GetPluginInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  return true;
}

PluginInfoHost_GetPluginInfo_Params_Data::PluginInfoHost_GetPluginInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PluginInfoHost_GetPluginInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PluginInfoHost_GetPluginInfo_ResponseParams_Data* object =
      static_cast<const PluginInfoHost_GetPluginInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin_info, validation_context))
    return false;

  return true;
}

PluginInfoHost_GetPluginInfo_ResponseParams_Data::PluginInfoHost_GetPluginInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace qtwebengine

namespace perfetto {

// static
void TraceFormatTraits<::qtwebengine::mojom::PluginStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::qtwebengine::mojom::PluginStatus value) {
  return std::move(context).WriteString(::qtwebengine::mojom::PluginStatusToString(value));
}

} // namespace perfetto