/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "QtOAIHttpRequest.h"

#include <QtCore/qdatetime.h>
#include <QtCore/qdir.h>
#include <QtCore/qfileinfo.h>
#include <QtCore/qurl.h>
#include <QtCore/quuid.h>
#include <QtCore/QtGlobal>
#include <QtNetwork/qformdatabuilder.h>
#include <QtNetwork/qhttpmultipart.h>
#include <QtNetwork/qnetworkaccessmanager.h>
#include <QtNetwork/qnetworkrequestfactory.h>
#include <QtNetwork/qrestaccessmanager.h>

#include <zlib.h>

namespace QtCommonOpenAPI {

using namespace Qt::StringLiterals;

// Internal url encoding helper function
QString toFormUrlEncoding(const QString &input)
{
    // Space ( ) → replaced with +
    // Unsafe or non-alphanumeric characters → percent-encoded (%XX)
    // Alphanumeric characters (a–z, A–Z, 0–9) → left as-is
    // The following characters are always percent-encoded in x-www-form-urlencoded:
    // "!" / "$" / "&" / "'" / "(" / ")" / "*" / "+" / "," / ";" / "="
    return QString::fromUtf8(QUrl::toPercentEncoding(input).replace("%20", "+"));
}

QtOAIHttpRequestInput::QtOAIHttpRequestInput()
{
    initialize();
}

QtOAIHttpRequestInput::~QtOAIHttpRequestInput() = default;

QtOAIHttpRequestInput::QtOAIHttpRequestInput(const QString &vUrlStr, const QString &vHttpMethod)
{
    initialize();
    m_urlStr = vUrlStr;
    m_httpMethod = vHttpMethod;
}

void QtOAIHttpRequestInput::initialize()
{
    m_varLayout = NOT_SET;
    m_urlStr.clear();
    m_httpMethod = "GET"_L1;
    m_multiPart.reset();
    m_isFormData = false;
}

QtOAIHttpRequestInput::QtOAIHttpRequestInput(QtOAIHttpRequestInput &other)
{
    m_urlStr = other.m_urlStr;
    m_httpMethod = other.m_httpMethod;
    m_varLayout = other.m_varLayout;
    m_vars = other.m_vars;
    m_fieldHeaders = other.m_fieldHeaders;
    m_headers = other.m_headers;
    m_files = other.m_files;
    m_requestBody = other.m_requestBody;
    m_queryItem = other.m_queryItem;
    m_isFormData = other.m_isFormData;
}

void QtOAIHttpRequestInput::addVar(const QString &key, const QString &value)
{
    if (m_varLayout == URL_ENCODED)
        m_queryItem.addQueryItem(toFormUrlEncoding(key), toFormUrlEncoding(value));
    else
        m_vars[key] = value;
}

void QtOAIHttpRequestInput::addFieldHeaders(const QString &key, const QString &value)
{
    m_fieldHeaders[key] = value;
}

void QtOAIHttpRequestInput::addFile(const QString &variableName, const QString &localFilename, const QString &mimeType)
{
    QtOAIHttpFileElement file(localFilename);
    file.setVariableName(variableName);
    file.setMimeType(mimeType);
    m_files.append(file);
}

void QtOAIHttpRequestInput::addVarLayout(QtOAIHttpRequestVarLayout layout)
{
    m_varLayout = layout;
}

void QtOAIHttpRequestInput::setHeaders(const QHttpHeaders &newHeaders)
{
    m_headers = newHeaders;
}

void QtOAIHttpRequestInput::setFormData(bool isForm)
{
    m_isFormData = isForm;
}

namespace QtOAIHttpRequestWorker {

QtOAIHttpFileElement getHttpFileElement(const QMap<QString, QtOAIHttpFileElement> &files, const QString &fieldname)
{
    if (!files.isEmpty()) {
        if (fieldname.isEmpty()) {
            return files.first();
        } else if (files.contains(fieldname)) {
            return files[fieldname];
        }
    }
    return QtOAIHttpFileElement();
}

QByteArray *getMultiPartField(const QMap<QString, QByteArray *> &multiPartFields, const QString &fieldname)
{
    if (!multiPartFields.isEmpty()) {
        if (fieldname.isEmpty()) {
            return multiPartFields.first();
        } else if (multiPartFields.contains(fieldname)) {
            return multiPartFields[fieldname];
        }
    }
    return nullptr;
}

QNetworkRequest getNetworkRequest(QtOAIHttpRequestInput &input, QByteArray &requestContent, std::shared_ptr<QNetworkRequestFactory> factory, bool responseCompressionEnabled, bool requestCompressionEnabled)
{
    // reset variables
    requestContent = "";

    if (input.m_varLayout == NOT_SET) {
        input.m_varLayout = input.m_httpMethod == "GET"_L1 || input.m_httpMethod == "HEAD"_L1
                                ? ADDRESS : URL_ENCODED;
    }
    // prepare request content
    if (input.m_varLayout == ADDRESS || input.m_varLayout == URL_ENCODED) {
        // variable layout is ADDRESS or URL_ENCODED
        if (!input.m_queryItem.isEmpty()) {
            if (input.m_varLayout == ADDRESS) {
                input.m_urlStr += '?'_L1;
                input.m_urlStr += input.m_queryItem.toString(QUrl::FullyEncoded);
            } else {
                requestContent = input.m_queryItem.toString(QUrl::FullyEncoded).toUtf8();
            }
        }
    } else {
        QFormDataBuilder builder;
        // add variables
        for (const auto &[key, str] : input.m_vars.asKeyValueRange()) {
            auto part = builder.part(key);
            const QByteArray value = str.toUtf8();
            if (input.m_fieldHeaders.contains(key)) {
                part.setBody(value, QString(), input.m_fieldHeaders[key]);
            } else {
                part.setBody(value);
            }
        }

        // add files
        QList<QFile *> addedFiles;
        for (auto &fileInfo : input.m_files) {
            QFileInfo fi(fileInfo.filename());
            // ensure necessary variables are available
            if (fileInfo.filename().isEmpty()
                || fileInfo.variableName().isEmpty()
                || !fi.exists()
                || !fi.isFile()
                || !fi.isReadable()) {
                // silent abort for the current file
                continue;
            }
            auto file = std::make_unique<QFile>(fileInfo.filename());
            if (!file->open(QIODevice::ReadOnly)) {
                qWarning() << "Cannot open the file: " << fileInfo.filename();
                continue;
            }
            // ensure filename for the request
            if (fileInfo.requestFilename().isEmpty())
                fileInfo.requestFilename() = fi.fileName();
            auto part = builder.part(fileInfo.variableName());
            part.setBodyDevice(file.get(), fileInfo.filename(),
                               fileInfo.mimeType().isEmpty() ? u"application/octet-stream"_s
                                                             : fileInfo.mimeType());
            addedFiles.append(file.release());
        }
        // Build the multipart object
        input.m_multiPart = builder.buildMultiPart();
        // Need to take care about opened files
        for (QFile *file: std::as_const(addedFiles)) {
            if (file)
                file->setParent(input.m_multiPart.get()); // we cannot delete the file now, so delete it with the multiPart
        }
    }

    if (input.m_requestBody.size() > 0) {
        requestContent.clear();
        if (!input.m_isFormData && requestCompressionEnabled) {
            requestContent.append(compressData(input.m_requestBody, 7, QtOAICompressionType::Gzip));
        } else {
            requestContent.append(input.m_requestBody);
        }
    }
    QNetworkRequest request = factory->createRequest(input.m_urlStr);
    if (request.header(QNetworkRequest::UserAgentHeader).isNull())
        request.setHeader(QNetworkRequest::UserAgentHeader, QString::fromUtf8("OpenAPI-Generator/1.0.0/cpp-qt"));

    for (int i = 0; i < input.m_headers.size(); i++) {
        const auto name = input.m_headers.nameAt(i);
        const QByteArray headerName(name.data(), name.size());
        // Skipping "multipart/*" header. Multipart should have NOT a header,
        // but the header AND a boundary, like: Content-Type:
        // multipart/form-data; boundary=----exclusive7MA4YWxkTrZu0gW
        // Both are being set by buildMultiPart() call above.
        if (input.m_varLayout == MULTIPART
                && (headerName.compare("content-type", Qt::CaseInsensitive) == 0))
            continue;
        // Header can already be presented in the request and should not be overwritten here.
        if (!request.hasRawHeader(headerName)) {
            // 'Cookie' values cannot be combined by QHttpHeaders::combinedValue()
            // due to the fact that 'Cookie' are being divided by ';' naturally.
            // Prefer QHttpHeaders::values() instead.
            if (headerName.compare("Cookie", Qt::CaseInsensitive) == 0) {
                const QList<QByteArray> cookies = input.m_headers.values(headerName);
                QByteArray joinedCookies;
                for (const auto &value: cookies) {
                    if (!joinedCookies.isEmpty())
                        joinedCookies.append("; " + value);
                    else
                        joinedCookies = value;
                }
                if (joinedCookies.isEmpty())
                    qWarning() << "Setting an empty cookie value";
                request.setRawHeader(headerName, joinedCookies);
            } else {
                request.setRawHeader(headerName, input.m_headers.combinedValue(headerName));
            }
        } else {
            // rawHeader() return all values as a string separated by the delimiter,
            // that a user chose to use (can be ';' or ',' in our case).
            const QByteArray rawHeader = request.rawHeader(headerName);
            const auto headerValue = QByteArray(input.m_headers.valueAt(i));
            if (!rawHeader.contains(headerValue)) {
                if (headerName.compare("Cookie", Qt::CaseInsensitive) == 0)
                    request.setRawHeader(headerName, rawHeader + "; " + headerValue);
                else
                    request.setRawHeader(headerName, rawHeader + ", " + headerValue);
            }
        }
    }
    if (requestContent.size() > 0 && !input.m_isFormData) {
        if (requestCompressionEnabled) {
            request.setRawHeader("Content-Encoding", "gzip");
        }
    } else if (requestContent.size() <= 0 || input.m_varLayout == URL_ENCODED) {
        // Here is expected that:
        // 1) The Operation is a POST request. URL_ENCODED is being set only for POST.
        // 2) AND requestContent.size() <= 0 in case bodyParams/formParams are optional and empty.
        // 3) OR/AND requestContent.size() <= 0 because the Operation has only Operation Parameters.
        // 4) AND input.m_headers doesn't contain Content-Type.
        // Despite the fact, that Openapi SPEC doesn't require to set Content-Type
        // for the situation mentioned above, the Qt framework expects setting it for all
        // POST requests.
        // For more info see the Qt commit by sha 4f578d15fe2ef176f0533c7ff4aea99b17636f85
        // Using the message without Content-Type triggers the Qt warning.
        if (!input.m_headers.contains(QHttpHeaders::WellKnownHeader::ContentType)) {
            request.setHeader(QNetworkRequest::ContentTypeHeader,
                              "application/x-www-form-urlencoded"_L1);
        }
    }

    if (responseCompressionEnabled) {
        request.setRawHeader("Accept-Encoding", "gzip");
    } else {
        request.setRawHeader("Accept-Encoding", "identity");
    }
    return request;
}

static QtOAICompressionType encodingFormatToCompressionType(const QString &encodingFormat)
{
    if (encodingFormat.compare("identity"_L1, Qt::CaseInsensitive) == 0 || encodingFormat.isEmpty())
        return QtOAICompressionType::None;

    if (encodingFormat.compare("gzip"_L1, Qt::CaseInsensitive) == 0)
        return QtOAICompressionType::Gzip;

    if (encodingFormat.compare("deflate"_L1, Qt::CaseInsensitive) == 0)
        return QtOAICompressionType::Deflate;

    qWarning() << "Unsupported Content-Encoding:" << encodingFormat;
    return QtOAICompressionType::None;
}

QByteArray parseResponse(const QRestReply &reply, const QString &workDir, QMap<QString, QtOAIHttpFileElement> *files)
{
    QByteArray result;
    QString contentDispositionHdr;
    QString contentTypeHdr;
    QString contentEncodingHdr;

    if (!reply.networkReply())
        return result;

    QHttpHeaders headers;
    if (reply.networkReply()->rawHeaderPairs().count() > 0)
        headers = reply.networkReply()->headers();

    for (qsizetype i = 0; i < headers.size(); ++i) {
        const auto name = headers.nameAt(i);
        const auto value = headers.valueAt(i);
        if (name.compare("Content-Disposition"_L1, Qt::CaseInsensitive) == 0)
            contentDispositionHdr = QString::fromUtf8(value);
        else if (name.compare("Content-Type"_L1, Qt::CaseInsensitive) == 0)
            contentTypeHdr = QString::fromUtf8(value);
        else if (name.compare("Content-Encoding"_L1, Qt::CaseInsensitive) == 0)
            contentEncodingHdr = QString::fromUtf8(value);
    }

    // Read body first
    result = reply.networkReply()->readAll();

    // Decompress if needed
    if (!contentEncodingHdr.isEmpty()) {
        const auto encodings = contentEncodingHdr.split(u';', Qt::SkipEmptyParts).first()
                                                 .split(u',', Qt::SkipEmptyParts);
        for (auto it = encodings.rbegin(); it != encodings.rend(); ++it) {
            const QString encoding = it->trimmed();
            if (encoding.compare("identity"_L1, Qt::CaseInsensitive) == 0)
                continue;
            result = decompressData(result, encodingFormatToCompressionType(encoding));
        }
    }

    const auto contentType = !contentTypeHdr.isEmpty()
            ? contentTypeHdr.split(u';', Qt::SkipEmptyParts).first().trimmed().toLower()
            : QStringLiteral("");

    if (contentType == "multipart/form-data"_L1) {
        // TODO: Handle multipart responses
    } else if (files) {
        QString filename = QUuid::createUuid().toString(QUuid::WithoutBraces);
        const auto contentDisposition = contentDispositionHdr.split(u';', Qt::SkipEmptyParts);
        bool isAttachment = false;

        if (!contentDisposition.isEmpty()) {
            isAttachment = contentDisposition.first() == "attachment"_L1;
            for (const auto &file : contentDisposition) {
                if (file.contains("filename"_L1)) {
                    const auto parts = file.split(u'=', Qt::SkipEmptyParts);
                    if (parts.size() > 1) {
                        filename = parts.at(1);
                        // RFC says filename value may be quoted: remove the surrounding quotes
                        if (filename.startsWith(QString::fromUtf8("\"")) && filename.endsWith(QString::fromUtf8("\"")))
                            filename = filename.mid(1, filename.size() - 2);
                        // TODO in QTBUG-141443: - Sanitize the filename
                        //                       - Distinguish between filename= and filename*=
                        break;
                    }
                }
            }
        }

        QtOAIHttpFileElement felement(workDir + QDir::separator() + filename);
        felement.setMimeType(contentType);
        felement.setTemporary(!isAttachment);

        felement.saveToLocalFile(result);
        files->insert(filename, felement);
    }

    reply.networkReply()->deleteLater();
    return result;
}

static QByteArray decompressGzipOrDeflate(const QByteArray &data)
{
    static constexpr uInt MaxUInt = std::numeric_limits<uInt>::max();
    static constexpr int CHUNK_SIZE = 8*1024;

    qsizetype inputLeft = data.size();
    if (inputLeft <= 4)
        return {};

    QByteArray result;
    bool success = false;

    qsizetype offset = 0;
    while (inputLeft > 0) {
        // expand to quint64 to do the proper comparison
        uInt inputBlockSize = (quint64)inputLeft > (quint64)MaxUInt ? MaxUInt : uInt(inputLeft);

        success = false;

        z_stream strm{};
        strm.avail_in = inputBlockSize;
        strm.next_in = (Bytef*)(data.data() + offset);

        success = inflateInit2(&strm, 15 + 32) == Z_OK;
        if (!success)
            break;

        char out[CHUNK_SIZE];
        do {
            strm.avail_out = CHUNK_SIZE;
            strm.next_out = (Bytef*)(out);
            success = inflate(&strm, Z_NO_FLUSH) >= Z_OK; // can return Z_STREAM_END
            if (success)
                result.append(out, CHUNK_SIZE - (int)strm.avail_out);
        } while (strm.avail_out == 0);
        if (success)
            success = inflateEnd(&strm) == Z_OK;

        if (!success)
            break;

        offset += qsizetype(inputBlockSize);
        inputLeft -= qsizetype(inputBlockSize);
    }
    return success ? result : QByteArray();
}

QByteArray decompressData(const QByteArray &data, QtOAICompressionType compressionType)
{
    switch (compressionType) {
    case QtOAICompressionType::Gzip:
    case QtOAICompressionType::Deflate:
        return decompressGzipOrDeflate(data);
    case QtOAICompressionType::None:
    default:
        return data;
    }
}

QByteArray compressData(const QByteArray &input, int level, QtOAICompressionType compressionType)
{
    static constexpr int GZIP_WINDOW_BIT = 15 + 16;
    static constexpr int ZLIB_WINDOW_BIT = 15;
    static constexpr int CHUNK_SIZE = 8 * 1024;

    if (input.isEmpty())
        return {};

    int windowBits = 0;
    switch (compressionType) {
    case QtOAICompressionType::Gzip:
        windowBits = GZIP_WINDOW_BIT;
        break;
    case QtOAICompressionType::Deflate:
        windowBits = ZLIB_WINDOW_BIT;
        break;
    case QtOAICompressionType::None:
        return input;
    }

    z_stream strm{};

    if (deflateInit2(&strm, qMax(-1, qMin(9, level)), Z_DEFLATED,
                     windowBits, 8, Z_DEFAULT_STRATEGY) != Z_OK) {
        return {};
    }

    QByteArray output;
    auto input_data = input.data();
    qsizetype input_data_left = input.size();
    int flush = 0;
    bool hasError = false;
    do {
        qsizetype chunk_size = qMin((qsizetype)CHUNK_SIZE, input_data_left);
        strm.next_in = (unsigned char*)input_data;
        // fine to cast to uInt, since it's not larger than CHUNK_SIZE
        strm.avail_in = (uInt)chunk_size;
        input_data += chunk_size;
        input_data_left -= chunk_size;
        flush = (input_data_left <= 0 ? Z_FINISH : Z_NO_FLUSH);
        do {
            char out[CHUNK_SIZE];
            strm.next_out = (unsigned char*)out;
            strm.avail_out = (uInt)CHUNK_SIZE;
            hasError = deflate(&strm, flush) < Z_OK; // can return Z_STREAM_END
            if (hasError)
                break;
            // fine to truncate avail_out to int, because it cannot be
            // larger than CHUNK_SIZE
            const qsizetype processed = (CHUNK_SIZE - (int)strm.avail_out);
            if (processed > 0)
                output.append(out, processed);
        } while (strm.avail_out == 0);
    } while ((flush != Z_FINISH) && !hasError);
    deflateEnd(&strm);

    return output;
}
} // namespace QtOAIHttpRequestWorker



} // namespace QtCommonOpenAPI
