/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.Point;

public class Rect {
    public Point tl;
    public Point br;

    public Rect() {
        this.tl = new Point(0, 0);
        this.br = new Point(0, 0);
    }

    public Rect(Point point, Point point2) {
        this.tl = new Point(point.x, point.y);
        this.br = new Point(point2.x, point2.y);
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.tl = new Point(n, n2);
        this.br = new Point(n3, n4);
    }

    public final void setXYWH(int n, int n2, int n3, int n4) {
        this.tl.x = n;
        this.tl.y = n2;
        this.br.x = n + n3;
        this.br.y = n2 + n4;
    }

    public final Rect intersect(Rect rect) {
        Rect rect2 = new Rect();
        rect2.tl.x = Math.max(this.tl.x, rect.tl.x);
        rect2.tl.y = Math.max(this.tl.y, rect.tl.y);
        rect2.br.x = Math.max(Math.min(this.br.x, rect.br.x), rect2.tl.x);
        rect2.br.y = Math.max(Math.min(this.br.y, rect.br.y), rect2.tl.y);
        return rect2;
    }

    public final Rect union_boundary(Rect rect) {
        if (rect.is_empty()) {
            return this;
        }
        if (this.is_empty()) {
            return rect;
        }
        Rect rect2 = new Rect();
        rect2.tl.x = Math.min(this.tl.x, rect.tl.x);
        rect2.tl.y = Math.min(this.tl.y, rect.tl.y);
        rect2.br.x = Math.max(this.br.x, rect.br.x);
        rect2.br.y = Math.max(this.br.y, rect.br.y);
        return rect2;
    }

    public final Rect translate(Point point) {
        return new Rect(this.tl.translate(point), this.br.translate(point));
    }

    public final boolean equals(Rect rect) {
        return rect.tl.equals(this.tl) && rect.br.equals(this.br);
    }

    public final boolean is_empty() {
        return this.tl.x >= this.br.x || this.tl.y >= this.br.y;
    }

    public final void clear() {
        this.tl = new Point();
        this.br = new Point();
    }

    public final boolean enclosed_by(Rect rect) {
        return this.tl.x >= rect.tl.x && this.tl.y >= rect.tl.y && this.br.x <= rect.br.x && this.br.y <= rect.br.y;
    }

    public final boolean overlaps(Rect rect) {
        return this.tl.x < rect.br.x && this.tl.y < rect.br.y && this.br.x > rect.tl.x && this.br.y > rect.tl.y;
    }

    public final int area() {
        int n = (this.br.x - this.tl.x) * (this.br.y - this.tl.y);
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public final Point dimensions() {
        return new Point(this.width(), this.height());
    }

    public final int width() {
        return this.br.x - this.tl.x;
    }

    public final int height() {
        return this.br.y - this.tl.y;
    }

    public final boolean contains(Point point) {
        return this.tl.x <= point.x && this.tl.y <= point.y && this.br.x > point.x && this.br.y > point.y;
    }
}

