/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgRemoteCommandExecutor;

public class HgPushCommand {
    private final Project myProject;
    private final VirtualFile myRepo;
    private final String myDestination;
    private String myRevision;
    private boolean myForce;
    private String myBranchName;
    private String myBookmarkName;
    private boolean myIsNewBranch;

    public HgPushCommand(Project project, @NotNull VirtualFile repo, String destination) {
        if (repo == null) {
            HgPushCommand.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRepo = repo;
        this.myDestination = destination;
    }

    public void setRevision(String revision) {
        this.myRevision = revision;
    }

    public void setForce(boolean force) {
        this.myForce = force;
    }

    public void setBranchName(String branchName) {
        this.myBranchName = branchName;
    }

    public void setIsNewBranch(boolean isNewBranch) {
        this.myIsNewBranch = isNewBranch;
    }

    public void setBookmarkName(String bookmark) {
        this.myBookmarkName = bookmark;
    }

    public HgCommandResult executeInCurrentThread() {
        LinkedList<String> arguments = new LinkedList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.myRevision)) {
            arguments.add("-r");
            arguments.add(this.myRevision);
        }
        if (this.myBranchName != null) {
            arguments.add("-b");
            arguments.add(this.myBranchName);
        }
        if (this.myIsNewBranch) {
            arguments.add("--new-branch");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myBookmarkName)) {
            arguments.add("-B");
            arguments.add(this.myBookmarkName);
        }
        if (this.myForce) {
            arguments.add("-f");
        }
        arguments.add(this.myDestination);
        HgRemoteCommandExecutor executor = new HgRemoteCommandExecutor(this.myProject, this.myDestination);
        executor.setShowOutput(true);
        HgCommandResult result = executor.executeInCurrentThread(this.myRepo, "push", arguments);
        ((HgUpdater)BackgroundTaskUtil.syncPublisher((Project)this.myProject, HgVcs.REMOTE_TOPIC)).update(this.myProject, null);
        return result;
    }

    public VirtualFile getRepo() {
        return this.myRepo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgPushCommand", "<init>"));
    }
}

