/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.api2.JiraRestApi2;
import com.intellij.tasks.jira.rest.api20alpha1.JiraRestApi20Alpha1;
import com.intellij.tasks.jira.rest.api3.JiraRestApiCloud3;
import com.intellij.tasks.jira.soap.JiraLegacyApi;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JiraRemoteApi {
    protected final JiraRepository myRepository;

    protected JiraRemoteApi(@NotNull JiraRepository repository) {
        if (repository == null) {
            JiraRemoteApi.$$$reportNull$$$0(0);
        }
        this.myRepository = repository;
    }

    @NotNull
    public abstract List<Task> findTasks(@NotNull String var1, int var2) throws Exception;

    @Nullable
    public abstract Task findTask(@NotNull String var1) throws Exception;

    @NotNull
    public abstract Set<CustomTaskState> getAvailableTaskStates(@NotNull Task var1) throws Exception;

    public abstract void setTaskState(@NotNull Task var1, @NotNull CustomTaskState var2) throws Exception;

    public abstract void updateTimeSpend(@NotNull LocalTask var1, @NotNull String var2, String var3) throws Exception;

    public final String toString() {
        return "JiraRemoteApi(" + this.getType().getVersionName() + ")";
    }

    @NotNull
    public abstract ApiType getType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi", "<init>"));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ApiType {
        LEGACY("XML-RPC + RSS"){

            @Override
            @NotNull
            public JiraLegacyApi createApi(@NotNull JiraRepository repository) {
                if (repository == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new JiraLegacyApi(repository);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$1", "createApi"));
            }
        }
        ,
        REST_2_0("REST 2.0"){

            @Override
            @NotNull
            public JiraRestApi2 createApi(@NotNull JiraRepository repository) {
                if (repository == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new JiraRestApi2(repository);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$2", "createApi"));
            }
        }
        ,
        REST_2_0_ALPHA("REST 2.0.alpha1"){

            @Override
            @NotNull
            public JiraRestApi20Alpha1 createApi(@NotNull JiraRepository repository) {
                if (repository == null) {
                    3.$$$reportNull$$$0(0);
                }
                return new JiraRestApi20Alpha1(repository);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$3", "createApi"));
            }
        }
        ,
        REST_3_CLOUD("REST 3.0 Cloud"){

            @Override
            @NotNull
            public JiraRestApiCloud3 createApi(@NotNull JiraRepository repository) {
                if (repository == null) {
                    4.$$$reportNull$$$0(0);
                }
                return new JiraRestApiCloud3(repository);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$4", "createApi"));
            }
        };

        private final String myVersionName;

        private ApiType(String versionName) {
            this.myVersionName = versionName;
        }

        @NotNull
        public abstract JiraRemoteApi createApi(@NotNull JiraRepository var1);

        @NotNull
        public String getVersionName() {
            String string = this.myVersionName;
            if (string == null) {
                ApiType.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRemoteApi$ApiType", "getVersionName"));
        }
    }
}

