/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.LdapURL;
import org.ldaptive.LdapUtils;
import org.ldaptive.Operation;
import org.ldaptive.Response;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.referral.AbstractReferralHandler;
import org.ldaptive.referral.ReferralConnectionFactory;

public class SearchReferralHandler
extends AbstractReferralHandler<SearchRequest, SearchResult> {
    public SearchReferralHandler() {
        this(10, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public SearchReferralHandler(ReferralConnectionFactory factory) {
        this(10, 0, factory);
    }

    public SearchReferralHandler(int limit) {
        this(limit, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public SearchReferralHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 0, factory);
    }

    private SearchReferralHandler(int limit, int depth, ReferralConnectionFactory factory) {
        super(limit, depth, factory);
    }

    @Override
    protected SearchRequest createReferralRequest(SearchRequest request, LdapURL url) {
        SearchRequest referralRequest = new SearchRequest();
        referralRequest.setControls(request.getControls());
        referralRequest.setIntermediateResponseHandlers(request.getIntermediateResponseHandlers());
        referralRequest.setReferralHandler(new SearchReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory()));
        if (!url.getEntry().isDefaultBaseDn()) {
            referralRequest.setBaseDn(url.getEntry().getBaseDn());
        } else {
            referralRequest.setBaseDn(request.getBaseDn());
        }
        referralRequest.setBinaryAttributes(request.getBinaryAttributes());
        referralRequest.setDerefAliases(request.getDerefAliases());
        referralRequest.setSearchEntryHandlers(request.getSearchEntryHandlers());
        org.ldaptive.handler.SearchReferenceHandler[] searchReferenceHandlers = request.getSearchReferenceHandlers();
        if (searchReferenceHandlers != null) {
            for (int i = 0; i < searchReferenceHandlers.length; ++i) {
                if (!(searchReferenceHandlers[i] instanceof SearchReferenceHandler)) continue;
                SearchReferenceHandler handler = (SearchReferenceHandler)searchReferenceHandlers[i];
                searchReferenceHandlers[i] = new SearchReferenceHandler(handler.getReferralLimit(), handler.getReferralDepth() + 1, handler.getReferralConnectionFactory());
            }
        }
        referralRequest.setReturnAttributes(request.getReturnAttributes());
        if (!url.getEntry().isDefaultFilter()) {
            referralRequest.setSearchFilter(url.getEntry().getFilter());
        } else {
            referralRequest.setSearchFilter(request.getSearchFilter());
        }
        if (!url.getEntry().isDefaultScope()) {
            referralRequest.setSearchScope(url.getEntry().getScope());
        } else {
            referralRequest.setSearchScope(request.getSearchScope());
        }
        referralRequest.setSizeLimit(request.getSizeLimit());
        referralRequest.setSortBehavior(request.getSortBehavior());
        referralRequest.setTimeLimit(request.getTimeLimit());
        referralRequest.setTypesOnly(request.getTypesOnly());
        return referralRequest;
    }

    @Override
    protected Operation<SearchRequest, SearchResult> createReferralOperation(Connection conn) {
        return new SearchOperation(conn);
    }

    @Override
    public void initializeRequest(SearchRequest request) {
        if (request.getSearchReferenceHandlers() != null) {
            request.setSearchReferenceHandlers(LdapUtils.concatArrays(request.getSearchReferenceHandlers(), new org.ldaptive.handler.SearchReferenceHandler[][]{{new SearchReferenceHandler()}}));
        } else {
            request.setSearchReferenceHandlers(new SearchReferenceHandler());
        }
    }

    public static class SearchReferenceHandler
    implements org.ldaptive.handler.SearchReferenceHandler {
        private final int referralLimit;
        private final int referralDepth;
        private final ReferralConnectionFactory connectionFactory;

        public SearchReferenceHandler() {
            this(10, 0, AbstractReferralHandler.DEFAULT_CONNECTION_FACTORY);
        }

        public SearchReferenceHandler(ReferralConnectionFactory factory) {
            this(10, 0, factory);
        }

        public SearchReferenceHandler(int limit) {
            this(limit, 0, AbstractReferralHandler.DEFAULT_CONNECTION_FACTORY);
        }

        public SearchReferenceHandler(int limit, ReferralConnectionFactory factory) {
            this(limit, 0, factory);
        }

        private SearchReferenceHandler(int limit, int depth, ReferralConnectionFactory factory) {
            this.referralLimit = limit;
            this.referralDepth = depth;
            this.connectionFactory = factory;
        }

        public int getReferralLimit() {
            return this.referralLimit;
        }

        public int getReferralDepth() {
            return this.referralDepth;
        }

        public ReferralConnectionFactory getReferralConnectionFactory() {
            return this.connectionFactory;
        }

        @Override
        public HandlerResult<SearchReference> handle(Connection conn, SearchRequest request, SearchReference reference) throws LdapException {
            if (reference == null) {
                return new HandlerResult<Object>(null);
            }
            SearchReferralHandler handler = new SearchReferralHandler(this.referralLimit, this.referralDepth, this.connectionFactory);
            HandlerResult result = handler.handle(conn, request, reference.getReferralUrls());
            Response<SearchResult> response = result.getResult();
            if (response != null) {
                reference.setReferenceResponse(response);
            }
            return new HandlerResult<SearchReference>(reference);
        }

        @Override
        public void initializeRequest(SearchRequest request) {
        }
    }
}

