/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AlgorithmFinder;
import com.password4j.Argon2Function;
import com.password4j.BalloonHashingFunction;
import com.password4j.CompressedPBKDF2Function;
import com.password4j.HashBuilder;
import com.password4j.HashUpdater;
import com.password4j.HashingFunction;
import com.password4j.PBKDF2Function;
import com.password4j.PepperGenerator;
import com.password4j.ScryptFunction;
import com.password4j.Utils;

public class HashChecker {
    protected byte[] hashed;
    protected byte[] salt;
    private byte[] plainTextPassword;
    private CharSequence pepper;

    private HashChecker() {
    }

    HashChecker(CharSequence plainTextPassword, String hashed) {
        this.hashed = Utils.fromCharSequenceToBytes(hashed);
        this.plainTextPassword = Utils.fromCharSequenceToBytes(plainTextPassword);
    }

    HashChecker(byte[] plainTextPassword, byte[] hashed) {
        this.hashed = hashed;
        this.plainTextPassword = plainTextPassword;
    }

    public HashChecker addPepper(CharSequence pepper) {
        this.pepper = pepper;
        return this;
    }

    public HashChecker addPepper() {
        this.pepper = PepperGenerator.get();
        return this;
    }

    public HashChecker addSalt(String salt) {
        this.salt = Utils.fromCharSequenceToBytes(salt);
        return this;
    }

    public HashChecker addSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public HashUpdater andUpdate() {
        return new HashUpdater(this, new HashBuilder(this.plainTextPassword).addPepper(this.pepper).addSalt(this.salt));
    }

    public boolean with(HashingFunction hashingFunction) {
        if (this.plainTextPassword == null || this.plainTextPassword.length == 0) {
            return false;
        }
        return hashingFunction.check(this.plainTextPassword, this.hashed, this.salt, this.pepper);
    }

    public boolean withPBKDF2() {
        PBKDF2Function pbkdf2 = AlgorithmFinder.getPBKDF2Instance();
        return this.with(pbkdf2);
    }

    public boolean withCompressedPBKDF2() {
        CompressedPBKDF2Function pbkdf2 = AlgorithmFinder.getCompressedPBKDF2Instance();
        return this.with(pbkdf2);
    }

    public boolean withScrypt() {
        ScryptFunction scrypt = AlgorithmFinder.getScryptInstance();
        return this.with(scrypt);
    }

    public boolean withBcrypt() {
        return this.with(AlgorithmFinder.getBcryptInstance());
    }

    public boolean withMessageDigest() {
        return this.with(AlgorithmFinder.getMessageDigestInstance());
    }

    public boolean withArgon2() {
        Argon2Function argon2 = AlgorithmFinder.getArgon2Instance();
        return this.with(argon2);
    }

    public boolean withBalloonHashing() {
        BalloonHashingFunction balloon = AlgorithmFinder.getBalloonHashingInstance();
        return this.with(balloon);
    }

    protected String getHashed() {
        return Utils.fromBytesToString(this.hashed);
    }
}

