/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;

public class CreateAwsKmsRsaKeyringInput {
    private final ByteBuffer publicKey;
    private final String kmsKeyId;
    private final EncryptionAlgorithmSpec encryptionAlgorithm;
    private final KmsClient kmsClient;
    private final List<String> grantTokens;

    protected CreateAwsKmsRsaKeyringInput(BuilderImpl builder) {
        this.publicKey = builder.publicKey();
        this.kmsKeyId = builder.kmsKeyId();
        this.encryptionAlgorithm = builder.encryptionAlgorithm();
        this.kmsClient = builder.kmsClient();
        this.grantTokens = builder.grantTokens();
    }

    public ByteBuffer publicKey() {
        return this.publicKey;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public EncryptionAlgorithmSpec encryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public KmsClient kmsClient() {
        return this.kmsClient;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer publicKey;
        protected String kmsKeyId;
        protected EncryptionAlgorithmSpec encryptionAlgorithm;
        protected KmsClient kmsClient;
        protected List<String> grantTokens;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateAwsKmsRsaKeyringInput model) {
            this.publicKey = model.publicKey();
            this.kmsKeyId = model.kmsKeyId();
            this.encryptionAlgorithm = model.encryptionAlgorithm();
            this.kmsClient = model.kmsClient();
            this.grantTokens = model.grantTokens();
        }

        @Override
        public Builder publicKey(ByteBuffer publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public ByteBuffer publicKey() {
            return this.publicKey;
        }

        @Override
        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public String kmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public Builder encryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        @Override
        public EncryptionAlgorithmSpec encryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        @Override
        public Builder kmsClient(KmsClient kmsClient) {
            this.kmsClient = kmsClient;
            return this;
        }

        @Override
        public KmsClient kmsClient() {
            return this.kmsClient;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public CreateAwsKmsRsaKeyringInput build() {
            if (Objects.isNull(this.kmsKeyId())) {
                throw new IllegalArgumentException("Missing value for required field `kmsKeyId`");
            }
            if (Objects.isNull(this.encryptionAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionAlgorithm`");
            }
            return new CreateAwsKmsRsaKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder publicKey(ByteBuffer var1);

        public ByteBuffer publicKey();

        public Builder kmsKeyId(String var1);

        public String kmsKeyId();

        public Builder encryptionAlgorithm(EncryptionAlgorithmSpec var1);

        public EncryptionAlgorithmSpec encryptionAlgorithm();

        public Builder kmsClient(KmsClient var1);

        public KmsClient kmsClient();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public CreateAwsKmsRsaKeyringInput build();
    }
}

