/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore;

import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.keystore.KeyStore;
import software.amazon.cryptography.keystore.internaldafny.types.CreateKeyStoreOutput;
import software.amazon.cryptography.keystore.internaldafny.types.Discovery;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.Error_KeyStoreException;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.GetKeyStoreInfoOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.keystore.model.BeaconKeyMaterials;
import software.amazon.cryptography.keystore.model.BranchKeyMaterials;
import software.amazon.cryptography.keystore.model.CollectionOfErrors;
import software.amazon.cryptography.keystore.model.CreateKeyInput;
import software.amazon.cryptography.keystore.model.CreateKeyOutput;
import software.amazon.cryptography.keystore.model.CreateKeyStoreInput;
import software.amazon.cryptography.keystore.model.GetActiveBranchKeyInput;
import software.amazon.cryptography.keystore.model.GetBranchKeyVersionInput;
import software.amazon.cryptography.keystore.model.GetBranchKeyVersionOutput;
import software.amazon.cryptography.keystore.model.KeyStoreException;
import software.amazon.cryptography.keystore.model.MRDiscovery;
import software.amazon.cryptography.keystore.model.OpaqueError;
import software.amazon.cryptography.keystore.model.OpaqueWithTextError;
import software.amazon.cryptography.keystore.model.VersionKeyInput;
import software.amazon.cryptography.keystore.model.VersionKeyOutput;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class ToDafny {
    public static Error Error(RuntimeException nativeValue) {
        if (nativeValue instanceof KeyStoreException) {
            return ToDafny.Error((KeyStoreException)nativeValue);
        }
        if (nativeValue instanceof OpaqueError) {
            return ToDafny.Error((OpaqueError)nativeValue);
        }
        if (nativeValue instanceof OpaqueWithTextError) {
            return ToDafny.Error((OpaqueWithTextError)nativeValue);
        }
        if (nativeValue instanceof CollectionOfErrors) {
            return ToDafny.Error((CollectionOfErrors)nativeValue);
        }
        return Error.create_Opaque(nativeValue);
    }

    public static Error Error(OpaqueError nativeValue) {
        return Error.create_Opaque(nativeValue.obj());
    }

    public static Error Error(OpaqueWithTextError nativeValue) {
        return Error.create_OpaqueWithText(nativeValue.obj(), (DafnySequence<? extends Character>)DafnySequence.asString((String)nativeValue.objMessage()));
    }

    public static Error Error(CollectionOfErrors nativeValue) {
        DafnySequence list = ToDafny.Aggregate.GenericToSequence(nativeValue.list(), ToDafny::Error, Error._typeDescriptor());
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.getMessage());
        return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)list, (DafnySequence<? extends Character>)message);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials BeaconKeyMaterials(BeaconKeyMaterials nativeValue) {
        DafnySequence beaconKeyIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.beaconKeyIdentifier());
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        Option<DafnySequence<? extends Byte>> beaconKey = Objects.nonNull(nativeValue.beaconKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.beaconKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>> hmacKeys = Objects.nonNull(nativeValue.hmacKeys()) && nativeValue.hmacKeys().size() > 0 ? Option.create_Some(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), ToDafny.HmacKeyMap(nativeValue.hmacKeys())) : Option.create_None(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials((DafnySequence<? extends Character>)beaconKeyIdentifier, encryptionContext, beaconKey, hmacKeys);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials BranchKeyMaterials(BranchKeyMaterials nativeValue) {
        DafnySequence branchKeyIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyIdentifier());
        DafnySequence branchKeyVersion = ToDafny.Simple.DafnyUtf8Bytes((String)nativeValue.branchKeyVersion());
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        DafnySequence branchKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.branchKey());
        return new software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials((DafnySequence<? extends Character>)branchKeyIdentifier, (DafnySequence<? extends Byte>)branchKeyVersion, encryptionContext, (DafnySequence<? extends Byte>)branchKey);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.CreateKeyInput CreateKeyInput(CreateKeyInput nativeValue) {
        Option<DafnySequence<? extends Character>> branchKeyIdentifier = Objects.nonNull(nativeValue.branchKeyIdentifier()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyIdentifier())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> encryptionContext = Objects.nonNull(nativeValue.encryptionContext()) && nativeValue.encryptionContext().size() > 0 ? Option.create_Some(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), ToDafny.EncryptionContext(nativeValue.encryptionContext())) : Option.create_None(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new software.amazon.cryptography.keystore.internaldafny.types.CreateKeyInput(branchKeyIdentifier, encryptionContext);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.CreateKeyOutput CreateKeyOutput(CreateKeyOutput nativeValue) {
        DafnySequence branchKeyIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyIdentifier());
        return new software.amazon.cryptography.keystore.internaldafny.types.CreateKeyOutput((DafnySequence<? extends Character>)branchKeyIdentifier);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.CreateKeyStoreInput CreateKeyStoreInput(CreateKeyStoreInput nativeValue) {
        return new software.amazon.cryptography.keystore.internaldafny.types.CreateKeyStoreInput();
    }

    public static CreateKeyStoreOutput CreateKeyStoreOutput(software.amazon.cryptography.keystore.model.CreateKeyStoreOutput nativeValue) {
        DafnySequence tableArn = ToDafny.Simple.CharacterSequence((String)nativeValue.tableArn());
        return new CreateKeyStoreOutput((DafnySequence<? extends Character>)tableArn);
    }

    public static Discovery Discovery(software.amazon.cryptography.keystore.model.Discovery nativeValue) {
        return new Discovery();
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput GetActiveBranchKeyInput(GetActiveBranchKeyInput nativeValue) {
        DafnySequence branchKeyIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyIdentifier());
        return new software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput((DafnySequence<? extends Character>)branchKeyIdentifier);
    }

    public static GetActiveBranchKeyOutput GetActiveBranchKeyOutput(software.amazon.cryptography.keystore.model.GetActiveBranchKeyOutput nativeValue) {
        software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials branchKeyMaterials = ToDafny.BranchKeyMaterials(nativeValue.branchKeyMaterials());
        return new GetActiveBranchKeyOutput(branchKeyMaterials);
    }

    public static GetBeaconKeyInput GetBeaconKeyInput(software.amazon.cryptography.keystore.model.GetBeaconKeyInput nativeValue) {
        DafnySequence branchKeyIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyIdentifier());
        return new GetBeaconKeyInput((DafnySequence<? extends Character>)branchKeyIdentifier);
    }

    public static GetBeaconKeyOutput GetBeaconKeyOutput(software.amazon.cryptography.keystore.model.GetBeaconKeyOutput nativeValue) {
        software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials beaconKeyMaterials = ToDafny.BeaconKeyMaterials(nativeValue.beaconKeyMaterials());
        return new GetBeaconKeyOutput(beaconKeyMaterials);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput GetBranchKeyVersionInput(GetBranchKeyVersionInput nativeValue) {
        DafnySequence branchKeyIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyIdentifier());
        DafnySequence branchKeyVersion = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyVersion());
        return new software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput((DafnySequence<? extends Character>)branchKeyIdentifier, (DafnySequence<? extends Character>)branchKeyVersion);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput GetBranchKeyVersionOutput(GetBranchKeyVersionOutput nativeValue) {
        software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials branchKeyMaterials = ToDafny.BranchKeyMaterials(nativeValue.branchKeyMaterials());
        return new software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput(branchKeyMaterials);
    }

    public static GetKeyStoreInfoOutput GetKeyStoreInfoOutput(software.amazon.cryptography.keystore.model.GetKeyStoreInfoOutput nativeValue) {
        DafnySequence keyStoreId = ToDafny.Simple.CharacterSequence((String)nativeValue.keyStoreId());
        DafnySequence keyStoreName = ToDafny.Simple.CharacterSequence((String)nativeValue.keyStoreName());
        DafnySequence logicalKeyStoreName = ToDafny.Simple.CharacterSequence((String)nativeValue.logicalKeyStoreName());
        DafnySequence<? extends DafnySequence<? extends Character>> grantTokens = ToDafny.GrantTokenList(nativeValue.grantTokens());
        KMSConfiguration kmsConfiguration = ToDafny.KMSConfiguration(nativeValue.kmsConfiguration());
        return new GetKeyStoreInfoOutput((DafnySequence<? extends Character>)keyStoreId, (DafnySequence<? extends Character>)keyStoreName, (DafnySequence<? extends Character>)logicalKeyStoreName, grantTokens, kmsConfiguration);
    }

    public static KeyStoreConfig KeyStoreConfig(software.amazon.cryptography.keystore.model.KeyStoreConfig nativeValue) {
        DafnySequence ddbTableName = ToDafny.Simple.CharacterSequence((String)nativeValue.ddbTableName());
        KMSConfiguration kmsConfiguration = ToDafny.KMSConfiguration(nativeValue.kmsConfiguration());
        DafnySequence logicalKeyStoreName = ToDafny.Simple.CharacterSequence((String)nativeValue.logicalKeyStoreName());
        Option<DafnySequence<? extends Character>> id = Objects.nonNull(nativeValue.id()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), ToDafny.Simple.CharacterSequence((String)nativeValue.id())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        Option<IDynamoDBClient> ddbClient = Objects.nonNull(nativeValue.ddbClient()) ? Option.create_Some(TypeDescriptor.reference(IDynamoDBClient.class), software.amazon.cryptography.services.dynamodb.internaldafny.ToDafny.DynamoDB_20120810(nativeValue.ddbClient())) : Option.create_None(TypeDescriptor.reference(IDynamoDBClient.class));
        Option<IKMSClient> kmsClient = Objects.nonNull(nativeValue.kmsClient()) ? Option.create_Some(TypeDescriptor.reference(IKMSClient.class), software.amazon.cryptography.services.kms.internaldafny.ToDafny.TrentService(nativeValue.kmsClient())) : Option.create_None(TypeDescriptor.reference(IKMSClient.class));
        return new KeyStoreConfig((DafnySequence<? extends Character>)ddbTableName, kmsConfiguration, (DafnySequence<? extends Character>)logicalKeyStoreName, id, grantTokens, ddbClient, kmsClient);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.MRDiscovery MRDiscovery(MRDiscovery nativeValue) {
        DafnySequence region = ToDafny.Simple.CharacterSequence((String)nativeValue.region());
        return new software.amazon.cryptography.keystore.internaldafny.types.MRDiscovery((DafnySequence<? extends Character>)region);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.VersionKeyInput VersionKeyInput(VersionKeyInput nativeValue) {
        DafnySequence branchKeyIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyIdentifier());
        return new software.amazon.cryptography.keystore.internaldafny.types.VersionKeyInput((DafnySequence<? extends Character>)branchKeyIdentifier);
    }

    public static software.amazon.cryptography.keystore.internaldafny.types.VersionKeyOutput VersionKeyOutput(VersionKeyOutput nativeValue) {
        return new software.amazon.cryptography.keystore.internaldafny.types.VersionKeyOutput();
    }

    public static Error Error(KeyStoreException nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_KeyStoreException((DafnySequence<? extends Character>)message);
    }

    public static KMSConfiguration KMSConfiguration(software.amazon.cryptography.keystore.model.KMSConfiguration nativeValue) {
        if (Objects.nonNull(nativeValue.kmsKeyArn())) {
            return KMSConfiguration.create_kmsKeyArn((DafnySequence<? extends Character>)ToDafny.Simple.CharacterSequence((String)nativeValue.kmsKeyArn()));
        }
        if (Objects.nonNull(nativeValue.kmsMRKeyArn())) {
            return KMSConfiguration.create_kmsMRKeyArn((DafnySequence<? extends Character>)ToDafny.Simple.CharacterSequence((String)nativeValue.kmsMRKeyArn()));
        }
        if (Objects.nonNull(nativeValue.discovery())) {
            return KMSConfiguration.create_discovery(ToDafny.Discovery(nativeValue.discovery()));
        }
        if (Objects.nonNull(nativeValue.mrDiscovery())) {
            return KMSConfiguration.create_mrDiscovery(ToDafny.MRDiscovery(nativeValue.mrDiscovery()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration.");
    }

    public static DafnySequence<? extends DafnySequence<? extends Character>> GrantTokenList(List<String> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny.Simple::CharacterSequence, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
    }

    public static DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> EncryptionContext(Map<String, String> nativeValue) {
        return ToDafny.Aggregate.GenericToMap(nativeValue, ToDafny.Simple::DafnyUtf8Bytes, ToDafny.Simple::DafnyUtf8Bytes);
    }

    public static DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> HmacKeyMap(Map<String, ByteBuffer> nativeValue) {
        return ToDafny.Aggregate.GenericToMap(nativeValue, ToDafny.Simple::CharacterSequence, ToDafny.Simple::ByteSequence);
    }

    public static IKeyStoreClient KeyStore(KeyStore nativeValue) {
        return nativeValue.impl();
    }
}

