/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch._types.aggregations.MatrixStatsFields;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MatrixStatsAggregate
extends AggregateBase
implements AggregateVariant,
ToCopyableBuilder<Builder, MatrixStatsAggregate> {
    private final long docCount;
    @Nonnull
    private final List<MatrixStatsFields> fields;
    public static final JsonpDeserializer<MatrixStatsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatrixStatsAggregate::setupMatrixStatsAggregateDeserializer);

    private MatrixStatsAggregate(Builder builder) {
        super(builder);
        this.docCount = ApiTypeHelper.requireNonNull(builder.docCount, this, "docCount");
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
    }

    public static MatrixStatsAggregate of(Function<Builder, ObjectBuilder<MatrixStatsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.MatrixStats;
    }

    public final long docCount() {
        return this.docCount;
    }

    @Nonnull
    public final List<MatrixStatsFields> fields() {
        return this.fields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (MatrixStatsFields item0 : this.fields) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMatrixStatsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        MatrixStatsAggregate.setupAggregateBaseDeserializer(op);
        op.add(Builder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(MatrixStatsFields._DESERIALIZER), "fields");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.docCount);
        result = 31 * result + Objects.hashCode(this.fields);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatrixStatsAggregate other = (MatrixStatsAggregate)o;
        return this.docCount == other.docCount && Objects.equals(this.fields, other.fields);
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, MatrixStatsAggregate> {
        private Long docCount;
        @Nullable
        private List<MatrixStatsFields> fields;

        public Builder() {
        }

        private Builder(MatrixStatsAggregate o) {
            super(o);
            this.docCount = o.docCount;
            this.fields = Builder._listCopy(o.fields);
        }

        private Builder(Builder o) {
            super(o);
            this.docCount = o.docCount;
            this.fields = Builder._listCopy(o.fields);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder docCount(long value) {
            this.docCount = value;
            return this;
        }

        @Nonnull
        public final Builder fields(List<MatrixStatsFields> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @Nonnull
        public final Builder fields(MatrixStatsFields value, MatrixStatsFields ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Nonnull
        public final Builder fields(Function<MatrixStatsFields.Builder, ObjectBuilder<MatrixStatsFields>> fn) {
            return this.fields(fn.apply(new MatrixStatsFields.Builder()).build(), new MatrixStatsFields[0]);
        }

        @Override
        @Nonnull
        public MatrixStatsAggregate build() {
            this._checkSingleUse();
            return new MatrixStatsAggregate(this);
        }
    }
}

