/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.neuralsearch.sparse.NeuralSparseIndexShard;
import org.opensearch.neuralsearch.transport.NeuralSparseClearCacheRequest;
import org.opensearch.neuralsearch.transport.NeuralSparseClearCacheResponse;
import org.opensearch.transport.TransportService;

public class NeuralSparseClearCacheTransportAction
extends TransportBroadcastByNodeAction<NeuralSparseClearCacheRequest, NeuralSparseClearCacheResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private final IndicesService indicesService;

    @Inject
    public NeuralSparseClearCacheTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("cluster:admin/neural_sparse_clear_cache_action", clusterService, transportService, actionFilters, indexNameExpressionResolver, NeuralSparseClearCacheRequest::new, "seismic_thread_pool");
        this.indicesService = indicesService;
    }

    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput streamInput) {
        return TransportBroadcastByNodeAction.EmptyResult.readEmptyResultFrom((StreamInput)streamInput);
    }

    protected NeuralSparseClearCacheResponse newResponse(NeuralSparseClearCacheRequest request, int totalShards, int successfulShards, int failedShards, List<TransportBroadcastByNodeAction.EmptyResult> emptyResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new NeuralSparseClearCacheResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    protected NeuralSparseClearCacheRequest readRequestFrom(StreamInput streamInput) throws IOException {
        return new NeuralSparseClearCacheRequest(streamInput);
    }

    protected TransportBroadcastByNodeAction.EmptyResult shardOperation(NeuralSparseClearCacheRequest request, ShardRouting shardRouting) throws IOException {
        Index index = shardRouting.shardId().getIndex();
        IndexService indexService = this.indicesService.indexServiceSafe(index);
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        NeuralSparseIndexShard neuralSparseIndexShard = new NeuralSparseIndexShard(indexShard);
        neuralSparseIndexShard.clearCache();
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    protected ShardsIterator shards(ClusterState clusterState, NeuralSparseClearCacheRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState clusterState, NeuralSparseClearCacheRequest request) {
        return clusterState.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState clusterState, NeuralSparseClearCacheRequest request, String[] concreteIndices) {
        return clusterState.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }
}

