"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function defineRoutes(router, bannerSetup) {
  router.get({
    path: '/api/_plugins/_banner/content',
    validate: false
  }, async (context, request, response) => {
    // Get UI settings client
    const uiSettingsClient = context.core.uiSettings.client;
    const settings = await uiSettingsClient.getAll();

    // Extract banner settings from the result
    const content = settings['banner:content'];
    const color = settings['banner:color'];
    const iconType = settings['banner:iconType'];
    const isVisible = settings['banner:active'];
    const useMarkdown = settings['banner:useMarkdown'];
    const size = settings['banner:size'];

    // Combine UI settings with base config
    const config = {
      content,
      color: color,
      iconType,
      isVisible: Boolean(isVisible),
      useMarkdown: Boolean(useMarkdown),
      size: size
    };
    return response.ok({
      body: {
        content: config.content,
        color: config.color,
        iconType: config.iconType,
        isVisible: config.isVisible,
        useMarkdown: config.useMarkdown,
        size: config.size
      }
    });
  });
}