/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.script.Script;

@PublicApi(since="2.14.0")
public class DerivedField
implements Writeable,
ToXContentFragment {
    private final String name;
    private final String type;
    private final Script script;
    private String prefilterField;
    private Map<String, Object> properties;
    private Boolean ignoreMalformed;
    private String format;

    public DerivedField(String name, String type, Script script) {
        this.name = name;
        this.type = type;
        this.script = script;
    }

    public DerivedField(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.script = new Script(in);
        if (in.getVersion().onOrAfter(Version.V_2_15_0)) {
            if (in.readBoolean()) {
                this.properties = in.readMap();
            }
            this.prefilterField = in.readOptionalString();
            this.format = in.readOptionalString();
            this.ignoreMalformed = in.readOptionalBoolean();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        this.script.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_2_15_0)) {
            if (this.properties == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeMap(this.properties);
            }
            out.writeOptionalString(this.prefilterField);
            out.writeOptionalString(this.format);
            out.writeOptionalBoolean(this.ignoreMalformed);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("type", this.type);
        builder.field("script", (ToXContent)this.script);
        if (this.properties != null) {
            builder.field("properties", this.properties);
        }
        if (this.prefilterField != null) {
            builder.field("prefilter_field", this.prefilterField);
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        if (this.ignoreMalformed != null) {
            builder.field("ignore_malformed", this.ignoreMalformed);
        }
        builder.endObject();
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Script getScript() {
        return this.script;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getNestedFieldType(String fieldName) {
        if (this.properties == null || this.properties.isEmpty() || fieldName == null || fieldName.isEmpty()) {
            return null;
        }
        return (String)this.properties.get(fieldName);
    }

    public String getPrefilterField() {
        return this.prefilterField;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean getIgnoreMalformed() {
        return Boolean.TRUE.equals(this.ignoreMalformed);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setPrefilterField(String prefilterField) {
        this.prefilterField = prefilterField;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setIgnoreMalformed(boolean ignoreMalformed) {
        this.ignoreMalformed = ignoreMalformed;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.script, this.prefilterField, this.properties, this.ignoreMalformed, this.format);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DerivedField other = (DerivedField)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.script, other.script) && Objects.equals(this.prefilterField, other.prefilterField) && Objects.equals(this.properties, other.properties) && Objects.equals(this.ignoreMalformed, other.ignoreMalformed) && Objects.equals(this.format, other.format);
    }
}

